import{s as Mn,A as Tn,o as xn,n as _o}from"../chunks/scheduler.01eeda35.js";import{S as On,i as kn,g as i,s as n,r as m,A as jn,h as l,f as o,c as r,j as M,u as p,x as _,k as v,y as s,a,v as g,d as f,t as h,w as u}from"../chunks/index.6dd51b66.js";import{T as wn}from"../chunks/Tip.de9bae2b.js";import{D as k}from"../chunks/Docstring.cb556860.js";import{C as Gt}from"../chunks/CodeBlock.19ec9b8c.js";import{E as Wt}from"../chunks/ExampleCodeBlock.69db56ad.js";import{H as G,E as $n}from"../chunks/index.58fe8f9d.js";function In(U){let c,x="Examples:",b,y,F;return y=new Gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9uZUZvcm1lckNvbmZpZyUyQyUyME9uZUZvcm1lck1vZGVsJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyME9uZUZvcm1lciUyMHNoaS1sYWJzJTJGb25lZm9ybWVyX2FkZTIwa19zd2luX3RpbnklMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyME9uZUZvcm1lckNvbmZpZygpJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBzaGktbGFicyUyRm9uZWZvcm1lcl9hZGUyMGtfc3dpbl90aW55JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBPbmVGb3JtZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerConfig, OneFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a OneFormer shi-labs/oneformer_ade20k_swin_tiny configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = OneFormerConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the shi-labs/oneformer_ade20k_swin_tiny style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerModel(configuration)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=i("p"),c.textContent=x,b=n(),m(y.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),_(c)!=="svelte-kvfsh7"&&(c.textContent=x),b=r(d),p(y.$$.fragment,d)},m(d,w){a(d,c,w),a(d,b,w),g(y,d,w),F=!0},p:_o,i(d){F||(f(y.$$.fragment,d),F=!0)},o(d){h(y.$$.fragment,d),F=!1},d(d){d&&(o(c),o(b)),u(y,d)}}}function Un(U){let c,x=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=x},l(b){c=l(b,"P",{"data-svelte-h":!0}),_(c)!=="svelte-fincs2"&&(c.innerHTML=x)},m(b,y){a(b,c,y)},p:_o,d(b){b&&o(c)}}}function zn(U){let c,x="Example:",b,y,F;return y=new Gt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBPbmVGb3JtZXJQcm9jZXNzb3IlMkMlMjBPbmVGb3JtZXJNb2RlbCUwQSUwQSUyMyUyMGRvd25sb2FkJTIwdGV4dGluZyUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQSUyMyUyMGxvYWQlMjBwcm9jZXNzb3IlMjBmb3IlMjBwcmVwcm9jZXNzaW5nJTIwdGhlJTIwaW5wdXRzJTBBcHJvY2Vzc29yJTIwJTNEJTIwT25lRm9ybWVyUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJzaGktbGFicyUyRm9uZWZvcm1lcl9hZGUyMGtfc3dpbl90aW55JTIyKSUwQW1vZGVsJTIwJTNEJTIwT25lRm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnNoaS1sYWJzJTJGb25lZm9ybWVyX2FkZTIwa19zd2luX3RpbnklMjIpJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwJTVCJTIyc2VtYW50aWMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBbWFza19wcmVkaWN0aW9ucyUyMCUzRCUyMG91dHB1dHMudHJhbnNmb3JtZXJfZGVjb2Rlcl9tYXNrX3ByZWRpY3Rpb25zJTBBY2xhc3NfcHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLnRyYW5zZm9ybWVyX2RlY29kZXJfY2xhc3NfcHJlZGljdGlvbnMlMEElMEFmJTIyJUYwJTlGJTkxJTg5JTIwTWFzayUyMFByZWRpY3Rpb25zJTIwU2hhcGUlM0ElMjAlN0JsaXN0KG1hc2tfcHJlZGljdGlvbnMuc2hhcGUpJTdEJTJDJTIwQ2xhc3MlMjBQcmVkaWN0aW9ucyUyMFNoYXBlJTNBJTIwJTdCbGlzdChjbGFzc19wcmVkaWN0aW9ucy5zaGFwZSklN0QlMjI=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerProcessor, OneFormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># download texting image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load processor for preprocessing the inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = OneFormerProcessor.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerModel.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;semantic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>mask_predictions = outputs.transformer_decoder_mask_predictions
<span class="hljs-meta">&gt;&gt;&gt; </span>class_predictions = outputs.transformer_decoder_class_predictions

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Mask Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(mask_predictions.shape)}</span>, Class Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(class_predictions.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Mask Predictions Shape: [1, 150, 128, 171], Class Predictions Shape: [1, 150, 151]&#x27;</span>`,wrap:!1}}),{c(){c=i("p"),c.textContent=x,b=n(),m(y.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),_(c)!=="svelte-11lpom8"&&(c.textContent=x),b=r(d),p(y.$$.fragment,d)},m(d,w){a(d,c,w),a(d,b,w),g(y,d,w),F=!0},p:_o,i(d){F||(f(y.$$.fragment,d),F=!0)},o(d){h(y.$$.fragment,d),F=!1},d(d){d&&(o(c),o(b)),u(y,d)}}}function Cn(U){let c,x=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=x},l(b){c=l(b,"P",{"data-svelte-h":!0}),_(c)!=="svelte-fincs2"&&(c.innerHTML=x)},m(b,y){a(b,c,y)},p:_o,d(b){b&&o(c)}}}function Jn(U){let c,x="Universal segmentation example:",b,y,F;return y=new Gt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OneFormerProcessor, OneFormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load OneFormer fine-tuned on ADE20k for universal segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = OneFormerProcessor.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = OneFormerForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;shi-labs/oneformer_ade20k_swin_tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_ade20k/resolve/main/ADE_val_00000001.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Semantic Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;semantic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for semantic postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_semantic_map = processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Semantic Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_semantic_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Semantic Predictions Shape: [512, 683]&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Instance Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;instance&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for instance postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_instance_map = processor.post_process_instance_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Instance Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_instance_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Instance Predictions Shape: [512, 683]&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Panoptic Segmentation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, [<span class="hljs-string">&quot;panoptic&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can pass them to processor for panoptic postprocessing</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_panoptic_map = processor.post_process_panoptic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[(image.height, image.width)]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">f&quot;👉 Panoptic Predictions Shape: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(predicted_panoptic_map.shape)}</span>&quot;</span>
<span class="hljs-string">&#x27;👉 Panoptic Predictions Shape: [512, 683]&#x27;</span>`,wrap:!1}}),{c(){c=i("p"),c.textContent=x,b=n(),m(y.$$.fragment)},l(d){c=l(d,"P",{"data-svelte-h":!0}),_(c)!=="svelte-9x0o9r"&&(c.textContent=x),b=r(d),p(y.$$.fragment,d)},m(d,w){a(d,c,w),a(d,b,w),g(y,d,w),F=!0},p:_o,i(d){F||(f(y.$$.fragment,d),F=!0)},o(d){h(y.$$.fragment,d),F=!1},d(d){d&&(o(c),o(b)),u(y,d)}}}function Nn(U){let c,x,b,y,F,d,w,St='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',bo,te,yo,ne,Lt='The OneFormer model was proposed in <a href="https://arxiv.org/abs/2211.06220" rel="nofollow">OneFormer: One Transformer to Rule Universal Image Segmentation</a> by Jitesh Jain, Jiachen Li, MangTik Chiu, Ali Hassani, Nikita Orlov, Humphrey Shi. OneFormer is a universal image segmentation framework that can be trained on a single panoptic dataset to perform semantic, instance, and panoptic segmentation tasks. OneFormer uses a task token to condition the model on the task in focus, making the architecture task-guided for training, and task-dynamic for inference.',vo,re,Ht,Fo,se,Vt="The abstract from the paper is the following:",To,ae,Rt="<em>Universal Image Segmentation is not a new concept. Past attempts to unify image segmentation in the last decades include scene parsing, panoptic segmentation, and, more recently, new panoptic architectures. However, such panoptic architectures do not truly unify image segmentation because they need to be trained individually on the semantic, instance, or panoptic segmentation to achieve the best performance. Ideally, a truly universal framework should be trained only once and achieve SOTA performance across all three image segmentation tasks. To that end, we propose OneFormer, a universal image segmentation framework that unifies segmentation with a multi-task train-once design. We first propose a task-conditioned joint training strategy that enables training on ground truths of each domain (semantic, instance, and panoptic segmentation) within a single multi-task training process. Secondly, we introduce a task token to condition our model on the task at hand, making our model task-dynamic to support multi-task training and inference. Thirdly, we propose using a query-text contrastive loss during training to establish better inter-task and inter-class distinctions. Notably, our single OneFormer model outperforms specialized Mask2Former models across all three segmentation tasks on ADE20k, CityScapes, and COCO, despite the latter being trained on each of the three tasks individually with three times the resources. With new ConvNeXt and DiNAT backbones, we observe even more performance improvement. We believe OneFormer is a significant step towards making image segmentation more universal and accessible.</em>",wo,ie,Bt='The figure below illustrates the architecture of OneFormer. Taken from the <a href="https://arxiv.org/abs/2211.06220" rel="nofollow">original paper</a>.',Mo,le,Xt,xo,ce,Et='This model was contributed by <a href="https://huggingface.co/praeclarumjj3" rel="nofollow">Jitesh Jain</a>. The original code can be found <a href="https://github.com/SHI-Labs/OneFormer" rel="nofollow">here</a>.',Oo,de,ko,me,Dt=`<li>OneFormer requires two inputs during inference: <em>image</em> and <em>task token</em>.</li> <li>During training, OneFormer only uses panoptic annotations.</li> <li>If you want to train the model in a distributed environment across multiple nodes, then one should update the
<code>get_num_masks</code> function inside in the <code>OneFormerLoss</code> class of <code>modeling_oneformer.py</code>. When training on multiple nodes, this should be
set to the average number of target masks across all nodes, as can be seen in the original implementation <a href="https://github.com/SHI-Labs/OneFormer/blob/33ebb56ed34f970a30ae103e786c0cb64c653d9a/oneformer/modeling/criterion.py#L287" rel="nofollow">here</a>.</li> <li>One can use <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a> to prepare input images and task inputs for the model and optional targets for the model. <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a> wraps <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a> into a single instance to both prepare the images and encode the task inputs.</li> <li>To get the final segmentation, depending on the task, you can call <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a>. All three tasks can be solved using <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerForUniversalSegmentation">OneFormerForUniversalSegmentation</a> output, panoptic segmentation accepts an optional <code>label_ids_to_fuse</code> argument to fuse instances of the target object/s (e.g. sky) together.</li>`,jo,pe,$o,ge,Yt="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with OneFormer.",Io,fe,At='<li>Demo notebooks regarding inference + fine-tuning on custom data can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/OneFormer" rel="nofollow">here</a>.</li>',Uo,he,Qt=`If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we will review it.
The resource should ideally demonstrate something new instead of duplicating an existing resource.`,zo,ue,Co,S,_e,ot,Le,Kt='Class for outputs of <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a>. This class returns all the needed hidden states to compute the logits.',Jo,J,be,tt,He,en="Class for outputs of <code>OneFormerForUniversalSegmentationOutput</code>.",nt,Ve,on=`This output can be directly passed to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or
<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or
<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> depending on the task. Please, see
[\`~OneFormerImageProcessor] for details regarding usage.`,No,ye,Po,I,ve,rt,Re,tn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a>. It is used to instantiate a
OneFormer model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the OneFormer
<a href="https://huggingface.co/shi-labs/oneformer_ade20k_swin_tiny" rel="nofollow">shi-labs/oneformer_ade20k_swin_tiny</a> architecture
trained on <a href="https://huggingface.co/datasets/scene_parse_150" rel="nofollow">ADE20k-150</a>.`,st,Be,nn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,at,H,qo,Fe,Zo,T,Te,it,Xe,rn=`Constructs a OneFormer image processor. The image processor can be used to prepare image(s), task input(s) and
optional text inputs and targets for the model.`,lt,Ee,sn=`This image processor inherits from <a href="/docs/transformers/main/en/main_classes/image_processor#transformers.BaseImageProcessor">BaseImageProcessor</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,ct,De,we,dt,Z,Me,mt,Ye,an="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",pt,Ae,ln=`OneFormer addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,gt,V,xe,ft,Qe,cn=`Converts the output of <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,ht,R,Oe,ut,Ke,dn=`Converts the output of <code>OneFormerForUniversalSegmentationOutput</code> into image instance segmentation
predictions. Only supports PyTorch.`,_t,B,ke,bt,eo,mn=`Converts the output of <code>MaskFormerForInstanceSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,Wo,je,Go,j,$e,yt,oo,pn=`Constructs an OneFormer processor which wraps <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a> and
<a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer">CLIPTokenizer</a>/<a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizerFast">CLIPTokenizerFast</a> into a single processor that inherits both the image processor and
tokenizer functionalities.`,vt,X,Ie,Ft,to,gn=`This method forwards all its arguments to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.encode_inputs">OneFormerImageProcessor.encode_inputs()</a> and then tokenizes the
task_inputs. Please refer to the docstring of this method for more information.`,Tt,E,Ue,wt,no,fn=`This method forwards all its arguments to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_instance_segmentation">OneFormerImageProcessor.post_process_instance_segmentation()</a>.
Please refer to the docstring of this method for more information.`,Mt,D,ze,xt,ro,hn=`This method forwards all its arguments to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_panoptic_segmentation">OneFormerImageProcessor.post_process_panoptic_segmentation()</a>.
Please refer to the docstring of this method for more information.`,Ot,Y,Ce,kt,so,un=`This method forwards all its arguments to <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor.post_process_semantic_segmentation">OneFormerImageProcessor.post_process_semantic_segmentation()</a>.
Please refer to the docstring of this method for more information.`,So,Je,Lo,N,Ne,jt,ao,_n=`The bare OneFormer Model outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">nn.Module</a> sub-class. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,$t,z,Pe,It,io,bn='The <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerModel">OneFormerModel</a> forward method, overrides the <code>__call__</code> special method.',Ut,A,zt,Q,Ho,qe,Vo,P,Ze,Ct,lo,yn=`OneFormer Model for instance, semantic and panoptic image segmentation.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">nn.Module</a> sub-class. Use it as a
regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and behavior.`,Jt,$,We,Nt,co,vn='The <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerForUniversalSegmentation">OneFormerForUniversalSegmentation</a> forward method, overrides the <code>__call__</code> special method.',Pt,K,qt,mo,Fn="Example:",Zt,ee,Ro,Ge,Bo,ho,Xo;return F=new G({props:{title:"OneFormer",local:"oneformer",headingTag:"h1"}}),te=new G({props:{title:"Overview",local:"overview",headingTag:"h2"}}),de=new G({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),pe=new G({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ue=new G({props:{title:"OneFormer specific outputs",local:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",headingTag:"h2"}}),_e=new k({props:{name:"class transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput",parameters:[{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_object_queries",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_contrastive_queries",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_mask_predictions",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_class_predictions",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_auxiliary_predictions",val:": typing.Optional[typing.Tuple[typing.Dict[str, torch.FloatTensor]]] = None"},{name:"text_queries",val:": typing.Optional[torch.FloatTensor] = None"},{name:"task_token",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_object_queries",description:`<strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Output object queries from the last layer in the transformer decoder.`,name:"transformer_decoder_object_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_contrastive_queries",description:`<strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Contrastive queries from the transformer decoder.`,name:"transformer_decoder_contrastive_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_mask_predictions",description:`<strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_mask_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_class_predictions",description:`<strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) &#x2014;
Class Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_class_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.transformer_decoder_auxiliary_predictions",description:`<strong>transformer_decoder_auxiliary_predictions</strong> (Tuple of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Tuple of class and mask predictions from each layer of the transformer decoder.`,name:"transformer_decoder_auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.text_queries",description:`<strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Text queries derived from the input text list used for calculating contrastive loss during training.`,name:"text_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.task_token",description:`<strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>) &#x2014;
1D task token to condition the queries.`,name:"task_token"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L812"}}),be=new k({props:{name:"class transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput",anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"class_queries_logits",val:": typing.Optional[torch.FloatTensor] = None"},{name:"masks_queries_logits",val:": typing.Optional[torch.FloatTensor] = None"},{name:"auxiliary_predictions",val:": typing.List[typing.Dict[str, torch.FloatTensor]] = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_object_queries",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_contrastive_queries",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_mask_predictions",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_class_predictions",val:": typing.Optional[torch.FloatTensor] = None"},{name:"transformer_decoder_auxiliary_predictions",val:": typing.Optional[typing.List[typing.Dict[str, torch.FloatTensor]]] = None"},{name:"text_queries",val:": typing.Optional[torch.FloatTensor] = None"},{name:"task_token",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"}],parametersDescription:[{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The computed loss, returned when labels are present.`,name:"loss"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.class_queries_logits",description:`<strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.`,name:"class_queries_logits"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.`,name:"masks_queries_logits"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.auxiliary_predictions",description:`<strong>auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_object_queries",description:`<strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Output object queries from the last layer in the transformer decoder.`,name:"transformer_decoder_object_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_contrastive_queries",description:`<strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Contrastive queries from the transformer decoder.`,name:"transformer_decoder_contrastive_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_mask_predictions",description:`<strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_mask_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_class_predictions",description:`<strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) &#x2014;
Class Predictions from the last layer in the transformer decoder.`,name:"transformer_decoder_class_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.transformer_decoder_auxiliary_predictions",description:`<strong>transformer_decoder_auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"transformer_decoder_auxiliary_predictions"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.text_queries",description:`<strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>) &#x2014;
Text queries derived from the input text list used for calculating contrastive loss during training.`,name:"text_queries"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.task_token",description:`<strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>) &#x2014;
1D task token to condition the queries.`,name:"task_token"},{anchor:"transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L862"}}),ye=new G({props:{title:"OneFormerConfig",local:"transformers.OneFormerConfig",headingTag:"h2"}}),ve=new k({props:{name:"class transformers.OneFormerConfig",anchor:"transformers.OneFormerConfig",parameters:[{name:"backbone_config",val:": typing.Optional[typing.Dict] = None"},{name:"backbone",val:": typing.Optional[str] = None"},{name:"use_pretrained_backbone",val:": bool = False"},{name:"use_timm_backbone",val:": bool = False"},{name:"backbone_kwargs",val:": typing.Optional[typing.Dict] = None"},{name:"ignore_value",val:": int = 255"},{name:"num_queries",val:": int = 150"},{name:"no_object_weight",val:": int = 0.1"},{name:"class_weight",val:": float = 2.0"},{name:"mask_weight",val:": float = 5.0"},{name:"dice_weight",val:": float = 5.0"},{name:"contrastive_weight",val:": float = 0.5"},{name:"contrastive_temperature",val:": float = 0.07"},{name:"train_num_points",val:": int = 12544"},{name:"oversample_ratio",val:": float = 3.0"},{name:"importance_sample_ratio",val:": float = 0.75"},{name:"init_std",val:": float = 0.02"},{name:"init_xavier_std",val:": float = 1.0"},{name:"layer_norm_eps",val:": float = 1e-05"},{name:"is_training",val:": bool = False"},{name:"use_auxiliary_loss",val:": bool = True"},{name:"output_auxiliary_logits",val:": bool = True"},{name:"strides",val:": typing.Optional[list] = [4, 8, 16, 32]"},{name:"task_seq_len",val:": int = 77"},{name:"text_encoder_width",val:": int = 256"},{name:"text_encoder_context_length",val:": int = 77"},{name:"text_encoder_num_layers",val:": int = 6"},{name:"text_encoder_vocab_size",val:": int = 49408"},{name:"text_encoder_proj_layers",val:": int = 2"},{name:"text_encoder_n_ctx",val:": int = 16"},{name:"conv_dim",val:": int = 256"},{name:"mask_dim",val:": int = 256"},{name:"hidden_dim",val:": int = 256"},{name:"encoder_feedforward_dim",val:": int = 1024"},{name:"norm",val:": str = 'GN'"},{name:"encoder_layers",val:": int = 6"},{name:"decoder_layers",val:": int = 10"},{name:"use_task_norm",val:": bool = True"},{name:"num_attention_heads",val:": int = 8"},{name:"dropout",val:": float = 0.1"},{name:"dim_feedforward",val:": int = 2048"},{name:"pre_norm",val:": bool = False"},{name:"enforce_input_proj",val:": bool = False"},{name:"query_dec_layers",val:": int = 2"},{name:"common_stride",val:": int = 4"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code>, <em>optional</em>, defaults to <code>SwinConfig</code>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.OneFormerConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.OneFormerConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.OneFormerConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.OneFormerConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.OneFormerConfig.ignore_value",description:`<strong>ignore_value</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
Values to be ignored in GT label while calculating loss.`,name:"ignore_value"},{anchor:"transformers.OneFormerConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 150) &#x2014;
Number of object queries.`,name:"num_queries"},{anchor:"transformers.OneFormerConfig.no_object_weight",description:`<strong>no_object_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Weight for no-object class predictions.`,name:"no_object_weight"},{anchor:"transformers.OneFormerConfig.class_weight",description:`<strong>class_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Weight for Classification CE loss.`,name:"class_weight"},{anchor:"transformers.OneFormerConfig.mask_weight",description:`<strong>mask_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Weight for binary CE loss.`,name:"mask_weight"},{anchor:"transformers.OneFormerConfig.dice_weight",description:`<strong>dice_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Weight for dice loss.`,name:"dice_weight"},{anchor:"transformers.OneFormerConfig.contrastive_weight",description:`<strong>contrastive_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Weight for contrastive loss.`,name:"contrastive_weight"},{anchor:"transformers.OneFormerConfig.contrastive_temperature",description:`<strong>contrastive_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 0.07) &#x2014;
Initial value for scaling the contrastive logits.`,name:"contrastive_temperature"},{anchor:"transformers.OneFormerConfig.train_num_points",description:`<strong>train_num_points</strong> (<code>int</code>, <em>optional</em>, defaults to 12544) &#x2014;
Number of points to sample while calculating losses on mask predictions.`,name:"train_num_points"},{anchor:"transformers.OneFormerConfig.oversample_ratio",description:`<strong>oversample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
Ratio to decide how many points to oversample.`,name:"oversample_ratio"},{anchor:"transformers.OneFormerConfig.importance_sample_ratio",description:`<strong>importance_sample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.75) &#x2014;
Ratio of points that are sampled via importance sampling.`,name:"importance_sample_ratio"},{anchor:"transformers.OneFormerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
Standard deviation for normal intialization.`,name:"init_std"},{anchor:"transformers.OneFormerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Standard deviation for xavier uniform initialization.`,name:"init_xavier_std"},{anchor:"transformers.OneFormerConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
Epsilon for layer normalization.`,name:"layer_norm_eps"},{anchor:"transformers.OneFormerConfig.is_training",description:`<strong>is_training</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to run in training or inference mode.`,name:"is_training"},{anchor:"transformers.OneFormerConfig.use_auxiliary_loss",description:`<strong>use_auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to calculate loss using intermediate predictions from transformer decoder.`,name:"use_auxiliary_loss"},{anchor:"transformers.OneFormerConfig.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return intermediate predictions from transformer decoder.`,name:"output_auxiliary_logits"},{anchor:"transformers.OneFormerConfig.strides",description:`<strong>strides</strong> (<code>list</code>, <em>optional</em>, defaults to <code>[4, 8, 16, 32]</code>) &#x2014;
List containing the strides for feature maps in the encoder.`,name:"strides"},{anchor:"transformers.OneFormerConfig.task_seq_len",description:`<strong>task_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Sequence length for tokenizing text list input.`,name:"task_seq_len"},{anchor:"transformers.OneFormerConfig.text_encoder_width",description:`<strong>text_encoder_width</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Hidden size for text encoder.`,name:"text_encoder_width"},{anchor:"transformers.OneFormerConfig.text_encoder_context_length",description:`<strong>text_encoder_context_length</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Input sequence length for text encoder.`,name:"text_encoder_context_length"},{anchor:"transformers.OneFormerConfig.text_encoder_num_layers",description:`<strong>text_encoder_num_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers for transformer in text encoder.`,name:"text_encoder_num_layers"},{anchor:"transformers.OneFormerConfig.text_encoder_vocab_size",description:`<strong>text_encoder_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 49408) &#x2014;
Vocabulary size for tokenizer.`,name:"text_encoder_vocab_size"},{anchor:"transformers.OneFormerConfig.text_encoder_proj_layers",description:`<strong>text_encoder_proj_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of layers in MLP for project text queries.`,name:"text_encoder_proj_layers"},{anchor:"transformers.OneFormerConfig.text_encoder_n_ctx",description:`<strong>text_encoder_n_ctx</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of learnable text context queries.`,name:"text_encoder_n_ctx"},{anchor:"transformers.OneFormerConfig.conv_dim",description:`<strong>conv_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Feature map dimension to map outputs from the backbone.`,name:"conv_dim"},{anchor:"transformers.OneFormerConfig.mask_dim",description:`<strong>mask_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension for feature maps in pixel decoder.`,name:"mask_dim"},{anchor:"transformers.OneFormerConfig.hidden_dim",description:`<strong>hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension for hidden states in transformer decoder.`,name:"hidden_dim"},{anchor:"transformers.OneFormerConfig.encoder_feedforward_dim",description:`<strong>encoder_feedforward_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension for FFN layer in pixel decoder.`,name:"encoder_feedforward_dim"},{anchor:"transformers.OneFormerConfig.norm",description:`<strong>norm</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;GN&quot;</code>) &#x2014;
Type of normalization.`,name:"norm"},{anchor:"transformers.OneFormerConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers in pixel decoder.`,name:"encoder_layers"},{anchor:"transformers.OneFormerConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of layers in transformer decoder.`,name:"decoder_layers"},{anchor:"transformers.OneFormerConfig.use_task_norm",description:`<strong>use_task_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the task token.`,name:"use_task_norm"},{anchor:"transformers.OneFormerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads in transformer layers in the pixel and transformer decoders.`,name:"num_attention_heads"},{anchor:"transformers.OneFormerConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Dropout probability for pixel and transformer decoders.`,name:"dropout"},{anchor:"transformers.OneFormerConfig.dim_feedforward",description:`<strong>dim_feedforward</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension for FFN layer in transformer decoder.`,name:"dim_feedforward"},{anchor:"transformers.OneFormerConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize hidden states before attention layers in transformer decoder.`,name:"pre_norm"},{anchor:"transformers.OneFormerConfig.enforce_input_proj",description:`<strong>enforce_input_proj</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to project hidden states in transformer decoder.`,name:"enforce_input_proj"},{anchor:"transformers.OneFormerConfig.query_dec_layers",description:`<strong>query_dec_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Number of layers in query transformer.`,name:"query_dec_layers"},{anchor:"transformers.OneFormerConfig.common_stride",description:`<strong>common_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Common stride used for features in pixel decoder.`,name:"common_stride"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/configuration_oneformer.py#L28"}}),H=new Wt({props:{anchor:"transformers.OneFormerConfig.example",$$slots:{default:[In]},$$scope:{ctx:U}}}),Fe=new G({props:{title:"OneFormerImageProcessor",local:"transformers.OneFormerImageProcessor",headingTag:"h2"}}),Te=new k({props:{name:"class transformers.OneFormerImageProcessor",anchor:"transformers.OneFormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"repo_path",val:": typing.Optional[str] = 'shi-labs/oneformer_demo'"},{name:"class_info_file",val:": typing.Optional[str] = None"},{name:"num_text",val:": typing.Optional[int] = None"},{name:"num_labels",val:": typing.Optional[int] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.OneFormerImageProcessor.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>, defaults to 800) &#x2014;
Resize the input to the given size. Only has an effect if <code>do_resize</code> is set to <code>True</code>. If size is a
sequence like <code>(width, height)</code>, output size will be matched to this. If size is an int, smaller edge of
the image will be matched to this number. i.e, if <code>height &gt; width</code>, then image will be rescaled to <code>(size * height / width, size)</code>.`,name:"size"},{anchor:"transformers.OneFormerImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.Resampling.NEAREST</code>,
<code>PIL.Image.Resampling.BOX</code>, <code>PIL.Image.Resampling.BILINEAR</code>, <code>PIL.Image.Resampling.HAMMING</code>,
<code>PIL.Image.Resampling.BICUBIC</code> or <code>PIL.Image.Resampling.LANCZOS</code>. Only has an effect if <code>do_resize</code> is set
to <code>True</code>.`,name:"resample"},{anchor:"transformers.OneFormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the input to a certain <code>scale</code>.`,name:"do_rescale"},{anchor:"transformers.OneFormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1/ 255</code>) &#x2014;
Rescale the input by the given factor. Only has an effect if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.OneFormerImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.OneFormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images. Defaults to the ImageNet mean.`,name:"image_mean"},{anchor:"transformers.OneFormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images. Defaults to the
ImageNet std.`,name:"image_std"},{anchor:"transformers.OneFormerImageProcessor.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Label to be assigned to background pixels in segmentation maps. If provided, segmentation map pixels
denoted with 0 (background) will be replaced with <code>ignore_index</code>.`,name:"ignore_index"},{anchor:"transformers.OneFormerImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decrement all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k).
The background label will be replaced by <code>ignore_index</code>.`,name:"do_reduce_labels"},{anchor:"transformers.OneFormerImageProcessor.repo_path",description:`<strong>repo_path</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;shi-labs/oneformer_demo&quot;</code>) &#x2014;
Path to hub repo or local directory containing the JSON file with class information for the dataset.
If unset, will look for <code>class_info_file</code> in the current working directory.`,name:"repo_path"},{anchor:"transformers.OneFormerImageProcessor.class_info_file",description:`<strong>class_info_file</strong> (<code>str</code>, <em>optional</em>) &#x2014;
JSON file containing class information for the dataset. See <code>shi-labs/oneformer_demo/cityscapes_panoptic.json</code> for an example.`,name:"class_info_file"},{anchor:"transformers.OneFormerImageProcessor.num_text",description:`<strong>num_text</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of text entries in the text input list.`,name:"num_text"},{anchor:"transformers.OneFormerImageProcessor.num_labels",description:`<strong>num_labels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of labels in the segmentation map.`,name:"num_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L375"}}),we=new k({props:{name:"preprocess",anchor:"transformers.OneFormerImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"task_inputs",val:": typing.Optional[typing.List[str]] = None"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor'], NoneType] = None"},{name:"instance_id_to_semantic_id",val:": typing.Optional[typing.Dict[int, int]] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L678"}}),Me=new k({props:{name:"encode_inputs",anchor:"transformers.OneFormerImageProcessor.encode_inputs",parameters:[{name:"pixel_values_list",val:": typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]]"},{name:"task_inputs",val:": typing.List[str]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.List[typing.Dict[int, int]], typing.Dict[int, int], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.task_inputs",description:`<strong>task_inputs</strong> (<code>List[str]</code>) &#x2014;
List of task values.`,name:"task_inputs"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/main/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"},{anchor:"transformers.OneFormerImageProcessor.encode_inputs.input_data_format",description:`<strong>input_data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred from the input
image.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L960",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
<li><strong>text_inputs</strong> — Optional list of text string entries to be fed to a model (when <code>annotations</code> are
provided). They identify the binary masks present in the image.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/feature_extractor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),xe=new k({props:{name:"post_process_semantic_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L1095",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),Oe=new k({props:{name:"post_process_instance_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"task_type",val:": str = 'instance'"},{name:"is_demo",val:": bool = True"},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<code>OneFormerForUniversalSegmentationOutput</code>) &#x2014;
The outputs from <code>OneFormerForUniversalSegmentationOutput</code>.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.task_type",description:`<strong>task_type</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;instance&#x201D;) &#x2014;
The post processing depends on the task token input. If the <code>task_type</code> is &#x201C;panoptic&#x201D;, we need to
ignore the stuff predictions.`,name:"task_type"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.is_demo",description:`<strong>is_demo</strong> (<code>bool</code>, <em>optional)</em>, defaults to <code>True</code>) &#x2014;
Whether the model is in demo mode. If true, use threshold to predict final masks.`,name:"is_demo"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"},{anchor:"transformers.OneFormerImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional)</em>, defaults to <code>False</code>) &#x2014;
Whether to return predictions in COCO format.`,name:"return_coco_annotation"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L1145",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ke=new k({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Optional[typing.List[typing.Tuple[int, int]]] = None"}],parametersDescription:[{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>MaskFormerForInstanceSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/main/en/model_doc/maskformer#transformers.MaskFormerForInstanceSegmentation">MaskFormerForInstanceSegmentation</a>.`,name:"outputs"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.OneFormerImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/image_processing_oneformer.py#L1265",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),je=new G({props:{title:"OneFormerProcessor",local:"transformers.OneFormerProcessor",headingTag:"h2"}}),$e=new k({props:{name:"class transformers.OneFormerProcessor",anchor:"transformers.OneFormerProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"max_seq_length",val:": int = 77"},{name:"task_seq_length",val:": int = 77"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.OneFormerProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerImageProcessor">OneFormerImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.OneFormerProcessor.tokenizer",description:`<strong>tokenizer</strong> ([<code>CLIPTokenizer</code>, <code>CLIPTokenizerFast</code>]) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.OneFormerProcessor.max_seq_len",description:`<strong>max_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77)) &#x2014;
Sequence length for input text list.`,name:"max_seq_len"},{anchor:"transformers.OneFormerProcessor.task_seq_len",description:`<strong>task_seq_len</strong> (<code>int</code>, <em>optional</em>, defaults to 77) &#x2014;
Sequence length for input task token.`,name:"task_seq_len"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L29"}}),Ie=new k({props:{name:"encode_inputs",anchor:"transformers.OneFormerProcessor.encode_inputs",parameters:[{name:"images",val:" = None"},{name:"task_inputs",val:" = None"},{name:"segmentation_maps",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L145"}}),Ue=new k({props:{name:"post_process_instance_segmentation",anchor:"transformers.OneFormerProcessor.post_process_instance_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L192"}}),ze=new k({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.OneFormerProcessor.post_process_panoptic_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L199"}}),Ce=new k({props:{name:"post_process_semantic_segmentation",anchor:"transformers.OneFormerProcessor.post_process_semantic_segmentation",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/processing_oneformer.py#L185"}}),Je=new G({props:{title:"OneFormerModel",local:"transformers.OneFormerModel",headingTag:"h2"}}),Ne=new k({props:{name:"class transformers.OneFormerModel",anchor:"transformers.OneFormerModel",parameters:[{name:"config",val:": OneFormerConfig"}],parametersDescription:[{anchor:"transformers.OneFormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L2906"}}),Pe=new k({props:{name:"forward",anchor:"transformers.OneFormerModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"task_inputs",val:": Tensor"},{name:"text_inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.OneFormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a>. See
<code>OneFormerProcessor.__call__()</code> for details.`,name:"pixel_values"},{anchor:"transformers.OneFormerModel.forward.task_inputs",description:`<strong>task_inputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Task inputs. Task inputs can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <code>OneFormerProcessor.__call__()</code>
for details.`,name:"task_inputs"},{anchor:"transformers.OneFormerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.OneFormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OneFormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.OneFormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~OneFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L2927",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerConfig"
>OneFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Output object queries from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Contrastive queries from the transformer decoder.</li>
<li><strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) — Class Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_auxiliary_predictions</strong> (Tuple of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — Tuple of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Text queries derived from the input text list used for calculating contrastive loss during training.</li>
<li><strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>)
1D task token to condition the queries.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
<p><code>OneFormerModelOutput</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new wn({props:{$$slots:{default:[Un]},$$scope:{ctx:U}}}),Q=new Wt({props:{anchor:"transformers.OneFormerModel.forward.example",$$slots:{default:[zn]},$$scope:{ctx:U}}}),qe=new G({props:{title:"OneFormerForUniversalSegmentation",local:"transformers.OneFormerForUniversalSegmentation",headingTag:"h2"}}),Ze=new k({props:{name:"class transformers.OneFormerForUniversalSegmentation",anchor:"transformers.OneFormerForUniversalSegmentation",parameters:[{name:"config",val:": OneFormerConfig"}],parametersDescription:[{anchor:"transformers.OneFormerForUniversalSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerConfig">OneFormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L3035"}}),We=new k({props:{name:"forward",anchor:"transformers.OneFormerForUniversalSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"task_inputs",val:": Tensor"},{name:"text_inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"mask_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"class_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.OneFormerForUniversalSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerProcessor">OneFormerProcessor</a>. See
<code>OneFormerProcessor.__call__()</code> for details.`,name:"pixel_values"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.task_inputs",description:`<strong>task_inputs</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Task inputs. Task inputs can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <code>OneFormerProcessor.__call__()</code>
for details.`,name:"task_inputs"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~OneFormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.text_inputs",description:`<strong>text_inputs</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
Tensor fof shape <code>(num_queries, sequence_length)</code> to be fed to a model`,name:"text_inputs"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.mask_labels",description:`<strong>mask_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of mask labels of shape <code>(num_labels, height, width)</code> to be fed to a model`,name:"mask_labels"},{anchor:"transformers.OneFormerForUniversalSegmentation.forward.class_labels",description:`<strong>class_labels</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
list of target class labels of shape <code>(num_labels, height, width)</code> to be fed to a model. They identify the
labels of <code>mask_labels</code>, e.g. the label of <code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.`,name:"class_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/oneformer/modeling_oneformer.py#L3106",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.OneFormerConfig"
>OneFormerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) — The computed loss, returned when labels are present.</li>
<li><strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.</li>
<li><strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.</li>
<li><strong>auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>transformer_decoder_object_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Output object queries from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_contrastive_queries</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Contrastive queries from the transformer decoder.</li>
<li><strong>transformer_decoder_mask_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_class_predictions</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes+1)</code>) — Class Predictions from the last layer in the transformer decoder.</li>
<li><strong>transformer_decoder_auxiliary_predictions</strong> (List of Dict of <code>str, torch.FloatTensor</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>text_queries</strong> (<code>torch.FloatTensor</code>, <em>optional</em> of shape <code>(batch_size, num_queries, hidden_dim)</code>)
Text queries derived from the input text list used for calculating contrastive loss during training.</li>
<li><strong>task_token</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_dim)</code>)
1D task token to condition the queries.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
<p><code>OneFormerUniversalSegmentationOutput</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/oneformer#transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput"
>transformers.models.oneformer.modeling_oneformer.OneFormerForUniversalSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),K=new wn({props:{$$slots:{default:[Cn]},$$scope:{ctx:U}}}),ee=new Wt({props:{anchor:"transformers.OneFormerForUniversalSegmentation.forward.example",$$slots:{default:[Jn]},$$scope:{ctx:U}}}),Ge=new $n({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/oneformer.md"}}),{c(){c=i("meta"),x=n(),b=i("p"),y=n(),m(F.$$.fragment),d=n(),w=i("div"),w.innerHTML=St,bo=n(),m(te.$$.fragment),yo=n(),ne=i("p"),ne.innerHTML=Lt,vo=n(),re=i("img"),Fo=n(),se=i("p"),se.textContent=Vt,To=n(),ae=i("p"),ae.innerHTML=Rt,wo=n(),ie=i("p"),ie.innerHTML=Bt,Mo=n(),le=i("img"),xo=n(),ce=i("p"),ce.innerHTML=Et,Oo=n(),m(de.$$.fragment),ko=n(),me=i("ul"),me.innerHTML=Dt,jo=n(),m(pe.$$.fragment),$o=n(),ge=i("p"),ge.textContent=Yt,Io=n(),fe=i("ul"),fe.innerHTML=At,Uo=n(),he=i("p"),he.textContent=Qt,zo=n(),m(ue.$$.fragment),Co=n(),S=i("div"),m(_e.$$.fragment),ot=n(),Le=i("p"),Le.innerHTML=Kt,Jo=n(),J=i("div"),m(be.$$.fragment),tt=n(),He=i("p"),He.innerHTML=en,nt=n(),Ve=i("p"),Ve.innerHTML=on,No=n(),m(ye.$$.fragment),Po=n(),I=i("div"),m(ve.$$.fragment),rt=n(),Re=i("p"),Re.innerHTML=tn,st=n(),Be=i("p"),Be.innerHTML=nn,at=n(),m(H.$$.fragment),qo=n(),m(Fe.$$.fragment),Zo=n(),T=i("div"),m(Te.$$.fragment),it=n(),Xe=i("p"),Xe.textContent=rn,lt=n(),Ee=i("p"),Ee.innerHTML=sn,ct=n(),De=i("div"),m(we.$$.fragment),dt=n(),Z=i("div"),m(Me.$$.fragment),mt=n(),Ye=i("p"),Ye.innerHTML=an,pt=n(),Ae=i("p"),Ae.innerHTML=ln,gt=n(),V=i("div"),m(xe.$$.fragment),ft=n(),Qe=i("p"),Qe.innerHTML=cn,ht=n(),R=i("div"),m(Oe.$$.fragment),ut=n(),Ke=i("p"),Ke.innerHTML=dn,_t=n(),B=i("div"),m(ke.$$.fragment),bt=n(),eo=i("p"),eo.innerHTML=mn,Wo=n(),m(je.$$.fragment),Go=n(),j=i("div"),m($e.$$.fragment),yt=n(),oo=i("p"),oo.innerHTML=pn,vt=n(),X=i("div"),m(Ie.$$.fragment),Ft=n(),to=i("p"),to.innerHTML=gn,Tt=n(),E=i("div"),m(Ue.$$.fragment),wt=n(),no=i("p"),no.innerHTML=fn,Mt=n(),D=i("div"),m(ze.$$.fragment),xt=n(),ro=i("p"),ro.innerHTML=hn,Ot=n(),Y=i("div"),m(Ce.$$.fragment),kt=n(),so=i("p"),so.innerHTML=un,So=n(),m(Je.$$.fragment),Lo=n(),N=i("div"),m(Ne.$$.fragment),jt=n(),ao=i("p"),ao.innerHTML=_n,$t=n(),z=i("div"),m(Pe.$$.fragment),It=n(),io=i("p"),io.innerHTML=bn,Ut=n(),m(A.$$.fragment),zt=n(),m(Q.$$.fragment),Ho=n(),m(qe.$$.fragment),Vo=n(),P=i("div"),m(Ze.$$.fragment),Ct=n(),lo=i("p"),lo.innerHTML=yn,Jt=n(),$=i("div"),m(We.$$.fragment),Nt=n(),co=i("p"),co.innerHTML=vn,Pt=n(),m(K.$$.fragment),qt=n(),mo=i("p"),mo.textContent=Fn,Zt=n(),m(ee.$$.fragment),Ro=n(),m(Ge.$$.fragment),Bo=n(),ho=i("p"),this.h()},l(e){const t=jn("svelte-u9bgzb",document.head);c=l(t,"META",{name:!0,content:!0}),t.forEach(o),x=r(e),b=l(e,"P",{}),M(b).forEach(o),y=r(e),p(F.$$.fragment,e),d=r(e),w=l(e,"DIV",{class:!0,"data-svelte-h":!0}),_(w)!=="svelte-13t8s2t"&&(w.innerHTML=St),bo=r(e),p(te.$$.fragment,e),yo=r(e),ne=l(e,"P",{"data-svelte-h":!0}),_(ne)!=="svelte-4uriep"&&(ne.innerHTML=Lt),vo=r(e),re=l(e,"IMG",{width:!0,src:!0}),Fo=r(e),se=l(e,"P",{"data-svelte-h":!0}),_(se)!=="svelte-vfdo9a"&&(se.textContent=Vt),To=r(e),ae=l(e,"P",{"data-svelte-h":!0}),_(ae)!=="svelte-lnf9ge"&&(ae.innerHTML=Rt),wo=r(e),ie=l(e,"P",{"data-svelte-h":!0}),_(ie)!=="svelte-194z8jz"&&(ie.innerHTML=Bt),Mo=r(e),le=l(e,"IMG",{width:!0,src:!0}),xo=r(e),ce=l(e,"P",{"data-svelte-h":!0}),_(ce)!=="svelte-tphfzt"&&(ce.innerHTML=Et),Oo=r(e),p(de.$$.fragment,e),ko=r(e),me=l(e,"UL",{"data-svelte-h":!0}),_(me)!=="svelte-lbku0e"&&(me.innerHTML=Dt),jo=r(e),p(pe.$$.fragment,e),$o=r(e),ge=l(e,"P",{"data-svelte-h":!0}),_(ge)!=="svelte-e2wyhg"&&(ge.textContent=Yt),Io=r(e),fe=l(e,"UL",{"data-svelte-h":!0}),_(fe)!=="svelte-1f4vugx"&&(fe.innerHTML=At),Uo=r(e),he=l(e,"P",{"data-svelte-h":!0}),_(he)!=="svelte-1rggs50"&&(he.textContent=Qt),zo=r(e),p(ue.$$.fragment,e),Co=r(e),S=l(e,"DIV",{class:!0});var Se=M(S);p(_e.$$.fragment,Se),ot=r(Se),Le=l(Se,"P",{"data-svelte-h":!0}),_(Le)!=="svelte-l9bgt7"&&(Le.innerHTML=Kt),Se.forEach(o),Jo=r(e),J=l(e,"DIV",{class:!0});var L=M(J);p(be.$$.fragment,L),tt=r(L),He=l(L,"P",{"data-svelte-h":!0}),_(He)!=="svelte-tmsgtt"&&(He.innerHTML=en),nt=r(L),Ve=l(L,"P",{"data-svelte-h":!0}),_(Ve)!=="svelte-19d5ptt"&&(Ve.innerHTML=on),L.forEach(o),No=r(e),p(ye.$$.fragment,e),Po=r(e),I=l(e,"DIV",{class:!0});var q=M(I);p(ve.$$.fragment,q),rt=r(q),Re=l(q,"P",{"data-svelte-h":!0}),_(Re)!=="svelte-1stmifu"&&(Re.innerHTML=tn),st=r(q),Be=l(q,"P",{"data-svelte-h":!0}),_(Be)!=="svelte-o55m63"&&(Be.innerHTML=nn),at=r(q),p(H.$$.fragment,q),q.forEach(o),qo=r(e),p(Fe.$$.fragment,e),Zo=r(e),T=l(e,"DIV",{class:!0});var O=M(T);p(Te.$$.fragment,O),it=r(O),Xe=l(O,"P",{"data-svelte-h":!0}),_(Xe)!=="svelte-5uz02u"&&(Xe.textContent=rn),lt=r(O),Ee=l(O,"P",{"data-svelte-h":!0}),_(Ee)!=="svelte-1o6r6pd"&&(Ee.innerHTML=sn),ct=r(O),De=l(O,"DIV",{class:!0});var uo=M(De);p(we.$$.fragment,uo),uo.forEach(o),dt=r(O),Z=l(O,"DIV",{class:!0});var po=M(Z);p(Me.$$.fragment,po),mt=r(po),Ye=l(po,"P",{"data-svelte-h":!0}),_(Ye)!=="svelte-1tetyua"&&(Ye.innerHTML=an),pt=r(po),Ae=l(po,"P",{"data-svelte-h":!0}),_(Ae)!=="svelte-g5nqd2"&&(Ae.innerHTML=ln),po.forEach(o),gt=r(O),V=l(O,"DIV",{class:!0});var Eo=M(V);p(xe.$$.fragment,Eo),ft=r(Eo),Qe=l(Eo,"P",{"data-svelte-h":!0}),_(Qe)!=="svelte-cqk2tl"&&(Qe.innerHTML=cn),Eo.forEach(o),ht=r(O),R=l(O,"DIV",{class:!0});var Do=M(R);p(Oe.$$.fragment,Do),ut=r(Do),Ke=l(Do,"P",{"data-svelte-h":!0}),_(Ke)!=="svelte-ivz9k7"&&(Ke.innerHTML=dn),Do.forEach(o),_t=r(O),B=l(O,"DIV",{class:!0});var Yo=M(B);p(ke.$$.fragment,Yo),bt=r(Yo),eo=l(Yo,"P",{"data-svelte-h":!0}),_(eo)!=="svelte-pw2uru"&&(eo.innerHTML=mn),Yo.forEach(o),O.forEach(o),Wo=r(e),p(je.$$.fragment,e),Go=r(e),j=l(e,"DIV",{class:!0});var C=M(j);p($e.$$.fragment,C),yt=r(C),oo=l(C,"P",{"data-svelte-h":!0}),_(oo)!=="svelte-1w5nfyy"&&(oo.innerHTML=pn),vt=r(C),X=l(C,"DIV",{class:!0});var Ao=M(X);p(Ie.$$.fragment,Ao),Ft=r(Ao),to=l(Ao,"P",{"data-svelte-h":!0}),_(to)!=="svelte-1vyrc9d"&&(to.innerHTML=gn),Ao.forEach(o),Tt=r(C),E=l(C,"DIV",{class:!0});var Qo=M(E);p(Ue.$$.fragment,Qo),wt=r(Qo),no=l(Qo,"P",{"data-svelte-h":!0}),_(no)!=="svelte-1s6zzkn"&&(no.innerHTML=fn),Qo.forEach(o),Mt=r(C),D=l(C,"DIV",{class:!0});var Ko=M(D);p(ze.$$.fragment,Ko),xt=r(Ko),ro=l(Ko,"P",{"data-svelte-h":!0}),_(ro)!=="svelte-1sabqt1"&&(ro.innerHTML=hn),Ko.forEach(o),Ot=r(C),Y=l(C,"DIV",{class:!0});var et=M(Y);p(Ce.$$.fragment,et),kt=r(et),so=l(et,"P",{"data-svelte-h":!0}),_(so)!=="svelte-133lsut"&&(so.innerHTML=un),et.forEach(o),C.forEach(o),So=r(e),p(Je.$$.fragment,e),Lo=r(e),N=l(e,"DIV",{class:!0});var go=M(N);p(Ne.$$.fragment,go),jt=r(go),ao=l(go,"P",{"data-svelte-h":!0}),_(ao)!=="svelte-1o75izy"&&(ao.innerHTML=_n),$t=r(go),z=l(go,"DIV",{class:!0});var oe=M(z);p(Pe.$$.fragment,oe),It=r(oe),io=l(oe,"P",{"data-svelte-h":!0}),_(io)!=="svelte-1dezo66"&&(io.innerHTML=bn),Ut=r(oe),p(A.$$.fragment,oe),zt=r(oe),p(Q.$$.fragment,oe),oe.forEach(o),go.forEach(o),Ho=r(e),p(qe.$$.fragment,e),Vo=r(e),P=l(e,"DIV",{class:!0});var fo=M(P);p(Ze.$$.fragment,fo),Ct=r(fo),lo=l(fo,"P",{"data-svelte-h":!0}),_(lo)!=="svelte-1c5p7r"&&(lo.innerHTML=yn),Jt=r(fo),$=l(fo,"DIV",{class:!0});var W=M($);p(We.$$.fragment,W),Nt=r(W),co=l(W,"P",{"data-svelte-h":!0}),_(co)!=="svelte-28htca"&&(co.innerHTML=vn),Pt=r(W),p(K.$$.fragment,W),qt=r(W),mo=l(W,"P",{"data-svelte-h":!0}),_(mo)!=="svelte-11lpom8"&&(mo.textContent=Fn),Zt=r(W),p(ee.$$.fragment,W),W.forEach(o),fo.forEach(o),Ro=r(e),p(Ge.$$.fragment,e),Bo=r(e),ho=l(e,"P",{}),M(ho).forEach(o),this.h()},h(){v(c,"name","hf:doc:metadata"),v(c,"content",Pn),v(w,"class","flex flex-wrap space-x-1"),v(re,"width","600"),Tn(re.src,Ht="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/oneformer_teaser.png")||v(re,"src",Ht),v(le,"width","600"),Tn(le.src,Xt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/oneformer_architecture.png")||v(le,"src",Xt),v(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,c),a(e,x,t),a(e,b,t),a(e,y,t),g(F,e,t),a(e,d,t),a(e,w,t),a(e,bo,t),g(te,e,t),a(e,yo,t),a(e,ne,t),a(e,vo,t),a(e,re,t),a(e,Fo,t),a(e,se,t),a(e,To,t),a(e,ae,t),a(e,wo,t),a(e,ie,t),a(e,Mo,t),a(e,le,t),a(e,xo,t),a(e,ce,t),a(e,Oo,t),g(de,e,t),a(e,ko,t),a(e,me,t),a(e,jo,t),g(pe,e,t),a(e,$o,t),a(e,ge,t),a(e,Io,t),a(e,fe,t),a(e,Uo,t),a(e,he,t),a(e,zo,t),g(ue,e,t),a(e,Co,t),a(e,S,t),g(_e,S,null),s(S,ot),s(S,Le),a(e,Jo,t),a(e,J,t),g(be,J,null),s(J,tt),s(J,He),s(J,nt),s(J,Ve),a(e,No,t),g(ye,e,t),a(e,Po,t),a(e,I,t),g(ve,I,null),s(I,rt),s(I,Re),s(I,st),s(I,Be),s(I,at),g(H,I,null),a(e,qo,t),g(Fe,e,t),a(e,Zo,t),a(e,T,t),g(Te,T,null),s(T,it),s(T,Xe),s(T,lt),s(T,Ee),s(T,ct),s(T,De),g(we,De,null),s(T,dt),s(T,Z),g(Me,Z,null),s(Z,mt),s(Z,Ye),s(Z,pt),s(Z,Ae),s(T,gt),s(T,V),g(xe,V,null),s(V,ft),s(V,Qe),s(T,ht),s(T,R),g(Oe,R,null),s(R,ut),s(R,Ke),s(T,_t),s(T,B),g(ke,B,null),s(B,bt),s(B,eo),a(e,Wo,t),g(je,e,t),a(e,Go,t),a(e,j,t),g($e,j,null),s(j,yt),s(j,oo),s(j,vt),s(j,X),g(Ie,X,null),s(X,Ft),s(X,to),s(j,Tt),s(j,E),g(Ue,E,null),s(E,wt),s(E,no),s(j,Mt),s(j,D),g(ze,D,null),s(D,xt),s(D,ro),s(j,Ot),s(j,Y),g(Ce,Y,null),s(Y,kt),s(Y,so),a(e,So,t),g(Je,e,t),a(e,Lo,t),a(e,N,t),g(Ne,N,null),s(N,jt),s(N,ao),s(N,$t),s(N,z),g(Pe,z,null),s(z,It),s(z,io),s(z,Ut),g(A,z,null),s(z,zt),g(Q,z,null),a(e,Ho,t),g(qe,e,t),a(e,Vo,t),a(e,P,t),g(Ze,P,null),s(P,Ct),s(P,lo),s(P,Jt),s(P,$),g(We,$,null),s($,Nt),s($,co),s($,Pt),g(K,$,null),s($,qt),s($,mo),s($,Zt),g(ee,$,null),a(e,Ro,t),g(Ge,e,t),a(e,Bo,t),a(e,ho,t),Xo=!0},p(e,[t]){const Se={};t&2&&(Se.$$scope={dirty:t,ctx:e}),H.$set(Se);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),A.$set(L);const q={};t&2&&(q.$$scope={dirty:t,ctx:e}),Q.$set(q);const O={};t&2&&(O.$$scope={dirty:t,ctx:e}),K.$set(O);const uo={};t&2&&(uo.$$scope={dirty:t,ctx:e}),ee.$set(uo)},i(e){Xo||(f(F.$$.fragment,e),f(te.$$.fragment,e),f(de.$$.fragment,e),f(pe.$$.fragment,e),f(ue.$$.fragment,e),f(_e.$$.fragment,e),f(be.$$.fragment,e),f(ye.$$.fragment,e),f(ve.$$.fragment,e),f(H.$$.fragment,e),f(Fe.$$.fragment,e),f(Te.$$.fragment,e),f(we.$$.fragment,e),f(Me.$$.fragment,e),f(xe.$$.fragment,e),f(Oe.$$.fragment,e),f(ke.$$.fragment,e),f(je.$$.fragment,e),f($e.$$.fragment,e),f(Ie.$$.fragment,e),f(Ue.$$.fragment,e),f(ze.$$.fragment,e),f(Ce.$$.fragment,e),f(Je.$$.fragment,e),f(Ne.$$.fragment,e),f(Pe.$$.fragment,e),f(A.$$.fragment,e),f(Q.$$.fragment,e),f(qe.$$.fragment,e),f(Ze.$$.fragment,e),f(We.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(Ge.$$.fragment,e),Xo=!0)},o(e){h(F.$$.fragment,e),h(te.$$.fragment,e),h(de.$$.fragment,e),h(pe.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(ve.$$.fragment,e),h(H.$$.fragment,e),h(Fe.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(Me.$$.fragment,e),h(xe.$$.fragment,e),h(Oe.$$.fragment,e),h(ke.$$.fragment,e),h(je.$$.fragment,e),h($e.$$.fragment,e),h(Ie.$$.fragment,e),h(Ue.$$.fragment,e),h(ze.$$.fragment,e),h(Ce.$$.fragment,e),h(Je.$$.fragment,e),h(Ne.$$.fragment,e),h(Pe.$$.fragment,e),h(A.$$.fragment,e),h(Q.$$.fragment,e),h(qe.$$.fragment,e),h(Ze.$$.fragment,e),h(We.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(Ge.$$.fragment,e),Xo=!1},d(e){e&&(o(x),o(b),o(y),o(d),o(w),o(bo),o(yo),o(ne),o(vo),o(re),o(Fo),o(se),o(To),o(ae),o(wo),o(ie),o(Mo),o(le),o(xo),o(ce),o(Oo),o(ko),o(me),o(jo),o($o),o(ge),o(Io),o(fe),o(Uo),o(he),o(zo),o(Co),o(S),o(Jo),o(J),o(No),o(Po),o(I),o(qo),o(Zo),o(T),o(Wo),o(Go),o(j),o(So),o(Lo),o(N),o(Ho),o(Vo),o(P),o(Ro),o(Bo),o(ho)),o(c),u(F,e),u(te,e),u(de,e),u(pe,e),u(ue,e),u(_e),u(be),u(ye,e),u(ve),u(H),u(Fe,e),u(Te),u(we),u(Me),u(xe),u(Oe),u(ke),u(je,e),u($e),u(Ie),u(Ue),u(ze),u(Ce),u(Je,e),u(Ne),u(Pe),u(A),u(Q),u(qe,e),u(Ze),u(We),u(K),u(ee),u(Ge,e)}}}const Pn='{"title":"OneFormer","local":"oneformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"OneFormer specific outputs","local":"transformers.models.oneformer.modeling_oneformer.OneFormerModelOutput","sections":[],"depth":2},{"title":"OneFormerConfig","local":"transformers.OneFormerConfig","sections":[],"depth":2},{"title":"OneFormerImageProcessor","local":"transformers.OneFormerImageProcessor","sections":[],"depth":2},{"title":"OneFormerProcessor","local":"transformers.OneFormerProcessor","sections":[],"depth":2},{"title":"OneFormerModel","local":"transformers.OneFormerModel","sections":[],"depth":2},{"title":"OneFormerForUniversalSegmentation","local":"transformers.OneFormerForUniversalSegmentation","sections":[],"depth":2}],"depth":1}';function qn(U){return xn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rn extends On{constructor(c){super(),kn(this,c,qn,Nn,Mn,{})}}export{Rn as component};
