import{s as vt,o as Ct,n as Ut}from"../chunks/scheduler.01eeda35.js";import{S as zt,i as Bt,g as m,s as i,r as g,A as Vt,h as d,f as l,c as p,j as _t,u as _,x as f,k as Rt,y as R,a,v as W,d as U,t as X,w as I}from"../chunks/index.6dd51b66.js";import{T as Wt}from"../chunks/Tip.de9bae2b.js";import{C as st}from"../chunks/CodeBlock.19ec9b8c.js";import{H as yt,E as kt}from"../chunks/index.58fe8f9d.js";import{H as Yt,a as $t}from"../chunks/HfOption.f7f04550.js";function Ft(B){let n,b="Run the quantized model on a CPU by changing <code>device_map</code> to <code>&quot;cpu&quot;</code> and <code>layout</code> to <code>Int4CPULayout()</code>. This is only available in torchao 0.8.0+.";return{c(){n=m("p"),n.innerHTML=b},l(c){n=d(c,"P",{"data-svelte-h":!0}),f(n)!=="svelte-b8nyn5"&&(n.innerHTML=b)},m(c,h){a(c,n,h)},p:Ut,d(c){c&&l(n)}}}function Qt(B){let n,b="For best performance, you can use recommended settings by calling <code>torchao.quantization.utils.recommended_inductor_config_setter()</code>";return{c(){n=m("p"),n.innerHTML=b},l(c){n=d(c,"P",{"data-svelte-h":!0}),f(n)!=="svelte-dcid7j"&&(n.innerHTML=b)},m(c,h){a(c,n,h)},p:Ut,d(c){c&&l(n)}}}function xt(B){let n,b='Create a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.TorchAoConfig">TorchAoConfig</a> and specify the quantization type and <code>group_size</code> of the weights to quantize. Set the <code>cache_implementation</code> to <code>&quot;static&quot;</code> to automatically <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a> the forward method.',c,h,u,y,J="In torchao 0.10.0+, you can use the more flexible <code>AOBaseConfig</code> approach instead of string identifiers:",$,w,G,Z,k,j,v="TorchAO provides a variety of quantization configurations:",q,o,T="<li><code>Int4WeightOnlyConfig</code></li> <li><code>Int8WeightOnlyConfig</code></li> <li><code>Int8DynamicActivationInt8WeightConfig</code></li> <li><code>Float8WeightOnlyConfig</code></li>",C,L,ot="Each configuration can be further customized with parameters such as <code>group_size</code>, <code>scheme</code>, and <code>layout</code> to optimize for specific hardware and model architectures.",V,Y,S='For a complete list of available configurations, see our <a href="https://github.com/pytorch/ao/blob/main/torchao/quantization/quant_api.py" rel="nofollow">quantization API documentation</a>.',D,M,O,it="<strong>⚠️ DEPRECATION WARNING</strong>",Q,tt,pt="Starting with version 0.10.0, the string-based API for quantization configuration (e.g., <code>TorchAoConfig(&quot;int4_weight_only&quot;, group_size=128)</code>) is <strong>deprecated</strong> and will be removed in a future release.",x,E,P="Please use the new <code>AOBaseConfig</code>-based approach instead:",et,z,dt,H,K="The new API offers greater flexibility, better type safety, and access to the full range of features available in torchao.",ht,F,N,A,lt="Here’s how to migrate from common string identifiers to their <code>AOBaseConfig</code> equivalents:",at,t,r="<thead><tr><th>Old String API</th> <th>New <code>AOBaseConfig</code> API</th></tr></thead> <tbody><tr><td><code>&quot;int4_weight_only&quot;</code></td> <td><code>Int4WeightOnlyConfig()</code></td></tr> <tr><td><code>&quot;int8_weight_only&quot;</code></td> <td><code>Int8WeightOnlyConfig()</code></td></tr> <tr><td><code>&quot;int8_dynamic_activation_int8_weight&quot;</code></td> <td><code>Int8DynamicActivationInt8WeightConfig()</code></td></tr></tbody>",Mt,ft,Xt="All configuration objects accept parameters for customization (e.g., <code>group_size</code>, <code>scheme</code>, <code>layout</code>).",bt,rt,It="Below is the API for for torchao &lt; <code>0.9.0</code>",Jt,ct,Tt,ut,Zt="Run the code below to benchmark the quantized models performance.",wt,mt,jt,nt,gt;return h=new Wt({props:{warning:!1,$$slots:{default:[Ft]},$$scope:{ctx:B}}}),w=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVG9yY2hBb0NvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjB0b3JjaGFvLnF1YW50aXphdGlvbiUyMGltcG9ydCUyMEludDRXZWlnaHRPbmx5Q29uZmlnJTBBJTBBJTIzJTIwVXNpbmclMjBBT0Jhc2VDb25maWclMjBpbnN0YW5jZSUyMCh0b3JjaGFvJTIwJTNFJTNEJTIwMC4xMC4wKSUwQXF1YW50X2NvbmZpZyUyMCUzRCUyMEludDRXZWlnaHRPbmx5Q29uZmlnKGdyb3VwX3NpemUlM0QxMjgpJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFRvcmNoQW9Db25maWcocXVhbnRfdHlwZSUzRHF1YW50X2NvbmZpZyklMEElMEElMjMlMjBMb2FkJTIwYW5kJTIwcXVhbnRpemUlMjB0aGUlMjBtb2RlbCUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUwQSklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCJTIyKSUwQWlucHV0X3RleHQlMjAlM0QlMjAlMjJXaGF0JTIwYXJlJTIwd2UlMjBoYXZpbmclMjBmb3IlMjBkaW5uZXIlM0YlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwYXV0by1jb21waWxlJTIwdGhlJTIwcXVhbnRpemVkJTIwbW9kZWwlMjB3aXRoJTIwJTYwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIlNjAlMjB0byUyMGdldCUyMHNwZWVkJTIwdXAlMEFvdXRwdXQlMjAlM0QlMjBxdWFudGl6ZWRfbW9kZWwuZ2VuZXJhdGUoKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TorchAoConfig, AutoModelForCausalLM, AutoTokenizer
<span class="hljs-keyword">from</span> torchao.quantization <span class="hljs-keyword">import</span> Int4WeightOnlyConfig

<span class="hljs-comment"># Using AOBaseConfig instance (torchao &gt;= 0.10.0)</span>
quant_config = Int4WeightOnlyConfig(group_size=<span class="hljs-number">128</span>)
quantization_config = TorchAoConfig(quant_type=quant_config)

<span class="hljs-comment"># Load and quantize the model</span>
quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    quantization_config=quantization_config
)

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>)
input_text = <span class="hljs-string">&quot;What are we having for dinner?&quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># auto-compile the quantized model with \`cache_implementation=&quot;static&quot;\` to get speed up</span>
output = quantized_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),Z=new yt({props:{title:"Available Quantization Schemes",local:"available-quantization-schemes",headingTag:"h2"}}),z=new st({props:{code:"JTIzJTIwT2xkJTIwd2F5JTIwKGRlcHJlY2F0ZWQpJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMFRvcmNoQW9Db25maWcoJTIyaW50NF93ZWlnaHRfb25seSUyMiUyQyUyMGdyb3VwX3NpemUlM0QxMjgpJTBBJTBBJTIzJTIwTmV3JTIwd2F5JTIwKHJlY29tbWVuZGVkKSUwQWZyb20lMjB0b3JjaGFvLnF1YW50aXphdGlvbiUyMGltcG9ydCUyMEludDRXZWlnaHRPbmx5Q29uZmlnJTBBcXVhbnRfY29uZmlnJTIwJTNEJTIwSW50NFdlaWdodE9ubHlDb25maWcoZ3JvdXBfc2l6ZSUzRDEyOCklMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwVG9yY2hBb0NvbmZpZyhxdWFudF90eXBlJTNEcXVhbnRfY29uZmlnKQ==",highlighted:`<span class="hljs-comment"># Old way (deprecated)</span>
quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int4_weight_only&quot;</span>, group_size=<span class="hljs-number">128</span>)

<span class="hljs-comment"># New way (recommended)</span>
<span class="hljs-keyword">from</span> torchao.quantization <span class="hljs-keyword">import</span> Int4WeightOnlyConfig
quant_config = Int4WeightOnlyConfig(group_size=<span class="hljs-number">128</span>)
quantization_config = TorchAoConfig(quant_type=quant_config)`,wrap:!1}}),F=new yt({props:{title:"Migration Guide",local:"migration-guide",headingTag:"h2"}}),ct=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVG9yY2hBb0NvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBUb3JjaEFvQ29uZmlnKCUyMmludDRfd2VpZ2h0X29ubHklMjIlMkMlMjBncm91cF9zaXplJTNEMTI4KSUwQXF1YW50aXplZF9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUwQSklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLThCJTIyKSUwQWlucHV0X3RleHQlMjAlM0QlMjAlMjJXaGF0JTIwYXJlJTIwd2UlMjBoYXZpbmclMjBmb3IlMjBkaW5uZXIlM0YlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfdGV4dCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwYXV0by1jb21waWxlJTIwdGhlJTIwcXVhbnRpemVkJTIwbW9kZWwlMjB3aXRoJTIwJTYwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIlNjAlMjB0byUyMGdldCUyMHNwZWVkJTIwdXAlMEFvdXRwdXQlMjAlM0QlMjBxdWFudGl6ZWRfbW9kZWwuZ2VuZXJhdGUoKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXQlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TorchAoConfig, AutoModelForCausalLM, AutoTokenizer

quantization_config = TorchAoConfig(<span class="hljs-string">&quot;int4_weight_only&quot;</span>, group_size=<span class="hljs-number">128</span>)
quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    quantization_config=quantization_config
)

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>)
input_text = <span class="hljs-string">&quot;What are we having for dinner?&quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># auto-compile the quantized model with \`cache_implementation=&quot;static&quot;\` to get speed up</span>
output = quantized_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),mt=new st({props:{code:"ZnJvbSUyMHRvcmNoLl9pbmR1Y3Rvci51dGlscyUyMGltcG9ydCUyMGRvX2JlbmNoX3VzaW5nX3Byb2ZpbGluZyUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBDYWxsYWJsZSUwQSUwQWRlZiUyMGJlbmNobWFya19mbihmdW5jJTNBJTIwQ2FsbGFibGUlMkMlMjAqYXJncyUyQyUyMCoqa3dhcmdzKSUyMC0lM0UlMjBmbG9hdCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlRoaW4lMjB3cmFwcGVyJTIwYXJvdW5kJTIwZG9fYmVuY2hfdXNpbmdfcHJvZmlsaW5nJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwbm9fYXJncyUyMCUzRCUyMGxhbWJkYSUzQSUyMGZ1bmMoKmFyZ3MlMkMlMjAqKmt3YXJncyklMEElMjAlMjAlMjAlMjB0aW1lJTIwJTNEJTIwZG9fYmVuY2hfdXNpbmdfcHJvZmlsaW5nKG5vX2FyZ3MpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdGltZSUyMColMjAxZTMlMEElMEFNQVhfTkVXX1RPS0VOUyUyMCUzRCUyMDEwMDAlMEFwcmludCglMjJpbnQ0d28tMTI4JTIwbW9kZWwlM0ElMjIlMkMlMjBiZW5jaG1hcmtfZm4ocXVhbnRpemVkX21vZGVsLmdlbmVyYXRlJTJDJTIwKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRE1BWF9ORVdfVE9LRU5TJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIpKSUwQSUwQWJmMTZfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFvdXRwdXQlMjAlM0QlMjBiZjE2X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyKSUyMCUyMyUyMGF1dG8tY29tcGlsZSUwQXByaW50KCUyMmJmMTYlMjBtb2RlbCUzQSUyMiUyQyUyMGJlbmNobWFya19mbihiZjE2X21vZGVsLmdlbmVyYXRlJTJDJTIwKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRE1BWF9ORVdfVE9LRU5TJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIpKQ==",highlighted:`<span class="hljs-keyword">from</span> torch._inductor.utils <span class="hljs-keyword">import</span> do_bench_using_profiling
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Callable</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">benchmark_fn</span>(<span class="hljs-params">func: <span class="hljs-type">Callable</span>, *args, **kwargs</span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Thin wrapper around do_bench_using_profiling&quot;&quot;&quot;</span>
    no_args = <span class="hljs-keyword">lambda</span>: func(*args, **kwargs)
    time = do_bench_using_profiling(no_args)
    <span class="hljs-keyword">return</span> time * <span class="hljs-number">1e3</span>

MAX_NEW_TOKENS = <span class="hljs-number">1000</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;int4wo-128 model:&quot;</span>, benchmark_fn(quantized_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>))

bf16_model = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
output = bf16_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>) <span class="hljs-comment"># auto-compile</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;bf16 model:&quot;</span>, benchmark_fn(bf16_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>))`,wrap:!1}}),nt=new Wt({props:{warning:!1,$$slots:{default:[Qt]},$$scope:{ctx:B}}}),{c(){n=m("p"),n.innerHTML=b,c=i(),g(h.$$.fragment),u=i(),y=m("p"),y.innerHTML=J,$=i(),g(w.$$.fragment),G=i(),g(Z.$$.fragment),k=i(),j=m("p"),j.textContent=v,q=i(),o=m("ul"),o.innerHTML=T,C=i(),L=m("p"),L.innerHTML=ot,V=i(),Y=m("p"),Y.innerHTML=S,D=i(),M=m("blockquote"),O=m("p"),O.innerHTML=it,Q=i(),tt=m("p"),tt.innerHTML=pt,x=i(),E=m("p"),E.innerHTML=P,et=i(),g(z.$$.fragment),dt=i(),H=m("p"),H.textContent=K,ht=i(),g(F.$$.fragment),N=i(),A=m("p"),A.innerHTML=lt,at=i(),t=m("table"),t.innerHTML=r,Mt=i(),ft=m("p"),ft.innerHTML=Xt,bt=i(),rt=m("p"),rt.innerHTML=It,Jt=i(),g(ct.$$.fragment),Tt=i(),ut=m("p"),ut.textContent=Zt,wt=i(),g(mt.$$.fragment),jt=i(),g(nt.$$.fragment)},l(e){n=d(e,"P",{"data-svelte-h":!0}),f(n)!=="svelte-vp4lhi"&&(n.innerHTML=b),c=p(e),_(h.$$.fragment,e),u=p(e),y=d(e,"P",{"data-svelte-h":!0}),f(y)!=="svelte-141idma"&&(y.innerHTML=J),$=p(e),_(w.$$.fragment,e),G=p(e),_(Z.$$.fragment,e),k=p(e),j=d(e,"P",{"data-svelte-h":!0}),f(j)!=="svelte-vq290e"&&(j.textContent=v),q=p(e),o=d(e,"UL",{"data-svelte-h":!0}),f(o)!=="svelte-1uraxyr"&&(o.innerHTML=T),C=p(e),L=d(e,"P",{"data-svelte-h":!0}),f(L)!=="svelte-fedjfn"&&(L.innerHTML=ot),V=p(e),Y=d(e,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-15ibe5k"&&(Y.innerHTML=S),D=p(e),M=d(e,"BLOCKQUOTE",{});var s=_t(M);O=d(s,"P",{"data-svelte-h":!0}),f(O)!=="svelte-11pv5zk"&&(O.innerHTML=it),Q=p(s),tt=d(s,"P",{"data-svelte-h":!0}),f(tt)!=="svelte-jmxllg"&&(tt.innerHTML=pt),x=p(s),E=d(s,"P",{"data-svelte-h":!0}),f(E)!=="svelte-1qak5au"&&(E.innerHTML=P),et=p(s),_(z.$$.fragment,s),dt=p(s),H=d(s,"P",{"data-svelte-h":!0}),f(H)!=="svelte-8tiw44"&&(H.textContent=K),ht=p(s),_(F.$$.fragment,s),N=p(s),A=d(s,"P",{"data-svelte-h":!0}),f(A)!=="svelte-1kyext4"&&(A.innerHTML=lt),at=p(s),t=d(s,"TABLE",{"data-svelte-h":!0}),f(t)!=="svelte-1w9xui3"&&(t.innerHTML=r),Mt=p(s),ft=d(s,"P",{"data-svelte-h":!0}),f(ft)!=="svelte-9z9ctj"&&(ft.innerHTML=Xt),s.forEach(l),bt=p(e),rt=d(e,"P",{"data-svelte-h":!0}),f(rt)!=="svelte-1gt4wva"&&(rt.innerHTML=It),Jt=p(e),_(ct.$$.fragment,e),Tt=p(e),ut=d(e,"P",{"data-svelte-h":!0}),f(ut)!=="svelte-thutbg"&&(ut.textContent=Zt),wt=p(e),_(mt.$$.fragment,e),jt=p(e),_(nt.$$.fragment,e)},m(e,s){a(e,n,s),a(e,c,s),W(h,e,s),a(e,u,s),a(e,y,s),a(e,$,s),W(w,e,s),a(e,G,s),W(Z,e,s),a(e,k,s),a(e,j,s),a(e,q,s),a(e,o,s),a(e,C,s),a(e,L,s),a(e,V,s),a(e,Y,s),a(e,D,s),a(e,M,s),R(M,O),R(M,Q),R(M,tt),R(M,x),R(M,E),R(M,et),W(z,M,null),R(M,dt),R(M,H),R(M,ht),W(F,M,null),R(M,N),R(M,A),R(M,at),R(M,t),R(M,Mt),R(M,ft),a(e,bt,s),a(e,rt,s),a(e,Jt,s),W(ct,e,s),a(e,Tt,s),a(e,ut,s),a(e,wt,s),W(mt,e,s),a(e,jt,s),W(nt,e,s),gt=!0},p(e,s){const Gt={};s&2&&(Gt.$$scope={dirty:s,ctx:e}),h.$set(Gt);const qt={};s&2&&(qt.$$scope={dirty:s,ctx:e}),nt.$set(qt)},i(e){gt||(U(h.$$.fragment,e),U(w.$$.fragment,e),U(Z.$$.fragment,e),U(z.$$.fragment,e),U(F.$$.fragment,e),U(ct.$$.fragment,e),U(mt.$$.fragment,e),U(nt.$$.fragment,e),gt=!0)},o(e){X(h.$$.fragment,e),X(w.$$.fragment,e),X(Z.$$.fragment,e),X(z.$$.fragment,e),X(F.$$.fragment,e),X(ct.$$.fragment,e),X(mt.$$.fragment,e),X(nt.$$.fragment,e),gt=!1},d(e){e&&(l(n),l(c),l(u),l(y),l($),l(G),l(k),l(j),l(q),l(o),l(C),l(L),l(V),l(Y),l(D),l(M),l(bt),l(rt),l(Jt),l(Tt),l(ut),l(wt),l(jt)),I(h,e),I(w,e),I(Z,e),I(z),I(F),I(ct,e),I(mt,e),I(nt,e)}}}function Et(B){let n,b="Run the quantized model on a CPU by changing <code>device_map</code> to <code>&quot;cpu&quot;</code> and <code>layout</code> to <code>Int4CPULayout()</code>. This is only available in torchao 0.8.0+.";return{c(){n=m("p"),n.innerHTML=b},l(c){n=d(c,"P",{"data-svelte-h":!0}),f(n)!=="svelte-b8nyn5"&&(n.innerHTML=b)},m(c,h){a(c,n,h)},p:Ut,d(c){c&&l(n)}}}function Ht(B){let n,b='The <a href="https://pytorch.org/ao/stable/generated/torchao.quantization.autoquant.html#torchao.quantization.autoquant" rel="nofollow">autoquant</a> API automatically chooses a quantization type for quantizable layers (<code>nn.Linear</code>) by micro-benchmarking on input type and shape and compiling a single linear layer.',c,h,u='Create a <a href="/docs/transformers/main/en/main_classes/quantization#transformers.TorchAoConfig">TorchAoConfig</a> and set to <code>&quot;autoquant&quot;</code>. Set the <code>cache_implementation</code> to <code>&quot;static&quot;</code> to automatically <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a> the forward method. Finally, call <code>finalize_autoquant</code> on the quantized model to finalize the quantization and log the input shapes.',y,J,$,w,G,Z,k="Run the code below to benchmark the quantized models performance.",j,v,q;return J=new Wt({props:{warning:!1,$$slots:{default:[Et]},$$scope:{ctx:B}}}),w=new st({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVG9yY2hBb0NvbmZpZyUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBUb3JjaEFvQ29uZmlnKCUyMmF1dG9xdWFudCUyMiUyQyUyMG1pbl9zcW5yJTNETm9uZSklMEFxdWFudGl6ZWRfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04QiUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEJTIyYXV0byUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMEEpJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04QiUyMiklMEFpbnB1dF90ZXh0JTIwJTNEJTIwJTIyV2hhdCUyMGFyZSUyMHdlJTIwaGF2aW5nJTIwZm9yJTIwZGlubmVyJTNGJTIyJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGF1dG8tY29tcGlsZSUyMHRoZSUyMHF1YW50aXplZCUyMG1vZGVsJTIwd2l0aCUyMCU2MGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyJTYwJTIwdG8lMjBnZXQlMjBzcGVlZCUyMHVwJTBBb3V0cHV0JTIwJTNEJTIwcXVhbnRpemVkX21vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyKSUwQSUyMyUyMGV4cGxpY2l0bHklMjBjYWxsJTIwJTYwZmluYWxpemVfYXV0b3F1YW50JTYwJTIwKG1heSUyMGJlJTIwcmVmYWN0b3JlZCUyMGFuZCUyMHJlbW92ZWQlMjBpbiUyMHRoZSUyMGZ1dHVyZSklMEFxdWFudGl6ZWRfbW9kZWwuZmluYWxpemVfYXV0b3F1YW50KCklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dCU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TorchAoConfig, AutoModelForCausalLM, AutoTokenizer

quantization_config = TorchAoConfig(<span class="hljs-string">&quot;autoquant&quot;</span>, min_sqnr=<span class="hljs-literal">None</span>)
quantized_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>,
    torch_dtype=<span class="hljs-string">&quot;auto&quot;</span>,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>,
    quantization_config=quantization_config
)

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B&quot;</span>)
input_text = <span class="hljs-string">&quot;What are we having for dinner?&quot;</span>
input_ids = tokenizer(input_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># auto-compile the quantized model with \`cache_implementation=&quot;static&quot;\` to get speed up</span>
output = quantized_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>)
<span class="hljs-comment"># explicitly call \`finalize_autoquant\` (may be refactored and removed in the future)</span>
quantized_model.finalize_autoquant()
<span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),v=new st({props:{code:"ZnJvbSUyMHRvcmNoLl9pbmR1Y3Rvci51dGlscyUyMGltcG9ydCUyMGRvX2JlbmNoX3VzaW5nX3Byb2ZpbGluZyUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBDYWxsYWJsZSUwQSUwQWRlZiUyMGJlbmNobWFya19mbihmdW5jJTNBJTIwQ2FsbGFibGUlMkMlMjAqYXJncyUyQyUyMCoqa3dhcmdzKSUyMC0lM0UlMjBmbG9hdCUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMlRoaW4lMjB3cmFwcGVyJTIwYXJvdW5kJTIwZG9fYmVuY2hfdXNpbmdfcHJvZmlsaW5nJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwbm9fYXJncyUyMCUzRCUyMGxhbWJkYSUzQSUyMGZ1bmMoKmFyZ3MlMkMlMjAqKmt3YXJncyklMEElMjAlMjAlMjAlMjB0aW1lJTIwJTNEJTIwZG9fYmVuY2hfdXNpbmdfcHJvZmlsaW5nKG5vX2FyZ3MpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdGltZSUyMColMjAxZTMlMEElMEFNQVhfTkVXX1RPS0VOUyUyMCUzRCUyMDEwMDAlMEFwcmludCglMjJhdXRvcXVhbnRpemVkJTIwbW9kZWwlM0ElMjIlMkMlMjBiZW5jaG1hcmtfZm4ocXVhbnRpemVkX21vZGVsLmdlbmVyYXRlJTJDJTIwKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRE1BWF9ORVdfVE9LRU5TJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIpKSUwQSUwQWJmMTZfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfbmFtZSUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFvdXRwdXQlMjAlM0QlMjBiZjE2X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGNhY2hlX2ltcGxlbWVudGF0aW9uJTNEJTIyc3RhdGljJTIyKSUyMCUyMyUyMGF1dG8tY29tcGlsZSUwQXByaW50KCUyMmJmMTYlMjBtb2RlbCUzQSUyMiUyQyUyMGJlbmNobWFya19mbihiZjE2X21vZGVsLmdlbmVyYXRlJTJDJTIwKippbnB1dF9pZHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRE1BWF9ORVdfVE9LRU5TJTJDJTIwY2FjaGVfaW1wbGVtZW50YXRpb24lM0QlMjJzdGF0aWMlMjIpKQ==",highlighted:`<span class="hljs-keyword">from</span> torch._inductor.utils <span class="hljs-keyword">import</span> do_bench_using_profiling
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Callable</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">benchmark_fn</span>(<span class="hljs-params">func: <span class="hljs-type">Callable</span>, *args, **kwargs</span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;Thin wrapper around do_bench_using_profiling&quot;&quot;&quot;</span>
    no_args = <span class="hljs-keyword">lambda</span>: func(*args, **kwargs)
    time = do_bench_using_profiling(no_args)
    <span class="hljs-keyword">return</span> time * <span class="hljs-number">1e3</span>

MAX_NEW_TOKENS = <span class="hljs-number">1000</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;autoquantized model:&quot;</span>, benchmark_fn(quantized_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>))

bf16_model = AutoModelForCausalLM.from_pretrained(model_name, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
output = bf16_model.generate(**input_ids, max_new_tokens=<span class="hljs-number">10</span>, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>) <span class="hljs-comment"># auto-compile</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;bf16 model:&quot;</span>, benchmark_fn(bf16_model.generate, **input_ids, max_new_tokens=MAX_NEW_TOKENS, cache_implementation=<span class="hljs-string">&quot;static&quot;</span>))`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=b,c=i(),h=m("p"),h.innerHTML=u,y=i(),g(J.$$.fragment),$=i(),g(w.$$.fragment),G=i(),Z=m("p"),Z.textContent=k,j=i(),g(v.$$.fragment)},l(o){n=d(o,"P",{"data-svelte-h":!0}),f(n)!=="svelte-zr07mp"&&(n.innerHTML=b),c=p(o),h=d(o,"P",{"data-svelte-h":!0}),f(h)!=="svelte-21luch"&&(h.innerHTML=u),y=p(o),_(J.$$.fragment,o),$=p(o),_(w.$$.fragment,o),G=p(o),Z=d(o,"P",{"data-svelte-h":!0}),f(Z)!=="svelte-thutbg"&&(Z.textContent=k),j=p(o),_(v.$$.fragment,o)},m(o,T){a(o,n,T),a(o,c,T),a(o,h,T),a(o,y,T),W(J,o,T),a(o,$,T),W(w,o,T),a(o,G,T),a(o,Z,T),a(o,j,T),W(v,o,T),q=!0},p(o,T){const C={};T&2&&(C.$$scope={dirty:T,ctx:o}),J.$set(C)},i(o){q||(U(J.$$.fragment,o),U(w.$$.fragment,o),U(v.$$.fragment,o),q=!0)},o(o){X(J.$$.fragment,o),X(w.$$.fragment,o),X(v.$$.fragment,o),q=!1},d(o){o&&(l(n),l(c),l(h),l(y),l($),l(G),l(Z),l(j)),I(J,o),I(w,o),I(v,o)}}}function Nt(B){let n,b,c,h;return n=new $t({props:{id:"torchao",option:"manual",$$slots:{default:[xt]},$$scope:{ctx:B}}}),c=new $t({props:{id:"torchao",option:"automatic",$$slots:{default:[Ht]},$$scope:{ctx:B}}}),{c(){g(n.$$.fragment),b=i(),g(c.$$.fragment)},l(u){_(n.$$.fragment,u),b=p(u),_(c.$$.fragment,u)},m(u,y){W(n,u,y),a(u,b,y),W(c,u,y),h=!0},p(u,y){const J={};y&2&&(J.$$scope={dirty:y,ctx:u}),n.$set(J);const $={};y&2&&($.$$scope={dirty:y,ctx:u}),c.$set($)},i(u){h||(U(n.$$.fragment,u),U(c.$$.fragment,u),h=!0)},o(u){X(n.$$.fragment,u),X(c.$$.fragment,u),h=!1},d(u){u&&l(b),I(n,u),I(c,u)}}}function At(B){let n,b,c,h,u,y,J,$='<a href="https://github.com/pytorch/ao" rel="nofollow">torchao</a> is a PyTorch architecture optimization library with support for custom high performance data types, quantization, and sparsity. It is composable with native PyTorch features such as <a href="https://pytorch.org/tutorials/intermediate/torch_compile_tutorial.html" rel="nofollow">torch.compile</a> for even faster inference and training.',w,G,Z="Install torchao with the following command.",k,j,v,q,o=`torchao supports many quantization types for different data types (int4, float8, weight only, etc.).
Starting with version 0.10.0, torchao provides enhanced flexibility through the <code>AOBaseConfig</code> API, allowing for more customized quantization configurations.
And full access to the techniques offered in the torchao library.`,T,C,L="You can manually choose the quantization types and settings or automatically select the quantization types.",ot,V,Y,S,D,M,O='torchao implements <a href="https://pytorch.org/docs/stable/notes/extending.html#subclassing-torch-tensor" rel="nofollow">torch.Tensor subclasses</a> for maximum flexibility in supporting new quantized torch.Tensor formats. <a href="https://huggingface.co/docs/safetensors/en/index" rel="nofollow">Safetensors</a> serialization and deserialization does not work with torchao.',it,Q,tt='To avoid arbitrary user code execution, torchao sets <code>weights_only=True</code> in <a href="https://pytorch.org/docs/stable/generated/torch.load.html" rel="nofollow">torch.load</a> to ensure only tensors are loaded. Any known user functions can be whitelisted with <a href="https://pytorch.org/docs/stable/notes/serialization.html#torch.serialization.add_safe_globals" rel="nofollow">add_safe_globals</a>.',pt,x,E,P,et,z,dt='For a better sense of expected performance, view the <a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#benchmarks" rel="nofollow">benchmarks</a> for various models with CUDA and XPU backends.',H,K,ht='Refer to <a href="https://github.com/pytorch/ao/tree/main/torchao/quantization#other-available-quantization-techniques" rel="nofollow">Other Available Quantization Techniques</a> for more examples and documentation.',F,N,A,lt,at;return u=new yt({props:{title:"torchao",local:"torchao",headingTag:"h1"}}),j=new st({props:{code:"JTIzJTIwVXBkYXRpbmclMjAlRjAlOUYlQTQlOTclMjBUcmFuc2Zvcm1lcnMlMjB0byUyMHRoZSUyMGxhdGVzdCUyMHZlcnNpb24lMkMlMjBhcyUyMHRoZSUyMGV4YW1wbGUlMjBzY3JpcHQlMjBiZWxvdyUyMHVzZXMlMjB0aGUlMjBuZXclMjBhdXRvJTIwY29tcGlsYXRpb24lMEFwaXAlMjBpbnN0YWxsJTIwLS11cGdyYWRlJTIwdG9yY2glMjB0b3JjaGFvJTIwdHJhbnNmb3JtZXJz",highlighted:`<span class="hljs-comment"># Updating 🤗 Transformers to the latest version, as the example script below uses the new auto compilation</span>
pip install --upgrade torch torchao transformers`,wrap:!1}}),V=new Yt({props:{id:"torchao",options:["manual","automatic"],$$slots:{default:[Nt]},$$scope:{ctx:B}}}),S=new yt({props:{title:"Serialization",local:"serialization",headingTag:"h2"}}),x=new st({props:{code:"JTIzJTIwZG9uJ3QlMjBzZXJpYWxpemUlMjBtb2RlbCUyMHdpdGglMjBTYWZldGVuc29ycyUwQW91dHB1dF9kaXIlMjAlM0QlMjAlMjJsbGFtYTMtOGItaW50NHdvLTEyOCUyMiUwQXF1YW50aXplZF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIybGxhbWEzLThiLWludDR3by0xMjglMjIlMkMlMjBzYWZlX3NlcmlhbGl6YXRpb24lM0RGYWxzZSk=",highlighted:`<span class="hljs-comment"># don&#x27;t serialize model with Safetensors</span>
output_dir = <span class="hljs-string">&quot;llama3-8b-int4wo-128&quot;</span>
quantized_model.save_pretrained(<span class="hljs-string">&quot;llama3-8b-int4wo-128&quot;</span>, safe_serialization=<span class="hljs-literal">False</span>)`,wrap:!1}}),P=new yt({props:{title:"Resources",local:"resources",headingTag:"h2"}}),N=new kt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/quantization/torchao.md"}}),{c(){n=m("meta"),b=i(),c=m("p"),h=i(),g(u.$$.fragment),y=i(),J=m("p"),J.innerHTML=$,w=i(),G=m("p"),G.textContent=Z,k=i(),g(j.$$.fragment),v=i(),q=m("p"),q.innerHTML=o,T=i(),C=m("p"),C.textContent=L,ot=i(),g(V.$$.fragment),Y=i(),g(S.$$.fragment),D=i(),M=m("p"),M.innerHTML=O,it=i(),Q=m("p"),Q.innerHTML=tt,pt=i(),g(x.$$.fragment),E=i(),g(P.$$.fragment),et=i(),z=m("p"),z.innerHTML=dt,H=i(),K=m("p"),K.innerHTML=ht,F=i(),g(N.$$.fragment),A=i(),lt=m("p"),this.h()},l(t){const r=Vt("svelte-u9bgzb",document.head);n=d(r,"META",{name:!0,content:!0}),r.forEach(l),b=p(t),c=d(t,"P",{}),_t(c).forEach(l),h=p(t),_(u.$$.fragment,t),y=p(t),J=d(t,"P",{"data-svelte-h":!0}),f(J)!=="svelte-hptymg"&&(J.innerHTML=$),w=p(t),G=d(t,"P",{"data-svelte-h":!0}),f(G)!=="svelte-q2xfio"&&(G.textContent=Z),k=p(t),_(j.$$.fragment,t),v=p(t),q=d(t,"P",{"data-svelte-h":!0}),f(q)!=="svelte-ka4w7"&&(q.innerHTML=o),T=p(t),C=d(t,"P",{"data-svelte-h":!0}),f(C)!=="svelte-hxxsaz"&&(C.textContent=L),ot=p(t),_(V.$$.fragment,t),Y=p(t),_(S.$$.fragment,t),D=p(t),M=d(t,"P",{"data-svelte-h":!0}),f(M)!=="svelte-1g3oift"&&(M.innerHTML=O),it=p(t),Q=d(t,"P",{"data-svelte-h":!0}),f(Q)!=="svelte-5ma9bd"&&(Q.innerHTML=tt),pt=p(t),_(x.$$.fragment,t),E=p(t),_(P.$$.fragment,t),et=p(t),z=d(t,"P",{"data-svelte-h":!0}),f(z)!=="svelte-1b589wj"&&(z.innerHTML=dt),H=p(t),K=d(t,"P",{"data-svelte-h":!0}),f(K)!=="svelte-fj0t1q"&&(K.innerHTML=ht),F=p(t),_(N.$$.fragment,t),A=p(t),lt=d(t,"P",{}),_t(lt).forEach(l),this.h()},h(){Rt(n,"name","hf:doc:metadata"),Rt(n,"content",Lt)},m(t,r){R(document.head,n),a(t,b,r),a(t,c,r),a(t,h,r),W(u,t,r),a(t,y,r),a(t,J,r),a(t,w,r),a(t,G,r),a(t,k,r),W(j,t,r),a(t,v,r),a(t,q,r),a(t,T,r),a(t,C,r),a(t,ot,r),W(V,t,r),a(t,Y,r),W(S,t,r),a(t,D,r),a(t,M,r),a(t,it,r),a(t,Q,r),a(t,pt,r),W(x,t,r),a(t,E,r),W(P,t,r),a(t,et,r),a(t,z,r),a(t,H,r),a(t,K,r),a(t,F,r),W(N,t,r),a(t,A,r),a(t,lt,r),at=!0},p(t,[r]){const Mt={};r&2&&(Mt.$$scope={dirty:r,ctx:t}),V.$set(Mt)},i(t){at||(U(u.$$.fragment,t),U(j.$$.fragment,t),U(V.$$.fragment,t),U(S.$$.fragment,t),U(x.$$.fragment,t),U(P.$$.fragment,t),U(N.$$.fragment,t),at=!0)},o(t){X(u.$$.fragment,t),X(j.$$.fragment,t),X(V.$$.fragment,t),X(S.$$.fragment,t),X(x.$$.fragment,t),X(P.$$.fragment,t),X(N.$$.fragment,t),at=!1},d(t){t&&(l(b),l(c),l(h),l(y),l(J),l(w),l(G),l(k),l(v),l(q),l(T),l(C),l(ot),l(Y),l(D),l(M),l(it),l(Q),l(pt),l(E),l(et),l(z),l(H),l(K),l(F),l(A),l(lt)),l(n),I(u,t),I(j,t),I(V,t),I(S,t),I(x,t),I(P,t),I(N,t)}}}const Lt='{"title":"torchao","local":"torchao","sections":[{"title":"Available Quantization Schemes","local":"available-quantization-schemes","sections":[],"depth":2},{"title":"Migration Guide","local":"migration-guide","sections":[],"depth":2},{"title":"Serialization","local":"serialization","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function St(B){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class le extends zt{constructor(n){super(),Bt(this,n,St,At,vt,{})}}export{le as component};
