import{s as Ye,n as Ee,o as Qe}from"../chunks/scheduler.01eeda35.js";import{S as Ne,i as Ae,g as o,s as a,r as p,A as qe,h as i,f as l,c as s,j as Le,u as m,x as r,k as He,y as Se,a as n,v as u,d as f,t as c,w as d}from"../chunks/index.6dd51b66.js";import{C as A}from"../chunks/CodeBlock.19ec9b8c.js";import{D as Pe}from"../chunks/DocNotebookDropdown.dd532469.js";import{H as E,E as De}from"../chunks/index.58fe8f9d.js";function Ke(Xe){let h,q,Q,S,w,P,b,D,T,Ue='<a href="https://openxla.org/xla" rel="nofollow">Accelerated Linear Algebra (XLA)</a> is a linear algebra compiler that optimizes model runtime across different hardware and frameworks.',K,M,je="This guide will look specifically at how to accelerate <em>TensorFlow</em> models with XLA.",O,y,ee,J,Ze='XLA can potentially accelerate a TensorFlow model without making any source code changes. It is already packaged with the TensorFlow library, and it is triggered with <code>jit_compile</code> in any graph creating function such as <a href="https://www.tensorflow.org/api_docs/python/tf/function" rel="nofollow">tf.function</a>.',te,g,Re='If you’re using Keras methods like <a href="https://keras.io/api/models/model_training_apis/#fit-method" rel="nofollow">fit</a> and <a href="https://keras.io/api/models/model_training_apis/#predict-method" rel="nofollow">predict</a>, enable XLA by passing <code>jit_compile=True</code> to <a href="https://keras.io/api/models/model_training_apis/#compile-method" rel="nofollow">compile</a>.',le,_,ne,k,$e='XLA can be used to accelerate any arbitrary <a href="https://www.tensorflow.org/api_docs/python/tf/function" rel="nofollow">tf.function</a>.',ae,X,Ge='Models with a TensorFlow implementation like <a href="./model_doc/gpt2">GPT2</a>, <a href="./model_doc/t5">T5</a>, <a href="./model_doc/opt">OPT</a>, and <a href="./model_doc/whisper">Whisper</a> are XLA compatible. The speed up depends on a model, but in general, TensorFlow models in Transformers get a ~100x speed up.',se,U,oe,j,ve='A typical forward pass in a TensorFlow model is shown below. To run a forward pass with XLA, wrap the model with <a href="https://www.tensorflow.org/api_docs/python/tf/function" rel="nofollow">tf.function</a> and set <code>jit_compile=True</code>.',ie,Z,re,R,Ie='The default <code>call</code> function of the model is used to compile the XLA graph. But if there’s any other model function you want to compile with XLA, wrap them with <a href="https://www.tensorflow.org/api_docs/python/tf/function" rel="nofollow">tf.function</a>.',pe,$,me,G,ue,v,We='You could also compile other model functions with XLA. For example, enable XLA for text generation by wrapping <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.TFGenerationMixin.generate">generate()</a> with <a href="https://www.tensorflow.org/api_docs/python/tf/function" rel="nofollow">tf.function</a>.',fe,I,ce,W,de,x,xe="When executing an XLA-enabled function for the first time, it tries to infer the computation graph in a process known as <em>tracing</em>. This is a time-consuming step, but any consecutive calls to the function will be much faster because it won’t have to trace the computation graph again.",he,F,Fe="To ensure a function is only traced once, the inputs must have the same shape as when the graph was built. This usually isn’t an issue for fixed input shapes like images, but it can be an issue for inputs with variable shapes like text.",we,V,Ve='One way to handle this is to pad your text so it always has the same shape. Configure padding options such as <a href="https://hf.co/docs/transformers/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.pad.pad_to_multiple_of" rel="nofollow">pad_to_multiple_of</a> in the tokenizer.',be,B,Te,C,Be="In addition to the input shape, any changes to the generation options at any point also triggers tracing.",Me,z,ye,L,Ce="Learn more about XLA with the following resources.",Je,H,ze='<li>A <a href="https://colab.research.google.com/github/huggingface/blog/blob/main/notebooks/91_tf_xla_generate.ipynb" rel="nofollow">notebook</a> demonstrating XLA-compatible encoder-decoder and decoder-only text generation models.</li> <li>The <a href="https://hf.co/blog/tf-xla-generate" rel="nofollow">Faster Text Generation with TensorFlow and XLA</a> blog post compares benchmarks for XLA-compatible models and provides a friendly introduction to XLA in TensorFlow.</li> <li>The <a href="https://blog.tensorflow.org/2022/11/how-hugging-face-improved-text-generation-performance-with-xla.html" rel="nofollow">How Hugging Face improved Text Generation performance with XLA</a> blog post discusses the design philosophy behind adding XLA to TensorFlow models in Transformers.</li> <li>The <a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow">Introduction to graphs and tf.function</a> guide.</li> <li>The <a href="https://www.tensorflow.org/guide/function" rel="nofollow">Better performance with tf.function</a> guide.</li> <li>The <a href="https://openxla.org/xla" rel="nofollow">XLA</a> documentation.</li>',ge,Y,_e,N,ke;return w=new E({props:{title:"XLA",local:"xla",headingTag:"h1"}}),b=new Pe({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tf_xla.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/tf_xla.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tf_xla.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/tf_xla.ipynb"}]}}),y=new E({props:{title:"TensorFlow",local:"tensorflow",headingTag:"h2"}}),_=new A({props:{code:"bW9kZWwuY29tcGlsZShqaXRfY29tcGlsZSUzRFRydWUp",highlighted:'model.<span class="hljs-built_in">compile</span>(jit_compile=<span class="hljs-literal">True</span>)',wrap:!1}}),U=new E({props:{title:"Functions",local:"functions",headingTag:"h3"}}),Z=new A({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFtb2RlbCUyMCUzRCUyMHRmLmtlcmFzLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTVCdGYua2VyYXMubGF5ZXJzLkRlbnNlKDEwJTJDJTIwaW5wdXRfc2hhcGUlM0QoMTAlMkMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTIwdGYua2VyYXMubGF5ZXJzLkRlbnNlKDUlMkMlMjBhY3RpdmF0aW9uJTNEJTIyc29mdG1heCUyMiklNUQlMEEpJTBBJTIzJTIwR2VuZXJhdGUlMjByYW5kb20lMjBpbnB1dHMlMjBmb3IlMjB0aGUlMjBtb2RlbC4lMEFiYXRjaF9zaXplJTIwJTNEJTIwMTYlMEFpbnB1dF92ZWN0b3JfZGltJTIwJTNEJTIwMTAlMEFyYW5kb21faW5wdXRzJTIwJTNEJTIwdGYucmFuZG9tLm5vcm1hbCgoYmF0Y2hfc2l6ZSUyQyUyMGlucHV0X3ZlY3Rvcl9kaW0pKSUwQSUwQSUyMyUyMFJ1biUyMGElMjBmb3J3YXJkJTIwcGFzcy4lMEEtJTIwXyUyMCUzRCUyMG1vZGVsKHJhbmRvbV9pbnB1dHMpJTBBJTJCJTIweGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBJTJCJTIwXyUyMCUzRCUyMHhsYV9mbihyYW5kb21faW5wdXRzKQ==",highlighted:`import tensorflow as tf

model = tf.keras.Sequential(
    [tf.keras.layers.Dense(10, input_shape=(10,), activation=&quot;relu&quot;), tf.keras.layers.Dense(5, activation=&quot;softmax&quot;)]
)
# Generate random inputs for the model.
batch_size = 16
input_vector_dim = 10
random_inputs = tf.random.normal((batch_size, input_vector_dim))

# Run a forward pass.
<span class="hljs-deletion">- _ = model(random_inputs)</span>
<span class="hljs-addition">+ xla_fn = tf.function(model, jit_compile=True)</span>
<span class="hljs-addition">+ _ = xla_fn(random_inputs)</span>`,wrap:!1}}),$=new A({props:{code:"bXlfeGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwubXlfeGxhX2ZuJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKQ==",highlighted:'my_xla_fn = tf.function(model.my_xla_fn, jit_compile=<span class="hljs-literal">True</span>)',wrap:!1}}),G=new E({props:{title:"Text generation",local:"text-generation",headingTag:"h3"}}),I=new A({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMjMlMjBXaWxsJTIwZXJyb3IlMjBpZiUyMHRoZSUyMG1pbmltYWwlMjB2ZXJzaW9uJTIwb2YlMjBUcmFuc2Zvcm1lcnMlMjBpcyUyMG5vdCUyMGluc3RhbGxlZC4lMEFmcm9tJTIwdHJhbnNmb3JtZXJzLnV0aWxzJTIwaW1wb3J0JTIwY2hlY2tfbWluX3ZlcnNpb24lMEElMEFjaGVja19taW5fdmVyc2lvbiglMjI0LjIxLjAlMjIpJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wZW5haS1jb21tdW5pdHklMkZncHQyJTIyKSUwQWlucHV0X3N0cmluZyUyMCUzRCUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiU1RCUwQSUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQXRva2VuaXplZF9pbnB1dCUyMCUzRCUyMHRva2VuaXplcihpbnB1dF9zdHJpbmclMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKSUwQWdlbmVyYXRlZF90b2tlbnMlMjAlM0QlMjB4bGFfZ2VuZXJhdGUoKip0b2tlbml6ZWRfaW5wdXQlMkMlMjBudW1fYmVhbXMlM0QyKSUwQSUwQWRlY29kZWRfdGV4dCUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChmJTIyR2VuZXJhdGVkJTIwLS0lMjAlN0JkZWNvZGVkX3RleHQlN0QlMjIpJTBBJTIyR2VuZXJhdGVkJTIwLS0lMjBUZW5zb3JGbG93JTIwaXMlMjBhbiUyMG9wZW4tc291cmNlJTJDJTIwb3Blbi1zb3VyY2UlMkMlMjBkaXN0cmlidXRlZC1zb3VyY2UlMjBhcHBsaWNhdGlvbiUyMGZyYW1ld29yayUyMGZvciUyMHRoZSUyMg==",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM
<span class="hljs-comment"># Will error if the minimal version of Transformers is not installed.</span>
<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> check_min_version

check_min_version(<span class="hljs-string">&quot;4.21.0&quot;</span>)

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

tokenized_input = tokenizer(input_string, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)

decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)
<span class="hljs-string">&quot;Generated -- TensorFlow is an open-source, open-source, distributed-source application framework for the&quot;</span>`,wrap:!1}}),W=new E({props:{title:"Tracing",local:"tracing",headingTag:"h2"}}),B=new A({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcGVuYWktY29tbXVuaXR5JTJGZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpLWNvbW11bml0eSUyRmdwdDIlMjIpJTBBaW5wdXRfc3RyaW5nJTIwJTNEJTIwJTVCJTIyVGVuc29yRmxvdyUyMGlzJTIyJTVEJTBBJTBBeGxhX2dlbmVyYXRlJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwuZ2VuZXJhdGUlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBJTBBJTIzJTIwQ2FsbCUyMHRva2VuaXplciUyMHdpdGglMjBwYWRkaW5nJTIwb3B0aW9ucy4lMEF0b2tlbml6ZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfc3RyaW5nJTJDJTIwcGFkX3RvX211bHRpcGxlX29mJTNEOCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMEFnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIweGxhX2dlbmVyYXRlKCoqdG9rZW5pemVkX2lucHV0JTJDJTIwbnVtX2JlYW1zJTNEMiklMEFkZWNvZGVkX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlNUIwJTVEJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBcHJpbnQoZiUyMkdlbmVyYXRlZCUyMC0tJTIwJTdCZGVjb2RlZF90ZXh0JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;openai-community/gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Call tokenizer with padding options.</span>
tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)`,wrap:!1}}),z=new E({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Y=new De({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tf_xla.md"}}),{c(){h=o("meta"),q=a(),Q=o("p"),S=a(),p(w.$$.fragment),P=a(),p(b.$$.fragment),D=a(),T=o("p"),T.innerHTML=Ue,K=a(),M=o("p"),M.innerHTML=je,O=a(),p(y.$$.fragment),ee=a(),J=o("p"),J.innerHTML=Ze,te=a(),g=o("p"),g.innerHTML=Re,le=a(),p(_.$$.fragment),ne=a(),k=o("p"),k.innerHTML=$e,ae=a(),X=o("p"),X.innerHTML=Ge,se=a(),p(U.$$.fragment),oe=a(),j=o("p"),j.innerHTML=ve,ie=a(),p(Z.$$.fragment),re=a(),R=o("p"),R.innerHTML=Ie,pe=a(),p($.$$.fragment),me=a(),p(G.$$.fragment),ue=a(),v=o("p"),v.innerHTML=We,fe=a(),p(I.$$.fragment),ce=a(),p(W.$$.fragment),de=a(),x=o("p"),x.innerHTML=xe,he=a(),F=o("p"),F.textContent=Fe,we=a(),V=o("p"),V.innerHTML=Ve,be=a(),p(B.$$.fragment),Te=a(),C=o("p"),C.textContent=Be,Me=a(),p(z.$$.fragment),ye=a(),L=o("p"),L.textContent=Ce,Je=a(),H=o("ul"),H.innerHTML=ze,ge=a(),p(Y.$$.fragment),_e=a(),N=o("p"),this.h()},l(e){const t=qe("svelte-u9bgzb",document.head);h=i(t,"META",{name:!0,content:!0}),t.forEach(l),q=s(e),Q=i(e,"P",{}),Le(Q).forEach(l),S=s(e),m(w.$$.fragment,e),P=s(e),m(b.$$.fragment,e),D=s(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1lbryd6"&&(T.innerHTML=Ue),K=s(e),M=i(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-je7bo5"&&(M.innerHTML=je),O=s(e),m(y.$$.fragment,e),ee=s(e),J=i(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-sl3800"&&(J.innerHTML=Ze),te=s(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1psztr3"&&(g.innerHTML=Re),le=s(e),m(_.$$.fragment,e),ne=s(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1np5g0b"&&(k.innerHTML=$e),ae=s(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1axzne2"&&(X.innerHTML=Ge),se=s(e),m(U.$$.fragment,e),oe=s(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-nkyl9h"&&(j.innerHTML=ve),ie=s(e),m(Z.$$.fragment,e),re=s(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-nifpi8"&&(R.innerHTML=Ie),pe=s(e),m($.$$.fragment,e),me=s(e),m(G.$$.fragment,e),ue=s(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-oivvcm"&&(v.innerHTML=We),fe=s(e),m(I.$$.fragment,e),ce=s(e),m(W.$$.fragment,e),de=s(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1mt3fs"&&(x.innerHTML=xe),he=s(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1uqilyq"&&(F.textContent=Fe),we=s(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1wnsyes"&&(V.innerHTML=Ve),be=s(e),m(B.$$.fragment,e),Te=s(e),C=i(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-mwf4im"&&(C.textContent=Be),Me=s(e),m(z.$$.fragment,e),ye=s(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-himkuk"&&(L.textContent=Ce),Je=s(e),H=i(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-dpm7zh"&&(H.innerHTML=ze),ge=s(e),m(Y.$$.fragment,e),_e=s(e),N=i(e,"P",{}),Le(N).forEach(l),this.h()},h(){He(h,"name","hf:doc:metadata"),He(h,"content",Oe)},m(e,t){Se(document.head,h),n(e,q,t),n(e,Q,t),n(e,S,t),u(w,e,t),n(e,P,t),u(b,e,t),n(e,D,t),n(e,T,t),n(e,K,t),n(e,M,t),n(e,O,t),u(y,e,t),n(e,ee,t),n(e,J,t),n(e,te,t),n(e,g,t),n(e,le,t),u(_,e,t),n(e,ne,t),n(e,k,t),n(e,ae,t),n(e,X,t),n(e,se,t),u(U,e,t),n(e,oe,t),n(e,j,t),n(e,ie,t),u(Z,e,t),n(e,re,t),n(e,R,t),n(e,pe,t),u($,e,t),n(e,me,t),u(G,e,t),n(e,ue,t),n(e,v,t),n(e,fe,t),u(I,e,t),n(e,ce,t),u(W,e,t),n(e,de,t),n(e,x,t),n(e,he,t),n(e,F,t),n(e,we,t),n(e,V,t),n(e,be,t),u(B,e,t),n(e,Te,t),n(e,C,t),n(e,Me,t),u(z,e,t),n(e,ye,t),n(e,L,t),n(e,Je,t),n(e,H,t),n(e,ge,t),u(Y,e,t),n(e,_e,t),n(e,N,t),ke=!0},p:Ee,i(e){ke||(f(w.$$.fragment,e),f(b.$$.fragment,e),f(y.$$.fragment,e),f(_.$$.fragment,e),f(U.$$.fragment,e),f(Z.$$.fragment,e),f($.$$.fragment,e),f(G.$$.fragment,e),f(I.$$.fragment,e),f(W.$$.fragment,e),f(B.$$.fragment,e),f(z.$$.fragment,e),f(Y.$$.fragment,e),ke=!0)},o(e){c(w.$$.fragment,e),c(b.$$.fragment,e),c(y.$$.fragment,e),c(_.$$.fragment,e),c(U.$$.fragment,e),c(Z.$$.fragment,e),c($.$$.fragment,e),c(G.$$.fragment,e),c(I.$$.fragment,e),c(W.$$.fragment,e),c(B.$$.fragment,e),c(z.$$.fragment,e),c(Y.$$.fragment,e),ke=!1},d(e){e&&(l(q),l(Q),l(S),l(P),l(D),l(T),l(K),l(M),l(O),l(ee),l(J),l(te),l(g),l(le),l(ne),l(k),l(ae),l(X),l(se),l(oe),l(j),l(ie),l(re),l(R),l(pe),l(me),l(ue),l(v),l(fe),l(ce),l(de),l(x),l(he),l(F),l(we),l(V),l(be),l(Te),l(C),l(Me),l(ye),l(L),l(Je),l(H),l(ge),l(_e),l(N)),l(h),d(w,e),d(b,e),d(y,e),d(_,e),d(U,e),d(Z,e),d($,e),d(G,e),d(I,e),d(W,e),d(B,e),d(z,e),d(Y,e)}}}const Oe='{"title":"XLA","local":"xla","sections":[{"title":"TensorFlow","local":"tensorflow","sections":[{"title":"Functions","local":"functions","sections":[],"depth":3},{"title":"Text generation","local":"text-generation","sections":[],"depth":3}],"depth":2},{"title":"Tracing","local":"tracing","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function et(Xe){return Qe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ot extends Ne{constructor(h){super(),Ae(this,h,et,Ke,Ye,{})}}export{ot as component};
