import{s as _o,A as bo,o as yo,n as Ze}from"../chunks/scheduler.01eeda35.js";import{S as Mo,i as To,g as m,s,r as f,A as vo,h as p,f as a,c as r,j as P,u,x as v,k as J,y as i,a as l,v as _,d as b,t as y,w as M}from"../chunks/index.6dd51b66.js";import{T as Ut}from"../chunks/Tip.de9bae2b.js";import{D as H}from"../chunks/Docstring.cb556860.js";import{C as gt}from"../chunks/CodeBlock.19ec9b8c.js";import{F as wo,M as uo}from"../chunks/Markdown.3138439e.js";import{E as wt}from"../chunks/ExampleCodeBlock.69db56ad.js";import{P as xo}from"../chunks/PipelineTag.5efc345e.js";import{H as _e,E as $o}from"../chunks/index.58fe8f9d.js";function Bo(C){let t,T="Example:",o,d,w;return d=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlaXRDb25maWclMkMlMjBCZWl0TW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQkVpVCUyMGJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBCZWl0Q29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjAod2l0aCUyMHJhbmRvbSUyMHdlaWdodHMpJTIwZnJvbSUyMHRoZSUyMGJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyayUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwQmVpdE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BeitConfig, BeitModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BEiT beit-base-patch16-224-pt22k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = BeitConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the beit-base-patch16-224-pt22k style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(d.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),v(t)!=="svelte-11lpom8"&&(t.textContent=T),o=r(n),u(d.$$.fragment,n)},m(n,$){l(n,t,$),l(n,o,$),_(d,n,$),w=!0},p:Ze,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){y(d.$$.fragment,n),w=!1},d(n){n&&(a(t),a(o)),M(d,n)}}}function Co(C){let t,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=T},l(o){t=p(o,"P",{"data-svelte-h":!0}),v(t)!=="svelte-fincs2"&&(t.innerHTML=T)},m(o,d){l(o,t,d)},p:Ze,d(o){o&&a(t)}}}function jo(C){let t,T="Example:",o,d,w;return d=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRNb2RlbCUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJodWdnaW5nZmFjZSUyRmNhdHMtaW1hZ2UlMjIlMkMlMjB0cnVzdF9yZW1vdGVfY29kZSUzRFRydWUpJTBBaW1hZ2UlMjAlM0QlMjBkYXRhc2V0JTVCJTIydGVzdCUyMiU1RCU1QiUyMmltYWdlJTIyJTVEJTVCMCU1RCUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0LXB0MjJrJTIyKSUwQW1vZGVsJTIwJTNEJTIwQmVpdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQtcHQyMmslMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitModel.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">197</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(d.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),v(t)!=="svelte-11lpom8"&&(t.textContent=T),o=r(n),u(d.$$.fragment,n)},m(n,$){l(n,t,$),l(n,o,$),_(d,n,$),w=!0},p:Ze,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){y(d.$$.fragment,n),w=!1},d(n){n&&(a(t),a(o)),M(d,n)}}}function Fo(C){let t,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=T},l(o){t=p(o,"P",{"data-svelte-h":!0}),v(t)!=="svelte-fincs2"&&(t.innerHTML=T)},m(o,d){l(o,t,d)},p:Ze,d(o){o&&a(t)}}}function Io(C){let t,T="Examples:",o,d,w;return d=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyayUyMiklMEFtb2RlbCUyMCUzRCUyMEJlaXRGb3JNYXNrZWRJbWFnZU1vZGVsaW5nLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQtcHQyMmslMjIpJTBBJTBBbnVtX3BhdGNoZXMlMjAlM0QlMjAobW9kZWwuY29uZmlnLmltYWdlX3NpemUlMjAlMkYlMkYlMjBtb2RlbC5jb25maWcucGF0Y2hfc2l6ZSklMjAqKiUyMDIlMEFwaXhlbF92YWx1ZXMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5waXhlbF92YWx1ZXMlMEElMjMlMjBjcmVhdGUlMjByYW5kb20lMjBib29sZWFuJTIwbWFzayUyMG9mJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9wYXRjaGVzKSUwQWJvb2xfbWFza2VkX3BvcyUyMCUzRCUyMHRvcmNoLnJhbmRpbnQobG93JTNEMCUyQyUyMGhpZ2glM0QyJTJDJTIwc2l6ZSUzRCgxJTJDJTIwbnVtX3BhdGNoZXMpKS5ib29sKCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwocGl4ZWxfdmFsdWVzJTJDJTIwYm9vbF9tYXNrZWRfcG9zJTNEYm9vbF9tYXNrZWRfcG9zKSUwQWxvc3MlMkMlMjBsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvc3MlMkMlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_patches = (model.config.image_size // model.config.patch_size) ** <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create random boolean mask of shape (batch_size, num_patches)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>bool_masked_pos = torch.randint(low=<span class="hljs-number">0</span>, high=<span class="hljs-number">2</span>, size=(<span class="hljs-number">1</span>, num_patches)).<span class="hljs-built_in">bool</span>()

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(pixel_values, bool_masked_pos=bool_masked_pos)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss, logits = outputs.loss, outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">196</span>, <span class="hljs-number">8192</span>]`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(d.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),v(t)!=="svelte-kvfsh7"&&(t.textContent=T),o=r(n),u(d.$$.fragment,n)},m(n,$){l(n,t,$),l(n,o,$),_(d,n,$),w=!0},p:Ze,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){y(d.$$.fragment,n),w=!1},d(n){n&&(a(t),a(o)),M(d,n)}}}function ko(C){let t,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=T},l(o){t=p(o,"P",{"data-svelte-h":!0}),v(t)!=="svelte-fincs2"&&(t.innerHTML=T)},m(o,d){l(o,t,d)},p:Ze,d(o){o&&a(t)}}}function Jo(C){let t,T="Example:",o,d,w;return d=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmh1Z2dpbmdmYWNlJTJGY2F0cy1pbWFnZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSklMEFpbWFnZSUyMCUzRCUyMGRhdGFzZXQlNUIlMjJ0ZXN0JTIyJTVEJTVCJTIyaW1hZ2UlMjIlNUQlNUIwJTVEJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBCZWl0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKS5sb2dpdHMlMEElMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgpJTBBcHJpbnQobW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2xhYmVsJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
tabby, tabby cat`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(d.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),v(t)!=="svelte-11lpom8"&&(t.textContent=T),o=r(n),u(d.$$.fragment,n)},m(n,$){l(n,t,$),l(n,o,$),_(d,n,$),w=!0},p:Ze,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){y(d.$$.fragment,n),w=!1},d(n){n&&(a(t),a(o)),M(d,n)}}}function zo(C){let t,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=T},l(o){t=p(o,"P",{"data-svelte-h":!0}),v(t)!=="svelte-fincs2"&&(t.innerHTML=T)},m(o,d){l(o,t,d)},p:Ze,d(o){o&&a(t)}}}function Wo(C){let t,T="Examples:",o,d,w;return d=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLWZpbmV0dW5lZC1hZGUtNjQwLTY0MCUyMiklMEFtb2RlbCUyMCUzRCUyMEJlaXRGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLWZpbmV0dW5lZC1hZGUtNjQwLTY0MCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjMlMjBsb2dpdHMlMjBhcmUlMjBvZiUyMHNoYXBlJTIwKGJhdGNoX3NpemUlMkMlMjBudW1fbGFiZWxzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGgpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-finetuned-ade-640-640&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-finetuned-ade-640-640&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># logits are of shape (batch_size, num_labels, height, width)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(d.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),v(t)!=="svelte-kvfsh7"&&(t.textContent=T),o=r(n),u(d.$$.fragment,n)},m(n,$){l(n,t,$),l(n,o,$),_(d,n,$),w=!0},p:Ze,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){y(d.$$.fragment,n),w=!1},d(n){n&&(a(t),a(o)),M(d,n)}}}function Uo(C){let t,T,o,d,w,n,$=`The bare Beit Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,it,L,le,qe,D,ft='The <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitModel">BeitModel</a> forward method, overrides the <code>__call__</code> special method.',Ye,R,pt,be,ae,Se,Re,F,de,De,Q,lt=`Beit Model transformer with a ‘language’ modeling head on top. BEiT does masked image modeling by predicting
visual tokens of a Vector-Quantize Variational Autoencoder (VQ-VAE), whereas other vision models like ViT and DeiT
predict RGB pixel values. As a result, this class is incompatible with <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForMaskedImageModeling">AutoModelForMaskedImageModeling</a>, so you
will need to use <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForMaskedImageModeling">BeitForMaskedImageModeling</a> directly if you wish to do masked image modeling with BEiT.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Be,E,Te,O,Ne,Ce='The <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForMaskedImageModeling">BeitForMaskedImageModeling</a> forward method, overrides the <code>__call__</code> special method.',ve,I,we,te,xe,ce,tt,Z,me,dt,pe,Ge=`Beit Model transformer with an image classification head on top (a linear layer on top of the average of the final
hidden states of the patch tokens) e.g. for ImageNet.`,Qe,K,ut=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Oe,W,Ve,Ke,k,je='The <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a> forward method, overrides the <code>__call__</code> special method.',Fe,he,ot,oe,ge,se,Pe,ee,re,ye,ie,Ae="Beit Model transformer with a semantic segmentation head on top e.g. for ADE20k, CityScapes.",Xe,j,Ie=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ke,q,Je,ze,$e,ct='The <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> forward method, overrides the <code>__call__</code> special method.',We,fe,nt,ne,Le;return t=new _e({props:{title:"BeitModel",local:"transformers.BeitModel",headingTag:"h2"}}),d=new H({props:{name:"class transformers.BeitModel",anchor:"transformers.BeitModel",parameters:[{name:"config",val:": BeitConfig"},{name:"add_pooling_layer",val:": bool = True"}],parametersDescription:[{anchor:"transformers.BeitModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L823"}}),le=new H({props:{name:"forward",anchor:"transformers.BeitModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.BeitModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitModel.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.BeitModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitModel.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>, <em>optional</em>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L854",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/beit#transformers.models.beit.modeling_beit.BeitModelOutputWithPooling"
>transformers.models.beit.modeling_beit.BeitModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/beit#transformers.models.beit.modeling_beit.BeitModelOutputWithPooling"
>transformers.models.beit.modeling_beit.BeitModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),R=new Ut({props:{$$slots:{default:[Co]},$$scope:{ctx:C}}}),be=new wt({props:{anchor:"transformers.BeitModel.forward.example",$$slots:{default:[jo]},$$scope:{ctx:C}}}),Se=new _e({props:{title:"BeitForMaskedImageModeling",local:"transformers.BeitForMaskedImageModeling",headingTag:"h2"}}),de=new H({props:{name:"class transformers.BeitForMaskedImageModeling",anchor:"transformers.BeitForMaskedImageModeling",parameters:[{name:"config",val:": BeitConfig"}],parametersDescription:[{anchor:"transformers.BeitForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L936"}}),Te=new H({props:{name:"forward",anchor:"transformers.BeitForMaskedImageModeling.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"bool_masked_pos",val:": typing.Optional[torch.BoolTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.BeitForMaskedImageModeling.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitForMaskedImageModeling.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitForMaskedImageModeling.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitForMaskedImageModeling.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitForMaskedImageModeling.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.BeitForMaskedImageModeling.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitForMaskedImageModeling.forward.bool_masked_pos",description:`<strong>bool_masked_pos</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, num_patches)</code>) &#x2014;
Boolean masked positions. Indicates which patches are masked (1) and which aren&#x2019;t (0).`,name:"bool_masked_pos"},{anchor:"transformers.BeitForMaskedImageModeling.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L957",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.MaskedLMOutput"
>transformers.modeling_outputs.MaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),I=new Ut({props:{$$slots:{default:[Fo]},$$scope:{ctx:C}}}),te=new wt({props:{anchor:"transformers.BeitForMaskedImageModeling.forward.example",$$slots:{default:[Io]},$$scope:{ctx:C}}}),ce=new _e({props:{title:"BeitForImageClassification",local:"transformers.BeitForImageClassification",headingTag:"h2"}}),me=new H({props:{name:"class transformers.BeitForImageClassification",anchor:"transformers.BeitForImageClassification",parameters:[{name:"config",val:": BeitConfig"}],parametersDescription:[{anchor:"transformers.BeitForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L1038"}}),Ve=new H({props:{name:"forward",anchor:"transformers.BeitForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.BeitForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitForImageClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitForImageClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitForImageClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitForImageClassification.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.BeitForImageClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitForImageClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L1058",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),he=new Ut({props:{$$slots:{default:[ko]},$$scope:{ctx:C}}}),oe=new wt({props:{anchor:"transformers.BeitForImageClassification.forward.example",$$slots:{default:[Jo]},$$scope:{ctx:C}}}),se=new _e({props:{title:"BeitForSemanticSegmentation",local:"transformers.BeitForSemanticSegmentation",headingTag:"h2"}}),re=new H({props:{name:"class transformers.BeitForSemanticSegmentation",anchor:"transformers.BeitForSemanticSegmentation",parameters:[{name:"config",val:": BeitConfig"}],parametersDescription:[{anchor:"transformers.BeitForSemanticSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L1364"}}),Je=new H({props:{name:"forward",anchor:"transformers.BeitForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"interpolate_pos_encoding",val:": bool = False"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.BeitForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitFeatureExtractor.__call__">BeitImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.BeitForSemanticSegmentation.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.BeitForSemanticSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BeitForSemanticSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BeitForSemanticSegmentation.forward.interpolate_pos_encoding",description:`<strong>interpolate_pos_encoding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to interpolate the pre-trained position encodings.`,name:"interpolate_pos_encoding"},{anchor:"transformers.BeitForSemanticSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BeitForSemanticSegmentation.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Ground truth semantic segmentation maps for computing the loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels &gt; 1</code>, a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L1422",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SemanticSegmenterOutput"
>transformers.modeling_outputs.SemanticSegmenterOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig"
>BeitConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels, logits_height, logits_width)</code>) — Classification scores for each pixel.</p>
<Tip warning={true}>
<p>The logits returned do not necessarily have the same size as the <code>pixel_values</code> passed as inputs. This is
to avoid doing two interpolations and lose some quality when a user needs to resize the logits to the
original image size as post-processing. You should always check your logits shape and resize as needed.</p>
</Tip>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, patch_size, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.SemanticSegmenterOutput"
>transformers.modeling_outputs.SemanticSegmenterOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),fe=new Ut({props:{$$slots:{default:[zo]},$$scope:{ctx:C}}}),ne=new wt({props:{anchor:"transformers.BeitForSemanticSegmentation.forward.example",$$slots:{default:[Wo]},$$scope:{ctx:C}}}),{c(){f(t.$$.fragment),T=s(),o=m("div"),f(d.$$.fragment),w=s(),n=m("p"),n.innerHTML=$,it=s(),L=m("div"),f(le.$$.fragment),qe=s(),D=m("p"),D.innerHTML=ft,Ye=s(),f(R.$$.fragment),pt=s(),f(be.$$.fragment),ae=s(),f(Se.$$.fragment),Re=s(),F=m("div"),f(de.$$.fragment),De=s(),Q=m("p"),Q.innerHTML=lt,Be=s(),E=m("div"),f(Te.$$.fragment),O=s(),Ne=m("p"),Ne.innerHTML=Ce,ve=s(),f(I.$$.fragment),we=s(),f(te.$$.fragment),xe=s(),f(ce.$$.fragment),tt=s(),Z=m("div"),f(me.$$.fragment),dt=s(),pe=m("p"),pe.textContent=Ge,Qe=s(),K=m("p"),K.innerHTML=ut,Oe=s(),W=m("div"),f(Ve.$$.fragment),Ke=s(),k=m("p"),k.innerHTML=je,Fe=s(),f(he.$$.fragment),ot=s(),f(oe.$$.fragment),ge=s(),f(se.$$.fragment),Pe=s(),ee=m("div"),f(re.$$.fragment),ye=s(),ie=m("p"),ie.textContent=Ae,Xe=s(),j=m("p"),j.innerHTML=Ie,ke=s(),q=m("div"),f(Je.$$.fragment),ze=s(),$e=m("p"),$e.innerHTML=ct,We=s(),f(fe.$$.fragment),nt=s(),f(ne.$$.fragment),this.h()},l(c){u(t.$$.fragment,c),T=r(c),o=p(c,"DIV",{class:!0});var x=P(o);u(d.$$.fragment,x),w=r(x),n=p(x,"P",{"data-svelte-h":!0}),v(n)!=="svelte-1wah8ut"&&(n.innerHTML=$),it=r(x),L=p(x,"DIV",{class:!0});var G=P(L);u(le.$$.fragment,G),qe=r(G),D=p(G,"P",{"data-svelte-h":!0}),v(D)!=="svelte-bro8jz"&&(D.innerHTML=ft),Ye=r(G),u(R.$$.fragment,G),pt=r(G),u(be.$$.fragment,G),G.forEach(a),x.forEach(a),ae=r(c),u(Se.$$.fragment,c),Re=r(c),F=p(c,"DIV",{class:!0});var Y=P(F);u(de.$$.fragment,Y),De=r(Y),Q=p(Y,"P",{"data-svelte-h":!0}),v(Q)!=="svelte-uq2qy7"&&(Q.innerHTML=lt),Be=r(Y),E=p(Y,"DIV",{class:!0});var V=P(E);u(Te.$$.fragment,V),O=r(V),Ne=p(V,"P",{"data-svelte-h":!0}),v(Ne)!=="svelte-wqewd3"&&(Ne.innerHTML=Ce),ve=r(V),u(I.$$.fragment,V),we=r(V),u(te.$$.fragment,V),V.forEach(a),Y.forEach(a),xe=r(c),u(ce.$$.fragment,c),tt=r(c),Z=p(c,"DIV",{class:!0});var z=P(Z);u(me.$$.fragment,z),dt=r(z),pe=p(z,"P",{"data-svelte-h":!0}),v(pe)!=="svelte-83lcss"&&(pe.textContent=Ge),Qe=r(z),K=p(z,"P",{"data-svelte-h":!0}),v(K)!=="svelte-1gjh92c"&&(K.innerHTML=ut),Oe=r(z),W=p(z,"DIV",{class:!0});var U=P(W);u(Ve.$$.fragment,U),Ke=r(U),k=p(U,"P",{"data-svelte-h":!0}),v(k)!=="svelte-x5dkzj"&&(k.innerHTML=je),Fe=r(U),u(he.$$.fragment,U),ot=r(U),u(oe.$$.fragment,U),U.forEach(a),z.forEach(a),ge=r(c),u(se.$$.fragment,c),Pe=r(c),ee=p(c,"DIV",{class:!0});var ue=P(ee);u(re.$$.fragment,ue),ye=r(ue),ie=p(ue,"P",{"data-svelte-h":!0}),v(ie)!=="svelte-olwnwh"&&(ie.textContent=Ae),Xe=r(ue),j=p(ue,"P",{"data-svelte-h":!0}),v(j)!=="svelte-1gjh92c"&&(j.innerHTML=Ie),ke=r(ue),q=p(ue,"DIV",{class:!0});var A=P(q);u(Je.$$.fragment,A),ze=r(A),$e=p(A,"P",{"data-svelte-h":!0}),v($e)!=="svelte-1745vw3"&&($e.innerHTML=ct),We=r(A),u(fe.$$.fragment,A),nt=r(A),u(ne.$$.fragment,A),A.forEach(a),ue.forEach(a),this.h()},h(){J(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(c,x){_(t,c,x),l(c,T,x),l(c,o,x),_(d,o,null),i(o,w),i(o,n),i(o,it),i(o,L),_(le,L,null),i(L,qe),i(L,D),i(L,Ye),_(R,L,null),i(L,pt),_(be,L,null),l(c,ae,x),_(Se,c,x),l(c,Re,x),l(c,F,x),_(de,F,null),i(F,De),i(F,Q),i(F,Be),i(F,E),_(Te,E,null),i(E,O),i(E,Ne),i(E,ve),_(I,E,null),i(E,we),_(te,E,null),l(c,xe,x),_(ce,c,x),l(c,tt,x),l(c,Z,x),_(me,Z,null),i(Z,dt),i(Z,pe),i(Z,Qe),i(Z,K),i(Z,Oe),i(Z,W),_(Ve,W,null),i(W,Ke),i(W,k),i(W,Fe),_(he,W,null),i(W,ot),_(oe,W,null),l(c,ge,x),_(se,c,x),l(c,Pe,x),l(c,ee,x),_(re,ee,null),i(ee,ye),i(ee,ie),i(ee,Xe),i(ee,j),i(ee,ke),i(ee,q),_(Je,q,null),i(q,ze),i(q,$e),i(q,We),_(fe,q,null),i(q,nt),_(ne,q,null),Le=!0},p(c,x){const G={};x&2&&(G.$$scope={dirty:x,ctx:c}),R.$set(G);const Y={};x&2&&(Y.$$scope={dirty:x,ctx:c}),be.$set(Y);const V={};x&2&&(V.$$scope={dirty:x,ctx:c}),I.$set(V);const z={};x&2&&(z.$$scope={dirty:x,ctx:c}),te.$set(z);const U={};x&2&&(U.$$scope={dirty:x,ctx:c}),he.$set(U);const ue={};x&2&&(ue.$$scope={dirty:x,ctx:c}),oe.$set(ue);const A={};x&2&&(A.$$scope={dirty:x,ctx:c}),fe.$set(A);const Ue={};x&2&&(Ue.$$scope={dirty:x,ctx:c}),ne.$set(Ue)},i(c){Le||(b(t.$$.fragment,c),b(d.$$.fragment,c),b(le.$$.fragment,c),b(R.$$.fragment,c),b(be.$$.fragment,c),b(Se.$$.fragment,c),b(de.$$.fragment,c),b(Te.$$.fragment,c),b(I.$$.fragment,c),b(te.$$.fragment,c),b(ce.$$.fragment,c),b(me.$$.fragment,c),b(Ve.$$.fragment,c),b(he.$$.fragment,c),b(oe.$$.fragment,c),b(se.$$.fragment,c),b(re.$$.fragment,c),b(Je.$$.fragment,c),b(fe.$$.fragment,c),b(ne.$$.fragment,c),Le=!0)},o(c){y(t.$$.fragment,c),y(d.$$.fragment,c),y(le.$$.fragment,c),y(R.$$.fragment,c),y(be.$$.fragment,c),y(Se.$$.fragment,c),y(de.$$.fragment,c),y(Te.$$.fragment,c),y(I.$$.fragment,c),y(te.$$.fragment,c),y(ce.$$.fragment,c),y(me.$$.fragment,c),y(Ve.$$.fragment,c),y(he.$$.fragment,c),y(oe.$$.fragment,c),y(se.$$.fragment,c),y(re.$$.fragment,c),y(Je.$$.fragment,c),y(fe.$$.fragment,c),y(ne.$$.fragment,c),Le=!1},d(c){c&&(a(T),a(o),a(ae),a(Re),a(F),a(xe),a(tt),a(Z),a(ge),a(Pe),a(ee)),M(t,c),M(d),M(le),M(R),M(be),M(Se,c),M(de),M(Te),M(I),M(te),M(ce,c),M(me),M(Ve),M(he),M(oe),M(se,c),M(re),M(Je),M(fe),M(ne)}}}function Zo(C){let t,T;return t=new uo({props:{$$slots:{default:[Uo]},$$scope:{ctx:C}}}),{c(){f(t.$$.fragment)},l(o){u(t.$$.fragment,o)},m(o,d){_(t,o,d),T=!0},p(o,d){const w={};d&2&&(w.$$scope={dirty:d,ctx:o}),t.$set(w)},i(o){T||(b(t.$$.fragment,o),T=!0)},o(o){y(t.$$.fragment,o),T=!1},d(o){M(t,o)}}}function No(C){let t,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=T},l(o){t=p(o,"P",{"data-svelte-h":!0}),v(t)!=="svelte-fincs2"&&(t.innerHTML=T)},m(o,d){l(o,t,d)},p:Ze,d(o){o&&a(t)}}}function Po(C){let t,T="Examples:",o,d,w;return d=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEZsYXhCZWl0TW9kZWwlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyay1mdDIyayUyMiklMEFtb2RlbCUyMCUzRCUyMEZsYXhCZWl0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJlaXQtYmFzZS1wYXRjaDE2LTIyNC1wdDIyay1mdDIyayUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, FlaxBeitModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k-ft22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxBeitModel.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k-ft22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(d.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),v(t)!=="svelte-kvfsh7"&&(t.textContent=T),o=r(n),u(d.$$.fragment,n)},m(n,$){l(n,t,$),l(n,o,$),_(d,n,$),w=!0},p:Ze,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){y(d.$$.fragment,n),w=!1},d(n){n&&(a(t),a(o)),M(d,n)}}}function Lo(C){let t,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=T},l(o){t=p(o,"P",{"data-svelte-h":!0}),v(t)!=="svelte-fincs2"&&(t.innerHTML=T)},m(o,d){l(o,t,d)},p:Ze,d(o){o&&a(t)}}}function Eo(C){let t,T="Examples:",o,d,w;return d=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEJlaXRGb3JNYXNrZWRJbWFnZU1vZGVsaW5nJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQtcHQyMmslMjIpJTBBbW9kZWwlMjAlM0QlMjBCZWl0Rm9yTWFza2VkSW1hZ2VNb2RlbGluZy5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0LXB0MjJrJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, BeitForMaskedImageModeling
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BeitForMaskedImageModeling.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224-pt22k&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(d.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),v(t)!=="svelte-kvfsh7"&&(t.textContent=T),o=r(n),u(d.$$.fragment,n)},m(n,$){l(n,t,$),l(n,o,$),_(d,n,$),w=!0},p:Ze,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){y(d.$$.fragment,n),w=!1},d(n){n&&(a(t),a(o)),M(d,n)}}}function So(C){let t,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=m("p"),t.innerHTML=T},l(o){t=p(o,"P",{"data-svelte-h":!0}),v(t)!=="svelte-fincs2"&&(t.innerHTML=T)},m(o,d){l(o,t,d)},p:Ze,d(o){o&&a(t)}}}function Ro(C){let t,T="Example:",o,d,w;return d=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEZsYXhCZWl0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwRmxheEJlaXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiZWl0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, FlaxBeitForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FlaxBeitForImageClassification.from_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])`,wrap:!1}}),{c(){t=m("p"),t.textContent=T,o=s(),f(d.$$.fragment)},l(n){t=p(n,"P",{"data-svelte-h":!0}),v(t)!=="svelte-11lpom8"&&(t.textContent=T),o=r(n),u(d.$$.fragment,n)},m(n,$){l(n,t,$),l(n,o,$),_(d,n,$),w=!0},p:Ze,i(n){w||(b(d.$$.fragment,n),w=!0)},o(n){y(d.$$.fragment,n),w=!1},d(n){n&&(a(t),a(o)),M(d,n)}}}function Go(C){let t,T,o,d,w,n,$="The bare Beit Model transformer outputting raw hidden-states without any specific head on top.",it,L,le=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,qe,D,ft=`This model is also a
<a href="https://flax.readthedocs.io/en/latest/api_reference/flax.linen/module.html" rel="nofollow">flax.linen.Module</a> subclass. Use it as
a regular Flax linen Module and refer to the Flax documentation for all matter related to general usage and
behavior.`,Ye,R,pt="Finally, this model supports inherent JAX features such as:",be,ae,Se='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Re,F,de,De,Q,lt="The <code>FlaxBeitPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",Be,E,Te,O,Ne,Ce,ve,I,we,te,xe,ce="Beit Model transformer with a ‘language’ modeling head on top (to predict visual tokens).",tt,Z,me=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,dt,pe,Ge=`This model is also a
<a href="https://flax.readthedocs.io/en/latest/api_reference/flax.linen/module.html" rel="nofollow">flax.linen.Module</a> subclass. Use it as
a regular Flax linen Module and refer to the Flax documentation for all matter related to general usage and
behavior.`,Qe,K,ut="Finally, this model supports inherent JAX features such as:",Oe,W,Ve='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',Ke,k,je,Fe,he,ot="The <code>FlaxBeitPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",oe,ge,se,Pe,ee=`bool_masked_pos (<code>numpy.ndarray</code> of shape <code>(batch_size, num_patches)</code>):
Boolean masked positions. Indicates which patches are masked (1) and which aren’t (0).`,re,ye,ie,Ae,Xe,j,Ie,ke,q,Je=`Beit Model transformer with an image classification head on top (a linear layer on top of the average of the final
hidden states of the patch tokens) e.g. for ImageNet.`,ze,$e,ct=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading, saving and converting weights from PyTorch models)`,We,fe,nt=`This model is also a
<a href="https://flax.readthedocs.io/en/latest/api_reference/flax.linen/module.html" rel="nofollow">flax.linen.Module</a> subclass. Use it as
a regular Flax linen Module and refer to the Flax documentation for all matter related to general usage and
behavior.`,ne,Le,c="Finally, this model supports inherent JAX features such as:",x,G,Y='<li><a href="https://jax.readthedocs.io/en/latest/jax.html#just-in-time-compilation-jit" rel="nofollow">Just-In-Time (JIT) compilation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#automatic-differentiation" rel="nofollow">Automatic Differentiation</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#vectorization-vmap" rel="nofollow">Vectorization</a></li> <li><a href="https://jax.readthedocs.io/en/latest/jax.html#parallelization-pmap" rel="nofollow">Parallelization</a></li>',V,z,U,ue,A,Ue="The <code>FlaxBeitPreTrainedModel</code> forward method, overrides the <code>__call__</code> special method.",at,et,mt,st,ht;return t=new _e({props:{title:"FlaxBeitModel",local:"transformers.FlaxBeitModel",headingTag:"h2"}}),d=new H({props:{name:"class transformers.FlaxBeitModel",anchor:"transformers.FlaxBeitModel",parameters:[{name:"config",val:": BeitConfig"},{name:"input_shape",val:" = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxBeitModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxBeitModel.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_flax_beit.py#L741"}}),de=new H({props:{name:"__call__",anchor:"transformers.FlaxBeitModel.__call__",parameters:[{name:"pixel_values",val:""},{name:"bool_masked_pos",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": <function PRNGKey at 0x7fb5f69e4e50> = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_flax_beit.py#L632",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/model_doc/beit#transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling"
>transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.beit.configuration_beit.BeitConfig'&gt;</code>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) — Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.</li>
<li><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer plus
the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/beit#transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling"
>transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new Ut({props:{$$slots:{default:[No]},$$scope:{ctx:C}}}),O=new wt({props:{anchor:"transformers.FlaxBeitModel.__call__.example",$$slots:{default:[Po]},$$scope:{ctx:C}}}),Ce=new _e({props:{title:"FlaxBeitForMaskedImageModeling",local:"transformers.FlaxBeitForMaskedImageModeling",headingTag:"h2"}}),we=new H({props:{name:"class transformers.FlaxBeitForMaskedImageModeling",anchor:"transformers.FlaxBeitForMaskedImageModeling",parameters:[{name:"config",val:": BeitConfig"},{name:"input_shape",val:" = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxBeitForMaskedImageModeling.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxBeitForMaskedImageModeling.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_flax_beit.py#L825"}}),je=new H({props:{name:"__call__",anchor:"transformers.FlaxBeitForMaskedImageModeling.__call__",parameters:[{name:"pixel_values",val:""},{name:"bool_masked_pos",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": <function PRNGKey at 0x7fb5f69e4e50> = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_flax_beit.py#L632",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"
>transformers.modeling_flax_outputs.FlaxMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.beit.configuration_beit.BeitConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxMaskedLMOutput"
>transformers.modeling_flax_outputs.FlaxMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ge=new Ut({props:{$$slots:{default:[Lo]},$$scope:{ctx:C}}}),ye=new wt({props:{anchor:"transformers.FlaxBeitForMaskedImageModeling.__call__.example",$$slots:{default:[Eo]},$$scope:{ctx:C}}}),Ae=new _e({props:{title:"FlaxBeitForImageClassification",local:"transformers.FlaxBeitForImageClassification",headingTag:"h2"}}),Ie=new H({props:{name:"class transformers.FlaxBeitForImageClassification",anchor:"transformers.FlaxBeitForImageClassification",parameters:[{name:"config",val:": BeitConfig"},{name:"input_shape",val:" = None"},{name:"seed",val:": int = 0"},{name:"dtype",val:": dtype = <class 'jax.numpy.float32'>"},{name:"_do_init",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxBeitForImageClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.FlaxBeitForImageClassification.dtype",description:`<strong>dtype</strong> (<code>jax.numpy.dtype</code>, <em>optional</em>, defaults to <code>jax.numpy.float32</code>) &#x2014;
The data type of the computation. Can be one of <code>jax.numpy.float32</code>, <code>jax.numpy.float16</code> (on GPUs) and
<code>jax.numpy.bfloat16</code> (on TPUs).</p>
<p>This can be used to enable mixed-precision training or half-precision inference on GPUs or TPUs. If
specified all the computation will be performed with the given <code>dtype</code>.</p>
<p><strong>Note that this only specifies the dtype of the computation and does not influence the dtype of model
parameters.</strong></p>
<p>If you wish to change the dtype of the model parameters, see <a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_fp16">to_fp16()</a> and
<a href="/docs/transformers/main/en/main_classes/model#transformers.FlaxPreTrainedModel.to_bf16">to_bf16()</a>.`,name:"dtype"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_flax_beit.py#L909"}}),U=new H({props:{name:"__call__",anchor:"transformers.FlaxBeitForImageClassification.__call__",parameters:[{name:"pixel_values",val:""},{name:"bool_masked_pos",val:" = None"},{name:"params",val:": dict = None"},{name:"dropout_rng",val:": <function PRNGKey at 0x7fb5f69e4e50> = None"},{name:"train",val:": bool = False"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_flax_beit.py#L632",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput"
>transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<code>&lt;class 'transformers.models.beit.configuration_beit.BeitConfig'&gt;</code>) and inputs.</p>
<ul>
<li>
<p><strong>logits</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput"
>transformers.modeling_flax_outputs.FlaxSequenceClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),et=new Ut({props:{$$slots:{default:[So]},$$scope:{ctx:C}}}),st=new wt({props:{anchor:"transformers.FlaxBeitForImageClassification.__call__.example",$$slots:{default:[Ro]},$$scope:{ctx:C}}}),{c(){f(t.$$.fragment),T=s(),o=m("div"),f(d.$$.fragment),w=s(),n=m("p"),n.textContent=$,it=s(),L=m("p"),L.innerHTML=le,qe=s(),D=m("p"),D.innerHTML=ft,Ye=s(),R=m("p"),R.textContent=pt,be=s(),ae=m("ul"),ae.innerHTML=Se,Re=s(),F=m("div"),f(de.$$.fragment),De=s(),Q=m("p"),Q.innerHTML=lt,Be=s(),f(E.$$.fragment),Te=s(),f(O.$$.fragment),Ne=s(),f(Ce.$$.fragment),ve=s(),I=m("div"),f(we.$$.fragment),te=s(),xe=m("p"),xe.textContent=ce,tt=s(),Z=m("p"),Z.innerHTML=me,dt=s(),pe=m("p"),pe.innerHTML=Ge,Qe=s(),K=m("p"),K.textContent=ut,Oe=s(),W=m("ul"),W.innerHTML=Ve,Ke=s(),k=m("div"),f(je.$$.fragment),Fe=s(),he=m("p"),he.innerHTML=ot,oe=s(),f(ge.$$.fragment),se=s(),Pe=m("p"),Pe.innerHTML=ee,re=s(),f(ye.$$.fragment),ie=s(),f(Ae.$$.fragment),Xe=s(),j=m("div"),f(Ie.$$.fragment),ke=s(),q=m("p"),q.textContent=Je,ze=s(),$e=m("p"),$e.innerHTML=ct,We=s(),fe=m("p"),fe.innerHTML=nt,ne=s(),Le=m("p"),Le.textContent=c,x=s(),G=m("ul"),G.innerHTML=Y,V=s(),z=m("div"),f(U.$$.fragment),ue=s(),A=m("p"),A.innerHTML=Ue,at=s(),f(et.$$.fragment),mt=s(),f(st.$$.fragment),this.h()},l(g){u(t.$$.fragment,g),T=r(g),o=p(g,"DIV",{class:!0});var B=P(o);u(d.$$.fragment,B),w=r(B),n=p(B,"P",{"data-svelte-h":!0}),v(n)!=="svelte-yakhoj"&&(n.textContent=$),it=r(B),L=p(B,"P",{"data-svelte-h":!0}),v(L)!=="svelte-3daxed"&&(L.innerHTML=le),qe=r(B),D=p(B,"P",{"data-svelte-h":!0}),v(D)!=="svelte-10nfsf3"&&(D.innerHTML=ft),Ye=r(B),R=p(B,"P",{"data-svelte-h":!0}),v(R)!=="svelte-1pplc4a"&&(R.textContent=pt),be=r(B),ae=p(B,"UL",{"data-svelte-h":!0}),v(ae)!=="svelte-1w7z84m"&&(ae.innerHTML=Se),Re=r(B),F=p(B,"DIV",{class:!0});var X=P(F);u(de.$$.fragment,X),De=r(X),Q=p(X,"P",{"data-svelte-h":!0}),v(Q)!=="svelte-15yd1qb"&&(Q.innerHTML=lt),Be=r(X),u(E.$$.fragment,X),Te=r(X),u(O.$$.fragment,X),X.forEach(a),B.forEach(a),Ne=r(g),u(Ce.$$.fragment,g),ve=r(g),I=p(g,"DIV",{class:!0});var N=P(I);u(we.$$.fragment,N),te=r(N),xe=p(N,"P",{"data-svelte-h":!0}),v(xe)!=="svelte-1xpbgj8"&&(xe.textContent=ce),tt=r(N),Z=p(N,"P",{"data-svelte-h":!0}),v(Z)!=="svelte-3daxed"&&(Z.innerHTML=me),dt=r(N),pe=p(N,"P",{"data-svelte-h":!0}),v(pe)!=="svelte-10nfsf3"&&(pe.innerHTML=Ge),Qe=r(N),K=p(N,"P",{"data-svelte-h":!0}),v(K)!=="svelte-1pplc4a"&&(K.textContent=ut),Oe=r(N),W=p(N,"UL",{"data-svelte-h":!0}),v(W)!=="svelte-1w7z84m"&&(W.innerHTML=Ve),Ke=r(N),k=p(N,"DIV",{class:!0});var Me=P(k);u(je.$$.fragment,Me),Fe=r(Me),he=p(Me,"P",{"data-svelte-h":!0}),v(he)!=="svelte-15yd1qb"&&(he.innerHTML=ot),oe=r(Me),u(ge.$$.fragment,Me),se=r(Me),Pe=p(Me,"P",{"data-svelte-h":!0}),v(Pe)!=="svelte-1rn5vq7"&&(Pe.innerHTML=ee),re=r(Me),u(ye.$$.fragment,Me),Me.forEach(a),N.forEach(a),ie=r(g),u(Ae.$$.fragment,g),Xe=r(g),j=p(g,"DIV",{class:!0});var S=P(j);u(Ie.$$.fragment,S),ke=r(S),q=p(S,"P",{"data-svelte-h":!0}),v(q)!=="svelte-83lcss"&&(q.textContent=Je),ze=r(S),$e=p(S,"P",{"data-svelte-h":!0}),v($e)!=="svelte-3daxed"&&($e.innerHTML=ct),We=r(S),fe=p(S,"P",{"data-svelte-h":!0}),v(fe)!=="svelte-10nfsf3"&&(fe.innerHTML=nt),ne=r(S),Le=p(S,"P",{"data-svelte-h":!0}),v(Le)!=="svelte-1pplc4a"&&(Le.textContent=c),x=r(S),G=p(S,"UL",{"data-svelte-h":!0}),v(G)!=="svelte-1w7z84m"&&(G.innerHTML=Y),V=r(S),z=p(S,"DIV",{class:!0});var Ee=P(z);u(U.$$.fragment,Ee),ue=r(Ee),A=p(Ee,"P",{"data-svelte-h":!0}),v(A)!=="svelte-15yd1qb"&&(A.innerHTML=Ue),at=r(Ee),u(et.$$.fragment,Ee),mt=r(Ee),u(st.$$.fragment,Ee),Ee.forEach(a),S.forEach(a),this.h()},h(){J(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(o,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(g,B){_(t,g,B),l(g,T,B),l(g,o,B),_(d,o,null),i(o,w),i(o,n),i(o,it),i(o,L),i(o,qe),i(o,D),i(o,Ye),i(o,R),i(o,be),i(o,ae),i(o,Re),i(o,F),_(de,F,null),i(F,De),i(F,Q),i(F,Be),_(E,F,null),i(F,Te),_(O,F,null),l(g,Ne,B),_(Ce,g,B),l(g,ve,B),l(g,I,B),_(we,I,null),i(I,te),i(I,xe),i(I,tt),i(I,Z),i(I,dt),i(I,pe),i(I,Qe),i(I,K),i(I,Oe),i(I,W),i(I,Ke),i(I,k),_(je,k,null),i(k,Fe),i(k,he),i(k,oe),_(ge,k,null),i(k,se),i(k,Pe),i(k,re),_(ye,k,null),l(g,ie,B),_(Ae,g,B),l(g,Xe,B),l(g,j,B),_(Ie,j,null),i(j,ke),i(j,q),i(j,ze),i(j,$e),i(j,We),i(j,fe),i(j,ne),i(j,Le),i(j,x),i(j,G),i(j,V),i(j,z),_(U,z,null),i(z,ue),i(z,A),i(z,at),_(et,z,null),i(z,mt),_(st,z,null),ht=!0},p(g,B){const X={};B&2&&(X.$$scope={dirty:B,ctx:g}),E.$set(X);const N={};B&2&&(N.$$scope={dirty:B,ctx:g}),O.$set(N);const Me={};B&2&&(Me.$$scope={dirty:B,ctx:g}),ge.$set(Me);const S={};B&2&&(S.$$scope={dirty:B,ctx:g}),ye.$set(S);const Ee={};B&2&&(Ee.$$scope={dirty:B,ctx:g}),et.$set(Ee);const Zt={};B&2&&(Zt.$$scope={dirty:B,ctx:g}),st.$set(Zt)},i(g){ht||(b(t.$$.fragment,g),b(d.$$.fragment,g),b(de.$$.fragment,g),b(E.$$.fragment,g),b(O.$$.fragment,g),b(Ce.$$.fragment,g),b(we.$$.fragment,g),b(je.$$.fragment,g),b(ge.$$.fragment,g),b(ye.$$.fragment,g),b(Ae.$$.fragment,g),b(Ie.$$.fragment,g),b(U.$$.fragment,g),b(et.$$.fragment,g),b(st.$$.fragment,g),ht=!0)},o(g){y(t.$$.fragment,g),y(d.$$.fragment,g),y(de.$$.fragment,g),y(E.$$.fragment,g),y(O.$$.fragment,g),y(Ce.$$.fragment,g),y(we.$$.fragment,g),y(je.$$.fragment,g),y(ge.$$.fragment,g),y(ye.$$.fragment,g),y(Ae.$$.fragment,g),y(Ie.$$.fragment,g),y(U.$$.fragment,g),y(et.$$.fragment,g),y(st.$$.fragment,g),ht=!1},d(g){g&&(a(T),a(o),a(Ne),a(ve),a(I),a(ie),a(Xe),a(j)),M(t,g),M(d),M(de),M(E),M(O),M(Ce,g),M(we),M(je),M(ge),M(ye),M(Ae,g),M(Ie),M(U),M(et),M(st)}}}function Vo(C){let t,T;return t=new uo({props:{$$slots:{default:[Go]},$$scope:{ctx:C}}}),{c(){f(t.$$.fragment)},l(o){u(t.$$.fragment,o)},m(o,d){_(t,o,d),T=!0},p(o,d){const w={};d&2&&(w.$$scope={dirty:d,ctx:o}),t.$set(w)},i(o){T||(b(t.$$.fragment,o),T=!0)},o(o){y(t.$$.fragment,o),T=!1},d(o){M(t,o)}}}function Ao(C){let t,T,o,d,w,n,$,it=`<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="Flax" src="https://img.shields.io/badge/Flax-29a79b.svg?style=flat&amp;logo=data:image/png;base64,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
"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>`,L,le,qe,D,ft=`The BEiT model was proposed in <a href="https://arxiv.org/abs/2106.08254" rel="nofollow">BEiT: BERT Pre-Training of Image Transformers</a> by
Hangbo Bao, Li Dong and Furu Wei. Inspired by BERT, BEiT is the first paper that makes self-supervised pre-training of
Vision Transformers (ViTs) outperform supervised pre-training. Rather than pre-training the model to predict the class
of an image (as done in the <a href="https://arxiv.org/abs/2010.11929" rel="nofollow">original ViT paper</a>), BEiT models are pre-trained to
predict visual tokens from the codebook of OpenAI’s <a href="https://arxiv.org/abs/2102.12092" rel="nofollow">DALL-E model</a> given masked
patches.`,Ye,R,pt="The abstract from the paper is the following:",be,ae,Se=`<em>We introduce a self-supervised vision representation model BEiT, which stands for Bidirectional Encoder representation
from Image Transformers. Following BERT developed in the natural language processing area, we propose a masked image
modeling task to pretrain vision Transformers. Specifically, each image has two views in our pre-training, i.e, image
patches (such as 16x16 pixels), and visual tokens (i.e., discrete tokens). We first “tokenize” the original image into
visual tokens. Then we randomly mask some image patches and fed them into the backbone Transformer. The pre-training
objective is to recover the original visual tokens based on the corrupted image patches. After pre-training BEiT, we
directly fine-tune the model parameters on downstream tasks by appending task layers upon the pretrained encoder.
Experimental results on image classification and semantic segmentation show that our model achieves competitive results
with previous pre-training methods. For example, base-size BEiT achieves 83.2% top-1 accuracy on ImageNet-1K,
significantly outperforming from-scratch DeiT training (81.8%) with the same setup. Moreover, large-size BEiT obtains
86.3% only using ImageNet-1K, even outperforming ViT-L with supervised pre-training on ImageNet-22K (85.2%).</em>`,Re,F,de=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The JAX/FLAX version of this model was
contributed by <a href="https://huggingface.co/kamalkraj" rel="nofollow">kamalkraj</a>. The original code can be found <a href="https://github.com/microsoft/unilm/tree/master/beit" rel="nofollow">here</a>.`,De,Q,lt,Be,E=`<li>BEiT models are regular Vision Transformers, but pre-trained in a self-supervised way rather than supervised. They
outperform both the <a href="vit">original model (ViT)</a> as well as <a href="deit">Data-efficient Image Transformers (DeiT)</a> when fine-tuned on ImageNet-1K and CIFAR-100. You can check out demo notebooks regarding inference as well as
fine-tuning on custom data <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/VisionTransformer" rel="nofollow">here</a> (you can just replace
<a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor">ViTFeatureExtractor</a> by <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> and
<a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTForImageClassification">ViTForImageClassification</a> by <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a>).</li> <li>There’s also a demo notebook available which showcases how to combine DALL-E’s image tokenizer with BEiT for
performing masked image modeling. You can find it <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/BEiT" rel="nofollow">here</a>.</li> <li>As the BEiT models expect each image to be of the same size (resolution), one can use
<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitImageProcessor">BeitImageProcessor</a> to resize (or rescale) and normalize images for the model.</li> <li>Both the patch resolution and image resolution used during pre-training or fine-tuning are reflected in the name of
each checkpoint. For example, <code>microsoft/beit-base-patch16-224</code> refers to a base-sized architecture with patch
resolution of 16x16 and fine-tuning resolution of 224x224. All checkpoints can be found on the <a href="https://huggingface.co/models?search=microsoft/beit" rel="nofollow">hub</a>.</li> <li>The available checkpoints are either (1) pre-trained on <a href="http://www.image-net.org/" rel="nofollow">ImageNet-22k</a> (a collection of
14 million images and 22k classes) only, (2) also fine-tuned on ImageNet-22k or (3) also fine-tuned on <a href="http://www.image-net.org/challenges/LSVRC/2012/" rel="nofollow">ImageNet-1k</a> (also referred to as ILSVRC 2012, a collection of 1.3 million
images and 1,000 classes).</li> <li>BEiT uses relative position embeddings, inspired by the T5 model. During pre-training, the authors shared the
relative position bias among the several self-attention layers. During fine-tuning, each layer’s relative position
bias is initialized with the shared relative position bias obtained after pre-training. Note that, if one wants to
pre-train a model from scratch, one needs to either set the <code>use_relative_position_bias</code> or the
<code>use_relative_position_bias</code> attribute of <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitConfig">BeitConfig</a> to <code>True</code> in order to add
position embeddings.</li>`,Te,O,Ne,Ce,ve,I='BEiT pre-training. Taken from the <a href="https://arxiv.org/abs/2106.08254">original paper.</a>',we,te,xe,ce,tt=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,Z,me,dt=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,pe,Ge,Qe,K,ut="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",Oe,W,Ve=`On a local benchmark (NVIDIA GeForce RTX 2060-8GB, PyTorch 2.5.1, OS Ubuntu 20.04) with <code>float16</code> and
<code>microsoft/beit-base-patch16-224</code> model, we saw the following improvements during training and inference:`,Ke,k,je,Fe,he="<thead><tr><th>num_training_steps</th> <th>batch_size</th> <th>image_size</th> <th>is_cuda</th> <th>Time per batch (eager - s)</th> <th>Time per batch (sdpa - s)</th> <th>Speedup (%)</th> <th>Eager peak mem (MB)</th> <th>SDPA peak mem (MB)</th> <th>Mem saving (%)</th></tr></thead> <tbody><tr><td>50</td> <td>2</td> <td>(1048, 640)</td> <td>True</td> <td>0.984</td> <td>0.746</td> <td>31.975</td> <td>6738.915</td> <td>4319.886</td> <td>55.998</td></tr></tbody>",ot,oe,ge,se,Pe='<thead><tr><th align="right">Image batch size</th> <th align="right">Eager (s/iter)</th> <th align="left">Eager CI, %</th> <th align="right">Eager memory (MB)</th> <th align="right">SDPA (s/iter)</th> <th align="left">SDPA CI, %</th> <th align="right">SDPA memory (MB)</th> <th align="right">SDPA speedup</th> <th align="right">SDPA memory saved (%)</th></tr></thead> <tbody><tr><td align="right">1</td> <td align="right">0.012</td> <td align="left">±0.3%</td> <td align="right">3.76657e+08</td> <td align="right">0.011</td> <td align="left">±0.5%</td> <td align="right">3.75739e+08</td> <td align="right">1.05</td> <td align="right">0.244</td></tr> <tr><td align="right">4</td> <td align="right">0.013</td> <td align="left">±0.1%</td> <td align="right">4.03147e+08</td> <td align="right">0.011</td> <td align="left">±0.2%</td> <td align="right">3.90554e+08</td> <td align="right">1.178</td> <td align="right">3.225</td></tr> <tr><td align="right">16</td> <td align="right">0.045</td> <td align="left">±0.1%</td> <td align="right">4.96697e+08</td> <td align="right">0.035</td> <td align="left">±0.1%</td> <td align="right">4.51232e+08</td> <td align="right">1.304</td> <td align="right">10.076</td></tr> <tr><td align="right">32</td> <td align="right">0.088</td> <td align="left">±0.1%</td> <td align="right">6.24417e+08</td> <td align="right">0.066</td> <td align="left">±0.1%</td> <td align="right">5.33488e+08</td> <td align="right">1.325</td> <td align="right">17.044</td></tr></tbody>',ee,re,ye,ie,Ae="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with BEiT.",Xe,j,Ie,ke,q='<li><a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForImageClassification">BeitForImageClassification</a> is supported by this <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/image-classification" rel="nofollow">example script</a> and <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/image_classification.ipynb" rel="nofollow">notebook</a>.</li> <li>See also: <a href="../tasks/image_classification">Image classification task guide</a></li>',Je,ze,$e="<strong>Semantic segmentation</strong>",ct,We,fe='<li><a href="../tasks/semantic_segmentation">Semantic segmentation task guide</a></li>',nt,ne,Le="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",c,x,G,Y,V,z,U,ue='Class for outputs of <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitModel">BeitModel</a>.',A,Ue,at,et,mt,st='Class for outputs of <a href="/docs/transformers/main/en/model_doc/beit#transformers.FlaxBeitModel">FlaxBeitModel</a>.',ht,g,B,X,N,Me,S,Ee=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitModel">BeitModel</a>. It is used to instantiate an BEiT
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the BEiT
<a href="https://huggingface.co/microsoft/beit-base-patch16-224-pt22k" rel="nofollow">microsoft/beit-base-patch16-224-pt22k</a> architecture.`,Zt,_t,At,xt,Xt,rt,$t,oo,Nt,Bt,no,bt,Ct,ao,Pt,mo='Converts the output of <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',Ht,jt,qt,He,Ft,so,Lt,po="Constructs a BEiT image processor.",ro,yt,It,io,Et,ho="Preprocess an image or batch of images.",lo,Mt,kt,co,St,go='Converts the output of <a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a> into semantic segmentation maps. Only supports PyTorch.',Yt,Tt,Dt,Jt,Qt,Vt,Ot;return w=new _e({props:{title:"BEiT",local:"beit",headingTag:"h1"}}),le=new _e({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Q=new _e({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),te=new _e({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h3"}}),Ge=new gt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlaXRGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBbW9kZWwlMjAlM0QlMjBCZWl0Rm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybWljcm9zb2Z0JTJGYmVpdC1iYXNlLXBhdGNoMTYtMjI0JTIyJTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMnNkcGElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBLi4u",highlighted:`from transformers import BeitForImageClassification
model = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">BeitForImageClassification</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-string">&quot;microsoft/beit-base-patch16-224&quot;</span>, <span class="hljs-params">attn_implementation</span>=<span class="hljs-string">&quot;sdpa&quot;</span>, <span class="hljs-params">torch_dtype</span>=<span class="hljs-params">torch</span>.<span class="hljs-params">float16</span>)</span>
...`,wrap:!1}}),k=new _e({props:{title:"Training",local:"training",headingTag:"h4"}}),oe=new _e({props:{title:"Inference",local:"inference",headingTag:"h4"}}),re=new _e({props:{title:"Resources",local:"resources",headingTag:"h2"}}),j=new xo({props:{pipeline:"image-classification"}}),x=new _e({props:{title:"BEiT specific outputs",local:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling",headingTag:"h2"}}),V=new H({props:{name:"class transformers.models.beit.modeling_beit.BeitModelOutputWithPooling",anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooler_output",val:": typing.Optional[torch.FloatTensor] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor, ...]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor, ...]] = None"}],parametersDescription:[{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.`,name:"pooler_output"},{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_beit.py#L65"}}),at=new H({props:{name:"class transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling",anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling",parameters:[{name:"last_hidden_state",val:": typing.Optional[jax.Array] = None"},{name:"pooler_output",val:": typing.Optional[jax.Array] = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[jax.Array]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[jax.Array]] = None"}],parametersDescription:[{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.pooler_output",description:`<strong>pooler_output</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, hidden_size)</code>) &#x2014;
Average of the last layer hidden states of the patch tokens (excluding the <em>[CLS]</em> token) if
<em>config.use_mean_pooling</em> is set to True. If set to False, then the final hidden state of the <em>[CLS]</em> token
will be returned.`,name:"pooler_output"},{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer plus
the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.beit.modeling_flax_beit.FlaxBeitModelOutputWithPooling.attentions",description:`<strong>attentions</strong> (<code>tuple(jnp.ndarray)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>jnp.ndarray</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/modeling_flax_beit.py#L44"}}),g=new _e({props:{title:"BeitConfig",local:"transformers.BeitConfig",headingTag:"h2"}}),N=new H({props:{name:"class transformers.BeitConfig",anchor:"transformers.BeitConfig",parameters:[{name:"vocab_size",val:" = 8192"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"use_mask_token",val:" = False"},{name:"use_absolute_position_embeddings",val:" = False"},{name:"use_relative_position_bias",val:" = False"},{name:"use_shared_relative_position_bias",val:" = False"},{name:"layer_scale_init_value",val:" = 0.1"},{name:"drop_path_rate",val:" = 0.1"},{name:"use_mean_pooling",val:" = True"},{name:"pool_scales",val:" = [1, 2, 3, 6]"},{name:"use_auxiliary_head",val:" = True"},{name:"auxiliary_loss_weight",val:" = 0.4"},{name:"auxiliary_channels",val:" = 256"},{name:"auxiliary_num_convs",val:" = 1"},{name:"auxiliary_concat_input",val:" = False"},{name:"semantic_loss_ignore_index",val:" = 255"},{name:"out_features",val:" = None"},{name:"out_indices",val:" = None"},{name:"add_fpn",val:" = False"},{name:"reshape_hidden_states",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeitConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Vocabulary size of the BEiT model. Defines the number of different image tokens that can be used during
pre-training.`,name:"vocab_size"},{anchor:"transformers.BeitConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.BeitConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.BeitConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.BeitConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.BeitConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.BeitConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.BeitConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.BeitConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.BeitConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.BeitConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.BeitConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.BeitConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.BeitConfig.use_mask_token",description:`<strong>use_mask_token</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a mask token for masked image modeling.`,name:"use_mask_token"},{anchor:"transformers.BeitConfig.use_absolute_position_embeddings",description:`<strong>use_absolute_position_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use BERT-style absolute position embeddings.`,name:"use_absolute_position_embeddings"},{anchor:"transformers.BeitConfig.use_relative_position_bias",description:`<strong>use_relative_position_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use T5-style relative position embeddings in the self-attention layers.`,name:"use_relative_position_bias"},{anchor:"transformers.BeitConfig.use_shared_relative_position_bias",description:`<strong>use_shared_relative_position_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use the same relative position embeddings across all self-attention layers of the Transformer.`,name:"use_shared_relative_position_bias"},{anchor:"transformers.BeitConfig.layer_scale_init_value",description:`<strong>layer_scale_init_value</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Scale to use in the self-attention layers. 0.1 for base, 1e-5 for large. Set 0 to disable layer scale.`,name:"layer_scale_init_value"},{anchor:"transformers.BeitConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Stochastic depth rate per sample (when applied in the main path of residual layers).`,name:"drop_path_rate"},{anchor:"transformers.BeitConfig.use_mean_pooling",description:`<strong>use_mean_pooling</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to mean pool the final hidden states of the patches instead of using the final hidden state of the
CLS token, before applying the classification head.`,name:"use_mean_pooling"},{anchor:"transformers.BeitConfig.pool_scales",description:`<strong>pool_scales</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>[1, 2, 3, 6]</code>) &#x2014;
Pooling scales used in Pooling Pyramid Module applied on the last feature map.`,name:"pool_scales"},{anchor:"transformers.BeitConfig.use_auxiliary_head",description:`<strong>use_auxiliary_head</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use an auxiliary head during training.`,name:"use_auxiliary_head"},{anchor:"transformers.BeitConfig.auxiliary_loss_weight",description:`<strong>auxiliary_loss_weight</strong> (<code>float</code>, <em>optional</em>, defaults to 0.4) &#x2014;
Weight of the cross-entropy loss of the auxiliary head.`,name:"auxiliary_loss_weight"},{anchor:"transformers.BeitConfig.auxiliary_channels",description:`<strong>auxiliary_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Number of channels to use in the auxiliary head.`,name:"auxiliary_channels"},{anchor:"transformers.BeitConfig.auxiliary_num_convs",description:`<strong>auxiliary_num_convs</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of convolutional layers to use in the auxiliary head.`,name:"auxiliary_num_convs"},{anchor:"transformers.BeitConfig.auxiliary_concat_input",description:`<strong>auxiliary_concat_input</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to concatenate the output of the auxiliary head with the input before the classification layer.`,name:"auxiliary_concat_input"},{anchor:"transformers.BeitConfig.semantic_loss_ignore_index",description:`<strong>semantic_loss_ignore_index</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
The index that is ignored by the loss function of the semantic segmentation model.`,name:"semantic_loss_ignore_index"},{anchor:"transformers.BeitConfig.out_features",description:`<strong>out_features</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of features to output. Can be any of <code>&quot;stem&quot;</code>, <code>&quot;stage1&quot;</code>, <code>&quot;stage2&quot;</code>, etc.
(depending on how many stages the model has). If unset and <code>out_indices</code> is set, will default to the
corresponding stages. If unset and <code>out_indices</code> is unset, will default to the last stage. Must be in the
same order as defined in the <code>stage_names</code> attribute.`,name:"out_features"},{anchor:"transformers.BeitConfig.out_indices",description:`<strong>out_indices</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
If used as backbone, list of indices of features to output. Can be any of 0, 1, 2, etc. (depending on how
many stages the model has). If unset and <code>out_features</code> is set, will default to the corresponding stages.
If unset and <code>out_features</code> is unset, will default to the last stage. Must be in the
same order as defined in the <code>stage_names</code> attribute.`,name:"out_indices"},{anchor:"transformers.BeitConfig.add_fpn",description:`<strong>add_fpn</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add a FPN as part of the backbone. Only relevant for <code>BeitBackbone</code>.`,name:"add_fpn"},{anchor:"transformers.BeitConfig.reshape_hidden_states",description:`<strong>reshape_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to reshape the feature maps to 4D tensors of shape <code>(batch_size, hidden_size, height, width)</code> in
case the model is used as backbone. If <code>False</code>, the feature maps will be 3D tensors of shape <code>(batch_size, seq_len, hidden_size)</code>. Only relevant for <code>BeitBackbone</code>.`,name:"reshape_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/configuration_beit.py#L28"}}),_t=new wt({props:{anchor:"transformers.BeitConfig.example",$$slots:{default:[Bo]},$$scope:{ctx:C}}}),xt=new _e({props:{title:"BeitFeatureExtractor",local:"transformers.BeitFeatureExtractor",headingTag:"h2"}}),$t=new H({props:{name:"class transformers.BeitFeatureExtractor",anchor:"transformers.BeitFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/feature_extraction_beit.py#L26"}}),Bt=new H({props:{name:"__call__",anchor:"transformers.BeitFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"segmentation_maps",val:" = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/image_processing_beit.py#L309"}}),Ct=new H({props:{name:"post_process_semantic_segmentation",anchor:"transformers.BeitFeatureExtractor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.List[typing.Tuple] = None"}],parametersDescription:[{anchor:"transformers.BeitFeatureExtractor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.BeitFeatureExtractor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code> of length <code>batch_size</code>, <em>optional</em>) &#x2014;
List of tuples corresponding to the requested final size (height, width) of each prediction. If unset,
predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/image_processing_beit.py#L471",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code> of length <code>batch_size</code>, where each item is a semantic
segmentation map of shape (height, width) corresponding to the target_sizes entry (if <code>target_sizes</code> is
specified). Each entry of each <code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>semantic_segmentation</p>
`}}),jt=new _e({props:{title:"BeitImageProcessor",local:"transformers.BeitImageProcessor",headingTag:"h2"}}),Ft=new H({props:{name:"class transformers.BeitImageProcessor",anchor:"transformers.BeitImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_rescale",val:": bool = True"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_reduce_labels",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeitImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.BeitImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.BeitImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter in the
<code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.BeitImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image. If the input size is smaller than <code>crop_size</code> along any edge, the image
is padded with 0&#x2019;s and then center cropped. Can be overridden by the <code>do_center_crop</code> parameter in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.BeitImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Desired output size when applying center-cropping. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.
Can be overridden by the <code>crop_size</code> parameter in the <code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.BeitImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.BeitImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.BeitImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.BeitImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
The mean to use if normalizing the image. This is a float or list of floats of length of the number of
channels of the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.BeitImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
The standard deviation to use if normalizing the image. This is a float or list of floats of length of the
number of channels of the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.BeitImageProcessor.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to reduce all label values of segmentation maps by 1. Usually used for datasets where 0 is
used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k). The
background label will be replaced by 255. Can be overridden by the <code>do_reduce_labels</code> parameter in the
<code>preprocess</code> method.`,name:"do_reduce_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/image_processing_beit.py#L57"}}),It=new H({props:{name:"preprocess",anchor:"transformers.BeitImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor'], NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_reduce_labels",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.BeitImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.BeitImageProcessor.preprocess.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
Segmentation maps to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"segmentation_maps"},{anchor:"transformers.BeitImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.BeitImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.BeitImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.BeitImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.BeitImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the image after center crop. If one edge the image is smaller than <code>crop_size</code>, it will be
padded with zeros and then cropped`,name:"crop_size"},{anchor:"transformers.BeitImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image values between [0 - 1].`,name:"do_rescale"},{anchor:"transformers.BeitImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.BeitImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.BeitImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.BeitImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.BeitImageProcessor.preprocess.do_reduce_labels",description:`<strong>do_reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_reduce_labels</code>) &#x2014;
Whether or not to reduce all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g.
ADE20k). The background label will be replaced by 255.`,name:"do_reduce_labels"},{anchor:"transformers.BeitImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.BeitImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.BeitImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/image_processing_beit.py#L314"}}),kt=new H({props:{name:"post_process_semantic_segmentation",anchor:"transformers.BeitImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.List[typing.Tuple] = None"}],parametersDescription:[{anchor:"transformers.BeitImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/main/en/model_doc/beit#transformers.BeitForSemanticSegmentation">BeitForSemanticSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.BeitImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code> of length <code>batch_size</code>, <em>optional</em>) &#x2014;
List of tuples corresponding to the requested final size (height, width) of each prediction. If unset,
predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/beit/image_processing_beit.py#L471",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code> of length <code>batch_size</code>, where each item is a semantic
segmentation map of shape (height, width) corresponding to the target_sizes entry (if <code>target_sizes</code> is
specified). Each entry of each <code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>semantic_segmentation</p>
`}}),Tt=new wo({props:{pytorch:!0,tensorflow:!1,jax:!0,$$slots:{jax:[Vo],pytorch:[Zo]},$$scope:{ctx:C}}}),Jt=new $o({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/beit.md"}}),{c(){t=m("meta"),T=s(),o=m("p"),d=s(),f(w.$$.fragment),n=s(),$=m("div"),$.innerHTML=it,L=s(),f(le.$$.fragment),qe=s(),D=m("p"),D.innerHTML=ft,Ye=s(),R=m("p"),R.textContent=pt,be=s(),ae=m("p"),ae.innerHTML=Se,Re=s(),F=m("p"),F.innerHTML=de,De=s(),f(Q.$$.fragment),lt=s(),Be=m("ul"),Be.innerHTML=E,Te=s(),O=m("img"),Ce=s(),ve=m("small"),ve.innerHTML=I,we=s(),f(te.$$.fragment),xe=s(),ce=m("p"),ce.innerHTML=tt,Z=s(),me=m("p"),me.innerHTML=dt,pe=s(),f(Ge.$$.fragment),Qe=s(),K=m("p"),K.innerHTML=ut,Oe=s(),W=m("p"),W.innerHTML=Ve,Ke=s(),f(k.$$.fragment),je=s(),Fe=m("table"),Fe.innerHTML=he,ot=s(),f(oe.$$.fragment),ge=s(),se=m("table"),se.innerHTML=Pe,ee=s(),f(re.$$.fragment),ye=s(),ie=m("p"),ie.textContent=Ae,Xe=s(),f(j.$$.fragment),Ie=s(),ke=m("ul"),ke.innerHTML=q,Je=s(),ze=m("p"),ze.innerHTML=$e,ct=s(),We=m("ul"),We.innerHTML=fe,nt=s(),ne=m("p"),ne.textContent=Le,c=s(),f(x.$$.fragment),G=s(),Y=m("div"),f(V.$$.fragment),z=s(),U=m("p"),U.innerHTML=ue,A=s(),Ue=m("div"),f(at.$$.fragment),et=s(),mt=m("p"),mt.innerHTML=st,ht=s(),f(g.$$.fragment),B=s(),X=m("div"),f(N.$$.fragment),Me=s(),S=m("p"),S.innerHTML=Ee,Zt=s(),f(_t.$$.fragment),At=s(),f(xt.$$.fragment),Xt=s(),rt=m("div"),f($t.$$.fragment),oo=s(),Nt=m("div"),f(Bt.$$.fragment),no=s(),bt=m("div"),f(Ct.$$.fragment),ao=s(),Pt=m("p"),Pt.innerHTML=mo,Ht=s(),f(jt.$$.fragment),qt=s(),He=m("div"),f(Ft.$$.fragment),so=s(),Lt=m("p"),Lt.textContent=po,ro=s(),yt=m("div"),f(It.$$.fragment),io=s(),Et=m("p"),Et.textContent=ho,lo=s(),Mt=m("div"),f(kt.$$.fragment),co=s(),St=m("p"),St.innerHTML=go,Yt=s(),f(Tt.$$.fragment),Dt=s(),f(Jt.$$.fragment),Qt=s(),Vt=m("p"),this.h()},l(e){const h=vo("svelte-u9bgzb",document.head);t=p(h,"META",{name:!0,content:!0}),h.forEach(a),T=r(e),o=p(e,"P",{}),P(o).forEach(a),d=r(e),u(w.$$.fragment,e),n=r(e),$=p(e,"DIV",{class:!0,"data-svelte-h":!0}),v($)!=="svelte-f5ciix"&&($.innerHTML=it),L=r(e),u(le.$$.fragment,e),qe=r(e),D=p(e,"P",{"data-svelte-h":!0}),v(D)!=="svelte-82fvis"&&(D.innerHTML=ft),Ye=r(e),R=p(e,"P",{"data-svelte-h":!0}),v(R)!=="svelte-vfdo9a"&&(R.textContent=pt),be=r(e),ae=p(e,"P",{"data-svelte-h":!0}),v(ae)!=="svelte-s10fc1"&&(ae.innerHTML=Se),Re=r(e),F=p(e,"P",{"data-svelte-h":!0}),v(F)!=="svelte-29336p"&&(F.innerHTML=de),De=r(e),u(Q.$$.fragment,e),lt=r(e),Be=p(e,"UL",{"data-svelte-h":!0}),v(Be)!=="svelte-1ej7ct7"&&(Be.innerHTML=E),Te=r(e),O=p(e,"IMG",{src:!0,alt:!0,width:!0}),Ce=r(e),ve=p(e,"SMALL",{"data-svelte-h":!0}),v(ve)!=="svelte-11iyjyp"&&(ve.innerHTML=I),we=r(e),u(te.$$.fragment,e),xe=r(e),ce=p(e,"P",{"data-svelte-h":!0}),v(ce)!=="svelte-1cid2pe"&&(ce.innerHTML=tt),Z=r(e),me=p(e,"P",{"data-svelte-h":!0}),v(me)!=="svelte-1x11lxg"&&(me.innerHTML=dt),pe=r(e),u(Ge.$$.fragment,e),Qe=r(e),K=p(e,"P",{"data-svelte-h":!0}),v(K)!=="svelte-djb2w0"&&(K.innerHTML=ut),Oe=r(e),W=p(e,"P",{"data-svelte-h":!0}),v(W)!=="svelte-vyvhi1"&&(W.innerHTML=Ve),Ke=r(e),u(k.$$.fragment,e),je=r(e),Fe=p(e,"TABLE",{"data-svelte-h":!0}),v(Fe)!=="svelte-1qjtd23"&&(Fe.innerHTML=he),ot=r(e),u(oe.$$.fragment,e),ge=r(e),se=p(e,"TABLE",{"data-svelte-h":!0}),v(se)!=="svelte-18nua2y"&&(se.innerHTML=Pe),ee=r(e),u(re.$$.fragment,e),ye=r(e),ie=p(e,"P",{"data-svelte-h":!0}),v(ie)!=="svelte-1bkfbxv"&&(ie.textContent=Ae),Xe=r(e),u(j.$$.fragment,e),Ie=r(e),ke=p(e,"UL",{"data-svelte-h":!0}),v(ke)!=="svelte-zkv0ml"&&(ke.innerHTML=q),Je=r(e),ze=p(e,"P",{"data-svelte-h":!0}),v(ze)!=="svelte-1qspi63"&&(ze.innerHTML=$e),ct=r(e),We=p(e,"UL",{"data-svelte-h":!0}),v(We)!=="svelte-bnel3y"&&(We.innerHTML=fe),nt=r(e),ne=p(e,"P",{"data-svelte-h":!0}),v(ne)!=="svelte-1xesile"&&(ne.textContent=Le),c=r(e),u(x.$$.fragment,e),G=r(e),Y=p(e,"DIV",{class:!0});var zt=P(Y);u(V.$$.fragment,zt),z=r(zt),U=p(zt,"P",{"data-svelte-h":!0}),v(U)!=="svelte-148z2cd"&&(U.innerHTML=ue),zt.forEach(a),A=r(e),Ue=p(e,"DIV",{class:!0});var Wt=P(Ue);u(at.$$.fragment,Wt),et=r(Wt),mt=p(Wt,"P",{"data-svelte-h":!0}),v(mt)!=="svelte-1x6ong1"&&(mt.innerHTML=st),Wt.forEach(a),ht=r(e),u(g.$$.fragment,e),B=r(e),X=p(e,"DIV",{class:!0});var Rt=P(X);u(N.$$.fragment,Rt),Me=r(Rt),S=p(Rt,"P",{"data-svelte-h":!0}),v(S)!=="svelte-xekuij"&&(S.innerHTML=Ee),Zt=r(Rt),u(_t.$$.fragment,Rt),Rt.forEach(a),At=r(e),u(xt.$$.fragment,e),Xt=r(e),rt=p(e,"DIV",{class:!0});var Gt=P(rt);u($t.$$.fragment,Gt),oo=r(Gt),Nt=p(Gt,"DIV",{class:!0});var fo=P(Nt);u(Bt.$$.fragment,fo),fo.forEach(a),no=r(Gt),bt=p(Gt,"DIV",{class:!0});var Kt=P(bt);u(Ct.$$.fragment,Kt),ao=r(Kt),Pt=p(Kt,"P",{"data-svelte-h":!0}),v(Pt)!=="svelte-it6sc2"&&(Pt.innerHTML=mo),Kt.forEach(a),Gt.forEach(a),Ht=r(e),u(jt.$$.fragment,e),qt=r(e),He=p(e,"DIV",{class:!0});var vt=P(He);u(Ft.$$.fragment,vt),so=r(vt),Lt=p(vt,"P",{"data-svelte-h":!0}),v(Lt)!=="svelte-ky7k50"&&(Lt.textContent=po),ro=r(vt),yt=p(vt,"DIV",{class:!0});var eo=P(yt);u(It.$$.fragment,eo),io=r(eo),Et=p(eo,"P",{"data-svelte-h":!0}),v(Et)!=="svelte-1x3yxsa"&&(Et.textContent=ho),eo.forEach(a),lo=r(vt),Mt=p(vt,"DIV",{class:!0});var to=P(Mt);u(kt.$$.fragment,to),co=r(to),St=p(to,"P",{"data-svelte-h":!0}),v(St)!=="svelte-it6sc2"&&(St.innerHTML=go),to.forEach(a),vt.forEach(a),Yt=r(e),u(Tt.$$.fragment,e),Dt=r(e),u(Jt.$$.fragment,e),Qt=r(e),Vt=p(e,"P",{}),P(Vt).forEach(a),this.h()},h(){J(t,"name","hf:doc:metadata"),J(t,"content",Xo),J($,"class","flex flex-wrap space-x-1"),bo(O.src,Ne="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/beit_architecture.jpg")||J(O,"src",Ne),J(O,"alt","drawing"),J(O,"width","600"),J(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(yt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,h){i(document.head,t),l(e,T,h),l(e,o,h),l(e,d,h),_(w,e,h),l(e,n,h),l(e,$,h),l(e,L,h),_(le,e,h),l(e,qe,h),l(e,D,h),l(e,Ye,h),l(e,R,h),l(e,be,h),l(e,ae,h),l(e,Re,h),l(e,F,h),l(e,De,h),_(Q,e,h),l(e,lt,h),l(e,Be,h),l(e,Te,h),l(e,O,h),l(e,Ce,h),l(e,ve,h),l(e,we,h),_(te,e,h),l(e,xe,h),l(e,ce,h),l(e,Z,h),l(e,me,h),l(e,pe,h),_(Ge,e,h),l(e,Qe,h),l(e,K,h),l(e,Oe,h),l(e,W,h),l(e,Ke,h),_(k,e,h),l(e,je,h),l(e,Fe,h),l(e,ot,h),_(oe,e,h),l(e,ge,h),l(e,se,h),l(e,ee,h),_(re,e,h),l(e,ye,h),l(e,ie,h),l(e,Xe,h),_(j,e,h),l(e,Ie,h),l(e,ke,h),l(e,Je,h),l(e,ze,h),l(e,ct,h),l(e,We,h),l(e,nt,h),l(e,ne,h),l(e,c,h),_(x,e,h),l(e,G,h),l(e,Y,h),_(V,Y,null),i(Y,z),i(Y,U),l(e,A,h),l(e,Ue,h),_(at,Ue,null),i(Ue,et),i(Ue,mt),l(e,ht,h),_(g,e,h),l(e,B,h),l(e,X,h),_(N,X,null),i(X,Me),i(X,S),i(X,Zt),_(_t,X,null),l(e,At,h),_(xt,e,h),l(e,Xt,h),l(e,rt,h),_($t,rt,null),i(rt,oo),i(rt,Nt),_(Bt,Nt,null),i(rt,no),i(rt,bt),_(Ct,bt,null),i(bt,ao),i(bt,Pt),l(e,Ht,h),_(jt,e,h),l(e,qt,h),l(e,He,h),_(Ft,He,null),i(He,so),i(He,Lt),i(He,ro),i(He,yt),_(It,yt,null),i(yt,io),i(yt,Et),i(He,lo),i(He,Mt),_(kt,Mt,null),i(Mt,co),i(Mt,St),l(e,Yt,h),_(Tt,e,h),l(e,Dt,h),_(Jt,e,h),l(e,Qt,h),l(e,Vt,h),Ot=!0},p(e,[h]){const zt={};h&2&&(zt.$$scope={dirty:h,ctx:e}),_t.$set(zt);const Wt={};h&2&&(Wt.$$scope={dirty:h,ctx:e}),Tt.$set(Wt)},i(e){Ot||(b(w.$$.fragment,e),b(le.$$.fragment,e),b(Q.$$.fragment,e),b(te.$$.fragment,e),b(Ge.$$.fragment,e),b(k.$$.fragment,e),b(oe.$$.fragment,e),b(re.$$.fragment,e),b(j.$$.fragment,e),b(x.$$.fragment,e),b(V.$$.fragment,e),b(at.$$.fragment,e),b(g.$$.fragment,e),b(N.$$.fragment,e),b(_t.$$.fragment,e),b(xt.$$.fragment,e),b($t.$$.fragment,e),b(Bt.$$.fragment,e),b(Ct.$$.fragment,e),b(jt.$$.fragment,e),b(Ft.$$.fragment,e),b(It.$$.fragment,e),b(kt.$$.fragment,e),b(Tt.$$.fragment,e),b(Jt.$$.fragment,e),Ot=!0)},o(e){y(w.$$.fragment,e),y(le.$$.fragment,e),y(Q.$$.fragment,e),y(te.$$.fragment,e),y(Ge.$$.fragment,e),y(k.$$.fragment,e),y(oe.$$.fragment,e),y(re.$$.fragment,e),y(j.$$.fragment,e),y(x.$$.fragment,e),y(V.$$.fragment,e),y(at.$$.fragment,e),y(g.$$.fragment,e),y(N.$$.fragment,e),y(_t.$$.fragment,e),y(xt.$$.fragment,e),y($t.$$.fragment,e),y(Bt.$$.fragment,e),y(Ct.$$.fragment,e),y(jt.$$.fragment,e),y(Ft.$$.fragment,e),y(It.$$.fragment,e),y(kt.$$.fragment,e),y(Tt.$$.fragment,e),y(Jt.$$.fragment,e),Ot=!1},d(e){e&&(a(T),a(o),a(d),a(n),a($),a(L),a(qe),a(D),a(Ye),a(R),a(be),a(ae),a(Re),a(F),a(De),a(lt),a(Be),a(Te),a(O),a(Ce),a(ve),a(we),a(xe),a(ce),a(Z),a(me),a(pe),a(Qe),a(K),a(Oe),a(W),a(Ke),a(je),a(Fe),a(ot),a(ge),a(se),a(ee),a(ye),a(ie),a(Xe),a(Ie),a(ke),a(Je),a(ze),a(ct),a(We),a(nt),a(ne),a(c),a(G),a(Y),a(A),a(Ue),a(ht),a(B),a(X),a(At),a(Xt),a(rt),a(Ht),a(qt),a(He),a(Yt),a(Dt),a(Qt),a(Vt)),a(t),M(w,e),M(le,e),M(Q,e),M(te,e),M(Ge,e),M(k,e),M(oe,e),M(re,e),M(j,e),M(x,e),M(V),M(at),M(g,e),M(N),M(_t),M(xt,e),M($t),M(Bt),M(Ct),M(jt,e),M(Ft),M(It),M(kt),M(Tt,e),M(Jt,e)}}}const Xo='{"title":"BEiT","local":"beit","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[{"title":"Training","local":"training","sections":[],"depth":4},{"title":"Inference","local":"inference","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"BEiT specific outputs","local":"transformers.models.beit.modeling_beit.BeitModelOutputWithPooling","sections":[],"depth":2},{"title":"BeitConfig","local":"transformers.BeitConfig","sections":[],"depth":2},{"title":"BeitFeatureExtractor","local":"transformers.BeitFeatureExtractor","sections":[],"depth":2},{"title":"BeitImageProcessor","local":"transformers.BeitImageProcessor","sections":[],"depth":2},{"title":"BeitModel","local":"transformers.BeitModel","sections":[],"depth":2},{"title":"BeitForMaskedImageModeling","local":"transformers.BeitForMaskedImageModeling","sections":[],"depth":2},{"title":"BeitForImageClassification","local":"transformers.BeitForImageClassification","sections":[],"depth":2},{"title":"BeitForSemanticSegmentation","local":"transformers.BeitForSemanticSegmentation","sections":[],"depth":2},{"title":"FlaxBeitModel","local":"transformers.FlaxBeitModel","sections":[],"depth":2},{"title":"FlaxBeitForMaskedImageModeling","local":"transformers.FlaxBeitForMaskedImageModeling","sections":[],"depth":2},{"title":"FlaxBeitForImageClassification","local":"transformers.FlaxBeitForImageClassification","sections":[],"depth":2}],"depth":1}';function Ho(C){return yo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nn extends Mo{constructor(t){super(),To(this,t,Ho,Ao,_o,{})}}export{nn as component};
