import{s as ss,n as us,o as ms}from"../chunks/scheduler.b108d059.js";import{S as ns,i as fs,g as o,s as r,r as n,A as ps,h as i,f as e,c as a,j as m,u as f,x as s,k as u,y as hs,a as d,v as p,d as h,t as c,w as T}from"../chunks/index.008de539.js";import{H as y}from"../chunks/Heading.88bfeb84.js";function cs(xo){let v,cl,pl,Tl,F,yl,_,vl,x,bo="Helper module for mathematical processing.",Fl,b,$o=`These functions and classes are only used internally,
meaning an end-user shouldn’t need to access anything here.`,_l,$,Po='<li><a href="#module_utils/maths">utils/maths</a><ul><li><em>static</em><ul><li><a href="#module_utils/maths.interpolate_data"><code>.interpolate_data(input)</code></a></li> <li><a href="#module_utils/maths.transpose_data"><code>.transpose_data(array, dims, axes)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.softmax"><code>.softmax(arr)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/maths.log_softmax"><code>.log_softmax(arr)</code></a> ⇒ <code>T</code></li> <li><a href="#module_utils/maths.dot"><code>.dot(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.getTopItems"><code>.getTopItems(items, [top_k])</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.cos_sim"><code>.cos_sim(arr1, arr2)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.magnitude"><code>.magnitude(arr)</code></a> ⇒ <code>number</code></li> <li><a href="#module_utils/maths.min"><code>.min(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths.max"><code>.max(arr)</code></a> ⇒ <code>*</code></li> <li><a href="#module_utils/maths.medianFilter"><code>.medianFilter(data, windowSize)</code></a></li> <li><a href="#module_utils/maths.round"><code>.round(num, decimals)</code></a> ⇒ <code>number</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+completeSpectrum"><code>.completeSpectrum(spectrum)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li> <li><a href="#module_utils/maths..NP2FFT">~NP2FFT</a><ul><li><a href="#new_module_utils/maths..NP2FFT_new"><code>new NP2FFT(fft_length)</code></a></li></ul></li> <li><a href="#module_utils/maths..AnyTypedArray"><code>~AnyTypedArray</code></a> : <code>Int8Array</code> | <code>Uint8Array</code> | <code>Uint8ClampedArray</code> | <code>Int16Array</code> | <code>Uint16Array</code> | <code>Int32Array</code> | <code>Uint32Array</code> | <code>Float32Array</code> | <code>Float64Array</code></li></ul></li></ul></li>',xl,bl,$l,P,Pl,A,Al,C,Ao='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',Cl,H,Co="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>input</td><td><code>TypedArray</code></td></tr></tbody>",Hl,Ll,Ml,L,wl,M,gl,w,Ho="Helper method to transpose a <code>AnyTypedArray</code> directly",El,g,Lo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - The transposed array and the new shape.',Rl,E,Mo="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>array</td><td><code>T</code></td> </tr><tr><td>dims</td><td><code>Array.&lt;number&gt;</code></td> </tr><tr><td>axes</td><td><code>Array.&lt;number&gt;</code></td></tr></tbody>",zl,kl,Kl,R,Ol,z,Bl,k,wo="Compute the softmax of an array of numbers.",Dl,K,go='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>T</code> - The softmax array.',Il,O,Eo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>T</code></td><td><p>The array of numbers to compute the softmax of.</p></td></tr></tbody>",jl,Ul,ql,B,Sl,D,Nl,I,Ro="Calculates the logarithm of the softmax function for the input array.",Gl,j,zo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>T</code> - The resulting log_softmax array.',Jl,U,ko="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>T</code></td><td><p>The input array to calculate the log_softmax function for.</p></td></tr></tbody>",Ql,Vl,Wl,q,Xl,S,Yl,N,Ko="Calculates the dot product of two arrays.",Zl,G,Oo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The dot product of arr1 and arr2.',td,J,Bo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",ed,ld,dd,Q,rd,V,ad,W,Do="Get the top k items from an iterable, sorted by descending order",od,X,Io='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - The top k items, sorted by descending order',id,Y,jo="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>items</td><td><code>Array&lt;any&gt;</code> | <code>TypedArray</code></td><td></td><td><p>The items to be sorted</p></td> </tr><tr><td>[top_k]</td><td><code>number</code> | <code>null</code></td><td><code>0</code></td><td><p>The number of top items to return (default: 0 = return all)</p></td></tr></tbody>",sd,ud,md,Z,nd,tt,fd,et,Uo="Computes the cosine similarity between two arrays.",pd,lt,qo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The cosine similarity between the two arrays.',hd,dt,So="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr1</td><td><code>Array.&lt;number&gt;</code></td><td><p>The first array.</p></td> </tr><tr><td>arr2</td><td><code>Array.&lt;number&gt;</code></td><td><p>The second array.</p></td></tr></tbody>",cd,Td,yd,rt,vd,at,Fd,ot,No="Calculates the magnitude of a given array.",_d,it,Go='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The magnitude of the array.',xd,st,Jo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The array to calculate the magnitude of.</p></td></tr></tbody>",bd,$d,Pd,ut,Ad,mt,Cd,nt,Qo="Returns the value and index of the minimum element in an array.",Hd,ft,Vo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - the value and index of the minimum element, of the form: [valueOfMin, indexOfMin]<br/> <strong>Throws</strong>:',Ld,pt,Wo="<li><code>Error</code> If array is empty.</li>",Md,ht,Xo="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>TypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",wd,gd,Ed,ct,Rd,Tt,zd,yt,Yo="Returns the value and index of the maximum element in an array.",kd,vt,Zo='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>*</code> - the value and index of the maximum element, of the form: [valueOfMax, indexOfMax]<br/> <strong>Throws</strong>:',Kd,Ft,ti="<li><code>Error</code> If array is empty.</li>",Od,_t,ei="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array&lt;number&gt;</code> | <code>AnyTypedArray</code></td><td><p>array of numbers.</p></td></tr></tbody>",Bd,Dd,Id,xt,jd,bt,Ud,$t,li="Performs median filter on the provided data. Padding is done by mirroring the data.",qd,Pt,di='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a>',Sd,At,ri="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>AnyTypedArray</code></td><td><p>The input array</p></td> </tr><tr><td>windowSize</td><td><code>number</code></td><td><p>The window size</p></td></tr></tbody>",Nd,Gd,Jd,Ct,Qd,Ht,Vd,Lt,ai="Helper function to round a number to a given number of decimals",Wd,Mt,oi='<strong>Kind</strong>: static method of <a href="#module_utils/maths"><code>utils/maths</code></a><br/> <strong>Returns</strong>: <code>number</code> - The rounded number',Xd,wt,ii="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>num</td><td><code>number</code></td><td><p>The number to round</p></td> </tr><tr><td>decimals</td><td><code>number</code></td><td><p>The number of decimals</p></td></tr></tbody>",Yd,Zd,tr,gt,er,Et,lr,Rt,si="Implementation of Radix-4 FFT.",dr,zt,ui=`P2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are a power of two in length.
Code adapted from <a href="https://www.npmjs.com/package/fft.js" rel="nofollow">https://www.npmjs.com/package/fft.js</a>`,rr,kt,mi='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',ar,Kt,ni='<li><a href="#module_utils/maths..P2FFT">~P2FFT</a><ul><li><a href="#new_module_utils/maths..P2FFT_new"><code>new P2FFT(size)</code></a></li> <li><a href="#module_utils/maths..P2FFT+createComplexArray"><code>.createComplexArray()</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+fromComplexArray"><code>.fromComplexArray(complex, [storage])</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_utils/maths..P2FFT+toComplexArray"><code>.toComplexArray(input, [storage])</code></a> ⇒ <code>Float64Array</code></li> <li><a href="#module_utils/maths..P2FFT+completeSpectrum"><code>.completeSpectrum(spectrum)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+transform"><code>.transform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+realTransform"><code>.realTransform(out, data)</code></a></li> <li><a href="#module_utils/maths..P2FFT+inverseTransform"><code>.inverseTransform(out, data)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_transform4"><code>._transform4(out, data, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform2"><code>._singleTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleTransform4"><code>._singleTransform4(data, out, outOff, off, step, inv)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_realTransform4"><code>._realTransform4(out, data, inv)</code></a></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform2"><code>._singleRealTransform2(data, out, outOff, off, step)</code></a> ⇒ <code>void</code></li> <li><a href="#module_utils/maths..P2FFT+_singleRealTransform4"><code>._singleRealTransform4(data, out, outOff, off, step, inv)</code></a></li></ul></li>',or,ir,sr,Ot,ur,Bt,mr,Dt,fi="<strong>Throws</strong>:",nr,It,pi="<li><code>Error</code> FFT size must be a power of two larger than 1.</li>",fr,jt,hi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>number</code></td><td><p>The size of the input array. Must be a power of two larger than 1.</p></td></tr></tbody>",pr,hr,cr,Ut,Tr,qt,yr,St,ci="Create a complex number array with size <code>2 * size</code>",vr,Nt,Ti='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - A complex number array with size <code>2 * size</code>',Fr,_r,xr,Gt,br,Jt,$r,Qt,yi="Converts a complex number representation stored in a Float64Array to an array of real numbers.",Pr,Vt,vi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - An array of real numbers representing the input complex number representation.',Ar,Wt,Fi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>complex</td><td><code>Float64Array</code></td><td><p>The complex number representation to be converted.</p></td> </tr><tr><td>[storage]</td><td><code>Array.&lt;number&gt;</code></td><td><p>An optional array to store the result in.</p></td></tr></tbody>",Cr,Hr,Lr,Xt,Mr,Yt,wr,Zt,_i="Convert a real-valued input array to a complex-valued output array.",gr,te,xi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Returns</strong>: <code>Float64Array</code> - The complex-valued output array.',Er,ee,bi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>Float64Array</code></td><td><p>The real-valued input array.</p></td> </tr><tr><td>[storage]</td><td><code>Float64Array</code></td><td><p>Optional buffer to store the output array.</p></td></tr></tbody>",Rr,zr,kr,le,Kr,de,Or,re,$i="Completes the spectrum by adding its mirrored negative frequency components.",Br,ae,Pi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Dr,oe,Ai="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>spectrum</td><td><code>Float64Array</code></td><td><p>The input spectrum.</p></td></tr></tbody>",Ir,jr,Ur,ie,qr,se,Sr,ue,Ci="Performs a Fast Fourier Transform (FFT) on the given input data and stores the result in the output buffer.",Nr,me,Hi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',Gr,ne,Li="<li><code>Error</code> Input and output buffers must be different.</li>",Jr,fe,Mi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer to store the result.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",Qr,Vr,Wr,pe,Xr,he,Yr,ce,wi=`Performs a real-valued forward FFT on the given input buffer and stores the result in the given output buffer.
The input buffer must contain real values only, while the output buffer will contain complex values. The input and
output buffers must be different.`,Zr,Te,gi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',ta,ye,Ei="<li><code>Error</code> If the input and output buffers are the same.</li>",ea,ve,Ri="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer containing real values.</p></td></tr></tbody>",la,da,ra,Fe,aa,_e,oa,xe,zi=`Performs an inverse FFT transformation on the given <code>data</code> array, and stores the result in <code>out</code>.
The <code>out</code> array must be a different buffer than the <code>data</code> array. The <code>out</code> array will contain the
result of the transformation. The <code>data</code> array will not be modified.`,ia,be,ki='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a><br/> <strong>Throws</strong>:',sa,$e,Ki="<li><code>Error</code> If `out` and `data` refer to the same buffer.</li>",ua,Pe,Oi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data to transform.</p></td></tr></tbody>",ma,na,fa,Ae,pa,Ce,ha,He,Bi="Performs a radix-4 implementation of a discrete Fourier transform on a given set of data.",ca,Le,Di='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Ta,Me,Ii="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>A scaling factor to apply to the transform.</p></td></tr></tbody>",ya,va,Fa,we,_a,ge,xa,Ee,ji="Performs a radix-2 implementation of a discrete Fourier transform on a given set of data.",ba,Re,Ui='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',$a,ze,qi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input buffer of data to be transformed.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output buffer for the transformed data.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset at which to write the output data.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset at which to begin reading the input data.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for indexing the input data.</p></td></tr></tbody>",Pa,Aa,Ca,ke,Ha,Ke,La,Oe,Si="Performs radix-4 transformation on input data of length 8",Ma,Be,Ni='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',wa,De,Gi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input data array of length 8</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output data array of length 8</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>Index of output array to start writing from</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>Index of input array to start reading from</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>Step size between elements in input array</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>Scaling factor for inverse transform</p></td></tr></tbody>",ga,Ea,Ra,Ie,za,je,ka,Ue,Ji="Real input radix-4 implementation",Ka,qe,Qi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Oa,Se,Vi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>out</td><td><code>Float64Array</code></td><td><p>Output array for the transformed data</p></td> </tr><tr><td>data</td><td><code>Float64Array</code></td><td><p>Input array of real data to be transformed</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The scale factor used to normalize the inverse transform</p></td></tr></tbody>",Ba,Da,Ia,Ne,ja,Ge,Ua,Je,Wi="Performs a single real input radix-2 transformation on the provided data",qa,Qe,Xi='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Sa,Ve,Yi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The output offset</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The input offset</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step</p></td></tr></tbody>",Na,Ga,Ja,We,Qa,Xe,Va,Ye,Zi=`Computes a single real-valued transform using radix-4 algorithm.
This method is only called for len=8.`,Wa,Ze,ts='<strong>Kind</strong>: instance method of <a href="#module_utils/maths..P2FFT"><code>P2FFT</code></a>',Xa,tl,es="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>data</td><td><code>Float64Array</code></td><td><p>The input data array.</p></td> </tr><tr><td>out</td><td><code>Float64Array</code></td><td><p>The output data array.</p></td> </tr><tr><td>outOff</td><td><code>number</code></td><td><p>The offset into the output array.</p></td> </tr><tr><td>off</td><td><code>number</code></td><td><p>The offset into the input array.</p></td> </tr><tr><td>step</td><td><code>number</code></td><td><p>The step size for the input array.</p></td> </tr><tr><td>inv</td><td><code>number</code></td><td><p>The value of inverse.</p></td></tr></tbody>",Ya,Za,to,el,eo,ll,lo,dl,ls=`NP2FFT class provides functionality for performing Fast Fourier Transform on arrays
which are not a power of two in length. In such cases, the chirp-z transform is used.`,ro,rl,ds='For more information, see: <a href="https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156" rel="nofollow">https://math.stackexchange.com/questions/77118/non-power-of-2-ffts/77156#77156</a>',ao,al,rs='<strong>Kind</strong>: inner class of <a href="#module_utils/maths"><code>utils/maths</code></a>',oo,io,so,ol,uo,il,mo,sl,as="Constructs a new NP2FFT object.",no,ul,os="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>fft_length</td><td><code>number</code></td><td><p>The length of the FFT</p></td></tr></tbody>",fo,po,ho,ml,co,nl,To,fl,is='<strong>Kind</strong>: inner typedef of <a href="#module_utils/maths"><code>utils/maths</code></a>',yo,vo,Fo,hl,_o;return _=new y({props:{title:"utils/maths",local:"utilsmaths",headingTag:"h1"}}),A=new y({props:{title:"utils/maths.interpolate_data(input)",local:"utilsmathsinterpolatedatainput",headingTag:"h2"}}),M=new y({props:{title:"utils/maths.transpose_data(array, dims, axes) ⇒ <code> * </code>",local:"utilsmathstransposedataarray-dims-axes--code--code",headingTag:"h2"}}),z=new y({props:{title:"utils/maths.softmax(arr) ⇒ <code> T </code>",local:"utilsmathssoftmaxarr--code-t-code",headingTag:"h2"}}),D=new y({props:{title:"utils/maths.log_softmax(arr) ⇒ <code> T </code>",local:"utilsmathslogsoftmaxarr--code-t-code",headingTag:"h2"}}),S=new y({props:{title:"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathsdotarr1-arr2--code-number-code",headingTag:"h2"}}),V=new y({props:{title:"utils/maths.getTopItems(items, [top_k]) ⇒ <code> * </code>",local:"utilsmathsgettopitemsitems-topk--code--code",headingTag:"h2"}}),tt=new y({props:{title:"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>",local:"utilsmathscossimarr1-arr2--code-number-code",headingTag:"h2"}}),at=new y({props:{title:"utils/maths.magnitude(arr) ⇒ <code> number </code>",local:"utilsmathsmagnitudearr--code-number-code",headingTag:"h2"}}),mt=new y({props:{title:"utils/maths.min(arr) ⇒ <code> Array. < number > </code>",local:"utilsmathsminarr--code-array--number--code",headingTag:"h2"}}),Tt=new y({props:{title:"utils/maths.max(arr) ⇒ <code> * </code>",local:"utilsmathsmaxarr--code--code",headingTag:"h2"}}),bt=new y({props:{title:"utils/maths.medianFilter(data, windowSize)",local:"utilsmathsmedianfilterdata-windowsize",headingTag:"h2"}}),Ht=new y({props:{title:"utils/maths.round(num, decimals) ⇒ <code> number </code>",local:"utilsmathsroundnum-decimals--code-number-code",headingTag:"h2"}}),Et=new y({props:{title:"utils/maths~P2FFT",local:"utilsmathsp2fft",headingTag:"h2"}}),Bt=new y({props:{title:"new P2FFT(size)",local:"new-p2fftsize",headingTag:"h3"}}),qt=new y({props:{title:"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>",local:"p2fftcreatecomplexarray--code-float64array-code",headingTag:"h3"}}),Jt=new y({props:{title:"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>",local:"p2fftfromcomplexarraycomplex-storage--code-array--number--code",headingTag:"h3"}}),Yt=new y({props:{title:"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>",local:"p2ffttocomplexarrayinput-storage--code-float64array-code",headingTag:"h3"}}),de=new y({props:{title:"p2FFT.completeSpectrum(spectrum) ⇒ <code> void </code>",local:"p2fftcompletespectrumspectrum--code-void-code",headingTag:"h3"}}),se=new y({props:{title:"p2FFT.transform(out, data) ⇒ <code> void </code>",local:"p2ffttransformout-data--code-void-code",headingTag:"h3"}}),he=new y({props:{title:"p2FFT.realTransform(out, data)",local:"p2fftrealtransformout-data",headingTag:"h3"}}),_e=new y({props:{title:"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>",local:"p2fftinversetransformout-data--code-void-code",headingTag:"h3"}}),Ce=new y({props:{title:"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>",local:"p2ffttransform4out-data-inv--code-void-code",headingTag:"h3"}}),ge=new y({props:{title:"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsingletransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),Ke=new y({props:{title:"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>",local:"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code",headingTag:"h3"}}),je=new y({props:{title:"p2FFT._realTransform4(out, data, inv)",local:"p2fftrealtransform4out-data-inv",headingTag:"h3"}}),Ge=new y({props:{title:"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>",local:"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code",headingTag:"h3"}}),Xe=new y({props:{title:"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)",local:"p2fftsinglerealtransform4data-out-outoff-off-step-inv",headingTag:"h3"}}),ll=new y({props:{title:"utils/maths~NP2FFT",local:"utilsmathsnp2fft",headingTag:"h2"}}),il=new y({props:{title:"new NP2FFT(fft_length)",local:"new-np2fftfftlength",headingTag:"h3"}}),nl=new y({props:{title:"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>",local:"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code",headingTag:"h2"}}),{c(){v=o("meta"),cl=r(),pl=o("p"),Tl=r(),F=o("a"),yl=r(),n(_.$$.fragment),vl=r(),x=o("p"),x.textContent=bo,Fl=r(),b=o("p"),b.textContent=$o,_l=r(),$=o("ul"),$.innerHTML=Po,xl=r(),bl=o("hr"),$l=r(),P=o("a"),Pl=r(),n(A.$$.fragment),Al=r(),C=o("p"),C.innerHTML=Ao,Cl=r(),H=o("table"),H.innerHTML=Co,Hl=r(),Ll=o("hr"),Ml=r(),L=o("a"),wl=r(),n(M.$$.fragment),gl=r(),w=o("p"),w.innerHTML=Ho,El=r(),g=o("p"),g.innerHTML=Lo,Rl=r(),E=o("table"),E.innerHTML=Mo,zl=r(),kl=o("hr"),Kl=r(),R=o("a"),Ol=r(),n(z.$$.fragment),Bl=r(),k=o("p"),k.textContent=wo,Dl=r(),K=o("p"),K.innerHTML=go,Il=r(),O=o("table"),O.innerHTML=Eo,jl=r(),Ul=o("hr"),ql=r(),B=o("a"),Sl=r(),n(D.$$.fragment),Nl=r(),I=o("p"),I.textContent=Ro,Gl=r(),j=o("p"),j.innerHTML=zo,Jl=r(),U=o("table"),U.innerHTML=ko,Ql=r(),Vl=o("hr"),Wl=r(),q=o("a"),Xl=r(),n(S.$$.fragment),Yl=r(),N=o("p"),N.textContent=Ko,Zl=r(),G=o("p"),G.innerHTML=Oo,td=r(),J=o("table"),J.innerHTML=Bo,ed=r(),ld=o("hr"),dd=r(),Q=o("a"),rd=r(),n(V.$$.fragment),ad=r(),W=o("p"),W.textContent=Do,od=r(),X=o("p"),X.innerHTML=Io,id=r(),Y=o("table"),Y.innerHTML=jo,sd=r(),ud=o("hr"),md=r(),Z=o("a"),nd=r(),n(tt.$$.fragment),fd=r(),et=o("p"),et.textContent=Uo,pd=r(),lt=o("p"),lt.innerHTML=qo,hd=r(),dt=o("table"),dt.innerHTML=So,cd=r(),Td=o("hr"),yd=r(),rt=o("a"),vd=r(),n(at.$$.fragment),Fd=r(),ot=o("p"),ot.textContent=No,_d=r(),it=o("p"),it.innerHTML=Go,xd=r(),st=o("table"),st.innerHTML=Jo,bd=r(),$d=o("hr"),Pd=r(),ut=o("a"),Ad=r(),n(mt.$$.fragment),Cd=r(),nt=o("p"),nt.textContent=Qo,Hd=r(),ft=o("p"),ft.innerHTML=Vo,Ld=r(),pt=o("ul"),pt.innerHTML=Wo,Md=r(),ht=o("table"),ht.innerHTML=Xo,wd=r(),gd=o("hr"),Ed=r(),ct=o("a"),Rd=r(),n(Tt.$$.fragment),zd=r(),yt=o("p"),yt.textContent=Yo,kd=r(),vt=o("p"),vt.innerHTML=Zo,Kd=r(),Ft=o("ul"),Ft.innerHTML=ti,Od=r(),_t=o("table"),_t.innerHTML=ei,Bd=r(),Dd=o("hr"),Id=r(),xt=o("a"),jd=r(),n(bt.$$.fragment),Ud=r(),$t=o("p"),$t.textContent=li,qd=r(),Pt=o("p"),Pt.innerHTML=di,Sd=r(),At=o("table"),At.innerHTML=ri,Nd=r(),Gd=o("hr"),Jd=r(),Ct=o("a"),Qd=r(),n(Ht.$$.fragment),Vd=r(),Lt=o("p"),Lt.textContent=ai,Wd=r(),Mt=o("p"),Mt.innerHTML=oi,Xd=r(),wt=o("table"),wt.innerHTML=ii,Yd=r(),Zd=o("hr"),tr=r(),gt=o("a"),er=r(),n(Et.$$.fragment),lr=r(),Rt=o("p"),Rt.textContent=si,dr=r(),zt=o("p"),zt.innerHTML=ui,rr=r(),kt=o("p"),kt.innerHTML=mi,ar=r(),Kt=o("ul"),Kt.innerHTML=ni,or=r(),ir=o("hr"),sr=r(),Ot=o("a"),ur=r(),n(Bt.$$.fragment),mr=r(),Dt=o("p"),Dt.innerHTML=fi,nr=r(),It=o("ul"),It.innerHTML=pi,fr=r(),jt=o("table"),jt.innerHTML=hi,pr=r(),hr=o("hr"),cr=r(),Ut=o("a"),Tr=r(),n(qt.$$.fragment),yr=r(),St=o("p"),St.innerHTML=ci,vr=r(),Nt=o("p"),Nt.innerHTML=Ti,Fr=r(),_r=o("hr"),xr=r(),Gt=o("a"),br=r(),n(Jt.$$.fragment),$r=r(),Qt=o("p"),Qt.textContent=yi,Pr=r(),Vt=o("p"),Vt.innerHTML=vi,Ar=r(),Wt=o("table"),Wt.innerHTML=Fi,Cr=r(),Hr=o("hr"),Lr=r(),Xt=o("a"),Mr=r(),n(Yt.$$.fragment),wr=r(),Zt=o("p"),Zt.textContent=_i,gr=r(),te=o("p"),te.innerHTML=xi,Er=r(),ee=o("table"),ee.innerHTML=bi,Rr=r(),zr=o("hr"),kr=r(),le=o("a"),Kr=r(),n(de.$$.fragment),Or=r(),re=o("p"),re.textContent=$i,Br=r(),ae=o("p"),ae.innerHTML=Pi,Dr=r(),oe=o("table"),oe.innerHTML=Ai,Ir=r(),jr=o("hr"),Ur=r(),ie=o("a"),qr=r(),n(se.$$.fragment),Sr=r(),ue=o("p"),ue.textContent=Ci,Nr=r(),me=o("p"),me.innerHTML=Hi,Gr=r(),ne=o("ul"),ne.innerHTML=Li,Jr=r(),fe=o("table"),fe.innerHTML=Mi,Qr=r(),Vr=o("hr"),Wr=r(),pe=o("a"),Xr=r(),n(he.$$.fragment),Yr=r(),ce=o("p"),ce.textContent=wi,Zr=r(),Te=o("p"),Te.innerHTML=gi,ta=r(),ye=o("ul"),ye.innerHTML=Ei,ea=r(),ve=o("table"),ve.innerHTML=Ri,la=r(),da=o("hr"),ra=r(),Fe=o("a"),aa=r(),n(_e.$$.fragment),oa=r(),xe=o("p"),xe.innerHTML=zi,ia=r(),be=o("p"),be.innerHTML=ki,sa=r(),$e=o("ul"),$e.innerHTML=Ki,ua=r(),Pe=o("table"),Pe.innerHTML=Oi,ma=r(),na=o("hr"),fa=r(),Ae=o("a"),pa=r(),n(Ce.$$.fragment),ha=r(),He=o("p"),He.textContent=Bi,ca=r(),Le=o("p"),Le.innerHTML=Di,Ta=r(),Me=o("table"),Me.innerHTML=Ii,ya=r(),va=o("hr"),Fa=r(),we=o("a"),_a=r(),n(ge.$$.fragment),xa=r(),Ee=o("p"),Ee.textContent=ji,ba=r(),Re=o("p"),Re.innerHTML=Ui,$a=r(),ze=o("table"),ze.innerHTML=qi,Pa=r(),Aa=o("hr"),Ca=r(),ke=o("a"),Ha=r(),n(Ke.$$.fragment),La=r(),Oe=o("p"),Oe.textContent=Si,Ma=r(),Be=o("p"),Be.innerHTML=Ni,wa=r(),De=o("table"),De.innerHTML=Gi,ga=r(),Ea=o("hr"),Ra=r(),Ie=o("a"),za=r(),n(je.$$.fragment),ka=r(),Ue=o("p"),Ue.textContent=Ji,Ka=r(),qe=o("p"),qe.innerHTML=Qi,Oa=r(),Se=o("table"),Se.innerHTML=Vi,Ba=r(),Da=o("hr"),Ia=r(),Ne=o("a"),ja=r(),n(Ge.$$.fragment),Ua=r(),Je=o("p"),Je.textContent=Wi,qa=r(),Qe=o("p"),Qe.innerHTML=Xi,Sa=r(),Ve=o("table"),Ve.innerHTML=Yi,Na=r(),Ga=o("hr"),Ja=r(),We=o("a"),Qa=r(),n(Xe.$$.fragment),Va=r(),Ye=o("p"),Ye.textContent=Zi,Wa=r(),Ze=o("p"),Ze.innerHTML=ts,Xa=r(),tl=o("table"),tl.innerHTML=es,Ya=r(),Za=o("hr"),to=r(),el=o("a"),eo=r(),n(ll.$$.fragment),lo=r(),dl=o("p"),dl.textContent=ls,ro=r(),rl=o("p"),rl.innerHTML=ds,ao=r(),al=o("p"),al.innerHTML=rs,oo=r(),io=o("hr"),so=r(),ol=o("a"),uo=r(),n(il.$$.fragment),mo=r(),sl=o("p"),sl.textContent=as,no=r(),ul=o("table"),ul.innerHTML=os,fo=r(),po=o("hr"),ho=r(),ml=o("a"),co=r(),n(nl.$$.fragment),To=r(),fl=o("p"),fl.innerHTML=is,yo=r(),vo=o("hr"),Fo=r(),hl=o("p"),this.h()},l(t){const l=ps("svelte-u9bgzb",document.head);v=i(l,"META",{name:!0,content:!0}),l.forEach(e),cl=a(t),pl=i(t,"P",{}),m(pl).forEach(e),Tl=a(t),F=i(t,"A",{id:!0,class:!0}),m(F).forEach(e),yl=a(t),f(_.$$.fragment,t),vl=a(t),x=i(t,"P",{"data-svelte-h":!0}),s(x)!=="svelte-1d3zgi"&&(x.textContent=bo),Fl=a(t),b=i(t,"P",{"data-svelte-h":!0}),s(b)!=="svelte-il3kl8"&&(b.textContent=$o),_l=a(t),$=i(t,"UL",{"data-svelte-h":!0}),s($)!=="svelte-10zevgk"&&($.innerHTML=Po),xl=a(t),bl=i(t,"HR",{}),$l=a(t),P=i(t,"A",{id:!0,class:!0}),m(P).forEach(e),Pl=a(t),f(A.$$.fragment,t),Al=a(t),C=i(t,"P",{"data-svelte-h":!0}),s(C)!=="svelte-z8esp"&&(C.innerHTML=Ao),Cl=a(t),H=i(t,"TABLE",{"data-svelte-h":!0}),s(H)!=="svelte-13raiaj"&&(H.innerHTML=Co),Hl=a(t),Ll=i(t,"HR",{}),Ml=a(t),L=i(t,"A",{id:!0,class:!0}),m(L).forEach(e),wl=a(t),f(M.$$.fragment,t),gl=a(t),w=i(t,"P",{"data-svelte-h":!0}),s(w)!=="svelte-69x642"&&(w.innerHTML=Ho),El=a(t),g=i(t,"P",{"data-svelte-h":!0}),s(g)!=="svelte-1t49mrp"&&(g.innerHTML=Lo),Rl=a(t),E=i(t,"TABLE",{"data-svelte-h":!0}),s(E)!=="svelte-18fxup5"&&(E.innerHTML=Mo),zl=a(t),kl=i(t,"HR",{}),Kl=a(t),R=i(t,"A",{id:!0,class:!0}),m(R).forEach(e),Ol=a(t),f(z.$$.fragment,t),Bl=a(t),k=i(t,"P",{"data-svelte-h":!0}),s(k)!=="svelte-1liv70i"&&(k.textContent=wo),Dl=a(t),K=i(t,"P",{"data-svelte-h":!0}),s(K)!=="svelte-xvvopf"&&(K.innerHTML=go),Il=a(t),O=i(t,"TABLE",{"data-svelte-h":!0}),s(O)!=="svelte-adoxzf"&&(O.innerHTML=Eo),jl=a(t),Ul=i(t,"HR",{}),ql=a(t),B=i(t,"A",{id:!0,class:!0}),m(B).forEach(e),Sl=a(t),f(D.$$.fragment,t),Nl=a(t),I=i(t,"P",{"data-svelte-h":!0}),s(I)!=="svelte-5479oq"&&(I.textContent=Ro),Gl=a(t),j=i(t,"P",{"data-svelte-h":!0}),s(j)!=="svelte-m9boyl"&&(j.innerHTML=zo),Jl=a(t),U=i(t,"TABLE",{"data-svelte-h":!0}),s(U)!=="svelte-5wetzk"&&(U.innerHTML=ko),Ql=a(t),Vl=i(t,"HR",{}),Wl=a(t),q=i(t,"A",{id:!0,class:!0}),m(q).forEach(e),Xl=a(t),f(S.$$.fragment,t),Yl=a(t),N=i(t,"P",{"data-svelte-h":!0}),s(N)!=="svelte-1kaf4lx"&&(N.textContent=Ko),Zl=a(t),G=i(t,"P",{"data-svelte-h":!0}),s(G)!=="svelte-gudhvq"&&(G.innerHTML=Oo),td=a(t),J=i(t,"TABLE",{"data-svelte-h":!0}),s(J)!=="svelte-nyqk4k"&&(J.innerHTML=Bo),ed=a(t),ld=i(t,"HR",{}),dd=a(t),Q=i(t,"A",{id:!0,class:!0}),m(Q).forEach(e),rd=a(t),f(V.$$.fragment,t),ad=a(t),W=i(t,"P",{"data-svelte-h":!0}),s(W)!=="svelte-s7mgi8"&&(W.textContent=Do),od=a(t),X=i(t,"P",{"data-svelte-h":!0}),s(X)!=="svelte-5oll1y"&&(X.innerHTML=Io),id=a(t),Y=i(t,"TABLE",{"data-svelte-h":!0}),s(Y)!=="svelte-n1lt7"&&(Y.innerHTML=jo),sd=a(t),ud=i(t,"HR",{}),md=a(t),Z=i(t,"A",{id:!0,class:!0}),m(Z).forEach(e),nd=a(t),f(tt.$$.fragment,t),fd=a(t),et=i(t,"P",{"data-svelte-h":!0}),s(et)!=="svelte-6quqqj"&&(et.textContent=Uo),pd=a(t),lt=i(t,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-1y45k06"&&(lt.innerHTML=qo),hd=a(t),dt=i(t,"TABLE",{"data-svelte-h":!0}),s(dt)!=="svelte-nyqk4k"&&(dt.innerHTML=So),cd=a(t),Td=i(t,"HR",{}),yd=a(t),rt=i(t,"A",{id:!0,class:!0}),m(rt).forEach(e),vd=a(t),f(at.$$.fragment,t),Fd=a(t),ot=i(t,"P",{"data-svelte-h":!0}),s(ot)!=="svelte-132v21g"&&(ot.textContent=No),_d=a(t),it=i(t,"P",{"data-svelte-h":!0}),s(it)!=="svelte-odriss"&&(it.innerHTML=Go),xd=a(t),st=i(t,"TABLE",{"data-svelte-h":!0}),s(st)!=="svelte-nbo00i"&&(st.innerHTML=Jo),bd=a(t),$d=i(t,"HR",{}),Pd=a(t),ut=i(t,"A",{id:!0,class:!0}),m(ut).forEach(e),Ad=a(t),f(mt.$$.fragment,t),Cd=a(t),nt=i(t,"P",{"data-svelte-h":!0}),s(nt)!=="svelte-67h0u1"&&(nt.textContent=Qo),Hd=a(t),ft=i(t,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-cs0f6n"&&(ft.innerHTML=Vo),Ld=a(t),pt=i(t,"UL",{"data-svelte-h":!0}),s(pt)!=="svelte-jusv8t"&&(pt.innerHTML=Wo),Md=a(t),ht=i(t,"TABLE",{"data-svelte-h":!0}),s(ht)!=="svelte-mtkj0x"&&(ht.innerHTML=Xo),wd=a(t),gd=i(t,"HR",{}),Ed=a(t),ct=i(t,"A",{id:!0,class:!0}),m(ct).forEach(e),Rd=a(t),f(Tt.$$.fragment,t),zd=a(t),yt=i(t,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-9vv4b"&&(yt.textContent=Yo),kd=a(t),vt=i(t,"P",{"data-svelte-h":!0}),s(vt)!=="svelte-1ixuuwb"&&(vt.innerHTML=Zo),Kd=a(t),Ft=i(t,"UL",{"data-svelte-h":!0}),s(Ft)!=="svelte-jusv8t"&&(Ft.innerHTML=ti),Od=a(t),_t=i(t,"TABLE",{"data-svelte-h":!0}),s(_t)!=="svelte-oriydz"&&(_t.innerHTML=ei),Bd=a(t),Dd=i(t,"HR",{}),Id=a(t),xt=i(t,"A",{id:!0,class:!0}),m(xt).forEach(e),jd=a(t),f(bt.$$.fragment,t),Ud=a(t),$t=i(t,"P",{"data-svelte-h":!0}),s($t)!=="svelte-xb1vdd"&&($t.textContent=li),qd=a(t),Pt=i(t,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-z8esp"&&(Pt.innerHTML=di),Sd=a(t),At=i(t,"TABLE",{"data-svelte-h":!0}),s(At)!=="svelte-pk7ooi"&&(At.innerHTML=ri),Nd=a(t),Gd=i(t,"HR",{}),Jd=a(t),Ct=i(t,"A",{id:!0,class:!0}),m(Ct).forEach(e),Qd=a(t),f(Ht.$$.fragment,t),Vd=a(t),Lt=i(t,"P",{"data-svelte-h":!0}),s(Lt)!=="svelte-11aka64"&&(Lt.textContent=ai),Wd=a(t),Mt=i(t,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-jttckh"&&(Mt.innerHTML=oi),Xd=a(t),wt=i(t,"TABLE",{"data-svelte-h":!0}),s(wt)!=="svelte-c6gnt1"&&(wt.innerHTML=ii),Yd=a(t),Zd=i(t,"HR",{}),tr=a(t),gt=i(t,"A",{id:!0,class:!0}),m(gt).forEach(e),er=a(t),f(Et.$$.fragment,t),lr=a(t),Rt=i(t,"P",{"data-svelte-h":!0}),s(Rt)!=="svelte-16m1u76"&&(Rt.textContent=si),dr=a(t),zt=i(t,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-698ey0"&&(zt.innerHTML=ui),rr=a(t),kt=i(t,"P",{"data-svelte-h":!0}),s(kt)!=="svelte-tjke50"&&(kt.innerHTML=mi),ar=a(t),Kt=i(t,"UL",{"data-svelte-h":!0}),s(Kt)!=="svelte-1iua3xn"&&(Kt.innerHTML=ni),or=a(t),ir=i(t,"HR",{}),sr=a(t),Ot=i(t,"A",{id:!0,class:!0}),m(Ot).forEach(e),ur=a(t),f(Bt.$$.fragment,t),mr=a(t),Dt=i(t,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-1fz4yns"&&(Dt.innerHTML=fi),nr=a(t),It=i(t,"UL",{"data-svelte-h":!0}),s(It)!=="svelte-ph0ovr"&&(It.innerHTML=pi),fr=a(t),jt=i(t,"TABLE",{"data-svelte-h":!0}),s(jt)!=="svelte-a5vdxc"&&(jt.innerHTML=hi),pr=a(t),hr=i(t,"HR",{}),cr=a(t),Ut=i(t,"A",{id:!0,class:!0}),m(Ut).forEach(e),Tr=a(t),f(qt.$$.fragment,t),yr=a(t),St=i(t,"P",{"data-svelte-h":!0}),s(St)!=="svelte-1rrw4ya"&&(St.innerHTML=ci),vr=a(t),Nt=i(t,"P",{"data-svelte-h":!0}),s(Nt)!=="svelte-1gdnoew"&&(Nt.innerHTML=Ti),Fr=a(t),_r=i(t,"HR",{}),xr=a(t),Gt=i(t,"A",{id:!0,class:!0}),m(Gt).forEach(e),br=a(t),f(Jt.$$.fragment,t),$r=a(t),Qt=i(t,"P",{"data-svelte-h":!0}),s(Qt)!=="svelte-1693r4v"&&(Qt.textContent=yi),Pr=a(t),Vt=i(t,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-33y4ax"&&(Vt.innerHTML=vi),Ar=a(t),Wt=i(t,"TABLE",{"data-svelte-h":!0}),s(Wt)!=="svelte-1td0xj2"&&(Wt.innerHTML=Fi),Cr=a(t),Hr=i(t,"HR",{}),Lr=a(t),Xt=i(t,"A",{id:!0,class:!0}),m(Xt).forEach(e),Mr=a(t),f(Yt.$$.fragment,t),wr=a(t),Zt=i(t,"P",{"data-svelte-h":!0}),s(Zt)!=="svelte-rsnsrd"&&(Zt.textContent=_i),gr=a(t),te=i(t,"P",{"data-svelte-h":!0}),s(te)!=="svelte-1xayhm7"&&(te.innerHTML=xi),Er=a(t),ee=i(t,"TABLE",{"data-svelte-h":!0}),s(ee)!=="svelte-1up5toh"&&(ee.innerHTML=bi),Rr=a(t),zr=i(t,"HR",{}),kr=a(t),le=i(t,"A",{id:!0,class:!0}),m(le).forEach(e),Kr=a(t),f(de.$$.fragment,t),Or=a(t),re=i(t,"P",{"data-svelte-h":!0}),s(re)!=="svelte-id49q5"&&(re.textContent=$i),Br=a(t),ae=i(t,"P",{"data-svelte-h":!0}),s(ae)!=="svelte-1dkdszr"&&(ae.innerHTML=Pi),Dr=a(t),oe=i(t,"TABLE",{"data-svelte-h":!0}),s(oe)!=="svelte-15tum1z"&&(oe.innerHTML=Ai),Ir=a(t),jr=i(t,"HR",{}),Ur=a(t),ie=i(t,"A",{id:!0,class:!0}),m(ie).forEach(e),qr=a(t),f(se.$$.fragment,t),Sr=a(t),ue=i(t,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-846pp1"&&(ue.textContent=Ci),Nr=a(t),me=i(t,"P",{"data-svelte-h":!0}),s(me)!=="svelte-1t2xajz"&&(me.innerHTML=Hi),Gr=a(t),ne=i(t,"UL",{"data-svelte-h":!0}),s(ne)!=="svelte-173tqd8"&&(ne.innerHTML=Li),Jr=a(t),fe=i(t,"TABLE",{"data-svelte-h":!0}),s(fe)!=="svelte-1buvx7j"&&(fe.innerHTML=Mi),Qr=a(t),Vr=i(t,"HR",{}),Wr=a(t),pe=i(t,"A",{id:!0,class:!0}),m(pe).forEach(e),Xr=a(t),f(he.$$.fragment,t),Yr=a(t),ce=i(t,"P",{"data-svelte-h":!0}),s(ce)!=="svelte-ozshoc"&&(ce.textContent=wi),Zr=a(t),Te=i(t,"P",{"data-svelte-h":!0}),s(Te)!=="svelte-1t2xajz"&&(Te.innerHTML=gi),ta=a(t),ye=i(t,"UL",{"data-svelte-h":!0}),s(ye)!=="svelte-1ap3720"&&(ye.innerHTML=Ei),ea=a(t),ve=i(t,"TABLE",{"data-svelte-h":!0}),s(ve)!=="svelte-lghmn6"&&(ve.innerHTML=Ri),la=a(t),da=i(t,"HR",{}),ra=a(t),Fe=i(t,"A",{id:!0,class:!0}),m(Fe).forEach(e),aa=a(t),f(_e.$$.fragment,t),oa=a(t),xe=i(t,"P",{"data-svelte-h":!0}),s(xe)!=="svelte-ijignt"&&(xe.innerHTML=zi),ia=a(t),be=i(t,"P",{"data-svelte-h":!0}),s(be)!=="svelte-1t2xajz"&&(be.innerHTML=ki),sa=a(t),$e=i(t,"UL",{"data-svelte-h":!0}),s($e)!=="svelte-1bp21xg"&&($e.innerHTML=Ki),ua=a(t),Pe=i(t,"TABLE",{"data-svelte-h":!0}),s(Pe)!=="svelte-edt5vq"&&(Pe.innerHTML=Oi),ma=a(t),na=i(t,"HR",{}),fa=a(t),Ae=i(t,"A",{id:!0,class:!0}),m(Ae).forEach(e),pa=a(t),f(Ce.$$.fragment,t),ha=a(t),He=i(t,"P",{"data-svelte-h":!0}),s(He)!=="svelte-3r4wxn"&&(He.textContent=Bi),ca=a(t),Le=i(t,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-1dkdszr"&&(Le.innerHTML=Di),Ta=a(t),Me=i(t,"TABLE",{"data-svelte-h":!0}),s(Me)!=="svelte-15z8087"&&(Me.innerHTML=Ii),ya=a(t),va=i(t,"HR",{}),Fa=a(t),we=i(t,"A",{id:!0,class:!0}),m(we).forEach(e),_a=a(t),f(ge.$$.fragment,t),xa=a(t),Ee=i(t,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-1jz5wqp"&&(Ee.textContent=ji),ba=a(t),Re=i(t,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-1dkdszr"&&(Re.innerHTML=Ui),$a=a(t),ze=i(t,"TABLE",{"data-svelte-h":!0}),s(ze)!=="svelte-fx5ob"&&(ze.innerHTML=qi),Pa=a(t),Aa=i(t,"HR",{}),Ca=a(t),ke=i(t,"A",{id:!0,class:!0}),m(ke).forEach(e),Ha=a(t),f(Ke.$$.fragment,t),La=a(t),Oe=i(t,"P",{"data-svelte-h":!0}),s(Oe)!=="svelte-1baynqa"&&(Oe.textContent=Si),Ma=a(t),Be=i(t,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-1dkdszr"&&(Be.innerHTML=Ni),wa=a(t),De=i(t,"TABLE",{"data-svelte-h":!0}),s(De)!=="svelte-szv30n"&&(De.innerHTML=Gi),ga=a(t),Ea=i(t,"HR",{}),Ra=a(t),Ie=i(t,"A",{id:!0,class:!0}),m(Ie).forEach(e),za=a(t),f(je.$$.fragment,t),ka=a(t),Ue=i(t,"P",{"data-svelte-h":!0}),s(Ue)!=="svelte-1gll44b"&&(Ue.textContent=Ji),Ka=a(t),qe=i(t,"P",{"data-svelte-h":!0}),s(qe)!=="svelte-1dkdszr"&&(qe.innerHTML=Qi),Oa=a(t),Se=i(t,"TABLE",{"data-svelte-h":!0}),s(Se)!=="svelte-159qhrx"&&(Se.innerHTML=Vi),Ba=a(t),Da=i(t,"HR",{}),Ia=a(t),Ne=i(t,"A",{id:!0,class:!0}),m(Ne).forEach(e),ja=a(t),f(Ge.$$.fragment,t),Ua=a(t),Je=i(t,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-1upf1p8"&&(Je.textContent=Wi),qa=a(t),Qe=i(t,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-1dkdszr"&&(Qe.innerHTML=Xi),Sa=a(t),Ve=i(t,"TABLE",{"data-svelte-h":!0}),s(Ve)!=="svelte-18nciet"&&(Ve.innerHTML=Yi),Na=a(t),Ga=i(t,"HR",{}),Ja=a(t),We=i(t,"A",{id:!0,class:!0}),m(We).forEach(e),Qa=a(t),f(Xe.$$.fragment,t),Va=a(t),Ye=i(t,"P",{"data-svelte-h":!0}),s(Ye)!=="svelte-8fqhv2"&&(Ye.textContent=Zi),Wa=a(t),Ze=i(t,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-1dkdszr"&&(Ze.innerHTML=ts),Xa=a(t),tl=i(t,"TABLE",{"data-svelte-h":!0}),s(tl)!=="svelte-pf887e"&&(tl.innerHTML=es),Ya=a(t),Za=i(t,"HR",{}),to=a(t),el=i(t,"A",{id:!0,class:!0}),m(el).forEach(e),eo=a(t),f(ll.$$.fragment,t),lo=a(t),dl=i(t,"P",{"data-svelte-h":!0}),s(dl)!=="svelte-yw51a0"&&(dl.textContent=ls),ro=a(t),rl=i(t,"P",{"data-svelte-h":!0}),s(rl)!=="svelte-1gw6hta"&&(rl.innerHTML=ds),ao=a(t),al=i(t,"P",{"data-svelte-h":!0}),s(al)!=="svelte-tjke50"&&(al.innerHTML=rs),oo=a(t),io=i(t,"HR",{}),so=a(t),ol=i(t,"A",{id:!0,class:!0}),m(ol).forEach(e),uo=a(t),f(il.$$.fragment,t),mo=a(t),sl=i(t,"P",{"data-svelte-h":!0}),s(sl)!=="svelte-lvoqsi"&&(sl.textContent=as),no=a(t),ul=i(t,"TABLE",{"data-svelte-h":!0}),s(ul)!=="svelte-1gtay08"&&(ul.innerHTML=os),fo=a(t),po=i(t,"HR",{}),ho=a(t),ml=i(t,"A",{id:!0,class:!0}),m(ml).forEach(e),co=a(t),f(nl.$$.fragment,t),To=a(t),fl=i(t,"P",{"data-svelte-h":!0}),s(fl)!=="svelte-9rr3v5"&&(fl.innerHTML=is),yo=a(t),vo=i(t,"HR",{}),Fo=a(t),hl=i(t,"P",{}),m(hl).forEach(e),this.h()},h(){u(v,"name","hf:doc:metadata"),u(v,"content",Ts),u(F,"id","module_utils/maths"),u(F,"class","group"),u(P,"id","module_utils/maths.interpolate_data"),u(P,"class","group"),u(L,"id","module_utils/maths.transpose_data"),u(L,"class","group"),u(R,"id","module_utils/maths.softmax"),u(R,"class","group"),u(B,"id","module_utils/maths.log_softmax"),u(B,"class","group"),u(q,"id","module_utils/maths.dot"),u(q,"class","group"),u(Q,"id","module_utils/maths.getTopItems"),u(Q,"class","group"),u(Z,"id","module_utils/maths.cos_sim"),u(Z,"class","group"),u(rt,"id","module_utils/maths.magnitude"),u(rt,"class","group"),u(ut,"id","module_utils/maths.min"),u(ut,"class","group"),u(ct,"id","module_utils/maths.max"),u(ct,"class","group"),u(xt,"id","module_utils/maths.medianFilter"),u(xt,"class","group"),u(Ct,"id","module_utils/maths.round"),u(Ct,"class","group"),u(gt,"id","module_utils/maths..P2FFT"),u(gt,"class","group"),u(Ot,"id","new_module_utils/maths..P2FFT_new"),u(Ot,"class","group"),u(Ut,"id","module_utils/maths..P2FFT+createComplexArray"),u(Ut,"class","group"),u(Gt,"id","module_utils/maths..P2FFT+fromComplexArray"),u(Gt,"class","group"),u(Xt,"id","module_utils/maths..P2FFT+toComplexArray"),u(Xt,"class","group"),u(le,"id","module_utils/maths..P2FFT+completeSpectrum"),u(le,"class","group"),u(ie,"id","module_utils/maths..P2FFT+transform"),u(ie,"class","group"),u(pe,"id","module_utils/maths..P2FFT+realTransform"),u(pe,"class","group"),u(Fe,"id","module_utils/maths..P2FFT+inverseTransform"),u(Fe,"class","group"),u(Ae,"id","module_utils/maths..P2FFT+_transform4"),u(Ae,"class","group"),u(we,"id","module_utils/maths..P2FFT+_singleTransform2"),u(we,"class","group"),u(ke,"id","module_utils/maths..P2FFT+_singleTransform4"),u(ke,"class","group"),u(Ie,"id","module_utils/maths..P2FFT+_realTransform4"),u(Ie,"class","group"),u(Ne,"id","module_utils/maths..P2FFT+_singleRealTransform2"),u(Ne,"class","group"),u(We,"id","module_utils/maths..P2FFT+_singleRealTransform4"),u(We,"class","group"),u(el,"id","module_utils/maths..NP2FFT"),u(el,"class","group"),u(ol,"id","new_module_utils/maths..NP2FFT_new"),u(ol,"class","group"),u(ml,"id","module_utils/maths..AnyTypedArray"),u(ml,"class","group")},m(t,l){hs(document.head,v),d(t,cl,l),d(t,pl,l),d(t,Tl,l),d(t,F,l),d(t,yl,l),p(_,t,l),d(t,vl,l),d(t,x,l),d(t,Fl,l),d(t,b,l),d(t,_l,l),d(t,$,l),d(t,xl,l),d(t,bl,l),d(t,$l,l),d(t,P,l),d(t,Pl,l),p(A,t,l),d(t,Al,l),d(t,C,l),d(t,Cl,l),d(t,H,l),d(t,Hl,l),d(t,Ll,l),d(t,Ml,l),d(t,L,l),d(t,wl,l),p(M,t,l),d(t,gl,l),d(t,w,l),d(t,El,l),d(t,g,l),d(t,Rl,l),d(t,E,l),d(t,zl,l),d(t,kl,l),d(t,Kl,l),d(t,R,l),d(t,Ol,l),p(z,t,l),d(t,Bl,l),d(t,k,l),d(t,Dl,l),d(t,K,l),d(t,Il,l),d(t,O,l),d(t,jl,l),d(t,Ul,l),d(t,ql,l),d(t,B,l),d(t,Sl,l),p(D,t,l),d(t,Nl,l),d(t,I,l),d(t,Gl,l),d(t,j,l),d(t,Jl,l),d(t,U,l),d(t,Ql,l),d(t,Vl,l),d(t,Wl,l),d(t,q,l),d(t,Xl,l),p(S,t,l),d(t,Yl,l),d(t,N,l),d(t,Zl,l),d(t,G,l),d(t,td,l),d(t,J,l),d(t,ed,l),d(t,ld,l),d(t,dd,l),d(t,Q,l),d(t,rd,l),p(V,t,l),d(t,ad,l),d(t,W,l),d(t,od,l),d(t,X,l),d(t,id,l),d(t,Y,l),d(t,sd,l),d(t,ud,l),d(t,md,l),d(t,Z,l),d(t,nd,l),p(tt,t,l),d(t,fd,l),d(t,et,l),d(t,pd,l),d(t,lt,l),d(t,hd,l),d(t,dt,l),d(t,cd,l),d(t,Td,l),d(t,yd,l),d(t,rt,l),d(t,vd,l),p(at,t,l),d(t,Fd,l),d(t,ot,l),d(t,_d,l),d(t,it,l),d(t,xd,l),d(t,st,l),d(t,bd,l),d(t,$d,l),d(t,Pd,l),d(t,ut,l),d(t,Ad,l),p(mt,t,l),d(t,Cd,l),d(t,nt,l),d(t,Hd,l),d(t,ft,l),d(t,Ld,l),d(t,pt,l),d(t,Md,l),d(t,ht,l),d(t,wd,l),d(t,gd,l),d(t,Ed,l),d(t,ct,l),d(t,Rd,l),p(Tt,t,l),d(t,zd,l),d(t,yt,l),d(t,kd,l),d(t,vt,l),d(t,Kd,l),d(t,Ft,l),d(t,Od,l),d(t,_t,l),d(t,Bd,l),d(t,Dd,l),d(t,Id,l),d(t,xt,l),d(t,jd,l),p(bt,t,l),d(t,Ud,l),d(t,$t,l),d(t,qd,l),d(t,Pt,l),d(t,Sd,l),d(t,At,l),d(t,Nd,l),d(t,Gd,l),d(t,Jd,l),d(t,Ct,l),d(t,Qd,l),p(Ht,t,l),d(t,Vd,l),d(t,Lt,l),d(t,Wd,l),d(t,Mt,l),d(t,Xd,l),d(t,wt,l),d(t,Yd,l),d(t,Zd,l),d(t,tr,l),d(t,gt,l),d(t,er,l),p(Et,t,l),d(t,lr,l),d(t,Rt,l),d(t,dr,l),d(t,zt,l),d(t,rr,l),d(t,kt,l),d(t,ar,l),d(t,Kt,l),d(t,or,l),d(t,ir,l),d(t,sr,l),d(t,Ot,l),d(t,ur,l),p(Bt,t,l),d(t,mr,l),d(t,Dt,l),d(t,nr,l),d(t,It,l),d(t,fr,l),d(t,jt,l),d(t,pr,l),d(t,hr,l),d(t,cr,l),d(t,Ut,l),d(t,Tr,l),p(qt,t,l),d(t,yr,l),d(t,St,l),d(t,vr,l),d(t,Nt,l),d(t,Fr,l),d(t,_r,l),d(t,xr,l),d(t,Gt,l),d(t,br,l),p(Jt,t,l),d(t,$r,l),d(t,Qt,l),d(t,Pr,l),d(t,Vt,l),d(t,Ar,l),d(t,Wt,l),d(t,Cr,l),d(t,Hr,l),d(t,Lr,l),d(t,Xt,l),d(t,Mr,l),p(Yt,t,l),d(t,wr,l),d(t,Zt,l),d(t,gr,l),d(t,te,l),d(t,Er,l),d(t,ee,l),d(t,Rr,l),d(t,zr,l),d(t,kr,l),d(t,le,l),d(t,Kr,l),p(de,t,l),d(t,Or,l),d(t,re,l),d(t,Br,l),d(t,ae,l),d(t,Dr,l),d(t,oe,l),d(t,Ir,l),d(t,jr,l),d(t,Ur,l),d(t,ie,l),d(t,qr,l),p(se,t,l),d(t,Sr,l),d(t,ue,l),d(t,Nr,l),d(t,me,l),d(t,Gr,l),d(t,ne,l),d(t,Jr,l),d(t,fe,l),d(t,Qr,l),d(t,Vr,l),d(t,Wr,l),d(t,pe,l),d(t,Xr,l),p(he,t,l),d(t,Yr,l),d(t,ce,l),d(t,Zr,l),d(t,Te,l),d(t,ta,l),d(t,ye,l),d(t,ea,l),d(t,ve,l),d(t,la,l),d(t,da,l),d(t,ra,l),d(t,Fe,l),d(t,aa,l),p(_e,t,l),d(t,oa,l),d(t,xe,l),d(t,ia,l),d(t,be,l),d(t,sa,l),d(t,$e,l),d(t,ua,l),d(t,Pe,l),d(t,ma,l),d(t,na,l),d(t,fa,l),d(t,Ae,l),d(t,pa,l),p(Ce,t,l),d(t,ha,l),d(t,He,l),d(t,ca,l),d(t,Le,l),d(t,Ta,l),d(t,Me,l),d(t,ya,l),d(t,va,l),d(t,Fa,l),d(t,we,l),d(t,_a,l),p(ge,t,l),d(t,xa,l),d(t,Ee,l),d(t,ba,l),d(t,Re,l),d(t,$a,l),d(t,ze,l),d(t,Pa,l),d(t,Aa,l),d(t,Ca,l),d(t,ke,l),d(t,Ha,l),p(Ke,t,l),d(t,La,l),d(t,Oe,l),d(t,Ma,l),d(t,Be,l),d(t,wa,l),d(t,De,l),d(t,ga,l),d(t,Ea,l),d(t,Ra,l),d(t,Ie,l),d(t,za,l),p(je,t,l),d(t,ka,l),d(t,Ue,l),d(t,Ka,l),d(t,qe,l),d(t,Oa,l),d(t,Se,l),d(t,Ba,l),d(t,Da,l),d(t,Ia,l),d(t,Ne,l),d(t,ja,l),p(Ge,t,l),d(t,Ua,l),d(t,Je,l),d(t,qa,l),d(t,Qe,l),d(t,Sa,l),d(t,Ve,l),d(t,Na,l),d(t,Ga,l),d(t,Ja,l),d(t,We,l),d(t,Qa,l),p(Xe,t,l),d(t,Va,l),d(t,Ye,l),d(t,Wa,l),d(t,Ze,l),d(t,Xa,l),d(t,tl,l),d(t,Ya,l),d(t,Za,l),d(t,to,l),d(t,el,l),d(t,eo,l),p(ll,t,l),d(t,lo,l),d(t,dl,l),d(t,ro,l),d(t,rl,l),d(t,ao,l),d(t,al,l),d(t,oo,l),d(t,io,l),d(t,so,l),d(t,ol,l),d(t,uo,l),p(il,t,l),d(t,mo,l),d(t,sl,l),d(t,no,l),d(t,ul,l),d(t,fo,l),d(t,po,l),d(t,ho,l),d(t,ml,l),d(t,co,l),p(nl,t,l),d(t,To,l),d(t,fl,l),d(t,yo,l),d(t,vo,l),d(t,Fo,l),d(t,hl,l),_o=!0},p:us,i(t){_o||(h(_.$$.fragment,t),h(A.$$.fragment,t),h(M.$$.fragment,t),h(z.$$.fragment,t),h(D.$$.fragment,t),h(S.$$.fragment,t),h(V.$$.fragment,t),h(tt.$$.fragment,t),h(at.$$.fragment,t),h(mt.$$.fragment,t),h(Tt.$$.fragment,t),h(bt.$$.fragment,t),h(Ht.$$.fragment,t),h(Et.$$.fragment,t),h(Bt.$$.fragment,t),h(qt.$$.fragment,t),h(Jt.$$.fragment,t),h(Yt.$$.fragment,t),h(de.$$.fragment,t),h(se.$$.fragment,t),h(he.$$.fragment,t),h(_e.$$.fragment,t),h(Ce.$$.fragment,t),h(ge.$$.fragment,t),h(Ke.$$.fragment,t),h(je.$$.fragment,t),h(Ge.$$.fragment,t),h(Xe.$$.fragment,t),h(ll.$$.fragment,t),h(il.$$.fragment,t),h(nl.$$.fragment,t),_o=!0)},o(t){c(_.$$.fragment,t),c(A.$$.fragment,t),c(M.$$.fragment,t),c(z.$$.fragment,t),c(D.$$.fragment,t),c(S.$$.fragment,t),c(V.$$.fragment,t),c(tt.$$.fragment,t),c(at.$$.fragment,t),c(mt.$$.fragment,t),c(Tt.$$.fragment,t),c(bt.$$.fragment,t),c(Ht.$$.fragment,t),c(Et.$$.fragment,t),c(Bt.$$.fragment,t),c(qt.$$.fragment,t),c(Jt.$$.fragment,t),c(Yt.$$.fragment,t),c(de.$$.fragment,t),c(se.$$.fragment,t),c(he.$$.fragment,t),c(_e.$$.fragment,t),c(Ce.$$.fragment,t),c(ge.$$.fragment,t),c(Ke.$$.fragment,t),c(je.$$.fragment,t),c(Ge.$$.fragment,t),c(Xe.$$.fragment,t),c(ll.$$.fragment,t),c(il.$$.fragment,t),c(nl.$$.fragment,t),_o=!1},d(t){t&&(e(cl),e(pl),e(Tl),e(F),e(yl),e(vl),e(x),e(Fl),e(b),e(_l),e($),e(xl),e(bl),e($l),e(P),e(Pl),e(Al),e(C),e(Cl),e(H),e(Hl),e(Ll),e(Ml),e(L),e(wl),e(gl),e(w),e(El),e(g),e(Rl),e(E),e(zl),e(kl),e(Kl),e(R),e(Ol),e(Bl),e(k),e(Dl),e(K),e(Il),e(O),e(jl),e(Ul),e(ql),e(B),e(Sl),e(Nl),e(I),e(Gl),e(j),e(Jl),e(U),e(Ql),e(Vl),e(Wl),e(q),e(Xl),e(Yl),e(N),e(Zl),e(G),e(td),e(J),e(ed),e(ld),e(dd),e(Q),e(rd),e(ad),e(W),e(od),e(X),e(id),e(Y),e(sd),e(ud),e(md),e(Z),e(nd),e(fd),e(et),e(pd),e(lt),e(hd),e(dt),e(cd),e(Td),e(yd),e(rt),e(vd),e(Fd),e(ot),e(_d),e(it),e(xd),e(st),e(bd),e($d),e(Pd),e(ut),e(Ad),e(Cd),e(nt),e(Hd),e(ft),e(Ld),e(pt),e(Md),e(ht),e(wd),e(gd),e(Ed),e(ct),e(Rd),e(zd),e(yt),e(kd),e(vt),e(Kd),e(Ft),e(Od),e(_t),e(Bd),e(Dd),e(Id),e(xt),e(jd),e(Ud),e($t),e(qd),e(Pt),e(Sd),e(At),e(Nd),e(Gd),e(Jd),e(Ct),e(Qd),e(Vd),e(Lt),e(Wd),e(Mt),e(Xd),e(wt),e(Yd),e(Zd),e(tr),e(gt),e(er),e(lr),e(Rt),e(dr),e(zt),e(rr),e(kt),e(ar),e(Kt),e(or),e(ir),e(sr),e(Ot),e(ur),e(mr),e(Dt),e(nr),e(It),e(fr),e(jt),e(pr),e(hr),e(cr),e(Ut),e(Tr),e(yr),e(St),e(vr),e(Nt),e(Fr),e(_r),e(xr),e(Gt),e(br),e($r),e(Qt),e(Pr),e(Vt),e(Ar),e(Wt),e(Cr),e(Hr),e(Lr),e(Xt),e(Mr),e(wr),e(Zt),e(gr),e(te),e(Er),e(ee),e(Rr),e(zr),e(kr),e(le),e(Kr),e(Or),e(re),e(Br),e(ae),e(Dr),e(oe),e(Ir),e(jr),e(Ur),e(ie),e(qr),e(Sr),e(ue),e(Nr),e(me),e(Gr),e(ne),e(Jr),e(fe),e(Qr),e(Vr),e(Wr),e(pe),e(Xr),e(Yr),e(ce),e(Zr),e(Te),e(ta),e(ye),e(ea),e(ve),e(la),e(da),e(ra),e(Fe),e(aa),e(oa),e(xe),e(ia),e(be),e(sa),e($e),e(ua),e(Pe),e(ma),e(na),e(fa),e(Ae),e(pa),e(ha),e(He),e(ca),e(Le),e(Ta),e(Me),e(ya),e(va),e(Fa),e(we),e(_a),e(xa),e(Ee),e(ba),e(Re),e($a),e(ze),e(Pa),e(Aa),e(Ca),e(ke),e(Ha),e(La),e(Oe),e(Ma),e(Be),e(wa),e(De),e(ga),e(Ea),e(Ra),e(Ie),e(za),e(ka),e(Ue),e(Ka),e(qe),e(Oa),e(Se),e(Ba),e(Da),e(Ia),e(Ne),e(ja),e(Ua),e(Je),e(qa),e(Qe),e(Sa),e(Ve),e(Na),e(Ga),e(Ja),e(We),e(Qa),e(Va),e(Ye),e(Wa),e(Ze),e(Xa),e(tl),e(Ya),e(Za),e(to),e(el),e(eo),e(lo),e(dl),e(ro),e(rl),e(ao),e(al),e(oo),e(io),e(so),e(ol),e(uo),e(mo),e(sl),e(no),e(ul),e(fo),e(po),e(ho),e(ml),e(co),e(To),e(fl),e(yo),e(vo),e(Fo),e(hl)),e(v),T(_,t),T(A,t),T(M,t),T(z,t),T(D,t),T(S,t),T(V,t),T(tt,t),T(at,t),T(mt,t),T(Tt,t),T(bt,t),T(Ht,t),T(Et,t),T(Bt,t),T(qt,t),T(Jt,t),T(Yt,t),T(de,t),T(se,t),T(he,t),T(_e,t),T(Ce,t),T(ge,t),T(Ke,t),T(je,t),T(Ge,t),T(Xe,t),T(ll,t),T(il,t),T(nl,t)}}}const Ts='{"title":"utils/maths","local":"utilsmaths","sections":[{"title":"utils/maths.interpolate_data(input)","local":"utilsmathsinterpolatedatainput","sections":[],"depth":2},{"title":"utils/maths.transpose_data(array, dims, axes) ⇒ <code> * </code>","local":"utilsmathstransposedataarray-dims-axes--code--code","sections":[],"depth":2},{"title":"utils/maths.softmax(arr) ⇒ <code> T </code>","local":"utilsmathssoftmaxarr--code-t-code","sections":[],"depth":2},{"title":"utils/maths.log_softmax(arr) ⇒ <code> T </code>","local":"utilsmathslogsoftmaxarr--code-t-code","sections":[],"depth":2},{"title":"utils/maths.dot(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathsdotarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.getTopItems(items, [top_k]) ⇒ <code> * </code>","local":"utilsmathsgettopitemsitems-topk--code--code","sections":[],"depth":2},{"title":"utils/maths.cos_sim(arr1, arr2) ⇒ <code> number </code>","local":"utilsmathscossimarr1-arr2--code-number-code","sections":[],"depth":2},{"title":"utils/maths.magnitude(arr) ⇒ <code> number </code>","local":"utilsmathsmagnitudearr--code-number-code","sections":[],"depth":2},{"title":"utils/maths.min(arr) ⇒ <code> Array. < number > </code>","local":"utilsmathsminarr--code-array--number--code","sections":[],"depth":2},{"title":"utils/maths.max(arr) ⇒ <code> * </code>","local":"utilsmathsmaxarr--code--code","sections":[],"depth":2},{"title":"utils/maths.medianFilter(data, windowSize)","local":"utilsmathsmedianfilterdata-windowsize","sections":[],"depth":2},{"title":"utils/maths.round(num, decimals) ⇒ <code> number </code>","local":"utilsmathsroundnum-decimals--code-number-code","sections":[],"depth":2},{"title":"utils/maths~P2FFT","local":"utilsmathsp2fft","sections":[{"title":"new P2FFT(size)","local":"new-p2fftsize","sections":[],"depth":3},{"title":"p2FFT.createComplexArray() ⇒ <code> Float64Array </code>","local":"p2fftcreatecomplexarray--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.fromComplexArray(complex, [storage]) ⇒ <code> Array. < number > </code>","local":"p2fftfromcomplexarraycomplex-storage--code-array--number--code","sections":[],"depth":3},{"title":"p2FFT.toComplexArray(input, [storage]) ⇒ <code> Float64Array </code>","local":"p2ffttocomplexarrayinput-storage--code-float64array-code","sections":[],"depth":3},{"title":"p2FFT.completeSpectrum(spectrum) ⇒ <code> void </code>","local":"p2fftcompletespectrumspectrum--code-void-code","sections":[],"depth":3},{"title":"p2FFT.transform(out, data) ⇒ <code> void </code>","local":"p2ffttransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT.realTransform(out, data)","local":"p2fftrealtransformout-data","sections":[],"depth":3},{"title":"p2FFT.inverseTransform(out, data) ⇒ <code> void </code>","local":"p2fftinversetransformout-data--code-void-code","sections":[],"depth":3},{"title":"p2FFT._transform4(out, data, inv) ⇒ <code> void </code>","local":"p2ffttransform4out-data-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsingletransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleTransform4(data, out, outOff, off, step, inv) ⇒ <code> void </code>","local":"p2fftsingletransform4data-out-outoff-off-step-inv--code-void-code","sections":[],"depth":3},{"title":"p2FFT._realTransform4(out, data, inv)","local":"p2fftrealtransform4out-data-inv","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform2(data, out, outOff, off, step) ⇒ <code> void </code>","local":"p2fftsinglerealtransform2data-out-outoff-off-step--code-void-code","sections":[],"depth":3},{"title":"p2FFT._singleRealTransform4(data, out, outOff, off, step, inv)","local":"p2fftsinglerealtransform4data-out-outoff-off-step-inv","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~NP2FFT","local":"utilsmathsnp2fft","sections":[{"title":"new NP2FFT(fft_length)","local":"new-np2fftfftlength","sections":[],"depth":3}],"depth":2},{"title":"utils/maths~AnyTypedArray : <code> Int8Array </code> | <code> Uint8Array </code> | <code> Uint8ClampedArray </code> | <code> Int16Array </code> | <code> Uint16Array </code> | <code> Int32Array </code> | <code> Uint32Array </code> | <code> Float32Array </code> | <code> Float64Array </code>","local":"utilsmathsanytypedarray--code-int8array-code--code-uint8array-code--code-uint8clampedarray-code--code-int16array-code--code-uint16array-code--code-int32array-code--code-uint32array-code--code-float32array-code--code-float64array-code","sections":[],"depth":2}],"depth":1}';function ys(xo){return ms(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class xs extends ns{constructor(v){super(),fs(this,v,ys,cs,ss,{})}}export{xs as component};
