import{s as Dt,n as Kt,o as Ot}from"../chunks/scheduler.36a0863c.js";import{S as el,i as tl,g as s,s as a,r as p,A as ll,h as o,f as l,c as i,j as St,u as r,x as m,k as At,y as nl,a as n,v as u,d as g,t as d,w as c}from"../chunks/index.9c13489a.js";import{C as M}from"../chunks/CodeBlock.05d8ec32.js";import{D as al}from"../chunks/DocNotebookDropdown.653c9eec.js";import{H as b}from"../chunks/Heading.7a254a62.js";function il(bt){let f,be,Me,Je,J,Te,T,ye,y,Jt='Ci sono diversi modelli multilingue in 🤗 Transformers, e il loro utilizzo per l’inferenza differisce da quello dei modelli monolingua. Non <em>tutti</em> gli utilizzi dei modelli multilingue sono però diversi. Alcuni modelli, come <a href="https://huggingface.co/bert-base-multilingual-uncased" rel="nofollow">bert-base-multilingual-uncased</a>, possono essere usati come un modello monolingua. Questa guida ti mostrerà come utilizzare modelli multilingue che utilizzano un modo diverso per fare l’inferenza.',he,h,Ue,U,Tt="XLM ha dieci diversi checkpoint, di cui solo uno è monolingua. I nove checkpoint rimanenti possono essere suddivisi in due categorie: i checkpoint che utilizzano i language embeddings e quelli che non li utilizzano.",$e,$,je,j,yt="I seguenti modelli XLM utilizzano gli embeddings linguistici per specificare la lingua utilizzata per l’inferenza:",ke,k,ht="<li><code>xlm-mlm-ende-1024</code> (Modellazione mascherata del linguaggio (Masked language modeling, in inglese), Inglese-Tedesco)</li> <li><code>xlm-mlm-enfr-1024</code> (Modellazione mascherata del linguaggio, Inglese-Francese)</li> <li><code>xlm-mlm-enro-1024</code> (Modellazione mascherata del linguaggio, Inglese-Rumeno)</li> <li><code>xlm-mlm-xnli15-1024</code> (Modellazione mascherata del linguaggio, lingue XNLI)</li> <li><code>xlm-mlm-tlm-xnli15-1024</code> (Modellazione mascherata del linguaggio + traduzione, lingue XNLI)</li> <li><code>xlm-clm-enfr-1024</code> (Modellazione causale del linguaggio, Inglese-Francese)</li> <li><code>xlm-clm-ende-1024</code> (Modellazione causale del linguaggio, Inglese-Tedesco)</li>",ve,v,Ut="Gli embeddings linguistici sono rappresentati come un tensore delle stesse dimensioni dell’ <code>input_ids</code> passato al modello. I valori in questi tensori dipendono dal linguaggio usato e sono identificati dagli attributi <code>lang2id</code> e <code>id2lang</code> del tokenizer.",we,w,$t="In questo esempio, carica il checkpoint <code>xlm-clm-enfr-1024</code> (Modellazione causale del linguaggio, Inglese-Francese):",ze,z,xe,x,jt="L’attributo <code>lang2id</code> del tokenizer mostra il linguaggio del modello e il suo ids:",Ce,C,Ze,Z,kt="Poi, crea un esempio di input:",_e,_,Ie,I,vt="Imposta l’id del linguaggio a <code>&quot;en&quot;</code> e usalo per definire il language embedding. Il language embedding è un tensore riempito con <code>0</code> perché questo è il language id per l’inglese. Questo tensore dovrebbe avere la stessa dimensione di <code>input_ids</code>.",Xe,X,Ge,G,wt="Adesso puoi inserire <code>input_ids</code> e language embedding nel modello:",Re,R,We,W,zt='Lo script <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> può generare testo tramite i language embeddings usando i checkpoints <code>xlm-clm</code>.',Ve,V,Le,L,xt="I seguenti modelli XLM non richiedono l’utilizzo dei language embeddings per fare inferenza:",Be,B,Ct="<li><code>xlm-mlm-17-1280</code> (Modellazione mascherata del linguaggio, 17 lingue)</li> <li><code>xlm-mlm-100-1280</code> (Modellazione mascherata del linguaggio, 100 lingue)</li>",qe,q,Zt="Questi modelli sono utilizzati per rappresentazioni generiche di frasi, a differenza dei precedenti checkpoints XML.",He,H,Ee,E,_t="Il seguente modello BERT può essere usato per compiti multilingue:",Fe,F,It="<li><code>bert-base-multilingual-uncased</code> (Modellazione mascherata del linguaggio + Previsione della prossima frase, 102 lingue)</li> <li><code>bert-base-multilingual-cased</code> (Modellazione mascherata del linguaggio + Previsione della prossima frase, 104 lingue)</li>",Qe,Q,Xt="Questi modelli non richiedono language embeddings per fare inferenza. Riescono ad identificare il linguaggio dal contesto e inferire di conseguenza.",Ye,Y,Ne,N,Gt="Il seguente modello XLM-RoBERTa può essere usato per compiti multilingue:",Pe,P,Rt="<li><code>xlm-roberta-base</code> (Modellazione mascherata del linguaggio, 100 lingue)</li> <li><code>xlm-roberta-large</code> (Modellazione mascherata del linguaggio, 100 lingue)</li>",Se,S,Wt="XLM-RoBERTa è stato addestrato su 2.5TB di dati CommonCrawl appena creati e puliti in 100 lingue. Offre notevoli vantaggi rispetto ai modelli multilingue rilasciati in precedenza, come mBERT o XLM, in compiti come la classificazione, l’etichettatura delle sequenze e la risposta alle domande.",Ae,A,De,D,Vt="Il seguente modello M2M100 può essere usato per compiti multilingue:",Ke,K,Lt="<li><code>facebook/m2m100_418M</code> (Traduzione)</li> <li><code>facebook/m2m100_1.2B</code> (Traduzione)</li>",Oe,O,Bt="In questo esempio, carica il checkpoint <code>facebook/m2m100_418M</code>  per tradurre dal cinese all’inglese. Puoi impostare la lingua di partenza nel tokenizer:",et,ee,tt,te,qt="Applica il tokenizer al testo:",lt,le,nt,ne,Ht="M2M100 forza l’id della lingua obiettivo come primo token generato per tradurre nella lingua obiettivo. Imposta il parametro <code>forced_bos_token_id</code> a <code>en</code> nel metodo <code>generate</code> per tradurre in inglese:",at,ae,it,ie,st,se,Et="Il seguente modello MBart può essere usato per compiti multilingue:",ot,oe,Ft="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> (Traduzione automatica multilingue uno-a-molti, 50 lingue)</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> (Traduzione automatica multilingue molti-a-molti, 50 lingue)</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> (Traduzione automatica multilingue molti-a-uno, 50 lingue)</li> <li><code>facebook/mbart-large-50</code> (Traduzione multilingue, 50 lingue)</li> <li><code>facebook/mbart-large-cc25</code></li>",mt,me,Qt="In questo esempio, carica il checkpoint <code>facebook/mbart-large-50-many-to-many-mmt</code> per tradurre dal finlandese all’inglese. Puoi impostare la lingua di partenza nel tokenizer:",pt,pe,rt,re,Yt="Applica il tokenizer sul testo:",ut,ue,gt,ge,Nt="MBart forza l’id della lingua obiettivo come primo token generato per tradurre nella lingua obiettivo. Imposta il parametro <code>forced_bos_token_id</code> a <code>en</code> nel metodo <code>generate</code> per tradurre in inglese:",dt,de,ct,ce,Pt="Se stai usando il checkpoint <code>facebook/mbart-large-50-many-to-one-mmt</code>, non hai bisogno di forzare l’id della lingua obiettivo come primo token generato altrimenti l’uso è lo stesso.",Mt,fe,ft;return J=new b({props:{title:"Modelli multilingue per l’inferenza",local:"modelli-multilingue-per-linferenza",headingTag:"h1"}}),T=new al({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/tensorflow/multilingual.ipynb"}]}}),h=new b({props:{title:"XLM",local:"xlm",headingTag:"h2"}}),$=new b({props:{title:"XLM con language embeddings",local:"xlm-con-language-embeddings",headingTag:"h3"}}),z=new M({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ4bG0tY2xtLWVuZnItMTAyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFhMTVdpdGhMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeGxtLWNsbS1lbmZyLTEwMjQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),C=new M({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),_=new M({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjBvZiUyMDE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size of 1</span>',wrap:!1}}),X=new M({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwV2UlMjByZXNoYXBlJTIwaXQlMjB0byUyMGJlJTIwb2YlMjBzaXplJTIwKGJhdGNoX3NpemUlMkMlMjBzZXF1ZW5jZV9sZW5ndGgpJTBBbGFuZ3MlMjAlM0QlMjBsYW5ncy52aWV3KDElMkMlMjAtMSklMjAlMjAlMjMlMjBpcyUyMG5vdyUyMG9mJTIwc2hhcGUlMjAlNUIxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTVEJTIwKHdlJTIwaGF2ZSUyMGElMjBiYXRjaCUyMHNpemUlMjBvZiUyMDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We reshape it to be of size (batch_size, sequence_length)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># is now of shape [1, sequence_length] (we have a batch size of 1)</span>`,wrap:!1}}),R=new M({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),V=new b({props:{title:"XLM senza language embeddings",local:"xlm-senza-language-embeddings",headingTag:"h3"}}),H=new b({props:{title:"BERT",local:"bert",headingTag:"h2"}}),Y=new b({props:{title:"XLM-RoBERTa",local:"xlm-roberta",headingTag:"h2"}}),A=new b({props:{title:"M2M100",local:"m2m100",headingTag:"h2"}}),ee=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),le=new M({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),ae=new M({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),ie=new b({props:{title:"MBart",local:"mbart",headingTag:"h2"}}),pe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),ue=new M({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),de=new M({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkKCUyMmVuX1hYJTIyKSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id(<span class="hljs-string">&quot;en_XX&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),{c(){f=s("meta"),be=a(),Me=s("p"),Je=a(),p(J.$$.fragment),Te=a(),p(T.$$.fragment),ye=a(),y=s("p"),y.innerHTML=Jt,he=a(),p(h.$$.fragment),Ue=a(),U=s("p"),U.textContent=Tt,$e=a(),p($.$$.fragment),je=a(),j=s("p"),j.textContent=yt,ke=a(),k=s("ul"),k.innerHTML=ht,ve=a(),v=s("p"),v.innerHTML=Ut,we=a(),w=s("p"),w.innerHTML=$t,ze=a(),p(z.$$.fragment),xe=a(),x=s("p"),x.innerHTML=jt,Ce=a(),p(C.$$.fragment),Ze=a(),Z=s("p"),Z.textContent=kt,_e=a(),p(_.$$.fragment),Ie=a(),I=s("p"),I.innerHTML=vt,Xe=a(),p(X.$$.fragment),Ge=a(),G=s("p"),G.innerHTML=wt,Re=a(),p(R.$$.fragment),We=a(),W=s("p"),W.innerHTML=zt,Ve=a(),p(V.$$.fragment),Le=a(),L=s("p"),L.textContent=xt,Be=a(),B=s("ul"),B.innerHTML=Ct,qe=a(),q=s("p"),q.textContent=Zt,He=a(),p(H.$$.fragment),Ee=a(),E=s("p"),E.textContent=_t,Fe=a(),F=s("ul"),F.innerHTML=It,Qe=a(),Q=s("p"),Q.textContent=Xt,Ye=a(),p(Y.$$.fragment),Ne=a(),N=s("p"),N.textContent=Gt,Pe=a(),P=s("ul"),P.innerHTML=Rt,Se=a(),S=s("p"),S.textContent=Wt,Ae=a(),p(A.$$.fragment),De=a(),D=s("p"),D.textContent=Vt,Ke=a(),K=s("ul"),K.innerHTML=Lt,Oe=a(),O=s("p"),O.innerHTML=Bt,et=a(),p(ee.$$.fragment),tt=a(),te=s("p"),te.textContent=qt,lt=a(),p(le.$$.fragment),nt=a(),ne=s("p"),ne.innerHTML=Ht,at=a(),p(ae.$$.fragment),it=a(),p(ie.$$.fragment),st=a(),se=s("p"),se.textContent=Et,ot=a(),oe=s("ul"),oe.innerHTML=Ft,mt=a(),me=s("p"),me.innerHTML=Qt,pt=a(),p(pe.$$.fragment),rt=a(),re=s("p"),re.textContent=Yt,ut=a(),p(ue.$$.fragment),gt=a(),ge=s("p"),ge.innerHTML=Nt,dt=a(),p(de.$$.fragment),ct=a(),ce=s("p"),ce.innerHTML=Pt,Mt=a(),fe=s("p"),this.h()},l(e){const t=ll("svelte-u9bgzb",document.head);f=o(t,"META",{name:!0,content:!0}),t.forEach(l),be=i(e),Me=o(e,"P",{}),St(Me).forEach(l),Je=i(e),r(J.$$.fragment,e),Te=i(e),r(T.$$.fragment,e),ye=i(e),y=o(e,"P",{"data-svelte-h":!0}),m(y)!=="svelte-1t4n8rr"&&(y.innerHTML=Jt),he=i(e),r(h.$$.fragment,e),Ue=i(e),U=o(e,"P",{"data-svelte-h":!0}),m(U)!=="svelte-b0zdcx"&&(U.textContent=Tt),$e=i(e),r($.$$.fragment,e),je=i(e),j=o(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-6flhpc"&&(j.textContent=yt),ke=i(e),k=o(e,"UL",{"data-svelte-h":!0}),m(k)!=="svelte-10q5i5g"&&(k.innerHTML=ht),ve=i(e),v=o(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1o9s8ae"&&(v.innerHTML=Ut),we=i(e),w=o(e,"P",{"data-svelte-h":!0}),m(w)!=="svelte-dkazcf"&&(w.innerHTML=$t),ze=i(e),r(z.$$.fragment,e),xe=i(e),x=o(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-1lvsgdy"&&(x.innerHTML=jt),Ce=i(e),r(C.$$.fragment,e),Ze=i(e),Z=o(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-1gs48v1"&&(Z.textContent=kt),_e=i(e),r(_.$$.fragment,e),Ie=i(e),I=o(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-1lqmqx6"&&(I.innerHTML=vt),Xe=i(e),r(X.$$.fragment,e),Ge=i(e),G=o(e,"P",{"data-svelte-h":!0}),m(G)!=="svelte-1257czm"&&(G.innerHTML=wt),Re=i(e),r(R.$$.fragment,e),We=i(e),W=o(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-docsh6"&&(W.innerHTML=zt),Ve=i(e),r(V.$$.fragment,e),Le=i(e),L=o(e,"P",{"data-svelte-h":!0}),m(L)!=="svelte-1fsmnuh"&&(L.textContent=xt),Be=i(e),B=o(e,"UL",{"data-svelte-h":!0}),m(B)!=="svelte-1a8brqg"&&(B.innerHTML=Ct),qe=i(e),q=o(e,"P",{"data-svelte-h":!0}),m(q)!=="svelte-18famm0"&&(q.textContent=Zt),He=i(e),r(H.$$.fragment,e),Ee=i(e),E=o(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-16x26sb"&&(E.textContent=_t),Fe=i(e),F=o(e,"UL",{"data-svelte-h":!0}),m(F)!=="svelte-mn71at"&&(F.innerHTML=It),Qe=i(e),Q=o(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-nozyay"&&(Q.textContent=Xt),Ye=i(e),r(Y.$$.fragment,e),Ne=i(e),N=o(e,"P",{"data-svelte-h":!0}),m(N)!=="svelte-6sllth"&&(N.textContent=Gt),Pe=i(e),P=o(e,"UL",{"data-svelte-h":!0}),m(P)!=="svelte-uwbm6k"&&(P.innerHTML=Rt),Se=i(e),S=o(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-1t17k0a"&&(S.textContent=Wt),Ae=i(e),r(A.$$.fragment,e),De=i(e),D=o(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-sftpup"&&(D.textContent=Vt),Ke=i(e),K=o(e,"UL",{"data-svelte-h":!0}),m(K)!=="svelte-13d4mst"&&(K.innerHTML=Lt),Oe=i(e),O=o(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-13sr045"&&(O.innerHTML=Bt),et=i(e),r(ee.$$.fragment,e),tt=i(e),te=o(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1ysq4ea"&&(te.textContent=qt),lt=i(e),r(le.$$.fragment,e),nt=i(e),ne=o(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1hcjl5u"&&(ne.innerHTML=Ht),at=i(e),r(ae.$$.fragment,e),it=i(e),r(ie.$$.fragment,e),st=i(e),se=o(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-hqe28c"&&(se.textContent=Et),ot=i(e),oe=o(e,"UL",{"data-svelte-h":!0}),m(oe)!=="svelte-15l5ps7"&&(oe.innerHTML=Ft),mt=i(e),me=o(e,"P",{"data-svelte-h":!0}),m(me)!=="svelte-niv51s"&&(me.innerHTML=Qt),pt=i(e),r(pe.$$.fragment,e),rt=i(e),re=o(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-5lihjd"&&(re.textContent=Yt),ut=i(e),r(ue.$$.fragment,e),gt=i(e),ge=o(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-21vlhj"&&(ge.innerHTML=Nt),dt=i(e),r(de.$$.fragment,e),ct=i(e),ce=o(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-m0bu83"&&(ce.innerHTML=Pt),Mt=i(e),fe=o(e,"P",{}),St(fe).forEach(l),this.h()},h(){At(f,"name","hf:doc:metadata"),At(f,"content",sl)},m(e,t){nl(document.head,f),n(e,be,t),n(e,Me,t),n(e,Je,t),u(J,e,t),n(e,Te,t),u(T,e,t),n(e,ye,t),n(e,y,t),n(e,he,t),u(h,e,t),n(e,Ue,t),n(e,U,t),n(e,$e,t),u($,e,t),n(e,je,t),n(e,j,t),n(e,ke,t),n(e,k,t),n(e,ve,t),n(e,v,t),n(e,we,t),n(e,w,t),n(e,ze,t),u(z,e,t),n(e,xe,t),n(e,x,t),n(e,Ce,t),u(C,e,t),n(e,Ze,t),n(e,Z,t),n(e,_e,t),u(_,e,t),n(e,Ie,t),n(e,I,t),n(e,Xe,t),u(X,e,t),n(e,Ge,t),n(e,G,t),n(e,Re,t),u(R,e,t),n(e,We,t),n(e,W,t),n(e,Ve,t),u(V,e,t),n(e,Le,t),n(e,L,t),n(e,Be,t),n(e,B,t),n(e,qe,t),n(e,q,t),n(e,He,t),u(H,e,t),n(e,Ee,t),n(e,E,t),n(e,Fe,t),n(e,F,t),n(e,Qe,t),n(e,Q,t),n(e,Ye,t),u(Y,e,t),n(e,Ne,t),n(e,N,t),n(e,Pe,t),n(e,P,t),n(e,Se,t),n(e,S,t),n(e,Ae,t),u(A,e,t),n(e,De,t),n(e,D,t),n(e,Ke,t),n(e,K,t),n(e,Oe,t),n(e,O,t),n(e,et,t),u(ee,e,t),n(e,tt,t),n(e,te,t),n(e,lt,t),u(le,e,t),n(e,nt,t),n(e,ne,t),n(e,at,t),u(ae,e,t),n(e,it,t),u(ie,e,t),n(e,st,t),n(e,se,t),n(e,ot,t),n(e,oe,t),n(e,mt,t),n(e,me,t),n(e,pt,t),u(pe,e,t),n(e,rt,t),n(e,re,t),n(e,ut,t),u(ue,e,t),n(e,gt,t),n(e,ge,t),n(e,dt,t),u(de,e,t),n(e,ct,t),n(e,ce,t),n(e,Mt,t),n(e,fe,t),ft=!0},p:Kt,i(e){ft||(g(J.$$.fragment,e),g(T.$$.fragment,e),g(h.$$.fragment,e),g($.$$.fragment,e),g(z.$$.fragment,e),g(C.$$.fragment,e),g(_.$$.fragment,e),g(X.$$.fragment,e),g(R.$$.fragment,e),g(V.$$.fragment,e),g(H.$$.fragment,e),g(Y.$$.fragment,e),g(A.$$.fragment,e),g(ee.$$.fragment,e),g(le.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(pe.$$.fragment,e),g(ue.$$.fragment,e),g(de.$$.fragment,e),ft=!0)},o(e){d(J.$$.fragment,e),d(T.$$.fragment,e),d(h.$$.fragment,e),d($.$$.fragment,e),d(z.$$.fragment,e),d(C.$$.fragment,e),d(_.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(V.$$.fragment,e),d(H.$$.fragment,e),d(Y.$$.fragment,e),d(A.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(ue.$$.fragment,e),d(de.$$.fragment,e),ft=!1},d(e){e&&(l(be),l(Me),l(Je),l(Te),l(ye),l(y),l(he),l(Ue),l(U),l($e),l(je),l(j),l(ke),l(k),l(ve),l(v),l(we),l(w),l(ze),l(xe),l(x),l(Ce),l(Ze),l(Z),l(_e),l(Ie),l(I),l(Xe),l(Ge),l(G),l(Re),l(We),l(W),l(Ve),l(Le),l(L),l(Be),l(B),l(qe),l(q),l(He),l(Ee),l(E),l(Fe),l(F),l(Qe),l(Q),l(Ye),l(Ne),l(N),l(Pe),l(P),l(Se),l(S),l(Ae),l(De),l(D),l(Ke),l(K),l(Oe),l(O),l(et),l(tt),l(te),l(lt),l(nt),l(ne),l(at),l(it),l(st),l(se),l(ot),l(oe),l(mt),l(me),l(pt),l(rt),l(re),l(ut),l(gt),l(ge),l(dt),l(ct),l(ce),l(Mt),l(fe)),l(f),c(J,e),c(T,e),c(h,e),c($,e),c(z,e),c(C,e),c(_,e),c(X,e),c(R,e),c(V,e),c(H,e),c(Y,e),c(A,e),c(ee,e),c(le,e),c(ae,e),c(ie,e),c(pe,e),c(ue,e),c(de,e)}}}const sl='{"title":"Modelli multilingue per l’inferenza","local":"modelli-multilingue-per-linferenza","sections":[{"title":"XLM","local":"xlm","sections":[{"title":"XLM con language embeddings","local":"xlm-con-language-embeddings","sections":[],"depth":3},{"title":"XLM senza language embeddings","local":"xlm-senza-language-embeddings","sections":[],"depth":3}],"depth":2},{"title":"BERT","local":"bert","sections":[],"depth":2},{"title":"XLM-RoBERTa","local":"xlm-roberta","sections":[],"depth":2},{"title":"M2M100","local":"m2m100","sections":[],"depth":2},{"title":"MBart","local":"mbart","sections":[],"depth":2}],"depth":1}';function ol(bt){return Ot(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class dl extends el{constructor(f){super(),tl(this,f,ol,il,Dt,{})}}export{dl as component};
