import{s as Ev,o as Sv,n as J}from"../chunks/scheduler.9bc65507.js";import{S as qv,i as Hv,g as a,s as o,r as p,A as Pv,h as l,f as t,c as r,j as T,u as m,x as y,k as M,y as s,a as d,v as u,d as g,t as h,w as f}from"../chunks/index.707bf1b6.js";import{T as nn}from"../chunks/Tip.c2ecdbf4.js";import{D as v}from"../chunks/Docstring.17db21ae.js";import{C as x}from"../chunks/CodeBlock.54a9f38d.js";import{E as B}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as Y}from"../chunks/Heading.342b1fa6.js";function Dv($){let c,k=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/en/model_doc/bark" rel="nofollow">Bark</a>’s fine submodel. See the model documentation
for examples.`;return{c(){c=a("p"),c.innerHTML=k},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-nbt45a"&&(c.innerHTML=k)},m(b,_){d(b,c,_)},p:J,d(b){b&&t(c)}}}function Qv($){let c,k=`This logits processor is exclusively compatible with
<a href="https://huggingface.co/docs/transformers/main/en/model_doc/musicgen" rel="nofollow">MusicGen</a>`;return{c(){c=a("p"),c.innerHTML=k},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-1uojnuk"&&(c.innerHTML=k)},m(b,_){d(b,c,_)},p:J,d(b){b&&t(c)}}}function Yv($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function Av($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkFsaWNlJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMFdoYXQlMjBkbyUyMHlvdSUyMGxvdmUlM0YlNUNuQm9iJTNBJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3ZSUyMHNlZSUyMEJvYiUyMHJlcGVhdGluZyUyMEFsaWNlJ3MlMjBvcGluaW9uLiUyMElmJTIwQm9iJTIwd2FzJTIwYSUyMGNoYXRib3QlMkMlMjBpdCUyMHdvdWxkJTIwYmUlMjBhJTIwcG9vciUyMG9uZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhpcyUyMGxvZ2l0cyUyMHByb2Nlc3NvciUyQyUyMHdlJTIwY2FuJTIwcHJldmVudCUyMEJvYiUyMGZyb20lMjByZXBlYXRpbmclMjBBbGljZSdzJTIwb3Bpbmlvbi4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX25vX3JlcGVhdF9uZ3JhbV9zaXplJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice: I love cats. What do you love?\\nBob:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With greedy decoding, we see Bob repeating Alice&#x27;s opinion. If Bob was a chatbot, it would be a poor one.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: I love cats. What do you

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With this logits processor, we can prevent Bob from repeating Alice&#x27;s opinion.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, encoder_no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice: I love cats. What do you love?
Bob: My cats are very cute.`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function Ov($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkFsaWNlJTIwYW5kJTIwQm9iLiUyMFRoZSUyMHRoaXJkJTIwbWVtYmVyJ3MlMjBuYW1lJTIwd2FzJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwdGhlJTIwJTYwZW5jb2Rlcl9yZXBldGl0aW9uX3BlbmFsdHklNjAlMjBhcmd1bWVudCUyMHdlJTIwY2FuJTIwdHJpZ2dlciUyMHRoaXMlMjBsb2dpdHMlMjBwcm9jZXNzb3IlMjBpbiUyMCU2MGdlbmVyYXRlJTYwJTJDJTIwd2hpY2glMjBjYW4lMEElMjMlMjBwcm9tb3RlJTIwdGhlJTIwdXNlJTIwb2YlMjBwcm9tcHQlMjB0b2tlbnMlMjAoJTIyQm9iJTIyJTIwaW4lMjB0aGlzJTIwZXhhbXBsZSklMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBlbmNvZGVyX3JlcGV0aXRpb25fcGVuYWx0eSUzRDEuMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Alice and Bob. The third member&#x27;s name was&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob. The third membe<span class="hljs-string">r&#x27;s name was not mentioned.

&gt;&gt;&gt; # With the \`encoder_repetition_penalty\` argument we can trigger this logits processor in \`generate\`, which can
&gt;&gt;&gt; # promote the use of prompt tokens (&quot;Bob&quot; in this example)
&gt;&gt;&gt; gen_out = model.generate(**inputs, encoder_repetition_penalty=1.2)
&gt;&gt;&gt; print(tokenizer.batch_decode(gen_out, skip_special_tokens=True)[0])
Alice and Bob. The third member&#x27;</span>s name was Bob. The third membe<span class="hljs-string">r&#x27;s name was Bob.</span>`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function Kv($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjBlcHNpbG9uJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRvJTIwaGlnaC1wcm9iYWJpbGl0eSUyMHRva2Vucy4lMjBOb3RlJTIwdGhhdCUyMHRoaXMlMjBpcyUyMHNpbWlsYXIlMjB0byUwQSUyMyUyMFRvcCUyMFAlMjBzYW1wbGluZyUyQyUyMHdoaWNoJTIwcmVzdHJpY3RzJTIwdG9rZW5zJTIwYmFzZWQlMjBvbiUyMHRoZWlyJTIwY3VtdWxhdGl2ZSUyMHByb2JhYmlsaXR5LiUwQSUyMyUyMFBybyUyMHRpcCUzQSUyMFRoZSUyMHBhcGVyJTIwcmVjb21lbmRzJTIwdXNpbmclMjAlNjBlcHNpbG9uX2N1dG9mZiU2MCUyMHZhbHVlcyUyMGJldHdlZW4lMjAzZS00JTIwYW5kJTIwOWUtNCUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBlcHNpbG9uX2N1dG9mZiUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With epsilon sampling, the output gets restricted to high-probability tokens. Note that this is similar to</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Top P sampling, which restricts tokens based on their cumulative probability.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`epsilon_cutoff\` values between 3e-4 and 9e-4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, epsilon_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function ew($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjBldGElMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGdldHMlMjByZXN0cmljdGVkJTIwdG8lMjBoaWdoLXByb2JhYmlsaXR5JTIwdG9rZW5zLiUyMFlvdSUyMGNhbiUyMHNlZSUyMGl0JTIwYXMlMjBhJTIwZHluYW1pYyUyMGZvcm0lMjBvZiUwQSUyMyUyMGVwc2lsb24lMjBzYW1wbGluZyUyMHRoYXQlMjBhZGFwdHMlMjBpdHMlMjBjdXRvZmYlMjBwcm9iYWJpbGl0eSUyMGJhc2VkJTIwb24lMjB0aGUlMjBlbnRyb3B5JTIwKGhpZ2glMjBlbnRyb3B5JTIwJTNEJTIwbG93ZXIlMjBjdXRvZmYpLiUwQSUyMyUyMFBybyUyMHRpcCUzQSUyMFRoZSUyMHBhcGVyJTIwcmVjb21lbmRzJTIwdXNpbmclMjAlNjBldGFfY3V0b2ZmJTYwJTIwdmFsdWVzJTIwYmV0d2VlbiUyMDNlLTQlMjB0byUyMDRlLTMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZXRhX2N1dG9mZiUzRDAuMSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With eta sampling, the output gets restricted to high-probability tokens. You can see it as a dynamic form of</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># epsilon sampling that adapts its cutoff probability based on the entropy (high entropy = lower cutoff).</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: The paper recomends using \`eta_cutoff\` values between 3e-4 to 4e-3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, eta_cutoff=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function tw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Just wanted to let you know, I&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Let&#x27;s consider that we want short sentences, so we limit \`max_length=30\`. However, we observe that the answer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># tends to end abruptly.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, temperature=<span class="hljs-number">0.9</span>, max_length=<span class="hljs-number">30</span>, pad_token_id=<span class="hljs-number">50256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span> Although

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># To promote the appearance of the EOS token at the right time, we add the \`exponential_decay_length_penalty =</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (start_index, decay_factor)\`. Instead of cutting at max_tokens, the output comes to an end before and usually</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with more meaning. What happens is that starting from \`start_index\` the EOS token score will be increased</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># by \`decay_factor\` exponentially. However, if you set a high decay factor, you may also end up with abruptly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># ending sequences.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.6</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network
which&lt;|endoftext|&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With a small decay factor, you will have a higher chance of getting a meaningful sequence.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    do_sample=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    temperature=<span class="hljs-number">0.9</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">30</span>,
<span class="hljs-meta">... </span>    pad_token_id=<span class="hljs-number">50256</span>,
<span class="hljs-meta">... </span>    exponential_decay_length_penalty=(<span class="hljs-number">15</span>, <span class="hljs-number">1.01</span>),
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
Just wanted to let you know, I received a link to an ebook, the book How To Start A Social Network which was
published <span class="hljs-keyword">in</span> <span class="hljs-number">2010.</span>&lt;|endoftext|&gt;`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function sw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGZmxhbi10NS1zbWFsbCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUlMkZmbGFuLXQ1LXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJUcmFuc2xhdGUlMjBmcm9tJTIwRW5nbGlzaCUyMHRvJTIwR2VybWFuJTNBJTIwSSUyMGxvdmUlMjBjYXRzLiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwQnklMjBkZWZhdWx0JTJDJTIwaXQlMjBjb250aW51ZXMlMjBnZW5lcmF0aW5nJTIwYWNjb3JkaW5nJTIwdG8lMjB0aGUlMjBtb2RlbCdzJTIwbG9naXRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCklMEElMEElMjMlMjBXZSUyMGNhbiUyMHVzZSUyMCU2MGZvcmNlZF9ib3NfdG9rZW5faWQlNjAlMjB0byUyMGZvcmNlJTIwdGhlJTIwc3RhcnQlMjBvZiUyMGdlbmVyYXRpb24lMjB3aXRoJTIwYW4lMjBlbmNvZGVyLWRlY29kZXIlMjBtb2RlbCUwQSUyMyUyMChpbmNsdWRpbmclMjBmb3JjaW5nJTIwaXQlMjB0byUyMGVuZCUyMHN0cmFpZ2h0JTIwYXdheSUyMHdpdGglMjBhbiUyMEVPUyUyMHRva2VuKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBmb3JjZWRfYm9zX3Rva2VuX2lkJTNEdG9rZW5pemVyLmVvc190b2tlbl9pZCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google/flan-t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Translate from English to German: I love cats.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt; Ich liebe Kitty.&lt;/s&gt;

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can use \`forced_bos_token_id\` to force the start of generation with an encoder-decoder model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># (including forcing it to end straight away with an EOS token)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_bos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
&lt;pad&gt;&lt;/s&gt;`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function nw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyQSUyMHNlcXVlbmNlJTNBJTIwMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBCeSUyMGRlZmF1bHQlMkMlMjBpdCUyMGNvbnRpbnVlcyUyMGdlbmVyYXRpbmclMjBhY2NvcmRpbmclMjB0byUyMHRoZSUyMG1vZGVsJ3MlMjBsb2dpdHMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyklNUIwJTVEKSUwQSUwQSUyMyUyMCU2MGZvcmNlZF9lb3NfdG9rZW5faWQlNjAlMjBlbnN1cmVzJTIwdGhlJTIwZ2VuZXJhdGlvbiUyMGVuZHMlMjB3aXRoJTIwYSUyMEVPUyUyMHRva2VuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUyMGZvcmNlZF9lb3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZW9zX3Rva2VuX2lkKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`forced_eos_token_id\` ensures the generation ends with a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>, forced_eos_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>,&lt;|endoftext|&gt;`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function ow($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This Whisper model forces the generation to start with \`50362\` at the first position by default, i.e.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`&quot;forced_decoder_ids&quot;: [[1, 50362]]\`. This means all other tokens are masked out.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">all</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, i] == <span class="hljs-built_in">float</span>(<span class="hljs-string">&quot;-inf&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(processor.tokenizer.vocab_size) <span class="hljs-keyword">if</span> i != <span class="hljs-number">50362</span>)
<span class="hljs-meta">... </span>)
<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50362</span>])
tensor(<span class="hljs-number">0.</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`forced_decoder_ids\`, we stop seeing that effect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, forced_decoder_ids=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-built_in">all</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, i] == <span class="hljs-built_in">float</span>(<span class="hljs-string">&quot;-inf&quot;</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(processor.tokenizer.vocab_size) <span class="hljs-keyword">if</span> i != <span class="hljs-number">50362</span>)
<span class="hljs-meta">... </span>)
<span class="hljs-literal">False</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50362</span>])
tensor(<span class="hljs-number">19.3140</span>)`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function rw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMEluaXRpYWxpemUlMjB0aGUlMjBtb2RlbCUyMGFuZCUyMHRva2VuaXplciUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMnQ1LWJhc2UlMjIpJTBBJTBBJTIzJTIwQSUyMGxvbmclMjB0ZXh0JTIwYWJvdXQlMjB0aGUlMjBzb2xhciUyMHN5c3RlbSUwQXRleHQlMjAlM0QlMjAoJTBBJTIwJTIwJTIwJTIwJTIyVGhlJTIwU29sYXIlMjBTeXN0ZW0lMjBpcyUyMGElMjBncmF2aXRhdGlvbmFsbHklMjBib3VuZCUyMHN5c3RlbSUyMGNvbXByaXNpbmclMjB0aGUlMjBTdW4lMjBhbmQlMjB0aGUlMjBvYmplY3RzJTIwdGhhdCUyMG9yYml0JTIwaXQlMkMlMjAlMjIlMEElMjAlMjAlMjAlMjAlMjJlaXRoZXIlMjBkaXJlY3RseSUyMG9yJTIwaW5kaXJlY3RseS4lMjBPZiUyMHRoZSUyMG9iamVjdHMlMjB0aGF0JTIwb3JiaXQlMjB0aGUlMjBTdW4lMjBkaXJlY3RseSUyQyUyMHRoZSUyMGxhcmdlc3QlMjBhcmUlMjB0aGUlMjBlaWdodCUyMCUyMiUwQSUyMCUyMCUyMCUyMCUyMnBsYW5ldHMlMkMlMjB3aXRoJTIwdGhlJTIwcmVtYWluZGVyJTIwYmVpbmclMjBzbWFsbGVyJTIwb2JqZWN0cyUyQyUyMHN1Y2glMjBhcyUyMHRoZSUyMGZpdmUlMjBkd2FyZiUyMHBsYW5ldHMlMjBhbmQlMjBzbWFsbCUyMFNvbGFyJTIwU3lzdGVtJTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIyYm9kaWVzLiUyMFRoZSUyMFNvbGFyJTIwU3lzdGVtJTIwZm9ybWVkJTIwNC42JTIwYmlsbGlvbiUyMHllYXJzJTIwYWdvJTIwZnJvbSUyMHRoZSUyMGdyYXZpdGF0aW9uYWwlMjBjb2xsYXBzZSUyMG9mJTIwYSUyMGdpYW50JTIwJTIyJTBBJTIwJTIwJTIwJTIwJTIyaW50ZXJzdGVsbGFyJTIwbW9sZWN1bGFyJTIwY2xvdWQuJTIyJTBBKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJzdW1tYXJpemUlM0ElMjAlMjIlMjAlMkIlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUyMGRpdmVyc2UlMjBzdW1tYXJ5JTBBb3V0cHV0c19kaXZlcnNlJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjBudW1fYmVhbV9ncm91cHMlM0QyJTJDJTBBJTIwJTIwJTIwJTIwZGl2ZXJzaXR5X3BlbmFsdHklM0QxMC4wJTJDJTBBJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMG51bV9iZWFtcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDIlMkMlMEEpJTBBc3VtbWFyaWVzX2RpdmVyc2UlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHNfZGl2ZXJzZSUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTIwbm9uLWRpdmVyc2UlMjBzdW1tYXJ5JTBBb3V0cHV0c19ub25fZGl2ZXJzZSUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCUyMCUyMCoqaW5wdXRzJTJDJTBBJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRDEwMCUyQyUwQSUyMCUyMCUyMCUyMG51bV9iZWFtcyUzRDQlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDIlMkMlMEEpJTBBc3VtbWFyeV9ub25fZGl2ZXJzZSUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0c19ub25fZGl2ZXJzZSUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQSUwQSUyMyUyMFdpdGglMjAlNjBkaXZlcnNpdHlfcGVuYWx0eSU2MCUyQyUyMHRoZSUyMHJlc3VsdGluZyUyMGJlYW1zJTIwYXJlJTIwbXVjaCUyMG1vcmUlMjBkaXZlcnNlJTBBcHJpbnQoc3VtbWFyeV9ub25fZGl2ZXJzZSklMEElMEFwcmludChzdW1tYXJpZXNfZGl2ZXJzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the model and tokenizer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># A long text about the solar system</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;The Solar System is a gravitationally bound system comprising the Sun and the objects that orbit it, &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;either directly or indirectly. Of the objects that orbit the Sun directly, the largest are the eight &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;planets, with the remainder being smaller objects, such as the five dwarf planets and small Solar System &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;bodies. The Solar System formed 4.6 billion years ago from the gravitational collapse of a giant &quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;interstellar molecular cloud.&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;summarize: &quot;</span> + text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    diversity_penalty=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summaries_diverse = tokenizer.batch_decode(outputs_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate non-diverse summary</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs_non_diverse = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_length=<span class="hljs-number">100</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_non_diverse = tokenizer.batch_decode(outputs_non_diverse, skip_special_tokens=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`diversity_penalty\`, the resulting beams are much more diverse</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summary_non_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the Solar System formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(summaries_diverse)
[<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets.&#x27;</span>,
<span class="hljs-string">&#x27;the solar system formed 4.6 billion years ago from the collapse of a giant interstellar molecular cloud. of the objects that orbit the Sun directly, the largest are the eight planets. the rest of the objects are smaller objects, such as the five dwarf planets and small solar system bodies.&#x27;</span>]`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function aw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJBJTIwc2VxdWVuY2UlM0ElMjAxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMHRoZSUyMHNjb3JlcyUyMGFyZSUyMG5vdCUyMG5vcm1hbGl6ZWQlMjAtLSUyMHRoZSUyMHN1bSUyMG9mJTIwdGhlaXIlMjBleHBvbmVudGlhbHMlMjBpcyUyME5PVCUyMGElMjBub3JtYWxpemVkJTIwcHJvYmFiaWxpdHklMEElMjMlMjBkaXN0cmlidXRpb24lMkMlMjBzdW1taW5nJTIwdG8lMjAxJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQodG9yY2guc3VtKHRvcmNoLmV4cChvdXRwdXRzLnNjb3JlcyU1Qi0xJTVEKSkpJTBBJTBBJTIzJTIwTm9ybWFsaXppbmclMjB0aGVtJTIwbWF5JTIwaGF2ZSUyMGElMjBwb3NpdGl2ZSUyMGltcGFjdCUyMG9uJTIwYmVhbSUyMG1ldGhvZHMlMkMlMjBvciUyMHdoZW4lMjB1c2luZyUyMHRoZSUyMHNjb3JlcyUyMG9uJTIweW91ciUyMGFwcGxpY2F0aW9uJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmVub3JtYWxpemVfbG9naXRzJTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlKSUwQXByaW50KHRvcmNoLnN1bSh0b3JjaC5leHAob3V0cHV0cy5zY29yZXMlNUItMSU1RCkpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the scores are not normalized -- the sum of their exponentials is NOT a normalized probability</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># distribution, summing to 1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])))
tensor(<span class="hljs-number">816.3250</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Normalizing them may have a positive impact on beam methods, or when using the scores on your application</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, renormalize_logits=<span class="hljs-literal">True</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(torch.<span class="hljs-built_in">sum</span>(torch.exp(outputs.scores[-<span class="hljs-number">1</span>])))
tensor(<span class="hljs-number">1.0000</span>)`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function lw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBudW1iZXIlM0ElMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbGVuZ3RoJTYwJTIwdG8lMjBhJTIwdmFsdWUlMjBzbWFsbGVyJTIwdGhhbiUyMHRoZSUyMHVuY29udHJvbGxlZCUyMG91dHB1dCUyMGxlbmd0aCUyMGhhcyUyMG5vJTIwaW1wYWN0JTBBZ2VuX291dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWluX2xlbmd0aCUzRDMpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBzZXR0aW5nJTIwYSUyMGxhcmdlciUyMCU2MG1pbl9sZW5ndGglNjAlMjB3aWxsJTIwZm9yY2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwZ2VuZXJhdGUlMjBiZXlvbmQlMjBpdHMlMjBuYXR1cmFsJTIwZW5kaW5nJTIwcG9pbnQlMkMlMjB3aGljaCUyMGlzJTIwbm90JTBBJTIzJTIwbmVjZXNzYXJpbHklMjBpbmNvcnJlY3QlMEFnZW5fb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtaW5fbGVuZ3RoJTNEMTApJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fb3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A number:&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_length\` to a value smaller than the uncontrolled output length has no impact</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">3</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting a larger \`min_length\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_length=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand, nine hundred <span class="hljs-keyword">and</span> ninety-four`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function iw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGYmxvb216LTU2MG0lMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBudW1iZXIlM0ElMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMHNldHRpbmclMjAlNjBtaW5fbmV3X3Rva2VucyU2MCUyMHdpbGwlMjBmb3JjZSUyMHRoZSUyMG1vZGVsJTIwdG8lMjBnZW5lcmF0ZSUyMGJleW9uZCUyMGl0cyUyMG5hdHVyYWwlMjBlbmRpbmclMjBwb2ludCUyQyUyMHdoaWNoJTIwaXMlMjBub3QlMEElMjMlMjBuZWNlc3NhcmlseSUyMGluY29ycmVjdCUwQWdlbl9vdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1pbl9uZXdfdG9rZW5zJTNEMiklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbl9vdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;A number:&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># setting \`min_new_tokens\` will force the model to generate beyond its natural ending point, which is not</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># necessarily incorrect</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen_out = model.generate(**inputs, min_new_tokens=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(gen_out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A number: one thousand`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function cw($){let c,k=`In order to get the token ids of the words that should not appear in the generated text, make sure to set
<code>add_prefix_space=True</code> when initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code> argument is only supported for some slow tokenizers,
as fast tokenizers’ prefixing behaviours come from <code>pre tokenizers</code>. Read more
<a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){c=a("p"),c.innerHTML=k},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-15bvr1j"&&(c.innerHTML=k)},m(b,_){d(b,c,_)},p:J,d(b){b&&t(c)}}}function dw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIySW4lMjBhJTIwd29yZCUyQyUyMHRoZSUyMGNha2UlMjBpcyUyMGElMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUlMkMlMjBwYWRfdG9rZW5faWQlM0R0b2tlbml6ZXIuZW9zX3Rva2VuX2lkKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0X2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwTm93JTIwbGV0J3MlMjB0YWtlJTIwdGhlJTIwYmFkJTIwd29yZHMlMjBvdXQuJTIwUGxlYXNlJTIwbm90ZSUyMHRoYXQlMjB0aGUlMjB0b2tlbml6ZXIlMjBpcyUyMGluaXRpYWxpemVkJTIwZGlmZmVyZW50bHklMEF0b2tlbml6ZXJfd2l0aF9wcmVmaXhfc3BhY2UlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyJTJDJTIwYWRkX3ByZWZpeF9zcGFjZSUzRFRydWUpJTBBJTBBJTBBZGVmJTIwZ2V0X3Rva2Vuc19hc19saXN0KHdvcmRfbGlzdCklM0ElMEElMjAlMjAlMjAlMjAlMjJDb252ZXJ0cyUyMGElMjBzZXF1ZW5jZSUyMG9mJTIwd29yZHMlMjBpbnRvJTIwYSUyMGxpc3QlMjBvZiUyMHRva2VucyUyMiUwQSUyMCUyMCUyMCUyMHRva2Vuc19saXN0JTIwJTNEJTIwJTVCJTVEJTBBJTIwJTIwJTIwJTIwZm9yJTIwd29yZCUyMGluJTIwd29yZF9saXN0JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5pemVkX3dvcmQlMjAlM0QlMjB0b2tlbml6ZXJfd2l0aF9wcmVmaXhfc3BhY2UoJTVCd29yZCU1RCUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlKS5pbnB1dF9pZHMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9rZW5zX2xpc3QuYXBwZW5kKHRva2VuaXplZF93b3JkKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRva2Vuc19saXN0JTBBJTBBJTBBYmFkX3dvcmRzX2lkcyUyMCUzRCUyMGdldF90b2tlbnNfYXNfbGlzdCh3b3JkX2xpc3QlM0QlNUIlMjJtZXNzJTIyJTVEKSUwQW91dHB1dF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSglMEElMjAlMjAlMjAlMjBpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDUlMkMlMjBiYWRfd29yZHNfaWRzJTNEYmFkX3dvcmRzX2lkcyUyQyUyMHBhZF90b2tlbl9pZCUzRHRva2VuaXplci5lb3NfdG9rZW5faWQlMEEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;In a word, the cake is a&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, pad_token_id=tokenizer.eos_token_id)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a mess.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s take the bad words out. Please note that the tokenizer is initialized differently</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_list</span>(<span class="hljs-params">word_list</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Converts a sequence of words into a list of tokens&quot;</span>
<span class="hljs-meta">... </span>    tokens_list = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> word <span class="hljs-keyword">in</span> word_list:
<span class="hljs-meta">... </span>        tokenized_word = tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>        tokens_list.append(tokenized_word)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokens_list


<span class="hljs-meta">&gt;&gt;&gt; </span>bad_words_ids = get_tokens_as_list(word_list=[<span class="hljs-string">&quot;mess&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>output_ids = model.generate(
<span class="hljs-meta">... </span>    inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">5</span>, bad_words_ids=bad_words_ids, pad_token_id=tokenizer.eos_token_id
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(output_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
In a word, the cake <span class="hljs-keyword">is</span> a bit of a surprise.`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function pw($){let c,k=`Use n-gram penalties with care. For instance, penalizing 2-grams (bigrams) in an article about the city of New York
might lead to undesirable outcomes where the city’s name appears only once in the entire text.
<a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">Reference</a>`;return{c(){c=a("p"),c.innerHTML=k},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-5zfsi9"&&(c.innerHTML=k)},m(b,_){d(b,c,_)},p:J,d(b){b&&t(c)}}}function mw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVG9kYXklMjBJJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKG91dHB1dCU1QjAlNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkpJTBBJTBBJTIzJTIwTm93JTIwbGV0J3MlMjBhZGQlMjBuZ3JhbSUyMHNpemUlMjB1c2luZyUyMCU2MG5vX3JlcGVhdF9uZ3JhbV9zaXplJTYwLiUyMFRoaXMlMjBzdG9wcyUyMHRoZSUyMHJlcGV0aXRpb25zJTIwKCUyMkklRTIlODAlOTltJTIyKSUyMGluJTIwdGhlJTIwb3V0cHV0LiUwQW91dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbm9fcmVwZWF0X25ncmFtX3NpemUlM0QyKSUwQXByaW50KHRva2VuaXplci5kZWNvZGUob3V0cHV0JTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today I&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I’m going to be able to do it.

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s add ngram size using \`no_repeat_ngram_size\`. This stops the repetitions (&quot;I’m&quot;) in the output.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, no_repeat_ngram_size=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
Today I’m <span class="hljs-keyword">not</span> sure <span class="hljs-keyword">if</span> I can get a better understanding of the nature of this issue`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function uw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Alice and Bob&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, it continues generating according to the model&#x27;s logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob are friends

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can contrain it with \`prefix_allowed_tokens_fn\` to force a certain behavior based on a prefix.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For instance, we can force an entire entity to be generated when its beginning is detected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>entity =  tokenizer(<span class="hljs-string">&quot; Bob Marley&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids[<span class="hljs-number">0</span>]  <span class="hljs-comment"># 3 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">prefix_allowed_tokens_fn</span>(<span class="hljs-params">batch_id, input_ids</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Attempts to generate &#x27;Bob Marley&#x27; when &#x27;Bob&#x27; is detected.
<span class="hljs-meta">... </span>    In this case, \`batch_id\` is not used, but you can set rules for each batch member.
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">0</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> entity[<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">elif</span> input_ids[-<span class="hljs-number">2</span>] == entity[<span class="hljs-number">0</span>] <span class="hljs-keyword">and</span> input_ids[-<span class="hljs-number">1</span>] == entity[<span class="hljs-number">1</span>]:
<span class="hljs-meta">... </span>        <span class="hljs-keyword">return</span> entity[<span class="hljs-number">2</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">list</span>(<span class="hljs-built_in">range</span>(tokenizer.vocab_size))  <span class="hljs-comment"># If no match, allow all tokens</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, prefix_allowed_tokens_fn=prefix_allowed_tokens_fn)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
Alice <span class="hljs-keyword">and</span> Bob Marley`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function gw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyJTIwZm9yJTIwaXQlMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkknbSUyMG5vdCUyMGdvaW5nJTIwdG8lMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFRoaXMlMjBzaG93cyUyMGElMjBub3JtYWwlMjBnZW5lcmF0ZSUyMHdpdGhvdXQlMjBhbnklMjBzcGVjaWZpYyUyMHBhcmFtZXRlcnMlMEFzdW1tYXJ5X2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoc3VtbWFyeV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFRoaXMlMjBnZW5lcmF0ZXMlMjBhJTIwcGVuYWx0eSUyMGZvciUyMHJlcGVhdGVkJTIwdG9rZW5zJTBBcGVuYWxpemVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmVwZXRpdGlvbl9wZW5hbHR5JTNEMS4xKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUocGVuYWxpemVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing the model and tokenizer for it</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;I&#x27;m not going to&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This shows a normal generate without any specific parameters</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>m going to be able to do that

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This generates a penalty for repeated tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>penalized_ids = model.generate(**inputs, repetition_penalty=<span class="hljs-number">1.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(penalized_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
I<span class="hljs-string">&#x27;m not going to be able to do that. I&#x27;</span>ll just have to go out <span class="hljs-keyword">and</span> play`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function hw($){let c,k=`In order to get the token ids of the sequences that you want to bias, make sure to set <code>add_prefix_space=True</code> when
initializing the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The
<code>add_prefix_space</code> argument is only supported for some slow tokenizers, as fast tokenizers’ prefixing behaviours
come from <code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`;return{c(){c=a("p"),c.innerHTML=k},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-16cusgy"&&(c.innerHTML=k)},m(b,_){d(b,c,_)},p:J,d(b){b&&t(c)}}}function fw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;The full name of Donald is Donald&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>summary_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(summary_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Trump Jr

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Now let&#x27;s control generation through a bias. Please note that the tokenizer is initialized differently!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer_with_prefix_space = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, add_prefix_space=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">get_tokens_as_tuple</span>(<span class="hljs-params">word</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> <span class="hljs-built_in">tuple</span>(tokenizer_with_prefix_space([word], add_special_tokens=<span class="hljs-literal">False</span>).input_ids[<span class="hljs-number">0</span>])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we add a negative bias without beam search, it may become &quot;stuck&quot; in a prefix without good continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Trump&quot;</span>): -<span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald J. Donald,

<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Rumsfeld,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can also add a positive bias to nudge the model towards specific tokens or continuations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_bias = {get_tokens_as_tuple(<span class="hljs-string">&quot;Donald Duck&quot;</span>): <span class="hljs-number">10.0</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>biased_ids = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], max_new_tokens=<span class="hljs-number">4</span>, num_beams=<span class="hljs-number">4</span>, sequence_bias=sequence_bias)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(biased_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
The full name of Donald <span class="hljs-keyword">is</span> Donald Duck.`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function _w($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMCU2MGJlZ2luX3N1cHByZXNzX3Rva2VucyU2MCUyMHNldCUyMGJ5JTIwZGVmYXVsdCUyMCglM0QlMjAlNjAlNUIyMjAlMkMlMjA1MDI1NiU1RCU2MCkuJTIwNTAyNTYlMjBpcyUyMHRoZSUyMEVPUyUyMHRva2VuJTJDJTIwc28lMjB0aGlzJTIwbWVhbnMlMEElMjMlMjBpdCUyMGNhbid0JTIwZ2VuZXJhdGUlMjBhbmQlMjBFT1MlMjB0b2tlbiUyMGluJTIwdGhlJTIwZmlyc3QlMjBpdGVyYXRpb24lMkMlMjBidXQlMjBpdCUyMGNhbiUyMGluJTIwdGhlJTIwb3RoZXJzLiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlKSUwQXByaW50KG91dHB1dHMuc2NvcmVzJTVCMSU1RCU1QjAlMkMlMjA1MDI1NiU1RCklMjAlMjAlMjMlMjAxJTIwKGFuZCUyMG5vdCUyMDApJTIwaXMlMjB0aGUlMjBmaXJzdCUyMGZyZWVseSUyMGdlbmVyYXRlZCUyMHRva2VuJTBBcHJpbnQob3V0cHV0cy5zY29yZXMlNUItMSU1RCU1QjAlMkMlMjA1MDI1NiU1RCklMjAlMjAlMjMlMjBpbiUyMG90aGVyJTIwcGxhY2VzJTIwd2UlMjBjYW4lMjBzZWUlMjBzb21lJTIwcHJvYmFiaWxpdHklMjBtYXNzJTIwZm9yJTIwRU9TJTBBJTBBJTIzJTIwSWYlMjB3ZSUyMGRpc2FibGUlMjAlNjBiZWdpbl9zdXBwcmVzc190b2tlbnMlNjAlMkMlMjB3ZSUyMGNhbiUyMGdlbmVyYXRlJTIwRU9TJTIwaW4lMjB0aGUlMjBmaXJzdCUyMGl0ZXJhdGlvbi4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUlMkMlMjBvdXRwdXRfc2NvcmVzJTNEVHJ1ZSUyQyUyMGJlZ2luX3N1cHByZXNzX3Rva2VucyUzRE5vbmUlMEEpJTBBcHJpbnQob3V0cHV0cy5zY29yZXMlNUIxJTVEJTVCMCUyQyUyMDUwMjU2JTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has \`begin_suppress_tokens\` set by default (= \`[220, 50256]\`). 50256 is the EOS token, so this means</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># it can&#x27;t generate and EOS token in the first iteration, but it can in the others.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[-<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])  <span class="hljs-comment"># in other places we can see some probability mass for EOS</span>
tensor(<span class="hljs-number">29.9010</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`begin_suppress_tokens\`, we can generate EOS in the first iteration.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, begin_suppress_tokens=<span class="hljs-literal">None</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">50256</span>])
tensor(<span class="hljs-number">11.2027</span>)`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function bw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBXaGlzcGVyRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2hpc3BlciUyMGhhcyUyMGElMjBsb25nJTIwbGlzdCUyMG9mJTIwc3VwcHJlc3NlZCUyMHRva2Vucy4lMjBGb3IlMjBpbnN0YW5jZSUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMkMlMjB0aGUlMjB0b2tlbiUyMDElMjBpcyUyMHN1cHByZXNzZWQlMjBieSUyMGRlZmF1bHQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUpJTBBcHJpbnQob3V0cHV0cy5zY29yZXMlNUIxJTVEJTVCMCUyQyUyMDElNUQpJTIwJTIwJTIzJTIwMSUyMChhbmQlMjBub3QlMjAwKSUyMGlzJTIwdGhlJTIwZmlyc3QlMjBmcmVlbHklMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUwQSUyMyUyMElmJTIwd2UlMjBkaXNhYmxlJTIwJTYwc3VwcHJlc3NfdG9rZW5zJTYwJTJDJTIwd2UlMjBjYW4lMjBnZW5lcmF0ZSUyMGl0LiUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUyQyUyMG91dHB1dF9zY29yZXMlM0RUcnVlJTJDJTIwc3VwcHJlc3NfdG9rZW5zJTNETm9uZSklMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwMSU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Whisper has a long list of suppressed tokens. For instance, in this case, the token 1 is suppressed by default.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])  <span class="hljs-comment"># 1 (and not 0) is the first freely generated token</span>
tensor(-inf)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If we disable \`suppress_tokens\`, we can generate it.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>, suppress_tokens=<span class="hljs-literal">None</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">1</span>])
tensor(<span class="hljs-number">5.7738</span>)`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function yw($){let c,k=`Make sure that <code>do_sample=True</code> is included in the <code>generate</code> arguments otherwise the temperature value won’t have
any effect.`;return{c(){c=a("p"),c.innerHTML=k},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-1byeoum"&&(c.innerHTML=k)},m(b,_){d(b,c,_)},p:J,d(b){b&&t(c)}}}function Tw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwc2V0X3NlZWQlMEElMEFzZXRfc2VlZCgwKSUyMCUyMCUyMyUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFtb2RlbC5jb25maWcucGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuY29uZmlnLmVvc190b2tlbl9pZCUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUIlMjJIdWdnaW5nJTIwRmFjZSUyMENvbXBhbnklMjBpcyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwV2l0aCUyMHRlbXBlcmF0dXJlJTNEMS4wJTJDJTIwdGhlJTIwZGVmYXVsdCUyQyUyMHdlJTIwY29uc2lzdGVudGx5JTIwZ2V0JTIwcmFuZG9tJTIwb3V0cHV0cyUyMGR1ZSUyMHRvJTIwcmFuZG9tJTIwc2FtcGxpbmcuJTBBZ2VuZXJhdGVfa3dhcmdzJTIwJTNEJTIwJTdCJTIybWF4X25ld190b2tlbnMlMjIlM0ElMjAxMCUyQyUyMCUyMmRvX3NhbXBsZSUyMiUzQSUyMFRydWUlMkMlMjAlMjJ0ZW1wZXJhdHVyZSUyMiUzQSUyMDEuMCUyQyUyMCUyMm51bV9yZXR1cm5fc2VxdWVuY2VzJTIyJTNBJTIwMiU3RCUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMCoqZ2VuZXJhdGVfa3dhcmdzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSklMEElMEElMjMlMjBIb3dldmVyJTJDJTIwd2l0aCUyMHRlbXBlcmF0dXJlJTIwY2xvc2UlMjB0byUyMDAlMkMlMjBpdCUyMGFwcHJveGltYXRlcyUyMGdyZWVkeSUyMGRlY29kaW5nJTIwc3RyYXRlZ2llcyUyMChpbnZhcmlhbnQpJTBBZ2VuZXJhdGVfa3dhcmdzJTVCJTIydGVtcGVyYXR1cmUlMjIlNUQlMjAlM0QlMjAwLjAwMDElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjAqKmdlbmVyYXRlX2t3YXJncyklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)  <span class="hljs-comment"># for reproducibility</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Hugging Face Company is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With temperature=1.0, the default, we consistently get random outputs due to random sampling.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs = {<span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&quot;do_sample&quot;</span>: <span class="hljs-literal">True</span>, <span class="hljs-string">&quot;temperature&quot;</span>: <span class="hljs-number">1.0</span>, <span class="hljs-string">&quot;num_return_sequences&quot;</span>: <span class="hljs-number">2</span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a joint venture between GEO Group, one of&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is not an exact science – but what we believe does&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># However, with temperature close to 0, it approximates greedy decoding strategies (invariant)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_kwargs[<span class="hljs-string">&quot;temperature&quot;</span>] = <span class="hljs-number">0.0001</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, **generate_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>))
[<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>,
<span class="hljs-string">&#x27;Hugging Face Company is a company that has been around for over 20 years&#x27;</span>]`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function Mw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMEElMkMlMjBCJTJDJTIwQyUyQyUyMEQlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMFdpdGglMjBzYW1wbGluZyUyQyUyMHRoZSUyMG91dHB1dCUyMGlzJTIwdW5leHBlY3RlZCUyMC0tJTIwc29tZXRpbWVzJTIwdG9vJTIwdW5leHBlY3RlZC4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2l0aCUyMCU2MHRvcF9rJTYwJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBnZXRzJTIwcmVzdHJpY3RlZCUyMHRoZSUyMGslMjBtb3N0JTIwbGlrZWx5JTIwdG9rZW5zLiUwQSUyMyUyMFBybyUyMHRpcCUzQSUyMEluJTIwcHJhY3RpY2UlMkMlMjBMTE1zJTIwdXNlJTIwJTYwdG9wX2slNjAlMjBpbiUyMHRoZSUyMDUtNTAlMjByYW5nZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdG9wX2slM0QyKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: A, B, C, D&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, G, H, I. A, M

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_k\` sampling, the output gets restricted the k most likely tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_k\` in the 5-50 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_k=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: A, B, C, D, E, F, G, H, I`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function vw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBc2V0X3NlZWQoMCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxncHQyJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkElMjBzZXF1ZW5jZSUzQSUyMDElMkMlMjAyJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXaXRoJTIwc2FtcGxpbmclMkMlMjB0aGUlMjBvdXRwdXQlMjBpcyUyMHVuZXhwZWN0ZWQlMjAtLSUyMHNvbWV0aW1lcyUyMHRvbyUyMHVuZXhwZWN0ZWQuJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUwQSUyMyUyMFdpdGglMjAlNjB0b3BfcCU2MCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwZ2V0cyUyMHJlc3RyaWN0ZWQlMjB0byUyMGhpZ2gtcHJvYmFiaWxpdHklMjB0b2tlbnMuJTBBJTIzJTIwUHJvJTIwdGlwJTNBJTIwSW4lMjBwcmFjdGljZSUyQyUyMExMTXMlMjB1c2UlMjAlNjB0b3BfcCU2MCUyMGluJTIwdGhlJTIwMC45LTAuOTUlMjByYW5nZS4lMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdG9wX3AlM0QwLjEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;A sequence: 1, 2&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output is unexpected -- sometimes too unexpected.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2.</span> <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>, <span class="hljs-number">2</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`top_p\` sampling, the output gets restricted to high-probability tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pro tip: In practice, LLMs use \`top_p\` in the 0.9-0.95 range.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
A sequence: <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function ww($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUyQyUyMHNldF9zZWVkJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRmJsb29tei01NjBtJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbXotNTYwbSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyMSUyQyUyMDIlMkMlMjAzJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBXZSUyMGNhbiUyMHNlZSUyMHRoYXQlMjBncmVlZHklMjBkZWNvZGluZyUyMHByb2R1Y2VzJTIwYSUyMHNlcXVlbmNlJTIwb2YlMjBudW1iZXJzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwRm9yJTIwdGhpcyUyMHBhcnRpY3VsYXIlMjBzZWVkJTJDJTIwd2UlMjBjYW4lMjBzZWUlMjB0aGF0JTIwc2FtcGxpbmclMjBwcm9kdWNlcyUyMG5lYXJseSUyMHRoZSUyMHNhbWUlMjBsb3ctaW5mb3JtYXRpb24lMjAoJTNEJTIwbG93JTIwZW50cm9weSklMEElMjMlMjBzZXF1ZW5jZSUwQXNldF9zZWVkKDE4KSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCklMEElMEElMjMlMjBXaXRoJTIwJTYwdHlwaWNhbF9wJTYwJTIwc2V0JTJDJTIwdGhlJTIwbW9zdCUyMG9idmlvdXMlMjBzZXF1ZW5jZSUyMGlzJTIwbm8lMjBsb25nZXIlMjBwcm9kdWNlZCUyQyUyMHdoaWNoJTIwbWF5JTIwYmUlMjBnb29kJTIwZm9yJTIweW91ciUyMHByb2JsZW0lMEFzZXRfc2VlZCgxOCklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwdHlwaWNhbF9wJTNEMC4xJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUlMEEpJTBBcHJpbnQodG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzLnNlcXVlbmNlcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIzJTIwV2UlMjBjYW4lMjBzZWUlMjB0aGF0JTIwdGhlJTIwdG9rZW4lMjBjb3JyZXNwb25kaW5nJTIwdG8lMjAlMjI0JTIyJTIwKHRva2VuJTIwOTM0KSUyMGluJTIwdGhlJTIwc2Vjb25kJTIwcG9zaXRpb24lMkMlMjB0aGUlMjBtb3N0JTIwbGlrZWx5JTIwdG9rZW4lMEElMjMlMjBhcyUyMHNlZW4lMjB3aXRoJTIwZ3JlZWR5JTIwZGVjb2RpbmclMkMlMjB3YXMlMjBlbnRpcmVseSUyMGJsb2NrZWQlMjBvdXQlMEFwcmludChvdXRwdXRzLnNjb3JlcyU1QjElNUQlNUIwJTJDJTIwOTM0JTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM, set_seed

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloomz-560m&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;1, 2, 3&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that greedy decoding produces a sequence of numbers</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span>, <span class="hljs-number">10</span>,

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># For this particular seed, we can see that sampling produces nearly the same low-information (= low entropy)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sequence</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">6</span>, <span class="hljs-number">7</span>, <span class="hljs-number">8</span>, <span class="hljs-number">9</span> <span class="hljs-keyword">and</span> <span class="hljs-number">10</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With \`typical_p\` set, the most obvious sequence is no longer produced, which may be good for your problem</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">18</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs, do_sample=<span class="hljs-literal">True</span>, typical_p=<span class="hljs-number">0.1</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.sequences, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span> <span class="hljs-keyword">and</span> <span class="hljs-number">5</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We can see that the token corresponding to &quot;4&quot; (token 934) in the second position, the most likely token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># as seen with greedy decoding, was entirely blocked out</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.scores[<span class="hljs-number">1</span>][<span class="hljs-number">0</span>, <span class="hljs-number">934</span>])
tensor(-inf)`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function jw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyVG9kYXklMkMlMjBhJTIwZHJhZ29uJTIwZmxldyUyMG92ZXIlMjBQYXJpcyUyQyUyMEZyYW5jZSUyQyUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QxLjUpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwd2l0aCUyMGElMjBuZWdhdGl2ZSUyMHByb21wdCUwQW5lZ19pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMHZlcnklMjBoYXBweSUyMGV2ZW50JTIwaGFwcGVuZWQlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMiUyQyUyMG5lZ2F0aXZlX3Byb21wdF9pZHMlM0RuZWdfaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0JTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQSUwQSUyMyUyMHdpdGglMjBhJTIwcG9zaXRpdmUlMjBwcm9tcHQlMEFuZWdfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjB2ZXJ5JTIwaGFwcHklMjBldmVudCUyMGhhcHBlbmVkJTJDJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFvdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAlMkMlMjBuZWdhdGl2ZV9wcm9tcHRfaWRzJTNEbmVnX2lucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today, a dragon flew over Paris, France,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">1.5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 50 people and injuring more than 100&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a negative prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">2</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;Today, a dragon flew over Paris, France, killing at least 130 people. French media reported that&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># with a positive prompt</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>neg_inputs = tokenizer([<span class="hljs-string">&quot;A very happy event happened,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>out = model.generate(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>], guidance_scale=<span class="hljs-number">0</span>, negative_prompt_ids=neg_inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;Today, a dragon flew over Paris, France, and I&#x27;m very happy to be here. I&quot;</span>`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function kw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMFdoaXNwZXJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBHZW5lcmF0aW9uQ29uZmlnJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQW1vZGVsJTIwJTNEJTIwV2hpc3BlckZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJTIyKSUwQWRzJTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoZHMlNUIzJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRfZmVhdHVyZXMlMjAlM0QlMjBpbnB1dHMuaW5wdXRfZmVhdHVyZXMlMEElMEElMjNEaXNwbGF5aW5nJTIwdGltZXN0YW1wcyUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShpbnB1dHMlM0RpbnB1dF9mZWF0dXJlcyUyQyUyMHJldHVybl90aW1lc3RhbXBzJTNEVHJ1ZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwZGVjb2RlX3dpdGhfdGltZXN0YW1wcyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKSUwQSUwQSUwQSUyM05vJTIwdGltZXN0YW1wcyUyMCUyNiUyMGNoYW5nZSUyMEVPUyUzQSUwQSUyM1RoaXMlMjBhbGxvd3MlMjB0aGUlMjB1c2VyJTIwdG8lMjBzZWxlY3QlMjBhJTIwc3BlY2lmaWMlMjB0b2tlbiUyMHRvJTIwdGVybWluYXRlJTIwdGhlJTIwc2VxdWVuY2UlMjBvbiUyQyUyMGluJTIwdGhpcyUyMGNhc2UlMjBpdCdzJTIwdGhlJTIwd29yZCUyMCUyMmNhbiUyMig0NjApJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZW9zX3Rva2VuX2lkJTIwJTNEJTIwNDYwJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKGlucHV0cyUzRGlucHV0X2ZlYXR1cmVzJTJDcmV0dXJuX3RpbWVzdGFtcHMlM0RGYWxzZSklMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTVCMCU1RCUwQXByaW50KCUyMlRyYW5zY3JpcHRpb24lM0ElMjIlMkMlMjB0cmFuc2NyaXB0aW9uKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, WhisperForConditionalGeneration, GenerationConfig
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = WhisperForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;openai/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(ds[<span class="hljs-number">3</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_features = inputs.input_features

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment">#Displaying timestamps</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, decode_with_timestamps=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription: &lt;|startoftranscript|&gt;&lt;|<span class="hljs-number">0.00</span>|&gt; He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all, and can&lt;|6.44|&gt;&lt;|6.44|&gt; discover in it but little of rocky Ithaca.&lt;|9.44|&gt;&lt;|endoftext|&gt;


&gt;&gt;&gt; #No timestamps &amp; change EOS:
&gt;&gt;&gt; #This allows the user to select a specific token to terminate the sequence on, in this case it&#x27;</span>s the word <span class="hljs-string">&quot;can&quot;</span>(<span class="hljs-number">460</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.eos_token_id = <span class="hljs-number">460</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(inputs=input_features,return_timestamps=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Transcription:&quot;</span>, transcription)
Transcription:  He has grave doubts whether Sir Frederick Layton<span class="hljs-string">&#x27;s work is really Greek after all and can</span>`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function $w($){let c,k;return c=new x({props:{code:"Y29tcGxldGVkJTIwJTNEJTIwRmFsc2UlMEF3aGlsZSUyMG5vdCUyMGNvbXBsZXRlZCUzQSUwQSUyMCUyMCUyMCUyMF8lMkMlMjBjb21wbGV0ZWQlMjAlM0QlMjBjb25zdHJhaW50LnVwZGF0ZShjb25zdHJhaW50LmFkdmFuY2UoKSk=",highlighted:`completed = <span class="hljs-literal">False</span>
<span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> completed:
    _, completed = constraint.update(constraint.advance())`,wrap:!1}}),{c(){p(c.$$.fragment)},l(b){m(c.$$.fragment,b)},m(b,_){u(c,b,_),k=!0},p:J,i(b){k||(g(c.$$.fragment,b),k=!0)},o(b){h(c.$$.fragment,b),k=!1},d(b){f(c,b)}}}function Jw($){let c,k="The API for the streamer classes is still under development and may change in the future.";return{c(){c=a("p"),c.textContent=k},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-gv2g1g"&&(c.textContent=k)},m(b,_){d(b,c,_)},p:J,d(b){b&&t(c)}}}function xw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRTdHJlYW1lciUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dFN0cmVhbWVyKHRvayklMEElMEElMjMlMjBEZXNwaXRlJTIwcmV0dXJuaW5nJTIwdGhlJTIwdXN1YWwlMjBvdXRwdXQlMkMlMjB0aGUlMjBzdHJlYW1lciUyMHdpbGwlMjBhbHNvJTIwcHJpbnQlMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwdG8lMjBzdGRvdXQuJTBBXyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwc3RyZWFtZXIlM0RzdHJlYW1lciUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextStreamer

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Despite returning the usual output, the streamer will also print the generated text to stdout.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>_ = model.generate(**inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function Uw($){let c,k="The API for the streamer classes is still under development and may change in the future.";return{c(){c=a("p"),c.textContent=k},l(b){c=l(b,"P",{"data-svelte-h":!0}),y(c)!=="svelte-gv2g1g"&&(c.textContent=k)},m(b,_){d(b,c,_)},p:J,d(b){b&&t(c)}}}function Bw($){let c,k="Examples:",b,_,w;return _=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMFRleHRJdGVyYXRvclN0cmVhbWVyJTBBZnJvbSUyMHRocmVhZGluZyUyMGltcG9ydCUyMFRocmVhZCUwQSUwQXRvayUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2soJTVCJTIyQW4lMjBpbmNyZWFzaW5nJTIwc2VxdWVuY2UlM0ElMjBvbmUlMkMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXN0cmVhbWVyJTIwJTNEJTIwVGV4dEl0ZXJhdG9yU3RyZWFtZXIodG9rKSUwQSUwQSUyMyUyMFJ1biUyMHRoZSUyMGdlbmVyYXRpb24lMjBpbiUyMGElMjBzZXBhcmF0ZSUyMHRocmVhZCUyQyUyMHNvJTIwdGhhdCUyMHdlJTIwY2FuJTIwZmV0Y2glMjB0aGUlMjBnZW5lcmF0ZWQlMjB0ZXh0JTIwaW4lMjBhJTIwbm9uLWJsb2NraW5nJTIwd2F5LiUwQWdlbmVyYXRpb25fa3dhcmdzJTIwJTNEJTIwZGljdChpbnB1dHMlMkMlMjBzdHJlYW1lciUzRHN0cmVhbWVyJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEF0aHJlYWQlMjAlM0QlMjBUaHJlYWQodGFyZ2V0JTNEbW9kZWwuZ2VuZXJhdGUlMkMlMjBrd2FyZ3MlM0RnZW5lcmF0aW9uX2t3YXJncyklMEF0aHJlYWQuc3RhcnQoKSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwJTIyJTIyJTBBZm9yJTIwbmV3X3RleHQlMjBpbiUyMHN0cmVhbWVyJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3RleHQlMjAlMkIlM0QlMjBuZXdfdGV4dCUwQWdlbmVyYXRlZF90ZXh0",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, TextIteratorStreamer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> threading <span class="hljs-keyword">import</span> Thread

<span class="hljs-meta">&gt;&gt;&gt; </span>tok = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tok([<span class="hljs-string">&quot;An increasing sequence: one,&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>streamer = TextIteratorStreamer(tok)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Run the generation in a separate thread, so that we can fetch the generated text in a non-blocking way.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_kwargs = <span class="hljs-built_in">dict</span>(inputs, streamer=streamer, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread = Thread(target=model.generate, kwargs=generation_kwargs)
<span class="hljs-meta">&gt;&gt;&gt; </span>thread.start()
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = <span class="hljs-string">&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> new_text <span class="hljs-keyword">in</span> streamer:
<span class="hljs-meta">... </span>    generated_text += new_text
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text
<span class="hljs-string">&#x27;An increasing sequence: one, two, three, four, five, six, seven, eight, nine, ten, eleven,&#x27;</span>`,wrap:!1}}),{c(){c=a("p"),c.textContent=k,b=o(),p(_.$$.fragment)},l(n){c=l(n,"P",{"data-svelte-h":!0}),y(c)!=="svelte-kvfsh7"&&(c.textContent=k),b=r(n),m(_.$$.fragment,n)},m(n,j){d(n,c,j),d(n,b,j),u(_,n,j),w=!0},p:J,i(n){w||(g(_.$$.fragment,n),w=!0)},o(n){h(_.$$.fragment,n),w=!1},d(n){n&&(t(c),t(b)),f(_,n)}}}function Iw($){let c,k,b,_,w,n,j,ty=`このページには、<a href="/docs/transformers/main/ja/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> で使用されるすべてのユーティリティ関数がリストされています。
<a href="/docs/transformers/main/ja/main_classes/text_generation#transformers.GenerationMixin.greedy_search">greedy_search()</a>,
<a href="/docs/transformers/main/ja/main_classes/text_generation#transformers.GenerationMixin.contrastive_search">contrastive_search()</a>,
<a href="/docs/transformers/main/ja/main_classes/text_generation#transformers.GenerationMixin.sample">sample()</a>,
<a href="/docs/transformers/main/ja/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a>,
<a href="/docs/transformers/main/ja/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a>,
<a href="/docs/transformers/main/ja/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>、および
<a href="/docs/transformers/main/ja/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search">constrained_beam_search()</a>。`,Cp,on,sy="これらのほとんどは、ライブラリ内の生成メソッドのコードを学習する場合にのみ役に立ちます。",Gp,rn,Xp,an,ny=`<a href="/docs/transformers/main/ja/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> の出力は、次のサブクラスのインスタンスです。
<a href="/docs/transformers/main/ja/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a>。この出力は、返されたすべての情報を含むデータ構造です。
<a href="/docs/transformers/main/ja/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> によって作成されますが、タプルまたは辞書としても使用できます。`,Rp,ln,oy="以下に例を示します。",Np,cn,Ep,dn,ry=`<code>generation_output</code> オブジェクトは、できる限り <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.generation.GenerateDecoderOnlyOutput">GenerateDecoderOnlyOutput</a> です。
以下のそのクラスのドキュメントを参照してください。これは、次の属性があることを意味します。`,Sp,pn,ay="<li><code>sequences</code>: 生成されたトークンのシーケンス</li> <li><code>scores</code> (オプション): 各生成ステップの言語モデリング ヘッドの予測スコア</li> <li><code>hidden_​​states</code> (オプション): 生成ステップごとのモデルの隠れた状態</li> <li><code>attentions</code> (オプション): 生成ステップごとのモデルのアテンションの重み</li>",qp,mn,ly=`ここでは、<code>output_scores=True</code>を渡したので <code>scores</code> がありますが、<code>hidden_​​states</code> はありません。
<code>attentions</code> は、<code>output_hidden_​​states=True</code>または<code>output_attentions=True</code>を渡さなかったためです。`,Hp,un,iy=`通常と同じように各属性にアクセスできます。その属性がモデルから返されなかった場合は、
は「なし」を取得します。ここで、たとえば<code>generation_output.scores</code>は、生成されたすべての予測スコアです。
言語モデリングのヘッドであり、<code>generation_output.attentions</code>は<code>None</code>です。`,Pp,gn,cy=`<code>generation_output</code> オブジェクトをタプルとして使用する場合、<code>None</code> 値を持たない属性のみが保持されます。
たとえば、ここには 2 つの要素、<code>loss</code>、次に<code>logits</code>があります。`,Dp,hn,Qp,fn,dy="たとえば、タプル <code>(generation_output.sequences,generation_output.scores)</code> を返します。",Yp,_n,py=`<code>generation_output</code> オブジェクトを辞書として使用する場合、<code>None</code> を持たない属性のみが保持されます。
ここでは、たとえば、<code>sequences</code>と<code>scores</code>という 2 つのキーがあります。`,Ap,bn,my="ここではすべての出力タイプを文書化します。",Op,yn,Kp,vt,Tn,fg,ml,uy="Outputs of decoder-only generation models, when using non-beam methods.",em,wt,Mn,_g,ul,gy="Outputs of encoder-decider generation models, when using non-beam methods.",tm,jt,vn,bg,gl,hy="Outputs of decoder-only generation models, when using beam methods.",sm,kt,wn,yg,hl,fy="Outputs of encoder-decoder generation models, when using beam methods.",nm,jn,om,$t,kn,Tg,fl,_y=`Base class for outputs of encoder-decoder generation models using greedy search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,rm,Jt,$n,Mg,_l,by="Base class for outputs of decoder-only generation models using greedy search.",am,xt,Jn,vg,bl,yy=`Base class for outputs of encoder-decoder generation models using sampling. Hidden states and attention weights of
the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,lm,Ut,xn,wg,yl,Ty="Base class for outputs of decoder-only generation models using sampling.",im,Bt,Un,jg,Tl,My=`Base class for outputs of encoder-decoder generation models using beam search. Hidden states and attention weights
of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the encoder_hidden_states
attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,cm,It,Bn,kg,Ml,vy="Base class for outputs of decoder-only generation models using beam search.",dm,Zt,In,$g,vl,wy=`Base class for outputs of encoder-decoder generation models using beam sampling. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,pm,zt,Zn,Jg,wl,jy="Base class for outputs of decoder-only generation models using beam sample.",mm,Wt,zn,xg,jl,ky=`Base class for outputs of encoder-decoder generation models using contrastive search. Hidden states and attention
weights of the decoder (respectively the encoder) can be accessed via the encoder_attentions and the
encoder_hidden_states attributes (respectively the decoder_attentions and the decoder_hidden_states attributes)`,um,Vt,Wn,Ug,kl,$y="Base class for outputs of decoder-only generation models using contrastive search.",gm,Vn,hm,ve,Ln,Bg,$l,Jy="Flax Base class for outputs of decoder-only generation models using sampling.",Ig,Nt,Fn,Zg,Jl,xy="“Returns a new object replacing the specified fields with new values.",fm,we,Cn,zg,xl,Uy="Flax Base class for outputs of decoder-only generation models using greedy search.",Wg,Et,Gn,Vg,Ul,By="“Returns a new object replacing the specified fields with new values.",_m,je,Xn,Lg,Bl,Iy="Flax Base class for outputs of decoder-only generation models using greedy search.",Fg,St,Rn,Cg,Il,Zy="“Returns a new object replacing the specified fields with new values.",bm,Nn,ym,En,zy=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> を使用して、言語モデルのヘッドの予測スコアを変更できます。
世代。`,Tm,Sn,Mm,A,qn,Gg,Zl,Wy='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing alternated generation between the two codebooks of Bark.',Xg,qt,Rg,zl,Hn,vm,z,Pn,Ng,Wl,Vy=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for classifier free guidance (CFG). The scores are split over the batch dimension,
where the first half correspond to the conditional logits (predicted from the input prompt) and the second half
correspond to the unconditional logits (predicted from an empty or ‘null’ prompt). The processor computes a
weighted average across the conditional and unconditional logits, parameterised by the <code>guidance_scale</code>.`,Eg,Vl,Ly='See <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">the paper</a> for more information.',Sg,Ht,qg,Pt,Hg,Ll,Dn,wm,F,Qn,Pg,Fl,Fy=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.NoRepeatNGramLogitsProcessor">NoRepeatNGramLogitsProcessor</a>, but applied exclusively to prevent
the repetition of n-grams present in the prompt.`,Dg,Cl,Cy=`It was designed to promote chattiness in a language model, by preventing the generation of n-grams present in
previous conversation rounds.`,Qg,Dt,Yg,Gl,Yn,jm,C,An,Ag,Xl,Gy=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that works similarly to <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.RepetitionPenaltyLogitsProcessor">RepetitionPenaltyLogitsProcessor</a>, but with an <em>inverse</em> penalty
that is applied to the tokens present in the prompt. In other words, a penalty above 1.0 increases the odds of
selecting tokens that were present in the prompt.`,Og,Rl,Xy=`It was designed to avoid hallucination in input-grounded tasks, like summarization. Although originally intended
for encoder-decoder models, it can also be used with decoder-only models like LLMs.`,Kg,Qt,eh,Nl,On,km,O,Kn,th,El,Ry=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs epsilon-sampling, i.e. restricting to tokens with <code>prob &gt;= epsilon</code>. Takes the
largest min_tokens_to_keep tokens if no tokens satisfy this constraint. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more information.`,sh,Yt,nh,Sl,eo,$m,K,to,oh,ql,Ny=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs eta-sampling, a technique to filter out tokens with probabilities below a dynamic
cutoff value, <code>eta</code>, which is calculated based on a combination of the hyperparameter <code>epsilon</code> and the entropy of
the token probabilities, i.e. <code>eta := min(epsilon, sqrt(epsilon * e^-entropy(probabilities)))</code>. Takes the largest
min_tokens_to_keep tokens if no tokens satisfy this constraint. It addresses the issue of poor quality in long
samples of text generated by neural language models leading to more coherent and fluent text. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation
Sampling as Language Model Desmoothing</a> for more information. Note: <code>do_sample</code>
must be set to <code>True</code> for this <code>LogitsWarper</code> to work.`,rh,At,ah,Hl,so,Jm,ee,no,lh,Pl,Ey=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that exponentially increases the score of the <code>eos_token_id</code> after <code>start_index</code> has been
reached. This allows generating shorter sequences without having a hard cutoff, allowing the <code>eos_token</code> to be
predicted in a meaningful position.`,ih,Ot,ch,Dl,oo,xm,te,ro,dh,Ql,Sy=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the first generated token. Used with encoder-decoder
models.`,ph,Kt,mh,Yl,ao,Um,se,lo,uh,Al,qy='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',gh,es,hh,Ol,io,Bm,ne,co,fh,Kl,Hy=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before generation. The processor will set their log probs to <code>inf</code> so that they are
sampled at their corresponding index. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,_h,ts,bh,ei,po,Im,W,mo,yh,ti,Py='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces diverse beam search.',Th,si,Dy=`Note that this logits processor is only effective for <a href="/docs/transformers/main/ja/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">PreTrainedModel.group_beam_search()</a>. See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">Diverse Beam
Search: Decoding Diverse Solutions from Neural Sequence Models</a> for more
details.`,Mh,ni,Qy=`Traditional beam search often generates very similar sequences across different beams.
<code>HammingDiversityLogitsProcessor</code> addresses this by penalizing beams that generate tokens already chosen by other
beams in the same time step.`,vh,ss,wh,oi,uo,Zm,oe,go,jh,ri,Yy=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that removes all <code>nan</code> and <code>inf</code> values to avoid the generation method to fail. Note that using
the logits processor should only be used if necessary since it can slow down the generation method.`,kh,ai,Ay=`This logits processor has no <code>generate</code> example, as there shouldn’t be a correct combination of flags that warrants
its use.`,$h,li,ho,zm,re,fo,Jh,ii,Oy=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> and <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> for normalizing the scores using log-softmax. It’s important to normalize
the scores during beam search, after applying the logits processors or warpers, since the search algorithm used in
this library doesn’t do it (it only does it before, but they may need re-normalization) but it still supposes that
the scores are normalized when comparing the hypotheses.`,xh,ns,Uh,ci,_o,Wm,ke,bo,Bh,di,Ky="Abstract base class for all logit processors that can be applied during generation.",Ih,pi,yo,Vm,$e,To,Zh,mi,eT=`This class can be used to create a list of <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to subsequently process a
<code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> or <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> to the inputs.`,zh,ui,Mo,Lm,Je,vo,Wh,gi,tT="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Vh,hi,wo,Fm,ae,jo,Lh,fi,sT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length by setting EOS probability to 0. Note that, for decoder-only models
like most LLMs, the length includes the prompt.`,Fh,os,Ch,_i,ko,Cm,le,$o,Gh,bi,nT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforcing a min-length of new tokens by setting EOS (End-Of-Sequence) token probability to 0.
Contrarily to <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.MinLengthLogitsProcessor">MinLengthLogitsProcessor</a>, this processor ignores the prompt.`,Xh,rs,Rh,yi,Jo,Gm,G,xo,Nh,Ti,oT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces that specified sequences will never be selected.',Eh,as,Sh,ls,qh,Mi,Uo,Xm,X,Bo,Hh,vi,rT=`N-grams are groups of “n” consecutive words, characters, or tokens taken from a sequence of text. Given the
sentence: “She runs fast”, the bi-grams (n=2) would be (“she”, “runs”) and (“runs”, “fast”). In text generation,
avoiding repetitions of word sequences provides a more diverse output. This <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> enforces no
repetition of n-grams by setting the scores of banned tokens to negative infinity which eliminates those tokens
from consideration when further processing the scores. Note that, for decoder-only models like most LLMs, the
prompt is also considered to obtain the n-grams.
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,Ph,is,Dh,cs,Qh,wi,Io,Rm,ie,Zo,Yh,ji,aT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that enforces constrained generation and is useful for prefix-conditioned constrained
generation. See <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity Retrieval</a> for more information.`,Ah,ds,Oh,ki,zo,Nm,R,Wo,Kh,$i,lT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that prevents the repetition of previous tokens through a penalty. This penalty is applied at
most once per token. Note that, for decoder-only models like most LLMs, the considered tokens include the prompt.`,ef,Ji,iT=`In the original <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">paper</a>, the authors suggest the use of a penalty of around
1.2 to achieve a good balance between truthful generation and lack of repetition. To penalize and reduce
repetition, use <code>penalty</code> values above 1.0, where a higher value penalizes more strongly. To reward and encourage
repetition, use <code>penalty</code> values between 0.0 and 1.0, where a lower value rewards more strongly.`,tf,ps,sf,xi,Vo,Em,N,Lo,nf,Ui,cT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that applies an additive bias on sequences. The bias is applied to the last token of a sequence
when the next generated token can complete it. Consequently, to take the most of biasing sequences with more than
one token, consider using beam methods (to gracefully work around partially completed sequences that have a
negative bias) and applying the bias to their prefixes (to ensure the bias is applied earlier).`,of,ms,rf,us,af,Bi,Fo,Sm,ce,Co,lf,Ii,dT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.SuppressTokensAtBeginLogitsProcessor">SuppressTokensAtBeginLogitsProcessor</a> supresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are
not generated at the begining. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,cf,gs,df,Zi,Go,qm,de,Xo,pf,zi,pT=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so
that they are not generated. Originally created for
<a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>.`,mf,hs,uf,Wi,Ro,Hm,E,No,gf,Vi,mT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> for temperature (exponential scaling output probability distribution), which effectively means
that it can control the randomness of the predicted tokens. Often used together with <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a> and
<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,hf,fs,ff,_s,_f,Li,Eo,Pm,pe,So,bf,Fi,uT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements. Often used together
with <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TopPLogitsWarper">TopPLogitsWarper</a>.`,yf,bs,Tf,Ci,qo,Dm,me,Ho,Mf,Gi,gT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off. Often
used together with <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TemperatureLogitsWarper">TemperatureLogitsWarper</a> and <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TopKLogitsWarper">TopKLogitsWarper</a>.`,vf,ys,wf,Xi,Po,Qm,S,Do,jf,Ri,hT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> that performs typical decoding. Inspired on how humans use language, it prioritizes tokens whose
log probability is close to the entropy of the token probability distribution. This means that the most likely
tokens may be discarded in the process.`,kf,Ni,fT='See <a href="https://arxiv.org/abs/2202.00666" rel="nofollow">Typical Decoding for Natural Language Generation</a> for more information.',$f,Ts,Jf,Ei,Qo,Ym,q,Yo,xf,Si,_T=`Logits processor for Classifier-Free Guidance (CFG). The processors computes a weighted average across scores
from prompt conditional and prompt unconditional (or negative) logits, parameterized by the <code>guidance_scale</code>.
The unconditional scores are computed internally by prompting <code>model</code> with the <code>unconditional_ids</code> branch.`,Uf,qi,bT='See <a href="https://arxiv.org/abs/2306.17806" rel="nofollow">the paper</a> for more information.',Bf,Ms,If,Hi,Ao,Am,H,Oo,Zf,Pi,yT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a> that modifies the logits for the generation of timestamps in the transcription. When the input
tokens are at a specific threshold, the processor sets the scores to negative infinity. The processor makes sure
that timestamp tokens appear in pairs, by masking out the logits that would break this pairing pattern. This is
done to maintain the consistency and structure of generated timestamps. It also ensures that when the predicted
probability of sampling any of the timestamp token is greater than any individual non-timestamp token, those
non-timestamp logits are set to negative infinity. This is done to ensure the generation of timestamps over other
potential tokens.`,zf,Di,TT='See <a href="https://arxiv.org/abs/2212.04356" rel="nofollow">the paper</a> for more information.',Wf,vs,Vf,Qi,Ko,Om,er,Km,xe,tr,Lf,Yi,MT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the first generated token.',Ff,Ai,sr,eu,Ue,nr,Cf,Oi,vT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',Gf,Ki,or,tu,Be,rr,Xf,ec,wT=`This processor takes a list of pairs of integers which indicates a mapping from generation indices to token
indices that will be forced before sampling. The processor will set their log probs to <code>0</code> and all other tokens to
<code>-inf</code> so that they are sampled at their corresponding index.`,Rf,tc,ar,su,Ie,lr,Nf,sc,jT="Abstract base class for all logit processors that can be applied during generation.",Ef,ws,ir,Sf,nc,kT="TF method for processing logits.",nu,Ze,cr,qf,oc,$T=`This class can be used to create a list of <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to subsequently process a <code>scores</code> input tensor.
This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> to the
inputs.`,Hf,rc,dr,ou,ze,pr,Pf,ac,JT="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",Df,js,mr,Qf,lc,xT="TF method for warping logits.",ru,We,ur,Yf,ic,UT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',Af,cc,gr,au,Ve,hr,Of,dc,BT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces that specified sequences will never be sampled.',Kf,pc,fr,lu,Le,_r,e_,mc,IT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> that enforces no repetition of n-grams. See
<a href="https://github.com/pytorch/fairseq/blob/a07cb6f40480928c9e0548b737aadd36ee66ac76/fairseq/sequence_generator.py#L345" rel="nofollow">Fairseq</a>.`,t_,uc,br,iu,Fe,yr,s_,gc,ZT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TFLogitsProcessor">TFLogitsProcessor</a> enforcing an exponential penalty on repeated sequences.',n_,hc,Tr,cu,Ce,Mr,o_,fc,zT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TFSuppressTokensAtBeginLogitsProcessor">TFSuppressTokensAtBeginLogitsProcessor</a> suppresses a list of tokens as soon as the <code>generate</code> function starts
generating using <code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> at not
sampled at the begining of the generation.`,r_,_c,vr,du,Ge,wr,a_,bc,WT=`This processor can be used to suppress a list of tokens. The processor will set their log probs to <code>-inf</code> so that they
are not sampled.`,l_,yc,jr,pu,Xe,kr,i_,Tc,VT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> for temperature (exponential scaling output probability distribution).',c_,Mc,$r,mu,Re,Jr,d_,vc,LT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',p_,wc,xr,uu,Ne,Ur,m_,jc,FT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.TFLogitsWarper">TFLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to &lt;= prob_cut_off.',u_,kc,Br,gu,Ir,hu,Ee,Zr,g_,$c,CT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the first generated token.',h_,Jc,zr,fu,Se,Wr,f_,xc,GT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that enforces the specified token as the last generated token when <code>max_length</code> is reached.',__,Uc,Vr,_u,qe,Lr,b_,Bc,XT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> that takes a list of pairs of integers which indicates a mapping from generation indices to
token indices that will be forced before sampling. The processor will set their log probs to 0 and all other tokens
to <code>-inf</code> so that they are sampled at their corresponding index.`,y_,Ic,Fr,bu,He,Cr,T_,Zc,RT="Abstract base class for all logit processors that can be applied during generation.",M_,ks,Gr,v_,zc,NT="Flax method for processing logits.",yu,Pe,Xr,w_,Wc,ET=`This class can be used to create a list of <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to subsequently process
a <code>scores</code> input tensor. This class inherits from list and adds a specific <em><strong>call</strong></em> method to apply each
<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> or <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> to the inputs.`,j_,Vc,Rr,Tu,De,Nr,k_,Lc,ST="Abstract base class for all logit warpers that can be applied during generation with multinomial sampling.",$_,$s,Er,J_,Fc,qT="Flax method for warping logits.",Mu,Qe,Sr,x_,Cc,HT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> enforcing a min-length by setting EOS probability to 0.',U_,Gc,qr,vu,Ye,Hr,B_,Xc,PT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> supressing a list of tokens as soon as the <code>generate</code> function starts generating using
<code>begin_index</code> tokens. This should ensure that the tokens defined by <code>begin_suppress_tokens</code> are not sampled at the
begining of the generation.`,I_,Rc,Pr,wu,Ae,Dr,Z_,Nc,DT=`<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.FlaxLogitsProcessor">FlaxLogitsProcessor</a> suppressing a list of tokens at each decoding step. The processor will set their log probs
to be <code>-inf</code> so they are not sampled.`,z_,Ec,Qr,ju,Oe,Yr,W_,Sc,QT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> for temperature (exponential scaling output probability distribution).',V_,qc,Ar,ku,Ke,Or,L_,Hc,YT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-k, i.e. restricting to the k highest probability elements.',F_,Pc,Kr,$u,et,ea,C_,Dc,AT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.FlaxLogitsWarper">FlaxLogitsWarper</a> that performs top-p, i.e. restricting to top tokens summing to prob_cut_off &lt;= prob_cut_off.',G_,Qc,ta,Ju,tt,sa,X_,Yc,OT=`Whisper specific Processor. This processor can be used to force a list of tokens. The processor will set their log
probs to <code>inf</code> so that they are sampled at their corresponding index.`,R_,Ac,na,xu,oa,Uu,ra,KT='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a> を使用して、(EOS トークン以外の) 生成を停止するタイミングを変更できます。これは PyTorch 実装でのみ利用可能であることに注意してください。',Bu,ue,aa,N_,Oc,eM="Abstract base class for all stopping criteria that can be applied during generation.",E_,Kc,tM="If your stopping criteria depends on the <code>scores</code> input, make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.",S_,ed,la,Iu,Lt,ia,q_,td,ca,Zu,st,da,H_,sd,sM=`This class can be used to stop generation whenever the full generated number of tokens exceeds <code>max_length</code>. Keep
in mind for decoder-only type of transformers, this will include the initial prompted tokens.`,P_,nd,pa,zu,nt,ma,D_,od,nM=`This class can be used to stop generation whenever the full generation exceeds some amount of time. By default, the
time will start being counted when you initialize this function. You can override this by passing an
<code>initial_time</code>.`,Q_,rd,ua,Wu,ga,Vu,ha,oM='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.Constraint">Constraint</a> を使用すると、生成時に出力に特定のトークンまたはシーケンスが含まれるように強制できます。これは PyTorch 実装でのみ利用可能であることに注意してください。',Lu,U,fa,Y_,ad,rM=`Abstract base class for all constraints that can be applied during generation.
It must define how the constraint can be satisfied.`,A_,ld,aM="All classes that inherit Constraint must follow the requirement that",O_,Js,K_,id,lM="will always terminate (halt).",eb,xs,_a,tb,cd,iM="When called, returns the token that would take this constraint one step closer to being fulfilled.",sb,Us,ba,nb,dd,cM="Creates a new instance of this constraint.",ob,Bs,ya,rb,pd,dM="Reads in a token and returns whether it creates progress.",ab,Is,Ta,lb,md,pM="Returns the number of remaining steps of <code>advance()</code> in order to complete this constraint.",ib,Zs,Ma,cb,ud,mM=`Resets the state of this constraint to its initialization. We would call this in cases where the fulfillment of
a constraint is abrupted by an unwanted token.`,db,zs,va,pb,gd,uM="Tests whether this constraint has been properly defined.",mb,mt,wa,ub,hd,gM=`Reads in a token and returns booleans that indicate the progress made by it. This function will update the
state of this object unlikes <code>does_advance(self, token_id: int)</code>.`,gb,fd,hM=`This isn’t to test whether a certain token will advance the progress; it’s to update its state as if it has
been generated. This becomes important if token_id != desired token (refer to else statement in
PhrasalConstraint)`,Fu,Ft,ja,hb,_d,fM='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.Constraint">Constraint</a> enforcing that an ordered sequence of tokens is included in the output.',Cu,Ct,ka,fb,bd,_M='A special <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.Constraint">Constraint</a> that is fulfilled by fulfilling just one of several constraints.',Gu,ge,$a,_b,yd,bM="A class for beam scorers to track its progress through a list of constraints.",bb,L,Ja,yb,Td,yM=`The list of tokens to generate such that we can make progress.
By “list” we don’t mean the list of token that will fully fulfill a constraint.`,Tb,Md,TM=`Given constraints <code>c_i = {t_ij | j == # of tokens}</code>, If we’re not in the middle of progressing through a
specific constraint <code>c_i</code>, we return:`,Mb,vd,MM="<code>[t_k1 for k in indices of unfulfilled constraints]</code>",vb,wd,vM=`If we are in the middle of a constraint, then we return:
<code>[t_ij]</code>, where <code>i</code> is the index of the inprogress constraint, <code>j</code> is the next step for the constraint.`,wb,jd,wM=`Though we don’t care which constraint is fulfilled first, if we are in the progress of fulfilling a constraint,
that’s the only one we’ll return.`,jb,Ws,xa,kb,kd,jM="token_ids: the tokens generated thus far to reset the state of the progress through constraints.",Xu,Ua,Ru,he,Ba,$b,$d,kM=`Abstract base class for all beam scorers that are used for <a href="/docs/transformers/main/ja/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a> and
<a href="/docs/transformers/main/ja/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a>.`,Jb,Jd,Ia,xb,xd,Za,Nu,V,za,Ub,Ud,$M='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing standard beam search decoding.',Bb,Bd,JM=`Adapted in part from <a href="https://github.com/facebookresearch/XLM/blob/9e6f6814d17be4fe5b15f2e6c43eb2b2d76daeb4/src/model/transformer.py#L529" rel="nofollow">Facebook’s XLM beam search
code</a>.`,Ib,Id,xM=`Reference for the diverse beam search algorithm and implementation <a href="https://github.com/ashwinkalyan/dbs/blob/master/dbs/beam_utils.lua" rel="nofollow">Ashwin Kalyan’s DBS
implementation</a>`,Zb,Zd,Wa,zb,zd,Va,Eu,fe,La,Wb,Wd,UM='<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> implementing constrained beam search decoding.',Vb,Vd,Fa,Lb,Ld,Ca,Su,Ga,qu,ot,Xa,Fb,Fd,BM="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",Cb,Cd,IM='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',Hu,rt,Ra,Gb,Gd,ZM="Filter a distribution of logits using top-k and/or nucleus (top-p) filtering",Xb,Xd,zM='From: <a href="https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317" rel="nofollow">https://gist.github.com/thomwolf/1a5a29f6962089e871b94cbd09daf317</a>',Pu,Na,Du,Z,Ea,Rb,Rd,WM="Simple text streamer that prints the token(s) to stdout as soon as entire words are formed.",Nb,Vs,Eb,Ls,Sb,Fs,Sa,qb,Nd,VM="Flushes any remaining cache and prints a newline to stdout.",Hb,Cs,qa,Pb,Ed,LM="Prints the new text to stdout. If the stream is ending, also prints a newline.",Db,Gs,Ha,Qb,Sd,FM="Receives tokens, decodes them, and prints them to stdout as soon as they form entire words.",Qu,P,Pa,Yb,qd,CM=`Streamer that stores print-ready text in a queue, to be used by a downstream application as an iterator. This is
useful for applications that benefit from acessing the generated text in a non-blocking way (e.g. in an interactive
Gradio demo).`,Ab,Xs,Ob,Rs,Kb,Ns,Da,ey,Hd,GM="Put the new text in the queue. If the stream is ending, also put a stop signal in the queue.",Yu,Up,Au;return w=new Y({props:{title:"発電用ユーティリティ",local:"発電用ユーティリティ",headingTag:"h1"}}),rn=new Y({props:{title:"出力を生成する",local:"出力を生成する",headingTag:"h2"}}),cn=new x({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJUb2tlbml6ZXIlMkMlMjBHUFQyTE1IZWFkTW9kZWwlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBHUFQyVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwR1BUMkxNSGVhZE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJIZWxsbyUyQyUyMG15JTIwZG9nJTIwaXMlMjBjdXRlJTIwYW5kJTIwJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFnZW5lcmF0aW9uX291dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwcmV0dXJuX2RpY3RfaW5fZ2VuZXJhdGUlM0RUcnVlJTJDJTIwb3V0cHV0X3Njb3JlcyUzRFRydWUp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, GPT2LMHeadModel

tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
model = GPT2LMHeadModel.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute and &quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
generation_output = model.generate(**inputs, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)`,wrap:!1}}),hn=new x({props:{code:"Z2VuZXJhdGlvbl9vdXRwdXQlNUIlM0EyJTVE",highlighted:'generation_output[:<span class="hljs-number">2</span>]',wrap:!1}}),yn=new Y({props:{title:"PyTorch",local:"transformers.generation.GenerateDecoderOnlyOutput",headingTag:"h3"}}),Tn=new v({props:{name:"class transformers.generation.GenerateDecoderOnlyOutput",anchor:"transformers.generation.GenerateDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L96"}}),Mn=new v({props:{name:"class transformers.generation.GenerateEncoderDecoderOutput",anchor:"transformers.generation.GenerateEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for
each generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L131"}}),vn=new v({props:{name:"class transformers.generation.GenerateBeamDecoderOnlyOutput",anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"},{anchor:"transformers.generation.GenerateBeamDecoderOnlyOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L178"}}),wn=new v({props:{name:"class transformers.generation.GenerateBeamEncoderDecoderOutput",anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput",parameters:[{name:"sequences",val:": LongTensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"},{name:"past_key_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens in this beam.
Tuple of <code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>torch.FloatTensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"},{anchor:"transformers.generation.GenerateBeamEncoderDecoderOutput.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor)))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
NOTE: some models have a different <code>past_key_values</code> format, confirm with the model&#x2019;s documentation.
Usually a Tuple (one element for each layer of the decoder) of tuples (two elements, key tensor and value
tensor). The first Tuple is of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L221"}}),jn=new Y({props:{title:"TensorFlow",local:"transformers.generation.TFGreedySearchEncoderDecoderOutput",headingTag:"h3"}}),kn=new v({props:{name:"class transformers.generation.TFGreedySearchEncoderDecoderOutput",anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFGreedySearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L85"}}),$n=new v({props:{name:"class transformers.generation.TFGreedySearchDecoderOnlyOutput",anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFGreedySearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L57"}}),Jn=new v({props:{name:"class transformers.generation.TFSampleEncoderDecoderOutput",anchor:"transformers.generation.TFSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size*num_return_sequences, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L155"}}),xn=new v({props:{name:"class transformers.generation.TFSampleDecoderOnlyOutput",anchor:"transformers.generation.TFSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(num_return_sequences*batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L127"}}),Un=new v({props:{name:"class transformers.generation.TFBeamSearchEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. <code>Tuple of </code>tf.Tensor<code>with up to</code>max_new_tokens<code>elements (one element for each generated token), with each tensor of shape</code>(batch_size*num_beams, config.vocab_size)\`.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams*num_return_sequences, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L232"}}),Bn=new v({props:{name:"class transformers.generation.TFBeamSearchDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams*num_return_sequences, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L197"}}),In=new v({props:{name:"class transformers.generation.TFBeamSampleEncoderDecoderOutput",anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size*num_beams, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFBeamSampleEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L317"}}),Zn=new v({props:{name:"class transformers.generation.TFBeamSampleDecoderOnlyOutput",anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"sequences_scores",val:": Optional = None"},{name:"scores",val:": Optional = None"},{name:"beam_indices",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.sequences_scores",description:`<strong>sequences_scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size * num_return_sequence)</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Final beam scores of the generated <code>sequences</code>.`,name:"sequences_scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log
softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this
beam. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token),
with each tensor of shape <code>(batch_size*num_beams*num_return_sequences, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>.`,name:"beam_indices"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFBeamSampleDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size*num_beams, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L282"}}),zn=new v({props:{name:"class transformers.generation.TFContrastiveSearchEncoderDecoderOutput",anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"encoder_attentions",val:": Optional = None"},{name:"encoder_hidden_states",val:": Optional = None"},{name:"decoder_attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"},{name:"decoder_hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_attentions",description:`<strong>encoder_attentions</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for each layer of the decoder) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.`,name:"encoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(tf.Tensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>tf.Tensor</code> (one for the output of the embeddings + one for the output of each layer) of shape
<code>(batch_size, sequence_length, hidden_size)</code>.`,name:"encoder_hidden_states"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_attentions",description:`<strong>decoder_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"decoder_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"cross_attentions"},{anchor:"transformers.generation.TFContrastiveSearchEncoderDecoderOutput.decoder_hidden_states",description:`<strong>decoder_hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"decoder_hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L393"}}),Wn=new v({props:{name:"class transformers.generation.TFContrastiveSearchDecoderOnlyOutput",anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput",parameters:[{name:"sequences",val:": Tensor = None"},{name:"scores",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"hidden_states",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter
if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code> <em>optional</em>, returned when <code>output_scores=True</code> is passed or when <code>config.output_scores=True</code>) &#x2014;
Processed prediction scores of the language modeling head (scores for each vocabulary token before SoftMax)
at each generation step. Tuple of <code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each
generated token), with each tensor of shape <code>(batch_size, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or <code>config.output_attentions=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, num_heads, generated_length, sequence_length)</code>.`,name:"attentions"},{anchor:"transformers.generation.TFContrastiveSearchDecoderOnlyOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(tuple(tf.Tensor))</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple (one element for each generated token) of tuples (one element for each layer of the decoder) of
<code>tf.Tensor</code> of shape <code>(batch_size, generated_length, hidden_size)</code>.`,name:"hidden_states"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L366"}}),Vn=new Y({props:{title:"FLAX",local:"transformers.generation.FlaxSampleOutput",headingTag:"h3"}}),Ln=new v({props:{name:"class transformers.generation.FlaxSampleOutput",anchor:"transformers.generation.FlaxSampleOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxSampleOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L68"}}),Fn=new v({props:{name:"replace",anchor:"transformers.generation.FlaxSampleOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),Cn=new v({props:{name:"class transformers.generation.FlaxGreedySearchOutput",anchor:"transformers.generation.FlaxGreedySearchOutput",parameters:[{name:"sequences",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxGreedySearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L54"}}),Gn=new v({props:{name:"replace",anchor:"transformers.generation.FlaxGreedySearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),Xn=new v({props:{name:"class transformers.generation.FlaxBeamSearchOutput",anchor:"transformers.generation.FlaxBeamSearchOutput",parameters:[{name:"sequences",val:": Array = None"},{name:"scores",val:": Array = None"}],parametersDescription:[{anchor:"transformers.generation.FlaxBeamSearchOutput.sequences",description:`<strong>sequences</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, max_length)</code>) &#x2014;
The generated sequences.`,name:"sequences"},{anchor:"transformers.generation.FlaxBeamSearchOutput.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size,)</code>) &#x2014;
The scores (log probabilities) of the generated sequences.`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_utils.py#L82"}}),Rn=new v({props:{name:"replace",anchor:"transformers.generation.FlaxBeamSearchOutput.replace",parameters:[{name:"**updates",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/flax/struct.py#L111"}}),Nn=new Y({props:{title:"LogitsProcessor",local:"logitsprocessor",headingTag:"h2"}}),Sn=new Y({props:{title:"PyTorch",local:"transformers.AlternatingCodebooksLogitsProcessor",headingTag:"h3"}}),qn=new v({props:{name:"class transformers.AlternatingCodebooksLogitsProcessor",anchor:"transformers.AlternatingCodebooksLogitsProcessor",parameters:[{name:"input_start_len",val:": int"},{name:"semantic_vocab_size",val:": int"},{name:"codebook_size",val:": int"}],parametersDescription:[{anchor:"transformers.AlternatingCodebooksLogitsProcessor.input_start_len",description:`<strong>input_start_len</strong> (<code>int</code>) &#x2014;
The length of the initial input sequence.`,name:"input_start_len"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.semantic_vocab_size",description:`<strong>semantic_vocab_size</strong> (<code>int</code>) &#x2014;
Vocabulary size of the semantic part, i.e number of tokens associated to the semantic vocabulary.`,name:"semantic_vocab_size"},{anchor:"transformers.AlternatingCodebooksLogitsProcessor.codebook_size",description:`<strong>codebook_size</strong> (<code>int</code>) &#x2014;
Number of tokens associated to the codebook.`,name:"codebook_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2011"}}),qt=new nn({props:{warning:!0,$$slots:{default:[Dv]},$$scope:{ctx:$}}}),Hn=new v({props:{name:"__call__",anchor:"transformers.AlternatingCodebooksLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2040"}}),Pn=new v({props:{name:"class transformers.ClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:""}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (float) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1947"}}),Ht=new nn({props:{warning:!0,$$slots:{default:[Qv]},$$scope:{ctx:$}}}),Pt=new B({props:{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[Yv]},$$scope:{ctx:$}}}),Dn=new v({props:{name:"__call__",anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ClassifierFreeGuidanceLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1995",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Qn=new v({props:{name:"class transformers.EncoderNoRepeatNGramLogitsProcessor",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor",parameters:[{name:"encoder_ngram_size",val:": int"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_ngram_size",description:`<strong>encoder_ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur within the encoder input ids.`,name:"encoder_ngram_size"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>int</code>) &#x2014;
The encoder_input_ids that should not be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L874"}}),Dt=new B({props:{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.example",$$slots:{default:[Av]},$$scope:{ctx:$}}}),Yn=new v({props:{name:"__call__",anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderNoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L923",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),An=new v({props:{name:"class transformers.EncoderRepetitionPenaltyLogitsProcessor",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"},{name:"encoder_input_ids",val:": LongTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 rewards prompt tokens. Between 0.0
and 1.0 penalizes prompt tokens.`,name:"penalty"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.encoder_input_ids",description:`<strong>encoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
The encoder_input_ids that should be repeated within the decoder ids.`,name:"encoder_input_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L342"}}),Qt=new B({props:{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.example",$$slots:{default:[Ov]},$$scope:{ctx:$}}}),On=new v({props:{name:"__call__",anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EncoderRepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L386",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Kn=new v({props:{name:"class transformers.EpsilonLogitsWarper",anchor:"transformers.EpsilonLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
If set to &gt; 0, only the most tokens with probabilities <code>epsilon</code> or higher are kept for generation.`,name:"epsilon"},{anchor:"transformers.EpsilonLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.EpsilonLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L603"}}),Yt=new B({props:{anchor:"transformers.EpsilonLogitsWarper.example",$$slots:{default:[Kv]},$$scope:{ctx:$}}}),eo=new v({props:{name:"__call__",anchor:"transformers.EpsilonLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EpsilonLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EpsilonLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L656",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),to=new v({props:{name:"class transformers.EtaLogitsWarper",anchor:"transformers.EtaLogitsWarper",parameters:[{name:"epsilon",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.epsilon",description:`<strong>epsilon</strong> (<code>float</code>) &#x2014;
A float value in the range (0, 1). Hyperparameter used to calculate the dynamic cutoff value, <code>eta</code>. The
suggested values from the paper ranges from 3e-4 to 4e-3 depending on the size of the model.`,name:"epsilon"},{anchor:"transformers.EtaLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All values that are found to be below the dynamic cutoff value, <code>eta</code>, are set to this float value. This
parameter is useful when logits need to be modified for very low probability tokens that should be excluded
from generation entirely.`,name:"filter_value"},{anchor:"transformers.EtaLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Specifies the minimum number of tokens that must be kept for generation, regardless of their probabilities.
For example, if <code>min_tokens_to_keep</code> is set to 1, at least one token will always be kept for generation,
even if all tokens have probabilities below the cutoff <code>eta</code>.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L670"}}),At=new B({props:{anchor:"transformers.EtaLogitsWarper.example",$$slots:{default:[ew]},$$scope:{ctx:$}}}),so=new v({props:{name:"__call__",anchor:"transformers.EtaLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.EtaLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.EtaLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L733",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),no=new v({props:{name:"class transformers.ExponentialDecayLengthPenalty",anchor:"transformers.ExponentialDecayLengthPenalty",parameters:[{name:"exponential_decay_length_penalty",val:": Tuple"},{name:"eos_token_id",val:": Union"},{name:"input_ids_seq_length",val:": int"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>) &#x2014;
This tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where penalty
starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.ExponentialDecayLengthPenalty.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ExponentialDecayLengthPenalty.input_ids_seq_length",description:`<strong>input_ids_seq_length</strong> (<code>int</code>) &#x2014;
The length of the input sequence.`,name:"input_ids_seq_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1494"}}),Ot=new B({props:{anchor:"transformers.ExponentialDecayLengthPenalty.example",$$slots:{default:[tw]},$$scope:{ctx:$}}}),oo=new v({props:{name:"__call__",anchor:"transformers.ExponentialDecayLengthPenalty.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ExponentialDecayLengthPenalty.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ro=new v({props:{name:"class transformers.ForcedBOSTokenLogitsProcessor",anchor:"transformers.ForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1378"}}),Kt=new B({props:{anchor:"transformers.ForcedBOSTokenLogitsProcessor.example",$$slots:{default:[sw]},$$scope:{ctx:$}}}),ao=new v({props:{name:"__call__",anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedBOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1413",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),lo=new v({props:{name:"class transformers.ForcedEOSTokenLogitsProcessor",anchor:"transformers.ForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1423"}}),es=new B({props:{anchor:"transformers.ForcedEOSTokenLogitsProcessor.example",$$slots:{default:[nw]},$$scope:{ctx:$}}}),io=new v({props:{name:"__call__",anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForcedEOSTokenLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1462",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),co=new v({props:{name:"class transformers.ForceTokensLogitsProcessor",anchor:"transformers.ForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": List"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1710"}}),ts=new B({props:{anchor:"transformers.ForceTokensLogitsProcessor.example",$$slots:{default:[ow]},$$scope:{ctx:$}}}),po=new v({props:{name:"__call__",anchor:"transformers.ForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.ForceTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ForceTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1751",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),mo=new v({props:{name:"class transformers.HammingDiversityLogitsProcessor",anchor:"transformers.HammingDiversityLogitsProcessor",parameters:[{name:"diversity_penalty",val:": float"},{name:"num_beams",val:": int"},{name:"num_beam_groups",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. A higher <code>diversity_penalty</code> will enforce greater diversity among the beams. Adjusting
this value can help strike a balance between diversity and natural likelihood.`,name:"diversity_penalty"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.HammingDiversityLogitsProcessor.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1245"}}),ss=new B({props:{anchor:"transformers.HammingDiversityLogitsProcessor.example",$$slots:{default:[rw]},$$scope:{ctx:$}}}),uo=new v({props:{name:"__call__",anchor:"transformers.HammingDiversityLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"current_tokens",val:": LongTensor"},{name:"beam_group_idx",val:": int"}],parametersDescription:[{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.current_tokens",description:`<strong>current_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the tokens selected by the other
beam groups in the current generation step.`,name:"current_tokens"},{anchor:"transformers.HammingDiversityLogitsProcessor.__call__.beam_group_idx",description:`<strong>beam_group_idx</strong> (<code>int</code>) &#x2014;
The index of the beam group currently being processed.`,name:"beam_group_idx"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1332",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),go=new v({props:{name:"class transformers.InfNanRemoveLogitsProcessor",anchor:"transformers.InfNanRemoveLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1473"}}),ho=new v({props:{name:"__call__",anchor:"transformers.InfNanRemoveLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.InfNanRemoveLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1482",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),fo=new v({props:{name:"class transformers.LogitNormalization",anchor:"transformers.LogitNormalization",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1585"}}),ns=new B({props:{anchor:"transformers.LogitNormalization.example",$$slots:{default:[aw]},$$scope:{ctx:$}}}),_o=new v({props:{name:"__call__",anchor:"transformers.LogitNormalization.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitNormalization.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitNormalization.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1616",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),bo=new v({props:{name:"class transformers.LogitsProcessor",anchor:"transformers.LogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L44"}}),yo=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L47",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),To=new v({props:{name:"class transformers.LogitsProcessorList",anchor:"transformers.LogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L64"}}),Mo=new v({props:{name:"__call__",anchor:"transformers.LogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using
beam search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.LogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional kwargs that are specific to a logits processor.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L71",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),vo=new v({props:{name:"class transformers.LogitsWarper",anchor:"transformers.LogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L54"}}),wo=new v({props:{name:"__call__",anchor:"transformers.LogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.LogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L57",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),jo=new v({props:{name:"class transformers.MinLengthLogitsProcessor",anchor:"transformers.MinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.MinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L102"}}),os=new B({props:{anchor:"transformers.MinLengthLogitsProcessor.example",$$slots:{default:[lw]},$$scope:{ctx:$}}}),ko=new v({props:{name:"__call__",anchor:"transformers.MinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L151",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),$o=new v({props:{name:"class transformers.MinNewTokensLengthLogitsProcessor",anchor:"transformers.MinNewTokensLengthLogitsProcessor",parameters:[{name:"prompt_length_to_skip",val:": int"},{name:"min_new_tokens",val:": int"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.prompt_length_to_skip",description:`<strong>prompt_length_to_skip</strong> (<code>int</code>) &#x2014;
The input tokens length. Not a valid argument when used with <code>generate</code> as it will automatically assign the
input length.`,name:"prompt_length_to_skip"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>) &#x2014;
The minimum <em>new</em> tokens length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_new_tokens"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L160"}}),rs=new B({props:{anchor:"transformers.MinNewTokensLengthLogitsProcessor.example",$$slots:{default:[iw]},$$scope:{ctx:$}}}),Jo=new v({props:{name:"__call__",anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MinNewTokensLengthLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L212",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),xo=new v({props:{name:"class transformers.NoBadWordsLogitsProcessor",anchor:"transformers.NoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": Union"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated.`,name:"bad_words_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1090"}}),as=new nn({props:{$$slots:{default:[cw]},$$scope:{ctx:$}}}),ls=new B({props:{anchor:"transformers.NoBadWordsLogitsProcessor.example",$$slots:{default:[dw]},$$scope:{ctx:$}}}),Uo=new v({props:{name:"__call__",anchor:"transformers.NoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoBadWordsLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1013",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Bo=new v({props:{name:"class transformers.NoRepeatNGramLogitsProcessor",anchor:"transformers.NoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L816"}}),is=new nn({props:{$$slots:{default:[pw]},$$scope:{ctx:$}}}),cs=new B({props:{anchor:"transformers.NoRepeatNGramLogitsProcessor.example",$$slots:{default:[mw]},$$scope:{ctx:$}}}),Io=new v({props:{name:"__call__",anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.NoRepeatNGramLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L863",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Zo=new v({props:{name:"class transformers.PrefixConstrainedLogitsProcessor",anchor:"transformers.PrefixConstrainedLogitsProcessor",parameters:[{name:"prefix_allowed_tokens_fn",val:": Callable"},{name:"num_beams",val:": int"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>) &#x2014;
This function constraints the beam search to allowed tokens only at each step. This function takes 2
arguments <code>inputs_ids</code> and the batch ID <code>batch_id</code>. It has to return a list with the allowed tokens for the
next generation step conditioned on the previously generated tokens <code>inputs_ids</code> and the batch ID
<code>batch_id</code>.`,name:"prefix_allowed_tokens_fn"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1177"}}),ds=new B({props:{anchor:"transformers.PrefixConstrainedLogitsProcessor.example",$$slots:{default:[uw]},$$scope:{ctx:$}}}),zo=new v({props:{name:"__call__",anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PrefixConstrainedLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1228",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Wo=new v({props:{name:"class transformers.RepetitionPenaltyLogitsProcessor",anchor:"transformers.RepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.penalty",description:`<strong>penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. Above 1.0 penalizes previously generated
tokens. Between 0.0 and 1.0 rewards previously generated tokens.`,name:"penalty"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L288"}}),ps=new B({props:{anchor:"transformers.RepetitionPenaltyLogitsProcessor.example",$$slots:{default:[gw]},$$scope:{ctx:$}}}),Vo=new v({props:{name:"__call__",anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.RepetitionPenaltyLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L331",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Lo=new v({props:{name:"class transformers.SequenceBiasLogitsProcessor",anchor:"transformers.SequenceBiasLogitsProcessor",parameters:[{name:"sequence_bias",val:": Dict"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. If a sequence has a length of 1, its bias
will always be applied. Otherwise, the bias will only be applied if the sequence in question is about to be
completed (in the token selection step after this processor is applied).`,name:"sequence_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L942"}}),ms=new nn({props:{$$slots:{default:[hw]},$$scope:{ctx:$}}}),us=new B({props:{anchor:"transformers.SequenceBiasLogitsProcessor.example",$$slots:{default:[fw]},$$scope:{ctx:$}}}),Fo=new v({props:{name:"__call__",anchor:"transformers.SequenceBiasLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SequenceBiasLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1013",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Co=new v({props:{name:"class transformers.SuppressTokensAtBeginLogitsProcessor",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1622"}}),gs=new B({props:{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.example",$$slots:{default:[_w]},$$scope:{ctx:$}}}),Go=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensAtBeginLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1664",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Xo=new v({props:{name:"class transformers.SuppressTokensLogitsProcessor",anchor:"transformers.SuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1672"}}),hs=new B({props:{anchor:"transformers.SuppressTokensLogitsProcessor.example",$$slots:{default:[bw]},$$scope:{ctx:$}}}),Ro=new v({props:{name:"__call__",anchor:"transformers.SuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SuppressTokensLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1704",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),No=new v({props:{name:"class transformers.TemperatureLogitsWarper",anchor:"transformers.TemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
Strictly positive float value used to modulate the logits distribution. A value smaller than <code>1</code> decreases
randomness (and vice versa), with <code>0</code> being equivalent to shifting all probability mass to the most likely
token.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L222"}}),fs=new nn({props:{$$slots:{default:[yw]},$$scope:{ctx:$}}}),_s=new B({props:{anchor:"transformers.TemperatureLogitsWarper.example",$$slots:{default:[Tw]},$$scope:{ctx:$}}}),Eo=new v({props:{name:"__call__",anchor:"transformers.TemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TemperatureLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TemperatureLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L282",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),So=new v({props:{name:"class transformers.TopKLogitsWarper",anchor:"transformers.TopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L462"}}),bs=new B({props:{anchor:"transformers.TopKLogitsWarper.example",$$slots:{default:[Mw]},$$scope:{ctx:$}}}),qo=new v({props:{name:"__call__",anchor:"transformers.TopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopKLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopKLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L506",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Ho=new v({props:{name:"class transformers.TopPLogitsWarper",anchor:"transformers.TopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L397"}}),ys=new B({props:{anchor:"transformers.TopPLogitsWarper.example",$$slots:{default:[vw]},$$scope:{ctx:$}}}),Po=new v({props:{name:"__call__",anchor:"transformers.TopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TopPLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TopPLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L446",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Do=new v({props:{name:"class transformers.TypicalLogitsWarper",anchor:"transformers.TypicalLogitsWarper",parameters:[{name:"mass",val:": float = 0.9"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.mass",description:`<strong>mass</strong> (<code>float</code>, <em>optional</em>, defaults to 0.9) &#x2014;
Value of typical_p between 0 and 1 inclusive, defaults to 0.9.`,name:"mass"},{anchor:"transformers.TypicalLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TypicalLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L515"}}),Ts=new B({props:{anchor:"transformers.TypicalLogitsWarper.example",$$slots:{default:[ww]},$$scope:{ctx:$}}}),Qo=new v({props:{name:"__call__",anchor:"transformers.TypicalLogitsWarper.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.TypicalLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TypicalLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L579",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Yo=new v({props:{name:"class transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor",parameters:[{name:"guidance_scale",val:": float"},{name:"model",val:""},{name:"unconditional_ids",val:": Optional = None"},{name:"unconditional_attention_mask",val:": Optional = None"},{name:"use_cache",val:": Optional = True"}],parametersDescription:[{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale != 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality. A value smaller than 1 has the opposite effect, while
making the negative prompt provided with negative_prompt_ids (if any) act as a positive prompt.`,name:"guidance_scale"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.model",description:`<strong>model</strong> (<code>PreTrainedModel</code>) &#x2014;
The model computing the unconditional scores. Supposedly the same as the one computing the conditional
scores. Both models must use the same tokenizer.`,name:"model"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_ids",description:`<strong>unconditional_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of input sequence tokens in the vocabulary for the unconditional branch. If unset, will default to
the last token of the prompt.`,name:"unconditional_ids"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.unconditional_attention_mask",description:`<strong>unconditional_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention mask for unconditional_ids.`,name:"unconditional_attention_mask"},{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to cache key/values during the negative prompt forward pass.`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2055"}}),Ms=new B({props:{anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.example",$$slots:{default:[jw]},$$scope:{ctx:$}}}),Ao=new v({props:{name:"__call__",anchor:"transformers.UnbatchedClassifierFreeGuidanceLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L2161"}}),Oo=new v({props:{name:"class transformers.WhisperTimeStampLogitsProcessor",anchor:"transformers.WhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"begin_index",val:": Optional = None"},{name:"_detect_timestamp_from_logprob",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.begin_index",description:"<strong>begin_index</strong> (<code>Optional</code>, <em>optional</em>) &#x2014; Token index of the first token that is generated by the model.",name:"begin_index"},{anchor:"transformers.WhisperTimeStampLogitsProcessor._detect_timestamp_from_logprob",description:"<strong>_detect_timestamp_from_logprob</strong> (<code>bool</code>, <em>optional</em>) &#x2014; Whether timestamps can be predicted from logprobs over all timestamps.",name:"_detect_timestamp_from_logprob"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1761"}}),vs=new B({props:{anchor:"transformers.WhisperTimeStampLogitsProcessor.example",$$slots:{default:[kw]},$$scope:{ctx:$}}}),Ko=new v({props:{name:"__call__",anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"}],parametersDescription:[{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. <a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.WhisperTimeStampLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/logits_process.py#L1843",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),er=new Y({props:{title:"TensorFlow",local:"transformers.TFForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),tr=new v({props:{name:"class transformers.TFForcedBOSTokenLogitsProcessor",anchor:"transformers.TFForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L448"}}),sr=new v({props:{name:"__call__",anchor:"transformers.TFForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L462"}}),nr=new v({props:{name:"class transformers.TFForcedEOSTokenLogitsProcessor",anchor:"transformers.TFForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.TFForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L478"}}),or=new v({props:{name:"__call__",anchor:"transformers.TFForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L495"}}),rr=new v({props:{name:"class transformers.TFForceTokensLogitsProcessor",anchor:"transformers.TFForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:": List"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L551"}}),ar=new v({props:{name:"__call__",anchor:"transformers.TFForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L567"}}),lr=new v({props:{name:"class transformers.TFLogitsProcessor",anchor:"transformers.TFLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L53"}}),ir=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ja/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessor.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L56",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),cr=new v({props:{name:"class transformers.TFLogitsProcessorList",anchor:"transformers.TFLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L75"}}),dr=new v({props:{name:"__call__",anchor:"transformers.TFLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ja/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsProcessorList.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L82",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),pr=new v({props:{name:"class transformers.TFLogitsWarper",anchor:"transformers.TFLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L64"}}),mr=new v({props:{name:"__call__",anchor:"transformers.TFLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],parametersDescription:[{anchor:"transformers.TFLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ja/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.TFLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search.`,name:"scores"},{anchor:"transformers.TFLogitsWarper.__call__.cur_len",description:`<strong>cur_len</strong> (<code>int</code>) &#x2014;
The current length of valid input sequence tokens. In the TF implementation, the input_ids&#x2019; sequence length
is the maximum length generate can produce, and we need to know which of its tokens are valid.`,name:"cur_len"},{anchor:"transformers.TFLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L67",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>tf.Tensor</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),ur=new v({props:{name:"class transformers.TFMinLengthLogitsProcessor",anchor:"transformers.TFMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.TFMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L202"}}),gr=new v({props:{name:"__call__",anchor:"transformers.TFMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L228"}}),hr=new v({props:{name:"class transformers.TFNoBadWordsLogitsProcessor",anchor:"transformers.TFNoBadWordsLogitsProcessor",parameters:[{name:"bad_words_ids",val:": List"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoBadWordsLogitsProcessor.bad_words_ids",description:`<strong>bad_words_ids</strong> (<code>List[List[int]]</code>) &#x2014;
List of list of token ids that are not allowed to be generated. In order to get the tokens of the words
that should not appear in the generated text, make sure to set <code>add_prefix_space=True</code> when initializing
the tokenizer, and use <code>tokenizer(bad_words, add_special_tokens=False).input_ids</code>. The <code>add_prefix_space</code>
argument is only supported for some slow tokenizers, as fast tokenizers&#x2019; prefixing behaviours come from
<code>pre tokenizers</code>. Read more <a href="https://huggingface.co/docs/tokenizers/api/pre-tokenizers" rel="nofollow">here</a>.`,name:"bad_words_ids"},{anchor:"transformers.TFNoBadWordsLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L288"}}),fr=new v({props:{name:"__call__",anchor:"transformers.TFNoBadWordsLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L367"}}),_r=new v({props:{name:"class transformers.TFNoRepeatNGramLogitsProcessor",anchor:"transformers.TFNoRepeatNGramLogitsProcessor",parameters:[{name:"ngram_size",val:": int"}],parametersDescription:[{anchor:"transformers.TFNoRepeatNGramLogitsProcessor.ngram_size",description:`<strong>ngram_size</strong> (<code>int</code>) &#x2014;
All ngrams of size <code>ngram_size</code> can only occur once.`,name:"ngram_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L388"}}),br=new v({props:{name:"__call__",anchor:"transformers.TFNoRepeatNGramLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L427"}}),yr=new v({props:{name:"class transformers.TFRepetitionPenaltyLogitsProcessor",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor",parameters:[{name:"penalty",val:": float"}],parametersDescription:[{anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L238"}}),Tr=new v({props:{name:"__call__",anchor:"transformers.TFRepetitionPenaltyLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L280"}}),Mr=new v({props:{name:"class transformers.TFSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L511"}}),vr=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L522"}}),wr=new v({props:{name:"class transformers.TFSuppressTokensLogitsProcessor",anchor:"transformers.TFSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L535"}}),jr=new v({props:{name:"__call__",anchor:"transformers.TFSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L542"}}),kr=new v({props:{name:"class transformers.TFTemperatureLogitsWarper",anchor:"transformers.TFTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.TFTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L98"}}),$r=new v({props:{name:"__call__",anchor:"transformers.TFTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L113"}}),Jr=new v({props:{name:"class transformers.TFTopKLogitsWarper",anchor:"transformers.TFTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.TFTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L118"}}),xr=new v({props:{name:"__call__",anchor:"transformers.TFTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L138"}}),Ur=new v({props:{name:"class transformers.TFTopPLogitsWarper",anchor:"transformers.TFTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.TFTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.TFTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.TFTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L146"}}),Br=new v({props:{name:"__call__",anchor:"transformers.TFTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Tensor"},{name:"scores",val:": Tensor"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_logits_process.py#L170"}}),Ir=new Y({props:{title:"FLAX",local:"transformers.FlaxForcedBOSTokenLogitsProcessor",headingTag:"h3"}}),Zr=new v({props:{name:"class transformers.FlaxForcedBOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor",parameters:[{name:"bos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the first generated token.`,name:"bos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L194"}}),zr=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedBOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L206"}}),Wr=new v({props:{name:"class transformers.FlaxForcedEOSTokenLogitsProcessor",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor",parameters:[{name:"max_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L216"}}),Vr=new v({props:{name:"__call__",anchor:"transformers.FlaxForcedEOSTokenLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L231"}}),Lr=new v({props:{name:"class transformers.FlaxForceTokensLogitsProcessor",anchor:"transformers.FlaxForceTokensLogitsProcessor",parameters:[{name:"force_token_map",val:""}],parametersDescription:[{anchor:"transformers.FlaxForceTokensLogitsProcessor.force_token_map",description:`<strong>force_token_map</strong> (<code>list</code>) &#x2014;
Map giving token ids and indices where they will be forced to be sampled.`,name:"force_token_map"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L315"}}),Fr=new v({props:{name:"__call__",anchor:"transformers.FlaxForceTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L337"}}),Cr=new v({props:{name:"class transformers.FlaxLogitsProcessor",anchor:"transformers.FlaxLogitsProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L50"}}),Gr=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessor.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ja/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessor.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessor.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L53",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Xr=new v({props:{name:"class transformers.FlaxLogitsProcessorList",anchor:"transformers.FlaxLogitsProcessorList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L72"}}),Rr=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsProcessorList.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxLogitsProcessorList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ja/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsProcessorList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L79",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Nr=new v({props:{name:"class transformers.FlaxLogitsWarper",anchor:"transformers.FlaxLogitsWarper",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L61"}}),Er=new v({props:{name:"__call__",anchor:"transformers.FlaxLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"}],parametersDescription:[{anchor:"transformers.FlaxLogitsWarper.__call__.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ja/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FlaxLogitsWarper.__call__.scores",description:`<strong>scores</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be logits for each vocabulary when not using beam
search or log softmax for each vocabulary token when using beam search`,name:"scores"},{anchor:"transformers.FlaxLogitsWarper.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional logits processor specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L64",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processed prediction scores.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>jnp.ndarray</code> of shape <code>(batch_size, config.vocab_size)</code></p>
`}}),Sr=new v({props:{name:"class transformers.FlaxMinLengthLogitsProcessor",anchor:"transformers.FlaxMinLengthLogitsProcessor",parameters:[{name:"min_length",val:": int"},{name:"eos_token_id",val:": int"}],parametersDescription:[{anchor:"transformers.FlaxMinLengthLogitsProcessor.min_length",description:`<strong>min_length</strong> (<code>int</code>) &#x2014;
The minimum length below which the score of <code>eos_token_id</code> is set to <code>-float(&quot;Inf&quot;)</code>.`,name:"min_length"},{anchor:"transformers.FlaxMinLengthLogitsProcessor.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>) &#x2014;
The id of the <em>end-of-sequence</em> token.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L241"}}),qr=new v({props:{name:"__call__",anchor:"transformers.FlaxMinLengthLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L262"}}),Hr=new v({props:{name:"class transformers.FlaxSuppressTokensAtBeginLogitsProcessor",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor",parameters:[{name:"begin_suppress_tokens",val:""},{name:"begin_index",val:""}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong> (<code>List[int]</code>) &#x2014;
Tokens to not sample.`,name:"begin_suppress_tokens"},{anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.begin_index",description:`<strong>begin_index</strong> (<code>int</code>) &#x2014;
Index where the tokens are suppressed.`,name:"begin_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L271"}}),Pr=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensAtBeginLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L288"}}),Dr=new v({props:{name:"class transformers.FlaxSuppressTokensLogitsProcessor",anchor:"transformers.FlaxSuppressTokensLogitsProcessor",parameters:[{name:"suppress_tokens",val:": list"}],parametersDescription:[{anchor:"transformers.FlaxSuppressTokensLogitsProcessor.suppress_tokens",description:`<strong>suppress_tokens</strong> (<code>list</code>) &#x2014;
Tokens to not sample.`,name:"suppress_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L296"}}),Qr=new v({props:{name:"__call__",anchor:"transformers.FlaxSuppressTokensLogitsProcessor.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L309"}}),Yr=new v({props:{name:"class transformers.FlaxTemperatureLogitsWarper",anchor:"transformers.FlaxTemperatureLogitsWarper",parameters:[{name:"temperature",val:": float"}],parametersDescription:[{anchor:"transformers.FlaxTemperatureLogitsWarper.temperature",description:`<strong>temperature</strong> (<code>float</code>) &#x2014;
The value used to module the logits distribution.`,name:"temperature"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L95"}}),Ar=new v({props:{name:"__call__",anchor:"transformers.FlaxTemperatureLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L110"}}),Or=new v({props:{name:"class transformers.FlaxTopKLogitsWarper",anchor:"transformers.FlaxTopKLogitsWarper",parameters:[{name:"top_k",val:": int"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopKLogitsWarper.top_k",description:`<strong>top_k</strong> (<code>int</code>) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.FlaxTopKLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopKLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L159"}}),Kr=new v({props:{name:"__call__",anchor:"transformers.FlaxTopKLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L179"}}),ea=new v({props:{name:"class transformers.FlaxTopPLogitsWarper",anchor:"transformers.FlaxTopPLogitsWarper",parameters:[{name:"top_p",val:": float"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.FlaxTopPLogitsWarper.top_p",description:`<strong>top_p</strong> (<code>float</code>) &#x2014;
If set to &lt; 1, only the smallest set of most probable tokens with probabilities that add up to <code>top_p</code> or
higher are kept for generation.`,name:"top_p"},{anchor:"transformers.FlaxTopPLogitsWarper.filter_value",description:`<strong>filter_value</strong> (<code>float</code>, <em>optional</em>, defaults to -inf) &#x2014;
All filtered values will be set to this float value.`,name:"filter_value"},{anchor:"transformers.FlaxTopPLogitsWarper.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimum number of tokens that cannot be filtered.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L115"}}),ta=new v({props:{name:"__call__",anchor:"transformers.FlaxTopPLogitsWarper.__call__",parameters:[{name:"input_ids",val:": Array"},{name:"scores",val:": Array"},{name:"cur_len",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L139"}}),sa=new v({props:{name:"class transformers.FlaxWhisperTimeStampLogitsProcessor",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor",parameters:[{name:"generate_config",val:""},{name:"model_config",val:""},{name:"decoder_input_length",val:""}],parametersDescription:[{anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.generate_config",description:`<strong>generate_config</strong> (<code>GenerateConfig</code>) &#x2014;
The generate config used to generate the output. The following parameters are required:
eos_token_id (<code>int</code>, <em>optional</em>, defaults to 50257):
The id of the <em>end-of-sequence</em> token.
no_timestamps_token_id (<code>int</code>, <em>optional</em>, defaults to 50363):
The id of the <code>&quot;&lt;|notimestamps|&gt;&quot;</code> token.
max_initial_timestamp_index (<code>int</code>, <em>optional</em>, defaults to 1):
Used to set the maximum value of the initial timestamp. This is used to prevent the model from
predicting timestamps that are too far in the future.`,name:"generate_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L363"}}),na=new v({props:{name:"__call__",anchor:"transformers.FlaxWhisperTimeStampLogitsProcessor.__call__",parameters:[{name:"input_ids",val:""},{name:"scores",val:""},{name:"cur_len",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/flax_logits_process.py#L397"}}),oa=new Y({props:{title:"StoppingCriteria",local:"transformers.StoppingCriteria",headingTag:"h2"}}),aa=new v({props:{name:"class transformers.StoppingCriteria",anchor:"transformers.StoppingCriteria",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L37"}}),la=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L44",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),ia=new v({props:{name:"class transformers.StoppingCriteriaList",anchor:"transformers.StoppingCriteriaList",parameters:[{name:"iterable",val:" = ()"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L129"}}),ca=new v({props:{name:"__call__",anchor:"transformers.StoppingCriteriaList.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.StoppingCriteriaList.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.StoppingCriteriaList.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.StoppingCriteriaList.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L130",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),da=new v({props:{name:"class transformers.MaxLengthCriteria",anchor:"transformers.MaxLengthCriteria",parameters:[{name:"max_length",val:": int"},{name:"max_position_embeddings",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.max_length",description:`<strong>max_length</strong> (<code>int</code>) &#x2014;
The maximum length that the output sequence can have in number of tokens.`,name:"max_length"},{anchor:"transformers.MaxLengthCriteria.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum model length, as defined by the model&#x2019;s <code>config.max_position_embeddings</code> attribute.`,name:"max_position_embeddings"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L49"}}),pa=new v({props:{name:"__call__",anchor:"transformers.MaxLengthCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxLengthCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxLengthCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxLengthCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L65",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),ma=new v({props:{name:"class transformers.MaxTimeCriteria",anchor:"transformers.MaxTimeCriteria",parameters:[{name:"max_time",val:": float"},{name:"initial_timestamp",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.max_time",description:`<strong>max_time</strong> (<code>float</code>) &#x2014;
The maximum allowed time in seconds for the generation.`,name:"max_time"},{anchor:"transformers.MaxTimeCriteria.initial_time",description:`<strong>initial_time</strong> (<code>float</code>, <em>optional</em>, defaults to <code>time.time()</code>) &#x2014;
The start of the generation allowed time.`,name:"initial_time"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L107"}}),ua=new v({props:{name:"__call__",anchor:"transformers.MaxTimeCriteria.__call__",parameters:[{name:"input_ids",val:": LongTensor"},{name:"scores",val:": FloatTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MaxTimeCriteria.__call__.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/ja/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MaxTimeCriteria.__call__.scores",description:`<strong>scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.vocab_size)</code>) &#x2014;
Prediction scores of a language modeling head. These can be scores for each vocabulary token before SoftMax
or scores for each vocabulary token after SoftMax. If this stopping criteria depends on the <code>scores</code> input,
make sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>.`,name:"scores"},{anchor:"transformers.MaxTimeCriteria.__call__.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional stopping criteria specific kwargs.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/stopping_criteria.py#L124",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>bool</code>. <code>False</code> indicates we should continue, <code>True</code> indicates we should stop.</p>
`}}),ga=new Y({props:{title:"Constraints",local:"transformers.Constraint",headingTag:"h2"}}),fa=new v({props:{name:"class transformers.Constraint",anchor:"transformers.Constraint",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L5"}}),Js=new B({props:{anchor:"transformers.Constraint.example",$$slots:{default:[$w]},$$scope:{ctx:$}}}),_a=new v({props:{name:"advance",anchor:"transformers.Constraint.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L48",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Must be a tensor of a list of indexable tokens, not some integer.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>token_ids(<code>torch.tensor</code>)</p>
`}}),ba=new v({props:{name:"copy",anchor:"transformers.Constraint.copy",parameters:[{name:"stateful",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L113",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The same constraint as the one being called from.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>constraint(<code>Constraint</code>)</p>
`}}),ya=new v({props:{name:"does_advance",anchor:"transformers.Constraint.does_advance",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L60"}}),Ta=new v({props:{name:"remaining",anchor:"transformers.Constraint.remaining",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L104"}}),Ma=new v({props:{name:"reset",anchor:"transformers.Constraint.reset",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L94"}}),va=new v({props:{name:"test",anchor:"transformers.Constraint.test",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L24"}}),wa=new v({props:{name:"update",anchor:"transformers.Constraint.update",parameters:[{name:"token_id",val:": int"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L69",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Whether this constraint has become one step closer to being fulfuilled.
completed(<code>bool</code>):
Whether this constraint has been completely fulfilled by this token being generated.
reset (<code>bool</code>):
Whether this constraint has reset its progress by this token being generated.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>stepped(<code>bool</code>)</p>
`}}),ja=new v({props:{name:"class transformers.PhrasalConstraint",anchor:"transformers.PhrasalConstraint",parameters:[{name:"token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.PhrasalConstraint.token_ids",description:`<strong>token_ids</strong> (<code>List[int]</code>) &#x2014;
The id of the token that must be generated by the output.`,name:"token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L129"}}),ka=new v({props:{name:"class transformers.DisjunctiveConstraint",anchor:"transformers.DisjunctiveConstraint",parameters:[{name:"nested_token_ids",val:": List"}],parametersDescription:[{anchor:"transformers.DisjunctiveConstraint.nested_token_ids",description:`<strong>nested_token_ids</strong> (<code>List[List[int]]</code>) &#x2014;
A list of words, where each word is a list of ids. This constraint is fulfilled by generating just one from
the list of words.`,name:"nested_token_ids"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L261"}}),$a=new v({props:{name:"class transformers.ConstraintListState",anchor:"transformers.ConstraintListState",parameters:[{name:"constraints",val:": List"}],parametersDescription:[{anchor:"transformers.ConstraintListState.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.Constraint">Constraint</a> objects that must be fulfilled by the beam scorer.`,name:"constraints"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L351"}}),Ja=new v({props:{name:"advance",anchor:"transformers.ConstraintListState.advance",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L383"}}),xa=new v({props:{name:"reset",anchor:"transformers.ConstraintListState.reset",parameters:[{name:"token_ids",val:": Optional"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_constraints.py#L418"}}),Ua=new Y({props:{title:"BeamSearch",local:"transformers.BeamScorer",headingTag:"h2"}}),Ba=new v({props:{name:"class transformers.BeamScorer",anchor:"transformers.BeamScorer",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L91"}}),Ia=new v({props:{name:"process",anchor:"transformers.BeamScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/ja/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.BeamScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.BeamScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.BeamScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.BeamScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.BeamScorer.process.group_index",description:`<strong>group_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the group of beams. Used with <a href="/docs/transformers/main/ja/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>.`,name:"group_index"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L97",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of all
non-finished beams.</li>
<li><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be added
to the non-finished beam_hypotheses.</li>
<li><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),Za=new v({props:{name:"finalize",anchor:"transformers.BeamScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BeamScorer.finalize.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/ja/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BeamScorer.finalize.final_beam_scores",description:`<strong>final_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The final scores of all non-finished beams.`,name:"final_beam_scores"},{anchor:"transformers.BeamScorer.finalize.final_beam_tokens",description:`<strong>final_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The last tokens to be added to the non-finished beam_hypotheses.`,name:"final_beam_tokens"},{anchor:"transformers.BeamScorer.finalize.final_beam_indices",description:`<strong>final_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) &#x2014;
The beam indices indicating to which beam the <code>final_beam_tokens</code> shall be added.`,name:"final_beam_indices"},{anchor:"transformers.BeamScorer.finalize.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.BeamScorer.finalize.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L109",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The generated sequences.
The second dimension (sequence_length) is either equal to <code>max_length</code> or shorter if all batches finished early
due to the <code>eos_token_id</code>.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.LongTensor</code> of shape <code>(batch_size * num_return_sequences, sequence_length)</code></p>
`}}),za=new v({props:{name:"class transformers.BeamSearchScorer",anchor:"transformers.BeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.BeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.BeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.BeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.BeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.BeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.BeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.BeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.BeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L123"}}),Wa=new v({props:{name:"process",anchor:"transformers.BeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"group_index",val:": Optional = 0"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L215"}}),Va=new v({props:{name:"finalize",anchor:"transformers.BeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L318"}}),La=new v({props:{name:"class transformers.ConstrainedBeamSearchScorer",anchor:"transformers.ConstrainedBeamSearchScorer",parameters:[{name:"batch_size",val:": int"},{name:"num_beams",val:": int"},{name:"constraints",val:": List"},{name:"device",val:": device"},{name:"length_penalty",val:": Optional = 1.0"},{name:"do_early_stopping",val:": Union = False"},{name:"num_beam_hyps_to_keep",val:": Optional = 1"},{name:"num_beam_groups",val:": Optional = 1"},{name:"max_length",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.batch_size",description:`<strong>batch_size</strong> (<code>int</code>) &#x2014;
Batch Size of <code>input_ids</code> for which standard beam search decoding is run in parallel.`,name:"batch_size"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beams",description:`<strong>num_beams</strong> (<code>int</code>) &#x2014;
Number of beams for beam search.`,name:"num_beams"},{anchor:"transformers.ConstrainedBeamSearchScorer.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>) &#x2014;
A list of positive constraints represented as <code>Constraint</code> objects that must be fulfilled in the generation
output. For more information, the documentation of <a href="/docs/transformers/main/ja/internal/generation_utils#transformers.Constraint">Constraint</a> should be read.`,name:"constraints"},{anchor:"transformers.ConstrainedBeamSearchScorer.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
Defines the device type (<em>e.g.</em>, <code>&quot;cpu&quot;</code> or <code>&quot;cuda&quot;</code>) on which this instance of <code>BeamSearchScorer</code> will be
allocated.`,name:"device"},{anchor:"transformers.ConstrainedBeamSearchScorer.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.ConstrainedBeamSearchScorer.do_early_stopping",description:`<strong>do_early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"do_early_stopping"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_hyps_to_keep",description:`<strong>num_beam_hyps_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of beam hypotheses that shall be returned upon calling
<a href="/docs/transformers/main/ja/internal/generation_utils#transformers.BeamSearchScorer.finalize">finalize()</a>.`,name:"num_beam_hyps_to_keep"},{anchor:"transformers.ConstrainedBeamSearchScorer.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
See <a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.ConstrainedBeamSearchScorer.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum length of the sequence to be generated.`,name:"max_length"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L415"}}),Fa=new v({props:{name:"process",anchor:"transformers.ConstrainedBeamSearchScorer.process",parameters:[{name:"input_ids",val:": LongTensor"},{name:"next_scores",val:": FloatTensor"},{name:"next_tokens",val:": LongTensor"},{name:"next_indices",val:": LongTensor"},{name:"scores_for_all_vocab",val:": FloatTensor"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],parametersDescription:[{anchor:"transformers.ConstrainedBeamSearchScorer.process.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using any class inheriting from <a href="/docs/transformers/main/ja/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>. See
<a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and <a href="/docs/transformers/main/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_scores",description:`<strong>next_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Current scores of the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_scores"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_tokens",description:`<strong>next_tokens</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
<code>input_ids</code> of the tokens corresponding to the top <code>2 * num_beams</code> non-finished beam hypotheses.`,name:"next_tokens"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.next_indices",description:`<strong>next_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2 * num_beams)</code>) &#x2014;
Beam indices indicating to which beam hypothesis the <code>next_tokens</code> correspond.`,name:"next_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.scores_for_all_vocab",description:`<strong>scores_for_all_vocab</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams, sequence_length)</code>) &#x2014;
The scores of all tokens in the vocabulary for each of the beam hypotheses.`,name:"scores_for_all_vocab"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices indicating to which beam hypothesis each token correspond.`,name:"beam_indices"},{anchor:"transformers.ConstrainedBeamSearchScorer.process.decoder_prompt_len",description:`<strong>decoder_prompt_len</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The length of prompt that is included in the input to decoder.`,name:"decoder_prompt_len"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L509",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A dictionary composed of the fields as defined above:</p>
<ul>
<li>
<p><strong>next_beam_scores</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Updated scores of
all
non-finished beams.</p>
</li>
<li>
<p><strong>next_beam_tokens</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Next tokens to be
added
to the non-finished beam_hypotheses.</p>
</li>
<li>
<p><strong>next_beam_indices</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size * num_beams)</code>) — Beam indices
indicating to which beam the next tokens shall be added.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>UserDict</code></p>
`}}),Ca=new v({props:{name:"finalize",anchor:"transformers.ConstrainedBeamSearchScorer.finalize",parameters:[{name:"input_ids",val:": LongTensor"},{name:"final_beam_scores",val:": FloatTensor"},{name:"final_beam_tokens",val:": LongTensor"},{name:"final_beam_indices",val:": LongTensor"},{name:"max_length",val:": int"},{name:"pad_token_id",val:": Optional = None"},{name:"eos_token_id",val:": Union = None"},{name:"beam_indices",val:": Optional = None"},{name:"decoder_prompt_len",val:": Optional = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/beam_search.py#L807"}}),Ga=new Y({props:{title:"Utilities",local:"transformers.top_k_top_p_filtering",headingTag:"h2"}}),Xa=new v({props:{name:"transformers.top_k_top_p_filtering",anchor:"transformers.top_k_top_p_filtering",parameters:[{name:"logits",val:": FloatTensor"},{name:"top_k",val:": int = 0"},{name:"top_p",val:": float = 1.0"},{name:"filter_value",val:": float = -inf"},{name:"min_tokens_to_keep",val:": int = 1"}],parametersDescription:[{anchor:"transformers.top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L4619"}}),Ra=new v({props:{name:"transformers.tf_top_k_top_p_filtering",anchor:"transformers.tf_top_k_top_p_filtering",parameters:[{name:"logits",val:""},{name:"top_k",val:" = 0"},{name:"top_p",val:" = 1.0"},{name:"filter_value",val:" = -inf"},{name:"min_tokens_to_keep",val:" = 1"}],parametersDescription:[{anchor:"transformers.tf_top_k_top_p_filtering.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If &gt; 0, only keep the top k tokens with highest probability (top-k filtering)`,name:"top_k"},{anchor:"transformers.tf_top_k_top_p_filtering.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If &lt; 1.0, only keep the top tokens with cumulative probability &gt;= top_p (nucleus filtering). Nucleus
filtering is described in Holtzman et al. (<a href="http://arxiv.org/abs/1904.09751" rel="nofollow">http://arxiv.org/abs/1904.09751</a>)`,name:"top_p"},{anchor:"transformers.tf_top_k_top_p_filtering.min_tokens_to_keep",description:`<strong>min_tokens_to_keep</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Minimumber of tokens we keep per batch example in the output.`,name:"min_tokens_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/tf_utils.py#L3092"}}),Na=new Y({props:{title:"Streamers",local:"transformers.TextStreamer",headingTag:"h2"}}),Ea=new v({props:{name:"class transformers.TextStreamer",anchor:"transformers.TextStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L38"}}),Vs=new nn({props:{warning:!0,$$slots:{default:[Jw]},$$scope:{ctx:$}}}),Ls=new B({props:{anchor:"transformers.TextStreamer.example",$$slots:{default:[xw]},$$scope:{ctx:$}}}),Sa=new v({props:{name:"end",anchor:"transformers.TextStreamer.end",parameters:[],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L116"}}),qa=new v({props:{name:"on_finalized_text",anchor:"transformers.TextStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L130"}}),Ha=new v({props:{name:"put",anchor:"transformers.TextStreamer.put",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L82"}}),Pa=new v({props:{name:"class transformers.TextIteratorStreamer",anchor:"transformers.TextIteratorStreamer",parameters:[{name:"tokenizer",val:": AutoTokenizer"},{name:"skip_prompt",val:": bool = False"},{name:"timeout",val:": Optional = None"},{name:"**decode_kwargs",val:""}],parametersDescription:[{anchor:"transformers.TextIteratorStreamer.tokenizer",description:`<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;
The tokenized used to decode the tokens.`,name:"tokenizer"},{anchor:"transformers.TextIteratorStreamer.skip_prompt",description:`<strong>skip_prompt</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to skip the prompt to <code>.generate()</code> or not. Useful e.g. for chatbots.`,name:"skip_prompt"},{anchor:"transformers.TextIteratorStreamer.timeout",description:`<strong>timeout</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The timeout for the text queue. If <code>None</code>, the queue will block indefinitely. Useful to handle exceptions
in <code>.generate()</code>, when it is called in a separate thread.`,name:"timeout"},{anchor:"transformers.TextIteratorStreamer.decode_kwargs",description:`<strong>decode_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments to pass to the tokenizer&#x2019;s <code>decode</code> method.`,name:"decode_kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L159"}}),Xs=new nn({props:{warning:!0,$$slots:{default:[Uw]},$$scope:{ctx:$}}}),Rs=new B({props:{anchor:"transformers.TextIteratorStreamer.example",$$slots:{default:[Bw]},$$scope:{ctx:$}}}),Da=new v({props:{name:"on_finalized_text",anchor:"transformers.TextIteratorStreamer.on_finalized_text",parameters:[{name:"text",val:": str"},{name:"stream_end",val:": bool = False"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/streamers.py#L213"}}),{c(){c=a("meta"),k=o(),b=a("p"),_=o(),p(w.$$.fragment),n=o(),j=a("p"),j.innerHTML=ty,Cp=o(),on=a("p"),on.textContent=sy,Gp=o(),p(rn.$$.fragment),Xp=o(),an=a("p"),an.innerHTML=ny,Rp=o(),ln=a("p"),ln.textContent=oy,Np=o(),p(cn.$$.fragment),Ep=o(),dn=a("p"),dn.innerHTML=ry,Sp=o(),pn=a("ul"),pn.innerHTML=ay,qp=o(),mn=a("p"),mn.innerHTML=ly,Hp=o(),un=a("p"),un.innerHTML=iy,Pp=o(),gn=a("p"),gn.innerHTML=cy,Dp=o(),p(hn.$$.fragment),Qp=o(),fn=a("p"),fn.innerHTML=dy,Yp=o(),_n=a("p"),_n.innerHTML=py,Ap=o(),bn=a("p"),bn.textContent=my,Op=o(),p(yn.$$.fragment),Kp=o(),vt=a("div"),p(Tn.$$.fragment),fg=o(),ml=a("p"),ml.textContent=uy,em=o(),wt=a("div"),p(Mn.$$.fragment),_g=o(),ul=a("p"),ul.textContent=gy,tm=o(),jt=a("div"),p(vn.$$.fragment),bg=o(),gl=a("p"),gl.textContent=hy,sm=o(),kt=a("div"),p(wn.$$.fragment),yg=o(),hl=a("p"),hl.textContent=fy,nm=o(),p(jn.$$.fragment),om=o(),$t=a("div"),p(kn.$$.fragment),Tg=o(),fl=a("p"),fl.textContent=_y,rm=o(),Jt=a("div"),p($n.$$.fragment),Mg=o(),_l=a("p"),_l.textContent=by,am=o(),xt=a("div"),p(Jn.$$.fragment),vg=o(),bl=a("p"),bl.textContent=yy,lm=o(),Ut=a("div"),p(xn.$$.fragment),wg=o(),yl=a("p"),yl.textContent=Ty,im=o(),Bt=a("div"),p(Un.$$.fragment),jg=o(),Tl=a("p"),Tl.textContent=My,cm=o(),It=a("div"),p(Bn.$$.fragment),kg=o(),Ml=a("p"),Ml.textContent=vy,dm=o(),Zt=a("div"),p(In.$$.fragment),$g=o(),vl=a("p"),vl.textContent=wy,pm=o(),zt=a("div"),p(Zn.$$.fragment),Jg=o(),wl=a("p"),wl.textContent=jy,mm=o(),Wt=a("div"),p(zn.$$.fragment),xg=o(),jl=a("p"),jl.textContent=ky,um=o(),Vt=a("div"),p(Wn.$$.fragment),Ug=o(),kl=a("p"),kl.textContent=$y,gm=o(),p(Vn.$$.fragment),hm=o(),ve=a("div"),p(Ln.$$.fragment),Bg=o(),$l=a("p"),$l.textContent=Jy,Ig=o(),Nt=a("div"),p(Fn.$$.fragment),Zg=o(),Jl=a("p"),Jl.textContent=xy,fm=o(),we=a("div"),p(Cn.$$.fragment),zg=o(),xl=a("p"),xl.textContent=Uy,Wg=o(),Et=a("div"),p(Gn.$$.fragment),Vg=o(),Ul=a("p"),Ul.textContent=By,_m=o(),je=a("div"),p(Xn.$$.fragment),Lg=o(),Bl=a("p"),Bl.textContent=Iy,Fg=o(),St=a("div"),p(Rn.$$.fragment),Cg=o(),Il=a("p"),Il.textContent=Zy,bm=o(),p(Nn.$$.fragment),ym=o(),En=a("p"),En.innerHTML=zy,Tm=o(),p(Sn.$$.fragment),Mm=o(),A=a("div"),p(qn.$$.fragment),Gg=o(),Zl=a("p"),Zl.innerHTML=Wy,Xg=o(),p(qt.$$.fragment),Rg=o(),zl=a("div"),p(Hn.$$.fragment),vm=o(),z=a("div"),p(Pn.$$.fragment),Ng=o(),Wl=a("p"),Wl.innerHTML=Vy,Eg=o(),Vl=a("p"),Vl.innerHTML=Ly,Sg=o(),p(Ht.$$.fragment),qg=o(),p(Pt.$$.fragment),Hg=o(),Ll=a("div"),p(Dn.$$.fragment),wm=o(),F=a("div"),p(Qn.$$.fragment),Pg=o(),Fl=a("p"),Fl.innerHTML=Fy,Dg=o(),Cl=a("p"),Cl.textContent=Cy,Qg=o(),p(Dt.$$.fragment),Yg=o(),Gl=a("div"),p(Yn.$$.fragment),jm=o(),C=a("div"),p(An.$$.fragment),Ag=o(),Xl=a("p"),Xl.innerHTML=Gy,Og=o(),Rl=a("p"),Rl.textContent=Xy,Kg=o(),p(Qt.$$.fragment),eh=o(),Nl=a("div"),p(On.$$.fragment),km=o(),O=a("div"),p(Kn.$$.fragment),th=o(),El=a("p"),El.innerHTML=Ry,sh=o(),p(Yt.$$.fragment),nh=o(),Sl=a("div"),p(eo.$$.fragment),$m=o(),K=a("div"),p(to.$$.fragment),oh=o(),ql=a("p"),ql.innerHTML=Ny,rh=o(),p(At.$$.fragment),ah=o(),Hl=a("div"),p(so.$$.fragment),Jm=o(),ee=a("div"),p(no.$$.fragment),lh=o(),Pl=a("p"),Pl.innerHTML=Ey,ih=o(),p(Ot.$$.fragment),ch=o(),Dl=a("div"),p(oo.$$.fragment),xm=o(),te=a("div"),p(ro.$$.fragment),dh=o(),Ql=a("p"),Ql.innerHTML=Sy,ph=o(),p(Kt.$$.fragment),mh=o(),Yl=a("div"),p(ao.$$.fragment),Um=o(),se=a("div"),p(lo.$$.fragment),uh=o(),Al=a("p"),Al.innerHTML=qy,gh=o(),p(es.$$.fragment),hh=o(),Ol=a("div"),p(io.$$.fragment),Bm=o(),ne=a("div"),p(co.$$.fragment),fh=o(),Kl=a("p"),Kl.innerHTML=Hy,_h=o(),p(ts.$$.fragment),bh=o(),ei=a("div"),p(po.$$.fragment),Im=o(),W=a("div"),p(mo.$$.fragment),yh=o(),ti=a("p"),ti.innerHTML=Py,Th=o(),si=a("p"),si.innerHTML=Dy,Mh=o(),ni=a("p"),ni.innerHTML=Qy,vh=o(),p(ss.$$.fragment),wh=o(),oi=a("div"),p(uo.$$.fragment),Zm=o(),oe=a("div"),p(go.$$.fragment),jh=o(),ri=a("p"),ri.innerHTML=Yy,kh=o(),ai=a("p"),ai.innerHTML=Ay,$h=o(),li=a("div"),p(ho.$$.fragment),zm=o(),re=a("div"),p(fo.$$.fragment),Jh=o(),ii=a("p"),ii.innerHTML=Oy,xh=o(),p(ns.$$.fragment),Uh=o(),ci=a("div"),p(_o.$$.fragment),Wm=o(),ke=a("div"),p(bo.$$.fragment),Bh=o(),di=a("p"),di.textContent=Ky,Ih=o(),pi=a("div"),p(yo.$$.fragment),Vm=o(),$e=a("div"),p(To.$$.fragment),Zh=o(),mi=a("p"),mi.innerHTML=eT,zh=o(),ui=a("div"),p(Mo.$$.fragment),Lm=o(),Je=a("div"),p(vo.$$.fragment),Wh=o(),gi=a("p"),gi.textContent=tT,Vh=o(),hi=a("div"),p(wo.$$.fragment),Fm=o(),ae=a("div"),p(jo.$$.fragment),Lh=o(),fi=a("p"),fi.innerHTML=sT,Fh=o(),p(os.$$.fragment),Ch=o(),_i=a("div"),p(ko.$$.fragment),Cm=o(),le=a("div"),p($o.$$.fragment),Gh=o(),bi=a("p"),bi.innerHTML=nT,Xh=o(),p(rs.$$.fragment),Rh=o(),yi=a("div"),p(Jo.$$.fragment),Gm=o(),G=a("div"),p(xo.$$.fragment),Nh=o(),Ti=a("p"),Ti.innerHTML=oT,Eh=o(),p(as.$$.fragment),Sh=o(),p(ls.$$.fragment),qh=o(),Mi=a("div"),p(Uo.$$.fragment),Xm=o(),X=a("div"),p(Bo.$$.fragment),Hh=o(),vi=a("p"),vi.innerHTML=rT,Ph=o(),p(is.$$.fragment),Dh=o(),p(cs.$$.fragment),Qh=o(),wi=a("div"),p(Io.$$.fragment),Rm=o(),ie=a("div"),p(Zo.$$.fragment),Yh=o(),ji=a("p"),ji.innerHTML=aT,Ah=o(),p(ds.$$.fragment),Oh=o(),ki=a("div"),p(zo.$$.fragment),Nm=o(),R=a("div"),p(Wo.$$.fragment),Kh=o(),$i=a("p"),$i.innerHTML=lT,ef=o(),Ji=a("p"),Ji.innerHTML=iT,tf=o(),p(ps.$$.fragment),sf=o(),xi=a("div"),p(Vo.$$.fragment),Em=o(),N=a("div"),p(Lo.$$.fragment),nf=o(),Ui=a("p"),Ui.innerHTML=cT,of=o(),p(ms.$$.fragment),rf=o(),p(us.$$.fragment),af=o(),Bi=a("div"),p(Fo.$$.fragment),Sm=o(),ce=a("div"),p(Co.$$.fragment),lf=o(),Ii=a("p"),Ii.innerHTML=dT,cf=o(),p(gs.$$.fragment),df=o(),Zi=a("div"),p(Go.$$.fragment),qm=o(),de=a("div"),p(Xo.$$.fragment),pf=o(),zi=a("p"),zi.innerHTML=pT,mf=o(),p(hs.$$.fragment),uf=o(),Wi=a("div"),p(Ro.$$.fragment),Hm=o(),E=a("div"),p(No.$$.fragment),gf=o(),Vi=a("p"),Vi.innerHTML=mT,hf=o(),p(fs.$$.fragment),ff=o(),p(_s.$$.fragment),_f=o(),Li=a("div"),p(Eo.$$.fragment),Pm=o(),pe=a("div"),p(So.$$.fragment),bf=o(),Fi=a("p"),Fi.innerHTML=uT,yf=o(),p(bs.$$.fragment),Tf=o(),Ci=a("div"),p(qo.$$.fragment),Dm=o(),me=a("div"),p(Ho.$$.fragment),Mf=o(),Gi=a("p"),Gi.innerHTML=gT,vf=o(),p(ys.$$.fragment),wf=o(),Xi=a("div"),p(Po.$$.fragment),Qm=o(),S=a("div"),p(Do.$$.fragment),jf=o(),Ri=a("p"),Ri.innerHTML=hT,kf=o(),Ni=a("p"),Ni.innerHTML=fT,$f=o(),p(Ts.$$.fragment),Jf=o(),Ei=a("div"),p(Qo.$$.fragment),Ym=o(),q=a("div"),p(Yo.$$.fragment),xf=o(),Si=a("p"),Si.innerHTML=_T,Uf=o(),qi=a("p"),qi.innerHTML=bT,Bf=o(),p(Ms.$$.fragment),If=o(),Hi=a("div"),p(Ao.$$.fragment),Am=o(),H=a("div"),p(Oo.$$.fragment),Zf=o(),Pi=a("p"),Pi.innerHTML=yT,zf=o(),Di=a("p"),Di.innerHTML=TT,Wf=o(),p(vs.$$.fragment),Vf=o(),Qi=a("div"),p(Ko.$$.fragment),Om=o(),p(er.$$.fragment),Km=o(),xe=a("div"),p(tr.$$.fragment),Lf=o(),Yi=a("p"),Yi.innerHTML=MT,Ff=o(),Ai=a("div"),p(sr.$$.fragment),eu=o(),Ue=a("div"),p(nr.$$.fragment),Cf=o(),Oi=a("p"),Oi.innerHTML=vT,Gf=o(),Ki=a("div"),p(or.$$.fragment),tu=o(),Be=a("div"),p(rr.$$.fragment),Xf=o(),ec=a("p"),ec.innerHTML=wT,Rf=o(),tc=a("div"),p(ar.$$.fragment),su=o(),Ie=a("div"),p(lr.$$.fragment),Nf=o(),sc=a("p"),sc.textContent=jT,Ef=o(),ws=a("div"),p(ir.$$.fragment),Sf=o(),nc=a("p"),nc.textContent=kT,nu=o(),Ze=a("div"),p(cr.$$.fragment),qf=o(),oc=a("p"),oc.innerHTML=$T,Hf=o(),rc=a("div"),p(dr.$$.fragment),ou=o(),ze=a("div"),p(pr.$$.fragment),Pf=o(),ac=a("p"),ac.textContent=JT,Df=o(),js=a("div"),p(mr.$$.fragment),Qf=o(),lc=a("p"),lc.textContent=xT,ru=o(),We=a("div"),p(ur.$$.fragment),Yf=o(),ic=a("p"),ic.innerHTML=UT,Af=o(),cc=a("div"),p(gr.$$.fragment),au=o(),Ve=a("div"),p(hr.$$.fragment),Of=o(),dc=a("p"),dc.innerHTML=BT,Kf=o(),pc=a("div"),p(fr.$$.fragment),lu=o(),Le=a("div"),p(_r.$$.fragment),e_=o(),mc=a("p"),mc.innerHTML=IT,t_=o(),uc=a("div"),p(br.$$.fragment),iu=o(),Fe=a("div"),p(yr.$$.fragment),s_=o(),gc=a("p"),gc.innerHTML=ZT,n_=o(),hc=a("div"),p(Tr.$$.fragment),cu=o(),Ce=a("div"),p(Mr.$$.fragment),o_=o(),fc=a("p"),fc.innerHTML=zT,r_=o(),_c=a("div"),p(vr.$$.fragment),du=o(),Ge=a("div"),p(wr.$$.fragment),a_=o(),bc=a("p"),bc.innerHTML=WT,l_=o(),yc=a("div"),p(jr.$$.fragment),pu=o(),Xe=a("div"),p(kr.$$.fragment),i_=o(),Tc=a("p"),Tc.innerHTML=VT,c_=o(),Mc=a("div"),p($r.$$.fragment),mu=o(),Re=a("div"),p(Jr.$$.fragment),d_=o(),vc=a("p"),vc.innerHTML=LT,p_=o(),wc=a("div"),p(xr.$$.fragment),uu=o(),Ne=a("div"),p(Ur.$$.fragment),m_=o(),jc=a("p"),jc.innerHTML=FT,u_=o(),kc=a("div"),p(Br.$$.fragment),gu=o(),p(Ir.$$.fragment),hu=o(),Ee=a("div"),p(Zr.$$.fragment),g_=o(),$c=a("p"),$c.innerHTML=CT,h_=o(),Jc=a("div"),p(zr.$$.fragment),fu=o(),Se=a("div"),p(Wr.$$.fragment),f_=o(),xc=a("p"),xc.innerHTML=GT,__=o(),Uc=a("div"),p(Vr.$$.fragment),_u=o(),qe=a("div"),p(Lr.$$.fragment),b_=o(),Bc=a("p"),Bc.innerHTML=XT,y_=o(),Ic=a("div"),p(Fr.$$.fragment),bu=o(),He=a("div"),p(Cr.$$.fragment),T_=o(),Zc=a("p"),Zc.textContent=RT,M_=o(),ks=a("div"),p(Gr.$$.fragment),v_=o(),zc=a("p"),zc.textContent=NT,yu=o(),Pe=a("div"),p(Xr.$$.fragment),w_=o(),Wc=a("p"),Wc.innerHTML=ET,j_=o(),Vc=a("div"),p(Rr.$$.fragment),Tu=o(),De=a("div"),p(Nr.$$.fragment),k_=o(),Lc=a("p"),Lc.textContent=ST,$_=o(),$s=a("div"),p(Er.$$.fragment),J_=o(),Fc=a("p"),Fc.textContent=qT,Mu=o(),Qe=a("div"),p(Sr.$$.fragment),x_=o(),Cc=a("p"),Cc.innerHTML=HT,U_=o(),Gc=a("div"),p(qr.$$.fragment),vu=o(),Ye=a("div"),p(Hr.$$.fragment),B_=o(),Xc=a("p"),Xc.innerHTML=PT,I_=o(),Rc=a("div"),p(Pr.$$.fragment),wu=o(),Ae=a("div"),p(Dr.$$.fragment),Z_=o(),Nc=a("p"),Nc.innerHTML=DT,z_=o(),Ec=a("div"),p(Qr.$$.fragment),ju=o(),Oe=a("div"),p(Yr.$$.fragment),W_=o(),Sc=a("p"),Sc.innerHTML=QT,V_=o(),qc=a("div"),p(Ar.$$.fragment),ku=o(),Ke=a("div"),p(Or.$$.fragment),L_=o(),Hc=a("p"),Hc.innerHTML=YT,F_=o(),Pc=a("div"),p(Kr.$$.fragment),$u=o(),et=a("div"),p(ea.$$.fragment),C_=o(),Dc=a("p"),Dc.innerHTML=AT,G_=o(),Qc=a("div"),p(ta.$$.fragment),Ju=o(),tt=a("div"),p(sa.$$.fragment),X_=o(),Yc=a("p"),Yc.innerHTML=OT,R_=o(),Ac=a("div"),p(na.$$.fragment),xu=o(),p(oa.$$.fragment),Uu=o(),ra=a("p"),ra.innerHTML=KT,Bu=o(),ue=a("div"),p(aa.$$.fragment),N_=o(),Oc=a("p"),Oc.textContent=eM,E_=o(),Kc=a("p"),Kc.innerHTML=tM,S_=o(),ed=a("div"),p(la.$$.fragment),Iu=o(),Lt=a("div"),p(ia.$$.fragment),q_=o(),td=a("div"),p(ca.$$.fragment),Zu=o(),st=a("div"),p(da.$$.fragment),H_=o(),sd=a("p"),sd.innerHTML=sM,P_=o(),nd=a("div"),p(pa.$$.fragment),zu=o(),nt=a("div"),p(ma.$$.fragment),D_=o(),od=a("p"),od.innerHTML=nM,Q_=o(),rd=a("div"),p(ua.$$.fragment),Wu=o(),p(ga.$$.fragment),Vu=o(),ha=a("p"),ha.innerHTML=oM,Lu=o(),U=a("div"),p(fa.$$.fragment),Y_=o(),ad=a("p"),ad.textContent=rM,A_=o(),ld=a("p"),ld.textContent=aM,O_=o(),p(Js.$$.fragment),K_=o(),id=a("p"),id.textContent=lM,eb=o(),xs=a("div"),p(_a.$$.fragment),tb=o(),cd=a("p"),cd.textContent=iM,sb=o(),Us=a("div"),p(ba.$$.fragment),nb=o(),dd=a("p"),dd.textContent=cM,ob=o(),Bs=a("div"),p(ya.$$.fragment),rb=o(),pd=a("p"),pd.textContent=dM,ab=o(),Is=a("div"),p(Ta.$$.fragment),lb=o(),md=a("p"),md.innerHTML=pM,ib=o(),Zs=a("div"),p(Ma.$$.fragment),cb=o(),ud=a("p"),ud.textContent=mM,db=o(),zs=a("div"),p(va.$$.fragment),pb=o(),gd=a("p"),gd.textContent=uM,mb=o(),mt=a("div"),p(wa.$$.fragment),ub=o(),hd=a("p"),hd.innerHTML=gM,gb=o(),fd=a("p"),fd.textContent=hM,Fu=o(),Ft=a("div"),p(ja.$$.fragment),hb=o(),_d=a("p"),_d.innerHTML=fM,Cu=o(),Ct=a("div"),p(ka.$$.fragment),fb=o(),bd=a("p"),bd.innerHTML=_M,Gu=o(),ge=a("div"),p($a.$$.fragment),_b=o(),yd=a("p"),yd.textContent=bM,bb=o(),L=a("div"),p(Ja.$$.fragment),yb=o(),Td=a("p"),Td.textContent=yM,Tb=o(),Md=a("p"),Md.innerHTML=TM,Mb=o(),vd=a("p"),vd.innerHTML=MM,vb=o(),wd=a("p"),wd.innerHTML=vM,wb=o(),jd=a("p"),jd.textContent=wM,jb=o(),Ws=a("div"),p(xa.$$.fragment),kb=o(),kd=a("p"),kd.textContent=jM,Xu=o(),p(Ua.$$.fragment),Ru=o(),he=a("div"),p(Ba.$$.fragment),$b=o(),$d=a("p"),$d.innerHTML=kM,Jb=o(),Jd=a("div"),p(Ia.$$.fragment),xb=o(),xd=a("div"),p(Za.$$.fragment),Nu=o(),V=a("div"),p(za.$$.fragment),Ub=o(),Ud=a("p"),Ud.innerHTML=$M,Bb=o(),Bd=a("p"),Bd.innerHTML=JM,Ib=o(),Id=a("p"),Id.innerHTML=xM,Zb=o(),Zd=a("div"),p(Wa.$$.fragment),zb=o(),zd=a("div"),p(Va.$$.fragment),Eu=o(),fe=a("div"),p(La.$$.fragment),Wb=o(),Wd=a("p"),Wd.innerHTML=UM,Vb=o(),Vd=a("div"),p(Fa.$$.fragment),Lb=o(),Ld=a("div"),p(Ca.$$.fragment),Su=o(),p(Ga.$$.fragment),qu=o(),ot=a("div"),p(Xa.$$.fragment),Fb=o(),Fd=a("p"),Fd.textContent=BM,Cb=o(),Cd=a("p"),Cd.innerHTML=IM,Hu=o(),rt=a("div"),p(Ra.$$.fragment),Gb=o(),Gd=a("p"),Gd.textContent=ZM,Xb=o(),Xd=a("p"),Xd.innerHTML=zM,Pu=o(),p(Na.$$.fragment),Du=o(),Z=a("div"),p(Ea.$$.fragment),Rb=o(),Rd=a("p"),Rd.textContent=WM,Nb=o(),p(Vs.$$.fragment),Eb=o(),p(Ls.$$.fragment),Sb=o(),Fs=a("div"),p(Sa.$$.fragment),qb=o(),Nd=a("p"),Nd.textContent=VM,Hb=o(),Cs=a("div"),p(qa.$$.fragment),Pb=o(),Ed=a("p"),Ed.textContent=LM,Db=o(),Gs=a("div"),p(Ha.$$.fragment),Qb=o(),Sd=a("p"),Sd.textContent=FM,Qu=o(),P=a("div"),p(Pa.$$.fragment),Yb=o(),qd=a("p"),qd.textContent=CM,Ab=o(),p(Xs.$$.fragment),Ob=o(),p(Rs.$$.fragment),Kb=o(),Ns=a("div"),p(Da.$$.fragment),ey=o(),Hd=a("p"),Hd.textContent=GM,Yu=o(),Up=a("p"),this.h()},l(e){const i=Pv("svelte-u9bgzb",document.head);c=l(i,"META",{name:!0,content:!0}),i.forEach(t),k=r(e),b=l(e,"P",{}),T(b).forEach(t),_=r(e),m(w.$$.fragment,e),n=r(e),j=l(e,"P",{"data-svelte-h":!0}),y(j)!=="svelte-15i3mav"&&(j.innerHTML=ty),Cp=r(e),on=l(e,"P",{"data-svelte-h":!0}),y(on)!=="svelte-1xb6mou"&&(on.textContent=sy),Gp=r(e),m(rn.$$.fragment,e),Xp=r(e),an=l(e,"P",{"data-svelte-h":!0}),y(an)!=="svelte-dga6j5"&&(an.innerHTML=ny),Rp=r(e),ln=l(e,"P",{"data-svelte-h":!0}),y(ln)!=="svelte-48zunw"&&(ln.textContent=oy),Np=r(e),m(cn.$$.fragment,e),Ep=r(e),dn=l(e,"P",{"data-svelte-h":!0}),y(dn)!=="svelte-qgefca"&&(dn.innerHTML=ry),Sp=r(e),pn=l(e,"UL",{"data-svelte-h":!0}),y(pn)!=="svelte-12oovmb"&&(pn.innerHTML=ay),qp=r(e),mn=l(e,"P",{"data-svelte-h":!0}),y(mn)!=="svelte-1x12yto"&&(mn.innerHTML=ly),Hp=r(e),un=l(e,"P",{"data-svelte-h":!0}),y(un)!=="svelte-x6gj5z"&&(un.innerHTML=iy),Pp=r(e),gn=l(e,"P",{"data-svelte-h":!0}),y(gn)!=="svelte-1rmet5j"&&(gn.innerHTML=cy),Dp=r(e),m(hn.$$.fragment,e),Qp=r(e),fn=l(e,"P",{"data-svelte-h":!0}),y(fn)!=="svelte-u42zuo"&&(fn.innerHTML=dy),Yp=r(e),_n=l(e,"P",{"data-svelte-h":!0}),y(_n)!=="svelte-1pctuzz"&&(_n.innerHTML=py),Ap=r(e),bn=l(e,"P",{"data-svelte-h":!0}),y(bn)!=="svelte-1r8y25s"&&(bn.textContent=my),Op=r(e),m(yn.$$.fragment,e),Kp=r(e),vt=l(e,"DIV",{class:!0});var Qa=T(vt);m(Tn.$$.fragment,Qa),fg=r(Qa),ml=l(Qa,"P",{"data-svelte-h":!0}),y(ml)!=="svelte-k7oes3"&&(ml.textContent=uy),Qa.forEach(t),em=r(e),wt=l(e,"DIV",{class:!0});var Ya=T(wt);m(Mn.$$.fragment,Ya),_g=r(Ya),ul=l(Ya,"P",{"data-svelte-h":!0}),y(ul)!=="svelte-1srbh9p"&&(ul.textContent=gy),Ya.forEach(t),tm=r(e),jt=l(e,"DIV",{class:!0});var Aa=T(jt);m(vn.$$.fragment,Aa),bg=r(Aa),gl=l(Aa,"P",{"data-svelte-h":!0}),y(gl)!=="svelte-1j3b9cp"&&(gl.textContent=hy),Aa.forEach(t),sm=r(e),kt=l(e,"DIV",{class:!0});var Oa=T(kt);m(wn.$$.fragment,Oa),yg=r(Oa),hl=l(Oa,"P",{"data-svelte-h":!0}),y(hl)!=="svelte-16r5px1"&&(hl.textContent=fy),Oa.forEach(t),nm=r(e),m(jn.$$.fragment,e),om=r(e),$t=l(e,"DIV",{class:!0});var Ka=T($t);m(kn.$$.fragment,Ka),Tg=r(Ka),fl=l(Ka,"P",{"data-svelte-h":!0}),y(fl)!=="svelte-1bnrp61"&&(fl.textContent=_y),Ka.forEach(t),rm=r(e),Jt=l(e,"DIV",{class:!0});var el=T(Jt);m($n.$$.fragment,el),Mg=r(el),_l=l(el,"P",{"data-svelte-h":!0}),y(_l)!=="svelte-fenhkk"&&(_l.textContent=by),el.forEach(t),am=r(e),xt=l(e,"DIV",{class:!0});var tl=T(xt);m(Jn.$$.fragment,tl),vg=r(tl),bl=l(tl,"P",{"data-svelte-h":!0}),y(bl)!=="svelte-1dqtgq4"&&(bl.textContent=yy),tl.forEach(t),lm=r(e),Ut=l(e,"DIV",{class:!0});var sl=T(Ut);m(xn.$$.fragment,sl),wg=r(sl),yl=l(sl,"P",{"data-svelte-h":!0}),y(yl)!=="svelte-10orfv5"&&(yl.textContent=Ty),sl.forEach(t),im=r(e),Bt=l(e,"DIV",{class:!0});var nl=T(Bt);m(Un.$$.fragment,nl),jg=r(nl),Tl=l(nl,"P",{"data-svelte-h":!0}),y(Tl)!=="svelte-jg8udg"&&(Tl.textContent=My),nl.forEach(t),cm=r(e),It=l(e,"DIV",{class:!0});var ol=T(It);m(Bn.$$.fragment,ol),kg=r(ol),Ml=l(ol,"P",{"data-svelte-h":!0}),y(Ml)!=="svelte-1i40667"&&(Ml.textContent=vy),ol.forEach(t),dm=r(e),Zt=l(e,"DIV",{class:!0});var rl=T(Zt);m(In.$$.fragment,rl),$g=r(rl),vl=l(rl,"P",{"data-svelte-h":!0}),y(vl)!=="svelte-n5fi8x"&&(vl.textContent=wy),rl.forEach(t),pm=r(e),zt=l(e,"DIV",{class:!0});var al=T(zt);m(Zn.$$.fragment,al),Jg=r(al),wl=l(al,"P",{"data-svelte-h":!0}),y(wl)!=="svelte-h5pj3l"&&(wl.textContent=jy),al.forEach(t),mm=r(e),Wt=l(e,"DIV",{class:!0});var ll=T(Wt);m(zn.$$.fragment,ll),xg=r(ll),jl=l(ll,"P",{"data-svelte-h":!0}),y(jl)!=="svelte-b9zq6n"&&(jl.textContent=ky),ll.forEach(t),um=r(e),Vt=l(e,"DIV",{class:!0});var il=T(Vt);m(Wn.$$.fragment,il),Ug=r(il),kl=l(il,"P",{"data-svelte-h":!0}),y(kl)!=="svelte-pru3ks"&&(kl.textContent=$y),il.forEach(t),gm=r(e),m(Vn.$$.fragment,e),hm=r(e),ve=l(e,"DIV",{class:!0});var Gt=T(ve);m(Ln.$$.fragment,Gt),Bg=r(Gt),$l=l(Gt,"P",{"data-svelte-h":!0}),y($l)!=="svelte-qoov36"&&($l.textContent=Jy),Ig=r(Gt),Nt=l(Gt,"DIV",{class:!0});var cl=T(Nt);m(Fn.$$.fragment,cl),Zg=r(cl),Jl=l(cl,"P",{"data-svelte-h":!0}),y(Jl)!=="svelte-5ihtpa"&&(Jl.textContent=xy),cl.forEach(t),Gt.forEach(t),fm=r(e),we=l(e,"DIV",{class:!0});var Xt=T(we);m(Cn.$$.fragment,Xt),zg=r(Xt),xl=l(Xt,"P",{"data-svelte-h":!0}),y(xl)!=="svelte-1tz7qrd"&&(xl.textContent=Uy),Wg=r(Xt),Et=l(Xt,"DIV",{class:!0});var dl=T(Et);m(Gn.$$.fragment,dl),Vg=r(dl),Ul=l(dl,"P",{"data-svelte-h":!0}),y(Ul)!=="svelte-5ihtpa"&&(Ul.textContent=By),dl.forEach(t),Xt.forEach(t),_m=r(e),je=l(e,"DIV",{class:!0});var Rt=T(je);m(Xn.$$.fragment,Rt),Lg=r(Rt),Bl=l(Rt,"P",{"data-svelte-h":!0}),y(Bl)!=="svelte-1tz7qrd"&&(Bl.textContent=Iy),Fg=r(Rt),St=l(Rt,"DIV",{class:!0});var pl=T(St);m(Rn.$$.fragment,pl),Cg=r(pl),Il=l(pl,"P",{"data-svelte-h":!0}),y(Il)!=="svelte-5ihtpa"&&(Il.textContent=Zy),pl.forEach(t),Rt.forEach(t),bm=r(e),m(Nn.$$.fragment,e),ym=r(e),En=l(e,"P",{"data-svelte-h":!0}),y(En)!=="svelte-gibq8u"&&(En.innerHTML=zy),Tm=r(e),m(Sn.$$.fragment,e),Mm=r(e),A=l(e,"DIV",{class:!0});var at=T(A);m(qn.$$.fragment,at),Gg=r(at),Zl=l(at,"P",{"data-svelte-h":!0}),y(Zl)!=="svelte-127u34o"&&(Zl.innerHTML=Wy),Xg=r(at),m(qt.$$.fragment,at),Rg=r(at),zl=l(at,"DIV",{class:!0});var Bp=T(zl);m(Hn.$$.fragment,Bp),Bp.forEach(t),at.forEach(t),vm=r(e),z=l(e,"DIV",{class:!0});var D=T(z);m(Pn.$$.fragment,D),Ng=r(D),Wl=l(D,"P",{"data-svelte-h":!0}),y(Wl)!=="svelte-kb275n"&&(Wl.innerHTML=Vy),Eg=r(D),Vl=l(D,"P",{"data-svelte-h":!0}),y(Vl)!=="svelte-lu7kru"&&(Vl.innerHTML=Ly),Sg=r(D),m(Ht.$$.fragment,D),qg=r(D),m(Pt.$$.fragment,D),Hg=r(D),Ll=l(D,"DIV",{class:!0});var Ip=T(Ll);m(Dn.$$.fragment,Ip),Ip.forEach(t),D.forEach(t),wm=r(e),F=l(e,"DIV",{class:!0});var _e=T(F);m(Qn.$$.fragment,_e),Pg=r(_e),Fl=l(_e,"P",{"data-svelte-h":!0}),y(Fl)!=="svelte-1bvcbfl"&&(Fl.innerHTML=Fy),Dg=r(_e),Cl=l(_e,"P",{"data-svelte-h":!0}),y(Cl)!=="svelte-mpy00q"&&(Cl.textContent=Cy),Qg=r(_e),m(Dt.$$.fragment,_e),Yg=r(_e),Gl=l(_e,"DIV",{class:!0});var Zp=T(Gl);m(Yn.$$.fragment,Zp),Zp.forEach(t),_e.forEach(t),jm=r(e),C=l(e,"DIV",{class:!0});var be=T(C);m(An.$$.fragment,be),Ag=r(be),Xl=l(be,"P",{"data-svelte-h":!0}),y(Xl)!=="svelte-149fokv"&&(Xl.innerHTML=Gy),Og=r(be),Rl=l(be,"P",{"data-svelte-h":!0}),y(Rl)!=="svelte-3qpgm7"&&(Rl.textContent=Xy),Kg=r(be),m(Qt.$$.fragment,be),eh=r(be),Nl=l(be,"DIV",{class:!0});var zp=T(Nl);m(On.$$.fragment,zp),zp.forEach(t),be.forEach(t),km=r(e),O=l(e,"DIV",{class:!0});var lt=T(O);m(Kn.$$.fragment,lt),th=r(lt),El=l(lt,"P",{"data-svelte-h":!0}),y(El)!=="svelte-70jn8q"&&(El.innerHTML=Ry),sh=r(lt),m(Yt.$$.fragment,lt),nh=r(lt),Sl=l(lt,"DIV",{class:!0});var Wp=T(Sl);m(eo.$$.fragment,Wp),Wp.forEach(t),lt.forEach(t),$m=r(e),K=l(e,"DIV",{class:!0});var it=T(K);m(to.$$.fragment,it),oh=r(it),ql=l(it,"P",{"data-svelte-h":!0}),y(ql)!=="svelte-157a3pq"&&(ql.innerHTML=Ny),rh=r(it),m(At.$$.fragment,it),ah=r(it),Hl=l(it,"DIV",{class:!0});var Vp=T(Hl);m(so.$$.fragment,Vp),Vp.forEach(t),it.forEach(t),Jm=r(e),ee=l(e,"DIV",{class:!0});var ct=T(ee);m(no.$$.fragment,ct),lh=r(ct),Pl=l(ct,"P",{"data-svelte-h":!0}),y(Pl)!=="svelte-9l9r5h"&&(Pl.innerHTML=Ey),ih=r(ct),m(Ot.$$.fragment,ct),ch=r(ct),Dl=l(ct,"DIV",{class:!0});var Lp=T(Dl);m(oo.$$.fragment,Lp),Lp.forEach(t),ct.forEach(t),xm=r(e),te=l(e,"DIV",{class:!0});var dt=T(te);m(ro.$$.fragment,dt),dh=r(dt),Ql=l(dt,"P",{"data-svelte-h":!0}),y(Ql)!=="svelte-4wnlf5"&&(Ql.innerHTML=Sy),ph=r(dt),m(Kt.$$.fragment,dt),mh=r(dt),Yl=l(dt,"DIV",{class:!0});var Fp=T(Yl);m(ao.$$.fragment,Fp),Fp.forEach(t),dt.forEach(t),Um=r(e),se=l(e,"DIV",{class:!0});var pt=T(se);m(lo.$$.fragment,pt),uh=r(pt),Al=l(pt,"P",{"data-svelte-h":!0}),y(Al)!=="svelte-1tdjecl"&&(Al.innerHTML=qy),gh=r(pt),m(es.$$.fragment,pt),hh=r(pt),Ol=l(pt,"DIV",{class:!0});var XM=T(Ol);m(io.$$.fragment,XM),XM.forEach(t),pt.forEach(t),Bm=r(e),ne=l(e,"DIV",{class:!0});var Es=T(ne);m(co.$$.fragment,Es),fh=r(Es),Kl=l(Es,"P",{"data-svelte-h":!0}),y(Kl)!=="svelte-lpfxi8"&&(Kl.innerHTML=Hy),_h=r(Es),m(ts.$$.fragment,Es),bh=r(Es),ei=l(Es,"DIV",{class:!0});var RM=T(ei);m(po.$$.fragment,RM),RM.forEach(t),Es.forEach(t),Im=r(e),W=l(e,"DIV",{class:!0});var ye=T(W);m(mo.$$.fragment,ye),yh=r(ye),ti=l(ye,"P",{"data-svelte-h":!0}),y(ti)!=="svelte-1auv3tz"&&(ti.innerHTML=Py),Th=r(ye),si=l(ye,"P",{"data-svelte-h":!0}),y(si)!=="svelte-esibi"&&(si.innerHTML=Dy),Mh=r(ye),ni=l(ye,"P",{"data-svelte-h":!0}),y(ni)!=="svelte-2fpu88"&&(ni.innerHTML=Qy),vh=r(ye),m(ss.$$.fragment,ye),wh=r(ye),oi=l(ye,"DIV",{class:!0});var NM=T(oi);m(uo.$$.fragment,NM),NM.forEach(t),ye.forEach(t),Zm=r(e),oe=l(e,"DIV",{class:!0});var Ss=T(oe);m(go.$$.fragment,Ss),jh=r(Ss),ri=l(Ss,"P",{"data-svelte-h":!0}),y(ri)!=="svelte-1esa4wu"&&(ri.innerHTML=Yy),kh=r(Ss),ai=l(Ss,"P",{"data-svelte-h":!0}),y(ai)!=="svelte-1v3r596"&&(ai.innerHTML=Ay),$h=r(Ss),li=l(Ss,"DIV",{class:!0});var EM=T(li);m(ho.$$.fragment,EM),EM.forEach(t),Ss.forEach(t),zm=r(e),re=l(e,"DIV",{class:!0});var qs=T(re);m(fo.$$.fragment,qs),Jh=r(qs),ii=l(qs,"P",{"data-svelte-h":!0}),y(ii)!=="svelte-8738xx"&&(ii.innerHTML=Oy),xh=r(qs),m(ns.$$.fragment,qs),Uh=r(qs),ci=l(qs,"DIV",{class:!0});var SM=T(ci);m(_o.$$.fragment,SM),SM.forEach(t),qs.forEach(t),Wm=r(e),ke=l(e,"DIV",{class:!0});var Pd=T(ke);m(bo.$$.fragment,Pd),Bh=r(Pd),di=l(Pd,"P",{"data-svelte-h":!0}),y(di)!=="svelte-y1kta5"&&(di.textContent=Ky),Ih=r(Pd),pi=l(Pd,"DIV",{class:!0});var qM=T(pi);m(yo.$$.fragment,qM),qM.forEach(t),Pd.forEach(t),Vm=r(e),$e=l(e,"DIV",{class:!0});var Dd=T($e);m(To.$$.fragment,Dd),Zh=r(Dd),mi=l(Dd,"P",{"data-svelte-h":!0}),y(mi)!=="svelte-37uayj"&&(mi.innerHTML=eT),zh=r(Dd),ui=l(Dd,"DIV",{class:!0});var HM=T(ui);m(Mo.$$.fragment,HM),HM.forEach(t),Dd.forEach(t),Lm=r(e),Je=l(e,"DIV",{class:!0});var Qd=T(Je);m(vo.$$.fragment,Qd),Wh=r(Qd),gi=l(Qd,"P",{"data-svelte-h":!0}),y(gi)!=="svelte-th82mu"&&(gi.textContent=tT),Vh=r(Qd),hi=l(Qd,"DIV",{class:!0});var PM=T(hi);m(wo.$$.fragment,PM),PM.forEach(t),Qd.forEach(t),Fm=r(e),ae=l(e,"DIV",{class:!0});var Hs=T(ae);m(jo.$$.fragment,Hs),Lh=r(Hs),fi=l(Hs,"P",{"data-svelte-h":!0}),y(fi)!=="svelte-1xa8qk1"&&(fi.innerHTML=sT),Fh=r(Hs),m(os.$$.fragment,Hs),Ch=r(Hs),_i=l(Hs,"DIV",{class:!0});var DM=T(_i);m(ko.$$.fragment,DM),DM.forEach(t),Hs.forEach(t),Cm=r(e),le=l(e,"DIV",{class:!0});var Ps=T(le);m($o.$$.fragment,Ps),Gh=r(Ps),bi=l(Ps,"P",{"data-svelte-h":!0}),y(bi)!=="svelte-pymmqx"&&(bi.innerHTML=nT),Xh=r(Ps),m(rs.$$.fragment,Ps),Rh=r(Ps),yi=l(Ps,"DIV",{class:!0});var QM=T(yi);m(Jo.$$.fragment,QM),QM.forEach(t),Ps.forEach(t),Gm=r(e),G=l(e,"DIV",{class:!0});var ut=T(G);m(xo.$$.fragment,ut),Nh=r(ut),Ti=l(ut,"P",{"data-svelte-h":!0}),y(Ti)!=="svelte-1prjyup"&&(Ti.innerHTML=oT),Eh=r(ut),m(as.$$.fragment,ut),Sh=r(ut),m(ls.$$.fragment,ut),qh=r(ut),Mi=l(ut,"DIV",{class:!0});var YM=T(Mi);m(Uo.$$.fragment,YM),YM.forEach(t),ut.forEach(t),Xm=r(e),X=l(e,"DIV",{class:!0});var gt=T(X);m(Bo.$$.fragment,gt),Hh=r(gt),vi=l(gt,"P",{"data-svelte-h":!0}),y(vi)!=="svelte-3en468"&&(vi.innerHTML=rT),Ph=r(gt),m(is.$$.fragment,gt),Dh=r(gt),m(cs.$$.fragment,gt),Qh=r(gt),wi=l(gt,"DIV",{class:!0});var AM=T(wi);m(Io.$$.fragment,AM),AM.forEach(t),gt.forEach(t),Rm=r(e),ie=l(e,"DIV",{class:!0});var Ds=T(ie);m(Zo.$$.fragment,Ds),Yh=r(Ds),ji=l(Ds,"P",{"data-svelte-h":!0}),y(ji)!=="svelte-ijx449"&&(ji.innerHTML=aT),Ah=r(Ds),m(ds.$$.fragment,Ds),Oh=r(Ds),ki=l(Ds,"DIV",{class:!0});var OM=T(ki);m(zo.$$.fragment,OM),OM.forEach(t),Ds.forEach(t),Nm=r(e),R=l(e,"DIV",{class:!0});var ht=T(R);m(Wo.$$.fragment,ht),Kh=r(ht),$i=l(ht,"P",{"data-svelte-h":!0}),y($i)!=="svelte-1a15qvt"&&($i.innerHTML=lT),ef=r(ht),Ji=l(ht,"P",{"data-svelte-h":!0}),y(Ji)!=="svelte-qhda5i"&&(Ji.innerHTML=iT),tf=r(ht),m(ps.$$.fragment,ht),sf=r(ht),xi=l(ht,"DIV",{class:!0});var KM=T(xi);m(Vo.$$.fragment,KM),KM.forEach(t),ht.forEach(t),Em=r(e),N=l(e,"DIV",{class:!0});var ft=T(N);m(Lo.$$.fragment,ft),nf=r(ft),Ui=l(ft,"P",{"data-svelte-h":!0}),y(Ui)!=="svelte-1n8l9mu"&&(Ui.innerHTML=cT),of=r(ft),m(ms.$$.fragment,ft),rf=r(ft),m(us.$$.fragment,ft),af=r(ft),Bi=l(ft,"DIV",{class:!0});var ev=T(Bi);m(Fo.$$.fragment,ev),ev.forEach(t),ft.forEach(t),Sm=r(e),ce=l(e,"DIV",{class:!0});var Qs=T(ce);m(Co.$$.fragment,Qs),lf=r(Qs),Ii=l(Qs,"P",{"data-svelte-h":!0}),y(Ii)!=="svelte-1sf5fpu"&&(Ii.innerHTML=dT),cf=r(Qs),m(gs.$$.fragment,Qs),df=r(Qs),Zi=l(Qs,"DIV",{class:!0});var tv=T(Zi);m(Go.$$.fragment,tv),tv.forEach(t),Qs.forEach(t),qm=r(e),de=l(e,"DIV",{class:!0});var Ys=T(de);m(Xo.$$.fragment,Ys),pf=r(Ys),zi=l(Ys,"P",{"data-svelte-h":!0}),y(zi)!=="svelte-kp6ubc"&&(zi.innerHTML=pT),mf=r(Ys),m(hs.$$.fragment,Ys),uf=r(Ys),Wi=l(Ys,"DIV",{class:!0});var sv=T(Wi);m(Ro.$$.fragment,sv),sv.forEach(t),Ys.forEach(t),Hm=r(e),E=l(e,"DIV",{class:!0});var _t=T(E);m(No.$$.fragment,_t),gf=r(_t),Vi=l(_t,"P",{"data-svelte-h":!0}),y(Vi)!=="svelte-1d46c41"&&(Vi.innerHTML=mT),hf=r(_t),m(fs.$$.fragment,_t),ff=r(_t),m(_s.$$.fragment,_t),_f=r(_t),Li=l(_t,"DIV",{class:!0});var nv=T(Li);m(Eo.$$.fragment,nv),nv.forEach(t),_t.forEach(t),Pm=r(e),pe=l(e,"DIV",{class:!0});var As=T(pe);m(So.$$.fragment,As),bf=r(As),Fi=l(As,"P",{"data-svelte-h":!0}),y(Fi)!=="svelte-is25iv"&&(Fi.innerHTML=uT),yf=r(As),m(bs.$$.fragment,As),Tf=r(As),Ci=l(As,"DIV",{class:!0});var ov=T(Ci);m(qo.$$.fragment,ov),ov.forEach(t),As.forEach(t),Dm=r(e),me=l(e,"DIV",{class:!0});var Os=T(me);m(Ho.$$.fragment,Os),Mf=r(Os),Gi=l(Os,"P",{"data-svelte-h":!0}),y(Gi)!=="svelte-xxibmz"&&(Gi.innerHTML=gT),vf=r(Os),m(ys.$$.fragment,Os),wf=r(Os),Xi=l(Os,"DIV",{class:!0});var rv=T(Xi);m(Po.$$.fragment,rv),rv.forEach(t),Os.forEach(t),Qm=r(e),S=l(e,"DIV",{class:!0});var bt=T(S);m(Do.$$.fragment,bt),jf=r(bt),Ri=l(bt,"P",{"data-svelte-h":!0}),y(Ri)!=="svelte-14xbohg"&&(Ri.innerHTML=hT),kf=r(bt),Ni=l(bt,"P",{"data-svelte-h":!0}),y(Ni)!=="svelte-1qmimno"&&(Ni.innerHTML=fT),$f=r(bt),m(Ts.$$.fragment,bt),Jf=r(bt),Ei=l(bt,"DIV",{class:!0});var av=T(Ei);m(Qo.$$.fragment,av),av.forEach(t),bt.forEach(t),Ym=r(e),q=l(e,"DIV",{class:!0});var yt=T(q);m(Yo.$$.fragment,yt),xf=r(yt),Si=l(yt,"P",{"data-svelte-h":!0}),y(Si)!=="svelte-1dewsn6"&&(Si.innerHTML=_T),Uf=r(yt),qi=l(yt,"P",{"data-svelte-h":!0}),y(qi)!=="svelte-5qs7tv"&&(qi.innerHTML=bT),Bf=r(yt),m(Ms.$$.fragment,yt),If=r(yt),Hi=l(yt,"DIV",{class:!0});var lv=T(Hi);m(Ao.$$.fragment,lv),lv.forEach(t),yt.forEach(t),Am=r(e),H=l(e,"DIV",{class:!0});var Tt=T(H);m(Oo.$$.fragment,Tt),Zf=r(Tt),Pi=l(Tt,"P",{"data-svelte-h":!0}),y(Pi)!=="svelte-pc02u7"&&(Pi.innerHTML=yT),zf=r(Tt),Di=l(Tt,"P",{"data-svelte-h":!0}),y(Di)!=="svelte-qmmn5t"&&(Di.innerHTML=TT),Wf=r(Tt),m(vs.$$.fragment,Tt),Vf=r(Tt),Qi=l(Tt,"DIV",{class:!0});var iv=T(Qi);m(Ko.$$.fragment,iv),iv.forEach(t),Tt.forEach(t),Om=r(e),m(er.$$.fragment,e),Km=r(e),xe=l(e,"DIV",{class:!0});var Yd=T(xe);m(tr.$$.fragment,Yd),Lf=r(Yd),Yi=l(Yd,"P",{"data-svelte-h":!0}),y(Yi)!=="svelte-10dgypl"&&(Yi.innerHTML=MT),Ff=r(Yd),Ai=l(Yd,"DIV",{class:!0});var cv=T(Ai);m(sr.$$.fragment,cv),cv.forEach(t),Yd.forEach(t),eu=r(e),Ue=l(e,"DIV",{class:!0});var Ad=T(Ue);m(nr.$$.fragment,Ad),Cf=r(Ad),Oi=l(Ad,"P",{"data-svelte-h":!0}),y(Oi)!=="svelte-1fxrl51"&&(Oi.innerHTML=vT),Gf=r(Ad),Ki=l(Ad,"DIV",{class:!0});var dv=T(Ki);m(or.$$.fragment,dv),dv.forEach(t),Ad.forEach(t),tu=r(e),Be=l(e,"DIV",{class:!0});var Od=T(Be);m(rr.$$.fragment,Od),Xf=r(Od),ec=l(Od,"P",{"data-svelte-h":!0}),y(ec)!=="svelte-1557waw"&&(ec.innerHTML=wT),Rf=r(Od),tc=l(Od,"DIV",{class:!0});var pv=T(tc);m(ar.$$.fragment,pv),pv.forEach(t),Od.forEach(t),su=r(e),Ie=l(e,"DIV",{class:!0});var Kd=T(Ie);m(lr.$$.fragment,Kd),Nf=r(Kd),sc=l(Kd,"P",{"data-svelte-h":!0}),y(sc)!=="svelte-y1kta5"&&(sc.textContent=jT),Ef=r(Kd),ws=l(Kd,"DIV",{class:!0});var Ou=T(ws);m(ir.$$.fragment,Ou),Sf=r(Ou),nc=l(Ou,"P",{"data-svelte-h":!0}),y(nc)!=="svelte-5aspnb"&&(nc.textContent=kT),Ou.forEach(t),Kd.forEach(t),nu=r(e),Ze=l(e,"DIV",{class:!0});var ep=T(Ze);m(cr.$$.fragment,ep),qf=r(ep),oc=l(ep,"P",{"data-svelte-h":!0}),y(oc)!=="svelte-1qfuij9"&&(oc.innerHTML=$T),Hf=r(ep),rc=l(ep,"DIV",{class:!0});var mv=T(rc);m(dr.$$.fragment,mv),mv.forEach(t),ep.forEach(t),ou=r(e),ze=l(e,"DIV",{class:!0});var tp=T(ze);m(pr.$$.fragment,tp),Pf=r(tp),ac=l(tp,"P",{"data-svelte-h":!0}),y(ac)!=="svelte-th82mu"&&(ac.textContent=JT),Df=r(tp),js=l(tp,"DIV",{class:!0});var Ku=T(js);m(mr.$$.fragment,Ku),Qf=r(Ku),lc=l(Ku,"P",{"data-svelte-h":!0}),y(lc)!=="svelte-hcoglc"&&(lc.textContent=xT),Ku.forEach(t),tp.forEach(t),ru=r(e),We=l(e,"DIV",{class:!0});var sp=T(We);m(ur.$$.fragment,sp),Yf=r(sp),ic=l(sp,"P",{"data-svelte-h":!0}),y(ic)!=="svelte-1dodxsh"&&(ic.innerHTML=UT),Af=r(sp),cc=l(sp,"DIV",{class:!0});var uv=T(cc);m(gr.$$.fragment,uv),uv.forEach(t),sp.forEach(t),au=r(e),Ve=l(e,"DIV",{class:!0});var np=T(Ve);m(hr.$$.fragment,np),Of=r(np),dc=l(np,"P",{"data-svelte-h":!0}),y(dc)!=="svelte-boai80"&&(dc.innerHTML=BT),Kf=r(np),pc=l(np,"DIV",{class:!0});var gv=T(pc);m(fr.$$.fragment,gv),gv.forEach(t),np.forEach(t),lu=r(e),Le=l(e,"DIV",{class:!0});var op=T(Le);m(_r.$$.fragment,op),e_=r(op),mc=l(op,"P",{"data-svelte-h":!0}),y(mc)!=="svelte-1y6bgg"&&(mc.innerHTML=IT),t_=r(op),uc=l(op,"DIV",{class:!0});var hv=T(uc);m(br.$$.fragment,hv),hv.forEach(t),op.forEach(t),iu=r(e),Fe=l(e,"DIV",{class:!0});var rp=T(Fe);m(yr.$$.fragment,rp),s_=r(rp),gc=l(rp,"P",{"data-svelte-h":!0}),y(gc)!=="svelte-1g3gpu5"&&(gc.innerHTML=ZT),n_=r(rp),hc=l(rp,"DIV",{class:!0});var fv=T(hc);m(Tr.$$.fragment,fv),fv.forEach(t),rp.forEach(t),cu=r(e),Ce=l(e,"DIV",{class:!0});var ap=T(Ce);m(Mr.$$.fragment,ap),o_=r(ap),fc=l(ap,"P",{"data-svelte-h":!0}),y(fc)!=="svelte-1dqm9yu"&&(fc.innerHTML=zT),r_=r(ap),_c=l(ap,"DIV",{class:!0});var _v=T(_c);m(vr.$$.fragment,_v),_v.forEach(t),ap.forEach(t),du=r(e),Ge=l(e,"DIV",{class:!0});var lp=T(Ge);m(wr.$$.fragment,lp),a_=r(lp),bc=l(lp,"P",{"data-svelte-h":!0}),y(bc)!=="svelte-a554sd"&&(bc.innerHTML=WT),l_=r(lp),yc=l(lp,"DIV",{class:!0});var bv=T(yc);m(jr.$$.fragment,bv),bv.forEach(t),lp.forEach(t),pu=r(e),Xe=l(e,"DIV",{class:!0});var ip=T(Xe);m(kr.$$.fragment,ip),i_=r(ip),Tc=l(ip,"P",{"data-svelte-h":!0}),y(Tc)!=="svelte-19zp2bi"&&(Tc.innerHTML=VT),c_=r(ip),Mc=l(ip,"DIV",{class:!0});var yv=T(Mc);m($r.$$.fragment,yv),yv.forEach(t),ip.forEach(t),mu=r(e),Re=l(e,"DIV",{class:!0});var cp=T(Re);m(Jr.$$.fragment,cp),d_=r(cp),vc=l(cp,"P",{"data-svelte-h":!0}),y(vc)!=="svelte-12f42n7"&&(vc.innerHTML=LT),p_=r(cp),wc=l(cp,"DIV",{class:!0});var Tv=T(wc);m(xr.$$.fragment,Tv),Tv.forEach(t),cp.forEach(t),uu=r(e),Ne=l(e,"DIV",{class:!0});var dp=T(Ne);m(Ur.$$.fragment,dp),m_=r(dp),jc=l(dp,"P",{"data-svelte-h":!0}),y(jc)!=="svelte-o6dmh5"&&(jc.innerHTML=FT),u_=r(dp),kc=l(dp,"DIV",{class:!0});var Mv=T(kc);m(Br.$$.fragment,Mv),Mv.forEach(t),dp.forEach(t),gu=r(e),m(Ir.$$.fragment,e),hu=r(e),Ee=l(e,"DIV",{class:!0});var pp=T(Ee);m(Zr.$$.fragment,pp),g_=r(pp),$c=l(pp,"P",{"data-svelte-h":!0}),y($c)!=="svelte-17jh0y9"&&($c.innerHTML=CT),h_=r(pp),Jc=l(pp,"DIV",{class:!0});var vv=T(Jc);m(zr.$$.fragment,vv),vv.forEach(t),pp.forEach(t),fu=r(e),Se=l(e,"DIV",{class:!0});var mp=T(Se);m(Wr.$$.fragment,mp),f_=r(mp),xc=l(mp,"P",{"data-svelte-h":!0}),y(xc)!=="svelte-wrtsx9"&&(xc.innerHTML=GT),__=r(mp),Uc=l(mp,"DIV",{class:!0});var wv=T(Uc);m(Vr.$$.fragment,wv),wv.forEach(t),mp.forEach(t),_u=r(e),qe=l(e,"DIV",{class:!0});var up=T(qe);m(Lr.$$.fragment,up),b_=r(up),Bc=l(up,"P",{"data-svelte-h":!0}),y(Bc)!=="svelte-1kmi0m4"&&(Bc.innerHTML=XT),y_=r(up),Ic=l(up,"DIV",{class:!0});var jv=T(Ic);m(Fr.$$.fragment,jv),jv.forEach(t),up.forEach(t),bu=r(e),He=l(e,"DIV",{class:!0});var gp=T(He);m(Cr.$$.fragment,gp),T_=r(gp),Zc=l(gp,"P",{"data-svelte-h":!0}),y(Zc)!=="svelte-y1kta5"&&(Zc.textContent=RT),M_=r(gp),ks=l(gp,"DIV",{class:!0});var eg=T(ks);m(Gr.$$.fragment,eg),v_=r(eg),zc=l(eg,"P",{"data-svelte-h":!0}),y(zc)!=="svelte-1l17mwc"&&(zc.textContent=NT),eg.forEach(t),gp.forEach(t),yu=r(e),Pe=l(e,"DIV",{class:!0});var hp=T(Pe);m(Xr.$$.fragment,hp),w_=r(hp),Wc=l(hp,"P",{"data-svelte-h":!0}),y(Wc)!=="svelte-1giv3tf"&&(Wc.innerHTML=ET),j_=r(hp),Vc=l(hp,"DIV",{class:!0});var kv=T(Vc);m(Rr.$$.fragment,kv),kv.forEach(t),hp.forEach(t),Tu=r(e),De=l(e,"DIV",{class:!0});var fp=T(De);m(Nr.$$.fragment,fp),k_=r(fp),Lc=l(fp,"P",{"data-svelte-h":!0}),y(Lc)!=="svelte-th82mu"&&(Lc.textContent=ST),$_=r(fp),$s=l(fp,"DIV",{class:!0});var tg=T($s);m(Er.$$.fragment,tg),J_=r(tg),Fc=l(tg,"P",{"data-svelte-h":!0}),y(Fc)!=="svelte-1tcb5cf"&&(Fc.textContent=qT),tg.forEach(t),fp.forEach(t),Mu=r(e),Qe=l(e,"DIV",{class:!0});var _p=T(Qe);m(Sr.$$.fragment,_p),x_=r(_p),Cc=l(_p,"P",{"data-svelte-h":!0}),y(Cc)!=="svelte-1vkpw95"&&(Cc.innerHTML=HT),U_=r(_p),Gc=l(_p,"DIV",{class:!0});var $v=T(Gc);m(qr.$$.fragment,$v),$v.forEach(t),_p.forEach(t),vu=r(e),Ye=l(e,"DIV",{class:!0});var bp=T(Ye);m(Hr.$$.fragment,bp),B_=r(bp),Xc=l(bp,"P",{"data-svelte-h":!0}),y(Xc)!=="svelte-dmdi7x"&&(Xc.innerHTML=PT),I_=r(bp),Rc=l(bp,"DIV",{class:!0});var Jv=T(Rc);m(Pr.$$.fragment,Jv),Jv.forEach(t),bp.forEach(t),wu=r(e),Ae=l(e,"DIV",{class:!0});var yp=T(Ae);m(Dr.$$.fragment,yp),Z_=r(yp),Nc=l(yp,"P",{"data-svelte-h":!0}),y(Nc)!=="svelte-bydq87"&&(Nc.innerHTML=DT),z_=r(yp),Ec=l(yp,"DIV",{class:!0});var xv=T(Ec);m(Qr.$$.fragment,xv),xv.forEach(t),yp.forEach(t),ju=r(e),Oe=l(e,"DIV",{class:!0});var Tp=T(Oe);m(Yr.$$.fragment,Tp),W_=r(Tp),Sc=l(Tp,"P",{"data-svelte-h":!0}),y(Sc)!=="svelte-1q1ek50"&&(Sc.innerHTML=QT),V_=r(Tp),qc=l(Tp,"DIV",{class:!0});var Uv=T(qc);m(Ar.$$.fragment,Uv),Uv.forEach(t),Tp.forEach(t),ku=r(e),Ke=l(e,"DIV",{class:!0});var Mp=T(Ke);m(Or.$$.fragment,Mp),L_=r(Mp),Hc=l(Mp,"P",{"data-svelte-h":!0}),y(Hc)!=="svelte-2o6f0l"&&(Hc.innerHTML=YT),F_=r(Mp),Pc=l(Mp,"DIV",{class:!0});var Bv=T(Pc);m(Kr.$$.fragment,Bv),Bv.forEach(t),Mp.forEach(t),$u=r(e),et=l(e,"DIV",{class:!0});var vp=T(et);m(ea.$$.fragment,vp),C_=r(vp),Dc=l(vp,"P",{"data-svelte-h":!0}),y(Dc)!=="svelte-e871yf"&&(Dc.innerHTML=AT),G_=r(vp),Qc=l(vp,"DIV",{class:!0});var Iv=T(Qc);m(ta.$$.fragment,Iv),Iv.forEach(t),vp.forEach(t),Ju=r(e),tt=l(e,"DIV",{class:!0});var wp=T(tt);m(sa.$$.fragment,wp),X_=r(wp),Yc=l(wp,"P",{"data-svelte-h":!0}),y(Yc)!=="svelte-1sygpwz"&&(Yc.innerHTML=OT),R_=r(wp),Ac=l(wp,"DIV",{class:!0});var Zv=T(Ac);m(na.$$.fragment,Zv),Zv.forEach(t),wp.forEach(t),xu=r(e),m(oa.$$.fragment,e),Uu=r(e),ra=l(e,"P",{"data-svelte-h":!0}),y(ra)!=="svelte-1cqwo58"&&(ra.innerHTML=KT),Bu=r(e),ue=l(e,"DIV",{class:!0});var Ks=T(ue);m(aa.$$.fragment,Ks),N_=r(Ks),Oc=l(Ks,"P",{"data-svelte-h":!0}),y(Oc)!=="svelte-rfvu1k"&&(Oc.textContent=eM),E_=r(Ks),Kc=l(Ks,"P",{"data-svelte-h":!0}),y(Kc)!=="svelte-e1lytz"&&(Kc.innerHTML=tM),S_=r(Ks),ed=l(Ks,"DIV",{class:!0});var zv=T(ed);m(la.$$.fragment,zv),zv.forEach(t),Ks.forEach(t),Iu=r(e),Lt=l(e,"DIV",{class:!0});var sg=T(Lt);m(ia.$$.fragment,sg),q_=r(sg),td=l(sg,"DIV",{class:!0});var Wv=T(td);m(ca.$$.fragment,Wv),Wv.forEach(t),sg.forEach(t),Zu=r(e),st=l(e,"DIV",{class:!0});var jp=T(st);m(da.$$.fragment,jp),H_=r(jp),sd=l(jp,"P",{"data-svelte-h":!0}),y(sd)!=="svelte-4hfu96"&&(sd.innerHTML=sM),P_=r(jp),nd=l(jp,"DIV",{class:!0});var Vv=T(nd);m(pa.$$.fragment,Vv),Vv.forEach(t),jp.forEach(t),zu=r(e),nt=l(e,"DIV",{class:!0});var kp=T(nt);m(ma.$$.fragment,kp),D_=r(kp),od=l(kp,"P",{"data-svelte-h":!0}),y(od)!=="svelte-q5v59n"&&(od.innerHTML=nM),Q_=r(kp),rd=l(kp,"DIV",{class:!0});var Lv=T(rd);m(ua.$$.fragment,Lv),Lv.forEach(t),kp.forEach(t),Wu=r(e),m(ga.$$.fragment,e),Vu=r(e),ha=l(e,"P",{"data-svelte-h":!0}),y(ha)!=="svelte-u9wl5y"&&(ha.innerHTML=oM),Lu=r(e),U=l(e,"DIV",{class:!0});var I=T(U);m(fa.$$.fragment,I),Y_=r(I),ad=l(I,"P",{"data-svelte-h":!0}),y(ad)!=="svelte-1kh5y5v"&&(ad.textContent=rM),A_=r(I),ld=l(I,"P",{"data-svelte-h":!0}),y(ld)!=="svelte-1ygkifj"&&(ld.textContent=aM),O_=r(I),m(Js.$$.fragment,I),K_=r(I),id=l(I,"P",{"data-svelte-h":!0}),y(id)!=="svelte-7kbd1a"&&(id.textContent=lM),eb=r(I),xs=l(I,"DIV",{class:!0});var ng=T(xs);m(_a.$$.fragment,ng),tb=r(ng),cd=l(ng,"P",{"data-svelte-h":!0}),y(cd)!=="svelte-691079"&&(cd.textContent=iM),ng.forEach(t),sb=r(I),Us=l(I,"DIV",{class:!0});var og=T(Us);m(ba.$$.fragment,og),nb=r(og),dd=l(og,"P",{"data-svelte-h":!0}),y(dd)!=="svelte-dtkk01"&&(dd.textContent=cM),og.forEach(t),ob=r(I),Bs=l(I,"DIV",{class:!0});var rg=T(Bs);m(ya.$$.fragment,rg),rb=r(rg),pd=l(rg,"P",{"data-svelte-h":!0}),y(pd)!=="svelte-11pa7k0"&&(pd.textContent=dM),rg.forEach(t),ab=r(I),Is=l(I,"DIV",{class:!0});var ag=T(Is);m(Ta.$$.fragment,ag),lb=r(ag),md=l(ag,"P",{"data-svelte-h":!0}),y(md)!=="svelte-57vcuk"&&(md.innerHTML=pM),ag.forEach(t),ib=r(I),Zs=l(I,"DIV",{class:!0});var lg=T(Zs);m(Ma.$$.fragment,lg),cb=r(lg),ud=l(lg,"P",{"data-svelte-h":!0}),y(ud)!=="svelte-e342dt"&&(ud.textContent=mM),lg.forEach(t),db=r(I),zs=l(I,"DIV",{class:!0});var ig=T(zs);m(va.$$.fragment,ig),pb=r(ig),gd=l(ig,"P",{"data-svelte-h":!0}),y(gd)!=="svelte-vbd5xj"&&(gd.textContent=uM),ig.forEach(t),mb=r(I),mt=l(I,"DIV",{class:!0});var $p=T(mt);m(wa.$$.fragment,$p),ub=r($p),hd=l($p,"P",{"data-svelte-h":!0}),y(hd)!=="svelte-1c2dshy"&&(hd.innerHTML=gM),gb=r($p),fd=l($p,"P",{"data-svelte-h":!0}),y(fd)!=="svelte-1qvu1un"&&(fd.textContent=hM),$p.forEach(t),I.forEach(t),Fu=r(e),Ft=l(e,"DIV",{class:!0});var cg=T(Ft);m(ja.$$.fragment,cg),hb=r(cg),_d=l(cg,"P",{"data-svelte-h":!0}),y(_d)!=="svelte-1xxtyjb"&&(_d.innerHTML=fM),cg.forEach(t),Cu=r(e),Ct=l(e,"DIV",{class:!0});var dg=T(Ct);m(ka.$$.fragment,dg),fb=r(dg),bd=l(dg,"P",{"data-svelte-h":!0}),y(bd)!=="svelte-6ibw78"&&(bd.innerHTML=_M),dg.forEach(t),Gu=r(e),ge=l(e,"DIV",{class:!0});var en=T(ge);m($a.$$.fragment,en),_b=r(en),yd=l(en,"P",{"data-svelte-h":!0}),y(yd)!=="svelte-rxlesw"&&(yd.textContent=bM),bb=r(en),L=l(en,"DIV",{class:!0});var Te=T(L);m(Ja.$$.fragment,Te),yb=r(Te),Td=l(Te,"P",{"data-svelte-h":!0}),y(Td)!=="svelte-15hhlou"&&(Td.textContent=yM),Tb=r(Te),Md=l(Te,"P",{"data-svelte-h":!0}),y(Md)!=="svelte-x0d0uq"&&(Md.innerHTML=TM),Mb=r(Te),vd=l(Te,"P",{"data-svelte-h":!0}),y(vd)!=="svelte-1w36vm3"&&(vd.innerHTML=MM),vb=r(Te),wd=l(Te,"P",{"data-svelte-h":!0}),y(wd)!=="svelte-1niq0qw"&&(wd.innerHTML=vM),wb=r(Te),jd=l(Te,"P",{"data-svelte-h":!0}),y(jd)!=="svelte-af4g6f"&&(jd.textContent=wM),Te.forEach(t),jb=r(en),Ws=l(en,"DIV",{class:!0});var pg=T(Ws);m(xa.$$.fragment,pg),kb=r(pg),kd=l(pg,"P",{"data-svelte-h":!0}),y(kd)!=="svelte-eab6jp"&&(kd.textContent=jM),pg.forEach(t),en.forEach(t),Xu=r(e),m(Ua.$$.fragment,e),Ru=r(e),he=l(e,"DIV",{class:!0});var tn=T(he);m(Ba.$$.fragment,tn),$b=r(tn),$d=l(tn,"P",{"data-svelte-h":!0}),y($d)!=="svelte-31krhn"&&($d.innerHTML=kM),Jb=r(tn),Jd=l(tn,"DIV",{class:!0});var Fv=T(Jd);m(Ia.$$.fragment,Fv),Fv.forEach(t),xb=r(tn),xd=l(tn,"DIV",{class:!0});var Cv=T(xd);m(Za.$$.fragment,Cv),Cv.forEach(t),tn.forEach(t),Nu=r(e),V=l(e,"DIV",{class:!0});var Me=T(V);m(za.$$.fragment,Me),Ub=r(Me),Ud=l(Me,"P",{"data-svelte-h":!0}),y(Ud)!=="svelte-eh7t54"&&(Ud.innerHTML=$M),Bb=r(Me),Bd=l(Me,"P",{"data-svelte-h":!0}),y(Bd)!=="svelte-19qrwo1"&&(Bd.innerHTML=JM),Ib=r(Me),Id=l(Me,"P",{"data-svelte-h":!0}),y(Id)!=="svelte-l79sbt"&&(Id.innerHTML=xM),Zb=r(Me),Zd=l(Me,"DIV",{class:!0});var Gv=T(Zd);m(Wa.$$.fragment,Gv),Gv.forEach(t),zb=r(Me),zd=l(Me,"DIV",{class:!0});var Xv=T(zd);m(Va.$$.fragment,Xv),Xv.forEach(t),Me.forEach(t),Eu=r(e),fe=l(e,"DIV",{class:!0});var sn=T(fe);m(La.$$.fragment,sn),Wb=r(sn),Wd=l(sn,"P",{"data-svelte-h":!0}),y(Wd)!=="svelte-1s1swef"&&(Wd.innerHTML=UM),Vb=r(sn),Vd=l(sn,"DIV",{class:!0});var Rv=T(Vd);m(Fa.$$.fragment,Rv),Rv.forEach(t),Lb=r(sn),Ld=l(sn,"DIV",{class:!0});var Nv=T(Ld);m(Ca.$$.fragment,Nv),Nv.forEach(t),sn.forEach(t),Su=r(e),m(Ga.$$.fragment,e),qu=r(e),ot=l(e,"DIV",{class:!0});var Jp=T(ot);m(Xa.$$.fragment,Jp),Fb=r(Jp),Fd=l(Jp,"P",{"data-svelte-h":!0}),y(Fd)!=="svelte-1aiwpx2"&&(Fd.textContent=BM),Cb=r(Jp),Cd=l(Jp,"P",{"data-svelte-h":!0}),y(Cd)!=="svelte-ts4ue3"&&(Cd.innerHTML=IM),Jp.forEach(t),Hu=r(e),rt=l(e,"DIV",{class:!0});var xp=T(rt);m(Ra.$$.fragment,xp),Gb=r(xp),Gd=l(xp,"P",{"data-svelte-h":!0}),y(Gd)!=="svelte-1aiwpx2"&&(Gd.textContent=ZM),Xb=r(xp),Xd=l(xp,"P",{"data-svelte-h":!0}),y(Xd)!=="svelte-ts4ue3"&&(Xd.innerHTML=zM),xp.forEach(t),Pu=r(e),m(Na.$$.fragment,e),Du=r(e),Z=l(e,"DIV",{class:!0});var Q=T(Z);m(Ea.$$.fragment,Q),Rb=r(Q),Rd=l(Q,"P",{"data-svelte-h":!0}),y(Rd)!=="svelte-5jvlz5"&&(Rd.textContent=WM),Nb=r(Q),m(Vs.$$.fragment,Q),Eb=r(Q),m(Ls.$$.fragment,Q),Sb=r(Q),Fs=l(Q,"DIV",{class:!0});var mg=T(Fs);m(Sa.$$.fragment,mg),qb=r(mg),Nd=l(mg,"P",{"data-svelte-h":!0}),y(Nd)!=="svelte-10d94rs"&&(Nd.textContent=VM),mg.forEach(t),Hb=r(Q),Cs=l(Q,"DIV",{class:!0});var ug=T(Cs);m(qa.$$.fragment,ug),Pb=r(ug),Ed=l(ug,"P",{"data-svelte-h":!0}),y(Ed)!=="svelte-tm945r"&&(Ed.textContent=LM),ug.forEach(t),Db=r(Q),Gs=l(Q,"DIV",{class:!0});var gg=T(Gs);m(Ha.$$.fragment,gg),Qb=r(gg),Sd=l(gg,"P",{"data-svelte-h":!0}),y(Sd)!=="svelte-1i1356p"&&(Sd.textContent=FM),gg.forEach(t),Q.forEach(t),Qu=r(e),P=l(e,"DIV",{class:!0});var Mt=T(P);m(Pa.$$.fragment,Mt),Yb=r(Mt),qd=l(Mt,"P",{"data-svelte-h":!0}),y(qd)!=="svelte-190fodr"&&(qd.textContent=CM),Ab=r(Mt),m(Xs.$$.fragment,Mt),Ob=r(Mt),m(Rs.$$.fragment,Mt),Kb=r(Mt),Ns=l(Mt,"DIV",{class:!0});var hg=T(Ns);m(Da.$$.fragment,hg),ey=r(hg),Hd=l(hg,"P",{"data-svelte-h":!0}),y(Hd)!=="svelte-16i5iz"&&(Hd.textContent=GM),hg.forEach(t),Mt.forEach(t),Yu=r(e),Up=l(e,"P",{}),T(Up).forEach(t),this.h()},h(){M(c,"name","hf:doc:metadata"),M(c,"content",Zw),M(vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ut,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(It,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(St,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ll,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Nl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Sl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Dl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Yl,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ol,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ei,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(li,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ci,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ui,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_i,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ki,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Wi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Li,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ci,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ei,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Hi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qi,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ai,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ki,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(js,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(cc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(pc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(uc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(hc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(_c,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(yc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(wc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(kc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Uc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ic,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ks,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($s,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Rc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ec,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(qc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Pc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Qc,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ac,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ed,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(td,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Us,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Bs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Is,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(mt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ft,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ct,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ws,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(xd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Zd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(zd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Vd,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ld,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Fs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Cs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Gs,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ns,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){s(document.head,c),d(e,k,i),d(e,b,i),d(e,_,i),u(w,e,i),d(e,n,i),d(e,j,i),d(e,Cp,i),d(e,on,i),d(e,Gp,i),u(rn,e,i),d(e,Xp,i),d(e,an,i),d(e,Rp,i),d(e,ln,i),d(e,Np,i),u(cn,e,i),d(e,Ep,i),d(e,dn,i),d(e,Sp,i),d(e,pn,i),d(e,qp,i),d(e,mn,i),d(e,Hp,i),d(e,un,i),d(e,Pp,i),d(e,gn,i),d(e,Dp,i),u(hn,e,i),d(e,Qp,i),d(e,fn,i),d(e,Yp,i),d(e,_n,i),d(e,Ap,i),d(e,bn,i),d(e,Op,i),u(yn,e,i),d(e,Kp,i),d(e,vt,i),u(Tn,vt,null),s(vt,fg),s(vt,ml),d(e,em,i),d(e,wt,i),u(Mn,wt,null),s(wt,_g),s(wt,ul),d(e,tm,i),d(e,jt,i),u(vn,jt,null),s(jt,bg),s(jt,gl),d(e,sm,i),d(e,kt,i),u(wn,kt,null),s(kt,yg),s(kt,hl),d(e,nm,i),u(jn,e,i),d(e,om,i),d(e,$t,i),u(kn,$t,null),s($t,Tg),s($t,fl),d(e,rm,i),d(e,Jt,i),u($n,Jt,null),s(Jt,Mg),s(Jt,_l),d(e,am,i),d(e,xt,i),u(Jn,xt,null),s(xt,vg),s(xt,bl),d(e,lm,i),d(e,Ut,i),u(xn,Ut,null),s(Ut,wg),s(Ut,yl),d(e,im,i),d(e,Bt,i),u(Un,Bt,null),s(Bt,jg),s(Bt,Tl),d(e,cm,i),d(e,It,i),u(Bn,It,null),s(It,kg),s(It,Ml),d(e,dm,i),d(e,Zt,i),u(In,Zt,null),s(Zt,$g),s(Zt,vl),d(e,pm,i),d(e,zt,i),u(Zn,zt,null),s(zt,Jg),s(zt,wl),d(e,mm,i),d(e,Wt,i),u(zn,Wt,null),s(Wt,xg),s(Wt,jl),d(e,um,i),d(e,Vt,i),u(Wn,Vt,null),s(Vt,Ug),s(Vt,kl),d(e,gm,i),u(Vn,e,i),d(e,hm,i),d(e,ve,i),u(Ln,ve,null),s(ve,Bg),s(ve,$l),s(ve,Ig),s(ve,Nt),u(Fn,Nt,null),s(Nt,Zg),s(Nt,Jl),d(e,fm,i),d(e,we,i),u(Cn,we,null),s(we,zg),s(we,xl),s(we,Wg),s(we,Et),u(Gn,Et,null),s(Et,Vg),s(Et,Ul),d(e,_m,i),d(e,je,i),u(Xn,je,null),s(je,Lg),s(je,Bl),s(je,Fg),s(je,St),u(Rn,St,null),s(St,Cg),s(St,Il),d(e,bm,i),u(Nn,e,i),d(e,ym,i),d(e,En,i),d(e,Tm,i),u(Sn,e,i),d(e,Mm,i),d(e,A,i),u(qn,A,null),s(A,Gg),s(A,Zl),s(A,Xg),u(qt,A,null),s(A,Rg),s(A,zl),u(Hn,zl,null),d(e,vm,i),d(e,z,i),u(Pn,z,null),s(z,Ng),s(z,Wl),s(z,Eg),s(z,Vl),s(z,Sg),u(Ht,z,null),s(z,qg),u(Pt,z,null),s(z,Hg),s(z,Ll),u(Dn,Ll,null),d(e,wm,i),d(e,F,i),u(Qn,F,null),s(F,Pg),s(F,Fl),s(F,Dg),s(F,Cl),s(F,Qg),u(Dt,F,null),s(F,Yg),s(F,Gl),u(Yn,Gl,null),d(e,jm,i),d(e,C,i),u(An,C,null),s(C,Ag),s(C,Xl),s(C,Og),s(C,Rl),s(C,Kg),u(Qt,C,null),s(C,eh),s(C,Nl),u(On,Nl,null),d(e,km,i),d(e,O,i),u(Kn,O,null),s(O,th),s(O,El),s(O,sh),u(Yt,O,null),s(O,nh),s(O,Sl),u(eo,Sl,null),d(e,$m,i),d(e,K,i),u(to,K,null),s(K,oh),s(K,ql),s(K,rh),u(At,K,null),s(K,ah),s(K,Hl),u(so,Hl,null),d(e,Jm,i),d(e,ee,i),u(no,ee,null),s(ee,lh),s(ee,Pl),s(ee,ih),u(Ot,ee,null),s(ee,ch),s(ee,Dl),u(oo,Dl,null),d(e,xm,i),d(e,te,i),u(ro,te,null),s(te,dh),s(te,Ql),s(te,ph),u(Kt,te,null),s(te,mh),s(te,Yl),u(ao,Yl,null),d(e,Um,i),d(e,se,i),u(lo,se,null),s(se,uh),s(se,Al),s(se,gh),u(es,se,null),s(se,hh),s(se,Ol),u(io,Ol,null),d(e,Bm,i),d(e,ne,i),u(co,ne,null),s(ne,fh),s(ne,Kl),s(ne,_h),u(ts,ne,null),s(ne,bh),s(ne,ei),u(po,ei,null),d(e,Im,i),d(e,W,i),u(mo,W,null),s(W,yh),s(W,ti),s(W,Th),s(W,si),s(W,Mh),s(W,ni),s(W,vh),u(ss,W,null),s(W,wh),s(W,oi),u(uo,oi,null),d(e,Zm,i),d(e,oe,i),u(go,oe,null),s(oe,jh),s(oe,ri),s(oe,kh),s(oe,ai),s(oe,$h),s(oe,li),u(ho,li,null),d(e,zm,i),d(e,re,i),u(fo,re,null),s(re,Jh),s(re,ii),s(re,xh),u(ns,re,null),s(re,Uh),s(re,ci),u(_o,ci,null),d(e,Wm,i),d(e,ke,i),u(bo,ke,null),s(ke,Bh),s(ke,di),s(ke,Ih),s(ke,pi),u(yo,pi,null),d(e,Vm,i),d(e,$e,i),u(To,$e,null),s($e,Zh),s($e,mi),s($e,zh),s($e,ui),u(Mo,ui,null),d(e,Lm,i),d(e,Je,i),u(vo,Je,null),s(Je,Wh),s(Je,gi),s(Je,Vh),s(Je,hi),u(wo,hi,null),d(e,Fm,i),d(e,ae,i),u(jo,ae,null),s(ae,Lh),s(ae,fi),s(ae,Fh),u(os,ae,null),s(ae,Ch),s(ae,_i),u(ko,_i,null),d(e,Cm,i),d(e,le,i),u($o,le,null),s(le,Gh),s(le,bi),s(le,Xh),u(rs,le,null),s(le,Rh),s(le,yi),u(Jo,yi,null),d(e,Gm,i),d(e,G,i),u(xo,G,null),s(G,Nh),s(G,Ti),s(G,Eh),u(as,G,null),s(G,Sh),u(ls,G,null),s(G,qh),s(G,Mi),u(Uo,Mi,null),d(e,Xm,i),d(e,X,i),u(Bo,X,null),s(X,Hh),s(X,vi),s(X,Ph),u(is,X,null),s(X,Dh),u(cs,X,null),s(X,Qh),s(X,wi),u(Io,wi,null),d(e,Rm,i),d(e,ie,i),u(Zo,ie,null),s(ie,Yh),s(ie,ji),s(ie,Ah),u(ds,ie,null),s(ie,Oh),s(ie,ki),u(zo,ki,null),d(e,Nm,i),d(e,R,i),u(Wo,R,null),s(R,Kh),s(R,$i),s(R,ef),s(R,Ji),s(R,tf),u(ps,R,null),s(R,sf),s(R,xi),u(Vo,xi,null),d(e,Em,i),d(e,N,i),u(Lo,N,null),s(N,nf),s(N,Ui),s(N,of),u(ms,N,null),s(N,rf),u(us,N,null),s(N,af),s(N,Bi),u(Fo,Bi,null),d(e,Sm,i),d(e,ce,i),u(Co,ce,null),s(ce,lf),s(ce,Ii),s(ce,cf),u(gs,ce,null),s(ce,df),s(ce,Zi),u(Go,Zi,null),d(e,qm,i),d(e,de,i),u(Xo,de,null),s(de,pf),s(de,zi),s(de,mf),u(hs,de,null),s(de,uf),s(de,Wi),u(Ro,Wi,null),d(e,Hm,i),d(e,E,i),u(No,E,null),s(E,gf),s(E,Vi),s(E,hf),u(fs,E,null),s(E,ff),u(_s,E,null),s(E,_f),s(E,Li),u(Eo,Li,null),d(e,Pm,i),d(e,pe,i),u(So,pe,null),s(pe,bf),s(pe,Fi),s(pe,yf),u(bs,pe,null),s(pe,Tf),s(pe,Ci),u(qo,Ci,null),d(e,Dm,i),d(e,me,i),u(Ho,me,null),s(me,Mf),s(me,Gi),s(me,vf),u(ys,me,null),s(me,wf),s(me,Xi),u(Po,Xi,null),d(e,Qm,i),d(e,S,i),u(Do,S,null),s(S,jf),s(S,Ri),s(S,kf),s(S,Ni),s(S,$f),u(Ts,S,null),s(S,Jf),s(S,Ei),u(Qo,Ei,null),d(e,Ym,i),d(e,q,i),u(Yo,q,null),s(q,xf),s(q,Si),s(q,Uf),s(q,qi),s(q,Bf),u(Ms,q,null),s(q,If),s(q,Hi),u(Ao,Hi,null),d(e,Am,i),d(e,H,i),u(Oo,H,null),s(H,Zf),s(H,Pi),s(H,zf),s(H,Di),s(H,Wf),u(vs,H,null),s(H,Vf),s(H,Qi),u(Ko,Qi,null),d(e,Om,i),u(er,e,i),d(e,Km,i),d(e,xe,i),u(tr,xe,null),s(xe,Lf),s(xe,Yi),s(xe,Ff),s(xe,Ai),u(sr,Ai,null),d(e,eu,i),d(e,Ue,i),u(nr,Ue,null),s(Ue,Cf),s(Ue,Oi),s(Ue,Gf),s(Ue,Ki),u(or,Ki,null),d(e,tu,i),d(e,Be,i),u(rr,Be,null),s(Be,Xf),s(Be,ec),s(Be,Rf),s(Be,tc),u(ar,tc,null),d(e,su,i),d(e,Ie,i),u(lr,Ie,null),s(Ie,Nf),s(Ie,sc),s(Ie,Ef),s(Ie,ws),u(ir,ws,null),s(ws,Sf),s(ws,nc),d(e,nu,i),d(e,Ze,i),u(cr,Ze,null),s(Ze,qf),s(Ze,oc),s(Ze,Hf),s(Ze,rc),u(dr,rc,null),d(e,ou,i),d(e,ze,i),u(pr,ze,null),s(ze,Pf),s(ze,ac),s(ze,Df),s(ze,js),u(mr,js,null),s(js,Qf),s(js,lc),d(e,ru,i),d(e,We,i),u(ur,We,null),s(We,Yf),s(We,ic),s(We,Af),s(We,cc),u(gr,cc,null),d(e,au,i),d(e,Ve,i),u(hr,Ve,null),s(Ve,Of),s(Ve,dc),s(Ve,Kf),s(Ve,pc),u(fr,pc,null),d(e,lu,i),d(e,Le,i),u(_r,Le,null),s(Le,e_),s(Le,mc),s(Le,t_),s(Le,uc),u(br,uc,null),d(e,iu,i),d(e,Fe,i),u(yr,Fe,null),s(Fe,s_),s(Fe,gc),s(Fe,n_),s(Fe,hc),u(Tr,hc,null),d(e,cu,i),d(e,Ce,i),u(Mr,Ce,null),s(Ce,o_),s(Ce,fc),s(Ce,r_),s(Ce,_c),u(vr,_c,null),d(e,du,i),d(e,Ge,i),u(wr,Ge,null),s(Ge,a_),s(Ge,bc),s(Ge,l_),s(Ge,yc),u(jr,yc,null),d(e,pu,i),d(e,Xe,i),u(kr,Xe,null),s(Xe,i_),s(Xe,Tc),s(Xe,c_),s(Xe,Mc),u($r,Mc,null),d(e,mu,i),d(e,Re,i),u(Jr,Re,null),s(Re,d_),s(Re,vc),s(Re,p_),s(Re,wc),u(xr,wc,null),d(e,uu,i),d(e,Ne,i),u(Ur,Ne,null),s(Ne,m_),s(Ne,jc),s(Ne,u_),s(Ne,kc),u(Br,kc,null),d(e,gu,i),u(Ir,e,i),d(e,hu,i),d(e,Ee,i),u(Zr,Ee,null),s(Ee,g_),s(Ee,$c),s(Ee,h_),s(Ee,Jc),u(zr,Jc,null),d(e,fu,i),d(e,Se,i),u(Wr,Se,null),s(Se,f_),s(Se,xc),s(Se,__),s(Se,Uc),u(Vr,Uc,null),d(e,_u,i),d(e,qe,i),u(Lr,qe,null),s(qe,b_),s(qe,Bc),s(qe,y_),s(qe,Ic),u(Fr,Ic,null),d(e,bu,i),d(e,He,i),u(Cr,He,null),s(He,T_),s(He,Zc),s(He,M_),s(He,ks),u(Gr,ks,null),s(ks,v_),s(ks,zc),d(e,yu,i),d(e,Pe,i),u(Xr,Pe,null),s(Pe,w_),s(Pe,Wc),s(Pe,j_),s(Pe,Vc),u(Rr,Vc,null),d(e,Tu,i),d(e,De,i),u(Nr,De,null),s(De,k_),s(De,Lc),s(De,$_),s(De,$s),u(Er,$s,null),s($s,J_),s($s,Fc),d(e,Mu,i),d(e,Qe,i),u(Sr,Qe,null),s(Qe,x_),s(Qe,Cc),s(Qe,U_),s(Qe,Gc),u(qr,Gc,null),d(e,vu,i),d(e,Ye,i),u(Hr,Ye,null),s(Ye,B_),s(Ye,Xc),s(Ye,I_),s(Ye,Rc),u(Pr,Rc,null),d(e,wu,i),d(e,Ae,i),u(Dr,Ae,null),s(Ae,Z_),s(Ae,Nc),s(Ae,z_),s(Ae,Ec),u(Qr,Ec,null),d(e,ju,i),d(e,Oe,i),u(Yr,Oe,null),s(Oe,W_),s(Oe,Sc),s(Oe,V_),s(Oe,qc),u(Ar,qc,null),d(e,ku,i),d(e,Ke,i),u(Or,Ke,null),s(Ke,L_),s(Ke,Hc),s(Ke,F_),s(Ke,Pc),u(Kr,Pc,null),d(e,$u,i),d(e,et,i),u(ea,et,null),s(et,C_),s(et,Dc),s(et,G_),s(et,Qc),u(ta,Qc,null),d(e,Ju,i),d(e,tt,i),u(sa,tt,null),s(tt,X_),s(tt,Yc),s(tt,R_),s(tt,Ac),u(na,Ac,null),d(e,xu,i),u(oa,e,i),d(e,Uu,i),d(e,ra,i),d(e,Bu,i),d(e,ue,i),u(aa,ue,null),s(ue,N_),s(ue,Oc),s(ue,E_),s(ue,Kc),s(ue,S_),s(ue,ed),u(la,ed,null),d(e,Iu,i),d(e,Lt,i),u(ia,Lt,null),s(Lt,q_),s(Lt,td),u(ca,td,null),d(e,Zu,i),d(e,st,i),u(da,st,null),s(st,H_),s(st,sd),s(st,P_),s(st,nd),u(pa,nd,null),d(e,zu,i),d(e,nt,i),u(ma,nt,null),s(nt,D_),s(nt,od),s(nt,Q_),s(nt,rd),u(ua,rd,null),d(e,Wu,i),u(ga,e,i),d(e,Vu,i),d(e,ha,i),d(e,Lu,i),d(e,U,i),u(fa,U,null),s(U,Y_),s(U,ad),s(U,A_),s(U,ld),s(U,O_),u(Js,U,null),s(U,K_),s(U,id),s(U,eb),s(U,xs),u(_a,xs,null),s(xs,tb),s(xs,cd),s(U,sb),s(U,Us),u(ba,Us,null),s(Us,nb),s(Us,dd),s(U,ob),s(U,Bs),u(ya,Bs,null),s(Bs,rb),s(Bs,pd),s(U,ab),s(U,Is),u(Ta,Is,null),s(Is,lb),s(Is,md),s(U,ib),s(U,Zs),u(Ma,Zs,null),s(Zs,cb),s(Zs,ud),s(U,db),s(U,zs),u(va,zs,null),s(zs,pb),s(zs,gd),s(U,mb),s(U,mt),u(wa,mt,null),s(mt,ub),s(mt,hd),s(mt,gb),s(mt,fd),d(e,Fu,i),d(e,Ft,i),u(ja,Ft,null),s(Ft,hb),s(Ft,_d),d(e,Cu,i),d(e,Ct,i),u(ka,Ct,null),s(Ct,fb),s(Ct,bd),d(e,Gu,i),d(e,ge,i),u($a,ge,null),s(ge,_b),s(ge,yd),s(ge,bb),s(ge,L),u(Ja,L,null),s(L,yb),s(L,Td),s(L,Tb),s(L,Md),s(L,Mb),s(L,vd),s(L,vb),s(L,wd),s(L,wb),s(L,jd),s(ge,jb),s(ge,Ws),u(xa,Ws,null),s(Ws,kb),s(Ws,kd),d(e,Xu,i),u(Ua,e,i),d(e,Ru,i),d(e,he,i),u(Ba,he,null),s(he,$b),s(he,$d),s(he,Jb),s(he,Jd),u(Ia,Jd,null),s(he,xb),s(he,xd),u(Za,xd,null),d(e,Nu,i),d(e,V,i),u(za,V,null),s(V,Ub),s(V,Ud),s(V,Bb),s(V,Bd),s(V,Ib),s(V,Id),s(V,Zb),s(V,Zd),u(Wa,Zd,null),s(V,zb),s(V,zd),u(Va,zd,null),d(e,Eu,i),d(e,fe,i),u(La,fe,null),s(fe,Wb),s(fe,Wd),s(fe,Vb),s(fe,Vd),u(Fa,Vd,null),s(fe,Lb),s(fe,Ld),u(Ca,Ld,null),d(e,Su,i),u(Ga,e,i),d(e,qu,i),d(e,ot,i),u(Xa,ot,null),s(ot,Fb),s(ot,Fd),s(ot,Cb),s(ot,Cd),d(e,Hu,i),d(e,rt,i),u(Ra,rt,null),s(rt,Gb),s(rt,Gd),s(rt,Xb),s(rt,Xd),d(e,Pu,i),u(Na,e,i),d(e,Du,i),d(e,Z,i),u(Ea,Z,null),s(Z,Rb),s(Z,Rd),s(Z,Nb),u(Vs,Z,null),s(Z,Eb),u(Ls,Z,null),s(Z,Sb),s(Z,Fs),u(Sa,Fs,null),s(Fs,qb),s(Fs,Nd),s(Z,Hb),s(Z,Cs),u(qa,Cs,null),s(Cs,Pb),s(Cs,Ed),s(Z,Db),s(Z,Gs),u(Ha,Gs,null),s(Gs,Qb),s(Gs,Sd),d(e,Qu,i),d(e,P,i),u(Pa,P,null),s(P,Yb),s(P,qd),s(P,Ab),u(Xs,P,null),s(P,Ob),u(Rs,P,null),s(P,Kb),s(P,Ns),u(Da,Ns,null),s(Ns,ey),s(Ns,Hd),d(e,Yu,i),d(e,Up,i),Au=!0},p(e,[i]){const Qa={};i&2&&(Qa.$$scope={dirty:i,ctx:e}),qt.$set(Qa);const Ya={};i&2&&(Ya.$$scope={dirty:i,ctx:e}),Ht.$set(Ya);const Aa={};i&2&&(Aa.$$scope={dirty:i,ctx:e}),Pt.$set(Aa);const Oa={};i&2&&(Oa.$$scope={dirty:i,ctx:e}),Dt.$set(Oa);const Ka={};i&2&&(Ka.$$scope={dirty:i,ctx:e}),Qt.$set(Ka);const el={};i&2&&(el.$$scope={dirty:i,ctx:e}),Yt.$set(el);const tl={};i&2&&(tl.$$scope={dirty:i,ctx:e}),At.$set(tl);const sl={};i&2&&(sl.$$scope={dirty:i,ctx:e}),Ot.$set(sl);const nl={};i&2&&(nl.$$scope={dirty:i,ctx:e}),Kt.$set(nl);const ol={};i&2&&(ol.$$scope={dirty:i,ctx:e}),es.$set(ol);const rl={};i&2&&(rl.$$scope={dirty:i,ctx:e}),ts.$set(rl);const al={};i&2&&(al.$$scope={dirty:i,ctx:e}),ss.$set(al);const ll={};i&2&&(ll.$$scope={dirty:i,ctx:e}),ns.$set(ll);const il={};i&2&&(il.$$scope={dirty:i,ctx:e}),os.$set(il);const Gt={};i&2&&(Gt.$$scope={dirty:i,ctx:e}),rs.$set(Gt);const cl={};i&2&&(cl.$$scope={dirty:i,ctx:e}),as.$set(cl);const Xt={};i&2&&(Xt.$$scope={dirty:i,ctx:e}),ls.$set(Xt);const dl={};i&2&&(dl.$$scope={dirty:i,ctx:e}),is.$set(dl);const Rt={};i&2&&(Rt.$$scope={dirty:i,ctx:e}),cs.$set(Rt);const pl={};i&2&&(pl.$$scope={dirty:i,ctx:e}),ds.$set(pl);const at={};i&2&&(at.$$scope={dirty:i,ctx:e}),ps.$set(at);const Bp={};i&2&&(Bp.$$scope={dirty:i,ctx:e}),ms.$set(Bp);const D={};i&2&&(D.$$scope={dirty:i,ctx:e}),us.$set(D);const Ip={};i&2&&(Ip.$$scope={dirty:i,ctx:e}),gs.$set(Ip);const _e={};i&2&&(_e.$$scope={dirty:i,ctx:e}),hs.$set(_e);const Zp={};i&2&&(Zp.$$scope={dirty:i,ctx:e}),fs.$set(Zp);const be={};i&2&&(be.$$scope={dirty:i,ctx:e}),_s.$set(be);const zp={};i&2&&(zp.$$scope={dirty:i,ctx:e}),bs.$set(zp);const lt={};i&2&&(lt.$$scope={dirty:i,ctx:e}),ys.$set(lt);const Wp={};i&2&&(Wp.$$scope={dirty:i,ctx:e}),Ts.$set(Wp);const it={};i&2&&(it.$$scope={dirty:i,ctx:e}),Ms.$set(it);const Vp={};i&2&&(Vp.$$scope={dirty:i,ctx:e}),vs.$set(Vp);const ct={};i&2&&(ct.$$scope={dirty:i,ctx:e}),Js.$set(ct);const Lp={};i&2&&(Lp.$$scope={dirty:i,ctx:e}),Vs.$set(Lp);const dt={};i&2&&(dt.$$scope={dirty:i,ctx:e}),Ls.$set(dt);const Fp={};i&2&&(Fp.$$scope={dirty:i,ctx:e}),Xs.$set(Fp);const pt={};i&2&&(pt.$$scope={dirty:i,ctx:e}),Rs.$set(pt)},i(e){Au||(g(w.$$.fragment,e),g(rn.$$.fragment,e),g(cn.$$.fragment,e),g(hn.$$.fragment,e),g(yn.$$.fragment,e),g(Tn.$$.fragment,e),g(Mn.$$.fragment,e),g(vn.$$.fragment,e),g(wn.$$.fragment,e),g(jn.$$.fragment,e),g(kn.$$.fragment,e),g($n.$$.fragment,e),g(Jn.$$.fragment,e),g(xn.$$.fragment,e),g(Un.$$.fragment,e),g(Bn.$$.fragment,e),g(In.$$.fragment,e),g(Zn.$$.fragment,e),g(zn.$$.fragment,e),g(Wn.$$.fragment,e),g(Vn.$$.fragment,e),g(Ln.$$.fragment,e),g(Fn.$$.fragment,e),g(Cn.$$.fragment,e),g(Gn.$$.fragment,e),g(Xn.$$.fragment,e),g(Rn.$$.fragment,e),g(Nn.$$.fragment,e),g(Sn.$$.fragment,e),g(qn.$$.fragment,e),g(qt.$$.fragment,e),g(Hn.$$.fragment,e),g(Pn.$$.fragment,e),g(Ht.$$.fragment,e),g(Pt.$$.fragment,e),g(Dn.$$.fragment,e),g(Qn.$$.fragment,e),g(Dt.$$.fragment,e),g(Yn.$$.fragment,e),g(An.$$.fragment,e),g(Qt.$$.fragment,e),g(On.$$.fragment,e),g(Kn.$$.fragment,e),g(Yt.$$.fragment,e),g(eo.$$.fragment,e),g(to.$$.fragment,e),g(At.$$.fragment,e),g(so.$$.fragment,e),g(no.$$.fragment,e),g(Ot.$$.fragment,e),g(oo.$$.fragment,e),g(ro.$$.fragment,e),g(Kt.$$.fragment,e),g(ao.$$.fragment,e),g(lo.$$.fragment,e),g(es.$$.fragment,e),g(io.$$.fragment,e),g(co.$$.fragment,e),g(ts.$$.fragment,e),g(po.$$.fragment,e),g(mo.$$.fragment,e),g(ss.$$.fragment,e),g(uo.$$.fragment,e),g(go.$$.fragment,e),g(ho.$$.fragment,e),g(fo.$$.fragment,e),g(ns.$$.fragment,e),g(_o.$$.fragment,e),g(bo.$$.fragment,e),g(yo.$$.fragment,e),g(To.$$.fragment,e),g(Mo.$$.fragment,e),g(vo.$$.fragment,e),g(wo.$$.fragment,e),g(jo.$$.fragment,e),g(os.$$.fragment,e),g(ko.$$.fragment,e),g($o.$$.fragment,e),g(rs.$$.fragment,e),g(Jo.$$.fragment,e),g(xo.$$.fragment,e),g(as.$$.fragment,e),g(ls.$$.fragment,e),g(Uo.$$.fragment,e),g(Bo.$$.fragment,e),g(is.$$.fragment,e),g(cs.$$.fragment,e),g(Io.$$.fragment,e),g(Zo.$$.fragment,e),g(ds.$$.fragment,e),g(zo.$$.fragment,e),g(Wo.$$.fragment,e),g(ps.$$.fragment,e),g(Vo.$$.fragment,e),g(Lo.$$.fragment,e),g(ms.$$.fragment,e),g(us.$$.fragment,e),g(Fo.$$.fragment,e),g(Co.$$.fragment,e),g(gs.$$.fragment,e),g(Go.$$.fragment,e),g(Xo.$$.fragment,e),g(hs.$$.fragment,e),g(Ro.$$.fragment,e),g(No.$$.fragment,e),g(fs.$$.fragment,e),g(_s.$$.fragment,e),g(Eo.$$.fragment,e),g(So.$$.fragment,e),g(bs.$$.fragment,e),g(qo.$$.fragment,e),g(Ho.$$.fragment,e),g(ys.$$.fragment,e),g(Po.$$.fragment,e),g(Do.$$.fragment,e),g(Ts.$$.fragment,e),g(Qo.$$.fragment,e),g(Yo.$$.fragment,e),g(Ms.$$.fragment,e),g(Ao.$$.fragment,e),g(Oo.$$.fragment,e),g(vs.$$.fragment,e),g(Ko.$$.fragment,e),g(er.$$.fragment,e),g(tr.$$.fragment,e),g(sr.$$.fragment,e),g(nr.$$.fragment,e),g(or.$$.fragment,e),g(rr.$$.fragment,e),g(ar.$$.fragment,e),g(lr.$$.fragment,e),g(ir.$$.fragment,e),g(cr.$$.fragment,e),g(dr.$$.fragment,e),g(pr.$$.fragment,e),g(mr.$$.fragment,e),g(ur.$$.fragment,e),g(gr.$$.fragment,e),g(hr.$$.fragment,e),g(fr.$$.fragment,e),g(_r.$$.fragment,e),g(br.$$.fragment,e),g(yr.$$.fragment,e),g(Tr.$$.fragment,e),g(Mr.$$.fragment,e),g(vr.$$.fragment,e),g(wr.$$.fragment,e),g(jr.$$.fragment,e),g(kr.$$.fragment,e),g($r.$$.fragment,e),g(Jr.$$.fragment,e),g(xr.$$.fragment,e),g(Ur.$$.fragment,e),g(Br.$$.fragment,e),g(Ir.$$.fragment,e),g(Zr.$$.fragment,e),g(zr.$$.fragment,e),g(Wr.$$.fragment,e),g(Vr.$$.fragment,e),g(Lr.$$.fragment,e),g(Fr.$$.fragment,e),g(Cr.$$.fragment,e),g(Gr.$$.fragment,e),g(Xr.$$.fragment,e),g(Rr.$$.fragment,e),g(Nr.$$.fragment,e),g(Er.$$.fragment,e),g(Sr.$$.fragment,e),g(qr.$$.fragment,e),g(Hr.$$.fragment,e),g(Pr.$$.fragment,e),g(Dr.$$.fragment,e),g(Qr.$$.fragment,e),g(Yr.$$.fragment,e),g(Ar.$$.fragment,e),g(Or.$$.fragment,e),g(Kr.$$.fragment,e),g(ea.$$.fragment,e),g(ta.$$.fragment,e),g(sa.$$.fragment,e),g(na.$$.fragment,e),g(oa.$$.fragment,e),g(aa.$$.fragment,e),g(la.$$.fragment,e),g(ia.$$.fragment,e),g(ca.$$.fragment,e),g(da.$$.fragment,e),g(pa.$$.fragment,e),g(ma.$$.fragment,e),g(ua.$$.fragment,e),g(ga.$$.fragment,e),g(fa.$$.fragment,e),g(Js.$$.fragment,e),g(_a.$$.fragment,e),g(ba.$$.fragment,e),g(ya.$$.fragment,e),g(Ta.$$.fragment,e),g(Ma.$$.fragment,e),g(va.$$.fragment,e),g(wa.$$.fragment,e),g(ja.$$.fragment,e),g(ka.$$.fragment,e),g($a.$$.fragment,e),g(Ja.$$.fragment,e),g(xa.$$.fragment,e),g(Ua.$$.fragment,e),g(Ba.$$.fragment,e),g(Ia.$$.fragment,e),g(Za.$$.fragment,e),g(za.$$.fragment,e),g(Wa.$$.fragment,e),g(Va.$$.fragment,e),g(La.$$.fragment,e),g(Fa.$$.fragment,e),g(Ca.$$.fragment,e),g(Ga.$$.fragment,e),g(Xa.$$.fragment,e),g(Ra.$$.fragment,e),g(Na.$$.fragment,e),g(Ea.$$.fragment,e),g(Vs.$$.fragment,e),g(Ls.$$.fragment,e),g(Sa.$$.fragment,e),g(qa.$$.fragment,e),g(Ha.$$.fragment,e),g(Pa.$$.fragment,e),g(Xs.$$.fragment,e),g(Rs.$$.fragment,e),g(Da.$$.fragment,e),Au=!0)},o(e){h(w.$$.fragment,e),h(rn.$$.fragment,e),h(cn.$$.fragment,e),h(hn.$$.fragment,e),h(yn.$$.fragment,e),h(Tn.$$.fragment,e),h(Mn.$$.fragment,e),h(vn.$$.fragment,e),h(wn.$$.fragment,e),h(jn.$$.fragment,e),h(kn.$$.fragment,e),h($n.$$.fragment,e),h(Jn.$$.fragment,e),h(xn.$$.fragment,e),h(Un.$$.fragment,e),h(Bn.$$.fragment,e),h(In.$$.fragment,e),h(Zn.$$.fragment,e),h(zn.$$.fragment,e),h(Wn.$$.fragment,e),h(Vn.$$.fragment,e),h(Ln.$$.fragment,e),h(Fn.$$.fragment,e),h(Cn.$$.fragment,e),h(Gn.$$.fragment,e),h(Xn.$$.fragment,e),h(Rn.$$.fragment,e),h(Nn.$$.fragment,e),h(Sn.$$.fragment,e),h(qn.$$.fragment,e),h(qt.$$.fragment,e),h(Hn.$$.fragment,e),h(Pn.$$.fragment,e),h(Ht.$$.fragment,e),h(Pt.$$.fragment,e),h(Dn.$$.fragment,e),h(Qn.$$.fragment,e),h(Dt.$$.fragment,e),h(Yn.$$.fragment,e),h(An.$$.fragment,e),h(Qt.$$.fragment,e),h(On.$$.fragment,e),h(Kn.$$.fragment,e),h(Yt.$$.fragment,e),h(eo.$$.fragment,e),h(to.$$.fragment,e),h(At.$$.fragment,e),h(so.$$.fragment,e),h(no.$$.fragment,e),h(Ot.$$.fragment,e),h(oo.$$.fragment,e),h(ro.$$.fragment,e),h(Kt.$$.fragment,e),h(ao.$$.fragment,e),h(lo.$$.fragment,e),h(es.$$.fragment,e),h(io.$$.fragment,e),h(co.$$.fragment,e),h(ts.$$.fragment,e),h(po.$$.fragment,e),h(mo.$$.fragment,e),h(ss.$$.fragment,e),h(uo.$$.fragment,e),h(go.$$.fragment,e),h(ho.$$.fragment,e),h(fo.$$.fragment,e),h(ns.$$.fragment,e),h(_o.$$.fragment,e),h(bo.$$.fragment,e),h(yo.$$.fragment,e),h(To.$$.fragment,e),h(Mo.$$.fragment,e),h(vo.$$.fragment,e),h(wo.$$.fragment,e),h(jo.$$.fragment,e),h(os.$$.fragment,e),h(ko.$$.fragment,e),h($o.$$.fragment,e),h(rs.$$.fragment,e),h(Jo.$$.fragment,e),h(xo.$$.fragment,e),h(as.$$.fragment,e),h(ls.$$.fragment,e),h(Uo.$$.fragment,e),h(Bo.$$.fragment,e),h(is.$$.fragment,e),h(cs.$$.fragment,e),h(Io.$$.fragment,e),h(Zo.$$.fragment,e),h(ds.$$.fragment,e),h(zo.$$.fragment,e),h(Wo.$$.fragment,e),h(ps.$$.fragment,e),h(Vo.$$.fragment,e),h(Lo.$$.fragment,e),h(ms.$$.fragment,e),h(us.$$.fragment,e),h(Fo.$$.fragment,e),h(Co.$$.fragment,e),h(gs.$$.fragment,e),h(Go.$$.fragment,e),h(Xo.$$.fragment,e),h(hs.$$.fragment,e),h(Ro.$$.fragment,e),h(No.$$.fragment,e),h(fs.$$.fragment,e),h(_s.$$.fragment,e),h(Eo.$$.fragment,e),h(So.$$.fragment,e),h(bs.$$.fragment,e),h(qo.$$.fragment,e),h(Ho.$$.fragment,e),h(ys.$$.fragment,e),h(Po.$$.fragment,e),h(Do.$$.fragment,e),h(Ts.$$.fragment,e),h(Qo.$$.fragment,e),h(Yo.$$.fragment,e),h(Ms.$$.fragment,e),h(Ao.$$.fragment,e),h(Oo.$$.fragment,e),h(vs.$$.fragment,e),h(Ko.$$.fragment,e),h(er.$$.fragment,e),h(tr.$$.fragment,e),h(sr.$$.fragment,e),h(nr.$$.fragment,e),h(or.$$.fragment,e),h(rr.$$.fragment,e),h(ar.$$.fragment,e),h(lr.$$.fragment,e),h(ir.$$.fragment,e),h(cr.$$.fragment,e),h(dr.$$.fragment,e),h(pr.$$.fragment,e),h(mr.$$.fragment,e),h(ur.$$.fragment,e),h(gr.$$.fragment,e),h(hr.$$.fragment,e),h(fr.$$.fragment,e),h(_r.$$.fragment,e),h(br.$$.fragment,e),h(yr.$$.fragment,e),h(Tr.$$.fragment,e),h(Mr.$$.fragment,e),h(vr.$$.fragment,e),h(wr.$$.fragment,e),h(jr.$$.fragment,e),h(kr.$$.fragment,e),h($r.$$.fragment,e),h(Jr.$$.fragment,e),h(xr.$$.fragment,e),h(Ur.$$.fragment,e),h(Br.$$.fragment,e),h(Ir.$$.fragment,e),h(Zr.$$.fragment,e),h(zr.$$.fragment,e),h(Wr.$$.fragment,e),h(Vr.$$.fragment,e),h(Lr.$$.fragment,e),h(Fr.$$.fragment,e),h(Cr.$$.fragment,e),h(Gr.$$.fragment,e),h(Xr.$$.fragment,e),h(Rr.$$.fragment,e),h(Nr.$$.fragment,e),h(Er.$$.fragment,e),h(Sr.$$.fragment,e),h(qr.$$.fragment,e),h(Hr.$$.fragment,e),h(Pr.$$.fragment,e),h(Dr.$$.fragment,e),h(Qr.$$.fragment,e),h(Yr.$$.fragment,e),h(Ar.$$.fragment,e),h(Or.$$.fragment,e),h(Kr.$$.fragment,e),h(ea.$$.fragment,e),h(ta.$$.fragment,e),h(sa.$$.fragment,e),h(na.$$.fragment,e),h(oa.$$.fragment,e),h(aa.$$.fragment,e),h(la.$$.fragment,e),h(ia.$$.fragment,e),h(ca.$$.fragment,e),h(da.$$.fragment,e),h(pa.$$.fragment,e),h(ma.$$.fragment,e),h(ua.$$.fragment,e),h(ga.$$.fragment,e),h(fa.$$.fragment,e),h(Js.$$.fragment,e),h(_a.$$.fragment,e),h(ba.$$.fragment,e),h(ya.$$.fragment,e),h(Ta.$$.fragment,e),h(Ma.$$.fragment,e),h(va.$$.fragment,e),h(wa.$$.fragment,e),h(ja.$$.fragment,e),h(ka.$$.fragment,e),h($a.$$.fragment,e),h(Ja.$$.fragment,e),h(xa.$$.fragment,e),h(Ua.$$.fragment,e),h(Ba.$$.fragment,e),h(Ia.$$.fragment,e),h(Za.$$.fragment,e),h(za.$$.fragment,e),h(Wa.$$.fragment,e),h(Va.$$.fragment,e),h(La.$$.fragment,e),h(Fa.$$.fragment,e),h(Ca.$$.fragment,e),h(Ga.$$.fragment,e),h(Xa.$$.fragment,e),h(Ra.$$.fragment,e),h(Na.$$.fragment,e),h(Ea.$$.fragment,e),h(Vs.$$.fragment,e),h(Ls.$$.fragment,e),h(Sa.$$.fragment,e),h(qa.$$.fragment,e),h(Ha.$$.fragment,e),h(Pa.$$.fragment,e),h(Xs.$$.fragment,e),h(Rs.$$.fragment,e),h(Da.$$.fragment,e),Au=!1},d(e){e&&(t(k),t(b),t(_),t(n),t(j),t(Cp),t(on),t(Gp),t(Xp),t(an),t(Rp),t(ln),t(Np),t(Ep),t(dn),t(Sp),t(pn),t(qp),t(mn),t(Hp),t(un),t(Pp),t(gn),t(Dp),t(Qp),t(fn),t(Yp),t(_n),t(Ap),t(bn),t(Op),t(Kp),t(vt),t(em),t(wt),t(tm),t(jt),t(sm),t(kt),t(nm),t(om),t($t),t(rm),t(Jt),t(am),t(xt),t(lm),t(Ut),t(im),t(Bt),t(cm),t(It),t(dm),t(Zt),t(pm),t(zt),t(mm),t(Wt),t(um),t(Vt),t(gm),t(hm),t(ve),t(fm),t(we),t(_m),t(je),t(bm),t(ym),t(En),t(Tm),t(Mm),t(A),t(vm),t(z),t(wm),t(F),t(jm),t(C),t(km),t(O),t($m),t(K),t(Jm),t(ee),t(xm),t(te),t(Um),t(se),t(Bm),t(ne),t(Im),t(W),t(Zm),t(oe),t(zm),t(re),t(Wm),t(ke),t(Vm),t($e),t(Lm),t(Je),t(Fm),t(ae),t(Cm),t(le),t(Gm),t(G),t(Xm),t(X),t(Rm),t(ie),t(Nm),t(R),t(Em),t(N),t(Sm),t(ce),t(qm),t(de),t(Hm),t(E),t(Pm),t(pe),t(Dm),t(me),t(Qm),t(S),t(Ym),t(q),t(Am),t(H),t(Om),t(Km),t(xe),t(eu),t(Ue),t(tu),t(Be),t(su),t(Ie),t(nu),t(Ze),t(ou),t(ze),t(ru),t(We),t(au),t(Ve),t(lu),t(Le),t(iu),t(Fe),t(cu),t(Ce),t(du),t(Ge),t(pu),t(Xe),t(mu),t(Re),t(uu),t(Ne),t(gu),t(hu),t(Ee),t(fu),t(Se),t(_u),t(qe),t(bu),t(He),t(yu),t(Pe),t(Tu),t(De),t(Mu),t(Qe),t(vu),t(Ye),t(wu),t(Ae),t(ju),t(Oe),t(ku),t(Ke),t($u),t(et),t(Ju),t(tt),t(xu),t(Uu),t(ra),t(Bu),t(ue),t(Iu),t(Lt),t(Zu),t(st),t(zu),t(nt),t(Wu),t(Vu),t(ha),t(Lu),t(U),t(Fu),t(Ft),t(Cu),t(Ct),t(Gu),t(ge),t(Xu),t(Ru),t(he),t(Nu),t(V),t(Eu),t(fe),t(Su),t(qu),t(ot),t(Hu),t(rt),t(Pu),t(Du),t(Z),t(Qu),t(P),t(Yu),t(Up)),t(c),f(w,e),f(rn,e),f(cn,e),f(hn,e),f(yn,e),f(Tn),f(Mn),f(vn),f(wn),f(jn,e),f(kn),f($n),f(Jn),f(xn),f(Un),f(Bn),f(In),f(Zn),f(zn),f(Wn),f(Vn,e),f(Ln),f(Fn),f(Cn),f(Gn),f(Xn),f(Rn),f(Nn,e),f(Sn,e),f(qn),f(qt),f(Hn),f(Pn),f(Ht),f(Pt),f(Dn),f(Qn),f(Dt),f(Yn),f(An),f(Qt),f(On),f(Kn),f(Yt),f(eo),f(to),f(At),f(so),f(no),f(Ot),f(oo),f(ro),f(Kt),f(ao),f(lo),f(es),f(io),f(co),f(ts),f(po),f(mo),f(ss),f(uo),f(go),f(ho),f(fo),f(ns),f(_o),f(bo),f(yo),f(To),f(Mo),f(vo),f(wo),f(jo),f(os),f(ko),f($o),f(rs),f(Jo),f(xo),f(as),f(ls),f(Uo),f(Bo),f(is),f(cs),f(Io),f(Zo),f(ds),f(zo),f(Wo),f(ps),f(Vo),f(Lo),f(ms),f(us),f(Fo),f(Co),f(gs),f(Go),f(Xo),f(hs),f(Ro),f(No),f(fs),f(_s),f(Eo),f(So),f(bs),f(qo),f(Ho),f(ys),f(Po),f(Do),f(Ts),f(Qo),f(Yo),f(Ms),f(Ao),f(Oo),f(vs),f(Ko),f(er,e),f(tr),f(sr),f(nr),f(or),f(rr),f(ar),f(lr),f(ir),f(cr),f(dr),f(pr),f(mr),f(ur),f(gr),f(hr),f(fr),f(_r),f(br),f(yr),f(Tr),f(Mr),f(vr),f(wr),f(jr),f(kr),f($r),f(Jr),f(xr),f(Ur),f(Br),f(Ir,e),f(Zr),f(zr),f(Wr),f(Vr),f(Lr),f(Fr),f(Cr),f(Gr),f(Xr),f(Rr),f(Nr),f(Er),f(Sr),f(qr),f(Hr),f(Pr),f(Dr),f(Qr),f(Yr),f(Ar),f(Or),f(Kr),f(ea),f(ta),f(sa),f(na),f(oa,e),f(aa),f(la),f(ia),f(ca),f(da),f(pa),f(ma),f(ua),f(ga,e),f(fa),f(Js),f(_a),f(ba),f(ya),f(Ta),f(Ma),f(va),f(wa),f(ja),f(ka),f($a),f(Ja),f(xa),f(Ua,e),f(Ba),f(Ia),f(Za),f(za),f(Wa),f(Va),f(La),f(Fa),f(Ca),f(Ga,e),f(Xa),f(Ra),f(Na,e),f(Ea),f(Vs),f(Ls),f(Sa),f(qa),f(Ha),f(Pa),f(Xs),f(Rs),f(Da)}}}const Zw='{"title":"発電用ユーティリティ","local":"発電用ユーティリティ","sections":[{"title":"出力を生成する","local":"出力を生成する","sections":[{"title":"PyTorch","local":"transformers.generation.GenerateDecoderOnlyOutput","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.generation.TFGreedySearchEncoderDecoderOutput","sections":[],"depth":3},{"title":"FLAX","local":"transformers.generation.FlaxSampleOutput","sections":[],"depth":3}],"depth":2},{"title":"LogitsProcessor","local":"logitsprocessor","sections":[{"title":"PyTorch","local":"transformers.AlternatingCodebooksLogitsProcessor","sections":[],"depth":3},{"title":"TensorFlow","local":"transformers.TFForcedBOSTokenLogitsProcessor","sections":[],"depth":3},{"title":"FLAX","local":"transformers.FlaxForcedBOSTokenLogitsProcessor","sections":[],"depth":3}],"depth":2},{"title":"StoppingCriteria","local":"transformers.StoppingCriteria","sections":[],"depth":2},{"title":"Constraints","local":"transformers.Constraint","sections":[],"depth":2},{"title":"BeamSearch","local":"transformers.BeamScorer","sections":[],"depth":2},{"title":"Utilities","local":"transformers.top_k_top_p_filtering","sections":[],"depth":2},{"title":"Streamers","local":"transformers.TextStreamer","sections":[],"depth":2}],"depth":1}';function zw($){return Sv(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rw extends qv{constructor(c){super(),Hv(this,c,zw,Iw,Ev,{})}}export{Rw as component};
