import{s as Ls,o as Ys,n as Hs}from"../chunks/scheduler.25b97de1.js";import{S as Fs,i as Ps,g as i,s as a,r,A as Xs,h as o,f as l,c as n,j as Bs,u as m,x as p,k as qs,y as Ds,a as s,v as c,d as h,t as d,w as M,m as Os,n as Ks}from"../chunks/index.d9030fc9.js";import{T as Gl}from"../chunks/Tip.baa67368.js";import{C as T}from"../chunks/CodeBlock.e6cd0d95.js";import{H as U,E as ea}from"../chunks/EditOnGithub.91d95064.js";function ta(f){let u;return{c(){u=Os(`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},l(J){u=Ks(J,`If you're fine-tuning a model for chat, in addition to setting a chat template, you should probably add any new chat
control tokens as special tokens in the tokenizer. Special tokens are never split, 
ensuring that your control tokens are always handled as single tokens rather than being tokenized in pieces. You 
should also set the tokenizer's \`eos_token\` attribute to the token that marks the end of assistant generations in your
template. This will ensure that text generation tools can correctly figure out when to stop generating text.`)},m(J,y){s(J,u,y)},d(J){J&&l(u)}}}function la(f){let u,J=`The easiest way to get started with writing Jinja templates is to take a look at some existing ones. You can use
<code>print(tokenizer.chat_template)</code> for any chat model to see what template it’s using. In general, models that support tool use have
much more complex templates than other models - so when you’re just getting started, they’re probably a bad example
to learn from! You can also take a look at the
<a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#synopsis" rel="nofollow">Jinja documentation</a> for details
of general Jinja formatting and syntax.`;return{c(){u=i("p"),u.innerHTML=J},l(y){u=o(y,"P",{"data-svelte-h":!0}),p(u)!=="svelte-qy60pj"&&(u.innerHTML=J)},m(y,w){s(y,u,w)},p:Hs,d(y){y&&l(u)}}}function sa(f){let u,J=`You can actually pass any <code>kwarg</code> to <code>apply_chat_template</code>, and it will be accessible inside the template as a variable. In general,
we recommend trying to stick to the core variables above, as it will make your model harder to use if users have
to write custom code to pass model-specific <code>kwargs</code>. However, we’re aware that this field moves quickly, so if you
have a new use-case that doesn’t fit in the core API, feel free to use a new <code>kwarg</code> for it! If a new <code>kwarg</code>
becomes common we may promote it into the core API and create a standard, documented format for it.`;return{c(){u=i("p"),u.innerHTML=J},l(y){u=o(y,"P",{"data-svelte-h":!0}),p(u)!=="svelte-cvlh0x"&&(u.innerHTML=J)},m(y,w){s(y,u,w)},p:Hs,d(y){y&&l(u)}}}function aa(f){let u,J,y,w,I,nt,b,Bl="In this page, we’ll explore more advanced techniques for working with chat templates in Transformers. Whether you’re looking to write your own templates, create custom components, or optimize your templates for efficiency, we’ll cover everything you need to take your templates to the next level. Let’s dive into the tools and strategies that will help you get the most out of your chat models.",it,x,ot,$,ql=`The chat template for a model is stored on the <code>tokenizer.chat_template</code> attribute. Let’s take a look at a <code>Zephyr</code> chat template, though note this
one is a little simplified from the actual one!`,pt,N,rt,A,Hl=`If you’ve never seen one of these before, this is a <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">Jinja template</a>.
Jinja is a templating language that allows you to write simple code that generates text. In many ways, the code and
syntax resembles Python. In pure Python, this template would look something like this:`,mt,v,ct,k,Ll="Effectively, the template does three things:",ht,Q,Yl=`<li>For each message, print the role enclosed in <code>&lt;|</code> and <code>|&gt;</code>, like <code>&lt;|user|&gt;</code> or <code>&lt;|assistant|&gt;</code>.</li> <li>Next, print the content of the message, followed by the end-of-sequence token.</li> <li>Finally, if <code>add_generation_prompt</code> is set, print the assistant token, so that the model knows to start generating
an assistant response.</li>`,dt,_,Fl=`This is a pretty simple template but Jinja gives you a lot of flexibility to do more complex things! Let’s see a Jinja
template that can format inputs similarly to the way LLaMA formats them (note that the real LLaMA template includes
handling for default system messages and slightly different system message handling in general - don’t use this one
in your actual code!)`,Mt,S,ut,Z,Pl=`Hopefully if you stare at this for a little bit you can see what this template is doing - it adds specific tokens like
<code>[INST]</code> and <code>[/INST]</code> based on the role of each message. User, assistant and system messages are clearly
distinguishable to the model because of the tokens they’re wrapped in.`,yt,z,Tt,E,Xl=`Simple, just write a jinja template and set <code>tokenizer.chat_template</code>. You may find it easier to start with an
existing template from another model and simply edit it for your needs! For example, we could take the LLaMA template
above and add ”[ASST]” and ”[/ASST]” to assistant messages:`,Jt,V,Ut,R,Dl=`Now, simply set the <code>tokenizer.chat_template</code> attribute. Next time you use <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, it will
use your new template! This attribute will be saved in the <code>tokenizer_config.json</code> file, so you can use
<a href="/docs/transformers/main/en/main_classes/model#transformers.utils.PushToHubMixin.push_to_hub">push_to_hub()</a> to upload your new template to the Hub and make sure everyone’s using the right
template for your model!`,ft,W,wt,G,Ol=`The method <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> which uses your chat template is called by the <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a> class, so
once you set the correct chat template, your model will automatically become compatible with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>.`,jt,j,gt,B,Ct,q,Kl=`Some models use different templates for different use cases. For example, they might use one template for normal chat
and another for tool-use, or retrieval-augmented generation. In these cases, <code>tokenizer.chat_template</code> is a dictionary.
This can cause some confusion, and where possible, we recommend using a single template for all use-cases. You can use
Jinja statements like <code>if tools is defined</code> and <code>{% macro %}</code> definitions to easily wrap multiple code paths in a
single template.`,It,H,es=`When a tokenizer has multiple templates, <code>tokenizer.chat_template</code> will be a <code>dict</code>, where each key is the name
of a template. The <code>apply_chat_template</code> method has special handling for certain template names: Specifically, it will
look for a template named <code>default</code> in most cases, and will raise an error if it can’t find one. However, if a template
named <code>tool_use</code> exists when the user has passed a <code>tools</code> argument, it will use that instead. To access templates
with other names, pass the name of the template you want to the <code>chat_template</code> argument of
<code>apply_chat_template()</code>.`,bt,L,ts=`We find that this can be a bit confusing for users, though - so if you’re writing a template yourself, we recommend
trying to put it all in a single template where possible!`,xt,Y,$t,F,ls=`When setting the template for a model that’s already been trained for chat, you should ensure that the template
exactly matches the message formatting that the model saw during training, or else you will probably experience
performance degradation. This is true even if you’re training the model further - you will probably get the best
performance if you keep the chat tokens constant. This is very analogous to tokenization - you generally get the
best performance for inference or fine-tuning when you precisely match the tokenization used during training.`,Nt,P,ss=`If you’re training a model from scratch, or fine-tuning a base language model for chat, on the other hand,
you have a lot of freedom to choose an appropriate template! LLMs are smart enough to learn to handle lots of different
input formats. One popular choice is the <code>ChatML</code> format, and this is a good, flexible choice for many use-cases.
It looks like this:`,At,X,vt,D,as=`If you like this one, here it is in one-liner form, ready to copy into your code. The one-liner also includes
handy support for <a href="#what-are-generation-prompts">generation prompts</a>, but note that it doesn’t add BOS or EOS tokens!
If your model expects those, they won’t be added automatically by <code>apply_chat_template</code> - in other words, the
text will be tokenized with <code>add_special_tokens=False</code>. This is to avoid potential conflicts between the template and
the <code>add_special_tokens</code> logic. If your model expects special tokens, make sure to add them to the template!`,kt,O,Qt,K,ns=`This template wraps each message in <code>&lt;|im_start|&gt;</code> and <code>&lt;|im_end|&gt;</code> tokens, and simply writes the role as a string, which
allows for flexibility in the roles you train with. The output looks like this:`,_t,ee,St,te,is=`The “user”, “system” and “assistant” roles are the standard for chat, and we recommend using them when it makes sense,
particularly if you want your model to operate well with <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. However, you are not limited
to these roles - templating is extremely flexible, and any string can be a role.`,Zt,le,zt,se,os=`If you have any chat models, you should set their <code>tokenizer.chat_template</code> attribute and test it using
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a>, then push the updated tokenizer to the Hub. This applies even if you’re
not the model owner - if you’re using a model with an empty chat template, or one that’s still using the default class
template, please open a <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> to the model repository so that this attribute can be set properly!`,Et,ae,ps=`Once the attribute is set, that’s it, you’re done! <code>tokenizer.apply_chat_template</code> will now work correctly for that
model, which means it is also automatically supported in places like <code>TextGenerationPipeline</code>!`,Vt,ne,rs=`By ensuring that models have this attribute, we can make sure that the whole community gets to use the full power of
open-source models. Formatting mismatches have been haunting the field and silently harming performance for too long -
it’s time to put an end to them!`,Rt,g,Wt,ie,ms=`Jinja templates in <code>transformers</code> are identical to Jinja templates elsewhere. The main thing to know is that
the conversation history will be accessible inside your template as a variable called <code>messages</code>.<br/>
You will be able to access <code>messages</code> in your template just like you can in Python, which means you can loop over
it with <code>{% for message in messages %}</code> or access individual messages with <code>{{ messages[0] }}</code>, for example.`,Gt,oe,cs="You can also use the following tips to write clean, efficient Jinja templates:",Bt,pe,qt,re,hs=`By default, Jinja will print any whitespace that comes before or after a block. This can be a problem for chat
templates, which generally want to be very precise with whitespace! To avoid this, we strongly recommend writing
your templates like this:`,Ht,me,Lt,ce,ds="rather than like this:",Yt,he,Ft,de,Ms=`Adding <code>-</code> will strip any whitespace that comes before the block. The second example looks innocent, but the newline
and indentation may end up being included in the output, which is probably not what you want!`,Pt,Me,Xt,ue,us=`Inside your template, you will have access several special variables. The most important of these is <code>messages</code>,
which contains the chat history as a list of message dicts. However, there are several others. Not every
variable will be used in every template. The most common other variables are:`,Dt,ye,ys="<li><code>tools</code> contains a list of tools in JSON schema format. Will be <code>None</code> or undefined if no tools are passed.</li> <li><code>documents</code> contains a list of documents in the format <code>{&quot;title&quot;: &quot;Title&quot;, &quot;contents&quot;: &quot;Contents&quot;}</code>, used for retrieval-augmented generation. Will be <code>None</code> or undefined if no documents are passed.</li> <li><code>add_generation_prompt</code> is a bool that is <code>True</code> if the user has requested a generation prompt, and <code>False</code> otherwise. If this is set, your template should add the header for an assistant message to the end of the conversation. If your model doesn’t have a specific header for assistant messages, you can ignore this flag.</li> <li><strong>Special tokens</strong> like <code>bos_token</code> and <code>eos_token</code>. These are extracted from <code>tokenizer.special_tokens_map</code>. The exact tokens available inside each template will differ depending on the parent tokenizer.</li>",Ot,C,Kt,Te,el,Je,Ts="There is also a short list of callable functions available to you inside your templates. These are:",tl,Ue,Js=`<li><code>raise_exception(msg)</code>: Raises a <code>TemplateException</code>. This is useful for debugging, and for telling users when they’re
doing something that your template doesn’t support.</li> <li><code>strftime_now(format_str)</code>: Equivalent to <code>datetime.now().strftime(format_str)</code> in Python. This is used for getting
the current date/time in a specific format, which is sometimes included in system messages.</li>`,ll,fe,sl,we,Us=`There are multiple implementations of Jinja in various languages. They generally have the same syntax,
but a key difference is that when you’re writing a template in Python you can use Python methods, such as
<code>.lower()</code> on strings or <code>.items()</code> on dicts. This will break if someone tries to use your template on a non-Python
implementation of Jinja. Non-Python implementations are particularly common in deployment environments, where JS
and Rust are very popular.`,al,je,fs=`Don’t panic, though! There are a few easy changes you can make to your templates to ensure they’re compatible across
all implementations of Jinja:`,nl,ge,ws=`<li>Replace Python methods with Jinja filters. These usually have the same name, for example <code>string.lower()</code> becomes
<code>string|lower</code>, and <code>dict.items()</code> becomes <code>dict|items</code>. One notable change is that <code>string.strip()</code> becomes <code>string|trim</code>.
See the <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/#builtin-filters" rel="nofollow">list of built-in filters</a>
in the Jinja documentation for more.</li> <li>Replace <code>True</code>, <code>False</code> and <code>None</code>, which are Python-specific, with <code>true</code>, <code>false</code> and <code>none</code>.</li> <li>Directly rendering a dict or list may give different results in other implementations (for example, string entries
might change from single-quoted to double-quoted). Adding the <code>tojson</code> filter can help to ensure consistency here.</li>`,il,Ce,ol,Ie,js=`We mentioned above that <code>add_generation_prompt</code> is a special variable that will be accessible inside your template,
and is controlled by the user setting the <code>add_generation_prompt</code> flag. If your model expects a header for
assistant messages, then your template must support adding the header when <code>add_generation_prompt</code> is set.`,pl,be,gs="Here is an example of a template that formats messages ChatML-style, with generation prompt support:",rl,xe,ml,$e,Cs=`The exact content of the assistant header will depend on your specific model, but it should always be <strong>the string
that represents the start of an assistant message</strong>, so that if the user applies your template with
<code>add_generation_prompt=True</code> and then generates text, the model will write an assistant response. Also note that some
models do not need a generation prompt, because assistant messages always begin immediately after user messages.
This is particularly common for LLaMA and Mistral models, where assistant messages begin immediately after the <code>[/INST]</code>
token that ends user messages. In these cases, the template can ignore the <code>add_generation_prompt</code> flag.`,cl,Ne,Is=`Generation prompts are important! If your model requires a generation prompt but it is not set in the template, then
model generations will likely be severely degraded, or the model may display unusual behaviour like continuing
the final user message!`,hl,Ae,dl,ve,bs=`When this feature was introduced, most templates were quite small, the Jinja equivalent of a “one-liner” script.
However, with new models and features like tool-use and RAG, some templates can be 100 lines long or more. When
writing templates like these, it’s a good idea to write them in a separate file, using a text editor. You can easily
extract a chat template to a file:`,Ml,ke,ul,Qe,xs="Or load the edited template back into the tokenizer:",yl,_e,Tl,Se,$s=`As an added bonus, when you write a long, multi-line template in a separate file, line numbers in that file will
exactly correspond to line numbers in template parsing or execution errors. This will make it much easier to
identify the source of issues.`,Jl,Ze,Ul,ze,Ns=`Although chat templates do not enforce a specific API for tools (or for anything, really), we recommend
template authors try to stick to a standard API where possible. The whole point of chat templates is to allow code
to be transferable across models, so deviating from the standard tools API means users will have to write
custom code to use tools with your model. Sometimes it’s unavoidable, but often with clever templating you can
make the standard API work!`,fl,Ee,As="Below, we’ll list the elements of the standard API, and give tips on writing templates that will work well with it.",wl,Ve,jl,Re,vs=`Your template should expect that the variable <code>tools</code> will either be null (if no tools are passed), or is a list
of JSON schema dicts. Our chat template methods allow users to pass tools as either JSON schema or Python functions, but when
functions are passed, we automatically generate JSON schema and pass that to your template. As a result, the
<code>tools</code> variable that your template receives will always be a list of JSON schema. Here is
a sample tool JSON schema:`,gl,We,Cl,Ge,ks=`And here is some example code for handling tools in your chat template. Remember, this is just an example for a
specific format - your model will probably need different formatting!`,Il,Be,bl,qe,Qs=`The specific tokens and tool descriptions your template renders should of course be chosen to match the ones your model
was trained with. There is no requirement that your <strong>model</strong> understands JSON schema input, only that your template can translate
JSON schema into your model’s format. For example, <a href="https://huggingface.co/CohereForAI/c4ai-command-r-plus-08-2024" rel="nofollow">Command-R</a>
was trained with tools defined using Python function headers, but the Command-R tool template accepts JSON schema,
converts types internally and renders the input tools as Python headers. You can do a lot with templates!`,xl,He,$l,Le,_s=`Tool calls, if present, will be a list attached to a message with the “assistant” role. Note that <code>tool_calls</code> is
always a list, even though most tool-calling models only support single tool calls at a time, which means
the list will usually only have a single element. Here is a sample message dict containing a tool call:`,Nl,Ye,Al,Fe,Ss="And a common pattern for handling them would be something like this:",vl,Pe,kl,Xe,Zs="Again, you should render the tool call with the formatting and special tokens that your model expects.",Ql,De,_l,Oe,zs=`Tool responses have a simple format: They are a message dict with the “tool” role, a “name” key giving the name
of the called function, and a “content” key containing the result of the tool call. Here is a sample tool response:`,Sl,Ke,Zl,et,Es=`You don’t need to use all of the keys in the tool response. For example, if your model doesn’t expect the function
name to be included in the tool response, then rendering it can be as simple as:`,zl,tt,El,lt,Vs=`Again, remember that the actual formatting and special tokens are model-specific - you should take a lot of care
to ensure that tokens, whitespace and everything else exactly match the format your model was trained with!`,Vl,st,Rl,at,Wl;return I=new U({props:{title:"Advanced Usage and Customizing Your Chat Templates",local:"advanced-usage-and-customizing-your-chat-templates",headingTag:"h1"}}),x=new U({props:{title:"How do chat templates work?",local:"how-do-chat-templates-work",headingTag:"h2"}}),N=new T({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0MnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclN0MlM0UlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwZW9zX3Rva2VuJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiUyNS0lMjBpZiUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTdDYXNzaXN0YW50JTdDJTNFJTVDbiclMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0Q=",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|&#x27;</span> + message[&#x27;role&#x27;] + <span class="hljs-string">&#x27;|&gt;\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> message[&#x27;content&#x27;] + eos_token }}</span><span class="language-xml">
{%- endfor %}
{%- if add_generation_prompt %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|assistant|&gt;\\n&#x27;</span> }}</span><span class="language-xml">
{%- endif %}</span>`,wrap:!1}}),v=new T({props:{code:"Zm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlM0ElMEElMjAlMjAlMjAlMjBwcmludChmJyUzQyU3QyU3Qm1lc3NhZ2UlNUIlMjJyb2xlJTIyJTVEJTdEJTdDJTNFJyklMEElMjAlMjAlMjAlMjBwcmludChtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwZW9zX3Rva2VuKSUwQWlmJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJyUzQyU3Q2Fzc2lzdGFudCU3QyUzRScp",highlighted:`<span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;&lt;|<span class="hljs-subst">{message[<span class="hljs-string">&quot;role&quot;</span>]}</span>|&gt;&#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>] + eos_token)
<span class="hljs-keyword">if</span> add_generation_prompt:
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;&lt;|assistant|&gt;&#x27;</span>)`,wrap:!1}}),S=new T({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3N5c3RlbSclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclNUMlNUNuJTNDJTNDJTJGU1lTJTNFJTNFJTVDJTVDbiU1QyU1Q24nJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUyMCclMjAlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),z=new U({props:{title:"How do I create a chat template?",local:"how-do-i-create-a-chat-template",headingTag:"h2"}}),V=new T({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTNDU1lTJTNFJTNFJTVDJTVDbiclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclNUJBU1NUJTVEJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJTVCJTJGQVNTVCU1RCclMjAlMkIlMjBlb3NfdG9rZW4lMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`{%- <span class="hljs-keyword">for</span> message <span class="hljs-keyword">in</span> messages %}
    {%- <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> %}
        {{- bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].<span class="hljs-keyword">strip</span>() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}
    {%- elif message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> %}
        {{- <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}
    {%- endif %}
{%- endfor %}`,wrap:!1}}),W=new T({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),j=new Gl({props:{$$slots:{default:[ta]},$$scope:{ctx:f}}}),B=new U({props:{title:"Why do some models have multiple templates?",local:"why-do-some-models-have-multiple-templates",headingTag:"h2"}}),Y=new U({props:{title:"What template should I use?",local:"what-template-should-i-use",headingTag:"h2"}}),X=new T({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMCclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> <span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[&#x27;role&#x27;] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[&#x27;content&#x27;] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span> }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),O=new T({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'tokenizer.chat_template = <span class="hljs-string">&quot;{% if not add_generation_prompt is defined %}{% set add_generation_prompt = false %}{% endif %}{% for message in messages %}{{&#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27;}}{% endfor %}{% if add_generation_prompt %}{{ &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}{% endif %}&quot;</span>',wrap:!1}}),ee=new T({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),le=new U({props:{title:"I want to add some chat templates! How should I get started?",local:"i-want-to-add-some-chat-templates-how-should-i-get-started",headingTag:"h2"}}),g=new Gl({props:{$$slots:{default:[la]},$$scope:{ctx:f}}}),pe=new U({props:{title:"Trimming whitespace",local:"trimming-whitespace",headingTag:"h3"}}),me=new T({props:{code:"JTdCJTI1LSUyMGZvciUyMG1lc3NhZ2UlMjBpbiUyMG1lc3NhZ2VzJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCLSUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1LSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="language-xml">{%- for message in messages %}
    </span><span class="hljs-template-variable">{{<span class="hljs-name">-</span> message[&#x27;role&#x27;] + message[&#x27;content&#x27;] }}</span><span class="language-xml">
{%- endfor %}</span>`,wrap:!1}}),he=new T({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0IlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;role&#x27;</span>] + message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Me=new U({props:{title:"Special variables",local:"special-variables",headingTag:"h3"}}),C=new Gl({props:{$$slots:{default:[sa]},$$scope:{ctx:f}}}),Te=new U({props:{title:"Callable functions",local:"callable-functions",headingTag:"h3"}}),fe=new U({props:{title:"Compatibility with non-Python Jinja",local:"compatibility-with-non-python-jinja",headingTag:"h3"}}),Ce=new U({props:{title:"Writing generation prompts",local:"writing-generation-prompts",headingTag:"h3"}}),xe=new T({props:{code:"JTdCJTdCLSUyMGJvc190b2tlbiUyMCU3RCU3RCUwQSU3QiUyNS0lMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyUyMCU3RCU3RCUwQSU3QiUyNS0lMjBlbmRmb3IlMjAlMjUlN0QlMEElN0IlMjUtJTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTVDbiclMjAlN0QlN0QlMEElN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0Q=",highlighted:`{{- bos_token }}
{%- for message in messages %}
    {{- &#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27; }}
{%- endfor %}
{%- if add_generation_prompt %}
    {{- &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}
{%- endif %}`,wrap:!1}}),Ae=new U({props:{title:"Writing and debugging larger templates",local:"writing-and-debugging-larger-templates",headingTag:"h3"}}),ke=new T({props:{code:"b3BlbiglMjJ0ZW1wbGF0ZS5qaW5qYSUyMiUyQyUyMCUyMnclMjIpLndyaXRlKHRva2VuaXplci5jaGF0X3RlbXBsYXRlKQ==",highlighted:'<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>).write(tokenizer.chat_template)',wrap:!1}}),_e=new T({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjBvcGVuKCUyMnRlbXBsYXRlLmppbmphJTIyKS5yZWFkKCk=",highlighted:'tokenizer.chat_template = <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;template.jinja&quot;</span>).read()',wrap:!1}}),Ze=new U({props:{title:"Writing templates for tools",local:"writing-templates-for-tools",headingTag:"h2"}}),Ve=new U({props:{title:"Tool definitions",local:"tool-definitions",headingTag:"h3"}}),We=new T({props:{code:"JTdCJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTBBJTIwJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIybnVtYmVyJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm51bWJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwc2Vjb25kJTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcXVpcmVkJTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span> 
  <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A function that multiplies two numbers&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span> 
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The first number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
        <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The second number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;a&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Be=new T({props:{code:"JTdCJTI1LSUyMGlmJTIwdG9vbHMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZm9yJTIwdG9vbCUyMGluJTIwdG9vbHMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyUzQ3Rvb2wlM0UnJTIwJTJCJTIwdG9vbCU1QidmdW5jdGlvbiclNUQlNUInbmFtZSclNUQlMjAlMkIlMjAnJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjUtJTIwZm9yJTIwYXJndW1lbnQlMjBpbiUyMHRvb2wlNUInZnVuY3Rpb24nJTVEJTVCJ3BhcmFtZXRlcnMnJTVEJTVCJ3Byb3BlcnRpZXMnJTVEJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCLSUyMGFyZ3VtZW50JTIwJTJCJTIwJyUzQSUyMCclMjAlMkIlMjB0b29sJTVCJ2Z1bmN0aW9uJyU1RCU1QidwYXJhbWV0ZXJzJyU1RCU1Qidwcm9wZXJ0aWVzJyU1RCU1QmFyZ3VtZW50JTVEJTVCJ2Rlc2NyaXB0aW9uJyU1RCUyMCUyQiUyMCclNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbmRmb3IlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0ItJTIwJyU1Q24lM0MlMkZ0b29sJTNFJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`{%- if tools %}
    {%- for tool in tools %}
        {{- &#x27;&lt;tool&gt;&#x27; + tool[&#x27;function&#x27;][&#x27;name&#x27;] + &#x27;\\n&#x27; }}
        {%- for argument in tool[&#x27;function&#x27;][&#x27;parameters&#x27;][&#x27;properties&#x27;] %}
            {{- argument + &#x27;: &#x27; + tool[&#x27;function&#x27;][&#x27;parameters&#x27;][&#x27;properties&#x27;][argument][&#x27;description&#x27;] + &#x27;\\n&#x27; }}
        {%- endfor %}
        {{- &#x27;\\n&lt;/tool&gt;&#x27; }}
    {%- endif %}
{%- endif %}`,wrap:!1}}),He=new U({props:{title:"Tool calls",local:"tool-calls",headingTag:"h3"}}),Ye=new T({props:{code:"JTdCJTBBJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUwQSUyMCUyMCUyMnRvb2xfY2FsbHMlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZnVuY3Rpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJmdW5jdGlvbiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJtdWx0aXBseSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFyZ3VtZW50cyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjA1JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYiUyMiUzQSUyMDYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlNUQlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tool_calls&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span>
      <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;arguments&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">6</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Pe=new T({props:{code:"JTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwYW5kJTIwJ3Rvb2xfY2FsbHMnJTIwaW4lMjBtZXNzYWdlJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1LSUyMGZvciUyMHRvb2xfY2FsbCUyMGluJTIwbWVzc2FnZSU1Qid0b29sX2NhbGxzJyU1RCUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAnJTNDdG9vbF9jYWxsJTNFJyUyMCUyQiUyMHRvb2xfY2FsbCU1QidmdW5jdGlvbiclNUQlNUInbmFtZSclNUQlMjAlMkIlMjAnJTVDbiclMjAlMkIlMjB0b29sX2NhbGwlNUInZnVuY3Rpb24nJTVEJTVCJ2FyZ3VtZW50cyclNUQlN0N0b2pzb24lMjAlMkIlMjAnJTVDbiUzQyUyRnRvb2xfY2FsbCUzRSclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kaWYlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUtJTIwZW5kZm9yJTIwJTI1JTdEJTBBJTdCJTI1LSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`{%- if message[&#x27;role&#x27;] == &#x27;assistant&#x27; and &#x27;tool_calls&#x27; in message %}
    {%- for tool_call in message[&#x27;tool_calls&#x27;] %}
            {{- &#x27;&lt;tool_call&gt;&#x27; + tool_call[&#x27;function&#x27;][&#x27;name&#x27;] + &#x27;\\n&#x27; + tool_call[&#x27;function&#x27;][&#x27;arguments&#x27;]|tojson + &#x27;\\n&lt;/tool_call&gt;&#x27; }}
        {%- endif %}
    {%- endfor %}
{%- endif %}`,wrap:!1}}),De=new U({props:{title:"Tool responses",local:"tool-responses",headingTag:"h3"}}),Ke=new T({props:{code:"JTdCJTBBJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnRvb2wlMjIlMkMlMEElMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMEElMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyMzAlMjIlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tool&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;30&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),tt=new T({props:{code:"JTdCJTI1LSUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd0b29sJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCU3QiU3Qi0lMjAlMjIlM0N0b29sX3Jlc3VsdCUzRSUyMiUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAlMjIlM0MlMkZ0b29sX3Jlc3VsdCUzRSUyMiUyMCU3RCU3RCUwQSU3QiUyNS0lMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`{%- if message[&#x27;role&#x27;] == &#x27;tool&#x27; %}
    {{- &quot;&lt;tool_result&gt;&quot; + message[&#x27;content&#x27;] + &quot;&lt;/tool_result&gt;&quot; }}
{%- endif %}`,wrap:!1}}),st=new ea({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/chat_template_advanced.md"}}),{c(){u=i("meta"),J=a(),y=i("p"),w=a(),r(I.$$.fragment),nt=a(),b=i("p"),b.textContent=Bl,it=a(),r(x.$$.fragment),ot=a(),$=i("p"),$.innerHTML=ql,pt=a(),r(N.$$.fragment),rt=a(),A=i("p"),A.innerHTML=Hl,mt=a(),r(v.$$.fragment),ct=a(),k=i("p"),k.textContent=Ll,ht=a(),Q=i("ol"),Q.innerHTML=Yl,dt=a(),_=i("p"),_.textContent=Fl,Mt=a(),r(S.$$.fragment),ut=a(),Z=i("p"),Z.innerHTML=Pl,yt=a(),r(z.$$.fragment),Tt=a(),E=i("p"),E.innerHTML=Xl,Jt=a(),r(V.$$.fragment),Ut=a(),R=i("p"),R.innerHTML=Dl,ft=a(),r(W.$$.fragment),wt=a(),G=i("p"),G.innerHTML=Ol,jt=a(),r(j.$$.fragment),gt=a(),r(B.$$.fragment),Ct=a(),q=i("p"),q.innerHTML=Kl,It=a(),H=i("p"),H.innerHTML=es,bt=a(),L=i("p"),L.textContent=ts,xt=a(),r(Y.$$.fragment),$t=a(),F=i("p"),F.textContent=ls,Nt=a(),P=i("p"),P.innerHTML=ss,At=a(),r(X.$$.fragment),vt=a(),D=i("p"),D.innerHTML=as,kt=a(),r(O.$$.fragment),Qt=a(),K=i("p"),K.innerHTML=ns,_t=a(),r(ee.$$.fragment),St=a(),te=i("p"),te.innerHTML=is,Zt=a(),r(le.$$.fragment),zt=a(),se=i("p"),se.innerHTML=os,Et=a(),ae=i("p"),ae.innerHTML=ps,Vt=a(),ne=i("p"),ne.textContent=rs,Rt=a(),r(g.$$.fragment),Wt=a(),ie=i("p"),ie.innerHTML=ms,Gt=a(),oe=i("p"),oe.textContent=cs,Bt=a(),r(pe.$$.fragment),qt=a(),re=i("p"),re.textContent=hs,Ht=a(),r(me.$$.fragment),Lt=a(),ce=i("p"),ce.textContent=ds,Yt=a(),r(he.$$.fragment),Ft=a(),de=i("p"),de.innerHTML=Ms,Pt=a(),r(Me.$$.fragment),Xt=a(),ue=i("p"),ue.innerHTML=us,Dt=a(),ye=i("ul"),ye.innerHTML=ys,Ot=a(),r(C.$$.fragment),Kt=a(),r(Te.$$.fragment),el=a(),Je=i("p"),Je.textContent=Ts,tl=a(),Ue=i("ul"),Ue.innerHTML=Js,ll=a(),r(fe.$$.fragment),sl=a(),we=i("p"),we.innerHTML=Us,al=a(),je=i("p"),je.textContent=fs,nl=a(),ge=i("ul"),ge.innerHTML=ws,il=a(),r(Ce.$$.fragment),ol=a(),Ie=i("p"),Ie.innerHTML=js,pl=a(),be=i("p"),be.textContent=gs,rl=a(),r(xe.$$.fragment),ml=a(),$e=i("p"),$e.innerHTML=Cs,cl=a(),Ne=i("p"),Ne.textContent=Is,hl=a(),r(Ae.$$.fragment),dl=a(),ve=i("p"),ve.textContent=bs,Ml=a(),r(ke.$$.fragment),ul=a(),Qe=i("p"),Qe.textContent=xs,yl=a(),r(_e.$$.fragment),Tl=a(),Se=i("p"),Se.textContent=$s,Jl=a(),r(Ze.$$.fragment),Ul=a(),ze=i("p"),ze.textContent=Ns,fl=a(),Ee=i("p"),Ee.textContent=As,wl=a(),r(Ve.$$.fragment),jl=a(),Re=i("p"),Re.innerHTML=vs,gl=a(),r(We.$$.fragment),Cl=a(),Ge=i("p"),Ge.textContent=ks,Il=a(),r(Be.$$.fragment),bl=a(),qe=i("p"),qe.innerHTML=Qs,xl=a(),r(He.$$.fragment),$l=a(),Le=i("p"),Le.innerHTML=_s,Nl=a(),r(Ye.$$.fragment),Al=a(),Fe=i("p"),Fe.textContent=Ss,vl=a(),r(Pe.$$.fragment),kl=a(),Xe=i("p"),Xe.textContent=Zs,Ql=a(),r(De.$$.fragment),_l=a(),Oe=i("p"),Oe.textContent=zs,Sl=a(),r(Ke.$$.fragment),Zl=a(),et=i("p"),et.textContent=Es,zl=a(),r(tt.$$.fragment),El=a(),lt=i("p"),lt.textContent=Vs,Vl=a(),r(st.$$.fragment),Rl=a(),at=i("p"),this.h()},l(e){const t=Xs("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),J=n(e),y=o(e,"P",{}),Bs(y).forEach(l),w=n(e),m(I.$$.fragment,e),nt=n(e),b=o(e,"P",{"data-svelte-h":!0}),p(b)!=="svelte-mj86xb"&&(b.textContent=Bl),it=n(e),m(x.$$.fragment,e),ot=n(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1czh8av"&&($.innerHTML=ql),pt=n(e),m(N.$$.fragment,e),rt=n(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-zet1qo"&&(A.innerHTML=Hl),mt=n(e),m(v.$$.fragment,e),ct=n(e),k=o(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-9bdwn1"&&(k.textContent=Ll),ht=n(e),Q=o(e,"OL",{"data-svelte-h":!0}),p(Q)!=="svelte-1ax9ke1"&&(Q.innerHTML=Yl),dt=n(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-4zn2hx"&&(_.textContent=Fl),Mt=n(e),m(S.$$.fragment,e),ut=n(e),Z=o(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-prz4we"&&(Z.innerHTML=Pl),yt=n(e),m(z.$$.fragment,e),Tt=n(e),E=o(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-1ubxgh9"&&(E.innerHTML=Xl),Jt=n(e),m(V.$$.fragment,e),Ut=n(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-t74z56"&&(R.innerHTML=Dl),ft=n(e),m(W.$$.fragment,e),wt=n(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-pl6d88"&&(G.innerHTML=Ol),jt=n(e),m(j.$$.fragment,e),gt=n(e),m(B.$$.fragment,e),Ct=n(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1d7cql4"&&(q.innerHTML=Kl),It=n(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1u88h1j"&&(H.innerHTML=es),bt=n(e),L=o(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1g7ri12"&&(L.textContent=ts),xt=n(e),m(Y.$$.fragment,e),$t=n(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-5u6sqi"&&(F.textContent=ls),Nt=n(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-ffreiw"&&(P.innerHTML=ss),At=n(e),m(X.$$.fragment,e),vt=n(e),D=o(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1cj1ql7"&&(D.innerHTML=as),kt=n(e),m(O.$$.fragment,e),Qt=n(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-soh9qu"&&(K.innerHTML=ns),_t=n(e),m(ee.$$.fragment,e),St=n(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-14p3dvw"&&(te.innerHTML=is),Zt=n(e),m(le.$$.fragment,e),zt=n(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-12av8vh"&&(se.innerHTML=os),Et=n(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-kn2i6o"&&(ae.innerHTML=ps),Vt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-197jyne"&&(ne.textContent=rs),Rt=n(e),m(g.$$.fragment,e),Wt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1eu5v04"&&(ie.innerHTML=ms),Gt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-10wmjwo"&&(oe.textContent=cs),Bt=n(e),m(pe.$$.fragment,e),qt=n(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-1ttgeg7"&&(re.textContent=hs),Ht=n(e),m(me.$$.fragment,e),Lt=n(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-qihux6"&&(ce.textContent=ds),Yt=n(e),m(he.$$.fragment,e),Ft=n(e),de=o(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-pefrh0"&&(de.innerHTML=Ms),Pt=n(e),m(Me.$$.fragment,e),Xt=n(e),ue=o(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1s7e55r"&&(ue.innerHTML=us),Dt=n(e),ye=o(e,"UL",{"data-svelte-h":!0}),p(ye)!=="svelte-1rdzqgp"&&(ye.innerHTML=ys),Ot=n(e),m(C.$$.fragment,e),Kt=n(e),m(Te.$$.fragment,e),el=n(e),Je=o(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-w29vry"&&(Je.textContent=Ts),tl=n(e),Ue=o(e,"UL",{"data-svelte-h":!0}),p(Ue)!=="svelte-1fmzhdy"&&(Ue.innerHTML=Js),ll=n(e),m(fe.$$.fragment,e),sl=n(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-jvvtjt"&&(we.innerHTML=Us),al=n(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-f0ucf0"&&(je.textContent=fs),nl=n(e),ge=o(e,"UL",{"data-svelte-h":!0}),p(ge)!=="svelte-doa6oc"&&(ge.innerHTML=ws),il=n(e),m(Ce.$$.fragment,e),ol=n(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-13g6lvo"&&(Ie.innerHTML=js),pl=n(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-i5qalm"&&(be.textContent=gs),rl=n(e),m(xe.$$.fragment,e),ml=n(e),$e=o(e,"P",{"data-svelte-h":!0}),p($e)!=="svelte-148o5ra"&&($e.innerHTML=Cs),cl=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-17es6d5"&&(Ne.textContent=Is),hl=n(e),m(Ae.$$.fragment,e),dl=n(e),ve=o(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-180ap61"&&(ve.textContent=bs),Ml=n(e),m(ke.$$.fragment,e),ul=n(e),Qe=o(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-1bv602"&&(Qe.textContent=xs),yl=n(e),m(_e.$$.fragment,e),Tl=n(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1mq7g8k"&&(Se.textContent=$s),Jl=n(e),m(Ze.$$.fragment,e),Ul=n(e),ze=o(e,"P",{"data-svelte-h":!0}),p(ze)!=="svelte-kt3iym"&&(ze.textContent=Ns),fl=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-1nlwaki"&&(Ee.textContent=As),wl=n(e),m(Ve.$$.fragment,e),jl=n(e),Re=o(e,"P",{"data-svelte-h":!0}),p(Re)!=="svelte-wrq3v1"&&(Re.innerHTML=vs),gl=n(e),m(We.$$.fragment,e),Cl=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-1woymkp"&&(Ge.textContent=ks),Il=n(e),m(Be.$$.fragment,e),bl=n(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-1vngoc7"&&(qe.innerHTML=Qs),xl=n(e),m(He.$$.fragment,e),$l=n(e),Le=o(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1x6y95z"&&(Le.innerHTML=_s),Nl=n(e),m(Ye.$$.fragment,e),Al=n(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-my9opo"&&(Fe.textContent=Ss),vl=n(e),m(Pe.$$.fragment,e),kl=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-hsoefm"&&(Xe.textContent=Zs),Ql=n(e),m(De.$$.fragment,e),_l=n(e),Oe=o(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-1hx88do"&&(Oe.textContent=zs),Sl=n(e),m(Ke.$$.fragment,e),Zl=n(e),et=o(e,"P",{"data-svelte-h":!0}),p(et)!=="svelte-1okuuze"&&(et.textContent=Es),zl=n(e),m(tt.$$.fragment,e),El=n(e),lt=o(e,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-13n2q2c"&&(lt.textContent=Vs),Vl=n(e),m(st.$$.fragment,e),Rl=n(e),at=o(e,"P",{}),Bs(at).forEach(l),this.h()},h(){qs(u,"name","hf:doc:metadata"),qs(u,"content",na)},m(e,t){Ds(document.head,u),s(e,J,t),s(e,y,t),s(e,w,t),c(I,e,t),s(e,nt,t),s(e,b,t),s(e,it,t),c(x,e,t),s(e,ot,t),s(e,$,t),s(e,pt,t),c(N,e,t),s(e,rt,t),s(e,A,t),s(e,mt,t),c(v,e,t),s(e,ct,t),s(e,k,t),s(e,ht,t),s(e,Q,t),s(e,dt,t),s(e,_,t),s(e,Mt,t),c(S,e,t),s(e,ut,t),s(e,Z,t),s(e,yt,t),c(z,e,t),s(e,Tt,t),s(e,E,t),s(e,Jt,t),c(V,e,t),s(e,Ut,t),s(e,R,t),s(e,ft,t),c(W,e,t),s(e,wt,t),s(e,G,t),s(e,jt,t),c(j,e,t),s(e,gt,t),c(B,e,t),s(e,Ct,t),s(e,q,t),s(e,It,t),s(e,H,t),s(e,bt,t),s(e,L,t),s(e,xt,t),c(Y,e,t),s(e,$t,t),s(e,F,t),s(e,Nt,t),s(e,P,t),s(e,At,t),c(X,e,t),s(e,vt,t),s(e,D,t),s(e,kt,t),c(O,e,t),s(e,Qt,t),s(e,K,t),s(e,_t,t),c(ee,e,t),s(e,St,t),s(e,te,t),s(e,Zt,t),c(le,e,t),s(e,zt,t),s(e,se,t),s(e,Et,t),s(e,ae,t),s(e,Vt,t),s(e,ne,t),s(e,Rt,t),c(g,e,t),s(e,Wt,t),s(e,ie,t),s(e,Gt,t),s(e,oe,t),s(e,Bt,t),c(pe,e,t),s(e,qt,t),s(e,re,t),s(e,Ht,t),c(me,e,t),s(e,Lt,t),s(e,ce,t),s(e,Yt,t),c(he,e,t),s(e,Ft,t),s(e,de,t),s(e,Pt,t),c(Me,e,t),s(e,Xt,t),s(e,ue,t),s(e,Dt,t),s(e,ye,t),s(e,Ot,t),c(C,e,t),s(e,Kt,t),c(Te,e,t),s(e,el,t),s(e,Je,t),s(e,tl,t),s(e,Ue,t),s(e,ll,t),c(fe,e,t),s(e,sl,t),s(e,we,t),s(e,al,t),s(e,je,t),s(e,nl,t),s(e,ge,t),s(e,il,t),c(Ce,e,t),s(e,ol,t),s(e,Ie,t),s(e,pl,t),s(e,be,t),s(e,rl,t),c(xe,e,t),s(e,ml,t),s(e,$e,t),s(e,cl,t),s(e,Ne,t),s(e,hl,t),c(Ae,e,t),s(e,dl,t),s(e,ve,t),s(e,Ml,t),c(ke,e,t),s(e,ul,t),s(e,Qe,t),s(e,yl,t),c(_e,e,t),s(e,Tl,t),s(e,Se,t),s(e,Jl,t),c(Ze,e,t),s(e,Ul,t),s(e,ze,t),s(e,fl,t),s(e,Ee,t),s(e,wl,t),c(Ve,e,t),s(e,jl,t),s(e,Re,t),s(e,gl,t),c(We,e,t),s(e,Cl,t),s(e,Ge,t),s(e,Il,t),c(Be,e,t),s(e,bl,t),s(e,qe,t),s(e,xl,t),c(He,e,t),s(e,$l,t),s(e,Le,t),s(e,Nl,t),c(Ye,e,t),s(e,Al,t),s(e,Fe,t),s(e,vl,t),c(Pe,e,t),s(e,kl,t),s(e,Xe,t),s(e,Ql,t),c(De,e,t),s(e,_l,t),s(e,Oe,t),s(e,Sl,t),c(Ke,e,t),s(e,Zl,t),s(e,et,t),s(e,zl,t),c(tt,e,t),s(e,El,t),s(e,lt,t),s(e,Vl,t),c(st,e,t),s(e,Rl,t),s(e,at,t),Wl=!0},p(e,[t]){const Rs={};t&2&&(Rs.$$scope={dirty:t,ctx:e}),j.$set(Rs);const Ws={};t&2&&(Ws.$$scope={dirty:t,ctx:e}),g.$set(Ws);const Gs={};t&2&&(Gs.$$scope={dirty:t,ctx:e}),C.$set(Gs)},i(e){Wl||(h(I.$$.fragment,e),h(x.$$.fragment,e),h(N.$$.fragment,e),h(v.$$.fragment,e),h(S.$$.fragment,e),h(z.$$.fragment,e),h(V.$$.fragment,e),h(W.$$.fragment,e),h(j.$$.fragment,e),h(B.$$.fragment,e),h(Y.$$.fragment,e),h(X.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(g.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(he.$$.fragment,e),h(Me.$$.fragment,e),h(C.$$.fragment,e),h(Te.$$.fragment,e),h(fe.$$.fragment,e),h(Ce.$$.fragment,e),h(xe.$$.fragment,e),h(Ae.$$.fragment,e),h(ke.$$.fragment,e),h(_e.$$.fragment,e),h(Ze.$$.fragment,e),h(Ve.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),h(He.$$.fragment,e),h(Ye.$$.fragment,e),h(Pe.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(tt.$$.fragment,e),h(st.$$.fragment,e),Wl=!0)},o(e){d(I.$$.fragment,e),d(x.$$.fragment,e),d(N.$$.fragment,e),d(v.$$.fragment,e),d(S.$$.fragment,e),d(z.$$.fragment,e),d(V.$$.fragment,e),d(W.$$.fragment,e),d(j.$$.fragment,e),d(B.$$.fragment,e),d(Y.$$.fragment,e),d(X.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(g.$$.fragment,e),d(pe.$$.fragment,e),d(me.$$.fragment,e),d(he.$$.fragment,e),d(Me.$$.fragment,e),d(C.$$.fragment,e),d(Te.$$.fragment,e),d(fe.$$.fragment,e),d(Ce.$$.fragment,e),d(xe.$$.fragment,e),d(Ae.$$.fragment,e),d(ke.$$.fragment,e),d(_e.$$.fragment,e),d(Ze.$$.fragment,e),d(Ve.$$.fragment,e),d(We.$$.fragment,e),d(Be.$$.fragment,e),d(He.$$.fragment,e),d(Ye.$$.fragment,e),d(Pe.$$.fragment,e),d(De.$$.fragment,e),d(Ke.$$.fragment,e),d(tt.$$.fragment,e),d(st.$$.fragment,e),Wl=!1},d(e){e&&(l(J),l(y),l(w),l(nt),l(b),l(it),l(ot),l($),l(pt),l(rt),l(A),l(mt),l(ct),l(k),l(ht),l(Q),l(dt),l(_),l(Mt),l(ut),l(Z),l(yt),l(Tt),l(E),l(Jt),l(Ut),l(R),l(ft),l(wt),l(G),l(jt),l(gt),l(Ct),l(q),l(It),l(H),l(bt),l(L),l(xt),l($t),l(F),l(Nt),l(P),l(At),l(vt),l(D),l(kt),l(Qt),l(K),l(_t),l(St),l(te),l(Zt),l(zt),l(se),l(Et),l(ae),l(Vt),l(ne),l(Rt),l(Wt),l(ie),l(Gt),l(oe),l(Bt),l(qt),l(re),l(Ht),l(Lt),l(ce),l(Yt),l(Ft),l(de),l(Pt),l(Xt),l(ue),l(Dt),l(ye),l(Ot),l(Kt),l(el),l(Je),l(tl),l(Ue),l(ll),l(sl),l(we),l(al),l(je),l(nl),l(ge),l(il),l(ol),l(Ie),l(pl),l(be),l(rl),l(ml),l($e),l(cl),l(Ne),l(hl),l(dl),l(ve),l(Ml),l(ul),l(Qe),l(yl),l(Tl),l(Se),l(Jl),l(Ul),l(ze),l(fl),l(Ee),l(wl),l(jl),l(Re),l(gl),l(Cl),l(Ge),l(Il),l(bl),l(qe),l(xl),l($l),l(Le),l(Nl),l(Al),l(Fe),l(vl),l(kl),l(Xe),l(Ql),l(_l),l(Oe),l(Sl),l(Zl),l(et),l(zl),l(El),l(lt),l(Vl),l(Rl),l(at)),l(u),M(I,e),M(x,e),M(N,e),M(v,e),M(S,e),M(z,e),M(V,e),M(W,e),M(j,e),M(B,e),M(Y,e),M(X,e),M(O,e),M(ee,e),M(le,e),M(g,e),M(pe,e),M(me,e),M(he,e),M(Me,e),M(C,e),M(Te,e),M(fe,e),M(Ce,e),M(xe,e),M(Ae,e),M(ke,e),M(_e,e),M(Ze,e),M(Ve,e),M(We,e),M(Be,e),M(He,e),M(Ye,e),M(Pe,e),M(De,e),M(Ke,e),M(tt,e),M(st,e)}}}const na='{"title":"Advanced Usage and Customizing Your Chat Templates","local":"advanced-usage-and-customizing-your-chat-templates","sections":[{"title":"How do chat templates work?","local":"how-do-chat-templates-work","sections":[],"depth":2},{"title":"How do I create a chat template?","local":"how-do-i-create-a-chat-template","sections":[],"depth":2},{"title":"Why do some models have multiple templates?","local":"why-do-some-models-have-multiple-templates","sections":[],"depth":2},{"title":"What template should I use?","local":"what-template-should-i-use","sections":[],"depth":2},{"title":"I want to add some chat templates! How should I get started?","local":"i-want-to-add-some-chat-templates-how-should-i-get-started","sections":[{"title":"Trimming whitespace","local":"trimming-whitespace","sections":[],"depth":3},{"title":"Special variables","local":"special-variables","sections":[],"depth":3},{"title":"Callable functions","local":"callable-functions","sections":[],"depth":3},{"title":"Compatibility with non-Python Jinja","local":"compatibility-with-non-python-jinja","sections":[],"depth":3},{"title":"Writing generation prompts","local":"writing-generation-prompts","sections":[],"depth":3},{"title":"Writing and debugging larger templates","local":"writing-and-debugging-larger-templates","sections":[],"depth":3}],"depth":2},{"title":"Writing templates for tools","local":"writing-templates-for-tools","sections":[{"title":"Tool definitions","local":"tool-definitions","sections":[],"depth":3},{"title":"Tool calls","local":"tool-calls","sections":[],"depth":3},{"title":"Tool responses","local":"tool-responses","sections":[],"depth":3}],"depth":2}],"depth":1}';function ia(f){return Ys(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ha extends Fs{constructor(u){super(),Ps(this,u,ia,aa,Ls,{})}}export{ha as component};
