import{s as Ae,o as De,n as Le}from"../chunks/scheduler.25b97de1.js";import{S as Pe,i as Ke,g as o,s as a,r,A as Oe,h as i,f as s,c as n,j as Ve,u as y,x as p,k as Ye,y as ts,a as l,v as h,d as u,t as m,w as d}from"../chunks/index.d9030fc9.js";import{T as Ee}from"../chunks/Tip.baa67368.js";import{C as T}from"../chunks/CodeBlock.e6cd0d95.js";import{H as Jt,E as es}from"../chunks/EditOnGithub.91d95064.js";function ss(Ut){let M,j=`The default behaviour of <code>TextGenerationPipeline</code> is to set <code>add_generation_prompt=True</code> so that it starts a new
message. However, if the final message in the input chat has the “assistant” role, it will assume that this message is
a prefill and switch to <code>continue_final_message=True</code> instead, because most models do not support multiple
consecutive assistant messages. You can override this behaviour by explicitly passing the <code>continue_final_message</code>
argument when calling the pipeline.`;return{c(){M=o("p"),M.innerHTML=j},l(c){M=i(c,"P",{"data-svelte-h":!0}),p(M)!=="svelte-95bbxf"&&(M.innerHTML=j)},m(c,U){l(c,M,U)},p:Le,d(c){c&&s(M)}}}function ls(Ut){let M,j=`By default, some tokenizers add special tokens like <code>&lt;bos&gt;</code> and <code>&lt;eos&gt;</code> to text they tokenize. Chat templates should
already include all the special tokens they need, and so additional special tokens will often be incorrect or
duplicated, which will hurt model performance.`,c,U,g=`Therefore, if you format text with <code>apply_chat_template(tokenize=False)</code>, you should set the argument
<code>add_special_tokens=False</code> when you tokenize that text later. If you use <code>apply_chat_template(tokenize=True)</code>, you don’t need to worry about this!`;return{c(){M=o("p"),M.innerHTML=j,c=a(),U=o("p"),U.innerHTML=g},l(J){M=i(J,"P",{"data-svelte-h":!0}),p(M)!=="svelte-148xjo3"&&(M.innerHTML=j),c=n(J),U=i(J,"P",{"data-svelte-h":!0}),p(U)!=="svelte-1hgzema"&&(U.innerHTML=g)},m(J,w){l(J,M,w),l(J,c,w),l(J,U,w)},p:Le,d(J){J&&(s(M),s(c),s(U))}}}function as(Ut){let M,j,c,U,g,J,w,ce=`An increasingly common use case for LLMs is <strong>chat</strong>. In a chat context, rather than continuing a single string
of text (as is the case with a standard language model), the model instead continues a conversation that consists
of one or more <strong>messages</strong>, each of which includes a <strong>role</strong>, like “user” or “assistant”, as well as message text.`,wt,I,Ue=`Much like tokenization, different models expect very different input formats for chat. This is the reason we added
<strong>chat templates</strong> as a feature. Chat templates are part of the tokenizer for text-only LLMs or processor for multimodal LLMs. They specify how to convert conversations, represented as lists of messages, into a single tokenizable string in the format that the model expects.`,jt,G,Je='We’ll explore the basic usage of chat templates with text-only LLMs in this page. For detailed guidance on multimodal models, we have a dedicated <a href="./chat_template_multimodal">documentation oage for multimodal models</a>, which covers how to work with image, video and audio inputs in your templates.',gt,C,Te="Let’s make this concrete with a quick example using the <code>mistralai/Mistral-7B-Instruct-v0.1</code> model:",ft,Z,bt,B,we=`Notice how the tokenizer has added the control tokens [INST] and [/INST] to indicate the start and end of
user messages (but not assistant messages!), and the entire chat is condensed into a single string.
If we use <code>tokenize=True</code>, which is the default setting, that string will also be tokenized for us.`,It,k,je="Now, try the same code, but swap in the <code>HuggingFaceH4/zephyr-7b-beta</code> model instead, and you should get:",Gt,$,Ct,v,ge=`Both Zephyr and Mistral-Instruct were fine-tuned from the same base model, <code>Mistral-7B-v0.1</code>. However, they were trained
with totally different chat formats. Without chat templates, you would have to write manual formatting code for each
model, and it’s very easy to make minor errors that hurt performance! Chat templates handle the details of formatting
for you, allowing you to write universal code that works for any model.`,Zt,Q,Bt,W,fe=`As you can see in the example above, chat templates are easy to use. Simply build a list of messages, with <code>role</code>
and <code>content</code> keys, and then pass it to the <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.apply_chat_template">apply_chat_template()</a> or <a href="/docs/transformers/main/en/main_classes/processors#transformers.ProcessorMixin.apply_chat_template">apply_chat_template()</a> method
depending on what type of model you are using. Once you do that,
you’ll get output that’s ready to go! When using chat templates as input for model generation, it’s also a good idea
to use <code>add_generation_prompt=True</code> to add a <a href="#what-are-generation-prompts">generation prompt</a>.`,kt,N,be="Here’s an example of preparing input for <code>model.generate()</code>, using <code>Zephyr</code> again:",$t,q,vt,z,Ie="This will yield a string in the input format that Zephyr expects.",Qt,x,Wt,_,Ge="Now that our input is formatted correctly for Zephyr, we can use the model to generate a response to the user’s question:",Nt,S,qt,R,Ce="This will yield:",zt,F,xt,H,Ze="Arr, ‘twas easy after all!",_t,X,St,V,Be=`Yes, there is! Our text generation pipelines support chat inputs, which makes it easy to use chat models. In the past,
we used to use a dedicated “ConversationalPipeline” class, but this has now been deprecated and its functionality
has been merged into the <a href="/docs/transformers/main/en/main_classes/pipelines#transformers.TextGenerationPipeline">TextGenerationPipeline</a>. Let’s try the <code>Zephyr</code> example again, but this time using
a pipeline:`,Rt,Y,Ft,E,Ht,L,ke=`The pipeline will take care of all the details of tokenization and calling <code>apply_chat_template</code> for you -
once the model has a chat template, all you need to do is initialize the pipeline and pass it the list of messages!`,Xt,A,Vt,D,$e=`You may have noticed that the <code>apply_chat_template</code> method has an <code>add_generation_prompt</code> argument. This argument tells
the template to add tokens that indicate the start of a bot response. For example, consider the following chat:`,Yt,P,Et,K,ve="Here’s what this will look like without a generation prompt, for a model that uses standard “ChatML” formatting:",Lt,O,At,tt,Qe="And here’s what it looks like <strong>with</strong> a generation prompt:",Dt,et,Pt,st,We=`Note that this time, we’ve added the tokens that indicate the start of a bot response. This ensures that when the model
generates text it will write a bot response instead of doing something unexpected, like continuing the user’s
message. Remember, chat models are still just language models - they’re trained to continue text, and chat is just a
special kind of text to them! You need to guide them with appropriate control tokens, so they know what they’re
supposed to be doing.`,Kt,lt,Ne=`Not all models require generation prompts. Some models, like LLaMA, don’t have any
special tokens before bot responses. In these cases, the <code>add_generation_prompt</code> argument will have no effect. The exact
effect that <code>add_generation_prompt</code> has will depend on the template being used.`,Ot,at,te,nt,qe=`When passing a list of messages to <code>apply_chat_template</code> or <code>TextGenerationPipeline</code>, you can choose
to format the chat so the model will continue the final message in the chat instead of starting a new one. This is done
by removing any end-of-sequence tokens that indicate the end of the final message, so that the model will simply
extend the final message when it begins to generate text. This is useful for “prefilling” the model’s response.`,ee,ot,ze="Here’s an example:",se,it,le,pt,xe=`The model will generate text that continues the JSON string, rather than starting a new message. This approach
can be very useful for improving the accuracy of the model’s instruction-following when you know how you want
it to start its replies.`,ae,Mt,_e=`Because <code>add_generation_prompt</code> adds the tokens that start a new message, and <code>continue_final_message</code> removes any
end-of-message tokens from the final message, it does not make sense to use them together. As a result, you’ll
get an error if you try!`,ne,f,oe,rt,ie,yt,Se=`Yes! This is a good way to ensure that the chat template matches the tokens the model sees during training.
We recommend that you apply the chat template as a preprocessing step for your dataset. After this, you
can simply continue like any other language model training task. When training, you should usually set
<code>add_generation_prompt=False</code>, because the added tokens to prompt an assistant response will not be helpful during
training. Let’s see an example:`,pe,ht,Me,ut,Re="And we get:",re,mt,ye,dt,Fe="From here, just continue training like you would with a standard language modelling task, using the <code>formatted_chat</code> column.",he,b,ue,ct,me,Tt,de;return g=new Jt({props:{title:"Getting Started with Chat Templates for Text LLMs",local:"getting-started-with-chat-templates-for-text-llms",headingTag:"h1"}}),Z=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST]I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),$=new T({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQUhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTNDJTJGcyUzRSUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQUknbSUyMGRvaW5nJTIwZ3JlYXQuJTIwSG93JTIwY2FuJTIwSSUyMGhlbHAlMjB5b3UlMjB0b2RheSUzRiUzQyUyRnMlM0UlMEElM0MlN0N1c2VyJTdDJTNFJTBBSSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTNDJTJGcyUzRQ==",highlighted:`&lt;|user|&gt;
Hello, how are you?&lt;/s&gt;
&lt;|assistant|&gt;
I&#x27;m doing great. How can I help you today?&lt;/s&gt;
&lt;|user|&gt;
I&#x27;d like to show off how chat templating works!&lt;/s&gt;`,wrap:!1}}),Q=new Jt({props:{title:"How do I use chat templates?",local:"how-do-i-use-chat-templates",headingTag:"h2"}}),q=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),x=new T({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;`,wrap:!1}}),S=new T({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTIwJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>) 
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),F=new T({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),X=new Jt({props:{title:"Is there an automated pipeline for chat?",local:"is-there-an-automated-pipeline-for-chat",headingTag:"h2"}}),Y=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMCUyMkh1Z2dpbmdGYWNlSDQlMkZ6ZXBoeXItN2ItYmV0YSUyMiklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSU1RCUwQXByaW50KHBpcGUobWVzc2FnZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEyOCklNUIwJTVEJTVCJ2dlbmVyYXRlZF90ZXh0JyU1RCU1Qi0xJTVEKSUyMCUyMCUyMyUyMFByaW50JTIwdGhlJTIwYXNzaXN0YW50J3MlMjByZXNwb25zZQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages, max_new_tokens=<span class="hljs-number">128</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Print the assistant&#x27;s response</span>`,wrap:!1}}),E=new T({props:{code:"JTdCJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTdE",highlighted:"{&#x27;role&#x27;: &#x27;assistant&#x27;, &#x27;content&#x27;: &quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;}",wrap:!1}}),A=new Jt({props:{title:"What are “generation prompts”?",local:"what-are-generation-prompts",headingTag:"h2"}}),P=new T({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),O=new T({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),et=new T({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),at=new Jt({props:{title:"What does “continue_final_message” do?",local:"what-does-continuefinalmessage-do",headingTag:"h2"}}),it=new T({props:{code:"Y2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkNhbiUyMHlvdSUyMGZvcm1hdCUyMHRoZSUyMGFuc3dlciUyMGluJTIwSlNPTiUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJyU3QiUyMm5hbWUlMjIlM0ElMjAlMjInJTdEJTJDJTBBJTVEJTBBJTBBZm9ybWF0dGVkX2NoYXQlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RUcnVlJTJDJTIwcmV0dXJuX2RpY3QlM0RUcnVlJTJDJTIwY29udGludWVfZmluYWxfbWVzc2FnZSUzRFRydWUpJTBBbW9kZWwuZ2VuZXJhdGUoKipmb3JtYXR0ZWRfY2hhdCk=",highlighted:`chat = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can you format the answer in JSON?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&#x27;{&quot;name&quot;: &quot;&#x27;</span>},
]

formatted_chat = tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, continue_final_message=<span class="hljs-literal">True</span>)
model.generate(**formatted_chat)`,wrap:!1}}),f=new Ee({props:{$$slots:{default:[ss]},$$scope:{ctx:Ut}}}),rt=new Jt({props:{title:"Can I use chat templates in training?",local:"can-i-use-chat-templates-in-training",headingTag:"h2"}}),ht=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),mt=new T({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),b=new Ee({props:{$$slots:{default:[ls]},$$scope:{ctx:Ut}}}),ct=new es({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/chat_template_basics.md"}}),{c(){M=o("meta"),j=a(),c=o("p"),U=a(),r(g.$$.fragment),J=a(),w=o("p"),w.innerHTML=ce,wt=a(),I=o("p"),I.innerHTML=Ue,jt=a(),G=o("p"),G.innerHTML=Je,gt=a(),C=o("p"),C.innerHTML=Te,ft=a(),r(Z.$$.fragment),bt=a(),B=o("p"),B.innerHTML=we,It=a(),k=o("p"),k.innerHTML=je,Gt=a(),r($.$$.fragment),Ct=a(),v=o("p"),v.innerHTML=ge,Zt=a(),r(Q.$$.fragment),Bt=a(),W=o("p"),W.innerHTML=fe,kt=a(),N=o("p"),N.innerHTML=be,$t=a(),r(q.$$.fragment),vt=a(),z=o("p"),z.textContent=Ie,Qt=a(),r(x.$$.fragment),Wt=a(),_=o("p"),_.textContent=Ge,Nt=a(),r(S.$$.fragment),qt=a(),R=o("p"),R.textContent=Ce,zt=a(),r(F.$$.fragment),xt=a(),H=o("p"),H.textContent=Ze,_t=a(),r(X.$$.fragment),St=a(),V=o("p"),V.innerHTML=Be,Rt=a(),r(Y.$$.fragment),Ft=a(),r(E.$$.fragment),Ht=a(),L=o("p"),L.innerHTML=ke,Xt=a(),r(A.$$.fragment),Vt=a(),D=o("p"),D.innerHTML=$e,Yt=a(),r(P.$$.fragment),Et=a(),K=o("p"),K.textContent=ve,Lt=a(),r(O.$$.fragment),At=a(),tt=o("p"),tt.innerHTML=Qe,Dt=a(),r(et.$$.fragment),Pt=a(),st=o("p"),st.textContent=We,Kt=a(),lt=o("p"),lt.innerHTML=Ne,Ot=a(),r(at.$$.fragment),te=a(),nt=o("p"),nt.innerHTML=qe,ee=a(),ot=o("p"),ot.textContent=ze,se=a(),r(it.$$.fragment),le=a(),pt=o("p"),pt.textContent=xe,ae=a(),Mt=o("p"),Mt.innerHTML=_e,ne=a(),r(f.$$.fragment),oe=a(),r(rt.$$.fragment),ie=a(),yt=o("p"),yt.innerHTML=Se,pe=a(),r(ht.$$.fragment),Me=a(),ut=o("p"),ut.textContent=Re,re=a(),r(mt.$$.fragment),ye=a(),dt=o("p"),dt.innerHTML=Fe,he=a(),r(b.$$.fragment),ue=a(),r(ct.$$.fragment),me=a(),Tt=o("p"),this.h()},l(t){const e=Oe("svelte-u9bgzb",document.head);M=i(e,"META",{name:!0,content:!0}),e.forEach(s),j=n(t),c=i(t,"P",{}),Ve(c).forEach(s),U=n(t),y(g.$$.fragment,t),J=n(t),w=i(t,"P",{"data-svelte-h":!0}),p(w)!=="svelte-ydi30o"&&(w.innerHTML=ce),wt=n(t),I=i(t,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1q7lkkp"&&(I.innerHTML=Ue),jt=n(t),G=i(t,"P",{"data-svelte-h":!0}),p(G)!=="svelte-w1vlk3"&&(G.innerHTML=Je),gt=n(t),C=i(t,"P",{"data-svelte-h":!0}),p(C)!=="svelte-19ob0qf"&&(C.innerHTML=Te),ft=n(t),y(Z.$$.fragment,t),bt=n(t),B=i(t,"P",{"data-svelte-h":!0}),p(B)!=="svelte-gwj0xd"&&(B.innerHTML=we),It=n(t),k=i(t,"P",{"data-svelte-h":!0}),p(k)!=="svelte-14wqu22"&&(k.innerHTML=je),Gt=n(t),y($.$$.fragment,t),Ct=n(t),v=i(t,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1010uaq"&&(v.innerHTML=ge),Zt=n(t),y(Q.$$.fragment,t),Bt=n(t),W=i(t,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1tiyfu1"&&(W.innerHTML=fe),kt=n(t),N=i(t,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1vun9x2"&&(N.innerHTML=be),$t=n(t),y(q.$$.fragment,t),vt=n(t),z=i(t,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1vy7akj"&&(z.textContent=Ie),Qt=n(t),y(x.$$.fragment,t),Wt=n(t),_=i(t,"P",{"data-svelte-h":!0}),p(_)!=="svelte-hj60o5"&&(_.textContent=Ge),Nt=n(t),y(S.$$.fragment,t),qt=n(t),R=i(t,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1bfcqd3"&&(R.textContent=Ce),zt=n(t),y(F.$$.fragment,t),xt=n(t),H=i(t,"P",{"data-svelte-h":!0}),p(H)!=="svelte-k9m2iy"&&(H.textContent=Ze),_t=n(t),y(X.$$.fragment,t),St=n(t),V=i(t,"P",{"data-svelte-h":!0}),p(V)!=="svelte-znnkjx"&&(V.innerHTML=Be),Rt=n(t),y(Y.$$.fragment,t),Ft=n(t),y(E.$$.fragment,t),Ht=n(t),L=i(t,"P",{"data-svelte-h":!0}),p(L)!=="svelte-5umvde"&&(L.innerHTML=ke),Xt=n(t),y(A.$$.fragment,t),Vt=n(t),D=i(t,"P",{"data-svelte-h":!0}),p(D)!=="svelte-rhnu79"&&(D.innerHTML=$e),Yt=n(t),y(P.$$.fragment,t),Et=n(t),K=i(t,"P",{"data-svelte-h":!0}),p(K)!=="svelte-jpbe39"&&(K.textContent=ve),Lt=n(t),y(O.$$.fragment,t),At=n(t),tt=i(t,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-61bp3d"&&(tt.innerHTML=Qe),Dt=n(t),y(et.$$.fragment,t),Pt=n(t),st=i(t,"P",{"data-svelte-h":!0}),p(st)!=="svelte-inq88f"&&(st.textContent=We),Kt=n(t),lt=i(t,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-uz30n4"&&(lt.innerHTML=Ne),Ot=n(t),y(at.$$.fragment,t),te=n(t),nt=i(t,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-y1327w"&&(nt.innerHTML=qe),ee=n(t),ot=i(t,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-wwwyth"&&(ot.textContent=ze),se=n(t),y(it.$$.fragment,t),le=n(t),pt=i(t,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-j6m3wj"&&(pt.textContent=xe),ae=n(t),Mt=i(t,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-hfpwig"&&(Mt.innerHTML=_e),ne=n(t),y(f.$$.fragment,t),oe=n(t),y(rt.$$.fragment,t),ie=n(t),yt=i(t,"P",{"data-svelte-h":!0}),p(yt)!=="svelte-i3l9c1"&&(yt.innerHTML=Se),pe=n(t),y(ht.$$.fragment,t),Me=n(t),ut=i(t,"P",{"data-svelte-h":!0}),p(ut)!=="svelte-13505nn"&&(ut.textContent=Re),re=n(t),y(mt.$$.fragment,t),ye=n(t),dt=i(t,"P",{"data-svelte-h":!0}),p(dt)!=="svelte-ziuqkt"&&(dt.innerHTML=Fe),he=n(t),y(b.$$.fragment,t),ue=n(t),y(ct.$$.fragment,t),me=n(t),Tt=i(t,"P",{}),Ve(Tt).forEach(s),this.h()},h(){Ye(M,"name","hf:doc:metadata"),Ye(M,"content",ns)},m(t,e){ts(document.head,M),l(t,j,e),l(t,c,e),l(t,U,e),h(g,t,e),l(t,J,e),l(t,w,e),l(t,wt,e),l(t,I,e),l(t,jt,e),l(t,G,e),l(t,gt,e),l(t,C,e),l(t,ft,e),h(Z,t,e),l(t,bt,e),l(t,B,e),l(t,It,e),l(t,k,e),l(t,Gt,e),h($,t,e),l(t,Ct,e),l(t,v,e),l(t,Zt,e),h(Q,t,e),l(t,Bt,e),l(t,W,e),l(t,kt,e),l(t,N,e),l(t,$t,e),h(q,t,e),l(t,vt,e),l(t,z,e),l(t,Qt,e),h(x,t,e),l(t,Wt,e),l(t,_,e),l(t,Nt,e),h(S,t,e),l(t,qt,e),l(t,R,e),l(t,zt,e),h(F,t,e),l(t,xt,e),l(t,H,e),l(t,_t,e),h(X,t,e),l(t,St,e),l(t,V,e),l(t,Rt,e),h(Y,t,e),l(t,Ft,e),h(E,t,e),l(t,Ht,e),l(t,L,e),l(t,Xt,e),h(A,t,e),l(t,Vt,e),l(t,D,e),l(t,Yt,e),h(P,t,e),l(t,Et,e),l(t,K,e),l(t,Lt,e),h(O,t,e),l(t,At,e),l(t,tt,e),l(t,Dt,e),h(et,t,e),l(t,Pt,e),l(t,st,e),l(t,Kt,e),l(t,lt,e),l(t,Ot,e),h(at,t,e),l(t,te,e),l(t,nt,e),l(t,ee,e),l(t,ot,e),l(t,se,e),h(it,t,e),l(t,le,e),l(t,pt,e),l(t,ae,e),l(t,Mt,e),l(t,ne,e),h(f,t,e),l(t,oe,e),h(rt,t,e),l(t,ie,e),l(t,yt,e),l(t,pe,e),h(ht,t,e),l(t,Me,e),l(t,ut,e),l(t,re,e),h(mt,t,e),l(t,ye,e),l(t,dt,e),l(t,he,e),h(b,t,e),l(t,ue,e),h(ct,t,e),l(t,me,e),l(t,Tt,e),de=!0},p(t,[e]){const He={};e&2&&(He.$$scope={dirty:e,ctx:t}),f.$set(He);const Xe={};e&2&&(Xe.$$scope={dirty:e,ctx:t}),b.$set(Xe)},i(t){de||(u(g.$$.fragment,t),u(Z.$$.fragment,t),u($.$$.fragment,t),u(Q.$$.fragment,t),u(q.$$.fragment,t),u(x.$$.fragment,t),u(S.$$.fragment,t),u(F.$$.fragment,t),u(X.$$.fragment,t),u(Y.$$.fragment,t),u(E.$$.fragment,t),u(A.$$.fragment,t),u(P.$$.fragment,t),u(O.$$.fragment,t),u(et.$$.fragment,t),u(at.$$.fragment,t),u(it.$$.fragment,t),u(f.$$.fragment,t),u(rt.$$.fragment,t),u(ht.$$.fragment,t),u(mt.$$.fragment,t),u(b.$$.fragment,t),u(ct.$$.fragment,t),de=!0)},o(t){m(g.$$.fragment,t),m(Z.$$.fragment,t),m($.$$.fragment,t),m(Q.$$.fragment,t),m(q.$$.fragment,t),m(x.$$.fragment,t),m(S.$$.fragment,t),m(F.$$.fragment,t),m(X.$$.fragment,t),m(Y.$$.fragment,t),m(E.$$.fragment,t),m(A.$$.fragment,t),m(P.$$.fragment,t),m(O.$$.fragment,t),m(et.$$.fragment,t),m(at.$$.fragment,t),m(it.$$.fragment,t),m(f.$$.fragment,t),m(rt.$$.fragment,t),m(ht.$$.fragment,t),m(mt.$$.fragment,t),m(b.$$.fragment,t),m(ct.$$.fragment,t),de=!1},d(t){t&&(s(j),s(c),s(U),s(J),s(w),s(wt),s(I),s(jt),s(G),s(gt),s(C),s(ft),s(bt),s(B),s(It),s(k),s(Gt),s(Ct),s(v),s(Zt),s(Bt),s(W),s(kt),s(N),s($t),s(vt),s(z),s(Qt),s(Wt),s(_),s(Nt),s(qt),s(R),s(zt),s(xt),s(H),s(_t),s(St),s(V),s(Rt),s(Ft),s(Ht),s(L),s(Xt),s(Vt),s(D),s(Yt),s(Et),s(K),s(Lt),s(At),s(tt),s(Dt),s(Pt),s(st),s(Kt),s(lt),s(Ot),s(te),s(nt),s(ee),s(ot),s(se),s(le),s(pt),s(ae),s(Mt),s(ne),s(oe),s(ie),s(yt),s(pe),s(Me),s(ut),s(re),s(ye),s(dt),s(he),s(ue),s(me),s(Tt)),s(M),d(g,t),d(Z,t),d($,t),d(Q,t),d(q,t),d(x,t),d(S,t),d(F,t),d(X,t),d(Y,t),d(E,t),d(A,t),d(P,t),d(O,t),d(et,t),d(at,t),d(it,t),d(f,t),d(rt,t),d(ht,t),d(mt,t),d(b,t),d(ct,t)}}}const ns='{"title":"Getting Started with Chat Templates for Text LLMs","local":"getting-started-with-chat-templates-for-text-llms","sections":[{"title":"How do I use chat templates?","local":"how-do-i-use-chat-templates","sections":[],"depth":2},{"title":"Is there an automated pipeline for chat?","local":"is-there-an-automated-pipeline-for-chat","sections":[],"depth":2},{"title":"What are “generation prompts”?","local":"what-are-generation-prompts","sections":[],"depth":2},{"title":"What does “continue_final_message” do?","local":"what-does-continuefinalmessage-do","sections":[],"depth":2},{"title":"Can I use chat templates in training?","local":"can-i-use-chat-templates-in-training","sections":[],"depth":2}],"depth":1}';function os(Ut){return De(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hs extends Pe{constructor(M){super(),Ke(this,M,os,as,Ae,{})}}export{hs as component};
