import{s as Kl,o as Ol,n as Ul}from"../chunks/scheduler.25b97de1.js";import{S as ts,i as ls,g as p,s as n,r as y,A as ss,h as M,f as s,c as a,j as Dl,u as J,x as i,k as Pl,y as es,a as e,v as r,d as T,t as m,w as d}from"../chunks/index.d9030fc9.js";import{T as wl}from"../chunks/Tip.baa67368.js";import{C as f}from"../chunks/CodeBlock.e6cd0d95.js";import{H as bt,E as ns}from"../chunks/EditOnGithub.91d95064.js";function as(B){let o,b=`The output format above is specific to the <code>Hermes-2-Pro</code> model we’re using in this example. Other models may emit different
tool call formats, and you may need to do some manual parsing at this step. For example, <code>Llama-3.1</code> models will emit
slightly different JSON, with <code>parameters</code> instead of <code>arguments</code>. Regardless of the format the model outputs, you
should add the tool call to the conversation in the format below, with <code>tool_calls</code>, <code>function</code> and <code>arguments</code> keys.`;return{c(){o=p("p"),o.innerHTML=b},l(c){o=M(c,"P",{"data-svelte-h":!0}),i(o)!=="svelte-1wfdwuk"&&(o.innerHTML=b)},m(c,h){e(c,o,h)},p:Ul,d(c){c&&s(o)}}}function os(B){let o,b=`If you’re familiar with the OpenAI API, you should pay attention to an important difference here - the <code>tool_call</code> is
a dict, but in the OpenAI API it’s a JSON string. Passing a string may cause errors or strange model behaviour!`;return{c(){o=p("p"),o.innerHTML=b},l(c){o=M(c,"P",{"data-svelte-h":!0}),i(o)!=="svelte-fq11ea"&&(o.innerHTML=b)},m(c,h){e(c,o,h)},p:Ul,d(c){c&&s(o)}}}function ps(B){let o,b=`Some model architectures, notably Mistral/Mixtral, also require a <code>tool_call_id</code> here, which should be
9 randomly-generated alphanumeric characters, and assigned to the <code>id</code> key of the tool call
dictionary. The same key should also be assigned to the <code>tool_call_id</code> key of the tool response dictionary below, so
that tool calls can be matched to tool responses. So, for Mistral/Mixtral models, the code above would be:`,c,h,C,I,w="and",G,j,U;return h=new f({props:{code:"dG9vbF9jYWxsX2lkJTIwJTNEJTIwJTIyOUFlM2JEYzJGJTIyJTIwJTIwJTIzJTIwUmFuZG9tJTIwSUQlMkMlMjA5JTIwYWxwaGFudW1lcmljJTIwY2hhcmFjdGVycyUwQXRvb2xfY2FsbCUyMCUzRCUyMCU3QiUyMm5hbWUlMjIlM0ElMjAlMjJnZXRfY3VycmVudF90ZW1wZXJhdHVyZSUyMiUyQyUyMCUyMmFyZ3VtZW50cyUyMiUzQSUyMCU3QiUyMmxvY2F0aW9uJTIyJTNBJTIwJTIyUGFyaXMlMkMlMjBGcmFuY2UlMjIlMkMlMjAlMjJ1bml0JTIyJTNBJTIwJTIyY2Vsc2l1cyUyMiU3RCU3RCUwQW1lc3NhZ2VzLmFwcGVuZCglN0IlMjJyb2xlJTIyJTNBJTIwJTIyYXNzaXN0YW50JTIyJTJDJTIwJTIydG9vbF9jYWxscyUyMiUzQSUyMCU1QiU3QiUyMnR5cGUlMjIlM0ElMjAlMjJmdW5jdGlvbiUyMiUyQyUyMCUyMmlkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call_id = <span class="hljs-string">&quot;9Ae3bDc2F&quot;</span>  <span class="hljs-comment"># Random ID, 9 alphanumeric characters</span>
tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),j=new f({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIydG9vbF9jYWxsX2lkJTIyJTNBJTIwdG9vbF9jYWxsX2lkJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;tool_call_id&quot;</span>: tool_call_id, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),{c(){o=p("p"),o.innerHTML=b,c=n(),y(h.$$.fragment),C=n(),I=p("p"),I.textContent=w,G=n(),y(j.$$.fragment)},l(u){o=M(u,"P",{"data-svelte-h":!0}),i(o)!=="svelte-70hqps"&&(o.innerHTML=b),c=a(u),J(h.$$.fragment,u),C=a(u),I=M(u,"P",{"data-svelte-h":!0}),i(I)!=="svelte-1qlona5"&&(I.textContent=w),G=a(u),J(j.$$.fragment,u)},m(u,g){e(u,o,g),e(u,c,g),r(h,u,g),e(u,C,g),e(u,I,g),e(u,G,g),r(j,u,g),U=!0},p:Ul,i(u){U||(T(h.$$.fragment,u),T(j.$$.fragment,u),U=!0)},o(u){m(h.$$.fragment,u),m(j.$$.fragment,u),U=!1},d(u){u&&(s(o),s(c),s(C),s(I),s(G)),d(h,u),d(j,u)}}}function Ms(B){let o,b="The <code>documents</code> input for retrieval-augmented generation is not widely supported, and many models have chat templates which simply ignore this input.",c,h,C="To verify if a model supports the <code>documents</code> input, you can read its model card, or <code>print(tokenizer.chat_template)</code> to see if the <code>documents</code> key is used anywhere.",I,w,G='One model class that does support it, though, is Cohere’s <a href="https://huggingface.co/CohereForAI/c4ai-command-r-08-2024" rel="nofollow">Command-R</a> and <a href="https://huggingface.co/CohereForAI/c4ai-command-r-plus-08-2024" rel="nofollow">Command-R+</a>, through their <code>rag</code> chat template. You can see additional examples of grounded generation using this feature in their model cards.';return{c(){o=p("p"),o.innerHTML=b,c=n(),h=p("p"),h.innerHTML=C,I=n(),w=p("p"),w.innerHTML=G},l(j){o=M(j,"P",{"data-svelte-h":!0}),i(o)!=="svelte-bl710l"&&(o.innerHTML=b),c=a(j),h=M(j,"P",{"data-svelte-h":!0}),i(h)!=="svelte-qpz2lz"&&(h.innerHTML=C),I=a(j),w=M(j,"P",{"data-svelte-h":!0}),i(w)!=="svelte-kg7zp3"&&(w.innerHTML=G)},m(j,U){e(j,o,U),e(j,c,U),e(j,h,U),e(j,I,U),e(j,w,U)},p:Ul,d(j){j&&(s(o),s(c),s(h),s(I),s(w))}}}function is(B){let o,b,c,h,C,I,w,G=`The only argument that <code>apply_chat_template</code> requires is <code>messages</code>. However, you can pass any keyword
argument to <code>apply_chat_template</code> and it will be accessible inside the template. This gives you a lot of freedom to use
chat templates for many things. There are no restrictions on the names or the format of these arguments - you can pass
strings, lists, dicts or whatever else you want.`,j,U,u=`That said, there are some common use-cases for these extra arguments,
such as passing tools for function calling, or documents for retrieval-augmented generation. In these common cases,
we have some opinionated recommendations about what the names and formats of these arguments should be, which are
described in the sections below. We encourage model authors to make their chat templates compatible with this format,
to make it easy to transfer tool-calling code between models.`,g,v,Ct,$,Il=`“Tool use” LLMs can choose to call functions as external tools before generating an answer. When passing tools
to a tool-use model, you can simply pass a list of functions to the <code>tools</code> argument:`,gt,x,Bt,V,bl=`In order for this to work correctly, you should write your functions in the format above, so that they can be parsed
correctly as tools. Specifically, you should follow these rules:`,Gt,X,fl=`<li>The function should have a descriptive name</li> <li>Every argument must have a type hint</li> <li>The function must have a docstring in the standard Google style (in other words, an initial function description<br/>
followed by an <code>Args:</code> block that describes the arguments, unless the function does not have any arguments.)</li> <li>Do not include types in the <code>Args:</code> block. In other words, write <code>a: The first number to multiply</code>, not
<code>a (int): The first number to multiply</code>. Type hints should go in the function header instead.</li> <li>The function can have a return type and a <code>Returns:</code> block in the docstring. However, these are optional
because most tool-use models ignore them.</li>`,At,Q,qt,E,Cl=`The sample code above is enough to list the available tools for your model, but what happens if it wants to actually use
one? If that happens, you should:`,Zt,R,gl="<li>Parse the model’s output to get the tool name(s) and arguments.</li> <li>Add the model’s tool call(s) to the conversation.</li> <li>Call the corresponding function(s) with those arguments.</li> <li>Add the result(s) to the conversation</li>",Wt,k,vt,N,Bl=`Let’s walk through a tool use example, step by step. For this example, we will use an 8B <code>Hermes-2-Pro</code> model,
as it is one of the highest-performing tool-use models in its size category at the time of writing. If you have the
memory, you can consider using a larger model instead like <a href="https://huggingface.co/CohereForAI/c4ai-command-r-v01" rel="nofollow">Command-R</a>
or <a href="https://huggingface.co/mistralai/Mixtral-8x22B-Instruct-v0.1" rel="nofollow">Mixtral-8x22B</a>, both of which also support tool use
and offer even stronger performance.`,$t,_,Gl="First, let’s load our model and tokenizer:",xt,S,Vt,z,Al="Next, let’s define a list of tools:",Xt,H,Qt,Y,ql="Now, let’s set up a conversation for our bot:",Et,F,Rt,L,Zl="Now, let’s apply the chat template and generate a response:",kt,D,Nt,P,Wl="And we get:",_t,K,St,O,vl=`The model has called the function with valid arguments, in the format requested by the function docstring. It has
inferred that we’re most likely referring to the Paris in France, and it remembered that, as the home of SI units,
the temperature in France should certainly be displayed in Celsius.`,zt,A,Ht,tt,$l="Next, let’s append the model’s tool call to the conversation.",Yt,lt,Ft,q,Lt,st,xl=`Now that we’ve added the tool call to the conversation, we can call the function and append the result to the
conversation. Since we’re just using a dummy function for this example that always returns 22.0, we can just append
that result directly.`,Dt,et,Pt,Z,Kt,nt,Vl="Finally, let’s let the assistant read the function outputs and continue chatting with the user:",Ot,at,tl,ot,Xl="And we get:",ll,pt,sl,Mt,Ql=`Although this was a simple demo with dummy tools and a single call, the same technique works with
multiple real tools and longer conversations. This can be a powerful way to extend the capabilities of conversational
agents with real-time information, computational tools like calculators, or access to large databases.`,el,it,nl,ut,El=`Each function you pass to the <code>tools</code> argument of <code>apply_chat_template</code> is converted into a
<a href="https://json-schema.org/learn/getting-started-step-by-step" rel="nofollow">JSON schema</a>. These schemas
are then passed to the model chat template. In other words, tool-use models do not see your functions directly, and they
never see the actual code inside them. What they care about is the function <strong>definitions</strong> and the <strong>arguments</strong> they
need to pass to them - they care about what the tools do and how to use them, not how they work! It is up to you
to read their outputs, detect if they have requested to use a tool, pass their arguments to the tool function, and
return the response in the chat.`,al,ct,Rl=`Generating JSON schemas to pass to the template should be automatic and invisible as long as your functions
follow the specification above, but if you encounter problems, or you simply want more control over the conversion,
you can handle the conversion manually. Here is an example of a manual schema conversion.`,ol,yt,pl,Jt,kl="This will yield:",Ml,rt,il,Tt,Nl=`If you wish, you can edit these schemas, or even write them from scratch yourself without using <code>get_json_schema</code> at
all. JSON schemas can be passed directly to the <code>tools</code> argument of
<code>apply_chat_template</code> - this gives you a lot of power to define precise schemas for more complex functions. Be careful,
though - the more complex your schemas, the more likely the model is to get confused when dealing with them! We
recommend simple function signatures where possible, keeping arguments (and especially complex, nested arguments)
to a minimum.`,ul,mt,_l="Here is an example of defining schemas by hand, and passing them directly to <code>apply_chat_template</code>:",cl,dt,yl,jt,Jl,ht,Sl=`“Retrieval-augmented generation” or “RAG” LLMs can search a corpus of documents for information before responding
to a query. This allows models to vastly expand their knowledge base beyond their limited context size. Our
recommendation for RAG models is that their template
should accept a <code>documents</code> argument. This should be a list of documents, where each “document”
is a single dict with <code>title</code> and <code>contents</code> keys, both of which are strings. Because this format is much simpler
than the JSON schemas used for tools, no helper functions are necessary.`,rl,wt,zl="Here’s an example of a RAG template in action:",Tl,Ut,ml,W,dl,It,jl,ft,hl;return C=new bt({props:{title:"Expanding Chat Templates with Tools and Documents",local:"expanding-chat-templates-with-tools-and-documents",headingTag:"h1"}}),v=new bt({props:{title:"Tool use / function calling",local:"tool-use--function-calling",headingTag:"h2"}}),x=new f({props:{code:"aW1wb3J0JTIwZGF0ZXRpbWUlMEElMEFkZWYlMjBjdXJyZW50X3RpbWUoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkdldCUyMHRoZSUyMGN1cnJlbnQlMjBsb2NhbCUyMHRpbWUlMjBhcyUyMGElMjBzdHJpbmcuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3RyKGRhdGV0aW1lLm5vdygpKSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBdG9vbHMlMjAlM0QlMjAlNUJjdXJyZW50X3RpbWUlMkMlMjBtdWx0aXBseSU1RCUwQSUwQW1vZGVsX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoJTBBJTIwJTIwJTIwJTIwbWVzc2FnZXMlMkMlMEElMjAlMjAlMjAlMjB0b29scyUzRHRvb2xzJTBBKQ==",highlighted:`<span class="hljs-keyword">import</span> datetime

<span class="hljs-keyword">def</span> <span class="hljs-title function_">current_time</span>():
    <span class="hljs-string">&quot;&quot;&quot;Get the current local time as a string.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">str</span>(datetime.now())

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

tools = [current_time, multiply]

model_input = tokenizer.apply_chat_template(
    messages,
    tools=tools
)`,wrap:!1}}),Q=new bt({props:{title:"Passing tool results to the model",local:"passing-tool-results-to-the-model",headingTag:"h3"}}),k=new bt({props:{title:"A complete tool use example",local:"a-complete-tool-use-example",headingTag:"h3"}}),S=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMk5vdXNSZXNlYXJjaCUyRkhlcm1lcy0yLVByby1MbGFtYS0zLThCJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;NousResearch/Hermes-2-Pro-Llama-3-8B&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),H=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_temperature</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span>, unit: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current temperature at a location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
        unit: The unit to return the temperature in. (choices: [&quot;celsius&quot;, &quot;fahrenheit&quot;])
    Returns:
        The current temperature at the specified location in the specified units, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">22.</span>  <span class="hljs-comment"># A real function should probably actually get the temperature!</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_current_wind_speed</span>(<span class="hljs-params">location: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">float</span>:
    <span class="hljs-string">&quot;&quot;&quot;
    Get the current wind speed in km/h at a given location.
    
    Args:
        location: The location to get the temperature for, in the format &quot;City, Country&quot;
    Returns:
        The current wind speed at the given location in km/h, as a float.
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> <span class="hljs-number">6.</span>  <span class="hljs-comment"># A real function should probably actually get the wind speed!</span>

tools = [get_current_temperature, get_current_wind_speed]`,wrap:!1}}),F=new f({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIyc3lzdGVtJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMllvdSUyMGFyZSUyMGElMjBib3QlMjB0aGF0JTIwcmVzcG9uZHMlMjB0byUyMHdlYXRoZXIlMjBxdWVyaWVzLiUyMFlvdSUyMHNob3VsZCUyMHJlcGx5JTIwd2l0aCUyMHRoZSUyMHVuaXQlMjB1c2VkJTIwaW4lMjB0aGUlMjBxdWVyaWVkJTIwbG9jYXRpb24uJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySGV5JTJDJTIwd2hhdCdzJTIwdGhlJTIwdGVtcGVyYXR1cmUlMjBpbiUyMFBhcmlzJTIwcmlnaHQlMjBub3clM0YlMjIlN0QlMEElNUQ=",highlighted:`messages = [
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a bot that responds to weather queries. You should reply with the unit used in the queried location.&quot;</span>},
  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hey, what&#x27;s the temperature in Paris right now?&quot;</span>}
]`,wrap:!1}}),D=new f({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),K=new f({props:{code:"JTNDdG9vbF9jYWxsJTNFJTBBJTdCJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTdEJTBBJTNDJTJGdG9vbF9jYWxsJTNFJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:`&lt;tool_call&gt;
{&quot;arguments&quot;: {&quot;location&quot;: &quot;Paris, France&quot;, &quot;unit&quot;: &quot;celsius&quot;}, &quot;name&quot;: &quot;get_current_temperature&quot;}
&lt;/tool_call&gt;&lt;|im_end|&gt;`,wrap:!1}}),A=new wl({props:{$$slots:{default:[as]},$$scope:{ctx:B}}}),lt=new f({props:{code:"dG9vbF9jYWxsJTIwJTNEJTIwJTdCJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyYXJndW1lbnRzJTIyJTNBJTIwJTdCJTIybG9jYXRpb24lMjIlM0ElMjAlMjJQYXJpcyUyQyUyMEZyYW5jZSUyMiUyQyUyMCUyMnVuaXQlMjIlM0ElMjAlMjJjZWxzaXVzJTIyJTdEJTdEJTBBbWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJ0b29sX2NhbGxzJTIyJTNBJTIwJTVCJTdCJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjB0b29sX2NhbGwlN0QlNUQlN0Qp",highlighted:`tool_call = {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;arguments&quot;</span>: {<span class="hljs-string">&quot;location&quot;</span>: <span class="hljs-string">&quot;Paris, France&quot;</span>, <span class="hljs-string">&quot;unit&quot;</span>: <span class="hljs-string">&quot;celsius&quot;</span>}}
messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;tool_calls&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, <span class="hljs-string">&quot;function&quot;</span>: tool_call}]})`,wrap:!1}}),q=new wl({props:{warning:!0,$$slots:{default:[os]},$$scope:{ctx:B}}}),et=new f({props:{code:"bWVzc2FnZXMuYXBwZW5kKCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ0b29sJTIyJTJDJTIwJTIybmFtZSUyMiUzQSUyMCUyMmdldF9jdXJyZW50X3RlbXBlcmF0dXJlJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMjIyLjAlMjIlN0Qp",highlighted:'messages.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;tool&quot;</span>, <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_temperature&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;22.0&quot;</span>})',wrap:!1}}),Z=new wl({props:{$$slots:{default:[ps]},$$scope:{ctx:B}}}),at=new f({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b29scyUzRHRvb2xzJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSUyQyUyMHJldHVybl9kaWN0JTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8obW9kZWwuZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSU3RCUwQW91dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXQlNUIwJTVEJTVCbGVuKGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU1QjAlNUQpJTNBJTVEKSk=",highlighted:`inputs = tokenizer.apply_chat_template(messages, tools=tools, add_generation_prompt=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(model.device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">128</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(out[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>]):]))`,wrap:!1}}),pt=new f({props:{code:"VGhlJTIwY3VycmVudCUyMHRlbXBlcmF0dXJlJTIwaW4lMjBQYXJpcyUyQyUyMEZyYW5jZSUyMGlzJTIwMjIuMCUyMCVDMiVCMCUyMENlbHNpdXMuJTNDJTdDaW1fZW5kJTdDJTNF",highlighted:"The current temperature in Paris, France is 22.0 ° Celsius.&lt;|im_end|&gt;",wrap:!1}}),it=new bt({props:{title:"Understanding tool schemas",local:"understanding-tool-schemas",headingTag:"h3"}}),yt=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy51dGlscyUyMGltcG9ydCUyMGdldF9qc29uX3NjaGVtYSUwQSUwQWRlZiUyMG11bHRpcGx5KGElM0ElMjBmbG9hdCUyQyUyMGIlM0ElMjBmbG9hdCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBBJTIwZnVuY3Rpb24lMjB0aGF0JTIwbXVsdGlwbGllcyUyMHR3byUyMG51bWJlcnMlMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjBBcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYSUzQSUyMFRoZSUyMGZpcnN0JTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGIlM0ElMjBUaGUlMjBzZWNvbmQlMjBudW1iZXIlMjB0byUyMG11bHRpcGx5JTBBJTIwJTIwJTIwJTIwJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYSUyMColMjBiJTBBJTBBc2NoZW1hJTIwJTNEJTIwZ2V0X2pzb25fc2NoZW1hKG11bHRpcGx5KSUwQXByaW50KHNjaGVtYSk=",highlighted:`<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> get_json_schema

<span class="hljs-keyword">def</span> <span class="hljs-title function_">multiply</span>(<span class="hljs-params">a: <span class="hljs-built_in">float</span>, b: <span class="hljs-built_in">float</span></span>):
    <span class="hljs-string">&quot;&quot;&quot;
    A function that multiplies two numbers
    
    Args:
        a: The first number to multiply
        b: The second number to multiply
    &quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> a * b

schema = get_json_schema(multiply)
<span class="hljs-built_in">print</span>(schema)`,wrap:!1}}),rt=new f({props:{code:"JTdCJTBBJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZ1bmN0aW9uJTIyJTJDJTIwJTBBJTIwJTIwJTIyZnVuY3Rpb24lMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJuYW1lJTIyJTNBJTIwJTIybXVsdGlwbHklMjIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjJkZXNjcmlwdGlvbiUyMiUzQSUyMCUyMkElMjBmdW5jdGlvbiUyMHRoYXQlMjBtdWx0aXBsaWVzJTIwdHdvJTIwbnVtYmVycyUyMiUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyb2JqZWN0JTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIycHJvcGVydGllcyUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmElMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIybnVtYmVyJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjAlMjJUaGUlMjBmaXJzdCUyMG51bWJlciUyMHRvJTIwbXVsdGlwbHklMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJiJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMm51bWJlciUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRlc2NyaXB0aW9uJTIyJTNBJTIwJTIyVGhlJTIwc2Vjb25kJTIwbnVtYmVyJTIwdG8lMjBtdWx0aXBseSUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlcXVpcmVkJTIyJTNBJTIwJTVCJTIyYSUyMiUyQyUyMCUyMmIlMjIlNUQlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlN0QlMEElN0Q=",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span> 
  <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;multiply&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;A function that multiplies two numbers&quot;</span><span class="hljs-punctuation">,</span> 
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
      <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;a&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span> 
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The first number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
        <span class="hljs-attr">&quot;b&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
          <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;number&quot;</span><span class="hljs-punctuation">,</span>
          <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The second number to multiply&quot;</span>
        <span class="hljs-punctuation">}</span>
      <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> 
      <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;a&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;b&quot;</span><span class="hljs-punctuation">]</span>
    <span class="hljs-punctuation">}</span>
  <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),dt=new f({props:{code:"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",highlighted:`<span class="hljs-comment"># A simple function that takes no arguments</span>
current_time = {
  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>, 
  <span class="hljs-string">&quot;function&quot;</span>: {
    <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;current_time&quot;</span>,
    <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current local time as a string.&quot;</span>,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>,
      <span class="hljs-string">&#x27;properties&#x27;</span>: {}
    }
  }
}

<span class="hljs-comment"># A more complete function that takes two numerical arguments</span>
multiply = {
  <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;function&#x27;</span>,
  <span class="hljs-string">&#x27;function&#x27;</span>: {
    <span class="hljs-string">&#x27;name&#x27;</span>: <span class="hljs-string">&#x27;multiply&#x27;</span>,
    <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;A function that multiplies two numbers&#x27;</span>, 
    <span class="hljs-string">&#x27;parameters&#x27;</span>: {
      <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;object&#x27;</span>, 
      <span class="hljs-string">&#x27;properties&#x27;</span>: {
        <span class="hljs-string">&#x27;a&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>,
          <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The first number to multiply&#x27;</span>
        }, 
        <span class="hljs-string">&#x27;b&#x27;</span>: {
          <span class="hljs-string">&#x27;type&#x27;</span>: <span class="hljs-string">&#x27;number&#x27;</span>, <span class="hljs-string">&#x27;description&#x27;</span>: <span class="hljs-string">&#x27;The second number to multiply&#x27;</span>
        }
      }, 
      <span class="hljs-string">&#x27;required&#x27;</span>: [<span class="hljs-string">&#x27;a&#x27;</span>, <span class="hljs-string">&#x27;b&#x27;</span>]
    }
  }
}

model_input = tokenizer.apply_chat_template(
    messages,
    tools = [current_time, multiply]
)`,wrap:!1}}),jt=new bt({props:{title:"Retrieval-augmented generation",local:"retrieval-augmented-generation",headingTag:"h2"}}),Ut=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-comment"># Load the model and tokenizer</span>
model_id = <span class="hljs-string">&quot;CohereForAI/c4ai-command-r-v01-4bit&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
device = model.device <span class="hljs-comment"># Get the device the model is loaded on</span>

<span class="hljs-comment"># Define conversation input</span>
conversation = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What has Man always dreamed of?&quot;</span>}
]

<span class="hljs-comment"># Define documents for retrieval-based generation</span>
documents = [
    {
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Moon: Our Age-Old Foe&quot;</span>, 
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Man has always dreamed of destroying the moon. In this essay, I shall...&quot;</span>
    },
    {
        <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;The Sun: Our Age-Old Friend&quot;</span>,
        <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Although often underappreciated, the sun provides several notable benefits...&quot;</span>
    }
]

<span class="hljs-comment"># Tokenize conversation and documents using a RAG template, returning PyTorch tensors.</span>
input_ids = tokenizer.apply_chat_template(
    conversation=conversation,
    documents=documents,
    chat_template=<span class="hljs-string">&quot;rag&quot;</span>,
    tokenize=<span class="hljs-literal">True</span>,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)

<span class="hljs-comment"># Generate a response </span>
gen_tokens = model.generate(
    input_ids,
    max_new_tokens=<span class="hljs-number">100</span>,
    do_sample=<span class="hljs-literal">True</span>,
    temperature=<span class="hljs-number">0.3</span>,
    )

<span class="hljs-comment"># Decode and print the generated text along with generation prompt</span>
gen_text = tokenizer.decode(gen_tokens[<span class="hljs-number">0</span>])
<span class="hljs-built_in">print</span>(gen_text)`,wrap:!1}}),W=new wl({props:{$$slots:{default:[Ms]},$$scope:{ctx:B}}}),It=new ns({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/chat_template_tools_and_documents.md"}}),{c(){o=p("meta"),b=n(),c=p("p"),h=n(),y(C.$$.fragment),I=n(),w=p("p"),w.innerHTML=G,j=n(),U=p("p"),U.textContent=u,g=n(),y(v.$$.fragment),Ct=n(),$=p("p"),$.innerHTML=Il,gt=n(),y(x.$$.fragment),Bt=n(),V=p("p"),V.textContent=bl,Gt=n(),X=p("ul"),X.innerHTML=fl,At=n(),y(Q.$$.fragment),qt=n(),E=p("p"),E.textContent=Cl,Zt=n(),R=p("ol"),R.innerHTML=gl,Wt=n(),y(k.$$.fragment),vt=n(),N=p("p"),N.innerHTML=Bl,$t=n(),_=p("p"),_.textContent=Gl,xt=n(),y(S.$$.fragment),Vt=n(),z=p("p"),z.textContent=Al,Xt=n(),y(H.$$.fragment),Qt=n(),Y=p("p"),Y.textContent=ql,Et=n(),y(F.$$.fragment),Rt=n(),L=p("p"),L.textContent=Zl,kt=n(),y(D.$$.fragment),Nt=n(),P=p("p"),P.textContent=Wl,_t=n(),y(K.$$.fragment),St=n(),O=p("p"),O.textContent=vl,zt=n(),y(A.$$.fragment),Ht=n(),tt=p("p"),tt.textContent=$l,Yt=n(),y(lt.$$.fragment),Ft=n(),y(q.$$.fragment),Lt=n(),st=p("p"),st.textContent=xl,Dt=n(),y(et.$$.fragment),Pt=n(),y(Z.$$.fragment),Kt=n(),nt=p("p"),nt.textContent=Vl,Ot=n(),y(at.$$.fragment),tl=n(),ot=p("p"),ot.textContent=Xl,ll=n(),y(pt.$$.fragment),sl=n(),Mt=p("p"),Mt.textContent=Ql,el=n(),y(it.$$.fragment),nl=n(),ut=p("p"),ut.innerHTML=El,al=n(),ct=p("p"),ct.textContent=Rl,ol=n(),y(yt.$$.fragment),pl=n(),Jt=p("p"),Jt.textContent=kl,Ml=n(),y(rt.$$.fragment),il=n(),Tt=p("p"),Tt.innerHTML=Nl,ul=n(),mt=p("p"),mt.innerHTML=_l,cl=n(),y(dt.$$.fragment),yl=n(),y(jt.$$.fragment),Jl=n(),ht=p("p"),ht.innerHTML=Sl,rl=n(),wt=p("p"),wt.textContent=zl,Tl=n(),y(Ut.$$.fragment),ml=n(),y(W.$$.fragment),dl=n(),y(It.$$.fragment),jl=n(),ft=p("p"),this.h()},l(t){const l=ss("svelte-u9bgzb",document.head);o=M(l,"META",{name:!0,content:!0}),l.forEach(s),b=a(t),c=M(t,"P",{}),Dl(c).forEach(s),h=a(t),J(C.$$.fragment,t),I=a(t),w=M(t,"P",{"data-svelte-h":!0}),i(w)!=="svelte-dd615e"&&(w.innerHTML=G),j=a(t),U=M(t,"P",{"data-svelte-h":!0}),i(U)!=="svelte-dcun4m"&&(U.textContent=u),g=a(t),J(v.$$.fragment,t),Ct=a(t),$=M(t,"P",{"data-svelte-h":!0}),i($)!=="svelte-6sd0wq"&&($.innerHTML=Il),gt=a(t),J(x.$$.fragment,t),Bt=a(t),V=M(t,"P",{"data-svelte-h":!0}),i(V)!=="svelte-608o9m"&&(V.textContent=bl),Gt=a(t),X=M(t,"UL",{"data-svelte-h":!0}),i(X)!=="svelte-17htrb"&&(X.innerHTML=fl),At=a(t),J(Q.$$.fragment,t),qt=a(t),E=M(t,"P",{"data-svelte-h":!0}),i(E)!=="svelte-11962fa"&&(E.textContent=Cl),Zt=a(t),R=M(t,"OL",{"data-svelte-h":!0}),i(R)!=="svelte-1vd84s7"&&(R.innerHTML=gl),Wt=a(t),J(k.$$.fragment,t),vt=a(t),N=M(t,"P",{"data-svelte-h":!0}),i(N)!=="svelte-1oi0gsn"&&(N.innerHTML=Bl),$t=a(t),_=M(t,"P",{"data-svelte-h":!0}),i(_)!=="svelte-o8n6v4"&&(_.textContent=Gl),xt=a(t),J(S.$$.fragment,t),Vt=a(t),z=M(t,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1q7358y"&&(z.textContent=Al),Xt=a(t),J(H.$$.fragment,t),Qt=a(t),Y=M(t,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-11hfyaa"&&(Y.textContent=ql),Et=a(t),J(F.$$.fragment,t),Rt=a(t),L=M(t,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1usrd3e"&&(L.textContent=Zl),kt=a(t),J(D.$$.fragment,t),Nt=a(t),P=M(t,"P",{"data-svelte-h":!0}),i(P)!=="svelte-13505nn"&&(P.textContent=Wl),_t=a(t),J(K.$$.fragment,t),St=a(t),O=M(t,"P",{"data-svelte-h":!0}),i(O)!=="svelte-nxltbo"&&(O.textContent=vl),zt=a(t),J(A.$$.fragment,t),Ht=a(t),tt=M(t,"P",{"data-svelte-h":!0}),i(tt)!=="svelte-336ooj"&&(tt.textContent=$l),Yt=a(t),J(lt.$$.fragment,t),Ft=a(t),J(q.$$.fragment,t),Lt=a(t),st=M(t,"P",{"data-svelte-h":!0}),i(st)!=="svelte-1mv1vl9"&&(st.textContent=xl),Dt=a(t),J(et.$$.fragment,t),Pt=a(t),J(Z.$$.fragment,t),Kt=a(t),nt=M(t,"P",{"data-svelte-h":!0}),i(nt)!=="svelte-1qjybqz"&&(nt.textContent=Vl),Ot=a(t),J(at.$$.fragment,t),tl=a(t),ot=M(t,"P",{"data-svelte-h":!0}),i(ot)!=="svelte-13505nn"&&(ot.textContent=Xl),ll=a(t),J(pt.$$.fragment,t),sl=a(t),Mt=M(t,"P",{"data-svelte-h":!0}),i(Mt)!=="svelte-1evxmus"&&(Mt.textContent=Ql),el=a(t),J(it.$$.fragment,t),nl=a(t),ut=M(t,"P",{"data-svelte-h":!0}),i(ut)!=="svelte-pl4mbs"&&(ut.innerHTML=El),al=a(t),ct=M(t,"P",{"data-svelte-h":!0}),i(ct)!=="svelte-37xmdz"&&(ct.textContent=Rl),ol=a(t),J(yt.$$.fragment,t),pl=a(t),Jt=M(t,"P",{"data-svelte-h":!0}),i(Jt)!=="svelte-1bfcqd3"&&(Jt.textContent=kl),Ml=a(t),J(rt.$$.fragment,t),il=a(t),Tt=M(t,"P",{"data-svelte-h":!0}),i(Tt)!=="svelte-19t6fs5"&&(Tt.innerHTML=Nl),ul=a(t),mt=M(t,"P",{"data-svelte-h":!0}),i(mt)!=="svelte-1nlyrys"&&(mt.innerHTML=_l),cl=a(t),J(dt.$$.fragment,t),yl=a(t),J(jt.$$.fragment,t),Jl=a(t),ht=M(t,"P",{"data-svelte-h":!0}),i(ht)!=="svelte-1977j4z"&&(ht.innerHTML=Sl),rl=a(t),wt=M(t,"P",{"data-svelte-h":!0}),i(wt)!=="svelte-1xmnzcc"&&(wt.textContent=zl),Tl=a(t),J(Ut.$$.fragment,t),ml=a(t),J(W.$$.fragment,t),dl=a(t),J(It.$$.fragment,t),jl=a(t),ft=M(t,"P",{}),Dl(ft).forEach(s),this.h()},h(){Pl(o,"name","hf:doc:metadata"),Pl(o,"content",us)},m(t,l){es(document.head,o),e(t,b,l),e(t,c,l),e(t,h,l),r(C,t,l),e(t,I,l),e(t,w,l),e(t,j,l),e(t,U,l),e(t,g,l),r(v,t,l),e(t,Ct,l),e(t,$,l),e(t,gt,l),r(x,t,l),e(t,Bt,l),e(t,V,l),e(t,Gt,l),e(t,X,l),e(t,At,l),r(Q,t,l),e(t,qt,l),e(t,E,l),e(t,Zt,l),e(t,R,l),e(t,Wt,l),r(k,t,l),e(t,vt,l),e(t,N,l),e(t,$t,l),e(t,_,l),e(t,xt,l),r(S,t,l),e(t,Vt,l),e(t,z,l),e(t,Xt,l),r(H,t,l),e(t,Qt,l),e(t,Y,l),e(t,Et,l),r(F,t,l),e(t,Rt,l),e(t,L,l),e(t,kt,l),r(D,t,l),e(t,Nt,l),e(t,P,l),e(t,_t,l),r(K,t,l),e(t,St,l),e(t,O,l),e(t,zt,l),r(A,t,l),e(t,Ht,l),e(t,tt,l),e(t,Yt,l),r(lt,t,l),e(t,Ft,l),r(q,t,l),e(t,Lt,l),e(t,st,l),e(t,Dt,l),r(et,t,l),e(t,Pt,l),r(Z,t,l),e(t,Kt,l),e(t,nt,l),e(t,Ot,l),r(at,t,l),e(t,tl,l),e(t,ot,l),e(t,ll,l),r(pt,t,l),e(t,sl,l),e(t,Mt,l),e(t,el,l),r(it,t,l),e(t,nl,l),e(t,ut,l),e(t,al,l),e(t,ct,l),e(t,ol,l),r(yt,t,l),e(t,pl,l),e(t,Jt,l),e(t,Ml,l),r(rt,t,l),e(t,il,l),e(t,Tt,l),e(t,ul,l),e(t,mt,l),e(t,cl,l),r(dt,t,l),e(t,yl,l),r(jt,t,l),e(t,Jl,l),e(t,ht,l),e(t,rl,l),e(t,wt,l),e(t,Tl,l),r(Ut,t,l),e(t,ml,l),r(W,t,l),e(t,dl,l),r(It,t,l),e(t,jl,l),e(t,ft,l),hl=!0},p(t,[l]){const Hl={};l&2&&(Hl.$$scope={dirty:l,ctx:t}),A.$set(Hl);const Yl={};l&2&&(Yl.$$scope={dirty:l,ctx:t}),q.$set(Yl);const Fl={};l&2&&(Fl.$$scope={dirty:l,ctx:t}),Z.$set(Fl);const Ll={};l&2&&(Ll.$$scope={dirty:l,ctx:t}),W.$set(Ll)},i(t){hl||(T(C.$$.fragment,t),T(v.$$.fragment,t),T(x.$$.fragment,t),T(Q.$$.fragment,t),T(k.$$.fragment,t),T(S.$$.fragment,t),T(H.$$.fragment,t),T(F.$$.fragment,t),T(D.$$.fragment,t),T(K.$$.fragment,t),T(A.$$.fragment,t),T(lt.$$.fragment,t),T(q.$$.fragment,t),T(et.$$.fragment,t),T(Z.$$.fragment,t),T(at.$$.fragment,t),T(pt.$$.fragment,t),T(it.$$.fragment,t),T(yt.$$.fragment,t),T(rt.$$.fragment,t),T(dt.$$.fragment,t),T(jt.$$.fragment,t),T(Ut.$$.fragment,t),T(W.$$.fragment,t),T(It.$$.fragment,t),hl=!0)},o(t){m(C.$$.fragment,t),m(v.$$.fragment,t),m(x.$$.fragment,t),m(Q.$$.fragment,t),m(k.$$.fragment,t),m(S.$$.fragment,t),m(H.$$.fragment,t),m(F.$$.fragment,t),m(D.$$.fragment,t),m(K.$$.fragment,t),m(A.$$.fragment,t),m(lt.$$.fragment,t),m(q.$$.fragment,t),m(et.$$.fragment,t),m(Z.$$.fragment,t),m(at.$$.fragment,t),m(pt.$$.fragment,t),m(it.$$.fragment,t),m(yt.$$.fragment,t),m(rt.$$.fragment,t),m(dt.$$.fragment,t),m(jt.$$.fragment,t),m(Ut.$$.fragment,t),m(W.$$.fragment,t),m(It.$$.fragment,t),hl=!1},d(t){t&&(s(b),s(c),s(h),s(I),s(w),s(j),s(U),s(g),s(Ct),s($),s(gt),s(Bt),s(V),s(Gt),s(X),s(At),s(qt),s(E),s(Zt),s(R),s(Wt),s(vt),s(N),s($t),s(_),s(xt),s(Vt),s(z),s(Xt),s(Qt),s(Y),s(Et),s(Rt),s(L),s(kt),s(Nt),s(P),s(_t),s(St),s(O),s(zt),s(Ht),s(tt),s(Yt),s(Ft),s(Lt),s(st),s(Dt),s(Pt),s(Kt),s(nt),s(Ot),s(tl),s(ot),s(ll),s(sl),s(Mt),s(el),s(nl),s(ut),s(al),s(ct),s(ol),s(pl),s(Jt),s(Ml),s(il),s(Tt),s(ul),s(mt),s(cl),s(yl),s(Jl),s(ht),s(rl),s(wt),s(Tl),s(ml),s(dl),s(jl),s(ft)),s(o),d(C,t),d(v,t),d(x,t),d(Q,t),d(k,t),d(S,t),d(H,t),d(F,t),d(D,t),d(K,t),d(A,t),d(lt,t),d(q,t),d(et,t),d(Z,t),d(at,t),d(pt,t),d(it,t),d(yt,t),d(rt,t),d(dt,t),d(jt,t),d(Ut,t),d(W,t),d(It,t)}}}const us='{"title":"Expanding Chat Templates with Tools and Documents","local":"expanding-chat-templates-with-tools-and-documents","sections":[{"title":"Tool use / function calling","local":"tool-use--function-calling","sections":[{"title":"Passing tool results to the model","local":"passing-tool-results-to-the-model","sections":[],"depth":3},{"title":"A complete tool use example","local":"a-complete-tool-use-example","sections":[],"depth":3},{"title":"Understanding tool schemas","local":"understanding-tool-schemas","sections":[],"depth":3}],"depth":2},{"title":"Retrieval-augmented generation","local":"retrieval-augmented-generation","sections":[],"depth":2}],"depth":1}';function cs(B){return Ol(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ds extends ts{constructor(o){super(),ls(this,o,cs,is,Kl,{})}}export{ds as component};
