import{s as Ia,f as Ua,o as La,n as Po}from"../chunks/scheduler.25b97de1.js";import{S as Ca,i as ja,g as r,s as n,r as c,A as $a,h as i,f as o,c as s,j as $,u as d,x as f,k as J,y as l,a,v as m,d as p,t as g,w as h}from"../chunks/index.d9030fc9.js";import{T as za}from"../chunks/Tip.baa67368.js";import{D as q}from"../chunks/Docstring.ffac8efa.js";import{C as F}from"../chunks/CodeBlock.e6cd0d95.js";import{E as Ja}from"../chunks/ExampleCodeBlock.22dfe688.js";import{P as xa}from"../chunks/PipelineTag.5f100392.js";import{H as I,E as ka}from"../chunks/EditOnGithub.91d95064.js";function qa(B){let _,U="Example:",v,T,y;return T=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTGxhdmFDb25maWclMkMlMjBDTElQVmlzaW9uQ29uZmlnJTJDJTIwTGxhbWFDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwQ0xJUC12aXNpb24lMjBjb25maWclMEF2aXNpb25fY29uZmlnJTIwJTNEJTIwQ0xJUFZpc2lvbkNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMExsYW1hJTIwY29uZmlnJTBBdGV4dF9jb25maWclMjAlM0QlMjBMbGFtYUNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMExsYXZhJTIwbGxhdmEtMS41LTdiJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMExsYXZhQ29uZmlnKHZpc2lvbl9jb25maWclMkMlMjB0ZXh0X2NvbmZpZyklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwbGxhdmEtMS41LTdiJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBMbGF2YUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbihjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaForConditionalGeneration, LlavaConfig, CLIPVisionConfig, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = CLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llava llava-1.5-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlavaConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the llava-1.5-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){_=r("p"),_.textContent=U,v=n(),c(T.$$.fragment)},l(u){_=i(u,"P",{"data-svelte-h":!0}),f(_)!=="svelte-11lpom8"&&(_.textContent=U),v=s(u),d(T.$$.fragment,u)},m(u,b){a(u,_,b),a(u,v,b),m(T,u,b),y=!0},p:Po,i(u){y||(p(T.$$.fragment,u),y=!0)},o(u){g(T.$$.fragment,u),y=!1},d(u){u&&(o(_),o(v)),h(T,u)}}}function Fa(B){let _,U=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){_=r("p"),_.innerHTML=U},l(v){_=i(v,"P",{"data-svelte-h":!0}),f(_)!=="svelte-fincs2"&&(_.innerHTML=U)},m(v,T){a(v,_,T)},p:Po,d(v){v&&o(_)}}}function Na(B){let _,U="Example:",v,T,y;return T=new F({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMExsYXZhRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGF2YUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybGxhdmEtaGYlMkZsbGF2YS0xLjUtN2ItaGYlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybGxhdmEtaGYlMkZsbGF2YS0xLjUtN2ItaGYlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbldoYXQncyUyMHRoZSUyMGNvbnRlbnQlMjBvZiUyMHRoZSUyMGltYWdlJTNGJTIwQVNTSVNUQU5UJTNBJTIyJTBBdXJsJTIwJTNEJTIwJTIyaHR0cHMlM0ElMkYlMkZ3d3cuaWxhbmtlbG1hbi5vcmclMkZzdG9wc2lnbnMlMkZhdXN0cmFsaWEuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwdGV4dCUzRHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTUpJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;USER: &lt;image&gt;\\nWhat&#x27;s the content of the image? ASSISTANT:&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">15</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;USER:  \\nWhat&#x27;s the content of the image? ASSISTANT: The image features a busy city street with a stop sign prominently displayed&quot;</span>`,wrap:!1}}),{c(){_=r("p"),_.textContent=U,v=n(),c(T.$$.fragment)},l(u){_=i(u,"P",{"data-svelte-h":!0}),f(_)!=="svelte-11lpom8"&&(_.textContent=U),v=s(u),d(T.$$.fragment,u)},m(u,b){a(u,_,b),a(u,v,b),m(T,u,b),y=!0},p:Po,i(u){y||(p(T.$$.fragment,u),y=!0)},o(u){g(T.$$.fragment,u),y=!1},d(u){u&&(o(_),o(v)),h(T,u)}}}function Ba(B){let _,U,v,T,y,u,b,gt,X,Go="LLaVa is an open-source chatbot trained by fine-tuning LlamA/Vicuna on GPT-generated multimodal instruction-following data. It is an auto-regressive language model, based on the transformer architecture. In other words, it is an multi-modal version of LLMs fine-tuned for chat / instructions.",ht,A,Zo='The LLaVa model was proposed in <a href="https://arxiv.org/abs/2304.08485" rel="nofollow">Visual Instruction Tuning</a> and improved in <a href="https://arxiv.org/pdf/2310.03744" rel="nofollow">Improved Baselines with Visual Instruction Tuning</a> by Haotian Liu, Chunyuan Li, Yuheng Li and Yong Jae Lee.',ft,Y,Ro="The abstract from the paper is the following:",ut,D,So="<em>Large multimodal models (LMM) have recently shown encouraging progress with visual instruction tuning. In this note, we show that the fully-connected vision-language cross-modal connector in LLaVA is surprisingly powerful and data-efficient. With simple modifications to LLaVA, namely, using CLIP-ViT-L-336px with an MLP projection and adding academic-task-oriented VQA data with simple response formatting prompts, we establish stronger baselines that achieve state-of-the-art across 11 benchmarks. Our final 13B checkpoint uses merely 1.2M publicly available data, and finishes full training in ∼1 day on a single 8-A100 node. We hope this can make state-of-the-art LMM research more accessible. Code and model will be publicly available</em>",_t,W,Vo,Tt,O,Eo='LLaVa architecture. Taken from the <a href="https://arxiv.org/abs/2304.08485">original paper.</a>',vt,K,Qo=`This model was contributed by <a href="https://huggingface.co/ArthurZ" rel="nofollow">ArthurZ</a> and <a href="https://huggingface.co/ybelkada" rel="nofollow">ybelkada</a>.
The original code can be found <a href="https://github.com/haotian-liu/LLaVA/tree/main/llava" rel="nofollow">here</a>.`,yt,ee,bt,te,Ho="<li><p>We advise users to use <code>padding_side=&quot;left&quot;</code> when computing batched generation as it leads to more accurate results. Simply make sure to call <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before generating.</p></li> <li><p>Note the model has not been explicitly trained to process multiple images in the same prompt, although this is technically possible, you may experience inaccurate results.</p></li>",wt,oe,Xo="<p>[!NOTE]\nLLaVA models after release v4.46 will raise warnings about adding <code>processor.patch_size = {{patch_size}}</code>, <code>processor.num_additional_image_tokens = {{num_additional_image_tokens}}</code> and processor.vision_feature_select_strategy = {{vision_feature_select_strategy}}<code>. It is strongly recommended to add the attributes to the processor if you own the model checkpoint, or open a PR if it is not owned by you. Adding these attributes means that LLaVA will try to infer the number of image tokens required per image and expand the text with as many </code>&lt;image&gt;<code>placeholders as there will be tokens. Usually it is around 500 tokens per image, so make sure that the text is not truncated as otherwise there will be failure when merging the embeddings. The attributes can be obtained from model config, as</code>model.config.vision_config.patch_size<code>or</code>model.config.vision_feature_select_strategy<code>. The </code>num_additional_image_tokens<code>should be</code>1<code>if the vision backbone adds a CLS token or</code>0` if nothing extra is added to the vision patches.</p>",Mt,ae,Jt,ne,Ao="Each <strong>checkpoint</strong> is trained with a specific prompt format, depending on the underlying large language model backbone. To ensure correct formatting, use the processor’s <code>apply_chat_template</code> method.",It,se,Yo="<strong>Important:</strong>",Ut,re,Do="<li>You must construct a conversation history — passing a plain string won’t work.</li> <li>Each message should be a dictionary with <code>&quot;role&quot;</code> and <code>&quot;content&quot;</code> keys.</li> <li>The <code>&quot;content&quot;</code> should be a list of dictionaries for different modalities like <code>&quot;text&quot;</code> and <code>&quot;image&quot;</code>.</li>",Lt,ie,Oo=`Here’s an example of how to structure your input.
We will use <a href="https://huggingface.co/llava-hf/llava-1.5-7b-hf" rel="nofollow">llava-hf/llava-1.5-7b-hf</a> and a conversation history of text and image. Each content field has to be a list of dicts, as follows:`,Ct,le,jt,ce,Ko="<li>If you want to construct a chat prompt yourself, below is a list of prompt formats accepted by each llava checkpoint:</li>",$t,de,ea='<a href="https://huggingface.co/collections/llava-hf/llava-interleave-668e19a97da0036aad4a2f19" rel="nofollow">llava-interleave models</a> requires the following format:',zt,me,xt,pe,ta="For multiple turns conversation:",kt,ge,qt,he,oa='<a href="https://huggingface.co/collections/llava-hf/llava-15-65f762d5b6941db5c2ba07e0" rel="nofollow">llava-1.5 models</a> requires the following format:',Ft,fe,Nt,ue,aa="For multiple turns conversation:",Bt,_e,Wt,Te,na="🚀 <strong>Bonus:</strong> If you’re using <code>transformers&gt;=4.49.0</code>, you can also get a vectorized output from <code>apply_chat_template</code>. See the <strong>Usage Examples</strong> below for more details on how to use it.",Pt,ve,Gt,ye,Zt,be,Rt,we,St,Me,sa="LLaVa also supports batched inference. Here is how you can do it:",Vt,Je,Et,Ie,Qt,Ue,ra='In order to match the logits of the <a href="https://github.com/haotian-liu/LLaVA/tree/main" rel="nofollow">original implementation</a>, one needs to additionally specify <code>do_pad=True</code> when instantiating <code>LLavaImageProcessor</code>:',Ht,Le,Xt,Ce,At,je,ia='Flash Attention 2 is an even faster, optimized version of the previous optimization, please refer to the <a href="https://huggingface.co/docs/transformers/perf_infer_gpu_one" rel="nofollow">Flash Attention 2 section of performance docs</a>.',Yt,$e,Dt,ze,la="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with BEiT.",Ot,xe,Kt,ke,ca='<li>A <a href="https://colab.research.google.com/drive/1qsl6cd2c8gGtEW1xV5io7S8NHh-Cp1TV?usp=sharing" rel="nofollow">Google Colab demo</a> on how to run Llava on a free-tier Google colab instance leveraging 4-bit inference.</li> <li>A <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/LLaVa/Inference_with_LLaVa_for_multimodal_generation.ipynb" rel="nofollow">similar notebook</a> showcasing batched inference. 🌎</li>',eo,qe,to,w,Fe,_o,De,da=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaForConditionalGeneration">LlavaForConditionalGeneration</a>. It is used to instantiate an
Llava model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Llava-9B.`,To,Oe,ma='e.g. <a href="https://huggingface.co/llava-hf/llava-9b" rel="nofollow">llava-hf/llava-9b</a>',vo,Ke,pa=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,yo,P,oo,Ne,ao,z,Be,bo,et,ga="Constructs a LLaVa image processor.",wo,G,We,Mo,tt,ha="Preprocess an image or batch of images.",no,Pe,so,x,Ge,Jo,ot,fa="Constructs a fast Llava image processor.",Io,Z,Ze,Uo,at,ua="Preprocess an image or batch of images.",ro,Re,io,M,Se,Lo,nt,_a="Constructs a LLaVa processor which wraps a LLaVa image processor and a LLaMa tokenizer into a single processor.",Co,st,Ta=`<a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaImageProcessor">LlavaImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor.decode">decode()</a> for more information.`,jo,R,Ve,$o,rt,va=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,zo,S,Ee,xo,it,ya=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,lo,Qe,co,L,He,ko,lt,ba=`The LLAVA model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,qo,ct,wa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Fo,j,Xe,No,dt,Ma='The <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaForConditionalGeneration">LlavaForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Bo,V,Wo,E,mo,Ae,po,pt,go;return y=new I({props:{title:"LLaVa",local:"llava",headingTag:"h1"}}),b=new I({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ee=new I({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ae=new I({props:{title:"Formatting Prompts with Chat Templates",local:"formatting-prompts-with-chat-templates",headingTag:"h3"}}),le=new F({props:{code:"JTBBJTBBJTBBJTBBJTBBJTIyVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbiUzQ1doYXQlRTIlODAlOTlzJTIwc2hvd24lMjBpbiUyMHRoaXMlMjBpbWFnZSUzRiUyMEFTU0lTVEFOVCUzQSUyMFRoaXMlMjBpbWFnZSUyMHNob3dzJTIwYSUyMHJlZCUyMHN0b3AlMjBzaWduLiUzQyUyRnMlM0VVU0VSJTNBJTIwRGVzY3JpYmUlMjB0aGUlMjBpbWFnZSUyMGluJTIwbW9yZSUyMGRldGFpbHMuJTIwQVNTSVNUQU5UJTNBJTIy",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What’s shown in this image?&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;This image shows a red stop sign.&quot;</span>},]
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe the image in more details.&quot;</span>},
        ],
    },
]

text_prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Note that the template simply formats your prompt, you still have to tokenize it and obtain pixel values for your images</span>
<span class="hljs-built_in">print</span>(text_prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;USER: &lt;image&gt;\\n&lt;What’s shown in this image? ASSISTANT: This image shows a red stop sign.&lt;/s&gt;USER: Describe the image in more details. ASSISTANT:&quot;</span>`,wrap:!1}}),me=new F({props:{code:"JTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTIwJTNDaW1hZ2UlM0UlNUNuV2hhdCUyMGlzJTIwc2hvd24lMjBpbiUyMHRoaXMlMjBpbWFnZSUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTIy",highlighted:'<span class="hljs-string">&quot;&lt;|im_start|&gt;user &lt;image&gt;\\nWhat is shown in this image?&lt;|im_end|&gt;&lt;|im_start|&gt;assistant&quot;</span>',wrap:!1}}),ge=new F({props:{code:"JTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTIwJTNDaW1hZ2UlM0UlNUNuJTNDcHJvbXB0MSUzRSUzQyU3Q2ltX2VuZCU3QyUzRSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTIwJTNDYW5zd2VyMSUzRSUzQyU3Q2ltX2VuZCU3QyUzRSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciUyMCUzQ2ltYWdlJTNFJTVDbiUzQ3Byb21wdDElM0UlM0MlN0NpbV9lbmQlN0MlM0UlM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUyMCUyMg==",highlighted:'<span class="hljs-string">&quot;&lt;|im_start|&gt;user &lt;image&gt;\\n&lt;prompt1&gt;&lt;|im_end|&gt;&lt;|im_start|&gt;assistant &lt;answer1&gt;&lt;|im_end|&gt;&lt;|im_start|&gt;user &lt;image&gt;\\n&lt;prompt1&gt;&lt;|im_end|&gt;&lt;|im_start|&gt;assistant &quot;</span>',wrap:!1}}),fe=new F({props:{code:"JTIyVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbiUzQ3Byb21wdCUzRSUyMEFTU0lTVEFOVCUzQSUyMg==",highlighted:'<span class="hljs-string">&quot;USER: &lt;image&gt;\\n&lt;prompt&gt; ASSISTANT:&quot;</span>',wrap:!1}}),_e=new F({props:{code:"JTIyVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbiUzQ3Byb21wdDElM0UlMjBBU1NJU1RBTlQlM0ElMjAlM0NhbnN3ZXIxJTNFJTNDJTJGcyUzRVVTRVIlM0ElMjAlM0Nwcm9tcHQyJTNFJTIwQVNTSVNUQU5UJTNBJTIwJTNDYW5zd2VyMiUzRSUzQyUyRnMlM0VVU0VSJTNBJTIwJTNDcHJvbXB0MyUzRSUyMEFTU0lTVEFOVCUzQSUyMg==",highlighted:'<span class="hljs-string">&quot;USER: &lt;image&gt;\\n&lt;prompt1&gt; ASSISTANT: &lt;answer1&gt;&lt;/s&gt;USER: &lt;prompt2&gt; ASSISTANT: &lt;answer2&gt;&lt;/s&gt;USER: &lt;prompt3&gt; ASSISTANT:&quot;</span>',wrap:!1}}),ve=new I({props:{title:"Usage examples",local:"usage-examples",headingTag:"h2"}}),ye=new I({props:{title:"Single input inference",local:"single-input-inference",headingTag:"h3"}}),be=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMExsYXZhRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBJTIzJTIwTG9hZCUyMHRoZSUyMG1vZGVsJTIwaW4lMjBoYWxmLXByZWNpc2lvbiUwQW1vZGVsJTIwJTNEJTIwTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmxsYXZhLWhmJTJGbGxhdmEtMS41LTdiLWhmJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIybGxhdmEtaGYlMkZsbGF2YS0xLjUtN2ItaGYlMjIpJTBBJTBBY29udmVyc2F0aW9uJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMmltYWdlJTIyJTJDJTIwJTIydXJsJTIyJTNBJTIwJTIyaHR0cHMlM0ElMkYlMkZ3d3cuaWxhbmtlbG1hbi5vcmclMkZzdG9wc2lnbnMlMkZhdXN0cmFsaWEuanBnJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIydHlwZSUyMiUzQSUyMCUyMnRleHQlMjIlMkMlMjAlMjJ0ZXh0JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwc2hvd24lMjBpbiUyMHRoaXMlMjBpbWFnZSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvci5hcHBseV9jaGF0X3RlbXBsYXRlKCUwQSUyMCUyMCUyMCUyMGNvbnZlcnNhdGlvbiUyQyUwQSUyMCUyMCUyMCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fZGljdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTBBKS50byhtb2RlbC5kZXZpY2UlMkMlMjB0b3JjaC5mbG9hdDE2KSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDMwKSUwQXByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaForConditionalGeneration

<span class="hljs-comment"># Load the model in half-precision</span>
model = LlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
        ],
    },
]

inputs = processor.apply_chat_template(
    conversation,
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
).to(model.device, torch.float16)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">30</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),we=new I({props:{title:"Batched inference",local:"batched-inference",headingTag:"h3"}}),Je=new F({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaForConditionalGeneration

<span class="hljs-comment"># Load the model in half-precision</span>
model = LlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-1.5-7b-hf&quot;</span>)


<span class="hljs-comment"># Prepare a batch of two prompts</span>
conversation_1 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
        ],
    },
]

conversation_2 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
        ],
    },
]

inputs = processor.apply_chat_template(
    [conversation_1, conversation_2],
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    padding=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
).to(model.device, torch.float16)


<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">30</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ie=new I({props:{title:"Note regarding reproducing original implementation",local:"note-regarding-reproducing-original-implementation",headingTag:"h2"}}),Le=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExMYXZhSW1hZ2VQcm9jZXNzb3IlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBMTGF2YUltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGbGxhdmEtaGYlMkZsbGF2YS0xLjUtN2ItaGYlMjIlMkMlMjBkb19wYWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LLavaImageProcessor

image_processor = LLavaImageProcessor.from_pretrained(<span class="hljs-string">&quot;https://huggingface.co/llava-hf/llava-1.5-7b-hf&quot;</span>, do_pad=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ce=new I({props:{title:"Using Flash Attention 2",local:"using-flash-attention-2",headingTag:"h3"}}),$e=new I({props:{title:"Resources",local:"resources",headingTag:"h2"}}),xe=new xa({props:{pipeline:"image-to-text"}}),qe=new I({props:{title:"LlavaConfig",local:"transformers.LlavaConfig",headingTag:"h2"}}),Fe=new q({props:{name:"class transformers.LlavaConfig",anchor:"transformers.LlavaConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 32000"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"vision_feature_layer",val:" = -2"},{name:"image_seq_length",val:" = 576"},{name:"multimodal_projector_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaConfig.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>CLIPVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.LlavaConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>LlamaConfig</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.LlavaConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.LlavaConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.LlavaConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaConfig.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 576) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"},{anchor:"transformers.LlavaConfig.multimodal_projector_bias",description:`<strong>multimodal_projector_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the multimodal projector.`,name:"multimodal_projector_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava/configuration_llava.py#L24"}}),P=new Ja({props:{anchor:"transformers.LlavaConfig.example",$$slots:{default:[qa]},$$scope:{ctx:B}}}),Ne=new I({props:{title:"LlavaImageProcessor",local:"transformers.LlavaImageProcessor",headingTag:"h2"}}),Be=new q({props:{name:"class transformers.LlavaImageProcessor",anchor:"transformers.LlavaImageProcessor",parameters:[{name:"do_pad",val:": bool = False"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to pad the image to a square based on the longest edge.
The padding value is determined by the <code>image_mean</code> parameter.
Can be overridden by <code>do_pad</code> in the <code>preprocess</code> method.`,name:"do_pad"},{anchor:"transformers.LlavaImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.LlavaImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.LlavaImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.LlavaImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava/image_processing_llava.py#L53"}}),We=new q({props:{name:"preprocess",anchor:"transformers.LlavaImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_pad",val:": bool = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": typing.Optional[PIL.Image.Resampling] = None"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Optional[int] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.LlavaImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image to a square based on the longest edge.
The padding value is determined by the <code>image_mean</code> parameter.`,name:"do_pad"},{anchor:"transformers.LlavaImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.LlavaImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.LlavaImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.LlavaImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.LlavaImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava/image_processing_llava.py#L279"}}),Pe=new I({props:{title:"LlavaImageProcessorFast",local:"transformers.LlavaImageProcessorFast",headingTag:"h2"}}),Ge=new q({props:{name:"class transformers.LlavaImageProcessorFast",anchor:"transformers.LlavaImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava.image_processing_llava_fast.LlavaFastImageProcessorInitKwargs]"}],parametersDescription:[{anchor:"transformers.LlavaImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaImageProcessorFast.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.default_to_square</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.LlavaImageProcessorFast.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>. Can be
overridden by the <code>resample</code> parameter in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.LlavaImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.LlavaImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Scale factor to use if rescaling the image. Only has an effect if <code>do_rescale</code> is set to <code>True</code>. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.LlavaImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaImageProcessorFast.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image to a square based on the longest edge. Can be overridden by the <code>do_pad</code> parameter`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava/image_processing_llava_fast.py#L72"}}),Ze=new q({props:{name:"preprocess",anchor:"transformers.LlavaImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava.image_processing_llava_fast.LlavaFastImageProcessorPreprocessKwargs]"}],parametersDescription:[{anchor:"transformers.LlavaImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> or <code>InterpolationMode</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.LlavaImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
do_pad (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>):
Whether to pad the image to a square based on the longest edge. Can be overridden by the <code>do_pad</code> parameter`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava/image_processing_llava_fast.py#L99"}}),Re=new I({props:{title:"LlavaProcessor",local:"transformers.LlavaProcessor",headingTag:"h2"}}),Se=new q({props:{name:"class transformers.LlavaProcessor",anchor:"transformers.LlavaProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"patch_size",val:" = None"},{name:"vision_feature_select_strategy",val:" = None"},{name:"chat_template",val:" = None"},{name:"image_token",val:" = '<image>'"},{name:"num_additional_image_tokens",val:" = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaImageProcessor">LlavaImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.LlavaProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.LlavaProcessor.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Patch size from the vision tower.`,name:"patch_size"},{anchor:"transformers.LlavaProcessor.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Shoudl be same as in model&#x2019;s config`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.LlavaProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"},{anchor:"transformers.LlavaProcessor.num_additional_image_tokens",description:`<strong>num_additional_image_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of additional tokens added to the image embeddings, such as CLS (+1). If the backbone has no CLS or other
extra tokens appended, no need to set this arg.`,name:"num_additional_image_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava/processing_llava.py#L40"}}),Ve=new q({props:{name:"batch_decode",anchor:"transformers.LlavaProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava/processing_llava.py#L175"}}),Ee=new q({props:{name:"decode",anchor:"transformers.LlavaProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava/processing_llava.py#L183"}}),Qe=new I({props:{title:"LlavaForConditionalGeneration",local:"transformers.LlavaForConditionalGeneration",headingTag:"h2"}}),He=new q({props:{name:"class transformers.LlavaForConditionalGeneration",anchor:"transformers.LlavaForConditionalGeneration",parameters:[{name:"config",val:": LlavaConfig"}],parametersDescription:[{anchor:"transformers.LlavaForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaConfig">LlavaConfig</a> or <code>LlavaVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava/modeling_llava.py#L243"}}),Xe=new q({props:{name:"forward",anchor:"transformers.LlavaForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"image_sizes",val:": Tensor = None"},{name:"**lm_kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaForConditionalGeneration.forward.pixel_values",description:'<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)) -- The tensors corresponding to the input images. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See [CLIPImageProcessor.__call__()](/docs/transformers/main/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__) for details ([]</code>LlavaProcessor`] uses\n<a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> for processing images).',name:"pixel_values"},{anchor:"transformers.LlavaForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlavaForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.LlavaForConditionalGeneration.forward.Args",description:`<strong>Args</strong> &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>logits_to_keep (<code>int</code> or <code>torch.Tensor</code>, <em>optional</em>):
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"Args"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava/modeling_llava.py#L327",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.llava.modeling_llava.LlavaCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaConfig"
>LlavaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size (batch_size, num_images, sequence_length, hidden_size)\`.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.llava.modeling_llava.LlavaCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),V=new za({props:{$$slots:{default:[Fa]},$$scope:{ctx:B}}}),E=new Ja({props:{anchor:"transformers.LlavaForConditionalGeneration.forward.example",$$slots:{default:[Na]},$$scope:{ctx:B}}}),Ae=new ka({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/llava.md"}}),{c(){_=r("meta"),U=n(),v=r("p"),T=n(),c(y.$$.fragment),u=n(),c(b.$$.fragment),gt=n(),X=r("p"),X.textContent=Go,ht=n(),A=r("p"),A.innerHTML=Zo,ft=n(),Y=r("p"),Y.textContent=Ro,ut=n(),D=r("p"),D.innerHTML=So,_t=n(),W=r("img"),Tt=n(),O=r("small"),O.innerHTML=Eo,vt=n(),K=r("p"),K.innerHTML=Qo,yt=n(),c(ee.$$.fragment),bt=n(),te=r("ul"),te.innerHTML=Ho,wt=n(),oe=r("blockquote"),oe.innerHTML=Xo,Mt=n(),c(ae.$$.fragment),Jt=n(),ne=r("p"),ne.innerHTML=Ao,It=n(),se=r("p"),se.innerHTML=Yo,Ut=n(),re=r("ul"),re.innerHTML=Do,Lt=n(),ie=r("p"),ie.innerHTML=Oo,Ct=n(),c(le.$$.fragment),jt=n(),ce=r("ul"),ce.innerHTML=Ko,$t=n(),de=r("p"),de.innerHTML=ea,zt=n(),c(me.$$.fragment),xt=n(),pe=r("p"),pe.textContent=ta,kt=n(),c(ge.$$.fragment),qt=n(),he=r("p"),he.innerHTML=oa,Ft=n(),c(fe.$$.fragment),Nt=n(),ue=r("p"),ue.textContent=aa,Bt=n(),c(_e.$$.fragment),Wt=n(),Te=r("p"),Te.innerHTML=na,Pt=n(),c(ve.$$.fragment),Gt=n(),c(ye.$$.fragment),Zt=n(),c(be.$$.fragment),Rt=n(),c(we.$$.fragment),St=n(),Me=r("p"),Me.textContent=sa,Vt=n(),c(Je.$$.fragment),Et=n(),c(Ie.$$.fragment),Qt=n(),Ue=r("p"),Ue.innerHTML=ra,Ht=n(),c(Le.$$.fragment),Xt=n(),c(Ce.$$.fragment),At=n(),je=r("p"),je.innerHTML=ia,Yt=n(),c($e.$$.fragment),Dt=n(),ze=r("p"),ze.textContent=la,Ot=n(),c(xe.$$.fragment),Kt=n(),ke=r("ul"),ke.innerHTML=ca,eo=n(),c(qe.$$.fragment),to=n(),w=r("div"),c(Fe.$$.fragment),_o=n(),De=r("p"),De.innerHTML=da,To=n(),Oe=r("p"),Oe.innerHTML=ma,vo=n(),Ke=r("p"),Ke.innerHTML=pa,yo=n(),c(P.$$.fragment),oo=n(),c(Ne.$$.fragment),ao=n(),z=r("div"),c(Be.$$.fragment),bo=n(),et=r("p"),et.textContent=ga,wo=n(),G=r("div"),c(We.$$.fragment),Mo=n(),tt=r("p"),tt.textContent=ha,no=n(),c(Pe.$$.fragment),so=n(),x=r("div"),c(Ge.$$.fragment),Jo=n(),ot=r("p"),ot.textContent=fa,Io=n(),Z=r("div"),c(Ze.$$.fragment),Uo=n(),at=r("p"),at.textContent=ua,ro=n(),c(Re.$$.fragment),io=n(),M=r("div"),c(Se.$$.fragment),Lo=n(),nt=r("p"),nt.textContent=_a,Co=n(),st=r("p"),st.innerHTML=Ta,jo=n(),R=r("div"),c(Ve.$$.fragment),$o=n(),rt=r("p"),rt.innerHTML=va,zo=n(),S=r("div"),c(Ee.$$.fragment),xo=n(),it=r("p"),it.innerHTML=ya,lo=n(),c(Qe.$$.fragment),co=n(),L=r("div"),c(He.$$.fragment),ko=n(),lt=r("p"),lt.innerHTML=ba,qo=n(),ct=r("p"),ct.innerHTML=wa,Fo=n(),j=r("div"),c(Xe.$$.fragment),No=n(),dt=r("p"),dt.innerHTML=Ma,Bo=n(),c(V.$$.fragment),Wo=n(),c(E.$$.fragment),mo=n(),c(Ae.$$.fragment),po=n(),pt=r("p"),this.h()},l(e){const t=$a("svelte-u9bgzb",document.head);_=i(t,"META",{name:!0,content:!0}),t.forEach(o),U=s(e),v=i(e,"P",{}),$(v).forEach(o),T=s(e),d(y.$$.fragment,e),u=s(e),d(b.$$.fragment,e),gt=s(e),X=i(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-xhhjdz"&&(X.textContent=Go),ht=s(e),A=i(e,"P",{"data-svelte-h":!0}),f(A)!=="svelte-iilyg8"&&(A.innerHTML=Zo),ft=s(e),Y=i(e,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-vfdo9a"&&(Y.textContent=Ro),ut=s(e),D=i(e,"P",{"data-svelte-h":!0}),f(D)!=="svelte-a2g4ox"&&(D.innerHTML=So),_t=s(e),W=i(e,"IMG",{src:!0,alt:!0,width:!0}),Tt=s(e),O=i(e,"SMALL",{"data-svelte-h":!0}),f(O)!=="svelte-16ml59q"&&(O.innerHTML=Eo),vt=s(e),K=i(e,"P",{"data-svelte-h":!0}),f(K)!=="svelte-3u37is"&&(K.innerHTML=Qo),yt=s(e),d(ee.$$.fragment,e),bt=s(e),te=i(e,"UL",{"data-svelte-h":!0}),f(te)!=="svelte-1gvp0fc"&&(te.innerHTML=Ho),wt=s(e),oe=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),f(oe)!=="svelte-nygwxc"&&(oe.innerHTML=Xo),Mt=s(e),d(ae.$$.fragment,e),Jt=s(e),ne=i(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-pavm2p"&&(ne.innerHTML=Ao),It=s(e),se=i(e,"P",{"data-svelte-h":!0}),f(se)!=="svelte-1uqcr0x"&&(se.innerHTML=Yo),Ut=s(e),re=i(e,"UL",{"data-svelte-h":!0}),f(re)!=="svelte-imbcrg"&&(re.innerHTML=Do),Lt=s(e),ie=i(e,"P",{"data-svelte-h":!0}),f(ie)!=="svelte-1hj0jdv"&&(ie.innerHTML=Oo),Ct=s(e),d(le.$$.fragment,e),jt=s(e),ce=i(e,"UL",{"data-svelte-h":!0}),f(ce)!=="svelte-rusc9d"&&(ce.innerHTML=Ko),$t=s(e),de=i(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-1qk1eny"&&(de.innerHTML=ea),zt=s(e),d(me.$$.fragment,e),xt=s(e),pe=i(e,"P",{"data-svelte-h":!0}),f(pe)!=="svelte-mnlzle"&&(pe.textContent=ta),kt=s(e),d(ge.$$.fragment,e),qt=s(e),he=i(e,"P",{"data-svelte-h":!0}),f(he)!=="svelte-uxk0fh"&&(he.innerHTML=oa),Ft=s(e),d(fe.$$.fragment,e),Nt=s(e),ue=i(e,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-mnlzle"&&(ue.textContent=aa),Bt=s(e),d(_e.$$.fragment,e),Wt=s(e),Te=i(e,"P",{"data-svelte-h":!0}),f(Te)!=="svelte-hqx9qk"&&(Te.innerHTML=na),Pt=s(e),d(ve.$$.fragment,e),Gt=s(e),d(ye.$$.fragment,e),Zt=s(e),d(be.$$.fragment,e),Rt=s(e),d(we.$$.fragment,e),St=s(e),Me=i(e,"P",{"data-svelte-h":!0}),f(Me)!=="svelte-befb9w"&&(Me.textContent=sa),Vt=s(e),d(Je.$$.fragment,e),Et=s(e),d(Ie.$$.fragment,e),Qt=s(e),Ue=i(e,"P",{"data-svelte-h":!0}),f(Ue)!=="svelte-1wciovq"&&(Ue.innerHTML=ra),Ht=s(e),d(Le.$$.fragment,e),Xt=s(e),d(Ce.$$.fragment,e),At=s(e),je=i(e,"P",{"data-svelte-h":!0}),f(je)!=="svelte-15nzlnu"&&(je.innerHTML=ia),Yt=s(e),d($e.$$.fragment,e),Dt=s(e),ze=i(e,"P",{"data-svelte-h":!0}),f(ze)!=="svelte-1bkfbxv"&&(ze.textContent=la),Ot=s(e),d(xe.$$.fragment,e),Kt=s(e),ke=i(e,"UL",{"data-svelte-h":!0}),f(ke)!=="svelte-qnejrc"&&(ke.innerHTML=ca),eo=s(e),d(qe.$$.fragment,e),to=s(e),w=i(e,"DIV",{class:!0});var C=$(w);d(Fe.$$.fragment,C),_o=s(C),De=i(C,"P",{"data-svelte-h":!0}),f(De)!=="svelte-1r3a7z"&&(De.innerHTML=da),To=s(C),Oe=i(C,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-d825u1"&&(Oe.innerHTML=ma),vo=s(C),Ke=i(C,"P",{"data-svelte-h":!0}),f(Ke)!=="svelte-o55m63"&&(Ke.innerHTML=pa),yo=s(C),d(P.$$.fragment,C),C.forEach(o),oo=s(e),d(Ne.$$.fragment,e),ao=s(e),z=i(e,"DIV",{class:!0});var N=$(z);d(Be.$$.fragment,N),bo=s(N),et=i(N,"P",{"data-svelte-h":!0}),f(et)!=="svelte-bcnugk"&&(et.textContent=ga),wo=s(N),G=i(N,"DIV",{class:!0});var Ye=$(G);d(We.$$.fragment,Ye),Mo=s(Ye),tt=i(Ye,"P",{"data-svelte-h":!0}),f(tt)!=="svelte-1x3yxsa"&&(tt.textContent=ha),Ye.forEach(o),N.forEach(o),no=s(e),d(Pe.$$.fragment,e),so=s(e),x=i(e,"DIV",{class:!0});var mt=$(x);d(Ge.$$.fragment,mt),Jo=s(mt),ot=i(mt,"P",{"data-svelte-h":!0}),f(ot)!=="svelte-1chufuc"&&(ot.textContent=fa),Io=s(mt),Z=i(mt,"DIV",{class:!0});var ho=$(Z);d(Ze.$$.fragment,ho),Uo=s(ho),at=i(ho,"P",{"data-svelte-h":!0}),f(at)!=="svelte-1x3yxsa"&&(at.textContent=ua),ho.forEach(o),mt.forEach(o),ro=s(e),d(Re.$$.fragment,e),io=s(e),M=i(e,"DIV",{class:!0});var k=$(M);d(Se.$$.fragment,k),Lo=s(k),nt=i(k,"P",{"data-svelte-h":!0}),f(nt)!=="svelte-q5h2es"&&(nt.textContent=_a),Co=s(k),st=i(k,"P",{"data-svelte-h":!0}),f(st)!=="svelte-1m5vjy5"&&(st.innerHTML=Ta),jo=s(k),R=i(k,"DIV",{class:!0});var fo=$(R);d(Ve.$$.fragment,fo),$o=s(fo),rt=i(fo,"P",{"data-svelte-h":!0}),f(rt)!=="svelte-1o9eza"&&(rt.innerHTML=va),fo.forEach(o),zo=s(k),S=i(k,"DIV",{class:!0});var uo=$(S);d(Ee.$$.fragment,uo),xo=s(uo),it=i(uo,"P",{"data-svelte-h":!0}),f(it)!=="svelte-kk16qw"&&(it.innerHTML=ya),uo.forEach(o),k.forEach(o),lo=s(e),d(Qe.$$.fragment,e),co=s(e),L=i(e,"DIV",{class:!0});var Q=$(L);d(He.$$.fragment,Q),ko=s(Q),lt=i(Q,"P",{"data-svelte-h":!0}),f(lt)!=="svelte-1ox7dlx"&&(lt.innerHTML=ba),qo=s(Q),ct=i(Q,"P",{"data-svelte-h":!0}),f(ct)!=="svelte-hswkmf"&&(ct.innerHTML=wa),Fo=s(Q),j=i(Q,"DIV",{class:!0});var H=$(j);d(Xe.$$.fragment,H),No=s(H),dt=i(H,"P",{"data-svelte-h":!0}),f(dt)!=="svelte-1n3tg9h"&&(dt.innerHTML=Ma),Bo=s(H),d(V.$$.fragment,H),Wo=s(H),d(E.$$.fragment,H),H.forEach(o),Q.forEach(o),mo=s(e),d(Ae.$$.fragment,e),po=s(e),pt=i(e,"P",{}),$(pt).forEach(o),this.h()},h(){J(_,"name","hf:doc:metadata"),J(_,"content",Wa),Ua(W.src,Vo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/llava_architecture.jpg")||J(W,"src",Vo),J(W,"alt","drawing"),J(W,"width","600"),J(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,_),a(e,U,t),a(e,v,t),a(e,T,t),m(y,e,t),a(e,u,t),m(b,e,t),a(e,gt,t),a(e,X,t),a(e,ht,t),a(e,A,t),a(e,ft,t),a(e,Y,t),a(e,ut,t),a(e,D,t),a(e,_t,t),a(e,W,t),a(e,Tt,t),a(e,O,t),a(e,vt,t),a(e,K,t),a(e,yt,t),m(ee,e,t),a(e,bt,t),a(e,te,t),a(e,wt,t),a(e,oe,t),a(e,Mt,t),m(ae,e,t),a(e,Jt,t),a(e,ne,t),a(e,It,t),a(e,se,t),a(e,Ut,t),a(e,re,t),a(e,Lt,t),a(e,ie,t),a(e,Ct,t),m(le,e,t),a(e,jt,t),a(e,ce,t),a(e,$t,t),a(e,de,t),a(e,zt,t),m(me,e,t),a(e,xt,t),a(e,pe,t),a(e,kt,t),m(ge,e,t),a(e,qt,t),a(e,he,t),a(e,Ft,t),m(fe,e,t),a(e,Nt,t),a(e,ue,t),a(e,Bt,t),m(_e,e,t),a(e,Wt,t),a(e,Te,t),a(e,Pt,t),m(ve,e,t),a(e,Gt,t),m(ye,e,t),a(e,Zt,t),m(be,e,t),a(e,Rt,t),m(we,e,t),a(e,St,t),a(e,Me,t),a(e,Vt,t),m(Je,e,t),a(e,Et,t),m(Ie,e,t),a(e,Qt,t),a(e,Ue,t),a(e,Ht,t),m(Le,e,t),a(e,Xt,t),m(Ce,e,t),a(e,At,t),a(e,je,t),a(e,Yt,t),m($e,e,t),a(e,Dt,t),a(e,ze,t),a(e,Ot,t),m(xe,e,t),a(e,Kt,t),a(e,ke,t),a(e,eo,t),m(qe,e,t),a(e,to,t),a(e,w,t),m(Fe,w,null),l(w,_o),l(w,De),l(w,To),l(w,Oe),l(w,vo),l(w,Ke),l(w,yo),m(P,w,null),a(e,oo,t),m(Ne,e,t),a(e,ao,t),a(e,z,t),m(Be,z,null),l(z,bo),l(z,et),l(z,wo),l(z,G),m(We,G,null),l(G,Mo),l(G,tt),a(e,no,t),m(Pe,e,t),a(e,so,t),a(e,x,t),m(Ge,x,null),l(x,Jo),l(x,ot),l(x,Io),l(x,Z),m(Ze,Z,null),l(Z,Uo),l(Z,at),a(e,ro,t),m(Re,e,t),a(e,io,t),a(e,M,t),m(Se,M,null),l(M,Lo),l(M,nt),l(M,Co),l(M,st),l(M,jo),l(M,R),m(Ve,R,null),l(R,$o),l(R,rt),l(M,zo),l(M,S),m(Ee,S,null),l(S,xo),l(S,it),a(e,lo,t),m(Qe,e,t),a(e,co,t),a(e,L,t),m(He,L,null),l(L,ko),l(L,lt),l(L,qo),l(L,ct),l(L,Fo),l(L,j),m(Xe,j,null),l(j,No),l(j,dt),l(j,Bo),m(V,j,null),l(j,Wo),m(E,j,null),a(e,mo,t),m(Ae,e,t),a(e,po,t),a(e,pt,t),go=!0},p(e,[t]){const C={};t&2&&(C.$$scope={dirty:t,ctx:e}),P.$set(C);const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),V.$set(N);const Ye={};t&2&&(Ye.$$scope={dirty:t,ctx:e}),E.$set(Ye)},i(e){go||(p(y.$$.fragment,e),p(b.$$.fragment,e),p(ee.$$.fragment,e),p(ae.$$.fragment,e),p(le.$$.fragment,e),p(me.$$.fragment,e),p(ge.$$.fragment,e),p(fe.$$.fragment,e),p(_e.$$.fragment,e),p(ve.$$.fragment,e),p(ye.$$.fragment,e),p(be.$$.fragment,e),p(we.$$.fragment,e),p(Je.$$.fragment,e),p(Ie.$$.fragment,e),p(Le.$$.fragment,e),p(Ce.$$.fragment,e),p($e.$$.fragment,e),p(xe.$$.fragment,e),p(qe.$$.fragment,e),p(Fe.$$.fragment,e),p(P.$$.fragment,e),p(Ne.$$.fragment,e),p(Be.$$.fragment,e),p(We.$$.fragment,e),p(Pe.$$.fragment,e),p(Ge.$$.fragment,e),p(Ze.$$.fragment,e),p(Re.$$.fragment,e),p(Se.$$.fragment,e),p(Ve.$$.fragment,e),p(Ee.$$.fragment,e),p(Qe.$$.fragment,e),p(He.$$.fragment,e),p(Xe.$$.fragment,e),p(V.$$.fragment,e),p(E.$$.fragment,e),p(Ae.$$.fragment,e),go=!0)},o(e){g(y.$$.fragment,e),g(b.$$.fragment,e),g(ee.$$.fragment,e),g(ae.$$.fragment,e),g(le.$$.fragment,e),g(me.$$.fragment,e),g(ge.$$.fragment,e),g(fe.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(we.$$.fragment,e),g(Je.$$.fragment,e),g(Ie.$$.fragment,e),g(Le.$$.fragment,e),g(Ce.$$.fragment,e),g($e.$$.fragment,e),g(xe.$$.fragment,e),g(qe.$$.fragment,e),g(Fe.$$.fragment,e),g(P.$$.fragment,e),g(Ne.$$.fragment,e),g(Be.$$.fragment,e),g(We.$$.fragment,e),g(Pe.$$.fragment,e),g(Ge.$$.fragment,e),g(Ze.$$.fragment,e),g(Re.$$.fragment,e),g(Se.$$.fragment,e),g(Ve.$$.fragment,e),g(Ee.$$.fragment,e),g(Qe.$$.fragment,e),g(He.$$.fragment,e),g(Xe.$$.fragment,e),g(V.$$.fragment,e),g(E.$$.fragment,e),g(Ae.$$.fragment,e),go=!1},d(e){e&&(o(U),o(v),o(T),o(u),o(gt),o(X),o(ht),o(A),o(ft),o(Y),o(ut),o(D),o(_t),o(W),o(Tt),o(O),o(vt),o(K),o(yt),o(bt),o(te),o(wt),o(oe),o(Mt),o(Jt),o(ne),o(It),o(se),o(Ut),o(re),o(Lt),o(ie),o(Ct),o(jt),o(ce),o($t),o(de),o(zt),o(xt),o(pe),o(kt),o(qt),o(he),o(Ft),o(Nt),o(ue),o(Bt),o(Wt),o(Te),o(Pt),o(Gt),o(Zt),o(Rt),o(St),o(Me),o(Vt),o(Et),o(Qt),o(Ue),o(Ht),o(Xt),o(At),o(je),o(Yt),o(Dt),o(ze),o(Ot),o(Kt),o(ke),o(eo),o(to),o(w),o(oo),o(ao),o(z),o(no),o(so),o(x),o(ro),o(io),o(M),o(lo),o(co),o(L),o(mo),o(po),o(pt)),o(_),h(y,e),h(b,e),h(ee,e),h(ae,e),h(le,e),h(me,e),h(ge,e),h(fe,e),h(_e,e),h(ve,e),h(ye,e),h(be,e),h(we,e),h(Je,e),h(Ie,e),h(Le,e),h(Ce,e),h($e,e),h(xe,e),h(qe,e),h(Fe),h(P),h(Ne,e),h(Be),h(We),h(Pe,e),h(Ge),h(Ze),h(Re,e),h(Se),h(Ve),h(Ee),h(Qe,e),h(He),h(Xe),h(V),h(E),h(Ae,e)}}}const Wa='{"title":"LLaVa","local":"llava","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Formatting Prompts with Chat Templates","local":"formatting-prompts-with-chat-templates","sections":[],"depth":3}],"depth":2},{"title":"Usage examples","local":"usage-examples","sections":[{"title":"Single input inference","local":"single-input-inference","sections":[],"depth":3},{"title":"Batched inference","local":"batched-inference","sections":[],"depth":3}],"depth":2},{"title":"Note regarding reproducing original implementation","local":"note-regarding-reproducing-original-implementation","sections":[{"title":"Using Flash Attention 2","local":"using-flash-attention-2","sections":[],"depth":3}],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"LlavaConfig","local":"transformers.LlavaConfig","sections":[],"depth":2},{"title":"LlavaImageProcessor","local":"transformers.LlavaImageProcessor","sections":[],"depth":2},{"title":"LlavaImageProcessorFast","local":"transformers.LlavaImageProcessorFast","sections":[],"depth":2},{"title":"LlavaProcessor","local":"transformers.LlavaProcessor","sections":[],"depth":2},{"title":"LlavaForConditionalGeneration","local":"transformers.LlavaForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Pa(B){return La(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xa extends Ca{constructor(_){super(),ja(this,_,Pa,Ba,Ia,{})}}export{Xa as component};
