import{s as za,f as $a,o as ka,n as _t}from"../chunks/scheduler.25b97de1.js";import{S as Za,i as Wa,g as r,s as n,r as d,A as qa,h as i,f as o,c as s,j as N,u as m,x as u,k as J,y as _,a,v as p,d as h,t as g,w as f}from"../chunks/index.d9030fc9.js";import{T as Qo}from"../chunks/Tip.baa67368.js";import{D as W}from"../chunks/Docstring.ffac8efa.js";import{C as L}from"../chunks/CodeBlock.e6cd0d95.js";import{E as La}from"../chunks/ExampleCodeBlock.22dfe688.js";import{H as I,E as Ba}from"../chunks/EditOnGithub.91d95064.js";function Fa(j){let l,b="<li>Llava-Next uses different number of patches for images and thus has to pad the inputs inside modeling code, aside from the padding done when processing the inputs. The default setting is “left-padding” if model is in <code>eval()</code> mode, otherwise “right-padding”.</li>";return{c(){l=r("ul"),l.innerHTML=b},l(T){l=i(T,"UL",{"data-svelte-h":!0}),u(l)!=="svelte-17g7vjy"&&(l.innerHTML=b)},m(T,y){a(T,l,y)},p:_t,d(T){T&&o(l)}}}function Ga(j){let l,b='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',T,y,v='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){l=r("p"),l.innerHTML=b,T=n(),y=r("p"),y.innerHTML=v},l(c){l=i(c,"P",{"data-svelte-h":!0}),u(l)!=="svelte-nz63kd"&&(l.innerHTML=b),T=s(c),y=i(c,"P",{"data-svelte-h":!0}),u(y)!=="svelte-aze40l"&&(y.innerHTML=v)},m(c,M){a(c,l,M),a(c,T,M),a(c,y,M)},p:_t,d(c){c&&(o(l),o(T),o(y))}}}function Ra(j){let l,b="Example:",T,y,v;return y=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhTmV4dEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMExsYXZhTmV4dENvbmZpZyUyQyUyMENMSVBWaXNpb25Db25maWclMkMlMjBMbGFtYUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBDTElQLXZpc2lvbiUyMGNvbmZpZyUwQXZpc2lvbl9jb25maWclMjAlM0QlMjBDTElQVmlzaW9uQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTGxhbWElMjBjb25maWclMEF0ZXh0X2NvbmZpZyUyMCUzRCUyMExsYW1hQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTGxhdmEtTmV4dCUyMGxsYXZhLWhmJTJGbGxhdmEtdjEuNi1taXN0cmFsLTdiLWhmJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMExsYXZhTmV4dENvbmZpZyh2aXNpb25fY29uZmlnJTJDJTIwdGV4dF9jb25maWcpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGxsYXZhLWhmJTJGbGxhdmEtdjEuNi1taXN0cmFsLTdiLWhmJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBMbGF2YU5leHRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextForConditionalGeneration, LlavaNextConfig, CLIPVisionConfig, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = CLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llava-Next llava-hf/llava-v1.6-mistral-7b-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlavaNextConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the llava-hf/llava-v1.6-mistral-7b-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaNextForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=r("p"),l.textContent=b,T=n(),d(y.$$.fragment)},l(c){l=i(c,"P",{"data-svelte-h":!0}),u(l)!=="svelte-11lpom8"&&(l.textContent=b),T=s(c),m(y.$$.fragment,c)},m(c,M){a(c,l,M),a(c,T,M),p(y,c,M),v=!0},p:_t,i(c){v||(h(y.$$.fragment,c),v=!0)},o(c){g(y.$$.fragment,c),v=!1},d(c){c&&(o(l),o(T)),f(y,c)}}}function Va(j){let l,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=r("p"),l.innerHTML=b},l(T){l=i(T,"P",{"data-svelte-h":!0}),u(l)!=="svelte-fincs2"&&(l.innerHTML=b)},m(T,y){a(T,l,y)},p:_t,d(T){T&&o(l)}}}function Xa(j){let l,b="Example:",T,y,v;return y=new L({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMExsYXZhTmV4dEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwTGxhdmFOZXh0Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJsbGF2YS1oZiUyRmxsYXZhLXYxLjYtbWlzdHJhbC03Yi1oZiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJsbGF2YS1oZiUyRmxsYXZhLXYxLjYtbWlzdHJhbC03Yi1oZiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjIlNUJJTlNUJTVEJTIwJTNDaW1hZ2UlM0UlNUNuV2hhdCUyMGlzJTIwc2hvd24lMjBpbiUyMHRoaXMlMjBpbWFnZSUzRiUyMCU1QiUyRklOU1QlNUQlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnd3dy5pbGFua2VsbWFuLm9yZyUyRnN0b3BzaWducyUyRmF1c3RyYWxpYS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEcHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQXByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaNextForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaNextForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;[INST] &lt;image&gt;\\nWhat is shown in this image? [/INST]&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;[INST]  \\nWhat is shown in this image? [/INST] The image appears to be a radar chart, which is a type of multi-dimensional plot (...)&quot;</span>`,wrap:!1}}),{c(){l=r("p"),l.textContent=b,T=n(),d(y.$$.fragment)},l(c){l=i(c,"P",{"data-svelte-h":!0}),u(l)!=="svelte-11lpom8"&&(l.textContent=b),T=s(c),m(y.$$.fragment,c)},m(c,M){a(c,l,M),a(c,T,M),p(y,c,M),v=!0},p:_t,i(c){v||(h(y.$$.fragment,c),v=!0)},o(c){g(y.$$.fragment,c),v=!1},d(c){c&&(o(l),o(T)),f(y,c)}}}function Pa(j){let l,b,T,y,v,c,M,Tt,A,So='The LLaVA-NeXT model was proposed in <a href="https://llava-vl.github.io/blog/2024-01-30-llava-next/" rel="nofollow">LLaVA-NeXT: Improved reasoning, OCR, and world knowledge</a> by Haotian Liu, Chunyuan Li, Yuheng Li, Bo Li, Yuanhan Zhang, Sheng Shen, Yong Jae Lee. LLaVa-NeXT (also called LLaVa-1.6) improves upon <a href="llava">LLaVa</a> by increasing the input image resolution and training on an improved visual instruction tuning dataset to improve OCR and common sense reasoning.',yt,D,Eo="The introduction from the blog is the following:",vt,O,Yo="*In October 2023, we released LLaVA-1.5 with a simple and efficient design along with great performance on a benchmark suite of 12 datasets. It has since served as the foundation of many comprehensive studies of data, model, and capabilities of large multimodal models (LMM), and has enabled various new applications.",bt,K,Ao="Today, we are thrilled to present LLaVA-NeXT, with improved reasoning, OCR, and world knowledge. LLaVA-NeXT even exceeds Gemini Pro on several benchmarks.",Mt,ee,Do="Compared with LLaVA-1.5, LLaVA-NeXT has several improvements:",wt,te,Oo=`Increasing the input image resolution to 4x more pixels. This allows it to grasp more visual details. It supports three aspect ratios, up to 672x672, 336x1344, 1344x336 resolution.
Better visual reasoning and OCR capability with an improved visual instruction tuning data mixture.
Better visual conversation for more scenarios, covering different applications. Better world knowledge and logical reasoning.
Efficient deployment and inference with SGLang.
Along with performance improvements, LLaVA-NeXT maintains the minimalist design and data efficiency of LLaVA-1.5. It re-uses the pretrained connector of LLaVA-1.5, and still uses less than 1M visual instruction tuning samples. The largest 34B variant finishes training in ~1 day with 32 A100s.*`,Jt,F,Ko,It,oe,ea='LLaVa-NeXT incorporates a higher input resolution by encoding various patches of the input image. Taken from the <a href="https://arxiv.org/abs/2310.03744">original paper.</a>',Ut,ae,ta=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/haotian-liu/LLaVA/tree/main" rel="nofollow">here</a>.`,xt,ne,jt,se,oa="<li>We advise users to use <code>padding_side=&quot;left&quot;</code> when computing batched generation as it leads to more accurate results. Simply make sure to call <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before generating.</li>",Ct,G,Nt,re,aa="<p>[!NOTE]\nLLaVA models after release v4.46 will raise warnings about adding <code>processor.patch_size = {{patch_size}}</code>, <code>processor.num_additional_image_tokens = {{num_additional_image_tokens}}</code> and processor.vision_feature_select_strategy = {{vision_feature_select_strategy}}<code>. It is strongly recommended to add the attributes to the processor if you own the model checkpoint, or open a PR if it is not owned by you. Adding these attributes means that LLaVA will try to infer the number of image tokens required per image and expand the text with as many </code>&lt;image&gt;<code>placeholders as there will be tokens. Usually it is around 500 tokens per image, so make sure that the text is not truncated as otherwise there will be failure when merging the embeddings. The attributes can be obtained from model config, as</code>model.config.vision_config.patch_size<code>or</code>model.config.vision_feature_select_strategy<code>. The </code>num_additional_image_tokens<code>should be</code>1<code>if the vision backbone adds a CLS token or</code>0` if nothing extra is added to the vision patches.</p>",Lt,ie,zt,le,na="Each <strong>checkpoint</strong> is trained with a specific prompt format, depending on the underlying large language model backbone. To ensure correct formatting, use the processor’s <code>apply_chat_template</code> method.",$t,ce,sa="<strong>Important:</strong>",kt,de,ra="<li>You must construct a conversation history — passing a plain string won’t work.</li> <li>Each message should be a dictionary with <code>&quot;role&quot;</code> and <code>&quot;content&quot;</code> keys.</li> <li>The <code>&quot;content&quot;</code> should be a list of dictionaries for different modalities like <code>&quot;text&quot;</code> and <code>&quot;image&quot;</code>.</li>",Zt,me,ia='Here’s an example of how to structure your input. We will use <a href="https://huggingface.co/llava-hf/llava-v1.6-mistral-7b-hf" rel="nofollow">llava-v1.6-mistral-7b-hf</a> and a conversation history of text and image.',Wt,pe,qt,he,la=`<li>If you want to construct a chat prompt yourself, below is a list of possible formats
.
<a href="https://huggingface.co/llava-hf/llava-v1.6-mistral-7b-hf" rel="nofollow">llava-v1.6-mistral-7b-hf</a> requires the following format:</li>`,Bt,ge,Ft,fe,ca='<a href="https://huggingface.co/llava-hf/llava-v1.6-vicuna-7b-hf" rel="nofollow">llava-v1.6-vicuna-7b-hf</a> and <a href="https://huggingface.co/llava-hf/llava-v1.6-vicuna-13b-hf" rel="nofollow">llava-v1.6-vicuna-13b-hf</a> require the following format:',Gt,ue,Rt,_e,da='<a href="https://huggingface.co/llava-hf/llava-v1.6-34b-hf" rel="nofollow">llava-v1.6-34b-hf</a> requires the following format:',Vt,Te,Xt,ye,ma='<a href="https://huggingface.co/llava-hf/llava-next-8b-hf" rel="nofollow">llama3-llava-next-8b-hf</a> requires the following format:',Pt,ve,Ht,be,pa='<a href="https://huggingface.co/llava-hf/llava-next-72b-hf" rel="nofollow">llava-next-72b-hf</a> and <a href="https://huggingface.co/llava-hf/llava-next-110b-hf" rel="nofollow">llava-next-110b-hf</a> require the following format:',Qt,Me,St,we,ha="🚀 <strong>Bonus:</strong> If you’re using <code>transformers&gt;=4.49.0</code>, you can also get a vectorized output from <code>apply_chat_template</code>. See the <strong>Usage Examples</strong> below for more details on how to use it.",Et,Je,Yt,Ie,At,Ue,ga="Here’s how to load the model and perform inference in half-precision (<code>torch.float16</code>):",Dt,xe,Ot,je,Kt,Ce,fa="LLaVa-Next can perform inference with multiple images as input, where images either belong to the same prompt or different prompts (in batched inference). Here is how you can do it:",eo,Ne,to,Le,oo,ze,ao,$e,ua="The model can be loaded in 8 or 4 bits, greatly reducing the memory requirements while maintaining the performance of the original model. First make sure to install bitsandbytes, <code>pip install bitsandbytes</code>, and to have access to a GPU/accelerator that is supported by the library.",no,R,so,ke,_a="Simply change the snippet above with:",ro,Ze,io,We,lo,qe,Ta='First make sure to install flash-attn. Refer to the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">original repository of Flash Attention</a> regarding that package installation. Simply change the snippet above with:',co,Be,mo,Fe,po,U,Ge,Uo,ot,ya=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextForConditionalGeneration">LlavaNextForConditionalGeneration</a>. It is used to instantiate an
Llava-NeXT model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/llava-hf/llava-v1.6-mistral-7b-hf" rel="nofollow">llava-hf/llava-v1.6-mistral-7b-hf</a>
model.`,xo,at,va=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,jo,V,ho,Re,go,z,Ve,Co,nt,ba=`Constructs a LLaVa-NeXT image processor. Based on <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> with incorporation of additional techniques
for processing high resolution images as explained in the <a href="https://arxiv.org/abs/2310.03744" rel="nofollow">LLaVa paper</a>.`,No,st,Xe,fo,Pe,uo,$,He,Lo,rt,Ma="Constructs a fast ConvNeXT image processor.",zo,X,Qe,$o,it,wa="Preprocess an image or batch of images.",_o,Se,To,w,Ee,ko,lt,Ja="Constructs a LLaVa-NeXT processor which wraps a LLaVa-NeXT image processor and a LLaMa tokenizer into a single processor.",Zo,ct,Ia=`<a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextProcessor">LlavaNextProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextProcessor.decode">decode()</a> for more information.`,Wo,P,Ye,qo,dt,Ua=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,Bo,H,Ae,Fo,mt,xa=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,yo,De,vo,x,Oe,Go,pt,ja=`The LLAVA-NeXT model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ro,ht,Ca=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Vo,C,Ke,Xo,gt,Na='The <a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextForConditionalGeneration">LlavaNextForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Po,Q,Ho,S,bo,et,Mo,ft,wo;return v=new I({props:{title:"LLaVA-NeXT",local:"llava-next",headingTag:"h1"}}),M=new I({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ne=new I({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),G=new Qo({props:{warning:!0,$$slots:{default:[Fa]},$$scope:{ctx:j}}}),ie=new I({props:{title:"Formatting Prompts with Chat Templates",local:"formatting-prompts-with-chat-templates",headingTag:"h3"}}),pe=new L({props:{code:"JTBBJTBBJTBBJTBBJTBBJTIyJTVCSU5TVCU1RCUyMCUzQ2ltYWdlJTNFJTVDbldoYXQncyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjAlNUIlMkZJTlNUJTVEJTIwVGhpcyUyMGltYWdlJTIwc2hvd3MlMjBhJTIwcmVkJTIwc3RvcCUyMHNpZ24uJTIwJTVCSU5TVCU1RCUyMERlc2NyaWJlJTIwdGhlJTIwaW1hZ2UlMjBpbiUyMG1vcmUlMjBkZXRhaWxzLiUyMCU1QiUyRklOU1QlNUQlMjI=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextProcessor

processor = LlavaNextProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What’s shown in this image?&quot;</span>},
        ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;This image shows a red stop sign.&quot;</span>},]
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe the image in more details.&quot;</span>},
        ],
    },
]

text_prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Note that the template simply formats your prompt, you still have to tokenize it and obtain pixel values for your images</span>
<span class="hljs-built_in">print</span>(text_prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;[INST] &lt;image&gt;\\nWhat&#x27;s shown in this image? [/INST] This image shows a red stop sign. [INST] Describe the image in more details. [/INST]&quot;</span>`,wrap:!1}}),ge=new L({props:{code:"JTIyJTVCSU5TVCU1RCUyMCUzQ2ltYWdlJTNFJTVDbldoYXQlMjBpcyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjAlNUIlMkZJTlNUJTVEJTIy",highlighted:'<span class="hljs-string">&quot;[INST] &lt;image&gt;\\nWhat is shown in this image? [/INST]&quot;</span>',wrap:!1}}),ue=new L({props:{code:"JTIyQSUyMGNoYXQlMjBiZXR3ZWVuJTIwYSUyMGN1cmlvdXMlMjBodW1hbiUyMGFuZCUyMGFuJTIwYXJ0aWZpY2lhbCUyMGludGVsbGlnZW5jZSUyMGFzc2lzdGFudC4lMjBUaGUlMjBhc3Npc3RhbnQlMjBnaXZlcyUyMGhlbHBmdWwlMkMlMjBkZXRhaWxlZCUyQyUyMGFuZCUyMHBvbGl0ZSUyMGFuc3dlcnMlMjB0byUyMHRoZSUyMGh1bWFuJ3MlMjBxdWVzdGlvbnMuJTIwVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbldoYXQlMjBpcyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjBBU1NJU1RBTlQlM0ElMjI=",highlighted:'<span class="hljs-string">&quot;A chat between a curious human and an artificial intelligence assistant. The assistant gives helpful, detailed, and polite answers to the human&#x27;s questions. USER: &lt;image&gt;\\nWhat is shown in this image? ASSISTANT:&quot;</span>',wrap:!1}}),Te=new L({props:{code:"JTIyJTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lNUNuQW5zd2VyJTIwdGhlJTIwcXVlc3Rpb25zLiUzQyU3Q2ltX2VuZCU3QyUzRSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciU1Q24lM0NpbWFnZSUzRSU1Q25XaGF0JTIwaXMlMjBzaG93biUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJTIy",highlighted:'<span class="hljs-string">&quot;&lt;|im_start|&gt;system\\nAnswer the questions.&lt;|im_end|&gt;&lt;|im_start|&gt;user\\n&lt;image&gt;\\nWhat is shown in this image?&lt;|im_end|&gt;&lt;|im_start|&gt;assistant\\n&quot;</span>',wrap:!1}}),ve=new L({props:{code:"JTIyJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFc3lzdGVtJTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNuWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBsYW5ndWFnZSUyMGFuZCUyMHZpc2lvbiUyMGFzc2lzdGFudC4lMjBZb3UlMjBhcmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwdGhlJTIwdmlzdWFsJTIwY29udGVudCUyMHRoYXQlMjB0aGUlMjB1c2VyJTIwcHJvdmlkZXMlMkMlMjBhbmQlMjBhc3Npc3QlMjB0aGUlMjB1c2VyJTIwd2l0aCUyMGElMjB2YXJpZXR5JTIwb2YlMjB0YXNrcyUyMHVzaW5nJTIwbmF0dXJhbCUyMGxhbmd1YWdlLiUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTVDbiU1Q24lM0NpbWFnZSUzRSU1Q25XaGF0JTIwaXMlMjBzaG93biUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNuJTIy",highlighted:'<span class="hljs-string">&quot;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nYou are a helpful language and vision assistant. You are able to understand the visual content that the user provides, and assist the user with a variety of tasks using natural language.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\n&lt;image&gt;\\nWhat is shown in this image?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span>',wrap:!1}}),Me=new L({props:{code:"JTIyJTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lNUNuWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciU1Q24lM0NpbWFnZSUzRSU1Q25XaGF0JTIwaXMlMjBzaG93biUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTVDbiUyMg==",highlighted:'<span class="hljs-string">&quot;&lt;|im_start|&gt;system\\nYou are a helpful assistant.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\n&lt;image&gt;\\nWhat is shown in this image?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\n&quot;</span>',wrap:!1}}),Je=new I({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),Ie=new I({props:{title:"Single image inference",local:"single-image-inference",headingTag:"h3"}}),xe=new L({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextProcessor, LlavaNextForConditionalGeneration
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

processor = LlavaNextProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

model = LlavaNextForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>, torch_dtype=torch.float16, low_cpu_mem_usage=<span class="hljs-literal">True</span>)
model.to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

<span class="hljs-comment"># prepare image and text prompt, using the appropriate prompt template</span>
url = <span class="hljs-string">&quot;https://github.com/haotian-liu/LLaVA/blob/1a91fc274d7c35a9b50b3cb29c4247ae5837ce39/images/llava_v1_5_radar.jpg?raw=true&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
        ],
    },
]
prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(image, prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

<span class="hljs-comment"># autoregressively complete prompt</span>
output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>)

<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),je=new I({props:{title:"Multi image inference",local:"multi-image-inference",headingTag:"h3"}}),Ne=new L({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText

<span class="hljs-comment"># Load the model in half-precision</span>
model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

<span class="hljs-comment"># Get three different images</span>
url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
image_stop = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_cats = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>
image_snowman = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># Prepare a batch of two prompts, where the first one is a multi-turn conversation and the second is not</span>
conversation_1 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;There is a red stop sign in the image.&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What about this image? How many cats do you see?&quot;</span>},
            ],
    },
]

conversation_2 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
]

prompt_1 = processor.apply_chat_template(conversation_1, add_generation_prompt=<span class="hljs-literal">True</span>)
prompt_2 = processor.apply_chat_template(conversation_2, add_generation_prompt=<span class="hljs-literal">True</span>)
prompts = [prompt_1, prompt_2]

<span class="hljs-comment"># We can simply feed images in the order they have to be used in the text prompt</span>
<span class="hljs-comment"># Each &quot;&lt;image&gt;&quot; token uses one image leaving the next for the subsequent &quot;&lt;image&gt;&quot; tokens</span>
inputs = processor(images=[image_stop, image_cats, image_snowman], text=prompts, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">30</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)`,wrap:!1}}),Le=new I({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),ze=new I({props:{title:"Quantization using Bitsandbytes",local:"quantization-using-bitsandbytes",headingTag:"h3"}}),R=new Qo({props:{$$slots:{default:[Ga]},$$scope:{ctx:j}}}),Ze=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQSUyMyUyMHNwZWNpZnklMjBob3clMjB0byUyMHF1YW50aXplJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUyMmxsYXZhLWhmJTJGbGxhdmEtdjEuNi1taXN0cmFsLTdiLWhmJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageTextToText, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),We=new I({props:{title:"Use Flash-Attention 2 to further speed-up generation",local:"use-flash-attention-2-to-further-speed-up-generation",headingTag:"h3"}}),Be=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0LmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGxvd19jcHVfbWVtX3VzYWdlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9mbGFzaF9hdHRlbnRpb25fMiUzRFRydWUlMEEpLnRvKDAp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageTextToText

model = AutoModelForImageTextToText.from_pretrained(
    model_id,
    torch_dtype=torch.float16,
    low_cpu_mem_usage=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),Fe=new I({props:{title:"LlavaNextConfig",local:"transformers.LlavaNextConfig",headingTag:"h2"}}),Ge=new W({props:{name:"class transformers.LlavaNextConfig",anchor:"transformers.LlavaNextConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 32000"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"vision_feature_layer",val:" = -2"},{name:"image_grid_pinpoints",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"image_seq_length",val:" = 576"},{name:"multimodal_projector_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextConfig.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>CLIPVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.LlavaNextConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>LlamaConfig</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.LlavaNextConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.LlavaNextConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.LlavaNextConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextConfig.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code>, <em>optional</em>, defaults to <code>[[336, 672], [672, 336], [672, 672], [1008, 336], [336, 1008]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. Each item in the list should be a tuple or list
of the form <code>(height, width)</code>.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.LlavaNextConfig.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 576) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"},{anchor:"transformers.LlavaNextConfig.multimodal_projector_bias",description:`<strong>multimodal_projector_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the multimodal projector.`,name:"multimodal_projector_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/configuration_llava_next.py#L24"}}),V=new La({props:{anchor:"transformers.LlavaNextConfig.example",$$slots:{default:[Ra]},$$scope:{ctx:j}}}),Re=new I({props:{title:"LlavaNextImageProcessor",local:"transformers.LlavaNextImageProcessor",headingTag:"h2"}}),Ve=new W({props:{name:"class transformers.LlavaNextImageProcessor",anchor:"transformers.LlavaNextImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"image_grid_pinpoints",val:": typing.List = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = True"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaNextImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaNextImageProcessor.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>[[672, 336], [336, 672], [672, 672], [336, 1008], [1008, 336]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaNextImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.LlavaNextImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaNextImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaNextImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaNextImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaNextImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaNextImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/image_processing_llava_next.py#L119"}}),Xe=new W({props:{name:"preprocess",anchor:"transformers.LlavaNextImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_resize",val:": bool = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"image_grid_pinpoints",val:": typing.List = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": bool = None"},{name:"crop_size",val:": int = None"},{name:"do_rescale",val:": bool = None"},{name:"rescale_factor",val:": float = None"},{name:"do_normalize",val:": bool = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"do_convert_rgb",val:": bool = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.LlavaNextImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>self.image_grid_pinpoints</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is
selected based on the original size of the image.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/image_processing_llava_next.py#L558"}}),Pe=new I({props:{title:"LlavaNextImageProcessorFast",local:"transformers.LlavaNextImageProcessorFast",headingTag:"h2"}}),He=new W({props:{name:"class transformers.LlavaNextImageProcessorFast",anchor:"transformers.LlavaNextImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_next.image_processing_llava_next_fast.LlavaNextFastImageProcessorInitKwargs]"}],parametersDescription:[{anchor:"transformers.LlavaNextImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaNextImageProcessorFast.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaNextImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.default_to_square</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.LlavaNextImageProcessorFast.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>. Can be
overridden by the <code>resample</code> parameter in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaNextImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.LlavaNextImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaNextImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Scale factor to use if rescaling the image. Only has an effect if <code>do_rescale</code> is set to <code>True</code>. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaNextImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaNextImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaNextImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaNextImageProcessorFast.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextImageProcessorFast.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/image_processing_llava_next_fast.py#L70"}}),Qe=new W({props:{name:"preprocess",anchor:"transformers.LlavaNextImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_next.image_processing_llava_next_fast.LlavaNextFastImageProcessorPreprocessKwargs]"}],parametersDescription:[{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> or <code>InterpolationMode</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
image_grid_pinpoints (<code>List</code>, <em>optional</em>):
A list of possible resolutions to use for processing high resolution images. Each item in the list should be a tuple or list
of the form <code>(height, width)</code>.
do_pad (<code>bool</code>, <em>optional</em>):
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/image_processing_llava_next_fast.py#L105"}}),Se=new I({props:{title:"LlavaNextProcessor",local:"transformers.LlavaNextProcessor",headingTag:"h2"}}),Ee=new W({props:{name:"class transformers.LlavaNextProcessor",anchor:"transformers.LlavaNextProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"patch_size",val:" = None"},{name:"vision_feature_select_strategy",val:" = None"},{name:"chat_template",val:" = None"},{name:"image_token",val:" = '<image>'"},{name:"num_additional_image_tokens",val:" = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.LlavaNextProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.LlavaNextProcessor.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Patch size from the vision tower.`,name:"patch_size"},{anchor:"transformers.LlavaNextProcessor.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Shoudl be same as in model&#x2019;s config`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.LlavaNextProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"},{anchor:"transformers.LlavaNextProcessor.num_additional_image_tokens",description:`<strong>num_additional_image_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of additional tokens added to the image embeddings, such as CLS (+1). If the backbone has no CLS or other
extra tokens appended, no need to set this arg.`,name:"num_additional_image_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/processing_llava_next.py#L43"}}),Ye=new W({props:{name:"batch_decode",anchor:"transformers.LlavaNextProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/processing_llava_next.py#L216"}}),Ae=new W({props:{name:"decode",anchor:"transformers.LlavaNextProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/processing_llava_next.py#L224"}}),De=new I({props:{title:"LlavaNextForConditionalGeneration",local:"transformers.LlavaNextForConditionalGeneration",headingTag:"h2"}}),Oe=new W({props:{name:"class transformers.LlavaNextForConditionalGeneration",anchor:"transformers.LlavaNextForConditionalGeneration",parameters:[{name:"config",val:": LlavaNextConfig"}],parametersDescription:[{anchor:"transformers.LlavaNextForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextConfig">LlavaNextConfig</a> or <code>LlavaNextVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/modeling_llava_next.py#L355"}}),Ke=new W({props:{name:"forward",anchor:"transformers.LlavaNextForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"image_sizes",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**lm_kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(batch_size, num_channels, image_size, image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/deit#transformers.DeiTFeatureExtractor.__call__">LlavaNextImageProcessor.<strong>call</strong>()</a> for details. <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses
<a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a> for processing images.`,name:"pixel_values"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.Args",description:`<strong>Args</strong> &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>logits_to_keep (<code>int</code> or <code>torch.Tensor</code>, <em>optional</em>):
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"Args"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/modeling_llava_next.py#L540",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.llava_next.modeling_llava_next.LlavaNextCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextConfig"
>LlavaNextConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size (batch_size * num_patches, num_images, sequence_length, hidden_size)\`.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.llava_next.modeling_llava_next.LlavaNextCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new Qo({props:{$$slots:{default:[Va]},$$scope:{ctx:j}}}),S=new La({props:{anchor:"transformers.LlavaNextForConditionalGeneration.forward.example",$$slots:{default:[Xa]},$$scope:{ctx:j}}}),et=new Ba({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/llava_next.md"}}),{c(){l=r("meta"),b=n(),T=r("p"),y=n(),d(v.$$.fragment),c=n(),d(M.$$.fragment),Tt=n(),A=r("p"),A.innerHTML=So,yt=n(),D=r("p"),D.textContent=Eo,vt=n(),O=r("p"),O.textContent=Yo,bt=n(),K=r("p"),K.textContent=Ao,Mt=n(),ee=r("p"),ee.textContent=Do,wt=n(),te=r("p"),te.textContent=Oo,Jt=n(),F=r("img"),It=n(),oe=r("small"),oe.innerHTML=ea,Ut=n(),ae=r("p"),ae.innerHTML=ta,xt=n(),d(ne.$$.fragment),jt=n(),se=r("ul"),se.innerHTML=oa,Ct=n(),d(G.$$.fragment),Nt=n(),re=r("blockquote"),re.innerHTML=aa,Lt=n(),d(ie.$$.fragment),zt=n(),le=r("p"),le.innerHTML=na,$t=n(),ce=r("p"),ce.innerHTML=sa,kt=n(),de=r("ul"),de.innerHTML=ra,Zt=n(),me=r("p"),me.innerHTML=ia,Wt=n(),d(pe.$$.fragment),qt=n(),he=r("ul"),he.innerHTML=la,Bt=n(),d(ge.$$.fragment),Ft=n(),fe=r("p"),fe.innerHTML=ca,Gt=n(),d(ue.$$.fragment),Rt=n(),_e=r("p"),_e.innerHTML=da,Vt=n(),d(Te.$$.fragment),Xt=n(),ye=r("p"),ye.innerHTML=ma,Pt=n(),d(ve.$$.fragment),Ht=n(),be=r("p"),be.innerHTML=pa,Qt=n(),d(Me.$$.fragment),St=n(),we=r("p"),we.innerHTML=ha,Et=n(),d(Je.$$.fragment),Yt=n(),d(Ie.$$.fragment),At=n(),Ue=r("p"),Ue.innerHTML=ga,Dt=n(),d(xe.$$.fragment),Ot=n(),d(je.$$.fragment),Kt=n(),Ce=r("p"),Ce.textContent=fa,eo=n(),d(Ne.$$.fragment),to=n(),d(Le.$$.fragment),oo=n(),d(ze.$$.fragment),ao=n(),$e=r("p"),$e.innerHTML=ua,no=n(),d(R.$$.fragment),so=n(),ke=r("p"),ke.textContent=_a,ro=n(),d(Ze.$$.fragment),io=n(),d(We.$$.fragment),lo=n(),qe=r("p"),qe.innerHTML=Ta,co=n(),d(Be.$$.fragment),mo=n(),d(Fe.$$.fragment),po=n(),U=r("div"),d(Ge.$$.fragment),Uo=n(),ot=r("p"),ot.innerHTML=ya,xo=n(),at=r("p"),at.innerHTML=va,jo=n(),d(V.$$.fragment),ho=n(),d(Re.$$.fragment),go=n(),z=r("div"),d(Ve.$$.fragment),Co=n(),nt=r("p"),nt.innerHTML=ba,No=n(),st=r("div"),d(Xe.$$.fragment),fo=n(),d(Pe.$$.fragment),uo=n(),$=r("div"),d(He.$$.fragment),Lo=n(),rt=r("p"),rt.textContent=Ma,zo=n(),X=r("div"),d(Qe.$$.fragment),$o=n(),it=r("p"),it.textContent=wa,_o=n(),d(Se.$$.fragment),To=n(),w=r("div"),d(Ee.$$.fragment),ko=n(),lt=r("p"),lt.textContent=Ja,Zo=n(),ct=r("p"),ct.innerHTML=Ia,Wo=n(),P=r("div"),d(Ye.$$.fragment),qo=n(),dt=r("p"),dt.innerHTML=Ua,Bo=n(),H=r("div"),d(Ae.$$.fragment),Fo=n(),mt=r("p"),mt.innerHTML=xa,yo=n(),d(De.$$.fragment),vo=n(),x=r("div"),d(Oe.$$.fragment),Go=n(),pt=r("p"),pt.innerHTML=ja,Ro=n(),ht=r("p"),ht.innerHTML=Ca,Vo=n(),C=r("div"),d(Ke.$$.fragment),Xo=n(),gt=r("p"),gt.innerHTML=Na,Po=n(),d(Q.$$.fragment),Ho=n(),d(S.$$.fragment),bo=n(),d(et.$$.fragment),Mo=n(),ft=r("p"),this.h()},l(e){const t=qa("svelte-u9bgzb",document.head);l=i(t,"META",{name:!0,content:!0}),t.forEach(o),b=s(e),T=i(e,"P",{}),N(T).forEach(o),y=s(e),m(v.$$.fragment,e),c=s(e),m(M.$$.fragment,e),Tt=s(e),A=i(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-5h5la5"&&(A.innerHTML=So),yt=s(e),D=i(e,"P",{"data-svelte-h":!0}),u(D)!=="svelte-1fhv1nu"&&(D.textContent=Eo),vt=s(e),O=i(e,"P",{"data-svelte-h":!0}),u(O)!=="svelte-1o8aykc"&&(O.textContent=Yo),bt=s(e),K=i(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-106g2gs"&&(K.textContent=Ao),Mt=s(e),ee=i(e,"P",{"data-svelte-h":!0}),u(ee)!=="svelte-o65l2n"&&(ee.textContent=Do),wt=s(e),te=i(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-qaxeu7"&&(te.textContent=Oo),Jt=s(e),F=i(e,"IMG",{src:!0,alt:!0,width:!0}),It=s(e),oe=i(e,"SMALL",{"data-svelte-h":!0}),u(oe)!=="svelte-1ueeg46"&&(oe.innerHTML=ea),Ut=s(e),ae=i(e,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-10gvx7f"&&(ae.innerHTML=ta),xt=s(e),m(ne.$$.fragment,e),jt=s(e),se=i(e,"UL",{"data-svelte-h":!0}),u(se)!=="svelte-b32abk"&&(se.innerHTML=oa),Ct=s(e),m(G.$$.fragment,e),Nt=s(e),re=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),u(re)!=="svelte-nygwxc"&&(re.innerHTML=aa),Lt=s(e),m(ie.$$.fragment,e),zt=s(e),le=i(e,"P",{"data-svelte-h":!0}),u(le)!=="svelte-pavm2p"&&(le.innerHTML=na),$t=s(e),ce=i(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-1uqcr0x"&&(ce.innerHTML=sa),kt=s(e),de=i(e,"UL",{"data-svelte-h":!0}),u(de)!=="svelte-imbcrg"&&(de.innerHTML=ra),Zt=s(e),me=i(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1aakomu"&&(me.innerHTML=ia),Wt=s(e),m(pe.$$.fragment,e),qt=s(e),he=i(e,"UL",{"data-svelte-h":!0}),u(he)!=="svelte-uiv36d"&&(he.innerHTML=la),Bt=s(e),m(ge.$$.fragment,e),Ft=s(e),fe=i(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-7fncpd"&&(fe.innerHTML=ca),Gt=s(e),m(ue.$$.fragment,e),Rt=s(e),_e=i(e,"P",{"data-svelte-h":!0}),u(_e)!=="svelte-5xtfcu"&&(_e.innerHTML=da),Vt=s(e),m(Te.$$.fragment,e),Xt=s(e),ye=i(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-ia69dt"&&(ye.innerHTML=ma),Pt=s(e),m(ve.$$.fragment,e),Ht=s(e),be=i(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-cihbm7"&&(be.innerHTML=pa),Qt=s(e),m(Me.$$.fragment,e),St=s(e),we=i(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-hqx9qk"&&(we.innerHTML=ha),Et=s(e),m(Je.$$.fragment,e),Yt=s(e),m(Ie.$$.fragment,e),At=s(e),Ue=i(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-19yw9ck"&&(Ue.innerHTML=ga),Dt=s(e),m(xe.$$.fragment,e),Ot=s(e),m(je.$$.fragment,e),Kt=s(e),Ce=i(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-1py9or5"&&(Ce.textContent=fa),eo=s(e),m(Ne.$$.fragment,e),to=s(e),m(Le.$$.fragment,e),oo=s(e),m(ze.$$.fragment,e),ao=s(e),$e=i(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-bd1tou"&&($e.innerHTML=ua),no=s(e),m(R.$$.fragment,e),so=s(e),ke=i(e,"P",{"data-svelte-h":!0}),u(ke)!=="svelte-gwf9h7"&&(ke.textContent=_a),ro=s(e),m(Ze.$$.fragment,e),io=s(e),m(We.$$.fragment,e),lo=s(e),qe=i(e,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-ujer0t"&&(qe.innerHTML=Ta),co=s(e),m(Be.$$.fragment,e),mo=s(e),m(Fe.$$.fragment,e),po=s(e),U=i(e,"DIV",{class:!0});var k=N(U);m(Ge.$$.fragment,k),Uo=s(k),ot=i(k,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-e5p3qx"&&(ot.innerHTML=ya),xo=s(k),at=i(k,"P",{"data-svelte-h":!0}),u(at)!=="svelte-o55m63"&&(at.innerHTML=va),jo=s(k),m(V.$$.fragment,k),k.forEach(o),ho=s(e),m(Re.$$.fragment,e),go=s(e),z=i(e,"DIV",{class:!0});var q=N(z);m(Ve.$$.fragment,q),Co=s(q),nt=i(q,"P",{"data-svelte-h":!0}),u(nt)!=="svelte-1wlr4kn"&&(nt.innerHTML=ba),No=s(q),st=i(q,"DIV",{class:!0});var ut=N(st);m(Xe.$$.fragment,ut),ut.forEach(o),q.forEach(o),fo=s(e),m(Pe.$$.fragment,e),uo=s(e),$=i(e,"DIV",{class:!0});var B=N($);m(He.$$.fragment,B),Lo=s(B),rt=i(B,"P",{"data-svelte-h":!0}),u(rt)!=="svelte-1bn0s7p"&&(rt.textContent=Ma),zo=s(B),X=i(B,"DIV",{class:!0});var tt=N(X);m(Qe.$$.fragment,tt),$o=s(tt),it=i(tt,"P",{"data-svelte-h":!0}),u(it)!=="svelte-1x3yxsa"&&(it.textContent=wa),tt.forEach(o),B.forEach(o),_o=s(e),m(Se.$$.fragment,e),To=s(e),w=i(e,"DIV",{class:!0});var Z=N(w);m(Ee.$$.fragment,Z),ko=s(Z),lt=i(Z,"P",{"data-svelte-h":!0}),u(lt)!=="svelte-qcp8uy"&&(lt.textContent=Ja),Zo=s(Z),ct=i(Z,"P",{"data-svelte-h":!0}),u(ct)!=="svelte-1ieki7i"&&(ct.innerHTML=Ia),Wo=s(Z),P=i(Z,"DIV",{class:!0});var Jo=N(P);m(Ye.$$.fragment,Jo),qo=s(Jo),dt=i(Jo,"P",{"data-svelte-h":!0}),u(dt)!=="svelte-1o9eza"&&(dt.innerHTML=Ua),Jo.forEach(o),Bo=s(Z),H=i(Z,"DIV",{class:!0});var Io=N(H);m(Ae.$$.fragment,Io),Fo=s(Io),mt=i(Io,"P",{"data-svelte-h":!0}),u(mt)!=="svelte-kk16qw"&&(mt.innerHTML=xa),Io.forEach(o),Z.forEach(o),yo=s(e),m(De.$$.fragment,e),vo=s(e),x=i(e,"DIV",{class:!0});var E=N(x);m(Oe.$$.fragment,E),Go=s(E),pt=i(E,"P",{"data-svelte-h":!0}),u(pt)!=="svelte-1mgcqn3"&&(pt.innerHTML=ja),Ro=s(E),ht=i(E,"P",{"data-svelte-h":!0}),u(ht)!=="svelte-hswkmf"&&(ht.innerHTML=Ca),Vo=s(E),C=i(E,"DIV",{class:!0});var Y=N(C);m(Ke.$$.fragment,Y),Xo=s(Y),gt=i(Y,"P",{"data-svelte-h":!0}),u(gt)!=="svelte-1v4wb0d"&&(gt.innerHTML=Na),Po=s(Y),m(Q.$$.fragment,Y),Ho=s(Y),m(S.$$.fragment,Y),Y.forEach(o),E.forEach(o),bo=s(e),m(et.$$.fragment,e),Mo=s(e),ft=i(e,"P",{}),N(ft).forEach(o),this.h()},h(){J(l,"name","hf:doc:metadata"),J(l,"content",Ha),$a(F.src,Ko="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/llava_next_overview.png")||J(F,"src",Ko),J(F,"alt","drawing"),J(F,"width","600"),J(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){_(document.head,l),a(e,b,t),a(e,T,t),a(e,y,t),p(v,e,t),a(e,c,t),p(M,e,t),a(e,Tt,t),a(e,A,t),a(e,yt,t),a(e,D,t),a(e,vt,t),a(e,O,t),a(e,bt,t),a(e,K,t),a(e,Mt,t),a(e,ee,t),a(e,wt,t),a(e,te,t),a(e,Jt,t),a(e,F,t),a(e,It,t),a(e,oe,t),a(e,Ut,t),a(e,ae,t),a(e,xt,t),p(ne,e,t),a(e,jt,t),a(e,se,t),a(e,Ct,t),p(G,e,t),a(e,Nt,t),a(e,re,t),a(e,Lt,t),p(ie,e,t),a(e,zt,t),a(e,le,t),a(e,$t,t),a(e,ce,t),a(e,kt,t),a(e,de,t),a(e,Zt,t),a(e,me,t),a(e,Wt,t),p(pe,e,t),a(e,qt,t),a(e,he,t),a(e,Bt,t),p(ge,e,t),a(e,Ft,t),a(e,fe,t),a(e,Gt,t),p(ue,e,t),a(e,Rt,t),a(e,_e,t),a(e,Vt,t),p(Te,e,t),a(e,Xt,t),a(e,ye,t),a(e,Pt,t),p(ve,e,t),a(e,Ht,t),a(e,be,t),a(e,Qt,t),p(Me,e,t),a(e,St,t),a(e,we,t),a(e,Et,t),p(Je,e,t),a(e,Yt,t),p(Ie,e,t),a(e,At,t),a(e,Ue,t),a(e,Dt,t),p(xe,e,t),a(e,Ot,t),p(je,e,t),a(e,Kt,t),a(e,Ce,t),a(e,eo,t),p(Ne,e,t),a(e,to,t),p(Le,e,t),a(e,oo,t),p(ze,e,t),a(e,ao,t),a(e,$e,t),a(e,no,t),p(R,e,t),a(e,so,t),a(e,ke,t),a(e,ro,t),p(Ze,e,t),a(e,io,t),p(We,e,t),a(e,lo,t),a(e,qe,t),a(e,co,t),p(Be,e,t),a(e,mo,t),p(Fe,e,t),a(e,po,t),a(e,U,t),p(Ge,U,null),_(U,Uo),_(U,ot),_(U,xo),_(U,at),_(U,jo),p(V,U,null),a(e,ho,t),p(Re,e,t),a(e,go,t),a(e,z,t),p(Ve,z,null),_(z,Co),_(z,nt),_(z,No),_(z,st),p(Xe,st,null),a(e,fo,t),p(Pe,e,t),a(e,uo,t),a(e,$,t),p(He,$,null),_($,Lo),_($,rt),_($,zo),_($,X),p(Qe,X,null),_(X,$o),_(X,it),a(e,_o,t),p(Se,e,t),a(e,To,t),a(e,w,t),p(Ee,w,null),_(w,ko),_(w,lt),_(w,Zo),_(w,ct),_(w,Wo),_(w,P),p(Ye,P,null),_(P,qo),_(P,dt),_(w,Bo),_(w,H),p(Ae,H,null),_(H,Fo),_(H,mt),a(e,yo,t),p(De,e,t),a(e,vo,t),a(e,x,t),p(Oe,x,null),_(x,Go),_(x,pt),_(x,Ro),_(x,ht),_(x,Vo),_(x,C),p(Ke,C,null),_(C,Xo),_(C,gt),_(C,Po),p(Q,C,null),_(C,Ho),p(S,C,null),a(e,bo,t),p(et,e,t),a(e,Mo,t),a(e,ft,t),wo=!0},p(e,[t]){const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),G.$set(k);const q={};t&2&&(q.$$scope={dirty:t,ctx:e}),R.$set(q);const ut={};t&2&&(ut.$$scope={dirty:t,ctx:e}),V.$set(ut);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),Q.$set(B);const tt={};t&2&&(tt.$$scope={dirty:t,ctx:e}),S.$set(tt)},i(e){wo||(h(v.$$.fragment,e),h(M.$$.fragment,e),h(ne.$$.fragment,e),h(G.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(ge.$$.fragment,e),h(ue.$$.fragment,e),h(Te.$$.fragment,e),h(ve.$$.fragment,e),h(Me.$$.fragment,e),h(Je.$$.fragment,e),h(Ie.$$.fragment,e),h(xe.$$.fragment,e),h(je.$$.fragment,e),h(Ne.$$.fragment,e),h(Le.$$.fragment,e),h(ze.$$.fragment,e),h(R.$$.fragment,e),h(Ze.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),h(Fe.$$.fragment,e),h(Ge.$$.fragment,e),h(V.$$.fragment,e),h(Re.$$.fragment,e),h(Ve.$$.fragment,e),h(Xe.$$.fragment,e),h(Pe.$$.fragment,e),h(He.$$.fragment,e),h(Qe.$$.fragment,e),h(Se.$$.fragment,e),h(Ee.$$.fragment,e),h(Ye.$$.fragment,e),h(Ae.$$.fragment,e),h(De.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(Q.$$.fragment,e),h(S.$$.fragment,e),h(et.$$.fragment,e),wo=!0)},o(e){g(v.$$.fragment,e),g(M.$$.fragment,e),g(ne.$$.fragment,e),g(G.$$.fragment,e),g(ie.$$.fragment,e),g(pe.$$.fragment,e),g(ge.$$.fragment,e),g(ue.$$.fragment,e),g(Te.$$.fragment,e),g(ve.$$.fragment,e),g(Me.$$.fragment,e),g(Je.$$.fragment,e),g(Ie.$$.fragment,e),g(xe.$$.fragment,e),g(je.$$.fragment,e),g(Ne.$$.fragment,e),g(Le.$$.fragment,e),g(ze.$$.fragment,e),g(R.$$.fragment,e),g(Ze.$$.fragment,e),g(We.$$.fragment,e),g(Be.$$.fragment,e),g(Fe.$$.fragment,e),g(Ge.$$.fragment,e),g(V.$$.fragment,e),g(Re.$$.fragment,e),g(Ve.$$.fragment,e),g(Xe.$$.fragment,e),g(Pe.$$.fragment,e),g(He.$$.fragment,e),g(Qe.$$.fragment,e),g(Se.$$.fragment,e),g(Ee.$$.fragment,e),g(Ye.$$.fragment,e),g(Ae.$$.fragment,e),g(De.$$.fragment,e),g(Oe.$$.fragment,e),g(Ke.$$.fragment,e),g(Q.$$.fragment,e),g(S.$$.fragment,e),g(et.$$.fragment,e),wo=!1},d(e){e&&(o(b),o(T),o(y),o(c),o(Tt),o(A),o(yt),o(D),o(vt),o(O),o(bt),o(K),o(Mt),o(ee),o(wt),o(te),o(Jt),o(F),o(It),o(oe),o(Ut),o(ae),o(xt),o(jt),o(se),o(Ct),o(Nt),o(re),o(Lt),o(zt),o(le),o($t),o(ce),o(kt),o(de),o(Zt),o(me),o(Wt),o(qt),o(he),o(Bt),o(Ft),o(fe),o(Gt),o(Rt),o(_e),o(Vt),o(Xt),o(ye),o(Pt),o(Ht),o(be),o(Qt),o(St),o(we),o(Et),o(Yt),o(At),o(Ue),o(Dt),o(Ot),o(Kt),o(Ce),o(eo),o(to),o(oo),o(ao),o($e),o(no),o(so),o(ke),o(ro),o(io),o(lo),o(qe),o(co),o(mo),o(po),o(U),o(ho),o(go),o(z),o(fo),o(uo),o($),o(_o),o(To),o(w),o(yo),o(vo),o(x),o(bo),o(Mo),o(ft)),o(l),f(v,e),f(M,e),f(ne,e),f(G,e),f(ie,e),f(pe,e),f(ge,e),f(ue,e),f(Te,e),f(ve,e),f(Me,e),f(Je,e),f(Ie,e),f(xe,e),f(je,e),f(Ne,e),f(Le,e),f(ze,e),f(R,e),f(Ze,e),f(We,e),f(Be,e),f(Fe,e),f(Ge),f(V),f(Re,e),f(Ve),f(Xe),f(Pe,e),f(He),f(Qe),f(Se,e),f(Ee),f(Ye),f(Ae),f(De,e),f(Oe),f(Ke),f(Q),f(S),f(et,e)}}}const Ha='{"title":"LLaVA-NeXT","local":"llava-next","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Formatting Prompts with Chat Templates","local":"formatting-prompts-with-chat-templates","sections":[],"depth":3}],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single image inference","local":"single-image-inference","sections":[],"depth":3},{"title":"Multi image inference","local":"multi-image-inference","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using Bitsandbytes","local":"quantization-using-bitsandbytes","sections":[],"depth":3},{"title":"Use Flash-Attention 2 to further speed-up generation","local":"use-flash-attention-2-to-further-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"LlavaNextConfig","local":"transformers.LlavaNextConfig","sections":[],"depth":2},{"title":"LlavaNextImageProcessor","local":"transformers.LlavaNextImageProcessor","sections":[],"depth":2},{"title":"LlavaNextImageProcessorFast","local":"transformers.LlavaNextImageProcessorFast","sections":[],"depth":2},{"title":"LlavaNextProcessor","local":"transformers.LlavaNextProcessor","sections":[],"depth":2},{"title":"LlavaNextForConditionalGeneration","local":"transformers.LlavaNextForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Qa(j){return ka(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class en extends Za{constructor(l){super(),Wa(this,l,Qa,Pa,za,{})}}export{en as component};
