import{s as Ms,o as ys,n as hs}from"../chunks/scheduler.25b97de1.js";import{S as fs,i as bs,g as i,s as a,r as p,A as ws,h as o,f as s,c as n,j as ds,u as m,x as r,k as Vt,y as js,a as l,v as c,d as u,t as d,w as g}from"../chunks/index.d9030fc9.js";import{T as gs}from"../chunks/Tip.baa67368.js";import{C as b}from"../chunks/CodeBlock.e6cd0d95.js";import{D as Us}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as y,E as Ts}from"../chunks/EditOnGithub.91d95064.js";function Js(ke){let h,f='If you want to jump straight to chatting with a model, <a href="quicktour#chat-with-text-generation-models">try our chat CLI</a>.';return{c(){h=i("p"),h.innerHTML=f},l(M){h=o(M,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1vc2ejv"&&(h.innerHTML=f)},m(M,w){l(M,h,w)},p:hs,d(M){M&&s(h)}}}function ks(ke){let h,f='If you’re interested in basic LLM usage, our high-level <a href="pipeline_tutorial"><code>Pipeline</code></a> interface is a great starting point. However, LLMs often require advanced features like quantization and fine control of the token selection step, which is best done through <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>. Autoregressive generation with LLMs is also resource-intensive and should be executed on a GPU for adequate throughput.';return{c(){h=i("p"),h.innerHTML=f},l(M){h=o(M,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1wydxnv"&&(h.innerHTML=f)},m(M,w){l(M,h,w)},p:hs,d(M){M&&s(h)}}}function Zs(ke){let h,f,M,w,k,_e,Z,Ge,_,Wt="LLMs, or Large Language Models, are the key component behind text generation. In a nutshell, they consist of large pretrained transformer models trained to predict the next word (or, more precisely, token) given some input text. Since they predict one token at a time, you need to do something more elaborate to generate new sentences other than just calling the model — you need to do autoregressive generation.",Ie,G,Rt='Autoregressive generation is the inference-time procedure of iteratively calling a model with its own generated outputs, given a few initial inputs. In 🤗 Transformers, this is handled by the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method, which is available to all models with generative capabilities.',ve,j,$e,I,Ct="This tutorial will show you how to:",Ve,v,Bt="<li>Generate text with an LLM</li> <li>Avoid common pitfalls</li> <li>Next steps to help you get the most out of your LLM</li>",We,$,xt="Before you begin, make sure you have all the necessary libraries installed:",Re,V,Ce,W,Xt='Bitsandbytes supports multiple backends in addition to CUDA-based GPUs. Refer to the multi-backend installation <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">guide</a> to learn more.',Be,R,xe,C,zt='A language model trained for <a href="tasks/language_modeling">causal language modeling</a> takes a sequence of text tokens as input and returns the probability distribution for the next token.',Xe,U,Ht='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_1_1080p.mov"></video> <figcaption>&quot;Forward pass of an LLM&quot;</figcaption>',ze,B,Lt="A critical aspect of autoregressive generation with LLMs is how to select the next token from this probability distribution. Anything goes in this step as long as you end up with a token for the next iteration. This means it can be as simple as selecting the most likely token from the probability distribution or as complex as applying a dozen transformations before sampling from the resulting distribution.",He,T,Qt='<video style="max-width: 90%; margin: auto;" autoplay="" loop="" muted="" playsinline="" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/assisted-generation/gif_2_1080p.mov"></video> <figcaption>&quot;Autoregressive generation iteratively selects the next token from a probability distribution to generate text&quot;</figcaption>',Le,x,Et="The process depicted above is repeated iteratively until some stopping condition is reached. Ideally, the stopping condition is dictated by the model, which should learn when to output an end-of-sequence (<code>EOS</code>) token. If this is not the case, generation stops when some predefined maximum length is reached.",Qe,X,Ft='Properly setting up the token selection step and the stopping condition is essential to make your model behave as you’d expect on your task. That is why we have a <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file associated with each model, which contains a good default generative parameterization and is loaded alongside your model.',Ee,z,Nt="Let’s talk code!",Fe,J,Ne,H,qt="First, you need to load the model.",qe,L,Se,Q,St="You’ll notice two flags in the <code>from_pretrained</code> call:",Ye,E,Yt='<li><code>device_map</code> ensures the model is moved to your GPU(s)</li> <li><code>load_in_4bit</code> applies <a href="main_classes/quantization">4-bit dynamic quantization</a> to massively reduce the resource requirements</li>',Ae,F,At="There are other ways to initialize a model, but this is a good baseline to begin with an LLM.",De,N,Dt='Next, you need to preprocess your text input with a <a href="tokenizer_summary">tokenizer</a>.',Pe,q,Ke,S,Pt='The <code>model_inputs</code> variable holds the tokenized text input, as well as the attention mask. While <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> does its best effort to infer the attention mask when it is not passed, we recommend passing it whenever possible for optimal results.',Oe,Y,Kt='After tokenizing the inputs, you can call the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> method to returns the generated tokens. The generated tokens then should be converted to text before printing.',et,A,tt,D,Ot="Finally, you don’t need to do it one sequence at a time! You can batch your inputs, which will greatly improve the throughput at a small latency and memory cost. All you need to do is to make sure you pad your inputs properly (more on that below).",st,P,lt,K,es="And that’s it! In a few lines of code, you can harness the power of an LLM.",at,O,nt,ee,ts='There are many <a href="generation_strategies">generation strategies</a>, and sometimes the default values may not be appropriate for your use case. If your outputs aren’t aligned with what you’re expecting, we’ve created a list of the most common pitfalls and how to avoid them.',it,te,ot,se,rt,le,ss='If not specified in the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file, <code>generate</code> returns up to 20 tokens by default. We highly recommend manually setting <code>max_new_tokens</code> in your <code>generate</code> call to control the maximum number of new tokens it can return. Keep in mind LLMs (more precisely, <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">decoder-only models</a>) also return the input prompt as part of the output.',pt,ae,mt,ne,ct,ie,ls='By default, and unless specified in the <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> file, <code>generate</code> selects the most likely token at each iteration (greedy decoding). Depending on your task, this may be undesirable; creative tasks like chatbots or writing an essay benefit from sampling. On the other hand, input-grounded tasks like audio transcription or translation benefit from greedy decoding. Enable sampling with <code>do_sample=True</code>, and you can learn more about this topic in this <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">blog post</a>.',ut,oe,dt,re,gt,pe,as='LLMs are <a href="https://huggingface.co/learn/nlp-course/chapter1/6?fw=pt" rel="nofollow">decoder-only</a> architectures, meaning they continue to iterate on your input prompt. If your inputs do not have the same length, they need to be padded. Since LLMs are not trained to continue from pad tokens, your input needs to be left-padded. Make sure you also don’t forget to pass the attention mask to generate!',ht,me,Mt,ce,yt,ue,ns='Some models and tasks expect a certain input prompt format to work properly. When this format is not applied, you will get a silent performance degradation: the model kinda works, but not as well as if you were following the expected prompt. More information about prompting, including which models and tasks need to be careful, is available in this <a href="tasks/prompting">guide</a>. Let’s see an example with a chat LLM, which makes use of <a href="chat_templating">chat templating</a>:',ft,de,bt,ge,wt,he,is="While the autoregressive generation process is relatively straightforward, making the most out of your LLM can be a challenging endeavor because there are many moving parts. For your next steps to help you dive deeper into LLM usage and understanding:",jt,Me,Ut,ye,os='<li>Guide on how to <a href="generation_strategies">control different generation methods</a>, how to set up the generation configuration file, and how to stream the output;</li> <li><a href="llm_optims">Accelerating text generation</a>;</li> <li><a href="chat_templating">Prompt templates for chat LLMs</a>;</li> <li><a href="tasks/prompting">Prompt design guide</a>;</li> <li>API reference on <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>, <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, and <a href="internal/generation_utils">generate-related classes</a>. Most of the classes, including the logits processors, have usage examples!</li>',Tt,fe,Jt,be,rs='<li><a href="https://huggingface.co/spaces/HuggingFaceH4/open_llm_leaderboard" rel="nofollow">Open LLM Leaderboard</a>, which focuses on the quality of the open-source models;</li> <li><a href="https://huggingface.co/spaces/optimum/llm-perf-leaderboard" rel="nofollow">Open LLM-Perf Leaderboard</a>, which focuses on LLM throughput.</li>',kt,we,Zt,je,ps='<li>Guide on how to <a href="llm_tutorial_optimization">optimize LLMs for speed and memory</a>;</li> <li>Guide on <a href="main_classes/quantization">quantization</a> such as bitsandbytes and autogptq, which shows you how to drastically reduce your memory requirements.</li>',_t,Ue,Gt,Te,ms='<li><a href="https://github.com/huggingface/optimum" rel="nofollow"><code>optimum</code></a>, an extension of 🤗 Transformers that optimizes for specific hardware devices;</li> <li><a href="https://github.com/outlines-dev/outlines" rel="nofollow"><code>outlines</code></a>, a library where you can constrain text generation (e.g. to generate JSON files);</li> <li><a href="https://github.com/uiuc-focal-lab/syncode" rel="nofollow"><code>SynCode</code></a>, a library for context-free grammar guided generation (e.g. JSON, SQL, Python);</li> <li><a href="https://github.com/huggingface/text-generation-inference" rel="nofollow"><code>text-generation-inference</code></a>, a production-ready server for LLMs;</li> <li><a href="https://github.com/oobabooga/text-generation-webui" rel="nofollow"><code>text-generation-webui</code></a>, a UI for text generation;</li> <li><a href="https://github.com/NVIDIA/logits-processor-zoo" rel="nofollow"><code>logits-processor-zoo</code></a>, containing additional options to control text generation with 🤗 Transformers. See our related <a href="https://huggingface.co/blog/logits-processor-zoo" rel="nofollow">blog post</a>.</li>',It,Je,vt,Ze,$t;return k=new y({props:{title:"Generation with LLMs",local:"generation-with-llms",headingTag:"h1"}}),Z=new Us({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial.ipynb"}]}}),j=new gs({props:{$$slots:{default:[Js]},$$scope:{ctx:ke}}}),V=new b({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGJpdHNhbmRieXRlcyUzRSUzRDAuMzkuMCUyMC1x",highlighted:"pip install transformers bitsandbytes&gt;=0.39.0 -q",wrap:!1}}),R=new y({props:{title:"Generate text",local:"generate-text",headingTag:"h2"}}),J=new gs({props:{$$slots:{default:[ks]},$$scope:{ctx:ke}}}),L=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),q=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwYWNjZWxlcmF0ZS50ZXN0X3V0aWxzLnRlc3RpbmclMjBpbXBvcnQlMjBnZXRfYmFja2VuZCUwQSUwQURFVklDRSUyQyUyMF8lMkMlMjBfJTIwJTNEJTIwZ2V0X2JhY2tlbmQoKSUyMCUyMyUyMGF1dG9tYXRpY2FsbHklMjBkZXRlY3RzJTIwdGhlJTIwdW5kZXJseWluZyUyMGRldmljZSUyMHR5cGUlMjAoQ1VEQSUyQyUyMENQVSUyQyUyMFhQVSUyQyUyME1QUyUyQyUyMGV0Yy4pJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiklMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTIyQSUyMGxpc3QlMjBvZiUyMGNvbG9ycyUzQSUyMHJlZCUyQyUyMGJsdWUlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhERVZJQ0Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate.test_utils.testing <span class="hljs-keyword">import</span> get_backend

<span class="hljs-meta">&gt;&gt;&gt; </span>DEVICE, _, _ = get_backend() <span class="hljs-comment"># automatically detects the underlying device type (CUDA, CPU, XPU, MPS, etc.)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(DEVICE)`,wrap:!1}}),A=new b({props:{code:"Z2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, orange, purple, pink,&#x27;</span>`,wrap:!1}}),P=new b({props:{code:"dG9rZW5pemVyLnBhZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW4lMjAlMjAlMjMlMjBNb3N0JTIwTExNcyUyMGRvbid0JTIwaGF2ZSUyMGElMjBwYWQlMjB0b2tlbiUyMGJ5JTIwZGVmYXVsdCUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjJBJTIwbGlzdCUyMG9mJTIwY29sb3JzJTNBJTIwcmVkJTJDJTIwYmx1ZSUyMiUyQyUyMCUyMlBvcnR1Z2FsJTIwaXMlMjIlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpLnRvKERFVklDRSklMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMpJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;A list of colors: red, blue&quot;</span>, <span class="hljs-string">&quot;Portugal is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>).to(DEVICE)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;A list of colors: red, blue, green, yellow, orange, purple, pink,&#x27;</span>,
<span class="hljs-string">&#x27;Portugal is a country in southwestern Europe, on the Iber&#x27;</span>]`,wrap:!1}}),O=new y({props:{title:"Common pitfalls",local:"common-pitfalls",headingTag:"h2"}}),te=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEF0b2tlbml6ZXIucGFkX3Rva2VuJTIwJTNEJTIwdG9rZW5pemVyLmVvc190b2tlbiUyMCUyMCUyMyUyME1vc3QlMjBMTE1zJTIwZG9uJ3QlMjBoYXZlJTIwYSUyMHBhZCUyMHRva2VuJTIwYnklMjBkZWZhdWx0JTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),se=new y({props:{title:"Generated output is too short/long",local:"generated-output-is-too-shortlong",headingTag:"h3"}}),ae=new b({props:{code:"bW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkElMjBzZXF1ZW5jZSUyMG9mJTIwbnVtYmVycyUzQSUyMDElMkMlMjAyJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oREVWSUNFKSUwQSUwQSUyMyUyMEJ5JTIwZGVmYXVsdCUyQyUyMHRoZSUyMG91dHB1dCUyMHdpbGwlMjBjb250YWluJTIwdXAlMjB0byUyMDIwJTIwdG9rZW5zJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEElMEElMjMlMjBTZXR0aW5nJTIwJTYwbWF4X25ld190b2tlbnMlNjAlMjBhbGxvd3MlMjB5b3UlMjB0byUyMGNvbnRyb2wlMjB0aGUlMjBtYXhpbXVtJTIwbGVuZ3RoJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqbW9kZWxfaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;A sequence of numbers: 1, 2&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(DEVICE)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># By default, the output will contain up to 20 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Setting \`max_new_tokens\` allows you to control the maximum length</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;A sequence of numbers: 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,&#x27;</span>`,wrap:!1}}),ne=new y({props:{title:"Incorrect generation mode",local:"incorrect-generation-mode",headingTag:"h3"}}),oe=new b({props:{code:"JTIzJTIwU2V0JTIwc2VlZCUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUyMC0tJTIweW91JTIwZG9uJ3QlMjBuZWVkJTIwdGhpcyUyMHVubGVzcyUyMHlvdSUyMHdhbnQlMjBmdWxsJTIwcmVwcm9kdWNpYmlsaXR5JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHNldF9zZWVkJTBBc2V0X3NlZWQoNDIpJTBBJTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCU1QiUyMkklMjBhbSUyMGElMjBjYXQuJTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oREVWSUNFKSUwQSUwQSUyMyUyMExMTSUyMCUyQiUyMGdyZWVkeSUyMGRlY29kaW5nJTIwJTNEJTIwcmVwZXRpdGl2ZSUyQyUyMGJvcmluZyUyMG91dHB1dCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwV2l0aCUyMHNhbXBsaW5nJTJDJTIwdGhlJTIwb3V0cHV0JTIwYmVjb21lcyUyMG1vcmUlMjBjcmVhdGl2ZSElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Set seed for reproducibility -- you don&#x27;t need this unless you want full reproducibility</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> set_seed
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">42</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([<span class="hljs-string">&quot;I am a cat.&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(DEVICE)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># LLM + greedy decoding = repetitive, boring output</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat. I am a cat. I am a cat. I am a cat&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With sampling, the output becomes more creative!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, do_sample=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;I am a cat.  Specifically, I am an indoor-only cat.  I&#x27;</span>`,wrap:!1}}),re=new y({props:{title:"Wrong padding side",local:"wrong-padding-side",headingTag:"h3"}}),me=new b({props:{code:"JTIzJTIwVGhlJTIwdG9rZW5pemVyJTIwaW5pdGlhbGl6ZWQlMjBhYm92ZSUyMGhhcyUyMHJpZ2h0LXBhZGRpbmclMjBhY3RpdmUlMjBieSUyMGRlZmF1bHQlM0ElMjB0aGUlMjAxc3QlMjBzZXF1ZW5jZSUyQyUwQSUyMyUyMHdoaWNoJTIwaXMlMjBzaG9ydGVyJTJDJTIwaGFzJTIwcGFkZGluZyUyMG9uJTIwdGhlJTIwcmlnaHQlMjBzaWRlLiUyMEdlbmVyYXRpb24lMjBmYWlscyUyMHRvJTIwY2FwdHVyZSUyMHRoZSUyMGxvZ2ljLiUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjIxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjAlMjJBJTJDJTIwQiUyQyUyMEMlMkMlMjBEJTJDJTIwRSUyMiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSkudG8oREVWSUNFKSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEJTBBJTBBJTIzJTIwV2l0aCUyMGxlZnQtcGFkZGluZyUyQyUyMGl0JTIwd29ya3MlMjBhcyUyMGV4cGVjdGVkISUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIpJTBBdG9rZW5pemVyLnBhZF90b2tlbiUyMCUzRCUyMHRva2VuaXplci5lb3NfdG9rZW4lMjAlMjAlMjMlMjBNb3N0JTIwTExNcyUyMGRvbid0JTIwaGF2ZSUyMGElMjBwYWQlMjB0b2tlbiUyMGJ5JTIwZGVmYXVsdCUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglMEElMjAlMjAlMjAlMjAlNUIlMjIxJTJDJTIwMiUyQyUyMDMlMjIlMkMlMjAlMjJBJTJDJTIwQiUyQyUyMEMlMkMlMjBEJTJDJTIwRSUyMiU1RCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSkudG8oREVWSUNFKSUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># The tokenizer initialized above has right-padding active by default: the 1st sequence,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># which is shorter, has padding on the right side. Generation fails to capture the logic.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(DEVICE)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 33333333333&#x27;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With left-padding, it works as expected!</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token = tokenizer.eos_token  <span class="hljs-comment"># Most LLMs don&#x27;t have a pad token by default</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer(
<span class="hljs-meta">... </span>    [<span class="hljs-string">&quot;1, 2, 3&quot;</span>, <span class="hljs-string">&quot;A, B, C, D, E&quot;</span>], padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>).to(DEVICE)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;1, 2, 3, 4, 5, 6,&#x27;</span>`,wrap:!1}}),ce=new y({props:{title:"Wrong prompt",local:"wrong-prompt",headingTag:"h3"}}),de=new b({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1hbHBoYSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWFscGhhJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTBBKSUwQXNldF9zZWVkKDApJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIySG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTIwUmVwbHklMjBhcyUyMGElMjB0aHVnLiUyMiUyMiUyMiUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplciglNUJwcm9tcHQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhERVZJQ0UpJTBBaW5wdXRfbGVuZ3RoJTIwJTNEJTIwbW9kZWxfaW5wdXRzLmlucHV0X2lkcy5zaGFwZSU1QjElNUQlMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKiptb2RlbF9pbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKSUwQXByaW50KHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyU1QiUzQSUyQyUyMGlucHV0X2xlbmd0aCUzQSU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTIzJTIwT2glMjBubyUyQyUyMGl0JTIwZGlkJTIwbm90JTIwZm9sbG93JTIwb3VyJTIwaW5zdHJ1Y3Rpb24lMjB0byUyMHJlcGx5JTIwYXMlMjBhJTIwdGh1ZyElMjBMZXQncyUyMHNlZSUyMHdoYXQlMjBoYXBwZW5zJTIwd2hlbiUyMHdlJTIwd3JpdGUlMEElMjMlMjBhJTIwYmV0dGVyJTIwcHJvbXB0JTIwYW5kJTIwdXNlJTIwdGhlJTIwcmlnaHQlMjB0ZW1wbGF0ZSUyMGZvciUyMHRoaXMlMjBtb2RlbCUyMCh0aHJvdWdoJTIwJTYwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUlNjApJTBBJTBBc2V0X3NlZWQoMCklMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHRodWclMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIb3clMjBtYW55JTIwaGVsaWNvcHRlcnMlMjBjYW4lMjBhJTIwaHVtYW4lMjBlYXQlMjBpbiUyMG9uZSUyMHNpdHRpbmclM0YlMjIlN0QlMkMlMEElNUQlMEFtb2RlbF9pbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShtZXNzYWdlcyUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzRFRydWUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhERVZJQ0UpJTBBaW5wdXRfbGVuZ3RoJTIwJTNEJTIwbW9kZWxfaW5wdXRzLnNoYXBlJTVCMSU1RCUwQWdlbmVyYXRlZF9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShtb2RlbF9pbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwbWF4X25ld190b2tlbnMlM0QyMCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF9pZHMlNUIlM0ElMkMlMjBpbnB1dF9sZW5ndGglM0ElNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVEKSUwQSUyMyUyMEFzJTIwd2UlMjBjYW4lMjBzZWUlMkMlMjBpdCUyMGZvbGxvd2VkJTIwYSUyMHByb3BlciUyMHRodWclMjBzdHlsZSUyMCVGMCU5RiU5OCU4RQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-alpha&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-alpha&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;&quot;&quot;How many helicopters can a human eat in one sitting? Reply as a thug.&quot;&quot;&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer([prompt], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(DEVICE)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = model_inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids[:, input_length:], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&quot;I&#x27;m not a thug, but i can tell you that a human cannot eat&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Oh no, it did not follow our instruction to reply as a thug! Let&#x27;s see what happens when we write</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># a better prompt and use the right template for this model (through \`tokenizer.apply_chat_template\`)</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>set_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a thug&quot;</span>,
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>model_inputs = tokenizer.apply_chat_template(messages, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(DEVICE)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = model_inputs.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(model_inputs, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.batch_decode(generated_ids[:, input_length:], skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])
<span class="hljs-string">&#x27;None, you thug. How bout you try to focus on more useful questions?&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># As we can see, it followed a proper thug style 😎</span>`,wrap:!1}}),ge=new y({props:{title:"Further resources",local:"further-resources",headingTag:"h2"}}),Me=new y({props:{title:"Advanced generate usage",local:"advanced-generate-usage",headingTag:"h3"}}),fe=new y({props:{title:"LLM leaderboards",local:"llm-leaderboards",headingTag:"h3"}}),we=new y({props:{title:"Latency, throughput and memory utilization",local:"latency-throughput-and-memory-utilization",headingTag:"h3"}}),Ue=new y({props:{title:"Related libraries",local:"related-libraries",headingTag:"h3"}}),Je=new Ts({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/llm_tutorial.md"}}),{c(){h=i("meta"),f=a(),M=i("p"),w=a(),p(k.$$.fragment),_e=a(),p(Z.$$.fragment),Ge=a(),_=i("p"),_.textContent=Wt,Ie=a(),G=i("p"),G.innerHTML=Rt,ve=a(),p(j.$$.fragment),$e=a(),I=i("p"),I.textContent=Ct,Ve=a(),v=i("ul"),v.innerHTML=Bt,We=a(),$=i("p"),$.textContent=xt,Re=a(),p(V.$$.fragment),Ce=a(),W=i("p"),W.innerHTML=Xt,Be=a(),p(R.$$.fragment),xe=a(),C=i("p"),C.innerHTML=zt,Xe=a(),U=i("figure"),U.innerHTML=Ht,ze=a(),B=i("p"),B.textContent=Lt,He=a(),T=i("figure"),T.innerHTML=Qt,Le=a(),x=i("p"),x.innerHTML=Et,Qe=a(),X=i("p"),X.innerHTML=Ft,Ee=a(),z=i("p"),z.textContent=Nt,Fe=a(),p(J.$$.fragment),Ne=a(),H=i("p"),H.textContent=qt,qe=a(),p(L.$$.fragment),Se=a(),Q=i("p"),Q.innerHTML=St,Ye=a(),E=i("ul"),E.innerHTML=Yt,Ae=a(),F=i("p"),F.textContent=At,De=a(),N=i("p"),N.innerHTML=Dt,Pe=a(),p(q.$$.fragment),Ke=a(),S=i("p"),S.innerHTML=Pt,Oe=a(),Y=i("p"),Y.innerHTML=Kt,et=a(),p(A.$$.fragment),tt=a(),D=i("p"),D.textContent=Ot,st=a(),p(P.$$.fragment),lt=a(),K=i("p"),K.textContent=es,at=a(),p(O.$$.fragment),nt=a(),ee=i("p"),ee.innerHTML=ts,it=a(),p(te.$$.fragment),ot=a(),p(se.$$.fragment),rt=a(),le=i("p"),le.innerHTML=ss,pt=a(),p(ae.$$.fragment),mt=a(),p(ne.$$.fragment),ct=a(),ie=i("p"),ie.innerHTML=ls,ut=a(),p(oe.$$.fragment),dt=a(),p(re.$$.fragment),gt=a(),pe=i("p"),pe.innerHTML=as,ht=a(),p(me.$$.fragment),Mt=a(),p(ce.$$.fragment),yt=a(),ue=i("p"),ue.innerHTML=ns,ft=a(),p(de.$$.fragment),bt=a(),p(ge.$$.fragment),wt=a(),he=i("p"),he.textContent=is,jt=a(),p(Me.$$.fragment),Ut=a(),ye=i("ol"),ye.innerHTML=os,Tt=a(),p(fe.$$.fragment),Jt=a(),be=i("ol"),be.innerHTML=rs,kt=a(),p(we.$$.fragment),Zt=a(),je=i("ol"),je.innerHTML=ps,_t=a(),p(Ue.$$.fragment),Gt=a(),Te=i("ol"),Te.innerHTML=ms,It=a(),p(Je.$$.fragment),vt=a(),Ze=i("p"),this.h()},l(e){const t=ws("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(s),f=n(e),M=o(e,"P",{}),ds(M).forEach(s),w=n(e),m(k.$$.fragment,e),_e=n(e),m(Z.$$.fragment,e),Ge=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-tihwde"&&(_.textContent=Wt),Ie=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-fnigcq"&&(G.innerHTML=Rt),ve=n(e),m(j.$$.fragment,e),$e=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1g5tmp7"&&(I.textContent=Ct),Ve=n(e),v=o(e,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-jbjjoq"&&(v.innerHTML=Bt),We=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1c9nexd"&&($.textContent=xt),Re=n(e),m(V.$$.fragment,e),Ce=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1wjvkti"&&(W.innerHTML=Xt),Be=n(e),m(R.$$.fragment,e),xe=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-e3t4o0"&&(C.innerHTML=zt),Xe=n(e),U=o(e,"FIGURE",{class:!0,"data-svelte-h":!0}),r(U)!=="svelte-hjgddv"&&(U.innerHTML=Ht),ze=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1qja5m9"&&(B.textContent=Lt),He=n(e),T=o(e,"FIGURE",{class:!0,"data-svelte-h":!0}),r(T)!=="svelte-1uqc9hk"&&(T.innerHTML=Qt),Le=n(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-pprvht"&&(x.innerHTML=Et),Qe=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1l96zw0"&&(X.innerHTML=Ft),Ee=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1wpt61n"&&(z.textContent=Nt),Fe=n(e),m(J.$$.fragment,e),Ne=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-17lmqvk"&&(H.textContent=qt),qe=n(e),m(L.$$.fragment,e),Se=n(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1ibsgq1"&&(Q.innerHTML=St),Ye=n(e),E=o(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-1ut1fuh"&&(E.innerHTML=Yt),Ae=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-14llc8d"&&(F.textContent=At),De=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-9uk3l0"&&(N.innerHTML=Dt),Pe=n(e),m(q.$$.fragment,e),Ke=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-isqmga"&&(S.innerHTML=Pt),Oe=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1c42551"&&(Y.innerHTML=Kt),et=n(e),m(A.$$.fragment,e),tt=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1p82il9"&&(D.textContent=Ot),st=n(e),m(P.$$.fragment,e),lt=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-wj0v9f"&&(K.textContent=es),at=n(e),m(O.$$.fragment,e),nt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1h0ongv"&&(ee.innerHTML=ts),it=n(e),m(te.$$.fragment,e),ot=n(e),m(se.$$.fragment,e),rt=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-16wmhsj"&&(le.innerHTML=ss),pt=n(e),m(ae.$$.fragment,e),mt=n(e),m(ne.$$.fragment,e),ct=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-9pvt4j"&&(ie.innerHTML=ls),ut=n(e),m(oe.$$.fragment,e),dt=n(e),m(re.$$.fragment,e),gt=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1n0cu3a"&&(pe.innerHTML=as),ht=n(e),m(me.$$.fragment,e),Mt=n(e),m(ce.$$.fragment,e),yt=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-136mw01"&&(ue.innerHTML=ns),ft=n(e),m(de.$$.fragment,e),bt=n(e),m(ge.$$.fragment,e),wt=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1w0my5d"&&(he.textContent=is),jt=n(e),m(Me.$$.fragment,e),Ut=n(e),ye=o(e,"OL",{"data-svelte-h":!0}),r(ye)!=="svelte-1fhcqea"&&(ye.innerHTML=os),Tt=n(e),m(fe.$$.fragment,e),Jt=n(e),be=o(e,"OL",{"data-svelte-h":!0}),r(be)!=="svelte-x6edjm"&&(be.innerHTML=rs),kt=n(e),m(we.$$.fragment,e),Zt=n(e),je=o(e,"OL",{"data-svelte-h":!0}),r(je)!=="svelte-15885m8"&&(je.innerHTML=ps),_t=n(e),m(Ue.$$.fragment,e),Gt=n(e),Te=o(e,"OL",{"data-svelte-h":!0}),r(Te)!=="svelte-154hiyq"&&(Te.innerHTML=ms),It=n(e),m(Je.$$.fragment,e),vt=n(e),Ze=o(e,"P",{}),ds(Ze).forEach(s),this.h()},h(){Vt(h,"name","hf:doc:metadata"),Vt(h,"content",_s),Vt(U,"class","image table text-center m-0 w-full"),Vt(T,"class","image table text-center m-0 w-full")},m(e,t){js(document.head,h),l(e,f,t),l(e,M,t),l(e,w,t),c(k,e,t),l(e,_e,t),c(Z,e,t),l(e,Ge,t),l(e,_,t),l(e,Ie,t),l(e,G,t),l(e,ve,t),c(j,e,t),l(e,$e,t),l(e,I,t),l(e,Ve,t),l(e,v,t),l(e,We,t),l(e,$,t),l(e,Re,t),c(V,e,t),l(e,Ce,t),l(e,W,t),l(e,Be,t),c(R,e,t),l(e,xe,t),l(e,C,t),l(e,Xe,t),l(e,U,t),l(e,ze,t),l(e,B,t),l(e,He,t),l(e,T,t),l(e,Le,t),l(e,x,t),l(e,Qe,t),l(e,X,t),l(e,Ee,t),l(e,z,t),l(e,Fe,t),c(J,e,t),l(e,Ne,t),l(e,H,t),l(e,qe,t),c(L,e,t),l(e,Se,t),l(e,Q,t),l(e,Ye,t),l(e,E,t),l(e,Ae,t),l(e,F,t),l(e,De,t),l(e,N,t),l(e,Pe,t),c(q,e,t),l(e,Ke,t),l(e,S,t),l(e,Oe,t),l(e,Y,t),l(e,et,t),c(A,e,t),l(e,tt,t),l(e,D,t),l(e,st,t),c(P,e,t),l(e,lt,t),l(e,K,t),l(e,at,t),c(O,e,t),l(e,nt,t),l(e,ee,t),l(e,it,t),c(te,e,t),l(e,ot,t),c(se,e,t),l(e,rt,t),l(e,le,t),l(e,pt,t),c(ae,e,t),l(e,mt,t),c(ne,e,t),l(e,ct,t),l(e,ie,t),l(e,ut,t),c(oe,e,t),l(e,dt,t),c(re,e,t),l(e,gt,t),l(e,pe,t),l(e,ht,t),c(me,e,t),l(e,Mt,t),c(ce,e,t),l(e,yt,t),l(e,ue,t),l(e,ft,t),c(de,e,t),l(e,bt,t),c(ge,e,t),l(e,wt,t),l(e,he,t),l(e,jt,t),c(Me,e,t),l(e,Ut,t),l(e,ye,t),l(e,Tt,t),c(fe,e,t),l(e,Jt,t),l(e,be,t),l(e,kt,t),c(we,e,t),l(e,Zt,t),l(e,je,t),l(e,_t,t),c(Ue,e,t),l(e,Gt,t),l(e,Te,t),l(e,It,t),c(Je,e,t),l(e,vt,t),l(e,Ze,t),$t=!0},p(e,[t]){const cs={};t&2&&(cs.$$scope={dirty:t,ctx:e}),j.$set(cs);const us={};t&2&&(us.$$scope={dirty:t,ctx:e}),J.$set(us)},i(e){$t||(u(k.$$.fragment,e),u(Z.$$.fragment,e),u(j.$$.fragment,e),u(V.$$.fragment,e),u(R.$$.fragment,e),u(J.$$.fragment,e),u(L.$$.fragment,e),u(q.$$.fragment,e),u(A.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(de.$$.fragment,e),u(ge.$$.fragment,e),u(Me.$$.fragment,e),u(fe.$$.fragment,e),u(we.$$.fragment,e),u(Ue.$$.fragment,e),u(Je.$$.fragment,e),$t=!0)},o(e){d(k.$$.fragment,e),d(Z.$$.fragment,e),d(j.$$.fragment,e),d(V.$$.fragment,e),d(R.$$.fragment,e),d(J.$$.fragment,e),d(L.$$.fragment,e),d(q.$$.fragment,e),d(A.$$.fragment,e),d(P.$$.fragment,e),d(O.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(me.$$.fragment,e),d(ce.$$.fragment,e),d(de.$$.fragment,e),d(ge.$$.fragment,e),d(Me.$$.fragment,e),d(fe.$$.fragment,e),d(we.$$.fragment,e),d(Ue.$$.fragment,e),d(Je.$$.fragment,e),$t=!1},d(e){e&&(s(f),s(M),s(w),s(_e),s(Ge),s(_),s(Ie),s(G),s(ve),s($e),s(I),s(Ve),s(v),s(We),s($),s(Re),s(Ce),s(W),s(Be),s(xe),s(C),s(Xe),s(U),s(ze),s(B),s(He),s(T),s(Le),s(x),s(Qe),s(X),s(Ee),s(z),s(Fe),s(Ne),s(H),s(qe),s(Se),s(Q),s(Ye),s(E),s(Ae),s(F),s(De),s(N),s(Pe),s(Ke),s(S),s(Oe),s(Y),s(et),s(tt),s(D),s(st),s(lt),s(K),s(at),s(nt),s(ee),s(it),s(ot),s(rt),s(le),s(pt),s(mt),s(ct),s(ie),s(ut),s(dt),s(gt),s(pe),s(ht),s(Mt),s(yt),s(ue),s(ft),s(bt),s(wt),s(he),s(jt),s(Ut),s(ye),s(Tt),s(Jt),s(be),s(kt),s(Zt),s(je),s(_t),s(Gt),s(Te),s(It),s(vt),s(Ze)),s(h),g(k,e),g(Z,e),g(j,e),g(V,e),g(R,e),g(J,e),g(L,e),g(q,e),g(A,e),g(P,e),g(O,e),g(te,e),g(se,e),g(ae,e),g(ne,e),g(oe,e),g(re,e),g(me,e),g(ce,e),g(de,e),g(ge,e),g(Me,e),g(fe,e),g(we,e),g(Ue,e),g(Je,e)}}}const _s='{"title":"Generation with LLMs","local":"generation-with-llms","sections":[{"title":"Generate text","local":"generate-text","sections":[],"depth":2},{"title":"Common pitfalls","local":"common-pitfalls","sections":[{"title":"Generated output is too short/long","local":"generated-output-is-too-shortlong","sections":[],"depth":3},{"title":"Incorrect generation mode","local":"incorrect-generation-mode","sections":[],"depth":3},{"title":"Wrong padding side","local":"wrong-padding-side","sections":[],"depth":3},{"title":"Wrong prompt","local":"wrong-prompt","sections":[],"depth":3}],"depth":2},{"title":"Further resources","local":"further-resources","sections":[{"title":"Advanced generate usage","local":"advanced-generate-usage","sections":[],"depth":3},{"title":"LLM leaderboards","local":"llm-leaderboards","sections":[],"depth":3},{"title":"Latency, throughput and memory utilization","local":"latency-throughput-and-memory-utilization","sections":[],"depth":3},{"title":"Related libraries","local":"related-libraries","sections":[],"depth":3}],"depth":2}],"depth":1}';function Gs(ke){return ys(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cs extends fs{constructor(h){super(),bs(this,h,Gs,Zs,Ms,{})}}export{Cs as component};
