import{s as kt,o as _t,n as Ie}from"../chunks/scheduler.25b97de1.js";import{S as Zt,i as Ct,g as b,s as o,r as u,A as vt,h as w,f as t,c as i,j as Tt,u as d,x as T,k as Jt,y as Wt,a as s,v as f,d as y,t as M,w as g,m as Gt,n as Xt}from"../chunks/index.d9030fc9.js";import{T as it}from"../chunks/Tip.baa67368.js";import{C as G}from"../chunks/CodeBlock.e6cd0d95.js";import{D as Rt}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{F as Ut,M as ot}from"../chunks/Markdown.7217f838.js";import{H as Ge,E as xt}from"../chunks/EditOnGithub.91d95064.js";function It(I){let l,h='If you aren’t familiar with finetuning a model with the <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a>, take a look at the basic tutorial <a href="../training#train-with-pytorch-trainer">here</a>!';return{c(){l=b("p"),l.innerHTML=h},l(n){l=w(n,"P",{"data-svelte-h":!0}),T(l)!=="svelte-15s4um0"&&(l.innerHTML=h)},m(n,m){s(n,l,m)},p:Ie,d(n){n&&t(l)}}}function Vt(I){let l,h,n,m='You’re ready to start training your model now! Load BERT with <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoModelForMultipleChoice">AutoModelForMultipleChoice</a>:',$,k,x,C,_="At this point, only three steps remain:",X,Z,V='<li>Define your training hyperparameters in <a href="/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>. The only required parameter is <code>output_dir</code> which specifies where to save your model. You’ll push this model to the Hub by setting <code>push_to_hub=True</code> (you need to be signed in to Hugging Face to upload your model). At the end of each epoch, the <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> will evaluate the accuracy and save the training checkpoint.</li> <li>Pass the training arguments to <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> along with the model, dataset, tokenizer, data collator, and <code>compute_metrics</code> function.</li> <li>Call <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.train">train()</a> to finetune your model.</li>',R,U,v,r,J='Once training is completed, share your model to the Hub with the <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> method so everyone can use your model:',B,Y,z;return l=new it({props:{$$slots:{default:[It]},$$scope:{ctx:I}}}),k=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTJDJTIwVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBUcmFpbmVyJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlLWJlcnQlMkZiZXJ0LWJhc2UtdW5jYXNlZCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForMultipleChoice, TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)`,wrap:!1}}),U=new G({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJteV9hd2Vzb21lX3N3YWdfbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBldmFsX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGxlYXJuaW5nX3JhdGUlM0Q1ZS01JTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTNEMTYlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2Vwb2NocyUzRDMlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRfZGVjYXklM0QwLjAxJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKSUwQSUwQXRyYWluZXIlMjAlM0QlMjBUcmFpbmVyKCUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0b2tlbml6ZWRfc3dhZyU1QiUyMnRyYWluJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdG9rZW5pemVkX3N3YWclNUIlMjJ2YWxpZGF0aW9uJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcHJvY2Vzc2luZ19jbGFzcyUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSklMEElMEF0cmFpbmVyLnRyYWluKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;my_awesome_swag_model&quot;</span>,
<span class="hljs-meta">... </span>    eval_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">16</span>,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=<span class="hljs-number">16</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    weight_decay=<span class="hljs-number">0.01</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=tokenized_swag[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    eval_dataset=tokenized_swag[<span class="hljs-string">&quot;validation&quot;</span>],
<span class="hljs-meta">... </span>    processing_class=tokenizer,
<span class="hljs-meta">... </span>    data_collator=collator,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()`,wrap:!1}}),Y=new G({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),{c(){u(l.$$.fragment),h=o(),n=b("p"),n.innerHTML=m,$=o(),u(k.$$.fragment),x=o(),C=b("p"),C.textContent=_,X=o(),Z=b("ol"),Z.innerHTML=V,R=o(),u(U.$$.fragment),v=o(),r=b("p"),r.innerHTML=J,B=o(),u(Y.$$.fragment)},l(c){d(l.$$.fragment,c),h=i(c),n=w(c,"P",{"data-svelte-h":!0}),T(n)!=="svelte-2bs5wx"&&(n.innerHTML=m),$=i(c),d(k.$$.fragment,c),x=i(c),C=w(c,"P",{"data-svelte-h":!0}),T(C)!=="svelte-l42k0i"&&(C.textContent=_),X=i(c),Z=w(c,"OL",{"data-svelte-h":!0}),T(Z)!=="svelte-18vvra9"&&(Z.innerHTML=V),R=i(c),d(U.$$.fragment,c),v=i(c),r=w(c,"P",{"data-svelte-h":!0}),T(r)!=="svelte-1v13hlo"&&(r.innerHTML=J),B=i(c),d(Y.$$.fragment,c)},m(c,W){f(l,c,W),s(c,h,W),s(c,n,W),s(c,$,W),f(k,c,W),s(c,x,W),s(c,C,W),s(c,X,W),s(c,Z,W),s(c,R,W),f(U,c,W),s(c,v,W),s(c,r,W),s(c,B,W),f(Y,c,W),z=!0},p(c,W){const F={};W&2&&(F.$$scope={dirty:W,ctx:c}),l.$set(F)},i(c){z||(y(l.$$.fragment,c),y(k.$$.fragment,c),y(U.$$.fragment,c),y(Y.$$.fragment,c),z=!0)},o(c){M(l.$$.fragment,c),M(k.$$.fragment,c),M(U.$$.fragment,c),M(Y.$$.fragment,c),z=!1},d(c){c&&(t(h),t(n),t($),t(x),t(C),t(X),t(Z),t(R),t(v),t(r),t(B)),g(l,c),g(k,c),g(U,c),g(Y,c)}}}function Bt(I){let l,h;return l=new ot({props:{$$slots:{default:[Vt]},$$scope:{ctx:I}}}),{c(){u(l.$$.fragment)},l(n){d(l.$$.fragment,n)},m(n,m){f(l,n,m),h=!0},p(n,m){const $={};m&2&&($.$$scope={dirty:m,ctx:n}),l.$set($)},i(n){h||(y(l.$$.fragment,n),h=!0)},o(n){M(l.$$.fragment,n),h=!1},d(n){g(l,n)}}}function Ft(I){let l,h='If you aren’t familiar with finetuning a model with Keras, take a look at the basic tutorial <a href="../training#train-a-tensorflow-model-with-keras">here</a>!';return{c(){l=b("p"),l.innerHTML=h},l(n){l=w(n,"P",{"data-svelte-h":!0}),T(l)!=="svelte-1rd4nl8"&&(l.innerHTML=h)},m(n,m){s(n,l,m)},p:Ie,d(n){n&&t(l)}}}function zt(I){let l,h,n,m,$,k='Then you can load BERT with <a href="/docs/transformers/main/en/model_doc/auto#transformers.TFAutoModelForMultipleChoice">TFAutoModelForMultipleChoice</a>:',x,C,_,X,Z='Convert your datasets to the <code>tf.data.Dataset</code> format with <a href="/docs/transformers/main/en/main_classes/model#transformers.TFPreTrainedModel.prepare_tf_dataset">prepare_tf_dataset()</a>:',V,R,U,v,r='Configure the model for training with <a href="https://keras.io/api/models/model_training_apis/#compile-method" rel="nofollow"><code>compile</code></a>. Note that Transformers models all have a default task-relevant loss function, so you don’t need to specify one unless you want to:',J,B,Y,z,c='The last two things to setup before you start training is to compute the accuracy from the predictions, and provide a way to push your model to the Hub. Both are done by using <a href="../main_classes/keras_callbacks">Keras callbacks</a>.',W,F,Xe='Pass your <code>compute_metrics</code> function to <a href="/docs/transformers/main/en/main_classes/keras_callbacks#transformers.KerasMetricCallback">KerasMetricCallback</a>:',ee,H,te,N,ie='Specify where to push your model and tokenizer in the <a href="/docs/transformers/main/en/main_classes/keras_callbacks#transformers.PushToHubCallback">PushToHubCallback</a>:',S,P,se,Q,ce="Then bundle your callbacks together:",q,D,ae,E,me='Finally, you’re ready to start training your model! Call <a href="https://keras.io/api/models/model_training_apis/#fit-method" rel="nofollow"><code>fit</code></a> with your training and validation datasets, the number of epochs, and your callbacks to finetune the model:',L,K,le,A,Re="Once training is completed, your model is automatically uploaded to the Hub so everyone can use it!",ne;return l=new it({props:{$$slots:{default:[Ft]},$$scope:{ctx:I}}}),n=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGNyZWF0ZV9vcHRpbWl6ZXIlMEElMEFiYXRjaF9zaXplJTIwJTNEJTIwMTYlMEFudW1fdHJhaW5fZXBvY2hzJTIwJTNEJTIwMiUwQXRvdGFsX3RyYWluX3N0ZXBzJTIwJTNEJTIwKGxlbih0b2tlbml6ZWRfc3dhZyU1QiUyMnRyYWluJTIyJTVEKSUyMCUyRiUyRiUyMGJhdGNoX3NpemUpJTIwKiUyMG51bV90cmFpbl9lcG9jaHMlMEFvcHRpbWl6ZXIlMkMlMjBzY2hlZHVsZSUyMCUzRCUyMGNyZWF0ZV9vcHRpbWl6ZXIoaW5pdF9sciUzRDVlLTUlMkMlMjBudW1fd2FybXVwX3N0ZXBzJTNEMCUyQyUyMG51bV90cmFpbl9zdGVwcyUzRHRvdGFsX3RyYWluX3N0ZXBzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> create_optimizer

<span class="hljs-meta">&gt;&gt;&gt; </span>batch_size = <span class="hljs-number">16</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_train_epochs = <span class="hljs-number">2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>total_train_steps = (<span class="hljs-built_in">len</span>(tokenized_swag[<span class="hljs-string">&quot;train&quot;</span>]) // batch_size) * num_train_epochs
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer, schedule = create_optimizer(init_lr=<span class="hljs-number">5e-5</span>, num_warmup_steps=<span class="hljs-number">0</span>, num_train_steps=total_train_steps)`,wrap:!1}}),C=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1iYXNlLXVuY2FzZWQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)`,wrap:!1}}),R=new G({props:{code:"ZGF0YV9jb2xsYXRvciUyMCUzRCUyMERhdGFDb2xsYXRvckZvck11bHRpcGxlQ2hvaWNlKHRva2VuaXplciUzRHRva2VuaXplciklMEF0Zl90cmFpbl9zZXQlMjAlM0QlMjBtb2RlbC5wcmVwYXJlX3RmX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVkX3N3YWclNUIlMjJ0cmFpbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNodWZmbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMEElMjAlMjAlMjAlMjBjb2xsYXRlX2ZuJTNEZGF0YV9jb2xsYXRvciUyQyUwQSklMEElMEF0Zl92YWxpZGF0aW9uX3NldCUyMCUzRCUyMG1vZGVsLnByZXBhcmVfdGZfZGF0YXNldCglMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfc3dhZyU1QiUyMnZhbGlkYXRpb24lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlJTNERmFsc2UlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGNvbGxhdGVfZm4lM0RkYXRhX2NvbGxhdG9yJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DataCollatorForMultipleChoice(tokenizer=tokenizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>tf_train_set = model.prepare_tf_dataset(
<span class="hljs-meta">... </span>    tokenized_swag[<span class="hljs-string">&quot;train&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    batch_size=batch_size,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_validation_set = model.prepare_tf_dataset(
<span class="hljs-meta">... </span>    tokenized_swag[<span class="hljs-string">&quot;validation&quot;</span>],
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    batch_size=batch_size,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>)`,wrap:!1}}),B=new G({props:{code:"bW9kZWwuY29tcGlsZShvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIpJTIwJTIwJTIzJTIwTm8lMjBsb3NzJTIwYXJndW1lbnQh",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(optimizer=optimizer)  <span class="hljs-comment"># No loss argument!</span>',wrap:!1}}),H=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5rZXJhc19jYWxsYmFja3MlMjBpbXBvcnQlMjBLZXJhc01ldHJpY0NhbGxiYWNrJTBBJTBBbWV0cmljX2NhbGxiYWNrJTIwJTNEJTIwS2VyYXNNZXRyaWNDYWxsYmFjayhtZXRyaWNfZm4lM0Rjb21wdXRlX21ldHJpY3MlMkMlMjBldmFsX2RhdGFzZXQlM0R0Zl92YWxpZGF0aW9uX3NldCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.keras_callbacks <span class="hljs-keyword">import</span> KerasMetricCallback

<span class="hljs-meta">&gt;&gt;&gt; </span>metric_callback = KerasMetricCallback(metric_fn=compute_metrics, eval_dataset=tf_validation_set)`,wrap:!1}}),P=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5rZXJhc19jYWxsYmFja3MlMjBpbXBvcnQlMjBQdXNoVG9IdWJDYWxsYmFjayUwQSUwQXB1c2hfdG9faHViX2NhbGxiYWNrJTIwJTNEJTIwUHVzaFRvSHViQ2FsbGJhY2soJTBBJTIwJTIwJTIwJTIwb3V0cHV0X2RpciUzRCUyMm15X2F3ZXNvbWVfbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.keras_callbacks <span class="hljs-keyword">import</span> PushToHubCallback

<span class="hljs-meta">&gt;&gt;&gt; </span>push_to_hub_callback = PushToHubCallback(
<span class="hljs-meta">... </span>    output_dir=<span class="hljs-string">&quot;my_awesome_model&quot;</span>,
<span class="hljs-meta">... </span>    tokenizer=tokenizer,
<span class="hljs-meta">... </span>)`,wrap:!1}}),D=new G({props:{code:"Y2FsbGJhY2tzJTIwJTNEJTIwJTVCbWV0cmljX2NhbGxiYWNrJTJDJTIwcHVzaF90b19odWJfY2FsbGJhY2slNUQ=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>callbacks = [metric_callback, push_to_hub_callback]',wrap:!1}}),K=new G({props:{code:"bW9kZWwuZml0KHglM0R0Zl90cmFpbl9zZXQlMkMlMjB2YWxpZGF0aW9uX2RhdGElM0R0Zl92YWxpZGF0aW9uX3NldCUyQyUyMGVwb2NocyUzRDIlMkMlMjBjYWxsYmFja3MlM0RjYWxsYmFja3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(x=tf_train_set, validation_data=tf_validation_set, epochs=<span class="hljs-number">2</span>, callbacks=callbacks)',wrap:!1}}),{c(){u(l.$$.fragment),h=Gt(`
To finetune a model in TensorFlow, start by setting up an optimizer function, learning rate schedule, and some training hyperparameters:

	`),u(n.$$.fragment),m=o(),$=b("p"),$.innerHTML=k,x=o(),u(C.$$.fragment),_=o(),X=b("p"),X.innerHTML=Z,V=o(),u(R.$$.fragment),U=o(),v=b("p"),v.innerHTML=r,J=o(),u(B.$$.fragment),Y=o(),z=b("p"),z.innerHTML=c,W=o(),F=b("p"),F.innerHTML=Xe,ee=o(),u(H.$$.fragment),te=o(),N=b("p"),N.innerHTML=ie,S=o(),u(P.$$.fragment),se=o(),Q=b("p"),Q.textContent=ce,q=o(),u(D.$$.fragment),ae=o(),E=b("p"),E.innerHTML=me,L=o(),u(K.$$.fragment),le=o(),A=b("p"),A.textContent=Re},l(a){d(l.$$.fragment,a),h=Xt(a,`
To finetune a model in TensorFlow, start by setting up an optimizer function, learning rate schedule, and some training hyperparameters:

	`),d(n.$$.fragment,a),m=i(a),$=w(a,"P",{"data-svelte-h":!0}),T($)!=="svelte-1hmpm03"&&($.innerHTML=k),x=i(a),d(C.$$.fragment,a),_=i(a),X=w(a,"P",{"data-svelte-h":!0}),T(X)!=="svelte-9ymftz"&&(X.innerHTML=Z),V=i(a),d(R.$$.fragment,a),U=i(a),v=w(a,"P",{"data-svelte-h":!0}),T(v)!=="svelte-17cxx5e"&&(v.innerHTML=r),J=i(a),d(B.$$.fragment,a),Y=i(a),z=w(a,"P",{"data-svelte-h":!0}),T(z)!=="svelte-6l1wkp"&&(z.innerHTML=c),W=i(a),F=w(a,"P",{"data-svelte-h":!0}),T(F)!=="svelte-bi2rpv"&&(F.innerHTML=Xe),ee=i(a),d(H.$$.fragment,a),te=i(a),N=w(a,"P",{"data-svelte-h":!0}),T(N)!=="svelte-1b3skyn"&&(N.innerHTML=ie),S=i(a),d(P.$$.fragment,a),se=i(a),Q=w(a,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-1lw9xm8"&&(Q.textContent=ce),q=i(a),d(D.$$.fragment,a),ae=i(a),E=w(a,"P",{"data-svelte-h":!0}),T(E)!=="svelte-1hrpv1v"&&(E.innerHTML=me),L=i(a),d(K.$$.fragment,a),le=i(a),A=w(a,"P",{"data-svelte-h":!0}),T(A)!=="svelte-2s71om"&&(A.textContent=Re)},m(a,j){f(l,a,j),s(a,h,j),f(n,a,j),s(a,m,j),s(a,$,j),s(a,x,j),f(C,a,j),s(a,_,j),s(a,X,j),s(a,V,j),f(R,a,j),s(a,U,j),s(a,v,j),s(a,J,j),f(B,a,j),s(a,Y,j),s(a,z,j),s(a,W,j),s(a,F,j),s(a,ee,j),f(H,a,j),s(a,te,j),s(a,N,j),s(a,S,j),f(P,a,j),s(a,se,j),s(a,Q,j),s(a,q,j),f(D,a,j),s(a,ae,j),s(a,E,j),s(a,L,j),f(K,a,j),s(a,le,j),s(a,A,j),ne=!0},p(a,j){const O={};j&2&&(O.$$scope={dirty:j,ctx:a}),l.$set(O)},i(a){ne||(y(l.$$.fragment,a),y(n.$$.fragment,a),y(C.$$.fragment,a),y(R.$$.fragment,a),y(B.$$.fragment,a),y(H.$$.fragment,a),y(P.$$.fragment,a),y(D.$$.fragment,a),y(K.$$.fragment,a),ne=!0)},o(a){M(l.$$.fragment,a),M(n.$$.fragment,a),M(C.$$.fragment,a),M(R.$$.fragment,a),M(B.$$.fragment,a),M(H.$$.fragment,a),M(P.$$.fragment,a),M(D.$$.fragment,a),M(K.$$.fragment,a),ne=!1},d(a){a&&(t(h),t(m),t($),t(x),t(_),t(X),t(V),t(U),t(v),t(J),t(Y),t(z),t(W),t(F),t(ee),t(te),t(N),t(S),t(se),t(Q),t(q),t(ae),t(E),t(L),t(le),t(A)),g(l,a),g(n,a),g(C,a),g(R,a),g(B,a),g(H,a),g(P,a),g(D,a),g(K,a)}}}function Yt(I){let l,h;return l=new ot({props:{$$slots:{default:[zt]},$$scope:{ctx:I}}}),{c(){u(l.$$.fragment)},l(n){d(l.$$.fragment,n)},m(n,m){f(l,n,m),h=!0},p(n,m){const $={};m&2&&($.$$scope={dirty:m,ctx:n}),l.$set($)},i(n){h||(y(l.$$.fragment,n),h=!0)},o(n){M(l.$$.fragment,n),h=!1},d(n){g(l,n)}}}function Ht(I){let l,h=`For a more in-depth example of how to finetune a model for multiple choice, take a look at the corresponding
<a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/multiple_choice.ipynb" rel="nofollow">PyTorch notebook</a>
or <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/multiple_choice-tf.ipynb" rel="nofollow">TensorFlow notebook</a>.`;return{c(){l=b("p"),l.innerHTML=h},l(n){l=w(n,"P",{"data-svelte-h":!0}),T(l)!=="svelte-1c9mh52"&&(l.innerHTML=h)},m(n,m){s(n,l,m)},p:Ie,d(n){n&&t(l)}}}function Nt(I){let l,h="Tokenize each prompt and candidate answer pair and return PyTorch tensors. You should also create some <code>labels</code>:",n,m,$,k,x="Pass your inputs and labels to the model and return the <code>logits</code>:",C,_,X,Z,V="Get the class with the highest probability:",R,U,v;return m=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ1c2VybmFtZSUyRm15X2F3ZXNvbWVfc3dhZ19tb2RlbCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTVCcHJvbXB0JTJDJTIwY2FuZGlkYXRlMSU1RCUyQyUyMCU1QnByb21wdCUyQyUyMGNhbmRpZGF0ZTIlNUQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUpJTBBbGFiZWxzJTIwJTNEJTIwdG9yY2gudGVuc29yKDApLnVuc3F1ZWV6ZSgwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;username/my_awesome_swag_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([[prompt, candidate1], [prompt, candidate2]], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor(<span class="hljs-number">0</span>).unsqueeze(<span class="hljs-number">0</span>)`,wrap:!1}}),_=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JNdWx0aXBsZUNob2ljZS5mcm9tX3ByZXRyYWluZWQoJTIydXNlcm5hbWUlMkZteV9hd2Vzb21lX3N3YWdfbW9kZWwlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqJTdCayUzQSUyMHYudW5zcXVlZXplKDApJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGlucHV0cy5pdGVtcygpJTdEJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;username/my_awesome_swag_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**{k: v.unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),U=new G({props:{code:"cHJlZGljdGVkX2NsYXNzJTIwJTNEJTIwbG9naXRzLmFyZ21heCgpLml0ZW0oKSUwQXByZWRpY3RlZF9jbGFzcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class = logits.argmax().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class
<span class="hljs-number">0</span>`,wrap:!1}}),{c(){l=b("p"),l.innerHTML=h,n=o(),u(m.$$.fragment),$=o(),k=b("p"),k.innerHTML=x,C=o(),u(_.$$.fragment),X=o(),Z=b("p"),Z.textContent=V,R=o(),u(U.$$.fragment)},l(r){l=w(r,"P",{"data-svelte-h":!0}),T(l)!=="svelte-1qxmddt"&&(l.innerHTML=h),n=i(r),d(m.$$.fragment,r),$=i(r),k=w(r,"P",{"data-svelte-h":!0}),T(k)!=="svelte-10twm8n"&&(k.innerHTML=x),C=i(r),d(_.$$.fragment,r),X=i(r),Z=w(r,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-18e4iwl"&&(Z.textContent=V),R=i(r),d(U.$$.fragment,r)},m(r,J){s(r,l,J),s(r,n,J),f(m,r,J),s(r,$,J),s(r,k,J),s(r,C,J),f(_,r,J),s(r,X,J),s(r,Z,J),s(r,R,J),f(U,r,J),v=!0},p:Ie,i(r){v||(y(m.$$.fragment,r),y(_.$$.fragment,r),y(U.$$.fragment,r),v=!0)},o(r){M(m.$$.fragment,r),M(_.$$.fragment,r),M(U.$$.fragment,r),v=!1},d(r){r&&(t(l),t(n),t($),t(k),t(C),t(X),t(Z),t(R)),g(m,r),g(_,r),g(U,r)}}}function Qt(I){let l,h;return l=new ot({props:{$$slots:{default:[Nt]},$$scope:{ctx:I}}}),{c(){u(l.$$.fragment)},l(n){d(l.$$.fragment,n)},m(n,m){f(l,n,m),h=!0},p(n,m){const $={};m&2&&($.$$scope={dirty:m,ctx:n}),l.$set($)},i(n){h||(y(l.$$.fragment,n),h=!0)},o(n){M(l.$$.fragment,n),h=!1},d(n){g(l,n)}}}function Et(I){let l,h="Tokenize each prompt and candidate answer pair and return TensorFlow tensors:",n,m,$,k,x="Pass your inputs to the model and return the <code>logits</code>:",C,_,X,Z,V="Get the class with the highest probability:",R,U,v;return m=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ1c2VybmFtZSUyRm15X2F3ZXNvbWVfc3dhZ19tb2RlbCUyMiklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTVCJTVCcHJvbXB0JTJDJTIwY2FuZGlkYXRlMSU1RCUyQyUyMCU1QnByb21wdCUyQyUyMGNhbmRpZGF0ZTIlNUQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyJTJDJTIwcGFkZGluZyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;username/my_awesome_swag_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([[prompt, candidate1], [prompt, candidate2]], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>, padding=<span class="hljs-literal">True</span>)`,wrap:!1}}),_=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRGQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMnVzZXJuYW1lJTJGbXlfYXdlc29tZV9zd2FnX21vZGVsJTIyKSUwQWlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB0Zi5leHBhbmRfZGltcyh2JTJDJTIwMCklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;username/my_awesome_swag_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = {k: tf.expand_dims(v, <span class="hljs-number">0</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),U=new G({props:{code:"cHJlZGljdGVkX2NsYXNzJTIwJTNEJTIwaW50KHRmLm1hdGguYXJnbWF4KGxvZ2l0cyUyQyUyMGF4aXMlM0QtMSklNUIwJTVEKSUwQXByZWRpY3RlZF9jbGFzcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class = <span class="hljs-built_in">int</span>(tf.math.argmax(logits, axis=-<span class="hljs-number">1</span>)[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class
<span class="hljs-number">0</span>`,wrap:!1}}),{c(){l=b("p"),l.textContent=h,n=o(),u(m.$$.fragment),$=o(),k=b("p"),k.innerHTML=x,C=o(),u(_.$$.fragment),X=o(),Z=b("p"),Z.textContent=V,R=o(),u(U.$$.fragment)},l(r){l=w(r,"P",{"data-svelte-h":!0}),T(l)!=="svelte-q8vskg"&&(l.textContent=h),n=i(r),d(m.$$.fragment,r),$=i(r),k=w(r,"P",{"data-svelte-h":!0}),T(k)!=="svelte-f3g043"&&(k.innerHTML=x),C=i(r),d(_.$$.fragment,r),X=i(r),Z=w(r,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-18e4iwl"&&(Z.textContent=V),R=i(r),d(U.$$.fragment,r)},m(r,J){s(r,l,J),s(r,n,J),f(m,r,J),s(r,$,J),s(r,k,J),s(r,C,J),f(_,r,J),s(r,X,J),s(r,Z,J),s(r,R,J),f(U,r,J),v=!0},p:Ie,i(r){v||(y(m.$$.fragment,r),y(_.$$.fragment,r),y(U.$$.fragment,r),v=!0)},o(r){M(m.$$.fragment,r),M(_.$$.fragment,r),M(U.$$.fragment,r),v=!1},d(r){r&&(t(l),t(n),t($),t(k),t(C),t(X),t(Z),t(R)),g(m,r),g(_,r),g(U,r)}}}function At(I){let l,h;return l=new ot({props:{$$slots:{default:[Et]},$$scope:{ctx:I}}}),{c(){u(l.$$.fragment)},l(n){d(l.$$.fragment,n)},m(n,m){f(l,n,m),h=!0},p(n,m){const $={};m&2&&($.$$scope={dirty:m,ctx:n}),l.$set($)},i(n){h||(y(l.$$.fragment,n),h=!0)},o(n){M(l.$$.fragment,n),h=!1},d(n){g(l,n)}}}function St(I){let l,h,n,m,$,k,x,C,_,X="A multiple choice task is similar to question answering, except several candidate answers are provided along with a context and the model is trained to select the correct answer.",Z,V,R="This guide will show you how to:",U,v,r='<li>Finetune <a href="https://huggingface.co/google-bert/bert-base-uncased" rel="nofollow">BERT</a> on the <code>regular</code> configuration of the <a href="https://huggingface.co/datasets/swag" rel="nofollow">SWAG</a> dataset to select the best answer given multiple options and some context.</li> <li>Use your finetuned model for inference.</li>',J,B,Y="Before you begin, make sure you have all the necessary libraries installed:",z,c,W,F,Xe="We encourage you to login to your Hugging Face account so you can upload and share your model with the community. When prompted, enter your token to login:",ee,H,te,N,ie,S,P="Start by loading the <code>regular</code> configuration of the SWAG dataset from the 🤗 Datasets library:",se,Q,ce,q,D="Then take a look at an example:",ae,E,me,L,K="While it looks like there are a lot of fields here, it is actually pretty straightforward:",le,A,Re="<li><code>sent1</code> and <code>sent2</code>: these fields show how a sentence starts, and if you put the two together, you get the <code>startphrase</code> field.</li> <li><code>ending</code>: suggests a possible ending for how a sentence can end, but only one of them is correct.</li> <li><code>label</code>: identifies the correct sentence ending.</li>",ne,a,j,O,ct="The next step is to load a BERT tokenizer to process the sentence starts and the four possible endings:",Ve,he,Be,ue,mt="The preprocessing function you want to create needs to:",Fe,de,ht="<li>Make four copies of the <code>sent1</code> field and combine each of them with <code>sent2</code> to recreate how a sentence starts.</li> <li>Combine <code>sent2</code> with each of the four possible sentence endings.</li> <li>Flatten these two lists so you can tokenize them, and then unflatten them afterward so each example has a corresponding <code>input_ids</code>, <code>attention_mask</code>, and <code>labels</code> field.</li>",ze,fe,Ye,ye,ut='To apply the preprocessing function over the entire dataset, use 🤗 Datasets <a href="https://huggingface.co/docs/datasets/main/en/package_reference/main_classes#datasets.Dataset.map" rel="nofollow">map</a> method. You can speed up the <code>map</code> function by setting <code>batched=True</code> to process multiple elements of the dataset at once:',He,Me,Ne,ge,dt='To create a batch of examples, it’s more efficient to <em>dynamically pad</em> the sentences to the longest length in a batch during collation, instead of padding the whole dataset to the maximum length. <a href="/docs/transformers/main/en/main_classes/data_collator#transformers.DataCollatorForMultipleChoice">DataCollatorForMultipleChoice</a> flattens all the model inputs, applies padding, and then unflattens the results.',Qe,be,Ee,we,Ae,je,ft='Including a metric during training is often helpful for evaluating your model’s performance. You can quickly load a evaluation method with the 🤗 <a href="https://huggingface.co/docs/evaluate/index" rel="nofollow">Evaluate</a> library. For this task, load the <a href="https://huggingface.co/spaces/evaluate-metric/accuracy" rel="nofollow">accuracy</a> metric (see the 🤗 Evaluate <a href="https://huggingface.co/docs/evaluate/a_quick_tour" rel="nofollow">quick tour</a> to learn more about how to load and compute a metric):',Se,$e,qe,Te,yt='Then create a function that passes your predictions and labels to <a href="https://huggingface.co/docs/evaluate/main/en/package_reference/main_classes#evaluate.EvaluationModule.compute" rel="nofollow">compute</a> to calculate the accuracy:',Le,Je,Pe,Ue,Mt="Your <code>compute_metrics</code> function is ready to go now, and you’ll return to it when you setup your training.",De,ke,Ke,pe,Oe,re,et,_e,tt,Ze,gt="Great, now that you’ve finetuned a model, you can use it for inference!",st,Ce,bt="Come up with some text and two candidate answers:",at,ve,lt,oe,nt,We,pt,xe,rt;return $=new Ge({props:{title:"Multiple choice",local:"multiple-choice",headingTag:"h1"}}),x=new Rt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/multiple_choice.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/multiple_choice.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/multiple_choice.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/multiple_choice.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/multiple_choice.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/multiple_choice.ipynb"}]}}),c=new G({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwZXZhbHVhdGU=",highlighted:"pip install transformers datasets evaluate",wrap:!1}}),H=new G({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),N=new Ge({props:{title:"Load SWAG dataset",local:"load-swag-dataset",headingTag:"h2"}}),Q=new G({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBc3dhZyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJzd2FnJTIyJTJDJTIwJTIycmVndWxhciUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>swag = load_dataset(<span class="hljs-string">&quot;swag&quot;</span>, <span class="hljs-string">&quot;regular&quot;</span>)`,wrap:!1}}),E=new G({props:{code:"c3dhZyU1QiUyMnRyYWluJTIyJTVEJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>swag[<span class="hljs-string">&quot;train&quot;</span>][<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;ending0&#x27;</span>: <span class="hljs-string">&#x27;passes by walking down the street playing their instruments.&#x27;</span>,
 <span class="hljs-string">&#x27;ending1&#x27;</span>: <span class="hljs-string">&#x27;has heard approaching them.&#x27;</span>,
 <span class="hljs-string">&#x27;ending2&#x27;</span>: <span class="hljs-string">&quot;arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
 <span class="hljs-string">&#x27;ending3&#x27;</span>: <span class="hljs-string">&#x27;turns the lead singer watches the performance.&#x27;</span>,
 <span class="hljs-string">&#x27;fold-ind&#x27;</span>: <span class="hljs-string">&#x27;3416&#x27;</span>,
 <span class="hljs-string">&#x27;gold-source&#x27;</span>: <span class="hljs-string">&#x27;gold&#x27;</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;sent1&#x27;</span>: <span class="hljs-string">&#x27;Members of the procession walk down the street holding small horn brass instruments.&#x27;</span>,
 <span class="hljs-string">&#x27;sent2&#x27;</span>: <span class="hljs-string">&#x27;A drum line&#x27;</span>,
 <span class="hljs-string">&#x27;startphrase&#x27;</span>: <span class="hljs-string">&#x27;Members of the procession walk down the street holding small horn brass instruments. A drum line&#x27;</span>,
 <span class="hljs-string">&#x27;video-id&#x27;</span>: <span class="hljs-string">&#x27;anetv_jkn6uvmqwh4&#x27;</span>}`,wrap:!1}}),a=new Ge({props:{title:"Preprocess",local:"preprocess",headingTag:"h2"}}),he=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)`,wrap:!1}}),fe=new G({props:{code:"ZW5kaW5nX25hbWVzJTIwJTNEJTIwJTVCJTIyZW5kaW5nMCUyMiUyQyUyMCUyMmVuZGluZzElMjIlMkMlMjAlMjJlbmRpbmcyJTIyJTJDJTIwJTIyZW5kaW5nMyUyMiU1RCUwQSUwQSUwQWRlZiUyMHByZXByb2Nlc3NfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwZmlyc3Rfc2VudGVuY2VzJTIwJTNEJTIwJTVCJTVCY29udGV4dCU1RCUyMColMjA0JTIwZm9yJTIwY29udGV4dCUyMGluJTIwZXhhbXBsZXMlNUIlMjJzZW50MSUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uX2hlYWRlcnMlMjAlM0QlMjBleGFtcGxlcyU1QiUyMnNlbnQyJTIyJTVEJTBBJTIwJTIwJTIwJTIwc2Vjb25kX3NlbnRlbmNlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmYlMjIlN0JoZWFkZXIlN0QlMjAlN0JleGFtcGxlcyU1QmVuZCU1RCU1QmklNUQlN0QlMjIlMjBmb3IlMjBlbmQlMjBpbiUyMGVuZGluZ19uYW1lcyU1RCUyMGZvciUyMGklMkMlMjBoZWFkZXIlMjBpbiUyMGVudW1lcmF0ZShxdWVzdGlvbl9oZWFkZXJzKSUwQSUyMCUyMCUyMCUyMCU1RCUwQSUwQSUyMCUyMCUyMCUyMGZpcnN0X3NlbnRlbmNlcyUyMCUzRCUyMHN1bShmaXJzdF9zZW50ZW5jZXMlMkMlMjAlNUIlNUQpJTBBJTIwJTIwJTIwJTIwc2Vjb25kX3NlbnRlbmNlcyUyMCUzRCUyMHN1bShzZWNvbmRfc2VudGVuY2VzJTJDJTIwJTVCJTVEKSUwQSUwQSUyMCUyMCUyMCUyMHRva2VuaXplZF9leGFtcGxlcyUyMCUzRCUyMHRva2VuaXplcihmaXJzdF9zZW50ZW5jZXMlMkMlMjBzZWNvbmRfc2VudGVuY2VzJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCayUzQSUyMCU1QnYlNUJpJTIwJTNBJTIwaSUyMCUyQiUyMDQlNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHYpJTJDJTIwNCklNUQlMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwdG9rZW5pemVkX2V4YW1wbGVzLml0ZW1zKCklN0Q=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>ending_names = [<span class="hljs-string">&quot;ending0&quot;</span>, <span class="hljs-string">&quot;ending1&quot;</span>, <span class="hljs-string">&quot;ending2&quot;</span>, <span class="hljs-string">&quot;ending3&quot;</span>]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_function</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    first_sentences = [[context] * <span class="hljs-number">4</span> <span class="hljs-keyword">for</span> context <span class="hljs-keyword">in</span> examples[<span class="hljs-string">&quot;sent1&quot;</span>]]
<span class="hljs-meta">... </span>    question_headers = examples[<span class="hljs-string">&quot;sent2&quot;</span>]
<span class="hljs-meta">... </span>    second_sentences = [
<span class="hljs-meta">... </span>        [<span class="hljs-string">f&quot;<span class="hljs-subst">{header}</span> <span class="hljs-subst">{examples[end][i]}</span>&quot;</span> <span class="hljs-keyword">for</span> end <span class="hljs-keyword">in</span> ending_names] <span class="hljs-keyword">for</span> i, header <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(question_headers)
<span class="hljs-meta">... </span>    ]

<span class="hljs-meta">... </span>    first_sentences = <span class="hljs-built_in">sum</span>(first_sentences, [])
<span class="hljs-meta">... </span>    second_sentences = <span class="hljs-built_in">sum</span>(second_sentences, [])

<span class="hljs-meta">... </span>    tokenized_examples = tokenizer(first_sentences, second_sentences, truncation=<span class="hljs-literal">True</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {k: [v[i : i + <span class="hljs-number">4</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), <span class="hljs-number">4</span>)] <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> tokenized_examples.items()}`,wrap:!1}}),Me=new G({props:{code:"dG9rZW5pemVkX3N3YWclMjAlM0QlMjBzd2FnLm1hcChwcmVwcm9jZXNzX2Z1bmN0aW9uJTJDJTIwYmF0Y2hlZCUzRFRydWUp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_swag = swag.<span class="hljs-built_in">map</span>(preprocess_function, batched=<span class="hljs-literal">True</span>)',wrap:!1}}),be=new G({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERhdGFDb2xsYXRvckZvck11bHRpcGxlQ2hvaWNlJTBBY29sbGF0b3IlMjAlM0QlMjBEYXRhQ29sbGF0b3JGb3JNdWx0aXBsZUNob2ljZSh0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DataCollatorForMultipleChoice
<span class="hljs-meta">&gt;&gt;&gt; </span>collator = DataCollatorForMultipleChoice(tokenizer=tokenizer)`,wrap:!1}}),we=new Ge({props:{title:"Evaluate",local:"evaluate",headingTag:"h2"}}),$e=new G({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFhY2N1cmFjeSUyMCUzRCUyMGV2YWx1YXRlLmxvYWQoJTIyYWNjdXJhY3klMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> evaluate

<span class="hljs-meta">&gt;&gt;&gt; </span>accuracy = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)`,wrap:!1}}),Je=new G({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyQyUyMGxhYmVscyUyMCUzRCUyMGV2YWxfcHJlZCUwQSUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwbnAuYXJnbWF4KHByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYWNjdXJhY3kuY29tcHV0ZShwcmVkaWN0aW9ucyUzRHByZWRpY3Rpb25zJTJDJTIwcmVmZXJlbmNlcyUzRGxhYmVscyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    predictions, labels = eval_pred
<span class="hljs-meta">... </span>    predictions = np.argmax(predictions, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> accuracy.compute(predictions=predictions, references=labels)`,wrap:!1}}),ke=new Ge({props:{title:"Train",local:"train",headingTag:"h2"}}),pe=new Ut({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[Yt],pytorch:[Bt]},$$scope:{ctx:I}}}),re=new it({props:{$$slots:{default:[Ht]},$$scope:{ctx:I}}}),_e=new Ge({props:{title:"Inference",local:"inference",headingTag:"h2"}}),ve=new G({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyRnJhbmNlJTIwaGFzJTIwYSUyMGJyZWFkJTIwbGF3JTJDJTIwTGUlMjBEJUMzJUE5Y3JldCUyMFBhaW4lMkMlMjB3aXRoJTIwc3RyaWN0JTIwcnVsZXMlMjBvbiUyMHdoYXQlMjBpcyUyMGFsbG93ZWQlMjBpbiUyMGElMjB0cmFkaXRpb25hbCUyMGJhZ3VldHRlLiUyMiUwQWNhbmRpZGF0ZTElMjAlM0QlMjAlMjJUaGUlMjBsYXclMjBkb2VzJTIwbm90JTIwYXBwbHklMjB0byUyMGNyb2lzc2FudHMlMjBhbmQlMjBicmlvY2hlLiUyMiUwQWNhbmRpZGF0ZTIlMjAlM0QlMjAlMjJUaGUlMjBsYXclMjBhcHBsaWVzJTIwdG8lMjBiYWd1ZXR0ZXMuJTIy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;France has a bread law, Le Décret Pain, with strict rules on what is allowed in a traditional baguette.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate1 = <span class="hljs-string">&quot;The law does not apply to croissants and brioche.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate2 = <span class="hljs-string">&quot;The law applies to baguettes.&quot;</span>`,wrap:!1}}),oe=new Ut({props:{pytorch:!0,tensorflow:!0,jax:!1,$$slots:{tensorflow:[At],pytorch:[Qt]},$$scope:{ctx:I}}}),We=new xt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tasks/multiple_choice.md"}}),{c(){l=b("meta"),h=o(),n=b("p"),m=o(),u($.$$.fragment),k=o(),u(x.$$.fragment),C=o(),_=b("p"),_.textContent=X,Z=o(),V=b("p"),V.textContent=R,U=o(),v=b("ol"),v.innerHTML=r,J=o(),B=b("p"),B.textContent=Y,z=o(),u(c.$$.fragment),W=o(),F=b("p"),F.textContent=Xe,ee=o(),u(H.$$.fragment),te=o(),u(N.$$.fragment),ie=o(),S=b("p"),S.innerHTML=P,se=o(),u(Q.$$.fragment),ce=o(),q=b("p"),q.textContent=D,ae=o(),u(E.$$.fragment),me=o(),L=b("p"),L.textContent=K,le=o(),A=b("ul"),A.innerHTML=Re,ne=o(),u(a.$$.fragment),j=o(),O=b("p"),O.textContent=ct,Ve=o(),u(he.$$.fragment),Be=o(),ue=b("p"),ue.textContent=mt,Fe=o(),de=b("ol"),de.innerHTML=ht,ze=o(),u(fe.$$.fragment),Ye=o(),ye=b("p"),ye.innerHTML=ut,He=o(),u(Me.$$.fragment),Ne=o(),ge=b("p"),ge.innerHTML=dt,Qe=o(),u(be.$$.fragment),Ee=o(),u(we.$$.fragment),Ae=o(),je=b("p"),je.innerHTML=ft,Se=o(),u($e.$$.fragment),qe=o(),Te=b("p"),Te.innerHTML=yt,Le=o(),u(Je.$$.fragment),Pe=o(),Ue=b("p"),Ue.innerHTML=Mt,De=o(),u(ke.$$.fragment),Ke=o(),u(pe.$$.fragment),Oe=o(),u(re.$$.fragment),et=o(),u(_e.$$.fragment),tt=o(),Ze=b("p"),Ze.textContent=gt,st=o(),Ce=b("p"),Ce.textContent=bt,at=o(),u(ve.$$.fragment),lt=o(),u(oe.$$.fragment),nt=o(),u(We.$$.fragment),pt=o(),xe=b("p"),this.h()},l(e){const p=vt("svelte-u9bgzb",document.head);l=w(p,"META",{name:!0,content:!0}),p.forEach(t),h=i(e),n=w(e,"P",{}),Tt(n).forEach(t),m=i(e),d($.$$.fragment,e),k=i(e),d(x.$$.fragment,e),C=i(e),_=w(e,"P",{"data-svelte-h":!0}),T(_)!=="svelte-gcifhg"&&(_.textContent=X),Z=i(e),V=w(e,"P",{"data-svelte-h":!0}),T(V)!=="svelte-1aff4p7"&&(V.textContent=R),U=i(e),v=w(e,"OL",{"data-svelte-h":!0}),T(v)!=="svelte-1iw2sa5"&&(v.innerHTML=r),J=i(e),B=w(e,"P",{"data-svelte-h":!0}),T(B)!=="svelte-1c9nexd"&&(B.textContent=Y),z=i(e),d(c.$$.fragment,e),W=i(e),F=w(e,"P",{"data-svelte-h":!0}),T(F)!=="svelte-k76o1m"&&(F.textContent=Xe),ee=i(e),d(H.$$.fragment,e),te=i(e),d(N.$$.fragment,e),ie=i(e),S=w(e,"P",{"data-svelte-h":!0}),T(S)!=="svelte-ndvump"&&(S.innerHTML=P),se=i(e),d(Q.$$.fragment,e),ce=i(e),q=w(e,"P",{"data-svelte-h":!0}),T(q)!=="svelte-1m91ua0"&&(q.textContent=D),ae=i(e),d(E.$$.fragment,e),me=i(e),L=w(e,"P",{"data-svelte-h":!0}),T(L)!=="svelte-1dgdrcg"&&(L.textContent=K),le=i(e),A=w(e,"UL",{"data-svelte-h":!0}),T(A)!=="svelte-vj0noe"&&(A.innerHTML=Re),ne=i(e),d(a.$$.fragment,e),j=i(e),O=w(e,"P",{"data-svelte-h":!0}),T(O)!=="svelte-j3i2fe"&&(O.textContent=ct),Ve=i(e),d(he.$$.fragment,e),Be=i(e),ue=w(e,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-pduvot"&&(ue.textContent=mt),Fe=i(e),de=w(e,"OL",{"data-svelte-h":!0}),T(de)!=="svelte-tso4vc"&&(de.innerHTML=ht),ze=i(e),d(fe.$$.fragment,e),Ye=i(e),ye=w(e,"P",{"data-svelte-h":!0}),T(ye)!=="svelte-74644w"&&(ye.innerHTML=ut),He=i(e),d(Me.$$.fragment,e),Ne=i(e),ge=w(e,"P",{"data-svelte-h":!0}),T(ge)!=="svelte-1j78585"&&(ge.innerHTML=dt),Qe=i(e),d(be.$$.fragment,e),Ee=i(e),d(we.$$.fragment,e),Ae=i(e),je=w(e,"P",{"data-svelte-h":!0}),T(je)!=="svelte-j1ipe9"&&(je.innerHTML=ft),Se=i(e),d($e.$$.fragment,e),qe=i(e),Te=w(e,"P",{"data-svelte-h":!0}),T(Te)!=="svelte-14irt3v"&&(Te.innerHTML=yt),Le=i(e),d(Je.$$.fragment,e),Pe=i(e),Ue=w(e,"P",{"data-svelte-h":!0}),T(Ue)!=="svelte-183aynn"&&(Ue.innerHTML=Mt),De=i(e),d(ke.$$.fragment,e),Ke=i(e),d(pe.$$.fragment,e),Oe=i(e),d(re.$$.fragment,e),et=i(e),d(_e.$$.fragment,e),tt=i(e),Ze=w(e,"P",{"data-svelte-h":!0}),T(Ze)!=="svelte-633ppb"&&(Ze.textContent=gt),st=i(e),Ce=w(e,"P",{"data-svelte-h":!0}),T(Ce)!=="svelte-nni2mt"&&(Ce.textContent=bt),at=i(e),d(ve.$$.fragment,e),lt=i(e),d(oe.$$.fragment,e),nt=i(e),d(We.$$.fragment,e),pt=i(e),xe=w(e,"P",{}),Tt(xe).forEach(t),this.h()},h(){Jt(l,"name","hf:doc:metadata"),Jt(l,"content",qt)},m(e,p){Wt(document.head,l),s(e,h,p),s(e,n,p),s(e,m,p),f($,e,p),s(e,k,p),f(x,e,p),s(e,C,p),s(e,_,p),s(e,Z,p),s(e,V,p),s(e,U,p),s(e,v,p),s(e,J,p),s(e,B,p),s(e,z,p),f(c,e,p),s(e,W,p),s(e,F,p),s(e,ee,p),f(H,e,p),s(e,te,p),f(N,e,p),s(e,ie,p),s(e,S,p),s(e,se,p),f(Q,e,p),s(e,ce,p),s(e,q,p),s(e,ae,p),f(E,e,p),s(e,me,p),s(e,L,p),s(e,le,p),s(e,A,p),s(e,ne,p),f(a,e,p),s(e,j,p),s(e,O,p),s(e,Ve,p),f(he,e,p),s(e,Be,p),s(e,ue,p),s(e,Fe,p),s(e,de,p),s(e,ze,p),f(fe,e,p),s(e,Ye,p),s(e,ye,p),s(e,He,p),f(Me,e,p),s(e,Ne,p),s(e,ge,p),s(e,Qe,p),f(be,e,p),s(e,Ee,p),f(we,e,p),s(e,Ae,p),s(e,je,p),s(e,Se,p),f($e,e,p),s(e,qe,p),s(e,Te,p),s(e,Le,p),f(Je,e,p),s(e,Pe,p),s(e,Ue,p),s(e,De,p),f(ke,e,p),s(e,Ke,p),f(pe,e,p),s(e,Oe,p),f(re,e,p),s(e,et,p),f(_e,e,p),s(e,tt,p),s(e,Ze,p),s(e,st,p),s(e,Ce,p),s(e,at,p),f(ve,e,p),s(e,lt,p),f(oe,e,p),s(e,nt,p),f(We,e,p),s(e,pt,p),s(e,xe,p),rt=!0},p(e,[p]){const wt={};p&2&&(wt.$$scope={dirty:p,ctx:e}),pe.$set(wt);const jt={};p&2&&(jt.$$scope={dirty:p,ctx:e}),re.$set(jt);const $t={};p&2&&($t.$$scope={dirty:p,ctx:e}),oe.$set($t)},i(e){rt||(y($.$$.fragment,e),y(x.$$.fragment,e),y(c.$$.fragment,e),y(H.$$.fragment,e),y(N.$$.fragment,e),y(Q.$$.fragment,e),y(E.$$.fragment,e),y(a.$$.fragment,e),y(he.$$.fragment,e),y(fe.$$.fragment,e),y(Me.$$.fragment,e),y(be.$$.fragment,e),y(we.$$.fragment,e),y($e.$$.fragment,e),y(Je.$$.fragment,e),y(ke.$$.fragment,e),y(pe.$$.fragment,e),y(re.$$.fragment,e),y(_e.$$.fragment,e),y(ve.$$.fragment,e),y(oe.$$.fragment,e),y(We.$$.fragment,e),rt=!0)},o(e){M($.$$.fragment,e),M(x.$$.fragment,e),M(c.$$.fragment,e),M(H.$$.fragment,e),M(N.$$.fragment,e),M(Q.$$.fragment,e),M(E.$$.fragment,e),M(a.$$.fragment,e),M(he.$$.fragment,e),M(fe.$$.fragment,e),M(Me.$$.fragment,e),M(be.$$.fragment,e),M(we.$$.fragment,e),M($e.$$.fragment,e),M(Je.$$.fragment,e),M(ke.$$.fragment,e),M(pe.$$.fragment,e),M(re.$$.fragment,e),M(_e.$$.fragment,e),M(ve.$$.fragment,e),M(oe.$$.fragment,e),M(We.$$.fragment,e),rt=!1},d(e){e&&(t(h),t(n),t(m),t(k),t(C),t(_),t(Z),t(V),t(U),t(v),t(J),t(B),t(z),t(W),t(F),t(ee),t(te),t(ie),t(S),t(se),t(ce),t(q),t(ae),t(me),t(L),t(le),t(A),t(ne),t(j),t(O),t(Ve),t(Be),t(ue),t(Fe),t(de),t(ze),t(Ye),t(ye),t(He),t(Ne),t(ge),t(Qe),t(Ee),t(Ae),t(je),t(Se),t(qe),t(Te),t(Le),t(Pe),t(Ue),t(De),t(Ke),t(Oe),t(et),t(tt),t(Ze),t(st),t(Ce),t(at),t(lt),t(nt),t(pt),t(xe)),t(l),g($,e),g(x,e),g(c,e),g(H,e),g(N,e),g(Q,e),g(E,e),g(a,e),g(he,e),g(fe,e),g(Me,e),g(be,e),g(we,e),g($e,e),g(Je,e),g(ke,e),g(pe,e),g(re,e),g(_e,e),g(ve,e),g(oe,e),g(We,e)}}}const qt='{"title":"Multiple choice","local":"multiple-choice","sections":[{"title":"Load SWAG dataset","local":"load-swag-dataset","sections":[],"depth":2},{"title":"Preprocess","local":"preprocess","sections":[],"depth":2},{"title":"Evaluate","local":"evaluate","sections":[],"depth":2},{"title":"Train","local":"train","sections":[],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2}],"depth":1}';function Lt(I){return _t(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class as extends Zt{constructor(l){super(),Ct(this,l,Lt,St,kt,{})}}export{as as component};
