import{s as nc,n as mc,o as uc}from"../chunks/scheduler.0219f8bd.js";import{S as fc,i as hc,g as a,s as o,r as p,A as _c,h as i,f as r,c as l,j as _,u as n,x as d,k as c,y as gc,a as s,v as m,d as u,t as f,w as h}from"../chunks/index.f61edf3b.js";import{C as Ti}from"../chunks/CodeBlock.38e566ae.js";import{H as g,E as xc}from"../chunks/EditOnGithub.48fa589f.js";function Tc(bi){let x,zr,Fr,Ar,T,Rr,b,Ur,y,yi="Processors are used to prepare non-textual inputs (e.g., image or audio) for a model.",Dr,$,$i="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",kr,v,Br,M,vi='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li> <li><a href="#Callable+_call"><code>._call(...args)</code></a></li></ul></li> <li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+get_resize_output_image_size"><code>.get_resize_output_image_size(image, size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+resize"><code>.resize(image)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li> <li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation()</code></a> : <code>*</code></li></ul></li> <li><a href="#module_processors.Processor">.Processor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.WhisperProcessor">.WhisperProcessor</a> ⇐ <code>Processor</code><ul><li><a href="#module_processors.WhisperProcessor+_call"><code>._call(audio)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.AutoProcessor">.AutoProcessor</a><ul><li><a href="#module_processors.AutoProcessor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li> <li><a href="#module_processors.data"><code>.data</code></a> : <code>Float32Array</code></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..center_to_corners_format"><code>~center_to_corners_format(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_processors..post_process_semantic_segmentation"><code>~post_process_semantic_segmentation(outputs, [target_sizes])</code></a> ⇒ <code>*</code><ul><li><a href="#module_processors..post_process_semantic_segmentation..labels"><code>~labels</code></a> : <code>Array.&lt;number&gt;</code></li></ul></li> <li><a href="#module_processors..post_process_panoptic_segmentation"><code>~post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li> <li><a href="#module_processors..post_process_instance_segmentation"><code>~post_process_instance_segmentation(outputs, [threshold], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li> <li><a href="#module_processors..enforce_size_divisibility"><code>~enforce_size_divisibility(size, divisor)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors..HeightWidth"><code>~HeightWidth</code></a> : <code>*</code></li> <li><a href="#module_processors..ImageFeatureExtractorResult"><code>~ImageFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..PreprocessedImage"><code>~PreprocessedImage</code></a> : <code>object</code></li> <li><a href="#module_processors..DetrFeatureExtractorResult"><code>~DetrFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..SamImageProcessorResult"><code>~SamImageProcessorResult</code></a> : <code>object</code></li></ul></li></ul></li>',Wr,Nr,Gr,w,Yr,E,Zr,C,Mi="Base class for feature extractors.",Qr,P,wi='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <a href="#Callable"><code>Callable</code></a>',Xr,H,Ei='<li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li> <li><a href="#Callable+_call"><code>._call(...args)</code></a></li></ul></li>',qr,Vr,Kr,J,Sr,I,Or,L,Ci="Constructs a new FeatureExtractor instance.",es,F,Pi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td></tr></tbody>",ts,rs,ss,j,os,z,ls,A,Hi=`This method should be implemented in subclasses to provide the
functionality of the callable object.`,as,R,Ji='<strong>Kind</strong>: instance method of <a href="#module_processors.FeatureExtractor"><code>FeatureExtractor</code></a><br/> <strong>Overrides</strong>: <a href="#Callable+_call"><code>_call</code></a><br/> <strong>Throws</strong>:',is,U,Ii="<li><code>Error</code> If the subclass does not implement the `_call` method.</li>",ds,D,Li="<thead><tr><th>Param</th><th>Type</th></tr></thead> <tbody><tr><td>...args</td><td><code>Array.&lt;any&gt;</code></td></tr></tbody>",cs,ps,ns,k,ms,B,us,W,Fi="Feature extractor for image models.",fs,N,ji='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>FeatureExtractor</code>',hs,G,zi='<li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+rescale"><code>.rescale(pixelData)</code></a> ⇒ <code>void</code></li> <li><a href="#module_processors.ImageFeatureExtractor+get_resize_output_image_size"><code>.get_resize_output_image_size(image, size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+resize"><code>.resize(image)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li>',_s,gs,xs,Y,Ts,Z,bs,Q,Ai="Constructs a new ImageFeatureExtractor instance.",ys,X,Ri=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td></td><td><p>The configuration for the feature extractor.</p></td> </tr><tr><td>config.image_mean</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The mean values for image normalization.</p></td> </tr><tr><td>config.image_std</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The standard deviation values for image normalization.</p></td> </tr><tr><td>config.do_rescale</td><td><code>boolean</code></td><td></td><td><p>Whether to rescale the image pixel values to the [0,1] range.</p></td> </tr><tr><td>config.rescale_factor</td><td><code>number</code></td><td></td><td><p>The factor to use for rescaling the image pixel values.</p></td> </tr><tr><td>config.do_normalize</td><td><code>boolean</code></td><td></td><td><p>Whether to normalize the image pixel values.</p></td> </tr><tr><td>config.do_resize</td><td><code>boolean</code></td><td></td><td><p>Whether to resize the image.</p></td> </tr><tr><td>config.resample</td><td><code>number</code></td><td></td><td><p>What method to use for resampling.</p></td> </tr><tr><td>config.size</td><td><code>number</code> | <code>Object</code></td><td></td><td><p>The size to resize the image to.</p></td> </tr><tr><td>[config.do_flip_channel_order]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to flip the color channels from RGB to BGR.
Can be overridden by the <code>do_flip_channel_order</code> parameter in the <code>preprocess</code> method.</p></td></tr></tbody>`,$s,vs,Ms,q,ws,V,Es,K,Ui=`Resize the image to make a thumbnail. The image is resized so that no dimension is larger than any
corresponding dimension of the specified size.`,Cs,S,Di='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',Ps,O,ki="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be resized.</p></td> </tr><tr><td>size</td><td><code>Object</code></td><td></td><td><p>The size <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> to resize the image to.</p></td> </tr><tr><td>[resample]</td><td><code>string</code> | <code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code></td><td><code>2</code></td><td><p>The resampling filter to use.</p></td></tr></tbody>",Hs,Js,Is,ee,Ls,te,Fs,re,Bi="Crops the margin of the image. Gray pixels are considered margin (i.e., pixels with a value below the threshold).",js,se,Wi='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The cropped image.',zs,oe,Ni="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be cropped.</p></td> </tr><tr><td>gray_threshold</td><td><code>number</code></td><td><code>200</code></td><td><p>Value below which pixels are considered to be gray.</p></td></tr></tbody>",As,Rs,Us,le,Ds,ae,ks,ie,Gi="Pad the image by a certain amount.",Bs,de,Yi='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The padded pixel data and image dimensions.',Ws,ce,Zi="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td></td><td><p>The pixel data to pad.</p></td> </tr><tr><td>imgDims</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The dimensions of the image (height, width, channels).</p></td> </tr><tr><td>padSize</td><td><code>*</code></td><td></td><td><p>The dimensions of the padded image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for padding.</p></td> </tr><tr><td>[options.mode]</td><td><code>&#39;constant&#39;</code> | <code>&#39;symmetric&#39;</code></td><td><code>&#39;constant&#39;</code></td><td><p>The type of padding to add.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to center the image.</p></td> </tr><tr><td>[options.constant_values]</td><td><code>number</code></td><td><code>0</code></td><td><p>The constant value to use for padding.</p></td></tr></tbody>",Ns,Gs,Ys,pe,Zs,ne,Qs,me,Qi="Rescale the image’ pixel values by <code>this.rescale_factor</code>.",Xs,ue,Xi='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a>',qs,fe,qi="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td><p>The pixel data to rescale.</p></td></tr></tbody>",Vs,Ks,Ss,he,Os,_e,eo,ge,Vi=`Find the target (width, height) dimension of the output image after
resizing given the input image and the desired size.`,to,xe,Ki='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The target (width, height) dimension of the output image after resizing.',ro,Te,Si="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to resize.</p></td> </tr><tr><td>size</td><td><code>any</code></td><td><p>The size to use for resizing the image.</p></td></tr></tbody>",so,oo,lo,be,ao,ye,io,$e,Oi="Resizes the image.",co,ve,ed='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',po,Me,td="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to resize.</p></td></tr></tbody>",no,mo,uo,we,fo,Ee,ho,Ce,rd="Preprocesses the given image.",_o,Pe,sd='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;PreprocessedImage&gt;</code> - The preprocessed image.',go,He,od="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to preprocess.</p></td> </tr><tr><td>overrides</td><td><code>Object</code></td><td><p>The overrides for the preprocessing options.</p></td></tr></tbody>",xo,To,bo,Je,yo,Ie,$o,Le,ld=`Calls the feature extraction process on an array of images,
preprocesses each image, and concatenates the resulting
features into a single Tensor.`,vo,Fe,ad='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values (and other metadata) of the preprocessed images.',Mo,je,id="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",wo,Eo,Co,ze,Po,Ae,Ho,Re,dd="Detr Feature Extractor.",Jo,Ue,cd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>ImageFeatureExtractor</code>',Io,De,pd='<li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation()</code></a> : <code>*</code></li></ul></li>',Lo,Fo,jo,ke,zo,Be,Ao,We,nd=`Calls the feature extraction process on an array of images, preprocesses
each image, and concatenates the resulting features into a single Tensor.`,Ro,Ne,md='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values of the preprocessed images.',Uo,Ge,ud="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td></tr></tbody>",Do,ko,Bo,Ye,Wo,Ze,No,Qe,fd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',Go,Yo,Zo,Xe,Qo,qe,Xo,Ve,hd='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',qo,Vo,Ko,Ke,So,Se,Oo,Oe,_d="Represents a Processor that extracts features from an input.",el,et,gd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <a href="#Callable"><code>Callable</code></a>',tl,tt,xd='<li><a href="#module_processors.Processor">.Processor</a> ⇐ <a href="#Callable"><code>Callable</code></a><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',rl,sl,ol,rt,ll,st,al,ot,Td="Creates a new Processor with the given feature extractor.",il,lt,bd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>feature_extractor</td><td><code>FeatureExtractor</code></td><td><p>The function used to extract features from the input.</p></td></tr></tbody>",dl,cl,pl,at,nl,it,ml,dt,yd="Calls the feature_extractor function with the given input.",ul,ct,$d='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Overrides</strong>: <a href="#Callable+_call"><code>_call</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',fl,pt,vd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",hl,_l,gl,nt,xl,mt,Tl,ut,Md="Represents a WhisperProcessor that extracts features from an audio input.",bl,ft,wd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Processor</code>',yl,$l,vl,ht,Ml,_t,wl,gt,Ed="Calls the feature_extractor function with the given audio input.",El,xt,Cd='<strong>Kind</strong>: instance method of <a href="#module_processors.WhisperProcessor"><code>WhisperProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',Cl,Tt,Pd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td><p>The audio input to extract features from.</p></td></tr></tbody>",Pl,Hl,Jl,bt,Il,yt,Ll,$t,Hd=`Helper class which is used to instantiate pretrained processors with the <code>from_pretrained</code> function.
The chosen processor class is determined by the type specified in the processor config.`,Fl,vt,Jd="<strong>Example:</strong> Load a processor using <code>from_pretrained</code>.",jl,Mt,zl,wt,Id="<strong>Example:</strong> Run an image through a processor.",Al,Et,Rl,Ct,Ld='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',Ul,Dl,kl,Pt,Bl,Ht,Wl,Jt,Fd="Instantiate one of the processor classes of the library from a pretrained model.",Nl,It,jd=`The processor class to instantiate is selected based on the <code>feature_extractor_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,Gl,Lt,zd='<strong>Kind</strong>: static method of <a href="#module_processors.AutoProcessor"><code>AutoProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',Yl,Ft,Ad=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>*</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,Zl,Ql,Xl,jt,ql,zt,Vl,At,Rd='<strong>Kind</strong>: static property of <a href="#module_processors"><code>processors</code></a>',Kl,Sl,Ol,Rt,ea,Ut,ta,Dt,Ud="Converts bounding boxes from center format to corners format.",ra,kt,Dd='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The coodinates for the top-left and bottom-right corners of the box (top_left_x, top_left_y, bottom_right_x, bottom_right_y)',sa,Bt,kd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The coordinate for the center of the box and its width, height dimensions (center_x, center_y, width, height)</p></td></tr></tbody>",oa,la,aa,Wt,ia,Nt,da,Gt,Bd="Post-processes the outputs of the model (for semantic segmentation).",ca,Yt,Wd='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>*</code> - The semantic segmentation maps.',pa,Zt,Nd=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>*</code></td><td></td><td><p>Raw outputs of the model.</p></td> </tr><tr><td>[target_sizes]</td><td><code>*</code></td><td><code></code></td><td><p>List of tuples corresponding to the requested final size
(height, width) of each prediction. If unset, predictions will not be resized.</p></td></tr></tbody>`,na,ma,ua,Qt,fa,Xt,ha,qt,Gd="The unique list of labels that were detected",_a,Vt,Yd='<strong>Kind</strong>: inner constant of <a href="#module_processors..post_process_semantic_segmentation"><code>post_process_semantic_segmentation</code></a>',ga,xa,Ta,Kt,ba,St,ya,Ot,Zd="Post-process the model output to generate the final panoptic segmentation.",$a,er,Qd='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a>',va,tr,Xd="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>*</code></td><td></td><td><p>The model output to post process</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The probability score threshold to keep predicted instance masks.</p></td> </tr><tr><td>[mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold to merge or discard small disconnected parts within each binary instance mask.</p></td> </tr><tr><td>[label_ids_to_fuse]</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The labels in this state will have all their instances be fused together.</p></td> </tr><tr><td>[target_sizes]</td><td><code>*</code></td><td><code></code></td><td><p>The target sizes to resize the masks to.</p></td></tr></tbody>",Ma,wa,Ea,rr,Ca,sr,Pa,or,qd="Post-processes the outputs of the model (for instance segmentation).",Ha,lr,Vd='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a>',Ja,ar,Kd=`<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>*</code></td><td></td><td><p>Raw outputs of the model.</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The probability score threshold to keep predicted instance masks.</p></td> </tr><tr><td>[target_sizes]</td><td><code>*</code></td><td><code></code></td><td><p>List of tuples corresponding to the requested final size
(height, width) of each prediction. If unset, predictions will not be resized.</p></td></tr></tbody>`,Ia,La,Fa,ir,ja,dr,za,cr,Sd="Rounds the height and width down to the closest multiple of size_divisibility",Aa,pr,Od='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>*</code> - The rounded size.',Ra,nr,ec="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>size</td><td><code>*</code></td><td><p>The size of the image</p></td> </tr><tr><td>divisor</td><td><code>number</code></td><td><p>The divisor to use.</p></td></tr></tbody>",Ua,Da,ka,mr,Ba,ur,Wa,fr,tc=`Named tuple to indicate the order we are using is (height x width), even though
the Graphics’ industry standard is (width x height).`,Na,hr,rc='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',Ga,Ya,Za,_r,Qa,gr,Xa,xr,sc='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',qa,Tr,oc="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the batched preprocessed images.</p></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[480, 640]].</p></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[1000, 1330]].</p></td></tr></tbody>",Va,Ka,Sa,br,Oa,yr,ei,$r,lc='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',ti,vr,ac="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>original_size</td><td><code>HeightWidth</code></td><td><p>The original size of the image.</p></td> </tr><tr><td>reshaped_input_size</td><td><code>HeightWidth</code></td><td><p>The reshaped input size of the image.</p></td> </tr><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the preprocessed image.</p></td></tr></tbody>",ri,si,oi,Mr,li,wr,ai,Er,ic='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',ii,Cr,dc="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_mask</td><td><code>Tensor</code></td></tr></tbody>",di,ci,pi,Pr,ni,Hr,mi,Jr,cc='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',ui,Ir,pc="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>[input_points]</td><td><code>Tensor</code></td> </tr><tr><td>[input_labels]</td><td><code>Tensor</code></td> </tr><tr><td>[input_boxes]</td><td><code>Tensor</code></td></tr></tbody>",fi,hi,_i,Lr,gi,jr,xi;return b=new g({props:{title:"processors",local:"processors",headingTag:"h1"}}),v=new Ti({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJyUzQiUwQSUwQWxldCUyMHByb2Nlc3NvciUyMCUzRCUyMGF3YWl0JTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJ29wZW5haSUyRndoaXNwZXItdGlueS5lbicpJTNCJTBBbGV0JTIwYXVkaW8lMjAlM0QlMjBhd2FpdCUyMHJlYWRfYXVkaW8oJ2h0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGbWxrLmZsYWMnJTJDJTIwMTYwMDApJTNCJTBBbGV0JTIwJTdCJTIwaW5wdXRfZmVhdHVyZXMlMjAlN0QlMjAlM0QlMjBhd2FpdCUyMHByb2Nlc3NvcihhdWRpbyklM0IlMEElMkYlMkYlMjBUZW5zb3IlMjAlN0IlMEElMkYlMkYlMjAlMjAlMjBkYXRhJTNBJTIwRmxvYXQzMkFycmF5KDI0MDAwMCklMjAlNUIwLjQ3NTI5ODQ2NDI5ODI0ODMlMkMlMjAwLjU1OTcyNTg4MDYyMjg2MzglMkMlMjAwLjU2NDM0MTY2NDMxNDI3JTJDJTIwLi4uJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwZGltcyUzQSUyMCU1QjElMkMlMjA4MCUyQyUyMDMwMDAlNUQlMkMlMEElMkYlMkYlMjAlMjAlMjB0eXBlJTNBJTIwJ2Zsb2F0MzInJTJDJTBBJTJGJTJGJTIwJTIwJTIwc2l6ZSUzQSUyMDI0MDAwMCUyQyUwQSUyRiUyRiUyMCU3RA==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@huggingface/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/v3.0.0/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">let</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),E=new g({props:{title:"processors.FeatureExtractor ⇐ <code> Callable </code>",local:"processorsfeatureextractor--code-callable-code",headingTag:"h2"}}),I=new g({props:{title:"new FeatureExtractor(config)",local:"new-featureextractorconfig",headingTag:"h3"}}),z=new g({props:{title:"featureExtractor._call(...args)",local:"featureextractorcallargs",headingTag:"h3"}}),B=new g({props:{title:"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>",local:"processorsimagefeatureextractor--code-featureextractor-code",headingTag:"h2"}}),Z=new g({props:{title:"new ImageFeatureExtractor(config)",local:"new-imagefeatureextractorconfig",headingTag:"h3"}}),V=new g({props:{title:"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code",headingTag:"h3"}}),te=new g({props:{title:"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code",headingTag:"h3"}}),ae=new g({props:{title:"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>",local:"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code",headingTag:"h3"}}),ne=new g({props:{title:"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>",local:"imagefeatureextractorrescalepixeldata--code-void-code",headingTag:"h3"}}),_e=new g({props:{title:"imageFeatureExtractor.get_resize_output_image_size(image, size) ⇒ <code> * </code>",local:"imagefeatureextractorgetresizeoutputimagesizeimage-size--code--code",headingTag:"h3"}}),ye=new g({props:{title:"imageFeatureExtractor.resize(image) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorresizeimage--code-promise--rawimage--code",headingTag:"h3"}}),Ee=new g({props:{title:"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>",local:"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code",headingTag:"h3"}}),Ie=new g({props:{title:"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>",local:"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code",headingTag:"h3"}}),Ae=new g({props:{title:"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>",local:"processorsdetrfeatureextractor--code-imagefeatureextractor-code",headingTag:"h2"}}),Be=new g({props:{title:"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>",local:"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code",headingTag:"h3"}}),Ze=new g({props:{title:"detrFeatureExtractor.post_process_object_detection() : <code> * </code>",local:"detrfeatureextractorpostprocessobjectdetection--code--code",headingTag:"h3"}}),qe=new g({props:{title:"detrFeatureExtractor.post_process_panoptic_segmentation() : <code> * </code>",local:"detrfeatureextractorpostprocesspanopticsegmentation--code--code",headingTag:"h3"}}),Se=new g({props:{title:"processors.Processor ⇐ <code> Callable </code>",local:"processorsprocessor--code-callable-code",headingTag:"h2"}}),st=new g({props:{title:"new Processor(feature_extractor)",local:"new-processorfeatureextractor",headingTag:"h3"}}),it=new g({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),mt=new g({props:{title:"processors.WhisperProcessor ⇐ <code> Processor </code>",local:"processorswhisperprocessor--code-processor-code",headingTag:"h2"}}),_t=new g({props:{title:"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>",local:"whisperprocessorcallaudio--code-promise--any--code",headingTag:"h3"}}),yt=new g({props:{title:"processors.AutoProcessor",local:"processorsautoprocessor",headingTag:"h2"}}),Mt=new Ti({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0I=",highlighted:'<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);',wrap:!1}}),Et=new Ti({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JyklM0IlMEFsZXQlMjBpbWFnZSUyMCUzRCUyMGF3YWl0JTIwUmF3SW1hZ2UucmVhZCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmZvb3RiYWxsLW1hdGNoLmpwZycpJTNCJTBBbGV0JTIwaW1hZ2VfaW5wdXRzJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoaW1hZ2UpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIyZGltcyUyMiUzQSUyMCU1QiUyMDElMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZsb2F0MzIlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJkYXRhJTIyJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTQ0MDg5MzE3MzIxNzc3MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMnNpemUlMjIlM0ElMjAxNTA1MjglMEElMkYlMkYlMjAlMjAlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJvcmlnaW5hbF9zaXplcyUyMiUzQSUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU1QiUyMDUzMyUyQyUyMDgwMCUyMCU1RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMnJlc2hhcGVkX2lucHV0X3NpemVzJTIyJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTVCJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTBBJTJGJTJGJTIwJTIwJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;Xenova/clip-vit-base-patch16&#x27;</span>);
<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/v3.0.0/football-match.jpg&#x27;</span>);
<span class="hljs-keyword">let</span> image_inputs = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(image);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;pixel_values&quot;: {</span>
<span class="hljs-comment">//     &quot;dims&quot;: [ 1, 3, 224, 224 ],</span>
<span class="hljs-comment">//     &quot;type&quot;: &quot;float32&quot;,</span>
<span class="hljs-comment">//     &quot;data&quot;: Float32Array [ -1.558687686920166, -1.558687686920166, -1.5440893173217773, ... ],</span>
<span class="hljs-comment">//     &quot;size&quot;: 150528</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   &quot;original_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 533, 800 ]</span>
<span class="hljs-comment">//   ],</span>
<span class="hljs-comment">//   &quot;reshaped_input_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 224, 224 ]</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Ht=new g({props:{title:"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),zt=new g({props:{title:"processors.data : <code> Float32Array </code>",local:"processorsdata--code-float32array-code",headingTag:"h2"}}),Ut=new g({props:{title:"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>",local:"processorscentertocornersformatarr--code-array--number--code",headingTag:"h2"}}),Nt=new g({props:{title:"processors~post_process_semantic_segmentation(outputs, [target_sizes]) ⇒ <code> * </code>",local:"processorspostprocesssemanticsegmentationoutputs-targetsizes--code--code",headingTag:"h2"}}),Xt=new g({props:{title:"post_process_semantic_segmentation~labels : <code> Array. < number > </code>",local:"postprocesssemanticsegmentationlabels--code-array--number--code",headingTag:"h3"}}),St=new g({props:{title:"processors~post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>",local:"processorspostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code",headingTag:"h2"}}),sr=new g({props:{title:"processors~post_process_instance_segmentation(outputs, [threshold], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>",local:"processorspostprocessinstancesegmentationoutputs-threshold-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code",headingTag:"h2"}}),dr=new g({props:{title:"processors~enforce_size_divisibility(size, divisor) ⇒ <code> * </code>",local:"processorsenforcesizedivisibilitysize-divisor--code--code",headingTag:"h2"}}),ur=new g({props:{title:"processors~HeightWidth : <code> * </code>",local:"processorsheightwidth--code--code",headingTag:"h2"}}),gr=new g({props:{title:"processors~ImageFeatureExtractorResult : <code> object </code>",local:"processorsimagefeatureextractorresult--code-object-code",headingTag:"h2"}}),yr=new g({props:{title:"processors~PreprocessedImage : <code> object </code>",local:"processorspreprocessedimage--code-object-code",headingTag:"h2"}}),wr=new g({props:{title:"processors~DetrFeatureExtractorResult : <code> object </code>",local:"processorsdetrfeatureextractorresult--code-object-code",headingTag:"h2"}}),Hr=new g({props:{title:"processors~SamImageProcessorResult : <code> object </code>",local:"processorssamimageprocessorresult--code-object-code",headingTag:"h2"}}),Lr=new xc({props:{source:"https://github.com/huggingface/transformers.js/blob/v3.0.0/docs/source/api/processors.md"}}),{c(){x=a("meta"),zr=o(),Fr=a("p"),Ar=o(),T=a("a"),Rr=o(),p(b.$$.fragment),Ur=o(),y=a("p"),y.textContent=yi,Dr=o(),$=a("p"),$.innerHTML=$i,kr=o(),p(v.$$.fragment),Br=o(),M=a("ul"),M.innerHTML=vi,Wr=o(),Nr=a("hr"),Gr=o(),w=a("a"),Yr=o(),p(E.$$.fragment),Zr=o(),C=a("p"),C.textContent=Mi,Qr=o(),P=a("p"),P.innerHTML=wi,Xr=o(),H=a("ul"),H.innerHTML=Ei,qr=o(),Vr=a("hr"),Kr=o(),J=a("a"),Sr=o(),p(I.$$.fragment),Or=o(),L=a("p"),L.textContent=Ci,es=o(),F=a("table"),F.innerHTML=Pi,ts=o(),rs=a("hr"),ss=o(),j=a("a"),os=o(),p(z.$$.fragment),ls=o(),A=a("p"),A.textContent=Hi,as=o(),R=a("p"),R.innerHTML=Ji,is=o(),U=a("ul"),U.innerHTML=Ii,ds=o(),D=a("table"),D.innerHTML=Li,cs=o(),ps=a("hr"),ns=o(),k=a("a"),ms=o(),p(B.$$.fragment),us=o(),W=a("p"),W.textContent=Fi,fs=o(),N=a("p"),N.innerHTML=ji,hs=o(),G=a("ul"),G.innerHTML=zi,_s=o(),gs=a("hr"),xs=o(),Y=a("a"),Ts=o(),p(Z.$$.fragment),bs=o(),Q=a("p"),Q.textContent=Ai,ys=o(),X=a("table"),X.innerHTML=Ri,$s=o(),vs=a("hr"),Ms=o(),q=a("a"),ws=o(),p(V.$$.fragment),Es=o(),K=a("p"),K.textContent=Ui,Cs=o(),S=a("p"),S.innerHTML=Di,Ps=o(),O=a("table"),O.innerHTML=ki,Hs=o(),Js=a("hr"),Is=o(),ee=a("a"),Ls=o(),p(te.$$.fragment),Fs=o(),re=a("p"),re.textContent=Bi,js=o(),se=a("p"),se.innerHTML=Wi,zs=o(),oe=a("table"),oe.innerHTML=Ni,As=o(),Rs=a("hr"),Us=o(),le=a("a"),Ds=o(),p(ae.$$.fragment),ks=o(),ie=a("p"),ie.textContent=Gi,Bs=o(),de=a("p"),de.innerHTML=Yi,Ws=o(),ce=a("table"),ce.innerHTML=Zi,Ns=o(),Gs=a("hr"),Ys=o(),pe=a("a"),Zs=o(),p(ne.$$.fragment),Qs=o(),me=a("p"),me.innerHTML=Qi,Xs=o(),ue=a("p"),ue.innerHTML=Xi,qs=o(),fe=a("table"),fe.innerHTML=qi,Vs=o(),Ks=a("hr"),Ss=o(),he=a("a"),Os=o(),p(_e.$$.fragment),eo=o(),ge=a("p"),ge.textContent=Vi,to=o(),xe=a("p"),xe.innerHTML=Ki,ro=o(),Te=a("table"),Te.innerHTML=Si,so=o(),oo=a("hr"),lo=o(),be=a("a"),ao=o(),p(ye.$$.fragment),io=o(),$e=a("p"),$e.textContent=Oi,co=o(),ve=a("p"),ve.innerHTML=ed,po=o(),Me=a("table"),Me.innerHTML=td,no=o(),mo=a("hr"),uo=o(),we=a("a"),fo=o(),p(Ee.$$.fragment),ho=o(),Ce=a("p"),Ce.textContent=rd,_o=o(),Pe=a("p"),Pe.innerHTML=sd,go=o(),He=a("table"),He.innerHTML=od,xo=o(),To=a("hr"),bo=o(),Je=a("a"),yo=o(),p(Ie.$$.fragment),$o=o(),Le=a("p"),Le.textContent=ld,vo=o(),Fe=a("p"),Fe.innerHTML=ad,Mo=o(),je=a("table"),je.innerHTML=id,wo=o(),Eo=a("hr"),Co=o(),ze=a("a"),Po=o(),p(Ae.$$.fragment),Ho=o(),Re=a("p"),Re.textContent=dd,Jo=o(),Ue=a("p"),Ue.innerHTML=cd,Io=o(),De=a("ul"),De.innerHTML=pd,Lo=o(),Fo=a("hr"),jo=o(),ke=a("a"),zo=o(),p(Be.$$.fragment),Ao=o(),We=a("p"),We.textContent=nd,Ro=o(),Ne=a("p"),Ne.innerHTML=md,Uo=o(),Ge=a("table"),Ge.innerHTML=ud,Do=o(),ko=a("hr"),Bo=o(),Ye=a("a"),Wo=o(),p(Ze.$$.fragment),No=o(),Qe=a("p"),Qe.innerHTML=fd,Go=o(),Yo=a("hr"),Zo=o(),Xe=a("a"),Qo=o(),p(qe.$$.fragment),Xo=o(),Ve=a("p"),Ve.innerHTML=hd,qo=o(),Vo=a("hr"),Ko=o(),Ke=a("a"),So=o(),p(Se.$$.fragment),Oo=o(),Oe=a("p"),Oe.textContent=_d,el=o(),et=a("p"),et.innerHTML=gd,tl=o(),tt=a("ul"),tt.innerHTML=xd,rl=o(),sl=a("hr"),ol=o(),rt=a("a"),ll=o(),p(st.$$.fragment),al=o(),ot=a("p"),ot.textContent=Td,il=o(),lt=a("table"),lt.innerHTML=bd,dl=o(),cl=a("hr"),pl=o(),at=a("a"),nl=o(),p(it.$$.fragment),ml=o(),dt=a("p"),dt.textContent=yd,ul=o(),ct=a("p"),ct.innerHTML=$d,fl=o(),pt=a("table"),pt.innerHTML=vd,hl=o(),_l=a("hr"),gl=o(),nt=a("a"),xl=o(),p(mt.$$.fragment),Tl=o(),ut=a("p"),ut.textContent=Md,bl=o(),ft=a("p"),ft.innerHTML=wd,yl=o(),$l=a("hr"),vl=o(),ht=a("a"),Ml=o(),p(_t.$$.fragment),wl=o(),gt=a("p"),gt.textContent=Ed,El=o(),xt=a("p"),xt.innerHTML=Cd,Cl=o(),Tt=a("table"),Tt.innerHTML=Pd,Pl=o(),Hl=a("hr"),Jl=o(),bt=a("a"),Il=o(),p(yt.$$.fragment),Ll=o(),$t=a("p"),$t.innerHTML=Hd,Fl=o(),vt=a("p"),vt.innerHTML=Jd,jl=o(),p(Mt.$$.fragment),zl=o(),wt=a("p"),wt.innerHTML=Id,Al=o(),p(Et.$$.fragment),Rl=o(),Ct=a("p"),Ct.innerHTML=Ld,Ul=o(),Dl=a("hr"),kl=o(),Pt=a("a"),Bl=o(),p(Ht.$$.fragment),Wl=o(),Jt=a("p"),Jt.textContent=Fd,Nl=o(),It=a("p"),It.innerHTML=jd,Gl=o(),Lt=a("p"),Lt.innerHTML=zd,Yl=o(),Ft=a("table"),Ft.innerHTML=Ad,Zl=o(),Ql=a("hr"),Xl=o(),jt=a("a"),ql=o(),p(zt.$$.fragment),Vl=o(),At=a("p"),At.innerHTML=Rd,Kl=o(),Sl=a("hr"),Ol=o(),Rt=a("a"),ea=o(),p(Ut.$$.fragment),ta=o(),Dt=a("p"),Dt.textContent=Ud,ra=o(),kt=a("p"),kt.innerHTML=Dd,sa=o(),Bt=a("table"),Bt.innerHTML=kd,oa=o(),la=a("hr"),aa=o(),Wt=a("a"),ia=o(),p(Nt.$$.fragment),da=o(),Gt=a("p"),Gt.textContent=Bd,ca=o(),Yt=a("p"),Yt.innerHTML=Wd,pa=o(),Zt=a("table"),Zt.innerHTML=Nd,na=o(),ma=a("hr"),ua=o(),Qt=a("a"),fa=o(),p(Xt.$$.fragment),ha=o(),qt=a("p"),qt.textContent=Gd,_a=o(),Vt=a("p"),Vt.innerHTML=Yd,ga=o(),xa=a("hr"),Ta=o(),Kt=a("a"),ba=o(),p(St.$$.fragment),ya=o(),Ot=a("p"),Ot.textContent=Zd,$a=o(),er=a("p"),er.innerHTML=Qd,va=o(),tr=a("table"),tr.innerHTML=Xd,Ma=o(),wa=a("hr"),Ea=o(),rr=a("a"),Ca=o(),p(sr.$$.fragment),Pa=o(),or=a("p"),or.textContent=qd,Ha=o(),lr=a("p"),lr.innerHTML=Vd,Ja=o(),ar=a("table"),ar.innerHTML=Kd,Ia=o(),La=a("hr"),Fa=o(),ir=a("a"),ja=o(),p(dr.$$.fragment),za=o(),cr=a("p"),cr.textContent=Sd,Aa=o(),pr=a("p"),pr.innerHTML=Od,Ra=o(),nr=a("table"),nr.innerHTML=ec,Ua=o(),Da=a("hr"),ka=o(),mr=a("a"),Ba=o(),p(ur.$$.fragment),Wa=o(),fr=a("p"),fr.textContent=tc,Na=o(),hr=a("p"),hr.innerHTML=rc,Ga=o(),Ya=a("hr"),Za=o(),_r=a("a"),Qa=o(),p(gr.$$.fragment),Xa=o(),xr=a("p"),xr.innerHTML=sc,qa=o(),Tr=a("table"),Tr.innerHTML=oc,Va=o(),Ka=a("hr"),Sa=o(),br=a("a"),Oa=o(),p(yr.$$.fragment),ei=o(),$r=a("p"),$r.innerHTML=lc,ti=o(),vr=a("table"),vr.innerHTML=ac,ri=o(),si=a("hr"),oi=o(),Mr=a("a"),li=o(),p(wr.$$.fragment),ai=o(),Er=a("p"),Er.innerHTML=ic,ii=o(),Cr=a("table"),Cr.innerHTML=dc,di=o(),ci=a("hr"),pi=o(),Pr=a("a"),ni=o(),p(Hr.$$.fragment),mi=o(),Jr=a("p"),Jr.innerHTML=cc,ui=o(),Ir=a("table"),Ir.innerHTML=pc,fi=o(),hi=a("hr"),_i=o(),p(Lr.$$.fragment),gi=o(),jr=a("p"),this.h()},l(e){const t=_c("svelte-u9bgzb",document.head);x=i(t,"META",{name:!0,content:!0}),t.forEach(r),zr=l(e),Fr=i(e,"P",{}),_(Fr).forEach(r),Ar=l(e),T=i(e,"A",{id:!0,class:!0}),_(T).forEach(r),Rr=l(e),n(b.$$.fragment,e),Ur=l(e),y=i(e,"P",{"data-svelte-h":!0}),d(y)!=="svelte-w0rx8m"&&(y.textContent=yi),Dr=l(e),$=i(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-1olsie5"&&($.innerHTML=$i),kr=l(e),n(v.$$.fragment,e),Br=l(e),M=i(e,"UL",{"data-svelte-h":!0}),d(M)!=="svelte-12cj3n8"&&(M.innerHTML=vi),Wr=l(e),Nr=i(e,"HR",{}),Gr=l(e),w=i(e,"A",{id:!0,class:!0}),_(w).forEach(r),Yr=l(e),n(E.$$.fragment,e),Zr=l(e),C=i(e,"P",{"data-svelte-h":!0}),d(C)!=="svelte-14r3pvv"&&(C.textContent=Mi),Qr=l(e),P=i(e,"P",{"data-svelte-h":!0}),d(P)!=="svelte-13iv745"&&(P.innerHTML=wi),Xr=l(e),H=i(e,"UL",{"data-svelte-h":!0}),d(H)!=="svelte-16exrlt"&&(H.innerHTML=Ei),qr=l(e),Vr=i(e,"HR",{}),Kr=l(e),J=i(e,"A",{id:!0,class:!0}),_(J).forEach(r),Sr=l(e),n(I.$$.fragment,e),Or=l(e),L=i(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-k3m2wg"&&(L.textContent=Ci),es=l(e),F=i(e,"TABLE",{"data-svelte-h":!0}),d(F)!=="svelte-rd7ds7"&&(F.innerHTML=Pi),ts=l(e),rs=i(e,"HR",{}),ss=l(e),j=i(e,"A",{id:!0,class:!0}),_(j).forEach(r),os=l(e),n(z.$$.fragment,e),ls=l(e),A=i(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-8c74gj"&&(A.textContent=Hi),as=l(e),R=i(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-syym47"&&(R.innerHTML=Ji),is=l(e),U=i(e,"UL",{"data-svelte-h":!0}),d(U)!=="svelte-7c1v8c"&&(U.innerHTML=Ii),ds=l(e),D=i(e,"TABLE",{"data-svelte-h":!0}),d(D)!=="svelte-1v34kj"&&(D.innerHTML=Li),cs=l(e),ps=i(e,"HR",{}),ns=l(e),k=i(e,"A",{id:!0,class:!0}),_(k).forEach(r),ms=l(e),n(B.$$.fragment,e),us=l(e),W=i(e,"P",{"data-svelte-h":!0}),d(W)!=="svelte-8k8cys"&&(W.textContent=Fi),fs=l(e),N=i(e,"P",{"data-svelte-h":!0}),d(N)!=="svelte-18p52n5"&&(N.innerHTML=ji),hs=l(e),G=i(e,"UL",{"data-svelte-h":!0}),d(G)!=="svelte-1ne2ywl"&&(G.innerHTML=zi),_s=l(e),gs=i(e,"HR",{}),xs=l(e),Y=i(e,"A",{id:!0,class:!0}),_(Y).forEach(r),Ts=l(e),n(Z.$$.fragment,e),bs=l(e),Q=i(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1mp2vol"&&(Q.textContent=Ai),ys=l(e),X=i(e,"TABLE",{"data-svelte-h":!0}),d(X)!=="svelte-1131cyk"&&(X.innerHTML=Ri),$s=l(e),vs=i(e,"HR",{}),Ms=l(e),q=i(e,"A",{id:!0,class:!0}),_(q).forEach(r),ws=l(e),n(V.$$.fragment,e),Es=l(e),K=i(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1q6eyx4"&&(K.textContent=Ui),Cs=l(e),S=i(e,"P",{"data-svelte-h":!0}),d(S)!=="svelte-ar7q77"&&(S.innerHTML=Di),Ps=l(e),O=i(e,"TABLE",{"data-svelte-h":!0}),d(O)!=="svelte-klyf4z"&&(O.innerHTML=ki),Hs=l(e),Js=i(e,"HR",{}),Is=l(e),ee=i(e,"A",{id:!0,class:!0}),_(ee).forEach(r),Ls=l(e),n(te.$$.fragment,e),Fs=l(e),re=i(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-7fx89a"&&(re.textContent=Bi),js=l(e),se=i(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-65os4c"&&(se.innerHTML=Wi),zs=l(e),oe=i(e,"TABLE",{"data-svelte-h":!0}),d(oe)!=="svelte-1dnvwno"&&(oe.innerHTML=Ni),As=l(e),Rs=i(e,"HR",{}),Us=l(e),le=i(e,"A",{id:!0,class:!0}),_(le).forEach(r),Ds=l(e),n(ae.$$.fragment,e),ks=l(e),ie=i(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1mmkb9p"&&(ie.textContent=Gi),Bs=l(e),de=i(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-110o3sn"&&(de.innerHTML=Yi),Ws=l(e),ce=i(e,"TABLE",{"data-svelte-h":!0}),d(ce)!=="svelte-mhh1xm"&&(ce.innerHTML=Zi),Ns=l(e),Gs=i(e,"HR",{}),Ys=l(e),pe=i(e,"A",{id:!0,class:!0}),_(pe).forEach(r),Zs=l(e),n(ne.$$.fragment,e),Qs=l(e),me=i(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-pyd72v"&&(me.innerHTML=Qi),Xs=l(e),ue=i(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-1isxmg1"&&(ue.innerHTML=Xi),qs=l(e),fe=i(e,"TABLE",{"data-svelte-h":!0}),d(fe)!=="svelte-1e1ka8e"&&(fe.innerHTML=qi),Vs=l(e),Ks=i(e,"HR",{}),Ss=l(e),he=i(e,"A",{id:!0,class:!0}),_(he).forEach(r),Os=l(e),n(_e.$$.fragment,e),eo=l(e),ge=i(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-8leww2"&&(ge.textContent=Vi),to=l(e),xe=i(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-eqxqo6"&&(xe.innerHTML=Ki),ro=l(e),Te=i(e,"TABLE",{"data-svelte-h":!0}),d(Te)!=="svelte-1n361ub"&&(Te.innerHTML=Si),so=l(e),oo=i(e,"HR",{}),lo=l(e),be=i(e,"A",{id:!0,class:!0}),_(be).forEach(r),ao=l(e),n(ye.$$.fragment,e),io=l(e),$e=i(e,"P",{"data-svelte-h":!0}),d($e)!=="svelte-5iny39"&&($e.textContent=Oi),co=l(e),ve=i(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-ar7q77"&&(ve.innerHTML=ed),po=l(e),Me=i(e,"TABLE",{"data-svelte-h":!0}),d(Me)!=="svelte-d8vk38"&&(Me.innerHTML=td),no=l(e),mo=i(e,"HR",{}),uo=l(e),we=i(e,"A",{id:!0,class:!0}),_(we).forEach(r),fo=l(e),n(Ee.$$.fragment,e),ho=l(e),Ce=i(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-10g8wi9"&&(Ce.textContent=rd),_o=l(e),Pe=i(e,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-cd20o3"&&(Pe.innerHTML=sd),go=l(e),He=i(e,"TABLE",{"data-svelte-h":!0}),d(He)!=="svelte-1773mps"&&(He.innerHTML=od),xo=l(e),To=i(e,"HR",{}),bo=l(e),Je=i(e,"A",{id:!0,class:!0}),_(Je).forEach(r),yo=l(e),n(Ie.$$.fragment,e),$o=l(e),Le=i(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-1uytqp8"&&(Le.textContent=ld),vo=l(e),Fe=i(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1pa0uk8"&&(Fe.innerHTML=ad),Mo=l(e),je=i(e,"TABLE",{"data-svelte-h":!0}),d(je)!=="svelte-hch5rz"&&(je.innerHTML=id),wo=l(e),Eo=i(e,"HR",{}),Co=l(e),ze=i(e,"A",{id:!0,class:!0}),_(ze).forEach(r),Po=l(e),n(Ae.$$.fragment,e),Ho=l(e),Re=i(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-y1gxwn"&&(Re.textContent=dd),Jo=l(e),Ue=i(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1xz91ac"&&(Ue.innerHTML=cd),Io=l(e),De=i(e,"UL",{"data-svelte-h":!0}),d(De)!=="svelte-n6at9h"&&(De.innerHTML=pd),Lo=l(e),Fo=i(e,"HR",{}),jo=l(e),ke=i(e,"A",{id:!0,class:!0}),_(ke).forEach(r),zo=l(e),n(Be.$$.fragment,e),Ao=l(e),We=i(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1ec3vsm"&&(We.textContent=nd),Ro=l(e),Ne=i(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-6tjpr7"&&(Ne.innerHTML=md),Uo=l(e),Ge=i(e,"TABLE",{"data-svelte-h":!0}),d(Ge)!=="svelte-1px7bnv"&&(Ge.innerHTML=ud),Do=l(e),ko=i(e,"HR",{}),Bo=l(e),Ye=i(e,"A",{id:!0,class:!0}),_(Ye).forEach(r),Wo=l(e),n(Ze.$$.fragment,e),No=l(e),Qe=i(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-j2v54d"&&(Qe.innerHTML=fd),Go=l(e),Yo=i(e,"HR",{}),Zo=l(e),Xe=i(e,"A",{id:!0,class:!0}),_(Xe).forEach(r),Qo=l(e),n(qe.$$.fragment,e),Xo=l(e),Ve=i(e,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-j2v54d"&&(Ve.innerHTML=hd),qo=l(e),Vo=i(e,"HR",{}),Ko=l(e),Ke=i(e,"A",{id:!0,class:!0}),_(Ke).forEach(r),So=l(e),n(Se.$$.fragment,e),Oo=l(e),Oe=i(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-o9f953"&&(Oe.textContent=_d),el=l(e),et=i(e,"P",{"data-svelte-h":!0}),d(et)!=="svelte-13iv745"&&(et.innerHTML=gd),tl=l(e),tt=i(e,"UL",{"data-svelte-h":!0}),d(tt)!=="svelte-ceq7pc"&&(tt.innerHTML=xd),rl=l(e),sl=i(e,"HR",{}),ol=l(e),rt=i(e,"A",{id:!0,class:!0}),_(rt).forEach(r),ll=l(e),n(st.$$.fragment,e),al=l(e),ot=i(e,"P",{"data-svelte-h":!0}),d(ot)!=="svelte-1naom0u"&&(ot.textContent=Td),il=l(e),lt=i(e,"TABLE",{"data-svelte-h":!0}),d(lt)!=="svelte-ilxs6c"&&(lt.innerHTML=bd),dl=l(e),cl=i(e,"HR",{}),pl=l(e),at=i(e,"A",{id:!0,class:!0}),_(at).forEach(r),nl=l(e),n(it.$$.fragment,e),ml=l(e),dt=i(e,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-zbbm3j"&&(dt.textContent=yd),ul=l(e),ct=i(e,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-1hik6yq"&&(ct.innerHTML=$d),fl=l(e),pt=i(e,"TABLE",{"data-svelte-h":!0}),d(pt)!=="svelte-pm1u9z"&&(pt.innerHTML=vd),hl=l(e),_l=i(e,"HR",{}),gl=l(e),nt=i(e,"A",{id:!0,class:!0}),_(nt).forEach(r),xl=l(e),n(mt.$$.fragment,e),Tl=l(e),ut=i(e,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-17pib55"&&(ut.textContent=Md),bl=l(e),ft=i(e,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1ljhyyr"&&(ft.innerHTML=wd),yl=l(e),$l=i(e,"HR",{}),vl=l(e),ht=i(e,"A",{id:!0,class:!0}),_(ht).forEach(r),Ml=l(e),n(_t.$$.fragment,e),wl=l(e),gt=i(e,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-r5x3fh"&&(gt.textContent=Ed),El=l(e),xt=i(e,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-1vpvonk"&&(xt.innerHTML=Cd),Cl=l(e),Tt=i(e,"TABLE",{"data-svelte-h":!0}),d(Tt)!=="svelte-nv3lon"&&(Tt.innerHTML=Pd),Pl=l(e),Hl=i(e,"HR",{}),Jl=l(e),bt=i(e,"A",{id:!0,class:!0}),_(bt).forEach(r),Il=l(e),n(yt.$$.fragment,e),Ll=l(e),$t=i(e,"P",{"data-svelte-h":!0}),d($t)!=="svelte-62dsf9"&&($t.innerHTML=Hd),Fl=l(e),vt=i(e,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-11vd43e"&&(vt.innerHTML=Jd),jl=l(e),n(Mt.$$.fragment,e),zl=l(e),wt=i(e,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-c0cgha"&&(wt.innerHTML=Id),Al=l(e),n(Et.$$.fragment,e),Rl=l(e),Ct=i(e,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-wmyz1o"&&(Ct.innerHTML=Ld),Ul=l(e),Dl=i(e,"HR",{}),kl=l(e),Pt=i(e,"A",{id:!0,class:!0}),_(Pt).forEach(r),Bl=l(e),n(Ht.$$.fragment,e),Wl=l(e),Jt=i(e,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-jwfdp9"&&(Jt.textContent=Fd),Nl=l(e),It=i(e,"P",{"data-svelte-h":!0}),d(It)!=="svelte-t85gxq"&&(It.innerHTML=jd),Gl=l(e),Lt=i(e,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-y7m8db"&&(Lt.innerHTML=zd),Yl=l(e),Ft=i(e,"TABLE",{"data-svelte-h":!0}),d(Ft)!=="svelte-1oj79mt"&&(Ft.innerHTML=Ad),Zl=l(e),Ql=i(e,"HR",{}),Xl=l(e),jt=i(e,"A",{id:!0,class:!0}),_(jt).forEach(r),ql=l(e),n(zt.$$.fragment,e),Vl=l(e),At=i(e,"P",{"data-svelte-h":!0}),d(At)!=="svelte-1kf99mp"&&(At.innerHTML=Rd),Kl=l(e),Sl=i(e,"HR",{}),Ol=l(e),Rt=i(e,"A",{id:!0,class:!0}),_(Rt).forEach(r),ea=l(e),n(Ut.$$.fragment,e),ta=l(e),Dt=i(e,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-kjzox5"&&(Dt.textContent=Ud),ra=l(e),kt=i(e,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-19qboln"&&(kt.innerHTML=Dd),sa=l(e),Bt=i(e,"TABLE",{"data-svelte-h":!0}),d(Bt)!=="svelte-1bv5sxq"&&(Bt.innerHTML=kd),oa=l(e),la=i(e,"HR",{}),aa=l(e),Wt=i(e,"A",{id:!0,class:!0}),_(Wt).forEach(r),ia=l(e),n(Nt.$$.fragment,e),da=l(e),Gt=i(e,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-nfvzgk"&&(Gt.textContent=Bd),ca=l(e),Yt=i(e,"P",{"data-svelte-h":!0}),d(Yt)!=="svelte-7nbrw3"&&(Yt.innerHTML=Wd),pa=l(e),Zt=i(e,"TABLE",{"data-svelte-h":!0}),d(Zt)!=="svelte-1tuc1gw"&&(Zt.innerHTML=Nd),na=l(e),ma=i(e,"HR",{}),ua=l(e),Qt=i(e,"A",{id:!0,class:!0}),_(Qt).forEach(r),fa=l(e),n(Xt.$$.fragment,e),ha=l(e),qt=i(e,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-u6jyju"&&(qt.textContent=Gd),_a=l(e),Vt=i(e,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-19j3owj"&&(Vt.innerHTML=Yd),ga=l(e),xa=i(e,"HR",{}),Ta=l(e),Kt=i(e,"A",{id:!0,class:!0}),_(Kt).forEach(r),ba=l(e),n(St.$$.fragment,e),ya=l(e),Ot=i(e,"P",{"data-svelte-h":!0}),d(Ot)!=="svelte-frdp8m"&&(Ot.textContent=Zd),$a=l(e),er=i(e,"P",{"data-svelte-h":!0}),d(er)!=="svelte-1rhvjmz"&&(er.innerHTML=Qd),va=l(e),tr=i(e,"TABLE",{"data-svelte-h":!0}),d(tr)!=="svelte-1xbqjg5"&&(tr.innerHTML=Xd),Ma=l(e),wa=i(e,"HR",{}),Ea=l(e),rr=i(e,"A",{id:!0,class:!0}),_(rr).forEach(r),Ca=l(e),n(sr.$$.fragment,e),Pa=l(e),or=i(e,"P",{"data-svelte-h":!0}),d(or)!=="svelte-70uwcf"&&(or.textContent=qd),Ha=l(e),lr=i(e,"P",{"data-svelte-h":!0}),d(lr)!=="svelte-1rhvjmz"&&(lr.innerHTML=Vd),Ja=l(e),ar=i(e,"TABLE",{"data-svelte-h":!0}),d(ar)!=="svelte-12ra2bi"&&(ar.innerHTML=Kd),Ia=l(e),La=i(e,"HR",{}),Fa=l(e),ir=i(e,"A",{id:!0,class:!0}),_(ir).forEach(r),ja=l(e),n(dr.$$.fragment,e),za=l(e),cr=i(e,"P",{"data-svelte-h":!0}),d(cr)!=="svelte-vlkbp"&&(cr.textContent=Sd),Aa=l(e),pr=i(e,"P",{"data-svelte-h":!0}),d(pr)!=="svelte-vmdbik"&&(pr.innerHTML=Od),Ra=l(e),nr=i(e,"TABLE",{"data-svelte-h":!0}),d(nr)!=="svelte-4ldb45"&&(nr.innerHTML=ec),Ua=l(e),Da=i(e,"HR",{}),ka=l(e),mr=i(e,"A",{id:!0,class:!0}),_(mr).forEach(r),Ba=l(e),n(ur.$$.fragment,e),Wa=l(e),fr=i(e,"P",{"data-svelte-h":!0}),d(fr)!=="svelte-2u8xbp"&&(fr.textContent=tc),Na=l(e),hr=i(e,"P",{"data-svelte-h":!0}),d(hr)!=="svelte-3xndnt"&&(hr.innerHTML=rc),Ga=l(e),Ya=i(e,"HR",{}),Za=l(e),_r=i(e,"A",{id:!0,class:!0}),_(_r).forEach(r),Qa=l(e),n(gr.$$.fragment,e),Xa=l(e),xr=i(e,"P",{"data-svelte-h":!0}),d(xr)!=="svelte-cy5pwv"&&(xr.innerHTML=sc),qa=l(e),Tr=i(e,"TABLE",{"data-svelte-h":!0}),d(Tr)!=="svelte-1dyar84"&&(Tr.innerHTML=oc),Va=l(e),Ka=i(e,"HR",{}),Sa=l(e),br=i(e,"A",{id:!0,class:!0}),_(br).forEach(r),Oa=l(e),n(yr.$$.fragment,e),ei=l(e),$r=i(e,"P",{"data-svelte-h":!0}),d($r)!=="svelte-cy5pwv"&&($r.innerHTML=lc),ti=l(e),vr=i(e,"TABLE",{"data-svelte-h":!0}),d(vr)!=="svelte-1cnys15"&&(vr.innerHTML=ac),ri=l(e),si=i(e,"HR",{}),oi=l(e),Mr=i(e,"A",{id:!0,class:!0}),_(Mr).forEach(r),li=l(e),n(wr.$$.fragment,e),ai=l(e),Er=i(e,"P",{"data-svelte-h":!0}),d(Er)!=="svelte-cy5pwv"&&(Er.innerHTML=ic),ii=l(e),Cr=i(e,"TABLE",{"data-svelte-h":!0}),d(Cr)!=="svelte-179cln2"&&(Cr.innerHTML=dc),di=l(e),ci=i(e,"HR",{}),pi=l(e),Pr=i(e,"A",{id:!0,class:!0}),_(Pr).forEach(r),ni=l(e),n(Hr.$$.fragment,e),mi=l(e),Jr=i(e,"P",{"data-svelte-h":!0}),d(Jr)!=="svelte-cy5pwv"&&(Jr.innerHTML=cc),ui=l(e),Ir=i(e,"TABLE",{"data-svelte-h":!0}),d(Ir)!=="svelte-1nrm9i3"&&(Ir.innerHTML=pc),fi=l(e),hi=i(e,"HR",{}),_i=l(e),n(Lr.$$.fragment,e),gi=l(e),jr=i(e,"P",{}),_(jr).forEach(r),this.h()},h(){c(x,"name","hf:doc:metadata"),c(x,"content",bc),c(T,"id","module_processors"),c(T,"class","group"),c(w,"id","module_processors.FeatureExtractor"),c(w,"class","group"),c(J,"id","new_module_processors.FeatureExtractor_new"),c(J,"class","group"),c(j,"id","Callable+_call"),c(j,"class","group"),c(k,"id","module_processors.ImageFeatureExtractor"),c(k,"class","group"),c(Y,"id","new_module_processors.ImageFeatureExtractor_new"),c(Y,"class","group"),c(q,"id","module_processors.ImageFeatureExtractor+thumbnail"),c(q,"class","group"),c(ee,"id","module_processors.ImageFeatureExtractor+crop_margin"),c(ee,"class","group"),c(le,"id","module_processors.ImageFeatureExtractor+pad_image"),c(le,"class","group"),c(pe,"id","module_processors.ImageFeatureExtractor+rescale"),c(pe,"class","group"),c(he,"id","module_processors.ImageFeatureExtractor+get_resize_output_image_size"),c(he,"class","group"),c(be,"id","module_processors.ImageFeatureExtractor+resize"),c(be,"class","group"),c(we,"id","module_processors.ImageFeatureExtractor+preprocess"),c(we,"class","group"),c(Je,"id","module_processors.ImageFeatureExtractor+_call"),c(Je,"class","group"),c(ze,"id","module_processors.DetrFeatureExtractor"),c(ze,"class","group"),c(ke,"id","module_processors.DetrFeatureExtractor+_call"),c(ke,"class","group"),c(Ye,"id","module_processors.DetrFeatureExtractor+post_process_object_detection"),c(Ye,"class","group"),c(Xe,"id","module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"),c(Xe,"class","group"),c(Ke,"id","module_processors.Processor"),c(Ke,"class","group"),c(rt,"id","new_module_processors.Processor_new"),c(rt,"class","group"),c(at,"id","module_processors.Processor+_call"),c(at,"class","group"),c(nt,"id","module_processors.WhisperProcessor"),c(nt,"class","group"),c(ht,"id","module_processors.WhisperProcessor+_call"),c(ht,"class","group"),c(bt,"id","module_processors.AutoProcessor"),c(bt,"class","group"),c(Pt,"id","module_processors.AutoProcessor.from_pretrained"),c(Pt,"class","group"),c(jt,"id","module_processors.data"),c(jt,"class","group"),c(Rt,"id","module_processors..center_to_corners_format"),c(Rt,"class","group"),c(Wt,"id","module_processors..post_process_semantic_segmentation"),c(Wt,"class","group"),c(Qt,"id","module_processors..post_process_semantic_segmentation..labels"),c(Qt,"class","group"),c(Kt,"id","module_processors..post_process_panoptic_segmentation"),c(Kt,"class","group"),c(rr,"id","module_processors..post_process_instance_segmentation"),c(rr,"class","group"),c(ir,"id","module_processors..enforce_size_divisibility"),c(ir,"class","group"),c(mr,"id","module_processors..HeightWidth"),c(mr,"class","group"),c(_r,"id","module_processors..ImageFeatureExtractorResult"),c(_r,"class","group"),c(br,"id","module_processors..PreprocessedImage"),c(br,"class","group"),c(Mr,"id","module_processors..DetrFeatureExtractorResult"),c(Mr,"class","group"),c(Pr,"id","module_processors..SamImageProcessorResult"),c(Pr,"class","group")},m(e,t){gc(document.head,x),s(e,zr,t),s(e,Fr,t),s(e,Ar,t),s(e,T,t),s(e,Rr,t),m(b,e,t),s(e,Ur,t),s(e,y,t),s(e,Dr,t),s(e,$,t),s(e,kr,t),m(v,e,t),s(e,Br,t),s(e,M,t),s(e,Wr,t),s(e,Nr,t),s(e,Gr,t),s(e,w,t),s(e,Yr,t),m(E,e,t),s(e,Zr,t),s(e,C,t),s(e,Qr,t),s(e,P,t),s(e,Xr,t),s(e,H,t),s(e,qr,t),s(e,Vr,t),s(e,Kr,t),s(e,J,t),s(e,Sr,t),m(I,e,t),s(e,Or,t),s(e,L,t),s(e,es,t),s(e,F,t),s(e,ts,t),s(e,rs,t),s(e,ss,t),s(e,j,t),s(e,os,t),m(z,e,t),s(e,ls,t),s(e,A,t),s(e,as,t),s(e,R,t),s(e,is,t),s(e,U,t),s(e,ds,t),s(e,D,t),s(e,cs,t),s(e,ps,t),s(e,ns,t),s(e,k,t),s(e,ms,t),m(B,e,t),s(e,us,t),s(e,W,t),s(e,fs,t),s(e,N,t),s(e,hs,t),s(e,G,t),s(e,_s,t),s(e,gs,t),s(e,xs,t),s(e,Y,t),s(e,Ts,t),m(Z,e,t),s(e,bs,t),s(e,Q,t),s(e,ys,t),s(e,X,t),s(e,$s,t),s(e,vs,t),s(e,Ms,t),s(e,q,t),s(e,ws,t),m(V,e,t),s(e,Es,t),s(e,K,t),s(e,Cs,t),s(e,S,t),s(e,Ps,t),s(e,O,t),s(e,Hs,t),s(e,Js,t),s(e,Is,t),s(e,ee,t),s(e,Ls,t),m(te,e,t),s(e,Fs,t),s(e,re,t),s(e,js,t),s(e,se,t),s(e,zs,t),s(e,oe,t),s(e,As,t),s(e,Rs,t),s(e,Us,t),s(e,le,t),s(e,Ds,t),m(ae,e,t),s(e,ks,t),s(e,ie,t),s(e,Bs,t),s(e,de,t),s(e,Ws,t),s(e,ce,t),s(e,Ns,t),s(e,Gs,t),s(e,Ys,t),s(e,pe,t),s(e,Zs,t),m(ne,e,t),s(e,Qs,t),s(e,me,t),s(e,Xs,t),s(e,ue,t),s(e,qs,t),s(e,fe,t),s(e,Vs,t),s(e,Ks,t),s(e,Ss,t),s(e,he,t),s(e,Os,t),m(_e,e,t),s(e,eo,t),s(e,ge,t),s(e,to,t),s(e,xe,t),s(e,ro,t),s(e,Te,t),s(e,so,t),s(e,oo,t),s(e,lo,t),s(e,be,t),s(e,ao,t),m(ye,e,t),s(e,io,t),s(e,$e,t),s(e,co,t),s(e,ve,t),s(e,po,t),s(e,Me,t),s(e,no,t),s(e,mo,t),s(e,uo,t),s(e,we,t),s(e,fo,t),m(Ee,e,t),s(e,ho,t),s(e,Ce,t),s(e,_o,t),s(e,Pe,t),s(e,go,t),s(e,He,t),s(e,xo,t),s(e,To,t),s(e,bo,t),s(e,Je,t),s(e,yo,t),m(Ie,e,t),s(e,$o,t),s(e,Le,t),s(e,vo,t),s(e,Fe,t),s(e,Mo,t),s(e,je,t),s(e,wo,t),s(e,Eo,t),s(e,Co,t),s(e,ze,t),s(e,Po,t),m(Ae,e,t),s(e,Ho,t),s(e,Re,t),s(e,Jo,t),s(e,Ue,t),s(e,Io,t),s(e,De,t),s(e,Lo,t),s(e,Fo,t),s(e,jo,t),s(e,ke,t),s(e,zo,t),m(Be,e,t),s(e,Ao,t),s(e,We,t),s(e,Ro,t),s(e,Ne,t),s(e,Uo,t),s(e,Ge,t),s(e,Do,t),s(e,ko,t),s(e,Bo,t),s(e,Ye,t),s(e,Wo,t),m(Ze,e,t),s(e,No,t),s(e,Qe,t),s(e,Go,t),s(e,Yo,t),s(e,Zo,t),s(e,Xe,t),s(e,Qo,t),m(qe,e,t),s(e,Xo,t),s(e,Ve,t),s(e,qo,t),s(e,Vo,t),s(e,Ko,t),s(e,Ke,t),s(e,So,t),m(Se,e,t),s(e,Oo,t),s(e,Oe,t),s(e,el,t),s(e,et,t),s(e,tl,t),s(e,tt,t),s(e,rl,t),s(e,sl,t),s(e,ol,t),s(e,rt,t),s(e,ll,t),m(st,e,t),s(e,al,t),s(e,ot,t),s(e,il,t),s(e,lt,t),s(e,dl,t),s(e,cl,t),s(e,pl,t),s(e,at,t),s(e,nl,t),m(it,e,t),s(e,ml,t),s(e,dt,t),s(e,ul,t),s(e,ct,t),s(e,fl,t),s(e,pt,t),s(e,hl,t),s(e,_l,t),s(e,gl,t),s(e,nt,t),s(e,xl,t),m(mt,e,t),s(e,Tl,t),s(e,ut,t),s(e,bl,t),s(e,ft,t),s(e,yl,t),s(e,$l,t),s(e,vl,t),s(e,ht,t),s(e,Ml,t),m(_t,e,t),s(e,wl,t),s(e,gt,t),s(e,El,t),s(e,xt,t),s(e,Cl,t),s(e,Tt,t),s(e,Pl,t),s(e,Hl,t),s(e,Jl,t),s(e,bt,t),s(e,Il,t),m(yt,e,t),s(e,Ll,t),s(e,$t,t),s(e,Fl,t),s(e,vt,t),s(e,jl,t),m(Mt,e,t),s(e,zl,t),s(e,wt,t),s(e,Al,t),m(Et,e,t),s(e,Rl,t),s(e,Ct,t),s(e,Ul,t),s(e,Dl,t),s(e,kl,t),s(e,Pt,t),s(e,Bl,t),m(Ht,e,t),s(e,Wl,t),s(e,Jt,t),s(e,Nl,t),s(e,It,t),s(e,Gl,t),s(e,Lt,t),s(e,Yl,t),s(e,Ft,t),s(e,Zl,t),s(e,Ql,t),s(e,Xl,t),s(e,jt,t),s(e,ql,t),m(zt,e,t),s(e,Vl,t),s(e,At,t),s(e,Kl,t),s(e,Sl,t),s(e,Ol,t),s(e,Rt,t),s(e,ea,t),m(Ut,e,t),s(e,ta,t),s(e,Dt,t),s(e,ra,t),s(e,kt,t),s(e,sa,t),s(e,Bt,t),s(e,oa,t),s(e,la,t),s(e,aa,t),s(e,Wt,t),s(e,ia,t),m(Nt,e,t),s(e,da,t),s(e,Gt,t),s(e,ca,t),s(e,Yt,t),s(e,pa,t),s(e,Zt,t),s(e,na,t),s(e,ma,t),s(e,ua,t),s(e,Qt,t),s(e,fa,t),m(Xt,e,t),s(e,ha,t),s(e,qt,t),s(e,_a,t),s(e,Vt,t),s(e,ga,t),s(e,xa,t),s(e,Ta,t),s(e,Kt,t),s(e,ba,t),m(St,e,t),s(e,ya,t),s(e,Ot,t),s(e,$a,t),s(e,er,t),s(e,va,t),s(e,tr,t),s(e,Ma,t),s(e,wa,t),s(e,Ea,t),s(e,rr,t),s(e,Ca,t),m(sr,e,t),s(e,Pa,t),s(e,or,t),s(e,Ha,t),s(e,lr,t),s(e,Ja,t),s(e,ar,t),s(e,Ia,t),s(e,La,t),s(e,Fa,t),s(e,ir,t),s(e,ja,t),m(dr,e,t),s(e,za,t),s(e,cr,t),s(e,Aa,t),s(e,pr,t),s(e,Ra,t),s(e,nr,t),s(e,Ua,t),s(e,Da,t),s(e,ka,t),s(e,mr,t),s(e,Ba,t),m(ur,e,t),s(e,Wa,t),s(e,fr,t),s(e,Na,t),s(e,hr,t),s(e,Ga,t),s(e,Ya,t),s(e,Za,t),s(e,_r,t),s(e,Qa,t),m(gr,e,t),s(e,Xa,t),s(e,xr,t),s(e,qa,t),s(e,Tr,t),s(e,Va,t),s(e,Ka,t),s(e,Sa,t),s(e,br,t),s(e,Oa,t),m(yr,e,t),s(e,ei,t),s(e,$r,t),s(e,ti,t),s(e,vr,t),s(e,ri,t),s(e,si,t),s(e,oi,t),s(e,Mr,t),s(e,li,t),m(wr,e,t),s(e,ai,t),s(e,Er,t),s(e,ii,t),s(e,Cr,t),s(e,di,t),s(e,ci,t),s(e,pi,t),s(e,Pr,t),s(e,ni,t),m(Hr,e,t),s(e,mi,t),s(e,Jr,t),s(e,ui,t),s(e,Ir,t),s(e,fi,t),s(e,hi,t),s(e,_i,t),m(Lr,e,t),s(e,gi,t),s(e,jr,t),xi=!0},p:mc,i(e){xi||(u(b.$$.fragment,e),u(v.$$.fragment,e),u(E.$$.fragment,e),u(I.$$.fragment,e),u(z.$$.fragment,e),u(B.$$.fragment,e),u(Z.$$.fragment,e),u(V.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ne.$$.fragment,e),u(_e.$$.fragment,e),u(ye.$$.fragment,e),u(Ee.$$.fragment,e),u(Ie.$$.fragment,e),u(Ae.$$.fragment,e),u(Be.$$.fragment,e),u(Ze.$$.fragment,e),u(qe.$$.fragment,e),u(Se.$$.fragment,e),u(st.$$.fragment,e),u(it.$$.fragment,e),u(mt.$$.fragment,e),u(_t.$$.fragment,e),u(yt.$$.fragment,e),u(Mt.$$.fragment,e),u(Et.$$.fragment,e),u(Ht.$$.fragment,e),u(zt.$$.fragment,e),u(Ut.$$.fragment,e),u(Nt.$$.fragment,e),u(Xt.$$.fragment,e),u(St.$$.fragment,e),u(sr.$$.fragment,e),u(dr.$$.fragment,e),u(ur.$$.fragment,e),u(gr.$$.fragment,e),u(yr.$$.fragment,e),u(wr.$$.fragment,e),u(Hr.$$.fragment,e),u(Lr.$$.fragment,e),xi=!0)},o(e){f(b.$$.fragment,e),f(v.$$.fragment,e),f(E.$$.fragment,e),f(I.$$.fragment,e),f(z.$$.fragment,e),f(B.$$.fragment,e),f(Z.$$.fragment,e),f(V.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(ne.$$.fragment,e),f(_e.$$.fragment,e),f(ye.$$.fragment,e),f(Ee.$$.fragment,e),f(Ie.$$.fragment,e),f(Ae.$$.fragment,e),f(Be.$$.fragment,e),f(Ze.$$.fragment,e),f(qe.$$.fragment,e),f(Se.$$.fragment,e),f(st.$$.fragment,e),f(it.$$.fragment,e),f(mt.$$.fragment,e),f(_t.$$.fragment,e),f(yt.$$.fragment,e),f(Mt.$$.fragment,e),f(Et.$$.fragment,e),f(Ht.$$.fragment,e),f(zt.$$.fragment,e),f(Ut.$$.fragment,e),f(Nt.$$.fragment,e),f(Xt.$$.fragment,e),f(St.$$.fragment,e),f(sr.$$.fragment,e),f(dr.$$.fragment,e),f(ur.$$.fragment,e),f(gr.$$.fragment,e),f(yr.$$.fragment,e),f(wr.$$.fragment,e),f(Hr.$$.fragment,e),f(Lr.$$.fragment,e),xi=!1},d(e){e&&(r(zr),r(Fr),r(Ar),r(T),r(Rr),r(Ur),r(y),r(Dr),r($),r(kr),r(Br),r(M),r(Wr),r(Nr),r(Gr),r(w),r(Yr),r(Zr),r(C),r(Qr),r(P),r(Xr),r(H),r(qr),r(Vr),r(Kr),r(J),r(Sr),r(Or),r(L),r(es),r(F),r(ts),r(rs),r(ss),r(j),r(os),r(ls),r(A),r(as),r(R),r(is),r(U),r(ds),r(D),r(cs),r(ps),r(ns),r(k),r(ms),r(us),r(W),r(fs),r(N),r(hs),r(G),r(_s),r(gs),r(xs),r(Y),r(Ts),r(bs),r(Q),r(ys),r(X),r($s),r(vs),r(Ms),r(q),r(ws),r(Es),r(K),r(Cs),r(S),r(Ps),r(O),r(Hs),r(Js),r(Is),r(ee),r(Ls),r(Fs),r(re),r(js),r(se),r(zs),r(oe),r(As),r(Rs),r(Us),r(le),r(Ds),r(ks),r(ie),r(Bs),r(de),r(Ws),r(ce),r(Ns),r(Gs),r(Ys),r(pe),r(Zs),r(Qs),r(me),r(Xs),r(ue),r(qs),r(fe),r(Vs),r(Ks),r(Ss),r(he),r(Os),r(eo),r(ge),r(to),r(xe),r(ro),r(Te),r(so),r(oo),r(lo),r(be),r(ao),r(io),r($e),r(co),r(ve),r(po),r(Me),r(no),r(mo),r(uo),r(we),r(fo),r(ho),r(Ce),r(_o),r(Pe),r(go),r(He),r(xo),r(To),r(bo),r(Je),r(yo),r($o),r(Le),r(vo),r(Fe),r(Mo),r(je),r(wo),r(Eo),r(Co),r(ze),r(Po),r(Ho),r(Re),r(Jo),r(Ue),r(Io),r(De),r(Lo),r(Fo),r(jo),r(ke),r(zo),r(Ao),r(We),r(Ro),r(Ne),r(Uo),r(Ge),r(Do),r(ko),r(Bo),r(Ye),r(Wo),r(No),r(Qe),r(Go),r(Yo),r(Zo),r(Xe),r(Qo),r(Xo),r(Ve),r(qo),r(Vo),r(Ko),r(Ke),r(So),r(Oo),r(Oe),r(el),r(et),r(tl),r(tt),r(rl),r(sl),r(ol),r(rt),r(ll),r(al),r(ot),r(il),r(lt),r(dl),r(cl),r(pl),r(at),r(nl),r(ml),r(dt),r(ul),r(ct),r(fl),r(pt),r(hl),r(_l),r(gl),r(nt),r(xl),r(Tl),r(ut),r(bl),r(ft),r(yl),r($l),r(vl),r(ht),r(Ml),r(wl),r(gt),r(El),r(xt),r(Cl),r(Tt),r(Pl),r(Hl),r(Jl),r(bt),r(Il),r(Ll),r($t),r(Fl),r(vt),r(jl),r(zl),r(wt),r(Al),r(Rl),r(Ct),r(Ul),r(Dl),r(kl),r(Pt),r(Bl),r(Wl),r(Jt),r(Nl),r(It),r(Gl),r(Lt),r(Yl),r(Ft),r(Zl),r(Ql),r(Xl),r(jt),r(ql),r(Vl),r(At),r(Kl),r(Sl),r(Ol),r(Rt),r(ea),r(ta),r(Dt),r(ra),r(kt),r(sa),r(Bt),r(oa),r(la),r(aa),r(Wt),r(ia),r(da),r(Gt),r(ca),r(Yt),r(pa),r(Zt),r(na),r(ma),r(ua),r(Qt),r(fa),r(ha),r(qt),r(_a),r(Vt),r(ga),r(xa),r(Ta),r(Kt),r(ba),r(ya),r(Ot),r($a),r(er),r(va),r(tr),r(Ma),r(wa),r(Ea),r(rr),r(Ca),r(Pa),r(or),r(Ha),r(lr),r(Ja),r(ar),r(Ia),r(La),r(Fa),r(ir),r(ja),r(za),r(cr),r(Aa),r(pr),r(Ra),r(nr),r(Ua),r(Da),r(ka),r(mr),r(Ba),r(Wa),r(fr),r(Na),r(hr),r(Ga),r(Ya),r(Za),r(_r),r(Qa),r(Xa),r(xr),r(qa),r(Tr),r(Va),r(Ka),r(Sa),r(br),r(Oa),r(ei),r($r),r(ti),r(vr),r(ri),r(si),r(oi),r(Mr),r(li),r(ai),r(Er),r(ii),r(Cr),r(di),r(ci),r(pi),r(Pr),r(ni),r(mi),r(Jr),r(ui),r(Ir),r(fi),r(hi),r(_i),r(gi),r(jr)),r(x),h(b,e),h(v,e),h(E,e),h(I,e),h(z,e),h(B,e),h(Z,e),h(V,e),h(te,e),h(ae,e),h(ne,e),h(_e,e),h(ye,e),h(Ee,e),h(Ie,e),h(Ae,e),h(Be,e),h(Ze,e),h(qe,e),h(Se,e),h(st,e),h(it,e),h(mt,e),h(_t,e),h(yt,e),h(Mt,e),h(Et,e),h(Ht,e),h(zt,e),h(Ut,e),h(Nt,e),h(Xt,e),h(St,e),h(sr,e),h(dr,e),h(ur,e),h(gr,e),h(yr,e),h(wr,e),h(Hr,e),h(Lr,e)}}}const bc='{"title":"processors","local":"processors","sections":[{"title":"processors.FeatureExtractor ⇐ <code> Callable </code>","local":"processorsfeatureextractor--code-callable-code","sections":[{"title":"new FeatureExtractor(config)","local":"new-featureextractorconfig","sections":[],"depth":3},{"title":"featureExtractor._call(...args)","local":"featureextractorcallargs","sections":[],"depth":3}],"depth":2},{"title":"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>","local":"processorsimagefeatureextractor--code-featureextractor-code","sections":[{"title":"new ImageFeatureExtractor(config)","local":"new-imagefeatureextractorconfig","sections":[],"depth":3},{"title":"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>","local":"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.rescale(pixelData) ⇒ <code> void </code>","local":"imagefeatureextractorrescalepixeldata--code-void-code","sections":[],"depth":3},{"title":"imageFeatureExtractor.get_resize_output_image_size(image, size) ⇒ <code> * </code>","local":"imagefeatureextractorgetresizeoutputimagesizeimage-size--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.resize(image) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorresizeimage--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>","local":"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>","local":"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code","sections":[],"depth":3}],"depth":2},{"title":"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>","local":"processorsdetrfeatureextractor--code-imagefeatureextractor-code","sections":[{"title":"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>","local":"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_object_detection() : <code> * </code>","local":"detrfeatureextractorpostprocessobjectdetection--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_panoptic_segmentation() : <code> * </code>","local":"detrfeatureextractorpostprocesspanopticsegmentation--code--code","sections":[],"depth":3}],"depth":2},{"title":"processors.Processor ⇐ <code> Callable </code>","local":"processorsprocessor--code-callable-code","sections":[{"title":"new Processor(feature_extractor)","local":"new-processorfeatureextractor","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.WhisperProcessor ⇐ <code> Processor </code>","local":"processorswhisperprocessor--code-processor-code","sections":[{"title":"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>","local":"whisperprocessorcallaudio--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.AutoProcessor","local":"processorsautoprocessor","sections":[{"title":"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors.data : <code> Float32Array </code>","local":"processorsdata--code-float32array-code","sections":[],"depth":2},{"title":"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>","local":"processorscentertocornersformatarr--code-array--number--code","sections":[],"depth":2},{"title":"processors~post_process_semantic_segmentation(outputs, [target_sizes]) ⇒ <code> * </code>","local":"processorspostprocesssemanticsegmentationoutputs-targetsizes--code--code","sections":[{"title":"post_process_semantic_segmentation~labels : <code> Array. < number > </code>","local":"postprocesssemanticsegmentationlabels--code-array--number--code","sections":[],"depth":3}],"depth":2},{"title":"processors~post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>","local":"processorspostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code","sections":[],"depth":2},{"title":"processors~post_process_instance_segmentation(outputs, [threshold], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>","local":"processorspostprocessinstancesegmentationoutputs-threshold-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code","sections":[],"depth":2},{"title":"processors~enforce_size_divisibility(size, divisor) ⇒ <code> * </code>","local":"processorsenforcesizedivisibilitysize-divisor--code--code","sections":[],"depth":2},{"title":"processors~HeightWidth : <code> * </code>","local":"processorsheightwidth--code--code","sections":[],"depth":2},{"title":"processors~ImageFeatureExtractorResult : <code> object </code>","local":"processorsimagefeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~PreprocessedImage : <code> object </code>","local":"processorspreprocessedimage--code-object-code","sections":[],"depth":2},{"title":"processors~DetrFeatureExtractorResult : <code> object </code>","local":"processorsdetrfeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~SamImageProcessorResult : <code> object </code>","local":"processorssamimageprocessorresult--code-object-code","sections":[],"depth":2}],"depth":1}';function yc(bi){return uc(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ec extends fc{constructor(x){super(),hc(this,x,yc,Tc,nc,{})}}export{Ec as component};
