import{s as nt,o as at,n as be}from"../chunks/scheduler.182ea377.js";import{S as it,i as pt,g as o,s as a,r as u,A as ot,h as m,f as t,c as i,j as tt,u as M,x as r,k as st,y as mt,a as s,v as d,d as y,t as h,w}from"../chunks/index.abf12888.js";import{T as Ue}from"../chunks/Tip.230e2334.js";import{C as j}from"../chunks/CodeBlock.57fe6e13.js";import{H as G}from"../chunks/Heading.16916d63.js";function rt(U){let n,J='In many cases, optimizing for memory or speed leads to improved performance in the other, so you should try to optimize for both whenever you can. This guide focuses on minimizing memory usage, but you can also learn more about how to <a href="fp16">Speed up inference</a>.';return{c(){n=o("p"),n.innerHTML=J},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-15lbm2y"&&(n.innerHTML=J)},m(p,c){s(p,n,c)},p:be,d(p){p&&t(n)}}}function ct(U){let n,J='Consider using <a href="#model-offloading">model offloading</a> if you want to optimize for speed because it is much faster. The tradeoff is your memory savings won’t be as large.';return{c(){n=o("p"),n.innerHTML=J},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-1yyrc0t"&&(n.innerHTML=J)},m(p,c){s(p,n,c)},p:be,d(p){p&&t(n)}}}function ft(U){let n,J='When using <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>, don’t move the pipeline to CUDA beforehand or else the gain in memory consumption will only be minimal (see this <a href="https://github.com/huggingface/diffusers/issues/1934" rel="nofollow">issue</a> for more information).',p,c,b='<a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a> is a stateful operation that installs hooks on the models.';return{c(){n=o("p"),n.innerHTML=J,p=a(),c=o("p"),c.innerHTML=b},l(f){n=m(f,"P",{"data-svelte-h":!0}),r(n)!=="svelte-u2087l"&&(n.innerHTML=J),p=i(f),c=m(f,"P",{"data-svelte-h":!0}),r(c)!=="svelte-m4j3is"&&(c.innerHTML=b)},m(f,T){s(f,n,T),s(f,p,T),s(f,c,T)},p:be,d(f){f&&(t(n),t(p),t(c))}}}function ut(U){let n,J="Model offloading requires 🤗 Accelerate version 0.17.0 or higher.";return{c(){n=o("p"),n.textContent=J},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-1guxtqy"&&(n.textContent=J)},m(p,c){s(p,n,c)},p:be,d(p){p&&t(n)}}}function Mt(U){let n,J=`In order to properly offload models after they’re called, it is required to run the entire pipeline and models are called in the pipeline’s expected order. Exercise caution if models are reused outside the context of the pipeline after hooks have been installed. See <a href="https://huggingface.co/docs/accelerate/en/package_reference/big_modeling#accelerate.hooks.remove_hook_from_module" rel="nofollow">Removing Hooks</a>
for more information.`,p,c,b='<a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> is a stateful operation that installs hooks on the models and state on the pipeline.';return{c(){n=o("p"),n.innerHTML=J,p=a(),c=o("p"),c.innerHTML=b},l(f){n=m(f,"P",{"data-svelte-h":!0}),r(n)!=="svelte-x5j3hq"&&(n.innerHTML=J),p=i(f),c=m(f,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1f2ces9"&&(c.innerHTML=b)},m(f,T){s(f,n,T),s(f,p,T),s(f,c,T)},p:be,d(f){f&&(t(n),t(p),t(c))}}}function dt(U){let n,J="If you have PyTorch &gt;= 2.0 installed, you should not expect a speed-up for inference when enabling <code>xformers</code>.";return{c(){n=o("p"),n.innerHTML=J},l(p){n=m(p,"P",{"data-svelte-h":!0}),r(n)!=="svelte-17vr965"&&(n.innerHTML=J)},m(p,c){s(p,n,c)},p:be,d(p){p&&t(n)}}}function yt(U){let n,J,p,c,b,f,T,bl="A barrier to using diffusion models is the large amount of memory required. To overcome this challenge, there are several memory-reducing techniques you can use to run even some of the largest models on free-tier or consumer GPUs. Some of these techniques can even be combined to further reduce memory usage.",Ce,C,Ze,v,jl="The results below are obtained from generating a single 512x512 image from the prompt a photo of an astronaut riding a horse on mars with 50 DDIM steps on a Nvidia Titan RTX, demonstrating the speed-up you can expect as a result of reduced memory consumption.",_e,W,Cl="<thead><tr><th></th> <th>latency</th> <th>speed-up</th></tr></thead> <tbody><tr><td>original</td> <td>9.50s</td> <td>x1</td></tr> <tr><td>fp16</td> <td>3.61s</td> <td>x2.63</td></tr> <tr><td>channels last</td> <td>3.30s</td> <td>x2.88</td></tr> <tr><td>traced UNet</td> <td>3.21s</td> <td>x2.96</td></tr> <tr><td>memory-efficient attention</td> <td>2.63s</td> <td>x3.61</td></tr></tbody>",Ie,$,ge,V,Zl='Sliced VAE enables decoding large batches of images with limited VRAM or batches with 32 images or more by decoding the batches of latents one image at a time. You’ll likely want to couple this with <a href="/docs/diffusers/v0.22.1/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to further reduce memory use.',Be,R,_l='To use sliced VAE, call <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.enable_vae_slicing">enable_vae_slicing()</a> on your pipeline before inference:',Ge,k,ve,X,Il="You may see a small performance boost in VAE decoding on multi-image batches, and there should be no performance impact on single-image batches.",We,E,$e,S,gl='Tiled VAE processing also enables working with large images on limited VRAM (for example, generating 4k images on 8GB of VRAM) by splitting the image into overlapping tiles, decoding the tiles, and then blending the outputs together to compose the final image. You should also used tiled VAE with <a href="/docs/diffusers/v0.22.1/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> to further reduce memory use.',Ve,Y,Bl='To use tiled VAE processing, call <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline.enable_vae_tiling">enable_vae_tiling()</a> on your pipeline before inference:',Re,x,ke,N,Gl="The output image has some tile-to-tile tone variation because the tiles are decoded separately, but you shouldn’t see any sharp and obvious seams between the tiles. Tiling is turned off for images that are 512x512 or smaller.",Xe,H,Ee,Q,vl="Offloading the weights to the CPU and only loading them on the GPU when performing the forward pass can also save memory. Often, this technique can reduce memory consumption to less than 3GB.",Se,z,Wl='To perform CPU offloading, call <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/latent_upscale#diffusers.StableDiffusionLatentUpscalePipeline.enable_sequential_cpu_offload">enable_sequential_cpu_offload()</a>:',Ye,A,xe,F,$l="CPU offloading works on submodules rather than whole models. This is the best way to minimize memory consumption, but inference is much slower due to the iterative nature of the diffusion process. The UNet component of the pipeline runs several times (as many as <code>num_inference_steps</code>); each time, the different UNet submodules are sequentially onloaded and offloaded as needed, resulting in a large number of memory transfers.",Ne,Z,He,L,Vl="CPU offloading can also be chained with attention slicing to reduce memory consumption to less than 2GB.",Qe,q,ze,_,Ae,P,Fe,I,Le,D,Rl='<a href="#cpu-offloading">Sequential CPU offloading</a> preserves a lot of memory but it makes inference slower because submodules are moved to GPU as needed, and they’re immediately returned to the CPU when a new module runs.',qe,K,kl="Full-model offloading is an alternative that moves whole models to the GPU, instead of handling each model’s constituent <em>submodules</em>. There is a negligible impact on inference time (compared with moving the pipeline to <code>cuda</code>), and it still provides some memory savings.",Pe,O,Xl=`During model offloading, only one of the main components of the pipeline (typically the text encoder, UNet and VAE)
is placed on the GPU while the others wait on the CPU. Components like the UNet that run for multiple iterations stay on the GPU until they’re no longer needed.`,De,ee,El='Enable model offloading by calling <a href="/docs/diffusers/v0.22.1/en/api/pipelines/stable_diffusion/gligen#diffusers.StableDiffusionGLIGENTextImagePipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> on the pipeline:',Ke,le,Oe,te,Sl="Model offloading can also be combined with attention slicing for additional memory savings.",el,se,ll,g,tl,ne,sl,ae,Yl="The channels-last memory format is an alternative way of ordering NCHW tensors in memory to preserve dimension ordering. Channels-last tensors are ordered in such a way that the channels become the densest dimension (storing images pixel-per-pixel). Since not all operators currently support the channels-last format, it may result in worst performance but you should still try and see if it works for your model.",nl,ie,xl="For example, to set the pipeline’s UNet to use the channels-last format:",al,pe,il,oe,pl,me,Nl="Tracing runs an example input tensor through the model and captures the operations that are performed on it as that input makes its way through the model’s layers. The executable or <code>ScriptFunction</code> that is returned is optimized with just-in-time compilation.",ol,re,Hl="To trace a UNet:",ml,ce,rl,fe,Ql="Replace the <code>unet</code> attribute of the pipeline with the traced model:",cl,ue,fl,Me,ul,de,zl='Recent work on optimizing bandwidth in the attention block has generated huge speed-ups and reductions in GPU memory usage. The most recent type of memory-efficient attention is <a href="https://arxiv.org/pdf/2205.14135.pdf" rel="nofollow">Flash Attention</a> (you can check out the original code at <a href="https://github.com/HazyResearch/flash-attention" rel="nofollow">HazyResearch/flash-attention</a>).',Ml,B,dl,ye,Al="To use Flash Attention, install the following:",yl,he,Fl='<li>PyTorch &gt; 1.12</li> <li>CUDA available</li> <li><a href="xformers">xFormers</a></li>',hl,we,Ll='Then call <a href="/docs/diffusers/v0.22.1/en/api/models/overview#diffusers.ModelMixin.enable_xformers_memory_efficient_attention">enable_xformers_memory_efficient_attention()</a> on the pipeline:',wl,Je,Jl,Te,ql='The iteration speed when using <code>xformers</code> should match the iteration speed of Torch 2.0 as described <a href="torch2.0">here</a>.',Tl,je,Ul;return b=new G({props:{title:"Reduce memory usage",local:"reduce-memory-usage",headingTag:"h1"}}),C=new Ue({props:{$$slots:{default:[rt]},$$scope:{ctx:U}}}),$=new G({props:{title:"Sliced VAE",local:"sliced-vae",headingTag:"h2"}}),k=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmElMjBwaG90byUyMG9mJTIwYW4lMjBhc3Ryb25hdXQlMjByaWRpbmclMjBhJTIwaG9yc2UlMjBvbiUyMG1hcnMlMjIlMEFwaXBlLmVuYWJsZV92YWVfc2xpY2luZygpJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZSglNUJwcm9tcHQlNUQlMjAqJTIwMzIpLmltYWdlcw==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_vae_slicing()
images = pipe([prompt] * <span class="hljs-number">32</span>).images`,wrap:!1}}),E=new G({props:{title:"Tiled VAE",local:"tiled-vae",headingTag:"h2"}}),x=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTJDJTBBKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZS5zY2hlZHVsZXIuY29uZmlnKSUwQXBpcGUlMjAlM0QlMjBwaXBlLnRvKCUyMmN1ZGElMjIpJTBBcHJvbXB0JTIwJTNEJTIwJTIyYSUyMGJlYXV0aWZ1bCUyMGxhbmRzY2FwZSUyMHBob3RvZ3JhcGglMjIlMEFwaXBlLmVuYWJsZV92YWVfdGlsaW5nKCklMEFwaXBlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKCU1QnByb21wdCU1RCUyQyUyMHdpZHRoJTNEMzg0MCUyQyUyMGhlaWdodCUzRDIyMjQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, UniPCMultistepScheduler

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
prompt = <span class="hljs-string">&quot;a beautiful landscape photograph&quot;</span>
pipe.enable_vae_tiling()
pipe.enable_xformers_memory_efficient_attention()

image = pipe([prompt], width=<span class="hljs-number">3840</span>, height=<span class="hljs-number">2224</span>, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),H=new G({props:{title:"CPU offloading",local:"cpu-offloading",headingTag:"h2"}}),A=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfc2VxdWVudGlhbF9jcHVfb2ZmbG9hZCgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_sequential_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Z=new Ue({props:{$$slots:{default:[ct]},$$scope:{ctx:U}}}),q=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfc2VxdWVudGlhbF9jcHVfb2ZmbG9hZCgpJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlKHByb21wdCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_sequential_cpu_offload()

image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),_=new Ue({props:{warning:!0,$$slots:{default:[ft]},$$scope:{ctx:U}}}),P=new G({props:{title:"Model offloading",local:"model-offloading",headingTag:"h2"}}),I=new Ue({props:{$$slots:{default:[ut]},$$scope:{ctx:U}}}),le=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwJTIwJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,  
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_model_cpu_offload()
image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),se=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMEElMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJhJTIwcGhvdG8lMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBtYXJzJTIyJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKSUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
)

prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
pipe.enable_model_cpu_offload()

image = pipe(prompt).images[<span class="hljs-number">0</span>]`,wrap:!1}}),g=new Ue({props:{warning:!0,$$slots:{default:[Mt]},$$scope:{ctx:U}}}),ne=new G({props:{title:"Channels-last memory format",local:"channels-last-memory-format",headingTag:"h2"}}),pe=new j({props:{code:"cHJpbnQocGlwZS51bmV0LmNvbnZfb3V0LnN0YXRlX2RpY3QoKSU1QiUyMndlaWdodCUyMiU1RC5zdHJpZGUoKSklMjAlMjAlMjMlMjAoMjg4MCUyQyUyMDklMkMlMjAzJTJDJTIwMSklMEFwaXBlLnVuZXQudG8obWVtb3J5X2Zvcm1hdCUzRHRvcmNoLmNoYW5uZWxzX2xhc3QpJTIwJTIwJTIzJTIwaW4tcGxhY2UlMjBvcGVyYXRpb24lMEFwcmludCglMEElMjAlMjAlMjAlMjBwaXBlLnVuZXQuY29udl9vdXQuc3RhdGVfZGljdCgpJTVCJTIyd2VpZ2h0JTIyJTVELnN0cmlkZSgpJTBBKSUyMCUyMCUyMyUyMCgyODgwJTJDJTIwMSUyQyUyMDk2MCUyQyUyMDMyMCklMjBoYXZpbmclMjBhJTIwc3RyaWRlJTIwb2YlMjAxJTIwZm9yJTIwdGhlJTIwMm5kJTIwZGltZW5zaW9uJTIwcHJvdmVzJTIwdGhhdCUyMGl0JTIwd29ya3M=",highlighted:`<span class="hljs-built_in">print</span>(pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride())  <span class="hljs-comment"># (2880, 9, 3, 1)</span>
pipe.unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># in-place operation</span>
<span class="hljs-built_in">print</span>(
    pipe.unet.conv_out.state_dict()[<span class="hljs-string">&quot;weight&quot;</span>].stride()
)  <span class="hljs-comment"># (2880, 1, 960, 320) having a stride of 1 for the 2nd dimension proves that it works</span>`,wrap:!1}}),oe=new G({props:{title:"Tracing",local:"tracing",headingTag:"h2"}}),ce=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> functools

<span class="hljs-comment"># torch disable grad</span>
torch.set_grad_enabled(<span class="hljs-literal">False</span>)

<span class="hljs-comment"># set variables</span>
n_experiments = <span class="hljs-number">2</span>
unet_runs_per_experiment = <span class="hljs-number">50</span>


<span class="hljs-comment"># load inputs</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">generate_inputs</span>():
    sample = torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>).half().cuda()
    timestep = torch.rand(<span class="hljs-number">1</span>).half().cuda() * <span class="hljs-number">999</span>
    encoder_hidden_states = torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">77</span>, <span class="hljs-number">768</span>).half().cuda()
    <span class="hljs-keyword">return</span> sample, timestep, encoder_hidden_states


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)
unet = pipe.unet
unet.<span class="hljs-built_in">eval</span>()
unet.to(memory_format=torch.channels_last)  <span class="hljs-comment"># use channels_last memory format</span>
unet.forward = functools.partial(unet.forward, return_dict=<span class="hljs-literal">False</span>)  <span class="hljs-comment"># set return_dict=False as default</span>

<span class="hljs-comment"># warmup</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">3</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet(*inputs)

<span class="hljs-comment"># trace</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;tracing..&quot;</span>)
unet_traced = torch.jit.trace(unet, inputs)
unet_traced.<span class="hljs-built_in">eval</span>()
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;done tracing&quot;</span>)


<span class="hljs-comment"># warmup and optimize graph</span>
<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
    <span class="hljs-keyword">with</span> torch.inference_mode():
        inputs = generate_inputs()
        orig_output = unet_traced(*inputs)


<span class="hljs-comment"># benchmarking</span>
<span class="hljs-keyword">with</span> torch.inference_mode():
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet_traced(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet traced inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)
    <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(n_experiments):
        torch.cuda.synchronize()
        start_time = time.time()
        <span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(unet_runs_per_experiment):
            orig_output = unet(*inputs)
        torch.cuda.synchronize()
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;unet inference took <span class="hljs-subst">{time.time() - start_time:<span class="hljs-number">.2</span>f}</span> seconds&quot;</span>)

<span class="hljs-comment"># save the model</span>
unet_traced.save(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)`,wrap:!1}}),ue=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGF0YWNsYXNzZXMlMjBpbXBvcnQlMjBkYXRhY2xhc3MlMEElMEElMEElNDBkYXRhY2xhc3MlMEFjbGFzcyUyMFVOZXQyRENvbmRpdGlvbk91dHB1dCUzQSUwQSUyMCUyMCUyMCUyMHNhbXBsZSUzQSUyMHRvcmNoLkZsb2F0VGVuc29yJTBBJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMkMlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwdXNlJTIwaml0dGVkJTIwdW5ldCUwQXVuZXRfdHJhY2VkJTIwJTNEJTIwdG9yY2guaml0LmxvYWQoJTIydW5ldF90cmFjZWQucHQlMjIpJTBBJTBBJTBBJTIzJTIwZGVsJTIwcGlwZS51bmV0JTBBY2xhc3MlMjBUcmFjZWRVTmV0KHRvcmNoLm5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuaW5fY2hhbm5lbHMlMjAlM0QlMjBwaXBlLnVuZXQuaW5fY2hhbm5lbHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmRldmljZSUyMCUzRCUyMHBpcGUudW5ldC5kZXZpY2UlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBsYXRlbnRfbW9kZWxfaW5wdXQlMkMlMjB0JTJDJTIwZW5jb2Rlcl9oaWRkZW5fc3RhdGVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNhbXBsZSUyMCUzRCUyMHVuZXRfdHJhY2VkKGxhdGVudF9tb2RlbF9pbnB1dCUyQyUyMHQlMkMlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMFVOZXQyRENvbmRpdGlvbk91dHB1dChzYW1wbGUlM0RzYW1wbGUpJTBBJTBBJTBBcGlwZS51bmV0JTIwJTNEJTIwVHJhY2VkVU5ldCgpJTBBJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHBpcGUoJTVCcHJvbXB0JTVEJTIwKiUyMDElMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass


<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">UNet2DConditionOutput</span>:
    sample: torch.FloatTensor


pipe = StableDiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># use jitted unet</span>
unet_traced = torch.jit.load(<span class="hljs-string">&quot;unet_traced.pt&quot;</span>)


<span class="hljs-comment"># del pipe.unet</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TracedUNet</span>(torch.nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.in_channels = pipe.unet.in_channels
        self.device = pipe.unet.device

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, latent_model_input, t, encoder_hidden_states</span>):
        sample = unet_traced(latent_model_input, t, encoder_hidden_states)[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">return</span> UNet2DConditionOutput(sample=sample)


pipe.unet = TracedUNet()

<span class="hljs-keyword">with</span> torch.inference_mode():
    image = pipe([prompt] * <span class="hljs-number">1</span>, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),Me=new G({props:{title:"Memory-efficient attention",local:"memory-efficient-attention",headingTag:"h2"}}),B=new Ue({props:{$$slots:{default:[dt]},$$scope:{ctx:U}}}),Je=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFwaXBlLmVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigpJTBBJTBBd2l0aCUyMHRvcmNoLmluZmVyZW5jZV9tb2RlKCklM0ElMEElMjAlMjAlMjAlMjBzYW1wbGUlMjAlM0QlMjBwaXBlKCUyMmElMjBzbWFsbCUyMGNhdCUyMiklMEElMEElMjMlMjBvcHRpb25hbCUzQSUyMFlvdSUyMGNhbiUyMGRpc2FibGUlMjBpdCUyMHZpYSUwQSUyMyUyMHBpcGUuZGlzYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbigp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipe = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

pipe.enable_xformers_memory_efficient_attention()

<span class="hljs-keyword">with</span> torch.inference_mode():
    sample = pipe(<span class="hljs-string">&quot;a small cat&quot;</span>)

<span class="hljs-comment"># optional: You can disable it via</span>
<span class="hljs-comment"># pipe.disable_xformers_memory_efficient_attention()</span>`,wrap:!1}}),{c(){n=o("meta"),J=a(),p=o("p"),c=a(),u(b.$$.fragment),f=a(),T=o("p"),T.textContent=bl,Ce=a(),u(C.$$.fragment),Ze=a(),v=o("p"),v.textContent=jl,_e=a(),W=o("table"),W.innerHTML=Cl,Ie=a(),u($.$$.fragment),ge=a(),V=o("p"),V.innerHTML=Zl,Be=a(),R=o("p"),R.innerHTML=_l,Ge=a(),u(k.$$.fragment),ve=a(),X=o("p"),X.textContent=Il,We=a(),u(E.$$.fragment),$e=a(),S=o("p"),S.innerHTML=gl,Ve=a(),Y=o("p"),Y.innerHTML=Bl,Re=a(),u(x.$$.fragment),ke=a(),N=o("p"),N.textContent=Gl,Xe=a(),u(H.$$.fragment),Ee=a(),Q=o("p"),Q.textContent=vl,Se=a(),z=o("p"),z.innerHTML=Wl,Ye=a(),u(A.$$.fragment),xe=a(),F=o("p"),F.innerHTML=$l,Ne=a(),u(Z.$$.fragment),He=a(),L=o("p"),L.textContent=Vl,Qe=a(),u(q.$$.fragment),ze=a(),u(_.$$.fragment),Ae=a(),u(P.$$.fragment),Fe=a(),u(I.$$.fragment),Le=a(),D=o("p"),D.innerHTML=Rl,qe=a(),K=o("p"),K.innerHTML=kl,Pe=a(),O=o("p"),O.textContent=Xl,De=a(),ee=o("p"),ee.innerHTML=El,Ke=a(),u(le.$$.fragment),Oe=a(),te=o("p"),te.textContent=Sl,el=a(),u(se.$$.fragment),ll=a(),u(g.$$.fragment),tl=a(),u(ne.$$.fragment),sl=a(),ae=o("p"),ae.textContent=Yl,nl=a(),ie=o("p"),ie.textContent=xl,al=a(),u(pe.$$.fragment),il=a(),u(oe.$$.fragment),pl=a(),me=o("p"),me.innerHTML=Nl,ol=a(),re=o("p"),re.textContent=Hl,ml=a(),u(ce.$$.fragment),rl=a(),fe=o("p"),fe.innerHTML=Ql,cl=a(),u(ue.$$.fragment),fl=a(),u(Me.$$.fragment),ul=a(),de=o("p"),de.innerHTML=zl,Ml=a(),u(B.$$.fragment),dl=a(),ye=o("p"),ye.textContent=Al,yl=a(),he=o("ul"),he.innerHTML=Fl,hl=a(),we=o("p"),we.innerHTML=Ll,wl=a(),u(Je.$$.fragment),Jl=a(),Te=o("p"),Te.innerHTML=ql,Tl=a(),je=o("p"),this.h()},l(e){const l=ot("svelte-u9bgzb",document.head);n=m(l,"META",{name:!0,content:!0}),l.forEach(t),J=i(e),p=m(e,"P",{}),tt(p).forEach(t),c=i(e),M(b.$$.fragment,e),f=i(e),T=m(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-18ag1qn"&&(T.textContent=bl),Ce=i(e),M(C.$$.fragment,e),Ze=i(e),v=m(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1nfsyhf"&&(v.textContent=jl),_e=i(e),W=m(e,"TABLE",{"data-svelte-h":!0}),r(W)!=="svelte-qiiy0g"&&(W.innerHTML=Cl),Ie=i(e),M($.$$.fragment,e),ge=i(e),V=m(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-9p8olg"&&(V.innerHTML=Zl),Be=i(e),R=m(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-18zv28y"&&(R.innerHTML=_l),Ge=i(e),M(k.$$.fragment,e),ve=i(e),X=m(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-fte8mn"&&(X.textContent=Il),We=i(e),M(E.$$.fragment,e),$e=i(e),S=m(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-grkfg5"&&(S.innerHTML=gl),Ve=i(e),Y=m(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-kvgpqr"&&(Y.innerHTML=Bl),Re=i(e),M(x.$$.fragment,e),ke=i(e),N=m(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-nyzaca"&&(N.textContent=Gl),Xe=i(e),M(H.$$.fragment,e),Ee=i(e),Q=m(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-435lli"&&(Q.textContent=vl),Se=i(e),z=m(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-17dsskg"&&(z.innerHTML=Wl),Ye=i(e),M(A.$$.fragment,e),xe=i(e),F=m(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-153k8wf"&&(F.innerHTML=$l),Ne=i(e),M(Z.$$.fragment,e),He=i(e),L=m(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1wrkee7"&&(L.textContent=Vl),Qe=i(e),M(q.$$.fragment,e),ze=i(e),M(_.$$.fragment,e),Ae=i(e),M(P.$$.fragment,e),Fe=i(e),M(I.$$.fragment,e),Le=i(e),D=m(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1w0xgx8"&&(D.innerHTML=Rl),qe=i(e),K=m(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-nislc4"&&(K.innerHTML=kl),Pe=i(e),O=m(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-11gjm3"&&(O.textContent=Xl),De=i(e),ee=m(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1l6e8mi"&&(ee.innerHTML=El),Ke=i(e),M(le.$$.fragment,e),Oe=i(e),te=m(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-18lh0s2"&&(te.textContent=Sl),el=i(e),M(se.$$.fragment,e),ll=i(e),M(g.$$.fragment,e),tl=i(e),M(ne.$$.fragment,e),sl=i(e),ae=m(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-sky5la"&&(ae.textContent=Yl),nl=i(e),ie=m(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-mhdc10"&&(ie.textContent=xl),al=i(e),M(pe.$$.fragment,e),il=i(e),M(oe.$$.fragment,e),pl=i(e),me=m(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1hj6sqj"&&(me.innerHTML=Nl),ol=i(e),re=m(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1ca1ko1"&&(re.textContent=Hl),ml=i(e),M(ce.$$.fragment,e),rl=i(e),fe=m(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-mpebhd"&&(fe.innerHTML=Ql),cl=i(e),M(ue.$$.fragment,e),fl=i(e),M(Me.$$.fragment,e),ul=i(e),de=m(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1fdlos"&&(de.innerHTML=zl),Ml=i(e),M(B.$$.fragment,e),dl=i(e),ye=m(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-rpfoyf"&&(ye.textContent=Al),yl=i(e),he=m(e,"UL",{"data-svelte-h":!0}),r(he)!=="svelte-1q6gndt"&&(he.innerHTML=Fl),hl=i(e),we=m(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-4rizsp"&&(we.innerHTML=Ll),wl=i(e),M(Je.$$.fragment,e),Jl=i(e),Te=m(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1y8qace"&&(Te.innerHTML=ql),Tl=i(e),je=m(e,"P",{}),tt(je).forEach(t),this.h()},h(){st(n,"name","hf:doc:metadata"),st(n,"content",ht)},m(e,l){mt(document.head,n),s(e,J,l),s(e,p,l),s(e,c,l),d(b,e,l),s(e,f,l),s(e,T,l),s(e,Ce,l),d(C,e,l),s(e,Ze,l),s(e,v,l),s(e,_e,l),s(e,W,l),s(e,Ie,l),d($,e,l),s(e,ge,l),s(e,V,l),s(e,Be,l),s(e,R,l),s(e,Ge,l),d(k,e,l),s(e,ve,l),s(e,X,l),s(e,We,l),d(E,e,l),s(e,$e,l),s(e,S,l),s(e,Ve,l),s(e,Y,l),s(e,Re,l),d(x,e,l),s(e,ke,l),s(e,N,l),s(e,Xe,l),d(H,e,l),s(e,Ee,l),s(e,Q,l),s(e,Se,l),s(e,z,l),s(e,Ye,l),d(A,e,l),s(e,xe,l),s(e,F,l),s(e,Ne,l),d(Z,e,l),s(e,He,l),s(e,L,l),s(e,Qe,l),d(q,e,l),s(e,ze,l),d(_,e,l),s(e,Ae,l),d(P,e,l),s(e,Fe,l),d(I,e,l),s(e,Le,l),s(e,D,l),s(e,qe,l),s(e,K,l),s(e,Pe,l),s(e,O,l),s(e,De,l),s(e,ee,l),s(e,Ke,l),d(le,e,l),s(e,Oe,l),s(e,te,l),s(e,el,l),d(se,e,l),s(e,ll,l),d(g,e,l),s(e,tl,l),d(ne,e,l),s(e,sl,l),s(e,ae,l),s(e,nl,l),s(e,ie,l),s(e,al,l),d(pe,e,l),s(e,il,l),d(oe,e,l),s(e,pl,l),s(e,me,l),s(e,ol,l),s(e,re,l),s(e,ml,l),d(ce,e,l),s(e,rl,l),s(e,fe,l),s(e,cl,l),d(ue,e,l),s(e,fl,l),d(Me,e,l),s(e,ul,l),s(e,de,l),s(e,Ml,l),d(B,e,l),s(e,dl,l),s(e,ye,l),s(e,yl,l),s(e,he,l),s(e,hl,l),s(e,we,l),s(e,wl,l),d(Je,e,l),s(e,Jl,l),s(e,Te,l),s(e,Tl,l),s(e,je,l),Ul=!0},p(e,[l]){const Pl={};l&2&&(Pl.$$scope={dirty:l,ctx:e}),C.$set(Pl);const Dl={};l&2&&(Dl.$$scope={dirty:l,ctx:e}),Z.$set(Dl);const Kl={};l&2&&(Kl.$$scope={dirty:l,ctx:e}),_.$set(Kl);const Ol={};l&2&&(Ol.$$scope={dirty:l,ctx:e}),I.$set(Ol);const et={};l&2&&(et.$$scope={dirty:l,ctx:e}),g.$set(et);const lt={};l&2&&(lt.$$scope={dirty:l,ctx:e}),B.$set(lt)},i(e){Ul||(y(b.$$.fragment,e),y(C.$$.fragment,e),y($.$$.fragment,e),y(k.$$.fragment,e),y(E.$$.fragment,e),y(x.$$.fragment,e),y(H.$$.fragment,e),y(A.$$.fragment,e),y(Z.$$.fragment,e),y(q.$$.fragment,e),y(_.$$.fragment,e),y(P.$$.fragment,e),y(I.$$.fragment,e),y(le.$$.fragment,e),y(se.$$.fragment,e),y(g.$$.fragment,e),y(ne.$$.fragment,e),y(pe.$$.fragment,e),y(oe.$$.fragment,e),y(ce.$$.fragment,e),y(ue.$$.fragment,e),y(Me.$$.fragment,e),y(B.$$.fragment,e),y(Je.$$.fragment,e),Ul=!0)},o(e){h(b.$$.fragment,e),h(C.$$.fragment,e),h($.$$.fragment,e),h(k.$$.fragment,e),h(E.$$.fragment,e),h(x.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(Z.$$.fragment,e),h(q.$$.fragment,e),h(_.$$.fragment,e),h(P.$$.fragment,e),h(I.$$.fragment,e),h(le.$$.fragment,e),h(se.$$.fragment,e),h(g.$$.fragment,e),h(ne.$$.fragment,e),h(pe.$$.fragment,e),h(oe.$$.fragment,e),h(ce.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(B.$$.fragment,e),h(Je.$$.fragment,e),Ul=!1},d(e){e&&(t(J),t(p),t(c),t(f),t(T),t(Ce),t(Ze),t(v),t(_e),t(W),t(Ie),t(ge),t(V),t(Be),t(R),t(Ge),t(ve),t(X),t(We),t($e),t(S),t(Ve),t(Y),t(Re),t(ke),t(N),t(Xe),t(Ee),t(Q),t(Se),t(z),t(Ye),t(xe),t(F),t(Ne),t(He),t(L),t(Qe),t(ze),t(Ae),t(Fe),t(Le),t(D),t(qe),t(K),t(Pe),t(O),t(De),t(ee),t(Ke),t(Oe),t(te),t(el),t(ll),t(tl),t(sl),t(ae),t(nl),t(ie),t(al),t(il),t(pl),t(me),t(ol),t(re),t(ml),t(rl),t(fe),t(cl),t(fl),t(ul),t(de),t(Ml),t(dl),t(ye),t(yl),t(he),t(hl),t(we),t(wl),t(Jl),t(Te),t(Tl),t(je)),t(n),w(b,e),w(C,e),w($,e),w(k,e),w(E,e),w(x,e),w(H,e),w(A,e),w(Z,e),w(q,e),w(_,e),w(P,e),w(I,e),w(le,e),w(se,e),w(g,e),w(ne,e),w(pe,e),w(oe,e),w(ce,e),w(ue,e),w(Me,e),w(B,e),w(Je,e)}}}const ht='{"title":"Reduce memory usage","local":"reduce-memory-usage","sections":[{"title":"Sliced VAE","local":"sliced-vae","sections":[],"depth":2},{"title":"Tiled VAE","local":"tiled-vae","sections":[],"depth":2},{"title":"CPU offloading","local":"cpu-offloading","sections":[],"depth":2},{"title":"Model offloading","local":"model-offloading","sections":[],"depth":2},{"title":"Channels-last memory format","local":"channels-last-memory-format","sections":[],"depth":2},{"title":"Tracing","local":"tracing","sections":[],"depth":2},{"title":"Memory-efficient attention","local":"memory-efficient-attention","sections":[],"depth":2}],"depth":1}';function wt(U){return at(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ct extends it{constructor(n){super(),pt(this,n,wt,yt,nt,{})}}export{Ct as component};
