
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/fillers/monaco-editor-core',[], function () {
    return self.monaco;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/_.contribution',["require", "exports", "./fillers/monaco-editor-core"], function (require, exports, monaco_editor_core_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.registerLanguage = exports.loadLanguage = void 0;
    var languageDefinitions = {};
    var lazyLanguageLoaders = {};
    var LazyLanguageLoader = /** @class */ (function () {
        function LazyLanguageLoader(languageId) {
            var _this = this;
            this._languageId = languageId;
            this._loadingTriggered = false;
            this._lazyLoadPromise = new Promise(function (resolve, reject) {
                _this._lazyLoadPromiseResolve = resolve;
                _this._lazyLoadPromiseReject = reject;
            });
        }
        LazyLanguageLoader.getOrCreate = function (languageId) {
            if (!lazyLanguageLoaders[languageId]) {
                lazyLanguageLoaders[languageId] = new LazyLanguageLoader(languageId);
            }
            return lazyLanguageLoaders[languageId];
        };
        LazyLanguageLoader.prototype.whenLoaded = function () {
            return this._lazyLoadPromise;
        };
        LazyLanguageLoader.prototype.load = function () {
            var _this = this;
            if (!this._loadingTriggered) {
                this._loadingTriggered = true;
                languageDefinitions[this._languageId].loader().then(function (mod) { return _this._lazyLoadPromiseResolve(mod); }, function (err) { return _this._lazyLoadPromiseReject(err); });
            }
            return this._lazyLoadPromise;
        };
        return LazyLanguageLoader;
    }());
    function loadLanguage(languageId) {
        return LazyLanguageLoader.getOrCreate(languageId).load();
    }
    exports.loadLanguage = loadLanguage;
    function registerLanguage(def) {
        var languageId = def.id;
        languageDefinitions[languageId] = def;
        monaco_editor_core_1.languages.register(def);
        var lazyLanguageLoader = LazyLanguageLoader.getOrCreate(languageId);
        monaco_editor_core_1.languages.setMonarchTokensProvider(languageId, lazyLanguageLoader.whenLoaded().then(function (mod) { return mod.language; }));
        monaco_editor_core_1.languages.onLanguage(languageId, function () {
            lazyLanguageLoader.load().then(function (mod) {
                monaco_editor_core_1.languages.setLanguageConfiguration(languageId, mod.conf);
            });
        });
    }
    exports.registerLanguage = registerLanguage;
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/abap/abap.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'abap',
        extensions: ['.abap'],
        aliases: ['abap', 'ABAP'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./abap'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/apex/apex.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'apex',
        extensions: ['.cls'],
        aliases: ['Apex', 'apex'],
        mimetypes: ['text/x-apex-source', 'text/x-apex'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./apex'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/azcli/azcli.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'azcli',
        extensions: ['.azcli'],
        aliases: ['Azure CLI', 'azcli'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./azcli'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/bat/bat.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'bat',
        extensions: ['.bat', '.cmd'],
        aliases: ['Batch', 'bat'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./bat'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/bicep/bicep.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'bicep',
        extensions: ['.bicep'],
        aliases: ['Bicep'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./bicep'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/cameligo/cameligo.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'cameligo',
        extensions: ['.mligo'],
        aliases: ['Cameligo'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./cameligo'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/clojure/clojure.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'clojure',
        extensions: ['.clj', '.cljs', '.cljc', '.edn'],
        aliases: ['clojure', 'Clojure'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./clojure'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/coffee/coffee.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'coffeescript',
        extensions: ['.coffee'],
        aliases: ['CoffeeScript', 'coffeescript', 'coffee'],
        mimetypes: ['text/x-coffeescript', 'text/coffeescript'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./coffee'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/cpp/cpp.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'c',
        extensions: ['.c', '.h'],
        aliases: ['C', 'c'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./cpp'], resolve_1, reject_1); }); }
    });
    __contribution_1.registerLanguage({
        id: 'cpp',
        extensions: ['.cpp', '.cc', '.cxx', '.hpp', '.hh', '.hxx'],
        aliases: ['C++', 'Cpp', 'cpp'],
        loader: function () { return new Promise(function (resolve_2, reject_2) { require(['./cpp'], resolve_2, reject_2); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/csharp/csharp.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'csharp',
        extensions: ['.cs', '.csx', '.cake'],
        aliases: ['C#', 'csharp'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./csharp'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/csp/csp.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'csp',
        extensions: [],
        aliases: ['CSP', 'csp'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./csp'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/css/css.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'css',
        extensions: ['.css'],
        aliases: ['CSS', 'css'],
        mimetypes: ['text/css'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./css'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/dart/dart.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'dart',
        extensions: ['.dart'],
        aliases: ['Dart', 'dart'],
        mimetypes: ['text/x-dart-source', 'text/x-dart'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./dart'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/dockerfile/dockerfile.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'dockerfile',
        extensions: ['.dockerfile'],
        filenames: ['Dockerfile'],
        aliases: ['Dockerfile'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./dockerfile'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/ecl/ecl.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'ecl',
        extensions: ['.ecl'],
        aliases: ['ECL', 'Ecl', 'ecl'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./ecl'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/elixir/elixir.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'elixir',
        extensions: ['.ex', '.exs'],
        aliases: ['Elixir', 'elixir', 'ex'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./elixir'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/fsharp/fsharp.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'fsharp',
        extensions: ['.fs', '.fsi', '.ml', '.mli', '.fsx', '.fsscript'],
        aliases: ['F#', 'FSharp', 'fsharp'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./fsharp'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/go/go.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'go',
        extensions: ['.go'],
        aliases: ['Go'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./go'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/graphql/graphql.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'graphql',
        extensions: ['.graphql', '.gql'],
        aliases: ['GraphQL', 'graphql', 'gql'],
        mimetypes: ['application/graphql'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./graphql'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/handlebars/handlebars.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'handlebars',
        extensions: ['.handlebars', '.hbs'],
        aliases: ['Handlebars', 'handlebars', 'hbs'],
        mimetypes: ['text/x-handlebars-template'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./handlebars'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/hcl/hcl.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'hcl',
        extensions: ['.tf', '.tfvars', '.hcl'],
        aliases: ['Terraform', 'tf', 'HCL', 'hcl'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./hcl'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/html/html.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'html',
        extensions: ['.html', '.htm', '.shtml', '.xhtml', '.mdoc', '.jsp', '.asp', '.aspx', '.jshtm'],
        aliases: ['HTML', 'htm', 'html', 'xhtml'],
        mimetypes: ['text/html', 'text/x-jshtm', 'text/template', 'text/ng-template'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./html'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/ini/ini.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'ini',
        extensions: ['.ini', '.properties', '.gitconfig'],
        filenames: ['config', '.gitattributes', '.gitconfig', '.editorconfig'],
        aliases: ['Ini', 'ini'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./ini'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/java/java.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'java',
        extensions: ['.java', '.jav'],
        aliases: ['Java', 'java'],
        mimetypes: ['text/x-java-source', 'text/x-java'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./java'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/javascript/javascript.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'javascript',
        extensions: ['.js', '.es6', '.jsx', '.mjs'],
        firstLine: '^#!.*\\bnode',
        filenames: ['jakefile'],
        aliases: ['JavaScript', 'javascript', 'js'],
        mimetypes: ['text/javascript'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./javascript'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/julia/julia.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'julia',
        extensions: ['.jl'],
        aliases: ['julia', 'Julia'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./julia'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/kotlin/kotlin.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'kotlin',
        extensions: ['.kt'],
        aliases: ['Kotlin', 'kotlin'],
        mimetypes: ['text/x-kotlin-source', 'text/x-kotlin'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./kotlin'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/less/less.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'less',
        extensions: ['.less'],
        aliases: ['Less', 'less'],
        mimetypes: ['text/x-less', 'text/less'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./less'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/lexon/lexon.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'lexon',
        extensions: ['.lex'],
        aliases: ['Lexon'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./lexon'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/lua/lua.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'lua',
        extensions: ['.lua'],
        aliases: ['Lua', 'lua'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./lua'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/liquid/liquid.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'liquid',
        extensions: ['.liquid', '.html.liquid'],
        aliases: ['Liquid', 'liquid'],
        mimetypes: ['application/liquid'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./liquid'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/m3/m3.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'm3',
        extensions: ['.m3', '.i3', '.mg', '.ig'],
        aliases: ['Modula-3', 'Modula3', 'modula3', 'm3'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./m3'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/markdown/markdown.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'markdown',
        extensions: ['.md', '.markdown', '.mdown', '.mkdn', '.mkd', '.mdwn', '.mdtxt', '.mdtext'],
        aliases: ['Markdown', 'markdown'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./markdown'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/mips/mips.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'mips',
        extensions: ['.s'],
        aliases: ['MIPS', 'MIPS-V'],
        mimetypes: ['text/x-mips', 'text/mips', 'text/plaintext'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./mips'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/msdax/msdax.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'msdax',
        extensions: ['.dax', '.msdax'],
        aliases: ['DAX', 'MSDAX'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./msdax'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/mysql/mysql.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'mysql',
        extensions: [],
        aliases: ['MySQL', 'mysql'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./mysql'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/objective-c/objective-c.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'objective-c',
        extensions: ['.m'],
        aliases: ['Objective-C'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./objective-c'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/pascal/pascal.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'pascal',
        extensions: ['.pas', '.p', '.pp'],
        aliases: ['Pascal', 'pas'],
        mimetypes: ['text/x-pascal-source', 'text/x-pascal'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./pascal'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/pascaligo/pascaligo.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'pascaligo',
        extensions: ['.ligo'],
        aliases: ['Pascaligo', 'ligo'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./pascaligo'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/perl/perl.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'perl',
        extensions: ['.pl'],
        aliases: ['Perl', 'pl'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./perl'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/pgsql/pgsql.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'pgsql',
        extensions: [],
        aliases: ['PostgreSQL', 'postgres', 'pg', 'postgre'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./pgsql'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/php/php.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'php',
        extensions: ['.php', '.php4', '.php5', '.phtml', '.ctp'],
        aliases: ['PHP', 'php'],
        mimetypes: ['application/x-php'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./php'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/postiats/postiats.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'postiats',
        extensions: ['.dats', '.sats', '.hats'],
        aliases: ['ATS', 'ATS/Postiats'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./postiats'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/powerquery/powerquery.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'powerquery',
        extensions: ['.pq', '.pqm'],
        aliases: ['PQ', 'M', 'Power Query', 'Power Query M'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./powerquery'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/powershell/powershell.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'powershell',
        extensions: ['.ps1', '.psm1', '.psd1'],
        aliases: ['PowerShell', 'powershell', 'ps', 'ps1'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./powershell'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/pug/pug.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'pug',
        extensions: ['.jade', '.pug'],
        aliases: ['Pug', 'Jade', 'jade'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./pug'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/python/python.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'python',
        extensions: ['.py', '.rpy', '.pyw', '.cpy', '.gyp', '.gypi'],
        aliases: ['Python', 'py'],
        firstLine: '^#!/.*\\bpython[0-9.-]*\\b',
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./python'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/qsharp/qsharp.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'qsharp',
        extensions: ['.qs'],
        aliases: ['Q#', 'qsharp'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./qsharp'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/r/r.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'r',
        extensions: ['.r', '.rhistory', '.rmd', '.rprofile', '.rt'],
        aliases: ['R', 'r'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./r'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/razor/razor.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'razor',
        extensions: ['.cshtml'],
        aliases: ['Razor', 'razor'],
        mimetypes: ['text/x-cshtml'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./razor'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/redis/redis.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'redis',
        extensions: ['.redis'],
        aliases: ['redis'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./redis'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/redshift/redshift.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'redshift',
        extensions: [],
        aliases: ['Redshift', 'redshift'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./redshift'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/restructuredtext/restructuredtext.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'restructuredtext',
        extensions: ['.rst'],
        aliases: ['reStructuredText', 'restructuredtext'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./restructuredtext'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/ruby/ruby.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'ruby',
        extensions: ['.rb', '.rbx', '.rjs', '.gemspec', '.pp'],
        filenames: ['rakefile', 'Gemfile'],
        aliases: ['Ruby', 'rb'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./ruby'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/rust/rust.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'rust',
        extensions: ['.rs', '.rlib'],
        aliases: ['Rust', 'rust'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./rust'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/sb/sb.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'sb',
        extensions: ['.sb'],
        aliases: ['Small Basic', 'sb'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./sb'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/scala/scala.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'scala',
        extensions: ['.scala', '.sc', '.sbt'],
        aliases: ['Scala', 'scala', 'SBT', 'Sbt', 'sbt', 'Dotty', 'dotty'],
        mimetypes: ['text/x-scala-source', 'text/x-scala', 'text/x-sbt', 'text/x-dotty'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./scala'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/scheme/scheme.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'scheme',
        extensions: ['.scm', '.ss', '.sch', '.rkt'],
        aliases: ['scheme', 'Scheme'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./scheme'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/scss/scss.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'scss',
        extensions: ['.scss'],
        aliases: ['Sass', 'sass', 'scss'],
        mimetypes: ['text/x-scss', 'text/scss'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./scss'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/shell/shell.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'shell',
        extensions: ['.sh', '.bash'],
        aliases: ['Shell', 'sh'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./shell'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/solidity/solidity.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'sol',
        extensions: ['.sol'],
        aliases: ['sol', 'solidity', 'Solidity'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./solidity'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/sophia/sophia.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'aes',
        extensions: ['.aes'],
        aliases: ['aes', 'sophia', 'Sophia'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./sophia'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/sparql/sparql.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'sparql',
        extensions: ['.rq'],
        aliases: ['sparql', 'SPARQL'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./sparql'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/sql/sql.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'sql',
        extensions: ['.sql'],
        aliases: ['SQL'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./sql'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/st/st.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'st',
        extensions: ['.st', '.iecst', '.iecplc', '.lc3lib'],
        aliases: ['StructuredText', 'scl', 'stl'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./st'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/swift/swift.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'swift',
        aliases: ['Swift', 'swift'],
        extensions: ['.swift'],
        mimetypes: ['text/swift'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./swift'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/systemverilog/systemverilog.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'systemverilog',
        extensions: ['.sv', '.svh'],
        aliases: ['SV', 'sv', 'SystemVerilog', 'systemverilog'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./systemverilog'], resolve_1, reject_1); }); }
    });
    __contribution_1.registerLanguage({
        id: 'verilog',
        extensions: ['.v', '.vh'],
        aliases: ['V', 'v', 'Verilog', 'verilog'],
        loader: function () { return new Promise(function (resolve_2, reject_2) { require(['./systemverilog'], resolve_2, reject_2); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/tcl/tcl.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'tcl',
        extensions: ['.tcl'],
        aliases: ['tcl', 'Tcl', 'tcltk', 'TclTk', 'tcl/tk', 'Tcl/Tk'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./tcl'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/twig/twig.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'twig',
        extensions: ['.twig'],
        aliases: ['Twig', 'twig'],
        mimetypes: ['text/x-twig'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./twig'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/typescript/typescript.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'typescript',
        extensions: ['.ts', '.tsx'],
        aliases: ['TypeScript', 'ts', 'typescript'],
        mimetypes: ['text/typescript'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./typescript'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/vb/vb.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'vb',
        extensions: ['.vb'],
        aliases: ['Visual Basic', 'vb'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./vb'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/xml/xml.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'xml',
        extensions: [
            '.xml',
            '.dtd',
            '.ascx',
            '.csproj',
            '.config',
            '.wxi',
            '.wxl',
            '.wxs',
            '.xaml',
            '.svg',
            '.svgz',
            '.opf',
            '.xsl'
        ],
        firstLine: '(\\<\\?xml.*)|(\\<svg)|(\\<\\!doctype\\s+svg)',
        aliases: ['XML', 'xml'],
        mimetypes: ['text/xml', 'application/xml', 'application/xaml+xml', 'application/xml-dtd'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./xml'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/yaml/yaml.contribution',["require", "exports", "../_.contribution"], function (require, exports, __contribution_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    __contribution_1.registerLanguage({
        id: 'yaml',
        extensions: ['.yaml', '.yml'],
        aliases: ['YAML', 'yaml', 'YML', 'yml'],
        mimetypes: ['application/x-yaml', 'text/x-yaml'],
        loader: function () { return new Promise(function (resolve_1, reject_1) { require(['./yaml'], resolve_1, reject_1); }); }
    });
});

/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
define('vs/basic-languages/monaco.contribution',["require", "exports", "./abap/abap.contribution", "./apex/apex.contribution", "./azcli/azcli.contribution", "./bat/bat.contribution", "./bicep/bicep.contribution", "./cameligo/cameligo.contribution", "./clojure/clojure.contribution", "./coffee/coffee.contribution", "./cpp/cpp.contribution", "./csharp/csharp.contribution", "./csp/csp.contribution", "./css/css.contribution", "./dart/dart.contribution", "./dockerfile/dockerfile.contribution", "./ecl/ecl.contribution", "./elixir/elixir.contribution", "./fsharp/fsharp.contribution", "./go/go.contribution", "./graphql/graphql.contribution", "./handlebars/handlebars.contribution", "./hcl/hcl.contribution", "./html/html.contribution", "./ini/ini.contribution", "./java/java.contribution", "./javascript/javascript.contribution", "./julia/julia.contribution", "./kotlin/kotlin.contribution", "./less/less.contribution", "./lexon/lexon.contribution", "./lua/lua.contribution", "./liquid/liquid.contribution", "./m3/m3.contribution", "./markdown/markdown.contribution", "./mips/mips.contribution", "./msdax/msdax.contribution", "./mysql/mysql.contribution", "./objective-c/objective-c.contribution", "./pascal/pascal.contribution", "./pascaligo/pascaligo.contribution", "./perl/perl.contribution", "./pgsql/pgsql.contribution", "./php/php.contribution", "./postiats/postiats.contribution", "./powerquery/powerquery.contribution", "./powershell/powershell.contribution", "./pug/pug.contribution", "./python/python.contribution", "./qsharp/qsharp.contribution", "./r/r.contribution", "./razor/razor.contribution", "./redis/redis.contribution", "./redshift/redshift.contribution", "./restructuredtext/restructuredtext.contribution", "./ruby/ruby.contribution", "./rust/rust.contribution", "./sb/sb.contribution", "./scala/scala.contribution", "./scheme/scheme.contribution", "./scss/scss.contribution", "./shell/shell.contribution", "./solidity/solidity.contribution", "./sophia/sophia.contribution", "./sparql/sparql.contribution", "./sql/sql.contribution", "./st/st.contribution", "./swift/swift.contribution", "./systemverilog/systemverilog.contribution", "./tcl/tcl.contribution", "./twig/twig.contribution", "./typescript/typescript.contribution", "./vb/vb.contribution", "./xml/xml.contribution", "./yaml/yaml.contribution"], function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
});

